/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.CBOS;
import jalis.comum.ConstantesGerais;
import jalis.comum.TabelaANS;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DetalhamentoErroFaturamento;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.Util;
import jalis.laboratorio.util.faturamento.eletronico.tiss.VersaoTiss;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.DefaultTableCellRenderer;

public class GuiaVirtual
extends JDialog
implements ActionListener,
WindowListener {
    private final int LARGURA_GUIA = 780;
    private final int ALTURA_GUIA = 575;
    private final int ALTURA_LINHA = 26;
    private final int CONSTANTE_LARGURA = 25;
    private final int ALTURA_LINHA_TABELA = 12;
    private final float TAMANHO_FONTE_ROTULO = 8.0f;
    private final float TAMANHO_FONTE_INTERNA = 8.5f;
    private final float TAMANHO_FONTE_CABECALHO = 9.0f;
    private final float TAMANHO_FONTE_AGRUPAMENTO = 9.0f;
    private final float TAMANHO_FONTE_TABELA = 9.0f;
    private final int INSET_TOP_PAINEL = 0;
    private final int INSET_LEFT_PAINEL = 2;
    private final int INSET_BOTTOM_PAINEL = 0;
    private final int INSET_RIGHT_PAINEL = 0;
    private final int INSET_TOP_AGRUPAMENTO = 2;
    private final int INSET_LEFT_AGRUPAMENTO = 3;
    private final int INSET_BOTTOM_AGRUPAMENTO = 0;
    private final int INSET_RIGHT_AGRUPAMENTO = 0;
    private final int INSET_TOP_CAMPOS = 0;
    private final int INSET_LEFT_CAMPOS = 1;
    private final int INSET_BOTTOM_CAMPOS = 0;
    private final int INSET_RIGHT_CAMPOS = 1;
    private final int INSET_TOP_TABELAS = 0;
    private final int INSET_LEFT_TABELAS = 3;
    private final int INSET_BOTTOM_TABELAS = 0;
    private final int INSET_RIGHT_TABELAS = 1;
    private final Color COR_OBRIGATORIOS = Color.BLUE;
    private final Color COR_INCORRETOS = Color.RED;
    public static final int CAMPO_DATA = 0;
    public static final int CAMPO_TABELA = 1;
    public static final int CAMPO_DESCRICAO = 2;
    public static final int CAMPO_QUANTIDADE = 3;
    public static final int CAMPO_VALOR_UNITARIO = 4;
    public static final int CAMPO_OBJETOS = 5;
    public static final int SOLICITADOS_TABELA = 0;
    public static final int SOLICITADOS_COD_PROCEDIMENTO = 1;
    public static final int SOLICITADOS_DESC_PROCEDIMENTO = 2;
    public static final int SOLICITADOS_QTDE_SOLICITADA = 3;
    public static final int SOLICITADOS_QTDE_AUTORIZADA = 4;
    public static final int SOLICITADOS_OBJETOS = 5;
    public static final int EXECUTADOS_DATA = 0;
    public static final int EXECUTADOS_TABELA = 1;
    public static final int EXECUTADOS_COD_PROCEDIMENTO = 2;
    public static final int EXECUTADOS_DESC_PROCEDIMENTO = 3;
    public static final int EXECUTADOS_QUANTIDADE = 4;
    public static final int EXECUTADOS_VALOR_UNITARIO = 5;
    public static final int EXECUTADOS_VALOR_TOTAL = 6;
    public static final int EXECUTADOS_OBJETOS = 7;
    public static final int TIPO_TABELA_SOLICITADOS = 0;
    public static final int TIPO_TABELA_EXECUTADOS = 1;
    private DadosFaturamento requisicaoAux = null;
    private String guiaAux = null;
    private Registro configuracaoAux = null;
    private boolean isOk = false;
    private Campo primeiroCampoIncorreto = null;
    boolean acessoAlterarTodosCampos = false;
    public static CampoTexto registroAns = null;
    public static CampoTexto numeroGuiaPrincipal = null;
    public static CampoTexto dataAutorizacao = null;
    public static CampoTexto senha = null;
    public static CampoTexto validadeSenha = null;
    public static CampoTexto dataEmissaoGuia = null;
    public static CampoTexto guia = null;
    public static CampoTexto numeroCarteirinha = null;
    public static CampoTexto plano = null;
    public static CampoTexto validadeCarteirinha = null;
    public static CampoTexto nome = null;
    public static CampoTexto numeroCartaoNacionalSaude = null;
    public static CampoTexto codigoOperadoraSolicitante = null;
    public static CampoTexto nomeContratadoSolicitante = null;
    public static CampoTexto codigoCnesSolicitante = null;
    public static CampoTexto registroAnsDestino = null;
    public static CampoTexto nomeProfissionalSolicitante = null;
    public static CampoCombo conselhoProfissionalSolicitante = null;
    public static CampoTexto numeroConselhoProfissionalSolicitante = null;
    public static CampoCombo ufProfissionalSolicitante = null;
    public static CampoCombo codigoCBOS = null;
    public static CampoTexto dataHoraSolicitacao = null;
    public static CampoCombo caraterSolicitacao = null;
    public static CampoTexto cid10 = null;
    public static CampoTexto indicacaoClinica = null;
    public static CampoTable procedimentos1 = null;
    public static CampoTexto codigoOperadoraExecutante = null;
    public static CampoTexto nomeContratadoExecutante = null;
    public static CampoTexto ti = null;
    public static CampoTexto logradouroNumeroComplemento = null;
    public static CampoTexto municipio = null;
    public static CampoCombo ufExecutante = null;
    public static CampoTexto codigoIbge = null;
    public static CampoTexto cep = null;
    public static CampoTexto codigoCnesExecutante = null;
    public static CampoTexto codigoOperadoraExecutanteComplementar = null;
    public static CampoTexto nomeProfissionalExecutanteComplementar = null;
    public static CampoCombo conselhoProfissionalExecutante = null;
    public static CampoTexto numeroConselhoExecutante = null;
    public static CampoCombo ufProfissionalExecutante = null;
    public static CampoCombo codigoCbosExecutante = null;
    public static CampoCombo grauParticipacao = null;
    public static CampoCombo tipoAtendimento = null;
    public static CampoCombo indicacaoAcidente = null;
    public static CampoCombo tipoSaida = null;
    public static CampoCombo tipoDoenca = null;
    public static CampoCombo tempoDoenca = null;
    public static CampoTable procedimentos2 = null;
    public static CampoTexto dataAssinaturaProcedimentoSerie = null;
    public static CampoTexto observacao = null;
    public static CampoTexto totalProcedimento = null;
    public static CampoTexto totalTaxasAlugueis = null;
    public static CampoTexto totalMateriais = null;
    public static CampoTexto totalMedicamentos = null;
    public static CampoTexto totalDiarias = null;
    public static CampoTexto totalGasesMedicinais = null;
    public static CampoTexto totalGeralGuia = null;
    public static CampoTexto dataAssinaturaSolicitante = null;
    public static CampoTexto dataAssinaturaResponsavelAutorizacao = null;
    public static CampoTexto dataAssinaturaBeneficiarioResponsavel = null;
    public static CampoTexto dataAssinaturaPrestadorExecutante = null;
    private JPanel panel1 = new JPanel(new GridBagLayout());
    private JPanel panel2 = new JPanel(new GridBagLayout());
    private JPanel panel3 = new JPanel(new GridBagLayout());
    private JPanel panel4 = new JPanel(new GridBagLayout());
    private JPanel panel5 = new JPanel(new GridBagLayout());
    private JPanel panel6 = new JPanel(new GridBagLayout());
    private JPanel panel7 = new JPanel(new GridBagLayout());
    private JPanel panel8 = new JPanel(new GridBagLayout());
    private JPanel panel9 = new JPanel(new GridBagLayout());
    private JPanel panel10 = new JPanel(new GridBagLayout());
    private JPanel panel11 = new JPanel(new GridBagLayout());
    private JPanel panel12 = new JPanel(new GridBagLayout());
    private JPanel panel13 = new JPanel(new GridBagLayout());
    private JPanel panelRodape = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JLabel labelBeneficiario = new JLabel("Dados do Benefici\u00e1rio");
    private JLabel labelContratadoSolicitante = new JLabel("Dados do Contratado Solicitante");
    private JLabel labelSolicitacao = new JLabel("Dados da Solicita\u00e7\u00e3o / Procedimentos e Exames Solicitados");
    private JLabel labelContratadoExecutante = new JLabel("Dados do Contratado Executante");
    private JLabel labelAtendimento = new JLabel("Dados do Atendimento");
    private JButton buttonOk = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private AbstractFaturamentoEletronico faturamentoEletronico = null;
    Registro config = null;

    public GuiaVirtual(Window owner, AbstractFaturamentoEletronico faturamentoEletronico, boolean acessoAlterarTodosCampos, Registro configuracaoEletronico) {
        super(owner);
        this.addWindowListener(this);
        this.faturamentoEletronico = faturamentoEletronico;
        this.acessoAlterarTodosCampos = acessoAlterarTodosCampos;
        this.configuracaoAux = configuracaoEletronico;
        registroAns = new CampoTexto("1-Registro ANS", 6, 3, 2.6f);
        numeroGuiaPrincipal = new CampoTexto("3-N\u00b0 Guia Principal (Pac. Internado)", 4.8f);
        dataAutorizacao = new CampoTexto("4-Data Autoriza\u00e7\u00e3o", 10, 4, 2.9f);
        senha = new CampoTexto("5-Senha", 30, 3, 4.2f);
        validadeSenha = new CampoTexto("6-Validade Senha", 10, 4, 2.6f);
        dataEmissaoGuia = new CampoTexto("7-Data Emiss\u00e3o Guia", 10, 4, 3.4f);
        guia = new CampoTexto("2-Guia", 1.0f);
        numeroCarteirinha = new CampoTexto("8-N\u00famero Carteirinha", 20, 3, 4.1f);
        plano = new CampoTexto("9-Plano", 40, 3, 5.2f);
        validadeCarteirinha = new CampoTexto("10-Val. Carteirinha", 10, 4, 2.8f);
        nome = new CampoTexto("11-Nome", 70, 3, 9.4f);
        numeroCartaoNacionalSaude = new CampoTexto("12-N\u00famero CNS", 15, 3, 1.0f);
        codigoOperadoraSolicitante = new CampoTexto("13-C\u00f3digo Operadora/CNPJ/CPF", 20, 1, 5.1f);
        nomeContratadoSolicitante = new CampoTexto("14-Nome do Contratado", 70, 3, 12.0f);
        codigoCnesSolicitante = new CampoTexto("15-C\u00f3digo CNES", 7, 1, 2.0f);
        registroAnsDestino = new CampoTexto("Registro ANS (destino)", 7, 1, 3.2f);
        nomeProfissionalSolicitante = new CampoTexto("16-Nome do Profissional Solicitante", 70, 3, 14.0f);
        conselhoProfissionalSolicitante = new CampoCombo("17-Conselho Prof.", ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.CONSELHOS), 3.3f);
        numeroConselhoProfissionalSolicitante = new CampoTexto("18-N\u00ba do Conselho", 15, 1, 3.3f);
        ufProfissionalSolicitante = new CampoCombo("19-UF", ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.ESTADOS), 1.3f);
        VersaoTiss versaoTiss = VersaoTiss.getVersaoPorDescricao(this.configuracaoAux.getString("versaoArquivo"));
        HashMap<String, String> lista = new HashMap<String, String>();
        Util.atualizaCodigoCbo(lista, versaoTiss);
        ArrayList teste = new ArrayList();
        lista.forEach((k, v) -> {
            StringBuilder stb = new StringBuilder((String)v);
            stb.insert(v.length() - 2, ".");
            teste.add(stb.toString());
        });
        codigoCBOS = new CampoCombo("20-C\u00f3digo CBO-S", teste.toArray(), 1.0f);
        dataHoraSolicitacao = new CampoTexto("21-Data/Hora Solicita\u00e7\u00e3o", 16, 14, 3.8f);
        caraterSolicitacao = new CampoCombo("22-Car\u00e1ter da Solicita\u00e7\u00e3o", new Object[]{CaraterSolicitacao.ELETIVO, CaraterSolicitacao.URGENCIA_EMERGENCIA}, 4.5f);
        cid10 = new CampoTexto("23-CID 10", 5, 1, 1.6f);
        indicacaoClinica = new CampoTexto("24-Indica\u00e7\u00e3o Cl\u00ednica (Obrigat\u00f3rio se Pequena Cirurgia, Terapia, Consulta Referenciada e Alto Custo)", 500, 3, 1.0f);
        procedimentos1 = new CampoTable(new String[]{"25-Tabela", "26-C\u00f3d. Procedimento", "27-Descri\u00e7\u00e3o", "28-Qtde. Solic.", "29-Qtde. Aut."}, new int[]{190, 105, 0, 70, 70}, new Class[]{String.class, String.class, String.class, Integer.class, Integer.class}, new int[]{0, 1}, 0, 1.0f);
        codigoOperadoraExecutante = new CampoTexto("30-C\u00f3d. Operadora/CNPJ", 20, 3, 4.1f);
        nomeContratadoExecutante = new CampoTexto("31-Nome do Contratado", 70, 3, 6.1f);
        ti = new CampoTexto("32-T.I.", 70, 3, 1.2f);
        logradouroNumeroComplemento = new CampoTexto("33,34,35-Logradouro-N\u00ba-Compl.", 500, 3, 4.8f);
        municipio = new CampoTexto("36-Munic\u00edpio", 40, 3, 3.3f);
        ufExecutante = new CampoCombo("37-UF", ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.ESTADOS), 1.3f);
        codigoIbge = new CampoTexto("38-C\u00f3d. IBGE", 7, 1, 1.9f);
        cep = new CampoTexto("39-CEP", 8, 9, 1.0f);
        codigoCnesExecutante = new CampoTexto("40-C\u00f3d. CNES", 7, 1, 2.2f);
        codigoOperadoraExecutanteComplementar = new CampoTexto("40a-C\u00f3d. Oper./CPF Exec. Comp.", 20, 1, 4.8f);
        nomeProfissionalExecutanteComplementar = new CampoTexto("41-Nome Prof. Executante Comp.", 70, 3, 5.6f);
        conselhoProfissionalExecutante = new CampoCombo("42-Conselho Prof.", ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.CONSELHOS), 2.7f);
        numeroConselhoExecutante = new CampoTexto("43-N\u00ba do Conselho", 15, 1, 3.1f);
        ufProfissionalExecutante = new CampoCombo("44-UF", ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.ESTADOS), 1.3f);
        codigoCbosExecutante = new CampoCombo("45-C\u00f3d. CBOS", CBOS.getCBOS(versaoTiss), 2.2f);
        grauParticipacao = new CampoCombo("45a-Grau Particip.", new Object[]{GrauParticipacao.CIRURGIAO, GrauParticipacao.PRIMEIRO_AUXILIAR, GrauParticipacao.SEGUNDO_AUXILIAR, GrauParticipacao.TERCEIRO_AUXILIAR, GrauParticipacao.QUARTO_AUXILIAR, GrauParticipacao.INSTRUMENTADOR, GrauParticipacao.ANESTESISTA, GrauParticipacao.AUXILIAR_ANESTESIA, GrauParticipacao.CONSULTOR, GrauParticipacao.PERFUSIONISTA, GrauParticipacao.PEDIATRA, GrauParticipacao.AUXILIAR_SADT, GrauParticipacao.CLINICO, GrauParticipacao.NAO_INFORMADO}, 1.0f);
        tipoAtendimento = new CampoCombo("46-Tipo de Atendimento", new Object[]{TipoAtendimento.REMICAO, TipoAtendimento.PEQUENA_CIRURGIA, TipoAtendimento.TERAPIAS, TipoAtendimento.CONSULTA, TipoAtendimento.EXAME, TipoAtendimento.ATENDIMENTO_DOMICILIAR, TipoAtendimento.SADT_INTERNADO, TipoAtendimento.QUIMIOTERAPIA, TipoAtendimento.RADIOTERAPIA, TipoAtendimento.TRS}, 11.3f);
        indicacaoAcidente = new CampoCombo("47-Indica\u00e7\u00e3o de Acidente", new Object[]{IndicacaoAcidente.ACIDENTE_DOENCA_RELACIONADA_TRABALHO, IndicacaoAcidente.TRANSITO, IndicacaoAcidente.OUTRO, IndicacaoAcidente.NAO_INFORMADO}, 6.8f);
        tipoSaida = new CampoCombo("48-Tipo de Sa\u00edda", new Object[]{TipoSaida.RETORNO, TipoSaida.RETORNO_SADT, TipoSaida.REFERENCIA, TipoSaida.INTERNACAO}, 1.0f);
        tipoDoenca = new CampoCombo("49-Tipo de Doen\u00e7a", new Object[]{TipoDoenca.AGUDA, TipoDoenca.CRONICA, TipoDoenca.NAO_INFORMADO}, 3.3f);
        tempoDoenca = new CampoCombo("50-Tempo de Doen\u00e7a", new Object[]{TempoDoenca.ANOS, TempoDoenca.MESES, TempoDoenca.DIAS, TempoDoenca.NAO_INFORMADO}, 3.3f);
        procedimentos2 = new CampoTable(new String[]{"51-Data", "54-Tabela", "55-C\u00f3d. Procedimento", "56-Descri\u00e7\u00e3o", "57-Qtde.", "61-Valor Unit\u00e1rio", "62-Valor Total"}, new int[]{65, 190, 105, 0, 45, 80, 70}, new Class[]{Date.class, Tabela.class, String.class, String.class, Integer.class, String.class, String.class}, new int[]{0, 1, 2}, 1, 1.0f);
        dataAssinaturaProcedimentoSerie = new CampoTexto("63-Data e Assinatura de Procedimentos em S\u00e9rie", 0, 1, 1.0f);
        observacao = new CampoTexto("64-Observa\u00e7\u00e3o", 240, 3, 1.0f);
        totalProcedimento = new CampoTexto("65-Tot. Procedimento", 10, 2, 3.0f);
        totalTaxasAlugueis = new CampoTexto("66-Tot. Tx. e Alugueis", 10, 2, 3.1f);
        totalMateriais = new CampoTexto("67-Total Materiais", 10, 2, 3.1f);
        totalMedicamentos = new CampoTexto("68-Total Medicamentos", 10, 2, 3.6f);
        totalDiarias = new CampoTexto("69-Total Di\u00e1rias", 10, 2, 2.9f);
        totalGasesMedicinais = new CampoTexto("70-Total Gases Medicinais", 10, 2, 4.2f);
        totalGeralGuia = new CampoTexto("71-Total Geral da Guia", 10, 2, 1.0f);
        dataAssinaturaSolicitante = new CampoTexto("86-Data e Assinatura do Solicitante", 0, 1, 5.8f);
        dataAssinaturaResponsavelAutorizacao = new CampoTexto("87-Data e Assinatura Respons. Autoriza\u00e7\u00e3o", 0, 1, 6.4f);
        dataAssinaturaBeneficiarioResponsavel = new CampoTexto("88-Data e Assinatura Benefic. Respons\u00e1vel", 0, 1, 6.3f);
        dataAssinaturaPrestadorExecutante = new CampoTexto("89-Data e Assinatura Prestador Executante", 0, 1, 1.0f);
        this.setSize(790, 585);
        this.setTitle("Guia Virtual");
        this.setModal(true);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
        this.montaGuia();
        Funcoes.montaEnter((JComponent)this.getContentPane());
    }

    private void montaGuia() {
        this.setLayout(new GridBagLayout());
        this.panel1.setPreferredSize(new Dimension(780, 26));
        this.panel1.setMinimumSize(new Dimension(780, 26));
        this.panel2.setPreferredSize(new Dimension(780, 26));
        this.panel2.setMinimumSize(new Dimension(780, 26));
        this.panel3.setPreferredSize(new Dimension(780, 26));
        this.panel3.setMinimumSize(new Dimension(780, 26));
        this.panel4.setPreferredSize(new Dimension(780, 26));
        this.panel4.setMinimumSize(new Dimension(780, 26));
        this.panel5.setPreferredSize(new Dimension(780, 26));
        this.panel5.setMinimumSize(new Dimension(780, 26));
        this.panel6.setPreferredSize(new Dimension(780, 26));
        this.panel6.setMinimumSize(new Dimension(780, 26));
        this.panel7.setPreferredSize(new Dimension(780, 26));
        this.panel7.setMinimumSize(new Dimension(780, 26));
        this.panel8.setPreferredSize(new Dimension(780, 26));
        this.panel8.setMinimumSize(new Dimension(780, 26));
        this.panel9.setPreferredSize(new Dimension(780, 26));
        this.panel9.setMinimumSize(new Dimension(780, 26));
        this.panel10.setPreferredSize(new Dimension(780, 26));
        this.panel10.setMinimumSize(new Dimension(780, 26));
        this.panel11.setPreferredSize(new Dimension(780, 26));
        this.panel11.setMinimumSize(new Dimension(780, 26));
        this.panel12.setPreferredSize(new Dimension(780, 26));
        this.panel12.setMinimumSize(new Dimension(780, 26));
        this.panel13.setPreferredSize(new Dimension(780, 26));
        this.panel13.setMinimumSize(new Dimension(780, 26));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.panel1, c);
        ++c.gridy;
        c.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.labelBeneficiario, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.panel2, c);
        ++c.gridy;
        c.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.labelContratadoSolicitante, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.panel3, c);
        ++c.gridy;
        this.add((Component)this.panel4, c);
        ++c.gridy;
        c.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.labelSolicitacao, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.panel5, c);
        ++c.gridy;
        c.insets = new Insets(0, 3, 0, 1);
        this.add((Component)procedimentos1, c);
        ++c.gridy;
        c.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.labelContratadoExecutante, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.panel6, c);
        ++c.gridy;
        this.add((Component)this.panel7, c);
        ++c.gridy;
        c.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.labelAtendimento, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.panel8, c);
        ++c.gridy;
        this.add((Component)this.panel9, c);
        ++c.gridy;
        c.insets = new Insets(0, 3, 0, 1);
        this.add((Component)procedimentos2, c);
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.panel10, c);
        ++c.gridy;
        this.add((Component)this.panel11, c);
        ++c.gridy;
        this.add((Component)this.panel12, c);
        ++c.gridy;
        this.add((Component)this.panel13, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.panelRodape, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panelRodape.add((Component)this.getPanelLegenda(), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelRodape.add((Component)new JLabel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelRodape.add((Component)this.panelBotoes, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel1.add((Component)registroAns, c);
        ++c.gridx;
        this.panel1.add((Component)numeroGuiaPrincipal, c);
        ++c.gridx;
        this.panel1.add((Component)dataAutorizacao, c);
        ++c.gridx;
        this.panel1.add((Component)senha, c);
        ++c.gridx;
        this.panel1.add((Component)validadeSenha, c);
        ++c.gridx;
        this.panel1.add((Component)dataEmissaoGuia, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel1.add((Component)guia, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel2.add((Component)numeroCarteirinha, c);
        ++c.gridx;
        this.panel2.add((Component)plano, c);
        ++c.gridx;
        this.panel2.add((Component)validadeCarteirinha, c);
        ++c.gridx;
        this.panel2.add((Component)nome, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel2.add((Component)numeroCartaoNacionalSaude, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel3.add((Component)codigoOperadoraSolicitante, c);
        ++c.gridx;
        this.panel3.add((Component)nomeContratadoSolicitante, c);
        ++c.gridx;
        this.panel3.add((Component)registroAnsDestino, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel3.add((Component)codigoCnesSolicitante, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel4.add((Component)nomeProfissionalSolicitante, c);
        ++c.gridx;
        this.panel4.add((Component)conselhoProfissionalSolicitante, c);
        ++c.gridx;
        this.panel4.add((Component)numeroConselhoProfissionalSolicitante, c);
        ++c.gridx;
        this.panel4.add((Component)ufProfissionalSolicitante, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel4.add((Component)codigoCBOS, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel5.add((Component)dataHoraSolicitacao, c);
        ++c.gridx;
        this.panel5.add((Component)caraterSolicitacao, c);
        ++c.gridx;
        this.panel5.add((Component)cid10, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel5.add((Component)indicacaoClinica, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel6.add((Component)codigoOperadoraExecutante, c);
        ++c.gridx;
        this.panel6.add((Component)nomeContratadoExecutante, c);
        ++c.gridx;
        this.panel6.add((Component)ti, c);
        ++c.gridx;
        this.panel6.add((Component)logradouroNumeroComplemento, c);
        ++c.gridx;
        this.panel6.add((Component)municipio, c);
        ++c.gridx;
        this.panel6.add((Component)ufExecutante, c);
        ++c.gridx;
        this.panel6.add((Component)codigoIbge, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel6.add((Component)cep, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel7.add((Component)codigoCnesExecutante, c);
        ++c.gridx;
        this.panel7.add((Component)codigoOperadoraExecutanteComplementar, c);
        ++c.gridx;
        this.panel7.add((Component)nomeProfissionalExecutanteComplementar, c);
        ++c.gridx;
        this.panel7.add((Component)conselhoProfissionalExecutante, c);
        ++c.gridx;
        this.panel7.add((Component)numeroConselhoExecutante, c);
        ++c.gridx;
        this.panel7.add((Component)ufProfissionalExecutante, c);
        ++c.gridx;
        this.panel7.add((Component)codigoCbosExecutante, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel7.add((Component)grauParticipacao, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        this.panel8.add((Component)tipoAtendimento, c);
        ++c.gridx;
        this.panel8.add((Component)indicacaoAcidente, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel8.add((Component)tipoSaida, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel9.add((Component)tipoDoenca, c);
        ++c.gridx;
        this.panel9.add((Component)tempoDoenca, c);
        c.fill = 2;
        c.weightx = 1.0;
        this.panel9.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel10.add((Component)dataAssinaturaProcedimentoSerie, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel11.add((Component)observacao, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel12.add((Component)totalProcedimento, c);
        ++c.gridx;
        this.panel12.add((Component)totalTaxasAlugueis, c);
        ++c.gridx;
        this.panel12.add((Component)totalMateriais, c);
        ++c.gridx;
        this.panel12.add((Component)totalMedicamentos, c);
        ++c.gridx;
        this.panel12.add((Component)totalDiarias, c);
        ++c.gridx;
        this.panel12.add((Component)totalGasesMedicinais, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel12.add((Component)totalGeralGuia, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.panel13.add((Component)dataAssinaturaSolicitante, c);
        ++c.gridx;
        this.panel13.add((Component)dataAssinaturaResponsavelAutorizacao, c);
        ++c.gridx;
        this.panel13.add((Component)dataAssinaturaBeneficiarioResponsavel, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panel13.add((Component)dataAssinaturaPrestadorExecutante, c);
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonOk.setMnemonic('O');
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.setMnemonic('C');
        this.buttonCancelar.addActionListener(this);
        this.inicializaCamposFixos();
        this.controlaCampos();
    }

    private void inicializaCamposFixos() {
        this.labelBeneficiario.setFont(this.labelBeneficiario.getFont().deriveFont(9.0f));
        this.labelContratadoSolicitante.setFont(this.labelContratadoSolicitante.getFont().deriveFont(9.0f));
        this.labelSolicitacao.setFont(this.labelSolicitacao.getFont().deriveFont(9.0f));
        this.labelContratadoExecutante.setFont(this.labelContratadoExecutante.getFont().deriveFont(9.0f));
        this.labelAtendimento.setFont(this.labelAtendimento.getFont().deriveFont(9.0f));
        caraterSolicitacao.setValor((Object)CaraterSolicitacao.ELETIVO);
        grauParticipacao.setValor((Object)GrauParticipacao.NAO_INFORMADO);
        indicacaoAcidente.setValor((Object)IndicacaoAcidente.NAO_INFORMADO);
        tipoDoenca.setValor((Object)TipoDoenca.NAO_INFORMADO);
        tempoDoenca.setValor((Object)TempoDoenca.NAO_INFORMADO);
        ti.setValor("Jalis");
        totalTaxasAlugueis.setValor("0");
        totalMedicamentos.setValor("0");
        totalDiarias.setValor("0");
        totalGasesMedicinais.setValor("0");
        totalMateriais.setValor("0");
        conselhoProfissionalSolicitante.setValor(" ");
        conselhoProfissionalExecutante.setValor(" ");
        ufProfissionalSolicitante.setValor(" ");
        ufExecutante.setValor(" ");
        ufProfissionalExecutante.setValor(" ");
        codigoCBOS.setValor("0000.00");
        codigoCbosExecutante.setValor("0000.00");
    }

    private void controlaCampos() {
        if (!this.acessoAlterarTodosCampos) {
            registroAns.setEnabled(false);
            numeroGuiaPrincipal.setEnabled(false);
            dataAutorizacao.setEnabled(false);
            senha.setEnabled(false);
            validadeSenha.setEnabled(false);
            dataEmissaoGuia.setEnabled(false);
            guia.setEnabled(false);
            numeroCarteirinha.setEnabled(false);
            plano.setEnabled(false);
            validadeCarteirinha.setEnabled(false);
            codigoOperadoraSolicitante.setEnabled(false);
            registroAnsDestino.setEnabled(false);
            nomeProfissionalSolicitante.setEnabled(false);
            codigoCBOS.setEnabled(false);
            dataHoraSolicitacao.setEnabled(false);
            cid10.setEnabled(false);
            codigoOperadoraExecutante.setEnabled(false);
            codigoCnesExecutante.setEnabled(false);
        }
        nome.setEnabled(false);
        nomeContratadoSolicitante.setEnabled(false);
        nomeContratadoExecutante.setEnabled(false);
        conselhoProfissionalSolicitante.setEnabled(false);
        numeroConselhoProfissionalSolicitante.setEnabled(false);
        ufProfissionalSolicitante.setEnabled(false);
        numeroCartaoNacionalSaude.setEnabled(false);
        codigoCnesSolicitante.setEnabled(false);
        indicacaoClinica.setEnabled(false);
        logradouroNumeroComplemento.setEnabled(false);
        municipio.setEnabled(false);
        ufExecutante.setEnabled(false);
        codigoIbge.setEnabled(false);
        cep.setEnabled(false);
        codigoOperadoraExecutanteComplementar.setEnabled(false);
        nomeProfissionalExecutanteComplementar.setEnabled(false);
        conselhoProfissionalExecutante.setEnabled(false);
        numeroConselhoExecutante.setEnabled(false);
        ufProfissionalExecutante.setEnabled(false);
        codigoCbosExecutante.setEnabled(false);
        grauParticipacao.setEnabled(false);
        observacao.setEnabled(false);
        totalMateriais.setEnabled(false);
        ti.setEnabled(false);
        caraterSolicitacao.setEnabled(false);
        grauParticipacao.setEnabled(false);
        tipoAtendimento.setEnabled(false);
        indicacaoAcidente.setEnabled(false);
        tipoSaida.setEnabled(false);
        tipoDoenca.setEnabled(false);
        tempoDoenca.setEnabled(false);
        dataAssinaturaProcedimentoSerie.setEnabled(false);
        dataAssinaturaSolicitante.setEnabled(false);
        dataAssinaturaResponsavelAutorizacao.setEnabled(false);
        dataAssinaturaBeneficiarioResponsavel.setEnabled(false);
        dataAssinaturaPrestadorExecutante.setEnabled(false);
        totalProcedimento.setEnabled(false);
        totalTaxasAlugueis.setEnabled(false);
        totalMedicamentos.setEnabled(false);
        totalDiarias.setEnabled(false);
        totalGasesMedicinais.setEnabled(false);
        totalGeralGuia.setEnabled(false);
    }

    public void setCamposObrigatorios(ArrayList<Campo> campos, int[] colunasObrigatoriasSolicitados, int[] colunasObrigatoriasExecutados) {
        if (campos != null) {
            for (int i = 0; i < campos.size(); ++i) {
                Campo campo = campos.get(i);
                if (campo == null) continue;
                campo.setObrigatorio(true);
            }
        }
        if (colunasObrigatoriasSolicitados != null && colunasObrigatoriasSolicitados.length > 0) {
            GuiaVirtual.procedimentos1.setColunasObrigatorias(colunasObrigatoriasSolicitados);
        }
        if (colunasObrigatoriasExecutados != null && colunasObrigatoriasExecutados.length > 0) {
            GuiaVirtual.procedimentos2.setColunasObrigatorias(colunasObrigatoriasExecutados);
        }
    }

    public void preencheValores(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
        this.requisicaoAux = requisicao;
        this.guiaAux = guia;
        this.configuracaoAux = configuracaoEletronico;
        this.faturamentoEletronico.preencheValoresCampos(this.requisicaoAux, configuracaoEletronico, guia);
        this.faturamentoEletronico.preencheValoresTabelas(this.requisicaoAux, guia);
    }

    public void setCamposIncorretos(ArrayList<AbstractFaturamentoEletronico.ErroCampo> campos, ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasSolicitados, ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasExecutados) {
        this.limpaCamposIncorretos(this.getContentPane());
        if (campos != null) {
            for (int i = 0; i < campos.size(); ++i) {
                Campo comp = campos.get(i).getCampo();
                if (comp == null || !comp.isObrigatorio) continue;
                comp.setIncorreto(true);
                DetalhamentoErroFaturamento erro = campos.get((int)i).erro;
                if (erro != null) {
                    comp.setToolTipText(erro.toString());
                }
                if (this.primeiroCampoIncorreto != null) {
                    if (comp.getLocation().y < this.primeiroCampoIncorreto.getLocation().y && comp.getLocation().x < this.primeiroCampoIncorreto.getLocation().x) {
                        this.primeiroCampoIncorreto = comp;
                    }
                } else {
                    this.primeiroCampoIncorreto = comp;
                }
                if (this.acessoAlterarTodosCampos) continue;
                comp.setEnabled(true);
            }
        }
        procedimentos1.setColunasIncorretas(colunasSolicitados);
        procedimentos1.repaint();
        procedimentos2.setColunasIncorretas(colunasExecutados);
        procedimentos2.repaint();
    }

    private void limpaCamposIncorretos(Container container) {
        Component[] componentes = container.getComponents();
        if (componentes != null) {
            for (int i = 0; i < componentes.length; ++i) {
                Component aux = componentes[i];
                if (aux instanceof Campo) {
                    Campo comp = (Campo)aux;
                    if (!comp.isObrigatorio) continue;
                    comp.setIncorreto(false);
                    continue;
                }
                if (!(aux instanceof Container)) continue;
                this.limpaCamposIncorretos((Container)aux);
            }
        }
    }

    public boolean isOk() {
        return this.isOk;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOk) {
            this.faturamentoEletronico.getValoresPreenchidos(this.requisicaoAux, procedimentos2.getListaExames(), this.configuracaoAux);
            this.isOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCancelar) {
            this.isOk = false;
            this.setVisible(false);
        }
    }

    private JPanel getPanelLegenda() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel panelLegenda = new JPanel();
        panelLegenda.setPreferredSize(new Dimension(10, 10));
        panelLegenda.setBackground(this.COR_OBRIGATORIOS);
        panelLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel.add((Component)panelLegenda, c);
        JLabel labelLegenda = new JLabel("Campo obrigat\u00f3rio");
        Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        ++c.gridx;
        panel.add((Component)labelLegenda, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 1);
        panelLegenda = new JPanel();
        panelLegenda.setPreferredSize(new Dimension(10, 10));
        panelLegenda.setBackground(this.COR_INCORRETOS);
        panelLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel.add((Component)panelLegenda, c);
        labelLegenda = new JLabel("Campo incorreto");
        font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)labelLegenda, c);
        return panel;
    }

    public DadosFaturamento getRequisicao() {
        return this.requisicaoAux;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.primeiroCampoIncorreto != null) {
            ScreenUtil.requisitarFoco(this.primeiroCampoIncorreto);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class CampoTable
    extends JPanel {
        private ModeloGridTable modelo = null;
        private JTable table = null;
        private JScrollPane scroll = null;
        private float proporcaoLargura = 0.0f;
        private int[] colunasObrigatorias = null;
        private int[] colunasEditaveis = null;
        private ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasIncorretas = null;
        private Border bordaOriginal = new JLabel().getBorder();
        private int tipoTabela = -1;

        public CampoTable(String[] colunas, int[] tamanhoColunas, Class[] tipoColunas, final int[] colunasEditaveis, final int tipoTabela, float proporcaoLargura) {
            this.proporcaoLargura = proporcaoLargura;
            this.tipoTabela = tipoTabela;
            this.colunasEditaveis = colunasEditaveis;
            this.modelo = new ModeloGridTable(colunas){

                public Class getColumnClass(int i) {
                    return Object.class;
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    if (colunasEditaveis != null) {
                        for (int i = 0; i < colunasEditaveis.length; ++i) {
                            if (colunasEditaveis[i] != columnIndex) continue;
                            if (GuiaVirtual.this.acessoAlterarTodosCampos) {
                                return true;
                            }
                            if (CampoTable.this.colunasIncorretas == null) continue;
                            for (int j = 0; j < CampoTable.this.colunasIncorretas.size(); ++j) {
                                AbstractFaturamentoEletronico.ErroExame erroExame = (AbstractFaturamentoEletronico.ErroExame)CampoTable.this.colunasIncorretas.get(j);
                                if (erroExame == null || erroExame.coluna != columnIndex) continue;
                                DadosExameFaturamento[] exames = null;
                                exames = tipoTabela == 0 ? (DadosExameFaturamento[])procedimentos1.modelo.getValueAt(rowIndex, 5) : (DadosExameFaturamento[])procedimentos2.modelo.getValueAt(rowIndex, 7);
                                if (exames == null) continue;
                                for (int k = 0; k < exames.length; ++k) {
                                    if (!exames[k].getCodigoExame().equalsIgnoreCase(erroExame.exame.getCodigoExame()) || exames[k].getCodigoMaterial() != erroExame.exame.getCodigoMaterial()) continue;
                                    return true;
                                }
                            }
                        }
                        return false;
                    }
                    return false;
                }
            };
            this.modelo.addTableModelListener(new ListenerModelo());
            this.table = new JTable(this.modelo);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setRowHeight(12);
            this.table.getSelectionModel().setSelectionMode(0);
            this.table.setRowSelectionAllowed(false);
            this.table.setCellSelectionEnabled(true);
            this.scroll = new JScrollPane(this.table);
            RendererTabela renderer = new RendererTabela();
            this.table.setDefaultRenderer(Object.class, renderer);
            this.table.setDefaultRenderer(String.class, renderer);
            this.table.setDefaultRenderer(Integer.class, renderer);
            this.table.setDefaultRenderer(Date.class, renderer);
            this.table.getTableHeader().setFont(this.table.getTableHeader().getFont().deriveFont(9.0f));
            this.modelo.setColumnSize(tamanhoColunas, this.table);
            if (tipoTabela == 1) {
                this.table.getColumnModel().getColumn(0).setCellEditor(new EditorData());
                this.table.getColumnModel().getColumn(1).setCellEditor(new EditorTabelaAns((Object[])TabelaANS.TiposTabela.getTipos()));
                this.table.getColumnModel().getColumn(2).setCellEditor(new EditorProcedimento());
            } else {
                this.table.getColumnModel().getColumn(0).setCellEditor(new EditorTabelaAns((Object[])TabelaANS.TiposTabela.getTipos()));
                this.table.getColumnModel().getColumn(1).setCellEditor(new EditorProcedimento());
            }
            this.montaCampo();
        }

        public void clear() {
            if (this.modelo != null) {
                this.modelo.clear();
            }
        }

        private void setColunasObrigatorias(int[] colunasObrigatorias) {
            if (colunasObrigatorias != null) {
                for (int i = 0; i < colunasObrigatorias.length; ++i) {
                    this.table.getColumnModel().getColumn(colunasObrigatorias[i]).setHeaderRenderer(new RendererObrigatorio());
                }
            }
        }

        public int[] getColunasObrigatorias() {
            return this.colunasObrigatorias;
        }

        private void montaCampo() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.scroll, "Center");
            this.setPreferredSize(new Dimension((int)(this.proporcaoLargura * 780.0f / 25.0f), 52));
            this.setMinimumSize(new Dimension((int)(this.proporcaoLargura * 780.0f / 25.0f), 52));
        }

        public void addLinha(Object[] linha) {
            this.modelo.addLine(linha);
        }

        public int getRowCount() {
            return this.modelo.getRowCount();
        }

        public HashMap<String, Object> getLineAt(int line) {
            return this.modelo.getLine(line);
        }

        public void setColunasIncorretas(ArrayList<AbstractFaturamentoEletronico.ErroExame> colunasIncorretas) {
            this.colunasIncorretas = colunasIncorretas;
        }

        public ArrayList<DadosExameFaturamento> getListaExames() {
            int coluna;
            int n = coluna = this.tipoTabela == 0 ? 5 : 7;
            if (this.modelo != null) {
                ArrayList<DadosExameFaturamento> listaExames = new ArrayList<DadosExameFaturamento>();
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    DadosExameFaturamento[] exames = (DadosExameFaturamento[])this.modelo.getValueAt(i, coluna);
                    if (exames == null) continue;
                    for (int j = 0; j < exames.length; ++j) {
                        listaExames.add(exames[j]);
                    }
                }
                if (listaExames.size() > 0) {
                    return listaExames;
                }
                return null;
            }
            return null;
        }

        class ListenerModelo
        implements TableModelListener {
            ListenerModelo() {
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0 && e.getSource() instanceof ModeloGridTable && e.getFirstRow() >= 0 && e.getColumn() >= 0) {
                    ModeloGridTable modelo = (ModeloGridTable)e.getSource();
                    DadosExameFaturamento[] exames = (DadosExameFaturamento[])modelo.getValueAt(e.getFirstRow(), CampoTable.this.tipoTabela == 0 ? 5 : 7);
                    if (modelo != null && exames != null && exames.length > 0) {
                        if (CampoTable.this.tipoTabela == 1 && e.getColumn() == 0) {
                            String dataAux = (String)modelo.getValueAt(e.getFirstRow(), e.getColumn());
                            if (Funcoes.verificaData(dataAux)) {
                                Date data = Funcoes.getData("dd/MM/yyyy", dataAux);
                                for (int i = 0; i < exames.length; ++i) {
                                    DadosExameFaturamento exame = exames[i];
                                    exame.setDataExame(data);
                                }
                            } else {
                                Funcoes.mensagem(GuiaVirtual.this, "Data inv\u00e1lida.", 2);
                            }
                        } else if (CampoTable.this.tipoTabela == 0 && e.getColumn() == 0 || CampoTable.this.tipoTabela == 1 && e.getColumn() == 1) {
                            TabelaANS.TiposTabela tabela = (TabelaANS.TiposTabela)((Object)modelo.getValueAt(e.getFirstRow(), e.getColumn()));
                            GuiaVirtual.this.requisicaoAux.setTipoTabela(tabela);
                        } else if (CampoTable.this.tipoTabela == 0 && e.getColumn() == 1 || CampoTable.this.tipoTabela == 1 && e.getColumn() == 2) {
                            String amb = (String)modelo.getValueAt(e.getFirstRow(), e.getColumn());
                            for (int i = 0; i < exames.length; ++i) {
                                DadosExameFaturamento exame = exames[i];
                                exame.setCodigoAMB(amb.substring(0, amb.length() < 11 ? amb.length() : 11));
                            }
                        }
                        ArrayList<DadosFaturamento> lista = new ArrayList<DadosFaturamento>();
                        lista.add(GuiaVirtual.this.requisicaoAux);
                        GuiaVirtual.this.faturamentoEletronico.verificaErrosFatura(lista, GuiaVirtual.this.configuracaoAux);
                        GuiaVirtual.this.faturamentoEletronico.preencheValoresTabelas(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.guiaAux);
                        GuiaVirtual.this.setCamposIncorretos(GuiaVirtual.this.faturamentoEletronico.getCamposIncorretos(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.guiaAux), GuiaVirtual.this.faturamentoEletronico.getColunasIncorretasSolicitados(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.guiaAux), GuiaVirtual.this.faturamentoEletronico.getColunasIncorretasExecutados(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.guiaAux));
                    }
                }
            }
        }

        class EditorProcedimento
        extends DefaultCellEditor {
            public EditorProcedimento() {
                super(new TTextField());
                TTextField text = (TTextField)this.getComponent();
                text.setFont(CampoTable.this.getFont().deriveFont(9.0f));
                text.setBorder(null);
            }
        }

        class EditorData
        extends DefaultCellEditor {
            public EditorData() {
                super(new TTextField(12, 4));
                TTextField text = (TTextField)this.getComponent();
                text.setFont(CampoTable.this.getFont().deriveFont(9.0f));
                text.setBorder(null);
            }
        }

        class EditorTabelaAns
        extends DefaultCellEditor {
            public EditorTabelaAns(Object[] items) {
                super(new JComboBox<Object>(items));
                JComboBox combo = (JComboBox)this.getComponent();
                combo.setFont(CampoTable.this.getFont().deriveFont(9.0f));
                combo.setUI(new BasicComboBoxUI(){

                    @Override
                    protected JButton createArrowButton() {
                        return new JButton(){

                            @Override
                            public int getWidth() {
                                return 0;
                            }
                        };
                    }
                });
            }
        }

        class RendererTabela
        extends DefaultTableCellRenderer {
            RendererTabela() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setFont(comp.getFont().deriveFont(9.0f));
                comp.setText("");
                if (value instanceof Date) {
                    comp.setText(Funcoes.formataData("dd/MM/yyyy", (Date)value));
                } else if (value instanceof Double) {
                    comp.setText(Funcoes.formataDecimal((Double)value));
                } else if (value != null) {
                    comp.setText(value.toString());
                }
                StringBuilder bufToolTip = new StringBuilder();
                if (CampoTable.this.colunasEditaveis != null) {
                    boolean isEditavel = false;
                    for (int i = 0; i < CampoTable.this.colunasEditaveis.length; ++i) {
                        if (CampoTable.this.colunasEditaveis[i] != column) continue;
                        isEditavel = true;
                        break;
                    }
                    if (isEditavel) {
                        if (value instanceof TabelaANS.TiposTabela) {
                            bufToolTip.append("<html>Clique para selecionar o tipo da tabela ans");
                        } else {
                            bufToolTip.append("<html>Clique duplo para editar");
                        }
                    } else {
                        bufToolTip.append("");
                    }
                }
                boolean isIncorreto = false;
                if (CampoTable.this.colunasIncorretas != null) {
                    DadosExameFaturamento[] exames = (DadosExameFaturamento[])CampoTable.this.modelo.getValueAt(row, CampoTable.this.tipoTabela == 0 ? 5 : 7);
                    for (int j = 0; j < exames.length; ++j) {
                        DadosExameFaturamento exame = exames[j];
                        if (exame != null) {
                            for (int i = 0; i < CampoTable.this.colunasIncorretas.size(); ++i) {
                                AbstractFaturamentoEletronico.ErroExame erro = (AbstractFaturamentoEletronico.ErroExame)CampoTable.this.colunasIncorretas.get(i);
                                if (erro == null || erro.exame == null || erro.coluna <= -1 || !erro.exame.equals(exame) || erro.coluna != column) continue;
                                isIncorreto = true;
                                if (bufToolTip.length() > 0) {
                                    bufToolTip.append("<br>");
                                } else {
                                    bufToolTip.append("<html>");
                                }
                                bufToolTip.append("<b>").append(erro.erro.toString()).append("</b></html>");
                                break;
                            }
                        }
                        if (isIncorreto) break;
                    }
                    if (isIncorreto) {
                        comp.setBorder(new LineBorder(Color.RED, 1, false));
                    } else {
                        comp.setBorder(CampoTable.this.bordaOriginal);
                    }
                } else {
                    comp.setBorder(CampoTable.this.bordaOriginal);
                }
                if (bufToolTip.length() > 0) {
                    comp.setToolTipText(bufToolTip.toString());
                }
                return comp;
            }
        }

        class RendererObrigatorio
        extends DefaultTableCellRenderer {
            RendererObrigatorio() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setForeground(GuiaVirtual.this.COR_OBRIGATORIOS);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setBackground(UIManager.getColor("TableHeader.cellBackground"));
                this.setFont(UIManager.getFont("TableHeader.font").deriveFont(9.0f));
                this.setHorizontalAlignment(0);
                return comp;
            }
        }
    }

    class CampoCombo
    extends Campo {
        private JComboBox comboValor;

        public CampoCombo(String rotulo, Object[] valores, float proporcaoLargura) {
            super(rotulo, proporcaoLargura);
            this.comboValor = null;
            this.comboValor = new JComboBox<Object>(valores);
            this.comboValor.setFont(this.comboValor.getFont().deriveFont(8.5f));
            this.comboValor.addFocusListener(new Campo.ListenerFocoCampo());
            this.montaCampo();
        }

        private void montaCampo() {
            ((Campo)this).montaCampo();
            this.add((Component)this.comboValor, "Center");
        }

        public void setValor(Object valor) {
            for (int i = 0; i < this.comboValor.getItemCount(); ++i) {
                if (!this.comboValor.getItemAt(i).toString().equalsIgnoreCase(valor.toString())) continue;
                this.comboValor.setSelectedIndex(i);
                break;
            }
        }

        public void validaCBOS(Object valor) {
            StringBuilder stb = new StringBuilder(valor.toString());
            stb.insert(valor.toString().length() - 2, ".");
            for (int i = 0; i < this.comboValor.getItemCount(); ++i) {
                if (!this.comboValor.getItemAt(i).toString().equalsIgnoreCase(stb.toString())) continue;
                this.comboValor.setSelectedIndex(i);
                break;
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.comboValor.setEnabled(isEnabled);
            this.comboValor.setFocusable(isEnabled);
        }

        @Override
        public Object getValor() {
            return this.comboValor.getSelectedItem();
        }

        @Override
        public void setIncorreto(boolean isIncorreto) {
            this.isIncorreto = isIncorreto;
            if (isIncorreto) {
                if (this.bordaOriginal == null) {
                    this.bordaOriginal = this.comboValor.getBorder();
                }
                this.comboValor.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 1, 0), new LineBorder(Color.RED, 1, false)));
                this.comboValor.repaint();
            } else if (this.bordaOriginal != null) {
                this.comboValor.setBorder(this.bordaOriginal);
                this.comboValor.repaint();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            ScreenUtil.requisitarFoco(this.comboValor);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void setToolTipText(String toollTip) {
            this.comboValor.setToolTipText(toollTip);
            this.labelRotulo.setToolTipText(toollTip);
        }
    }

    class CampoTexto
    extends Campo
    implements FocusListener {
        private TTextField textValor;
        private int tipoDado;

        public CampoTexto(String rotulo, int qtdeCaracteres, int tipoDado, float proporcaoLargura) {
            super(rotulo, proporcaoLargura);
            this.textValor = null;
            this.tipoDado = -1;
            this.tipoDado = tipoDado;
            this.textValor = new TTextField(qtdeCaracteres, tipoDado);
            this.textValor.setFont(this.textValor.getFont().deriveFont(8.5f));
            this.textValor.addFocusListener(new Campo.ListenerFocoCampo());
            this.montaCampo();
        }

        public CampoTexto(String rotulo, float proporcaoLargura) {
            super(rotulo, proporcaoLargura);
            this.textValor = null;
            this.tipoDado = -1;
            this.tipoDado = 3;
            this.textValor = new TTextField(20, "[a-zA-Z0-9./-]+");
            this.textValor.setFont(this.textValor.getFont().deriveFont(8.5f));
            this.textValor.addFocusListener(new Campo.ListenerFocoCampo());
            this.montaCampo();
        }

        private void montaCampo() {
            ((Campo)this).montaCampo();
            this.add((Component)this.textValor, "Center");
        }

        public void setValor(String valor) {
            if (this.tipoDado == 2 && valor != null && !Funcoes.textoVazio(valor) && Funcoes.isNumeric(valor)) {
                this.textValor.setText(Funcoes.formataDecimal(Double.parseDouble(Funcoes.limpaDecimal(valor))));
            } else {
                this.textValor.setText(valor);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.textValor.setEnabled(isEnabled);
            this.textValor.setFocusable(isEnabled);
        }

        @Override
        public Object getValor() {
            return Funcoes.textoVazio(this.textValor) ? null : this.textValor.getText();
        }

        @Override
        public void setIncorreto(boolean isIncorreto) {
            this.isIncorreto = isIncorreto;
            if (isIncorreto) {
                if (this.bordaOriginal == null) {
                    this.bordaOriginal = this.textValor.getBorder();
                }
                this.textValor.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 1, 0), new LineBorder(Color.RED, 1, false)));
                this.textValor.repaint();
            } else if (this.bordaOriginal != null) {
                this.textValor.setBorder(this.bordaOriginal);
                this.textValor.repaint();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            ScreenUtil.requisitarFoco(this.textValor);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void setToolTipText(String toolTip) {
            this.textValor.setToolTipText(toolTip);
            this.labelRotulo.setToolTipText(toolTip);
        }
    }

    abstract class Campo
    extends JPanel
    implements FocusListener {
        protected JLabel labelRotulo = null;
        protected float proporcaoLargura = 0.0f;
        protected boolean isObrigatorio = false;
        protected boolean isIncorreto = false;
        protected Border bordaOriginal = null;
        protected String valorAnterior = "";

        public Campo(String rotulo, float proporcaoLargura) {
            this.proporcaoLargura = proporcaoLargura;
            if (rotulo != null && !Funcoes.textoVazio(rotulo)) {
                this.labelRotulo = new JLabel(rotulo);
                this.labelRotulo.setFont(this.labelRotulo.getFont().deriveFont(8.0f));
                if (this.isObrigatorio) {
                    this.labelRotulo.setForeground(GuiaVirtual.this.COR_OBRIGATORIOS);
                }
            }
            this.addFocusListener(this);
        }

        private void setObrigatorio(boolean isObrigatorio) {
            this.isObrigatorio = isObrigatorio;
            this.labelRotulo.repaint();
        }

        private boolean getObrigatorio() {
            return this.isObrigatorio;
        }

        private void montaCampo() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.labelRotulo, "North");
            int largura = (int)(this.proporcaoLargura * 780.0f / 25.0f);
            this.setPreferredSize(new Dimension(largura, 26));
            this.setMinimumSize(new Dimension(largura, 26));
            this.setMaximumSize(new Dimension(largura, 26));
        }

        public abstract Object getValor();

        public abstract void setIncorreto(boolean var1);

        @Override
        public abstract void setEnabled(boolean var1);

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.isObrigatorio) {
                this.labelRotulo.setForeground(GuiaVirtual.this.COR_OBRIGATORIOS);
            }
        }

        @Override
        public abstract void setToolTipText(String var1);

        class ListenerFocoCampo
        implements FocusListener {
            ListenerFocoCampo() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                Campo.this.valorAnterior = Campo.this.getValor() == null ? "" : Campo.this.getValor().toString();
            }

            @Override
            public void focusLost(FocusEvent e) {
                GuiaVirtual.this.guiaAux = guia.getValor() == null ? "" : guia.getValor().toString();
                if (!e.isTemporary() && Campo.this.isObrigatorio) {
                    GuiaVirtual.this.faturamentoEletronico.getValoresPreenchidos(GuiaVirtual.this.requisicaoAux, procedimentos2.getListaExames(), GuiaVirtual.this.configuracaoAux);
                    ArrayList<DadosFaturamento> lista = new ArrayList<DadosFaturamento>();
                    lista.add(GuiaVirtual.this.requisicaoAux);
                    GuiaVirtual.this.faturamentoEletronico.verificaErrosFatura(lista, GuiaVirtual.this.configuracaoAux);
                    GuiaVirtual.this.preencheValores(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.configuracaoAux, GuiaVirtual.this.guiaAux);
                    GuiaVirtual.this.setCamposIncorretos(GuiaVirtual.this.faturamentoEletronico.getCamposIncorretos(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.guiaAux), GuiaVirtual.this.faturamentoEletronico.getColunasIncorretasSolicitados(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.guiaAux), GuiaVirtual.this.faturamentoEletronico.getColunasIncorretasExecutados(GuiaVirtual.this.requisicaoAux, GuiaVirtual.this.guiaAux));
                }
            }
        }
    }

    private static enum GrauParticipacao {
        CIRURGIAO("00-Cirurgi\u00e3o"),
        PRIMEIRO_AUXILIAR("01-1\u00ba Auxiliar"),
        SEGUNDO_AUXILIAR("02-2\u00ba AUXILIAR"),
        TERCEIRO_AUXILIAR("03-3\u00ba Auxiliar"),
        QUARTO_AUXILIAR("04-4\u00ba Auxiliar"),
        INSTRUMENTADOR("05-Instrumentador"),
        ANESTESISTA("06-Anestesista"),
        AUXILIAR_ANESTESIA("07-Aux. Anestesia"),
        CONSULTOR("08-Consultor"),
        PERFUSIONISTA("09-Perfusionista"),
        PEDIATRA("10-Pediatra na Sala de Parto"),
        AUXILIAR_SADT("11-Aux. SADT"),
        CLINICO("12-Cl\u00ednico"),
        NAO_INFORMADO(" ");

        String descricao = " ";

        private GrauParticipacao(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    private static enum TempoDoenca {
        ANOS("A-Anos"),
        MESES("M-Meses"),
        DIAS("D-Dias"),
        NAO_INFORMADO(" ");

        String descricao = " ";

        private TempoDoenca(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    private static enum TipoDoenca {
        AGUDA("A-Aguda"),
        CRONICA("C-Cr\u00f4nica"),
        NAO_INFORMADO(" ");

        String descricao = " ";

        private TipoDoenca(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    public static enum TipoSaida {
        RETORNO("1-Retorno"),
        RETORNO_SADT("2-Retorno SADT"),
        REFERENCIA("3-Refer\u00eancia"),
        INTERNACAO("4-Interna\u00e7\u00e3o");

        String descricao = "";

        private TipoSaida(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    private static enum IndicacaoAcidente {
        ACIDENTE_DOENCA_RELACIONADA_TRABALHO("0-Acidente ou Doen\u00e7a Relacionada ao Trabalho"),
        TRANSITO("1-Tr\u00e2nsito"),
        OUTRO("2-Outro"),
        NAO_INFORMADO(" ");

        String descricao = " ";

        private IndicacaoAcidente(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    public static enum TipoAtendimento {
        REMICAO("01-Remi\u00e7\u00e3o"),
        PEQUENA_CIRURGIA("02-Pequena Cirurgia"),
        TERAPIAS("03-Terapias"),
        CONSULTA("04-Consulta"),
        EXAME("05-Exame"),
        ATENDIMENTO_DOMICILIAR("06-Atendimento Domiciliar"),
        SADT_INTERNADO("07-SADT Internado"),
        QUIMIOTERAPIA("08-Quimioterapia"),
        RADIOTERAPIA("09-Radioterapia"),
        TRS("10-TRS-Terapia Renal Substitutiva");

        String descricao = "";

        private TipoAtendimento(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    private static enum CaraterSolicitacao {
        ELETIVO("E-Eletivo"),
        URGENCIA_EMERGENCIA("U-Urg\u00eancia/Emerg\u00eancia");

        String descricao = "";

        private CaraterSolicitacao(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    private class Tabela {
        private Tabela() {
        }
    }
}

