/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.Configurar;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;

public class Dativa
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    private Registro regFilial;
    private Registro regConvenio;
    private Registro regFatura;
    private int numeroRegistro = 0;
    private int qtdeContas = 0;
    private float totalConta = 0.0f;
    private float totalLote = 0.0f;

    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        StringBuilder retorno = new StringBuilder();
        try {
            Registro r;
            buf.append("select fil_razaosocial, fil_cnpj from filiais_postocoleta where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            ResultSet rsTemp = Conexao.executeQuery(st, buf);
            if (rsTemp.next()) {
                this.regFilial = new Registro(rsTemp);
            }
            buf.delete(0, buf.length());
            buf.append("select a.con_codigo, b.con_razao, b.tpe_codigo, b.con_faturaeletronica from fatura a ");
            buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.fat_codigo = ");
            buf.append(codigoFatura);
            buf.append(" and a.fat_datacancelamento is null ");
            rsTemp = Conexao.executeQuery(st, buf);
            if (rsTemp.next()) {
                this.regConvenio = new Registro(rsTemp);
            }
            if ((r = this.parseDadosXML(this.regConvenio.getString("con_faturaeletronica"))) != null) {
                r.setValor("sequencialRemessa", r.getInt("sequencialRemessa") + 1);
                this.regConvenio.carregar(r);
            }
            buf.delete(0, buf.length());
            buf.append("select fat_dtemis, fat_dtvenc, fat_dtinicio, fat_dtfim, fat_nota, ");
            buf.append("fat_adicional, fat_despcobranca, fat_percdesconto, fat_totalmateriais, ");
            buf.append("fat_totalexamesch, fat_totalexames, fat_qtdeexames, fat_qtderequisicao, ");
            buf.append("fat_dtconferencia ");
            buf.append("from fatura ");
            buf.append("where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and fat_codigo = ");
            buf.append(codigoFatura);
            buf.append(" and fat_datacancelamento is null ");
            rsTemp = Conexao.executeQuery(st, buf);
            if (rsTemp.next()) {
                this.regFatura = new Registro(rsTemp);
            }
            retorno.append(this.criaHeader(st, codigoFatura));
            buf.delete(0, buf.length());
            buf.append("select a.req_codigo, b.req_data, b.med_conselho, b.med_crm, b.med_uf, c.pac_nome, b.req_hora, b.req_dataentregaprev, b.req_horaentregaprev, ");
            buf.append("b.req_guia, b.req_matricula, b.req_dtfatura, b.req_horafatura ");
            buf.append("from faturarequisicao a ");
            buf.append("left join fatura fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo ");
            buf.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.fat_codigo = ");
            buf.append(codigoFatura);
            buf.append(" and fat.fat_datacancelamento is null ");
            buf.append(" and b.req_excluida = false ");
            buf.append(" order by a.req_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                retorno.append(this.criaConta(st2, new Registro(rs), codigoFatura));
            }
            retorno.append(this.criaFimLote(codigoFatura));
            retorno.append(this.criaTrailler());
            String xml = this.criaXML(this.regConvenio);
            buf.delete(0, buf.length());
            buf.append("update convenios set con_faturaeletronica = '");
            buf.append(StringUtil.textoDB(xml));
            buf.append("' where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and con_codigo = ");
            buf.append(this.regConvenio.getString("con_codigo"));
            Conexao.execute(Variaveis.filialPadrao, st2, buf);
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception r) {
                // empty catch block
            }
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Dativa (36)");
        }
        String nomeArquivo = "fat_" + codigoConvenio + "_" + Funcoes.formataData("ddMMyyyy_HHmm", new Date()) + "." + Dativa.getExtensaoArquivo();
        ArrayList<ArquivoFaturamentoEletronico> a = new ArrayList<ArquivoFaturamentoEletronico>();
        a.add(new ArquivoFaturamentoEletronico(nomeArquivo, retorno.toString()));
        return a;
    }

    public static String getNomeProtocolo() {
        return "Dativa";
    }

    public static String getExtensaoArquivo() {
        return "txt";
    }

    private String criaHeader(Statement st, int codigoFatura) throws Exception {
        StringBuilder linha = new StringBuilder();
        linha.append("CSMH");
        linha.append("0");
        linha.append("00000");
        linha.append("00000000");
        linha.append("00000000");
        linha.append("00");
        linha.append(Funcoes.preencheZero(Funcoes.limpaCampos(this.regConvenio.getString("codigoDativa"), "\\.", ",", "/", "-"), 5));
        linha.append(Funcoes.cortaString(this.regConvenio.getString("con_razao"), 30));
        linha.append("J");
        linha.append(Funcoes.cortaString(Funcoes.limpaCampos(this.regConvenio.getString("codigoPrestador"), "\\.", ",", "/", "-"), 14));
        linha.append(Funcoes.cortaString(this.regFilial.getString("fil_razaosocial"), 40));
        linha.append(Funcoes.formataData("ddMMyy", new Date()));
        linha.append(Funcoes.preencheZero(this.regConvenio.getInt("sequencialRemessa"), 4));
        linha.append(" ");
        linha.append(Funcoes.preencheVazio(" ", 15, 1));
        linha.append(Funcoes.preencheZero(this.numeroRegistro++, 6));
        linha.append(Funcoes.preencheVazio(" ", 99, 1));
        linha.append("F");
        return linha.toString();
    }

    private String criaConta(Statement st, Registro registro, int codigoFatura) throws Exception {
        StringBuilder buf = new StringBuilder();
        StringBuilder linha = new StringBuilder();
        ++this.qtdeContas;
        linha.append("\n");
        linha.append("CSMH");
        linha.append("1");
        linha.append("00000");
        linha.append("00000000");
        linha.append(Funcoes.cortaString(!Funcoes.textoVazio(registro.getString("req_guia")) ? registro.getString("req_guia") : registro.getString("req_codigo"), 8));
        linha.append("00");
        linha.append("999");
        linha.append(Funcoes.preencheZero(Funcoes.cortaString(!Funcoes.textoVazio(registro.getString("req_matricula")) ? registro.getString("req_matricula") : "", 18), 18));
        linha.append(Funcoes.preencheVazio("", 10, 1));
        linha.append("5");
        linha.append(Funcoes.formataData("ddMMyy", registro.getDate("req_dtfatura")));
        linha.append(Funcoes.limpaCampos(Funcoes.formataHora(registro.getDate("req_horafatura"), false), ":"));
        linha.append(Funcoes.formataData("ddMMyy", !DBUtil.campoNull(registro.getString("req_dtfatura")) ? registro.getDate("req_dtfatura") : registro.getDate("req_data")));
        linha.append(Funcoes.limpaCampos(Funcoes.formataHora(!DBUtil.campoNull(registro.getString("req_horafatura")) ? registro.getDate("req_horafatura") : registro.getDate("req_hora"), false), ":"));
        linha.append(Funcoes.formataData("ddMMyy", this.regFatura.getDate("fat_dtinicio")));
        linha.append(Funcoes.formataData("ddMMyy", this.regFatura.getDate("fat_dtfim")));
        linha.append("6");
        linha.append(Funcoes.preencheZero("", 6));
        linha.append(Funcoes.preencheZero("", 8));
        linha.append(Funcoes.preencheZero(registro.getString("med_crm"), 6));
        linha.append(Funcoes.preencheVazio(registro.getString("med_uf"), 2, 1));
        linha.append(" ");
        linha.append("00");
        linha.append(Funcoes.cortaString(!Funcoes.textoVazio(registro.getString("req_guia")) ? registro.getString("req_guia") : "", 11));
        linha.append(Funcoes.cortaString(Funcoes.limpaCampos(this.regConvenio.getString("codigoPrestador"), "\\.", ",", "/", "-"), 9));
        linha.append(Funcoes.preencheVazio("", 6, 1));
        linha.append(Funcoes.preencheZero(this.numeroRegistro++, 6));
        linha.append(Funcoes.preencheZero(Funcoes.limpaCampos(this.regFilial.getString("fil_cnpj"), "\\.", ",", "/", "-"), 14));
        linha.append("0");
        linha.append("N");
        linha.append("N");
        linha.append(Funcoes.preencheZero(registro.getString("med_crm"), 10));
        linha.append(Funcoes.preencheVazio(registro.getString("med_uf"), 2, 1));
        linha.append(Funcoes.cortaString(registro.getString("req_matricula"), 23));
        linha.append("04");
        linha.append("6");
        linha.append("N");
        linha.append("1");
        linha.append(Funcoes.preencheVazio("", 42, 1));
        linha.append("F");
        buf.delete(0, buf.length());
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" select a.exa_codigo ");
            buf.append("       ,b.exa_descricao ");
            buf.append("       ,c.dtm_codamb as dtp_codamb ");
            buf.append("       ,d.exr_codautorizacao ");
            buf.append("       ,count(a.exa_codigo) as qtdeExecutada ");
            buf.append("       ,sum(a.fer_total) as valorTotal ");
            buf.append("   from faturaexamerequisicao a ");
            buf.append("   left join fatura fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo ");
            buf.append("   left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("   left join examerequisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("   left join detalhetabelaprecometodologia c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and d.met_codigo = c.met_codigo and c.tpe_codigo = ").append(this.regConvenio.getString("tpe_codigo"));
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and a.fat_codigo = ").append(codigoFatura);
            buf.append("    and a.req_codigo = ").append(registro.getString("req_codigo"));
            buf.append("    and fat.fat_datacancelamento is null ");
            buf.append("    and d.exr_excluido = false ");
            buf.append("  group by a.exa_codigo ");
            buf.append("          ,b.exa_descricao ");
            buf.append("          ,c.dtm_codamb ");
            buf.append("          ,d.exr_codautorizacao ");
            buf.append("  order by b.exa_descricao ");
        } else {
            buf.append(" select a.exa_codigo ");
            buf.append("       ,b.exa_descricao ");
            buf.append("       ,c.dtp_codamb ");
            buf.append("       ,d.exr_codautorizacao ");
            buf.append("       ,count(a.exa_codigo) as qtdeExecutada ");
            buf.append("       ,sum(a.fer_total) as valorTotal ");
            buf.append("   from faturaexamerequisicao a ");
            buf.append("   left join fatura fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo ");
            buf.append("   left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("   left join detalhetabelapreco c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.tpe_codigo = ").append(this.regConvenio.getString("tpe_codigo"));
            buf.append("   left join examerequisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and a.fat_codigo = ").append(codigoFatura);
            buf.append("    and a.req_codigo = ").append(registro.getString("req_codigo"));
            buf.append("    and fat.fat_datacancelamento is null ");
            buf.append("    and d.exr_excluido = false ");
            buf.append("  group by a.exa_codigo ");
            buf.append("          ,b.exa_descricao ");
            buf.append("          ,c.dtp_codamb ");
            buf.append("          ,d.exr_codautorizacao ");
            buf.append("  order by b.exa_descricao ");
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        int numeroItem = 0;
        while (rs.next()) {
            linha.append(this.criaItemConta(registro, new Registro(rs), ++numeroItem));
        }
        linha.append(this.fechaConta(registro, numeroItem));
        return linha.toString();
    }

    private String criaItemConta(Registro registroRequisicao, Registro registro, int numeroItem) throws Exception {
        StringBuilder linha = new StringBuilder();
        linha.append("\n");
        linha.append("CSMH");
        linha.append("2");
        linha.append("00000");
        linha.append("00000000");
        linha.append(Funcoes.cortaString(!Funcoes.textoVazio(registroRequisicao.getString("req_guia")) ? registroRequisicao.getString("req_guia") : registroRequisicao.getString("req_codigo"), 8));
        linha.append("00");
        linha.append(Funcoes.preencheZero(numeroItem, 3));
        linha.append(Funcoes.cortaString(DBUtil.campoNull(registro.getString("dtp_codamb")) || Funcoes.textoVazio(registro.getString("dtp_codamb")) ? "0" : Funcoes.limpaCampos(registro.getString("dtp_codamb"), "\\.", "/", ",", "-"), 8));
        linha.append(Funcoes.cortaString(registro.getString("exa_descricao"), 50));
        linha.append("N");
        linha.append("N");
        linha.append(Funcoes.formataData("ddMMyy", registroRequisicao.getDate("req_dtfatura")));
        linha.append("0");
        linha.append(Funcoes.limpaCampos(Funcoes.formataDecimal("00000.000", registro.getInt("qtdeExecutada".toLowerCase())), "\\.", ","));
        linha.append(Funcoes.limpaCampos(Funcoes.formataDecimal("0000000000.00", registro.getDouble("valorTotal".toLowerCase())), "\\.", ","));
        this.totalConta = (float)((double)this.totalConta + registro.getDouble("valorTotal".toLowerCase()));
        linha.append("000");
        linha.append("   ");
        linha.append(Funcoes.preencheZero("", 5));
        linha.append("  ");
        linha.append(" ");
        linha.append(Funcoes.cortaString(Funcoes.limpaCampos(this.regConvenio.getString("codigoPrestador"), "\\.", ",", "/", "-"), 14));
        linha.append(Funcoes.preencheZero(this.numeroRegistro++, 6));
        linha.append(Funcoes.preencheVazio("", 6, 1));
        linha.append(Funcoes.preencheVazio("", 2, 1));
        linha.append(Funcoes.cortaString(Funcoes.limpaCampos(registro.getString("exr_codautorizacao"), "\\.", ",", "/", "-"), 10));
        linha.append("00");
        linha.append(Funcoes.preencheVazio("", 8, 1));
        linha.append(Funcoes.preencheVazio("", 15, 1));
        linha.append(Funcoes.preencheVazio("", 54, 1));
        linha.append("F");
        return linha.toString();
    }

    private String fechaConta(Registro registro, int numeroItens) {
        StringBuilder linha = new StringBuilder();
        linha.append("\n");
        linha.append("CSMH");
        linha.append("3");
        linha.append("00000");
        linha.append("00000000");
        linha.append(Funcoes.cortaString(!Funcoes.textoVazio(registro.getString("req_guia")) ? registro.getString("req_guia") : registro.getString("req_codigo"), 8));
        linha.append("00");
        linha.append(Funcoes.preencheZero(numeroItens, 3));
        linha.append(Funcoes.limpaCampos(Funcoes.formataDecimal("0000000000000.00", this.totalConta), "\\.", ","));
        linha.append(Funcoes.cortaString(registro.getString("pac_nome"), 40));
        linha.append(Funcoes.preencheVazio("", 43, 1));
        linha.append(Funcoes.preencheVazio("", 15, 1));
        linha.append(Funcoes.preencheZero(this.numeroRegistro++, 6));
        linha.append(Funcoes.preencheVazio("", 99, 1));
        linha.append("F");
        this.totalLote += this.totalConta;
        this.totalConta = 0.0f;
        return linha.toString();
    }

    private String criaFimLote(int codigoFatura) {
        StringBuilder linha = new StringBuilder();
        linha.append("\n");
        linha.append("CSMH");
        linha.append("4");
        linha.append("00000");
        linha.append("00000000");
        linha.append(Funcoes.preencheVazio("", "9", 8, 1));
        linha.append("00");
        linha.append(Funcoes.preencheVazio("", 10, 1));
        linha.append(Funcoes.preencheZero(this.qtdeContas, 3));
        linha.append(Funcoes.limpaCampos(Funcoes.formataDecimal("0000000000000.00", this.totalLote), "\\.", ","));
        linha.append(Funcoes.preencheVazio("", 73, 1));
        linha.append(Funcoes.preencheVazio("", 15, 1));
        linha.append(Funcoes.preencheZero(this.numeroRegistro++, 6));
        linha.append(Funcoes.preencheVazio("", 99, 1));
        linha.append("F");
        return linha.toString();
    }

    private String criaTrailler() {
        StringBuilder linha = new StringBuilder();
        linha.append("\n");
        linha.append("CSMH");
        linha.append("9");
        linha.append("00000");
        linha.append("99999999");
        linha.append(Funcoes.preencheVazio("", "9", 8, 1));
        linha.append("00");
        linha.append(Funcoes.preencheZero(this.qtdeContas, 5));
        linha.append(Funcoes.limpaCampos(Funcoes.formataDecimal("0000000000000.00", this.totalLote), "\\.", ","));
        linha.append(Funcoes.preencheVazio("", 81, 1));
        linha.append(Funcoes.preencheVazio("", 15, 1));
        linha.append(Funcoes.preencheZero(this.numeroRegistro++, 6));
        linha.append(Funcoes.preencheVazio("", 99, 1));
        linha.append("F");
        return linha.toString();
    }

    private int getSequenciaRemessa() {
        return 1;
    }

    private Registro parseDadosXML(String xml) {
        if (xml == null || Funcoes.textoVazio(xml)) {
            return null;
        }
        int sequencialRemessa = 0;
        if (Funcoes.isNumeric(StringUtil.getValor(xml, "sequencialRemessa"))) {
            sequencialRemessa = Integer.parseInt(StringUtil.getValor(xml, "sequencialRemessa"));
        }
        Registro reg = new Registro();
        reg.setValor("protocolo", Dativa.getNomeProtocolo());
        reg.setValor("codigoDativa", StringUtil.getValor(xml, "codigoDativa"));
        reg.setValor("sequencialRemessa", sequencialRemessa);
        reg.setValor("codigoPrestador", StringUtil.getValor(xml, "codigoPrestador"));
        return reg;
    }

    private String criaXML(Registro r) {
        if (r == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(Dativa.getNomeProtocolo()).append("</protocolo>");
        buf.append("<codigoDativa>").append(r.getString("codigoDativa")).append("</codigoDativa>");
        buf.append("<sequencialRemessa>").append(r.getString("sequencialRemessa")).append("</sequencialRemessa>");
        buf.append("<codigoPrestador>").append(r.getString("codigoPrestador")).append("</codigoPrestador>");
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        Configurar conf = new Configurar(parent);
        conf.setXML(this.parseDadosXML(xml));
        conf.setVisible(true);
        if (conf.ok()) {
            Registro r = new Registro();
            r.setValor("codigoDativa", conf.getCodigoDativa());
            r.setValor("sequencialRemessa", conf.getSequencia());
            r.setValor("codigoPrestador", conf.getPrestador());
            retorno = this.criaXML(r);
        }
        return retorno;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return false;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return ParametrosGerais.getCasasPrecoExame() == 2;
    }

    @Override
    public String getCodificacaoArquivo() {
        return FaturamentoEletronico.CODIFICACAO.ISO_8859_1.codificacao;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio0) {
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        return null;
    }

    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        return false;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return null;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        return null;
    }
}

