/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class ConsultarCodigoSolicitacaoAPI {
    public static final String CONFIRMA_OPERACAO = "confirma_operacao";
    public static final String CODIGO_SOLICITACAO = "codigo_solicitacao";
    public static final String BNFRIO_UNIMED = "bnfrio_unimed";
    public static final String BNFRIO_CONTRATO = "bnfrio_contrato";
    public static final String BNFRIO_CODIGO = "bnfrio_codigo";
    public static final String BNFRIO_DEPENDENTE = "bnfrio_dependente";
    public static final String NUMERO_GUIA = "numero_guia";
    public static final String TIPO_SOLICITACAO = "tipo_solicitacao";
    public static final String DATA_SOLICITACAO = "data_solicitacao";
    public static final String CODIGO_SITUACAO = "codigo_situacao";
    public static final String SITUACAO = "situacao";
    public static final String SENHA = "senha";
    public static final String VALIDADE_SENHA = "validade_senha";
    public static final String QUANTIDADE_ITENS = "quantidade_itens";
    public static final String MENSAGEM_ERRO = "mensagem_erro";
    private List<RetornoCodigoSolicitacao> listaRetorno = new ArrayList<RetornoCodigoSolicitacao>();

    public void solicitacaoCodigoSolicitacao(String endereco) throws IOException {
        String[] itens;
        this.listaRetorno.clear();
        URL url = new URL(endereco);
        URLConnection conn = url.openConnection();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String retorno = buffer.readLine();
        if (retorno != null && (itens = retorno.split("}")) != null) {
            for (String item : itens) {
                RetornoCodigoSolicitacao retornoSolicitacao = new RetornoCodigoSolicitacao();
                String[] novoItem = item.split(",");
                for (int i = 0; i < novoItem.length; ++i) {
                    String valor = novoItem[i];
                    if (valor.contains(CONFIRMA_OPERACAO)) {
                        retornoSolicitacao.setConfirma_operacao(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(CODIGO_SOLICITACAO)) {
                        valor = valor.substring(valor.indexOf(":") + 1).replaceAll("\\[", "").replaceAll("\\{", "").replaceAll("\"", "");
                        retornoSolicitacao.setCodigo_solicitacao(valor.substring(valor.indexOf(":") + 1, valor.length()));
                    }
                    if (valor.contains(BNFRIO_UNIMED)) {
                        retornoSolicitacao.setBnfrio_codigo(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(BNFRIO_CONTRATO)) {
                        retornoSolicitacao.setBnfrio_contrato(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(BNFRIO_CODIGO)) {
                        retornoSolicitacao.setBnfrio_codigo(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(BNFRIO_DEPENDENTE)) {
                        retornoSolicitacao.setBnfrio_dependente(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(NUMERO_GUIA)) {
                        retornoSolicitacao.setNumero_guia(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(TIPO_SOLICITACAO)) {
                        retornoSolicitacao.setTipo_solicitacao(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(DATA_SOLICITACAO)) {
                        retornoSolicitacao.setData_solicitacao(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(CODIGO_SITUACAO)) {
                        retornoSolicitacao.setCodigo_situacao(valor.substring(valor.indexOf(":") + 1, valor.length()).replaceAll("\"", ""));
                    }
                    if (valor.contains(SITUACAO)) {
                        retornoSolicitacao.setSituacao(valor.substring(valor.indexOf(":") + 1, valor.length()).replaceAll("\"", ""));
                    }
                    if (valor.contains(SENHA)) {
                        retornoSolicitacao.setSenha(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(VALIDADE_SENHA)) {
                        retornoSolicitacao.setValidade_senha(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (valor.contains(QUANTIDADE_ITENS)) {
                        retornoSolicitacao.setQuantidade_itens(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                    }
                    if (!valor.contains(MENSAGEM_ERRO)) continue;
                    retornoSolicitacao.setMensagem_erro(valor.substring(valor.indexOf(":") + 1, valor.length()).replace("\"", ""));
                }
                this.listaRetorno.add(retornoSolicitacao);
            }
        }
    }

    public List<RetornoCodigoSolicitacao> getListaRetorno() {
        return this.listaRetorno;
    }

    public void setListaRetorno(List<RetornoCodigoSolicitacao> listaRetorno) {
        this.listaRetorno = listaRetorno;
    }

    public class RetornoCodigoSolicitacao {
        private String confirma_operacao;
        private String codigo_solicitacao;
        private String bnfrio_unimed;
        private String bnfrio_contrato;
        private String bnfrio_codigo;
        private String bnfrio_dependente;
        private String numero_guia;
        private String tipo_solicitacao;
        private String data_solicitacao;
        private String codigo_situacao;
        private String situacao;
        private String senha;
        private String validade_senha;
        private String quantidade_itens;
        private String mensagem_erro;

        public String getConfirma_operacao() {
            return this.confirma_operacao;
        }

        public void setConfirma_operacao(String confirma_operacao) {
            this.confirma_operacao = confirma_operacao;
        }

        public String getCodigo_solicitacao() {
            return this.codigo_solicitacao;
        }

        public void setCodigo_solicitacao(String codigo_solicitacao) {
            this.codigo_solicitacao = codigo_solicitacao;
        }

        public String getBnfrio_unimed() {
            return this.bnfrio_unimed;
        }

        public void setBnfrio_unimed(String bnfrio_unimed) {
            this.bnfrio_unimed = bnfrio_unimed;
        }

        public String getBnfrio_contrato() {
            return this.bnfrio_contrato;
        }

        public void setBnfrio_contrato(String bnfrio_contrato) {
            this.bnfrio_contrato = bnfrio_contrato;
        }

        public String getBnfrio_codigo() {
            return this.bnfrio_codigo;
        }

        public void setBnfrio_codigo(String bnfrio_codigo) {
            this.bnfrio_codigo = bnfrio_codigo;
        }

        public String getBnfrio_dependente() {
            return this.bnfrio_dependente;
        }

        public void setBnfrio_dependente(String bnfrio_dependente) {
            this.bnfrio_dependente = bnfrio_dependente;
        }

        public String getNumero_guia() {
            return this.numero_guia;
        }

        public void setNumero_guia(String numero_guia) {
            this.numero_guia = numero_guia;
        }

        public String getTipo_solicitacao() {
            return this.tipo_solicitacao;
        }

        public void setTipo_solicitacao(String tipo_solicitacao) {
            this.tipo_solicitacao = tipo_solicitacao;
        }

        public String getData_solicitacao() {
            return this.data_solicitacao;
        }

        public void setData_solicitacao(String data_solicitacao) {
            this.data_solicitacao = data_solicitacao;
        }

        public String getCodigo_situacao() {
            return this.codigo_situacao;
        }

        public void setCodigo_situacao(String codigo_situacao) {
            this.codigo_situacao = codigo_situacao;
        }

        public String getSituacao() {
            return this.situacao;
        }

        public void setSituacao(String situacao) {
            this.situacao = situacao;
        }

        public String getSenha() {
            return this.senha;
        }

        public void setSenha(String senha) {
            this.senha = senha;
        }

        public String getValidade_senha() {
            return this.validade_senha;
        }

        public void setValidade_senha(String validade_senha) {
            this.validade_senha = validade_senha;
        }

        public String getQuantidade_itens() {
            return this.quantidade_itens;
        }

        public void setQuantidade_itens(String quantidade_itens) {
            this.quantidade_itens = quantidade_itens;
        }

        public String getMensagem_erro() {
            return this.mensagem_erro;
        }

        public void setMensagem_erro(String mensagem_erro) {
            this.mensagem_erro = mensagem_erro;
        }
    }
}

