/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.faturamento.eletronico.UnimedCampinas;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ConfigurarUnimedCampinas
extends JDialog
implements ActionListener {
    public static final String CODIGO_EXECUTANTE = "codigoExecutante";
    public static final String DATA_ENTREGA = "dataEntrega";
    public static final String CODIGO_LOCAL = "codigoLocal";
    public static final String TIPO_ARQUIVO = "tipoArquivo";
    public static final String IDENTIFICADOR_LABORATORIO = "idLaboratorio";
    public static final String NUMERO_GERACAO = "numeroGeracao";
    public static final String ANO_REFERENCIA = "anoReferencia";
    public static final String MES_REFERENCIA = "mesReferencia";
    public static final String GRADE = "grade";
    public static final String MEDICOS = "medicos";
    private JLabel labelIdentLaboratorio = new JLabel("Ident. Laborat\u00f3rio:");
    private JLabel labelCodExecutante = new JLabel("C\u00f3d. Executante:");
    private JLabel labelCodLocal = new JLabel("C\u00f3d. Local (UNCP):");
    private JLabel labelTipoArquivo = new JLabel("Tipo arquivo:");
    private JLabel labelAnoReferencia = new JLabel("Ano Refer\u00eancia:");
    private JLabel labelMesReferencia = new JLabel("M\u00eas Refer\u00eancia:");
    private JLabel labelNumeroEntrega = new JLabel("N\u00famero Entrega:");
    private JLabel labelDataEntrega = new JLabel("Data Entrega:");
    private JLabel labelGrade = new JLabel("Grade:");
    private JLabel labelConselho = new JLabel("Conselho");
    private JLabel labelCRM = new JLabel("CRM");
    private JLabel labelUF = new JLabel("UF");
    private JLabel labelUNCP = new JLabel("UNCP");
    private JLabel labelNomeMedico = new JLabel();
    private TTextField textAnoReferencia = new TTextField(4, 1);
    private TTextField textNumeroEntrega = new TTextField(2, 1);
    private TTextField textDataEntrega = new TTextField(8, 4);
    private TTextField textGrade = new TTextField(6, 1);
    private TTextField textIdentLaboratorio = new TTextField(2, 1);
    private TTextField textCodExecutante = new TTextField(11, 1);
    private TTextField textCodLocal = new TTextField(4, 1);
    private TTextField textCrmMedico = new TTextField(10, 1);
    private TTextField textUncpMedico = new TTextField(4, 1);
    private JComboBox comboMesReferencia = new JComboBox<String>(ConstantesGerais.MESES_ANO);
    private JComboBox comboTipoArquivo = new JComboBox<TipoArquivo>(new TipoArquivo[]{TipoArquivo.ARQUIVO_LABORATORIO, TipoArquivo.ARQUIVO_SERVICOS_IMAGEM});
    private JComboBox comboConselhoMedico = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    private JComboBox comboEstadoMedico = new JComboBox<String>(ConstantesGerais.ESTADOS);
    private JButton buttonDataEntrega = new JButton();
    private JButton buttonMedico = new JButton();
    private JButton buttonOkMedico = new JButton("OK");
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private ModeloGridTable modeloMedico = new ModeloGridTable(new String[]{"Cons.", "CRM", "UF", "Nome", "UNCP"});
    private JTable tableMedico = new JTable(this.modeloMedico);
    private JScrollPane scrollMedico = null;
    private JPanel panelUncpMedico = new JPanel(new GridBagLayout());
    private boolean medicoValido = false;
    private final int COLUNA_CONSELHO = 0;
    private final int COLUNA_CRM = 1;
    private final int COLUNA_UF = 2;
    private final int COLUNA_NOME = 3;
    private final int COLUNA_UNCP = 4;
    private boolean ok = false;

    public ConfigurarUnimedCampinas(Window owner, boolean configuracaoReduzida) {
        super(owner, "Configurando Unimed de Campinas");
        if (configuracaoReduzida) {
            this.montaTelaReduzida();
        } else {
            this.montaTela();
        }
    }

    public ConfigurarUnimedCampinas(Window owner) {
        super(owner, "Configurando Unimed de Campinas");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(500, 400));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "North");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentro.add((Component)this.labelIdentLaboratorio, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelCodLocal, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelAnoReferencia, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelNumeroEntrega, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelGrade, c);
        c.gridy = 0;
        ++c.gridx;
        this.textIdentLaboratorio.setToolTipText("N\u00famero indicador do laborat\u00f3rio na Unimed");
        Dimension d = new Dimension(20, 20);
        this.textIdentLaboratorio.setPreferredSize(d);
        this.textIdentLaboratorio.setMinimumSize(d);
        panelCentro.add((Component)this.textIdentLaboratorio, c);
        ++c.gridy;
        this.textCodLocal.setToolTipText("N\u00famero do local do prestador de servi\u00e7o");
        d = new Dimension(40, 20);
        this.textCodLocal.setPreferredSize(d);
        this.textCodLocal.setMinimumSize(d);
        panelCentro.add((Component)this.textCodLocal, c);
        ++c.gridy;
        d = new Dimension(40, 20);
        this.textAnoReferencia.setPreferredSize(d);
        this.textAnoReferencia.setMinimumSize(d);
        panelCentro.add((Component)this.textAnoReferencia, c);
        ++c.gridy;
        d = new Dimension(20, 20);
        this.textNumeroEntrega.setPreferredSize(d);
        this.textNumeroEntrega.setMinimumSize(d);
        this.textNumeroEntrega.setToolTipText("1 = 1\u00aa entrega, 2 = 2\u00aa entrega, e assim sucessivamente");
        panelCentro.add((Component)this.textNumeroEntrega, c);
        ++c.gridy;
        d = new Dimension(60, 20);
        this.textGrade.setPreferredSize(d);
        this.textGrade.setMinimumSize(d);
        this.textGrade.setToolTipText("Posi\u00e7\u00e3o atual da sequ\u00eancia de gera\u00e7\u00e3o");
        panelCentro.add((Component)this.textGrade, c);
        c.gridy = 0;
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 1);
        panelCentro.add((Component)this.labelCodExecutante, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelTipoArquivo, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelMesReferencia, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelDataEntrega, c);
        c.gridy = 0;
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 2;
        this.textCodExecutante.setToolTipText("C\u00f3digo do prestador (inclusive d\u00edgito verificador)");
        d = new Dimension(100, 20);
        this.textCodExecutante.setPreferredSize(d);
        this.textCodExecutante.setMinimumSize(d);
        panelCentro.add((Component)this.textCodExecutante, c);
        ++c.gridy;
        d = new Dimension(150, 20);
        this.comboTipoArquivo.setPreferredSize(d);
        this.comboTipoArquivo.setMinimumSize(d);
        panelCentro.add((Component)this.comboTipoArquivo, c);
        ++c.gridy;
        d = new Dimension(100, 20);
        this.comboMesReferencia.setPreferredSize(d);
        this.comboMesReferencia.setMinimumSize(d);
        panelCentro.add((Component)this.comboMesReferencia, c);
        ++c.gridy;
        c.gridwidth = 1;
        d = new Dimension(100, 20);
        this.textDataEntrega.setPreferredSize(d);
        this.textDataEntrega.setMinimumSize(d);
        this.textDataEntrega.setToolTipText("Data em que o arquivo ser\u00e1 entregue \u00e0 Unimed");
        panelCentro.add((Component)this.textDataEntrega, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonDataEntrega.setPreferredSize(d);
        this.buttonDataEntrega.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonDataEntrega);
        this.buttonDataEntrega.setFocusable(false);
        c.insets = new Insets(1, 0, 1, 1);
        panelCentro.add((Component)this.buttonDataEntrega, c);
        c.gridy += 2;
        c.gridx = 0;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.fill = 2;
        JLabel labelAux = new JLabel();
        d = new Dimension(10, 10);
        labelAux.setPreferredSize(d);
        labelAux.setMinimumSize(d);
        panelCentro.add((Component)labelAux, c);
        this.add((Component)this.panelUncpMedico, "Center");
        this.panelUncpMedico.setBorder(new TitledBorder("UNCP - M\u00e9dicos"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelUncpMedico.add((Component)this.labelConselho, c);
        ++c.gridx;
        this.panelUncpMedico.add((Component)this.labelCRM, c);
        ++c.gridx;
        this.panelUncpMedico.add((Component)this.labelUF, c);
        ++c.gridx;
        this.panelUncpMedico.add((Component)this.labelNomeMedico, c);
        c.gridx += 2;
        this.panelUncpMedico.add((Component)this.labelUNCP, c);
        ++c.gridy;
        c.gridx = 0;
        d = new Dimension(80, 20);
        this.comboConselhoMedico.setPreferredSize(d);
        this.comboConselhoMedico.setMinimumSize(d);
        this.panelUncpMedico.add((Component)this.comboConselhoMedico, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textCrmMedico.setPreferredSize(d);
        this.textCrmMedico.setMinimumSize(d);
        this.panelUncpMedico.add((Component)this.textCrmMedico, c);
        ++c.gridx;
        d = new Dimension(50, 20);
        this.comboEstadoMedico.setPreferredSize(d);
        this.comboEstadoMedico.setMinimumSize(d);
        this.panelUncpMedico.add((Component)this.comboEstadoMedico, c);
        ++c.gridx;
        Funcoes.imagemPesquisa(this.buttonMedico);
        this.buttonMedico.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonMedico.setPreferredSize(d);
        this.buttonMedico.setMinimumSize(d);
        this.panelUncpMedico.add((Component)this.buttonMedico, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelNomeMedico.setPreferredSize(d);
        this.labelNomeMedico.setMinimumSize(d);
        ScreenUtil.setBorda(new Component[]{this.labelNomeMedico}, new TitledBorder(""));
        this.panelUncpMedico.add((Component)this.labelNomeMedico, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        d = new Dimension(50, 20);
        this.textUncpMedico.setPreferredSize(d);
        this.textUncpMedico.setMinimumSize(d);
        this.panelUncpMedico.add((Component)this.textUncpMedico, c);
        ++c.gridx;
        this.buttonOkMedico.setMargin(new Insets(1, 1, 1, 1));
        d = new Dimension(30, 20);
        this.buttonOkMedico.setPreferredSize(d);
        this.buttonOkMedico.setMinimumSize(d);
        this.panelUncpMedico.add((Component)this.buttonOkMedico, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.modeloMedico.setColumnSize(new int[]{50, 80, 30, 0, 40}, this.tableMedico);
        this.tableMedico.getTableHeader().addMouseListener(this.modeloMedico);
        this.scrollMedico = new JScrollPane(this.tableMedico);
        this.panelUncpMedico.add((Component)this.scrollMedico, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        this.buttonSalvar.setMnemonic('S');
        panelBotoes.add(this.buttonSalvar);
        this.buttonCancelar.setMnemonic('C');
        panelBotoes.add(this.buttonCancelar);
        this.add((Component)panelBotoes, "South");
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonDataEntrega.addActionListener(this);
        this.buttonMedico.addActionListener(this);
        this.buttonOkMedico.addActionListener(this);
        this.textDataEntrega.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfigurarUnimedCampinas.this.buttonDataEntrega.doClick();
                }
            }
        });
        this.textCrmMedico.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfigurarUnimedCampinas.this.buttonMedico.doClick();
                }
            }
        });
        this.tableMedico.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConfigurarUnimedCampinas.this.tableMedico.getSelectedRow();
                if (row > -1 && e.getKeyCode() == 127) {
                    ConfigurarUnimedCampinas.this.modeloMedico.removeLine(row);
                }
            }
        });
        if (!Funcoes.textoVazio(ParametrosGerais.getUfDefault())) {
            this.comboEstadoMedico.setSelectedItem(ParametrosGerais.getUfDefault());
        }
        FocusAdapter focus = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ConfigurarUnimedCampinas.this.validaMedico();
                }
            }
        };
        this.comboConselhoMedico.addFocusListener(focus);
        this.textCrmMedico.addFocusListener(focus);
        this.comboEstadoMedico.addFocusListener(focus);
        Funcoes.montaEnter((JComponent)panelCentro);
        Funcoes.montaEnter((JComponent)this.panelUncpMedico);
        Funcoes.montaEnter((JComponent)panelBotoes);
    }

    private void buscaMedico() {
        Hashtable resultado = Pesquisas.medico(this, true);
        if (resultado != null) {
            this.comboConselhoMedico.setSelectedItem(resultado.get("med_conselho").toString());
            this.textCrmMedico.setText(resultado.get("med_crm").toString());
            this.comboEstadoMedico.setSelectedItem(resultado.get("med_uf").toString());
            this.labelNomeMedico.setText(resultado.get("med_nome").toString());
            this.medicoValido = true;
            ScreenUtil.requisitarFoco(this.textUncpMedico);
        } else {
            ScreenUtil.requisitarFoco(this.textCrmMedico);
        }
    }

    private void montaTelaReduzida() {
        this.setSize(new Dimension(430, 135));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentro.add((Component)this.labelAnoReferencia, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelNumeroEntrega, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelGrade, c);
        c.gridy = 0;
        ++c.gridx;
        Dimension d = new Dimension(40, 20);
        this.textAnoReferencia.setPreferredSize(d);
        this.textAnoReferencia.setMinimumSize(d);
        panelCentro.add((Component)this.textAnoReferencia, c);
        ++c.gridy;
        d = new Dimension(20, 20);
        this.textNumeroEntrega.setPreferredSize(d);
        this.textNumeroEntrega.setMinimumSize(d);
        this.textNumeroEntrega.setToolTipText("1 = 1\u00aa entrega, 2 = 2\u00aa entrega, e assim sucessivamente");
        panelCentro.add((Component)this.textNumeroEntrega, c);
        ++c.gridy;
        d = new Dimension(60, 20);
        this.textGrade.setPreferredSize(d);
        this.textGrade.setMinimumSize(d);
        this.textGrade.setToolTipText("Posi\u00e7\u00e3o atual da sequ\u00eancia de gera\u00e7\u00e3o");
        panelCentro.add((Component)this.textGrade, c);
        c.gridy = 0;
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 1);
        panelCentro.add((Component)this.labelMesReferencia, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelDataEntrega, c);
        c.gridy = 0;
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 2;
        d = new Dimension(100, 20);
        this.comboMesReferencia.setPreferredSize(d);
        this.comboMesReferencia.setMinimumSize(d);
        panelCentro.add((Component)this.comboMesReferencia, c);
        ++c.gridy;
        c.gridwidth = 1;
        d = new Dimension(100, 20);
        this.textDataEntrega.setPreferredSize(d);
        this.textDataEntrega.setMinimumSize(d);
        this.textDataEntrega.setToolTipText("Data em que o arquivo ser\u00e1 entregue \u00e0 Unimed");
        panelCentro.add((Component)this.textDataEntrega, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonDataEntrega.setPreferredSize(d);
        this.buttonDataEntrega.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonDataEntrega);
        this.buttonDataEntrega.setFocusable(false);
        c.insets = new Insets(1, 0, 1, 1);
        panelCentro.add((Component)this.buttonDataEntrega, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonSalvar);
        panelBotoes.add(this.buttonCancelar);
        this.add((Component)panelBotoes, "South");
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonDataEntrega.addActionListener(this);
        this.textDataEntrega.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfigurarUnimedCampinas.this.buttonDataEntrega.doClick();
                }
            }
        });
        Funcoes.montaEnter((JComponent)panelCentro);
        Funcoes.montaEnter((JComponent)panelBotoes);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSalvar) {
            this.ok = true;
            if (Funcoes.textoVazio(this.textIdentLaboratorio)) {
                Funcoes.mensagem(this, "A identifica\u00e7\u00e3o do laborat\u00f3rio deve ser preenchida.", 2);
                this.textIdentLaboratorio.grabFocus();
                return;
            }
            if (Funcoes.textoVazio(this.textCodExecutante)) {
                Funcoes.mensagem(this, "O c\u00f3digo do executante deve ser preenchido.", 2);
                this.textCodExecutante.grabFocus();
                return;
            }
            if (Funcoes.textoVazio(this.textCodLocal)) {
                Funcoes.mensagem(this, "O c\u00f3digo do local deve ser preenchido.", 2);
                this.textCodLocal.grabFocus();
                return;
            }
            if (this.comboTipoArquivo.getSelectedIndex() == -1) {
                Funcoes.mensagem(this, "O tipo de arquivo deve ser selecionado.", 2);
                this.comboTipoArquivo.grabFocus();
                return;
            }
            if (Funcoes.textoVazio(this.textAnoReferencia)) {
                Funcoes.mensagem(this, "O ano de refer\u00eancia deve ser preeenchido.", 2);
                this.textAnoReferencia.grabFocus();
                return;
            }
            if (this.comboMesReferencia.getSelectedIndex() == -1) {
                Funcoes.mensagem(this, "o m\u00eas de refer\u00eancia deve ser preenchido.", 2);
                this.comboMesReferencia.grabFocus();
                return;
            }
            if (Funcoes.textoVazio(this.textNumeroEntrega)) {
                Funcoes.mensagem(this, "O n\u00famero da entrega (no m\u00eas) deve ser preenchido.", 2);
                this.textNumeroEntrega.grabFocus();
                return;
            }
            if (Funcoes.textoVazio(this.textDataEntrega)) {
                Funcoes.mensagem(this, "A data de entrega deve ser preenchida.", 2);
                this.textDataEntrega.grabFocus();
                return;
            }
            if (Funcoes.textoVazio(this.textGrade)) {
                Funcoes.mensagem(this, "A grade atual deve ser preenchida.", 2);
                this.textGrade.grabFocus();
                return;
            }
            this.setVisible(false);
            return;
        }
        if (e.getSource() == this.buttonCancelar) {
            this.ok = false;
            this.setVisible(false);
            return;
        }
        if (e.getSource() == this.buttonDataEntrega) {
            Funcoes.mostraData(this.textDataEntrega, this.buttonDataEntrega, (JPanel)this.textDataEntrega.getParent(), true);
            return;
        }
        if (e.getSource() != this.buttonOkMedico) {
            if (e.getSource() != this.buttonMedico) return;
            this.buscaMedico();
            return;
        }
        if (!this.medicoValido) {
            Funcoes.mensagem(this, "Selecione um m\u00e9dico v\u00e1lido.", 2);
            ScreenUtil.requisitarFoco(this.textCrmMedico);
            return;
        }
        if (Funcoes.textoVazio(this.textUncpMedico)) {
            Funcoes.mensagem(this, "O UNCP do m\u00e9dico n\u00e3o foi informado.", 2);
            ScreenUtil.requisitarFoco(this.textUncpMedico);
            return;
        }
        String crm = this.textCrmMedico.getText();
        String conselho = this.comboConselhoMedico.getSelectedItem().toString();
        String uf = this.comboEstadoMedico.getSelectedItem().toString();
        String uncp = this.textUncpMedico.getText();
        boolean encontrado = false;
        for (int i = 0; i < this.modeloMedico.getRowCount(); ++i) {
            String crmAux = this.modeloMedico.getValueAt(i, 1).toString();
            String conselhoAux = this.modeloMedico.getValueAt(i, 0).toString();
            String ufAux = this.modeloMedico.getValueAt(i, 2).toString();
            if (!crmAux.equalsIgnoreCase(crm) || !conselhoAux.equalsIgnoreCase(conselho) || !ufAux.equalsIgnoreCase(uf)) continue;
            this.modeloMedico.setValueAt(uncp, i, 4);
            encontrado = true;
            break;
        }
        if (!encontrado) {
            this.modeloMedico.addLine(new Object[]{conselho, crm, uf, this.labelNomeMedico.getText(), uncp});
        }
        this.medicoValido = false;
        this.textCrmMedico.clear();
        this.labelNomeMedico.setText("");
        this.textUncpMedico.clear();
        ScreenUtil.requisitarFoco(this.textCrmMedico);
    }

    private void validaMedico() {
        if (!Funcoes.textoVazio(this.textCrmMedico)) {
            Statement st = Conexao.getStatement();
            if (st != null) {
                try {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select med_nome ");
                    buf.append("   from medico ");
                    buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("    and med_conselho = '").append(this.comboConselhoMedico.getSelectedItem()).append("' ");
                    buf.append("    and upper(med_crm) = upper('").append(this.textCrmMedico.getTextDB()).append("') ");
                    buf.append("    and med_uf = '").append(this.comboEstadoMedico.getSelectedItem()).append("' ");
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        this.labelNomeMedico.setText(rs.getString("med_nome"));
                        this.medicoValido = true;
                    } else {
                        this.labelNomeMedico.setText("N\u00e3o cadastrado");
                        this.medicoValido = false;
                    }
                    rs.close();
                }
                catch (SQLException sqlex) {
                    ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace());
                }
            }
            Conexao.fecharStatement(st);
        } else {
            this.labelNomeMedico.setText("");
            this.medicoValido = false;
        }
    }

    public void setXML(String xml) {
        if (xml != null) {
            String[] arrayMedicos;
            this.textIdentLaboratorio.setText(StringUtil.getValor(xml, IDENTIFICADOR_LABORATORIO));
            this.textCodExecutante.setText(StringUtil.getValor(xml, CODIGO_EXECUTANTE));
            this.textCodLocal.setText(StringUtil.getValor(xml, CODIGO_LOCAL));
            this.textAnoReferencia.setText(StringUtil.getValor(xml, ANO_REFERENCIA));
            this.textNumeroEntrega.setText(StringUtil.getValor(xml, NUMERO_GERACAO));
            this.textDataEntrega.setText(StringUtil.getValor(xml, DATA_ENTREGA));
            this.textGrade.setText(StringUtil.getValor(xml, GRADE));
            String tipoArquivo = StringUtil.getValor(xml, TIPO_ARQUIVO);
            if (tipoArquivo != null && !Funcoes.textoVazio(tipoArquivo)) {
                this.comboTipoArquivo.setSelectedItem((Object)TipoArquivo.get(tipoArquivo));
            } else {
                this.comboTipoArquivo.setSelectedIndex(0);
            }
            String mesReferencia = StringUtil.getValor(xml, MES_REFERENCIA);
            if (mesReferencia != null && !Funcoes.textoVazio(mesReferencia)) {
                this.comboMesReferencia.setSelectedIndex(Integer.parseInt(mesReferencia));
            } else {
                this.comboMesReferencia.setSelectedIndex(0);
            }
            String xmlMedicos = StringUtil.getValor(xml, MEDICOS);
            if (xmlMedicos != null && !Funcoes.textoVazio(xmlMedicos) && (arrayMedicos = StringUtil.getValores(xmlMedicos, "medico")) != null && arrayMedicos.length > 0) {
                for (int i = 0; i < arrayMedicos.length; ++i) {
                    String xmlMedico = arrayMedicos[i];
                    String crm = StringUtil.getValor(xmlMedico, "crm");
                    String conselho = StringUtil.getValor(xmlMedico, "conselho");
                    String uf = StringUtil.getValor(xmlMedico, "uf");
                    String nome = StringUtil.getValor(xmlMedico, "nome");
                    String uncp = StringUtil.getValor(xmlMedico, "uncp");
                    this.modeloMedico.addLine(new Object[]{conselho, crm, uf, nome, uncp});
                }
            }
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(UnimedCampinas.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag(IDENTIFICADOR_LABORATORIO, this.textIdentLaboratorio.getText()));
        buf.append(StringUtil.getTag(CODIGO_EXECUTANTE, this.textCodExecutante.getText()));
        buf.append(StringUtil.getTag(CODIGO_LOCAL, this.textCodLocal.getText()));
        buf.append(StringUtil.getTag(ANO_REFERENCIA, this.textAnoReferencia.getText()));
        buf.append(StringUtil.getTag(NUMERO_GERACAO, this.textNumeroEntrega.getText()));
        buf.append(StringUtil.getTag(DATA_ENTREGA, this.textDataEntrega.getText()));
        buf.append(StringUtil.getTag(GRADE, this.textGrade.getText()));
        buf.append(StringUtil.getTag(TIPO_ARQUIVO, String.valueOf(((TipoArquivo)((Object)this.comboTipoArquivo.getSelectedItem())).codigo)));
        buf.append(StringUtil.getTag(MES_REFERENCIA, String.valueOf(this.comboMesReferencia.getSelectedIndex())));
        if (this.modeloMedico.getRowCount() > 0) {
            buf.append("<medicos>");
            for (int i = 0; i < this.modeloMedico.getRowCount(); ++i) {
                buf.append("<medico>");
                buf.append("<crm>").append(this.modeloMedico.getValueAt(i, 1)).append("</crm>");
                buf.append("<uf>").append(this.modeloMedico.getValueAt(i, 2)).append("</uf>");
                buf.append("<conselho>").append(this.modeloMedico.getValueAt(i, 0)).append("</conselho>");
                buf.append("<nome>").append(this.modeloMedico.getValueAt(i, 3)).append("</nome>");
                buf.append("<uncp>").append(this.modeloMedico.getValueAt(i, 4)).append("</uncp>");
                buf.append("</medico>");
            }
            buf.append("</medicos>");
        }
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    public boolean ok() {
        return this.ok;
    }

    private static enum TipoArquivo {
        ARQUIVO_LABORATORIO("AL", "Laborat\u00f3rios"),
        ARQUIVO_SERVICOS_IMAGEM("AR", "Servi\u00e7os de Imagem");

        public String codigo;
        public String descricao;

        private TipoArquivo(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public static TipoArquivo get(String codigo) {
            if (codigo != null && codigo.equalsIgnoreCase(TipoArquivo.ARQUIVO_LABORATORIO.codigo)) {
                return ARQUIVO_LABORATORIO;
            }
            return ARQUIVO_SERVICOS_IMAGEM;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

