/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.laboratorio.util.faturamento.eletronico.SLine;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class ConfigurarSLine
extends JDialog
implements ActionListener {
    public static final String SL_TIPO = "tipoDocumento";
    public static final String SL_TITULO_DOCUMENTO = "tituloDocumento";
    public static final String IDENTIFICADOR_INSTALACAO = "identificadorInstalacao";
    public static final String OPCAO_ENVIO = "opcaoEnvio";
    public static final String ENVIAR_SMS = "enviarSms";
    public static final String MENSAGEM_SMS = "mensagemSms";
    public static final String OPER_REGANS = "registroAns";
    public static final String ENVIAR_COMO_OPERADORA = "enviarComoOperadora";
    private JLabel labelRegistroAns = new JLabel("Registro ANS");
    private TTextField textRegistroAns = new TTextField(6, 1);
    private JLabel labelIdentificadorInstalacao = new JLabel("Identificador da Instala\u00e7\u00e3o");
    private TTextField textIdentificadorInstalacao = new TTextField(2, 3);
    private JLabel labelTituloDocumento = new JLabel("T\u00edtulo do Documento");
    private JComboBox comboTituloDocumento = new JComboBox<Object>(new Object[]{TituloDocumento.IDENTIFICACAO, TituloDocumento.IDENTIFICACAO_E_NOME, TituloDocumento.NOME_E_IDENTIFICACAO, TituloDocumento.NOME});
    private JLabel labelOpcaoEnvio = new JLabel("Op\u00e7\u00e3o de Envio");
    private JComboBox comboOpcaoEnvio = new JComboBox<Object>(new Object[]{OpcaoEnvio.NOVO_DOCUMENTO, OpcaoEnvio.REENVIO_SOLICITACAO_USUARIO, OpcaoEnvio.REENVIO_CORRECAO_ERRO});
    private JLabel labelEnvioSms = new JLabel("Envio de SMS");
    private JComboBox comboEnvioSms = new JComboBox<Object>(new Object[]{EnvioSMS.NAO_ENVIAR, EnvioSMS.SOMENTE_AUTORIZADO, EnvioSMS.SEMPRE_ENVIAR});
    private JLabel labelSms = new JLabel("Mensagem SMS (m\u00e1x. 122 caracteres)");
    private JTextArea areaSms = new JTextArea(new DocSms(122));
    private JScrollPane scrollArea = new JScrollPane(this.areaSms);
    private JCheckBox checkEnviarComoOperadora = new JCheckBox("Enviar como operadora");
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private boolean ok = false;

    public ConfigurarSLine(JDialog owner) {
        super((Dialog)owner, "Configurando SLine");
        this.montaTela();
    }

    public ConfigurarSLine(JFrame owner) {
        super((Frame)owner, "Configurando SLine");
        this.montaTela();
    }

    public void montaTela() {
        this.setSize(new Dimension(260, 380));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        this.add((Component)panelBotoes, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 0, 1);
        panelCentro.add((Component)this.labelRegistroAns, c);
        ++c.gridy;
        panelCentro.add((Component)this.textRegistroAns, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelIdentificadorInstalacao, c);
        ++c.gridy;
        panelCentro.add((Component)this.textIdentificadorInstalacao, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelTituloDocumento, c);
        ++c.gridy;
        panelCentro.add((Component)this.comboTituloDocumento, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelOpcaoEnvio, c);
        ++c.gridy;
        panelCentro.add((Component)this.comboOpcaoEnvio, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelEnvioSms, c);
        ++c.gridy;
        panelCentro.add((Component)this.comboEnvioSms, c);
        ++c.gridy;
        panelCentro.add((Component)this.checkEnviarComoOperadora, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelSms, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        panelCentro.add((Component)this.scrollArea, c);
        panelBotoes.add(this.buttonSalvar);
        panelBotoes.add(this.buttonCancelar);
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        Funcoes.montaEnter((JComponent)panelCentro);
        Funcoes.montaEnter((JComponent)panelBotoes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.ok = e.getSource() == this.buttonSalvar;
        if (this.ok && Funcoes.textoVazio(this.textRegistroAns)) {
            Funcoes.mensagem(this, "O c\u00f3digo do registro na ANS deve ser preenchido.", 2);
            this.textRegistroAns.grabFocus();
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textIdentificadorInstalacao)) {
            Funcoes.mensagem(this, "O identificador de instala\u00e7\u00e3o deve ser preenchido.", 2);
            this.textIdentificadorInstalacao.grabFocus();
            return;
        }
        if (this.ok && this.comboTituloDocumento.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "O t\u00edtulo do documento deve ser configurado.", 2);
            this.comboTituloDocumento.grabFocus();
            return;
        }
        if (this.ok && this.comboOpcaoEnvio.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "A op\u00e7\u00e3o de envio deve ser configurada.", 2);
            this.comboOpcaoEnvio.grabFocus();
            return;
        }
        if (this.ok && this.comboEnvioSms.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "O envio de SMS deve ser configurado.", 2);
            this.comboEnvioSms.grabFocus();
            return;
        }
        this.setVisible(false);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setXML(String xml) {
        if (xml != null) {
            this.textRegistroAns.setText(StringUtil.getValor(xml, OPER_REGANS));
            this.textIdentificadorInstalacao.setText(StringUtil.getValor(xml, IDENTIFICADOR_INSTALACAO));
            this.areaSms.setText(StringUtil.getValor(xml, MENSAGEM_SMS));
            this.checkEnviarComoOperadora.setSelected(StringUtil.getBoolean(xml, ENVIAR_COMO_OPERADORA));
            String auxValor = StringUtil.getValor(xml, ENVIAR_SMS);
            Integer auxCodigo = null;
            auxCodigo = Funcoes.textoVazio(auxValor) ? Integer.valueOf(EnvioSMS.NAO_ENVIAR.codigo) : Integer.valueOf(Integer.parseInt(auxValor));
            switch (auxCodigo) {
                case 0: {
                    this.comboEnvioSms.setSelectedItem((Object)EnvioSMS.NAO_ENVIAR);
                    break;
                }
                case 1: {
                    this.comboEnvioSms.setSelectedItem((Object)EnvioSMS.SOMENTE_AUTORIZADO);
                    break;
                }
                case 2: {
                    this.comboEnvioSms.setSelectedItem((Object)EnvioSMS.SEMPRE_ENVIAR);
                }
            }
            auxValor = StringUtil.getValor(xml, OPCAO_ENVIO);
            auxCodigo = null;
            auxCodigo = Funcoes.textoVazio(auxValor) ? Integer.valueOf(OpcaoEnvio.NOVO_DOCUMENTO.codigo) : Integer.valueOf(Integer.parseInt(auxValor));
            switch (auxCodigo) {
                case 0: {
                    this.comboOpcaoEnvio.setSelectedItem((Object)OpcaoEnvio.NOVO_DOCUMENTO);
                    break;
                }
                case 1: {
                    this.comboOpcaoEnvio.setSelectedItem((Object)OpcaoEnvio.REENVIO_SOLICITACAO_USUARIO);
                    break;
                }
                case 2: {
                    this.comboOpcaoEnvio.setSelectedItem((Object)OpcaoEnvio.REENVIO_CORRECAO_ERRO);
                }
            }
            auxValor = StringUtil.getValor(xml, SL_TITULO_DOCUMENTO);
            auxCodigo = null;
            auxCodigo = Funcoes.textoVazio(auxValor) ? Integer.valueOf(TituloDocumento.IDENTIFICACAO.codigo) : Integer.valueOf(Integer.parseInt(auxValor));
            switch (auxCodigo) {
                case 0: {
                    this.comboTituloDocumento.setSelectedItem((Object)TituloDocumento.IDENTIFICACAO);
                    break;
                }
                case 1: {
                    this.comboTituloDocumento.setSelectedItem((Object)TituloDocumento.IDENTIFICACAO_E_NOME);
                    break;
                }
                case 2: {
                    this.comboTituloDocumento.setSelectedItem((Object)TituloDocumento.NOME_E_IDENTIFICACAO);
                    break;
                }
                case 3: {
                    this.comboTituloDocumento.setSelectedItem((Object)TituloDocumento.NOME);
                }
            }
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(SLine.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag(OPER_REGANS, this.textRegistroAns.getText()));
        buf.append(StringUtil.getTag(SL_TIPO, TipoDocumento.RE.codigo));
        buf.append(StringUtil.getTag(IDENTIFICADOR_INSTALACAO, this.textIdentificadorInstalacao.getText()));
        buf.append(StringUtil.getTag(SL_TITULO_DOCUMENTO, String.valueOf(((TituloDocumento)((Object)this.comboTituloDocumento.getSelectedItem())).codigo)));
        buf.append(StringUtil.getTag(ENVIAR_SMS, String.valueOf(((EnvioSMS)((Object)this.comboEnvioSms.getSelectedItem())).codigo)));
        buf.append(StringUtil.getTag(OPCAO_ENVIO, String.valueOf(((OpcaoEnvio)((Object)this.comboOpcaoEnvio.getSelectedItem())).codigo)));
        buf.append(StringUtil.getTag(MENSAGEM_SMS, this.areaSms.getText()));
        buf.append(StringUtil.getTag(ENVIAR_COMO_OPERADORA, this.checkEnviarComoOperadora.isSelected() ? "true" : "false"));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    class DocSms
    extends PlainDocument {
        int maxLength;

        public DocSms(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            int length = str.length();
            if (offset + length > this.maxLength) {
                length = this.maxLength - offset;
            }
            super.insertString(offset, str.substring(0, length), a);
        }
    }

    public static enum EnvioSMS {
        NAO_ENVIAR(0, "N\u00e3o enviar"),
        SOMENTE_AUTORIZADO(1, "Somente com autoriza\u00e7\u00e3o"),
        SEMPRE_ENVIAR(2, "Sempre enviar"),
        RESULTADO_LIBERADO_ANTES_PREVISTO(3, "Resultado liberado antes do previsto"),
        RESULTADO_LIBERADO_COM_ATRASO(4, "Resultado liberado com atraso");

        public int codigo;
        public String descricao;

        private EnvioSMS(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    public static enum OpcaoEnvio {
        NOVO_DOCUMENTO(0, "Novo documento"),
        REENVIO_SOLICITACAO_USUARIO(1, "Reenvio por solicita\u00e7\u00e3o do usu\u00e1rio"),
        REENVIO_CORRECAO_ERRO(2, "Reenvio para corre\u00e7\u00e3o de erro"),
        REENVIO_RESULTADO_PARCIAL(3, "Reenvio com resultado parcial");

        public int codigo;
        public String descricao;

        private OpcaoEnvio(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    public static enum TituloDocumento {
        IDENTIFICACAO(0, "Identifica\u00e7\u00e3o"),
        IDENTIFICACAO_E_NOME(1, "Identifica\u00e7\u00e3o e Nome"),
        NOME_E_IDENTIFICACAO(2, "Nome e Identifica\u00e7\u00e3o"),
        NOME(3, "Nome");

        public int codigo;
        public String descricao;

        private TituloDocumento(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }

    public static enum TipoDocumento {
        RE("RE");

        public String codigo;

        private TipoDocumento(String codigo) {
            this.codigo = codigo;
        }
    }
}

