/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.laboratorio.util.faturamento.eletronico.Planserv;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ConfigurarPlanserv
extends JDialog
implements ActionListener {
    public static final String TIPO_PRESTADOR = "tipoPrestador";
    public static final String CODIGO_PRESTADOR_OPERADORA = "codigoPrestadorOperadora";
    public static final String NOME_PRESTADOR = "nomePrestador";
    public static final String NUMERO_REMESSA = "numeroRemessa";
    public static final String VERSAO = "versao";
    public static final String CRM_RESPONSAVEL = "crmResponsavel";
    public static final String UF_CRM_RESPONSAVEL = "ufCRMResponsavel";
    public static final String CODIGO_ESPECIALIDADE = "codigoEspecialidade";
    public static final String SEQUENCIAL_ARQUIVO = "sequencialArquivo";
    public static final String CODIGO_EMPRESA_AUDITORIA = "codigoEmpresaAuditoria";
    public static final String NUMERO_RAT = "numeroRat";
    public static final String GUIA_COMO_BIOMETRIA = "guiaComoBiometria";
    public static final int VERSAO_LAYOUT_2 = 2;
    private JLabel labelNomePrestador = new JLabel("Nome Prestador");
    private TTextField textNomePrestador = new TTextField(40, 3);
    private JLabel labelTipoPrestador = new JLabel("Tipo Pessoa Prestador");
    private ButtonGroup buttonGroupTipoPrestador = new ButtonGroup();
    private JRadioButton buttonFisica = new JRadioButton("F\u00edsica", false);
    private JRadioButton buttonJuridica = new JRadioButton("Jur\u00eddica", true);
    private JLabel labelCodigoPrestadorOperadora = new JLabel("C\u00f3digo Prestador Operadora");
    private TTextField textCodigoPrestadorOperadora = new TTextField(12, 3);
    private JLabel labelNumeroRemessa = new JLabel("N\u00famero Remessa");
    private TTextField textNumeroRemessa = new TTextField(5, 1);
    private JLabel labelVersao = new JLabel("Vers\u00e3o do Layout");
    private JComboBox comboVersao = new JComboBox<Object>(new Object[]{2});
    private JLabel labelCrmResponsavel = new JLabel("CRM do Respons\u00e1vel");
    private TTextField textCrmResponsavel = new TTextField(8, 1);
    private JLabel labelUfCrmResponsavel = new JLabel("UF do CRM do Respons\u00e1vel (sigla)");
    private TTextField textUfCrmResponsavel = new TTextField(2, 3);
    private JLabel labelCodigoEspecialidade = new JLabel("C\u00f3digo da Especialidade na Operadora");
    private TTextField textCodigoEspecialidade = new TTextField(2, 1);
    private JLabel labelEmpresaAuditoria = new JLabel("Empresa de Auditoria");
    private JComboBox comboEmpresaAuditoria = new JComboBox<Object>(new Object[]{EmpresaAuditoria.CONCEITO_AUDITORIA, EmpresaAuditoria.CONTROL_MED, EmpresaAuditoria.AUDILINE, EmpresaAuditoria.AITE, EmpresaAuditoria.CONAMED, EmpresaAuditoria.MHZ});
    private JLabel labelNumeroRat = new JLabel("N\u00famero do Formul\u00e1rio de Auditoria");
    private TTextField textNumeroRat = new TTextField(10, 3);
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JCheckBox checkGuiaComoBiometria = new JCheckBox("Usar n\u00famero da guia como biometria");
    private boolean ok = false;

    public ConfigurarPlanserv(JDialog owner) {
        super((Dialog)owner, "Configurando Planserv");
        this.montaTela();
    }

    public ConfigurarPlanserv(JFrame owner) {
        super((Frame)owner, "Configurando Planserv");
        this.montaTela();
    }

    public void montaTela() {
        this.setSize(new Dimension(300, 520));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panelCentro.add((Component)this.labelNomePrestador, c);
        ++c.gridy;
        panelCentro.add((Component)this.textNomePrestador, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelTipoPrestador, c);
        ++c.gridy;
        JPanel panelTipoPrestador = new JPanel(new FlowLayout());
        this.buttonGroupTipoPrestador.add(this.buttonFisica);
        this.buttonGroupTipoPrestador.add(this.buttonJuridica);
        panelTipoPrestador.add(this.buttonFisica);
        panelTipoPrestador.add(this.buttonJuridica);
        panelCentro.add((Component)panelTipoPrestador, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelCodigoPrestadorOperadora, c);
        ++c.gridy;
        panelCentro.add((Component)this.textCodigoPrestadorOperadora, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelNumeroRemessa, c);
        ++c.gridy;
        panelCentro.add((Component)this.textNumeroRemessa, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelCrmResponsavel, c);
        ++c.gridy;
        panelCentro.add((Component)this.textCrmResponsavel, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelUfCrmResponsavel, c);
        ++c.gridy;
        panelCentro.add((Component)this.textUfCrmResponsavel, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelCodigoEspecialidade, c);
        ++c.gridy;
        panelCentro.add((Component)this.textCodigoEspecialidade, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelEmpresaAuditoria, c);
        ++c.gridy;
        panelCentro.add((Component)this.comboEmpresaAuditoria, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelNumeroRat, c);
        ++c.gridy;
        panelCentro.add((Component)this.textNumeroRat, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelVersao, c);
        ++c.gridy;
        panelCentro.add((Component)this.comboVersao, c);
        ++c.gridy;
        panelCentro.add((Component)this.checkGuiaComoBiometria, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonSalvar);
        panelBotoes.add(this.buttonCancelar);
        ++c.gridy;
        panelCentro.add((Component)panelBotoes, c);
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        Funcoes.montaEnter((JComponent)panelCentro);
        Funcoes.montaEnter((JComponent)panelBotoes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.ok = e.getSource() == this.buttonSalvar;
        if (this.ok && Funcoes.textoVazio(this.textNomePrestador)) {
            Funcoes.mensagem(this, "O nome do prestador deve ser preenchido.", 2);
            this.textNomePrestador.grabFocus();
            return;
        }
        if (this.ok && !this.buttonJuridica.isSelected() && !this.buttonFisica.isSelected()) {
            Funcoes.mensagem(this, "O tipo da pessoa do prestador deve ser preenchido.", 2);
            this.buttonFisica.grabFocus();
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textCodigoPrestadorOperadora.getText())) {
            Funcoes.mensagem(this, "O c\u00f3digo do prestador na operadora deve ser preenchido.", 2);
            this.textCodigoPrestadorOperadora.grabFocus();
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textNumeroRemessa)) {
            Funcoes.mensagem(this, "O n\u00famero da remessa deve ser preenchido.", 2);
            this.textNumeroRemessa.grabFocus();
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textCrmResponsavel)) {
            Funcoes.mensagem(this, "O CRM do respons\u00e1vel deve ser preeenchido.", 2);
            this.textCrmResponsavel.grabFocus();
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textUfCrmResponsavel)) {
            Funcoes.mensagem(this, "A sigla da UF do CRM do respons\u00e1vel deve ser preenchida.", 2);
            this.textUfCrmResponsavel.grabFocus();
            return;
        }
        if (this.ok && this.comboEmpresaAuditoria.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "A empresa de auditoria deve ser selecionada.", 2);
            this.comboEmpresaAuditoria.grabFocus();
            return;
        }
        if (this.ok && this.comboVersao.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "A vers\u00e3o do layout deve ser selecionada.", 2);
            this.comboVersao.grabFocus();
            return;
        }
        this.setVisible(false);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setXML(String xml) {
        if (xml != null) {
            this.textCodigoPrestadorOperadora.setText(StringUtil.getValor(xml, CODIGO_PRESTADOR_OPERADORA));
            this.textNomePrestador.setText(StringUtil.getValor(xml, NOME_PRESTADOR));
            this.textNumeroRemessa.setText(StringUtil.getValor(xml, NUMERO_REMESSA));
            this.comboVersao.setSelectedItem(StringUtil.getValor(xml, VERSAO));
            this.textCrmResponsavel.setText(StringUtil.getValor(xml, CRM_RESPONSAVEL));
            this.textUfCrmResponsavel.setText(StringUtil.getValor(xml, UF_CRM_RESPONSAVEL));
            this.textCodigoEspecialidade.setText(StringUtil.getValor(xml, CODIGO_ESPECIALIDADE));
            this.textNumeroRat.setText(StringUtil.getValor(xml, NUMERO_RAT));
            if (Funcoes.textoVazio(StringUtil.getValor(xml, GUIA_COMO_BIOMETRIA))) {
                this.checkGuiaComoBiometria.setSelected(false);
            } else if (StringUtil.getValor(xml, GUIA_COMO_BIOMETRIA).equalsIgnoreCase("T")) {
                this.checkGuiaComoBiometria.setSelected(true);
            } else {
                this.checkGuiaComoBiometria.setSelected(false);
            }
            if (StringUtil.getValor(xml, NUMERO_REMESSA).equalsIgnoreCase(TipoPessoa.FISICA.codigo)) {
                this.buttonFisica.setSelected(true);
            } else {
                this.buttonJuridica.setSelected(true);
            }
            String aux = StringUtil.getValor(xml, CODIGO_EMPRESA_AUDITORIA);
            Integer codigoEmpresa = null;
            codigoEmpresa = Funcoes.textoVazio(aux) ? Integer.valueOf(EmpresaAuditoria.CONCEITO_AUDITORIA.codigo) : Integer.valueOf(Integer.parseInt(aux));
            switch (codigoEmpresa) {
                case 3: {
                    this.comboEmpresaAuditoria.setSelectedItem((Object)EmpresaAuditoria.CONCEITO_AUDITORIA);
                    break;
                }
                case 4: {
                    this.comboEmpresaAuditoria.setSelectedItem((Object)EmpresaAuditoria.CONTROL_MED);
                    break;
                }
                case 5: {
                    this.comboEmpresaAuditoria.setSelectedItem((Object)EmpresaAuditoria.AUDILINE);
                    break;
                }
                case 6: {
                    this.comboEmpresaAuditoria.setSelectedItem((Object)EmpresaAuditoria.AITE);
                    break;
                }
                case 7: {
                    this.comboEmpresaAuditoria.setSelectedItem((Object)EmpresaAuditoria.CONAMED);
                    break;
                }
                case 8: {
                    this.comboEmpresaAuditoria.setSelectedItem((Object)EmpresaAuditoria.MHZ);
                }
            }
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(Planserv.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag(CODIGO_PRESTADOR_OPERADORA, this.textCodigoPrestadorOperadora.getText()));
        buf.append(StringUtil.getTag(NUMERO_REMESSA, this.textNumeroRemessa.getText()));
        buf.append(StringUtil.getTag(NOME_PRESTADOR, this.textNomePrestador.getText()));
        buf.append(StringUtil.getTag(VERSAO, this.comboVersao.getSelectedItem().toString()));
        buf.append(StringUtil.getTag(TIPO_PRESTADOR, this.buttonFisica.isSelected() ? TipoPessoa.FISICA.codigo : TipoPessoa.JURIDICA.codigo));
        buf.append(StringUtil.getTag(CRM_RESPONSAVEL, this.textCrmResponsavel.getText()));
        buf.append(StringUtil.getTag(UF_CRM_RESPONSAVEL, this.textUfCrmResponsavel.getText()));
        buf.append(StringUtil.getTag(CODIGO_ESPECIALIDADE, this.textCodigoEspecialidade.getText()));
        buf.append(StringUtil.getTag(CODIGO_EMPRESA_AUDITORIA, String.valueOf(((EmpresaAuditoria)((Object)this.comboEmpresaAuditoria.getSelectedItem())).codigo)));
        buf.append(StringUtil.getTag(NUMERO_RAT, this.textNumeroRat.getText()));
        buf.append(StringUtil.getTag(GUIA_COMO_BIOMETRIA, this.checkGuiaComoBiometria.isSelected() ? "T" : "F"));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    private static enum EmpresaAuditoria {
        CONCEITO_AUDITORIA(3),
        CONTROL_MED(4),
        AUDILINE(5),
        AITE(6),
        CONAMED(7),
        MHZ(8);

        public final int codigo;

        private EmpresaAuditoria(int codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            switch (this.codigo) {
                case 3: {
                    return "Conceito Auditoria";
                }
                case 4: {
                    return "Control Med";
                }
                case 5: {
                    return "Audiline";
                }
                case 6: {
                    return "Aite";
                }
                case 7: {
                    return "Conamed";
                }
                case 8: {
                    return "Mhz";
                }
            }
            return "";
        }
    }

    private static enum TipoPessoa {
        FISICA("F"),
        JURIDICA("J");

        public String codigo;

        private TipoPessoa(String codigo) {
            this.codigo = codigo;
        }
    }
}

