/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.laboratorio.util.faturamento.eletronico.Ibcm;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ConfigurarIbcm
extends JDialog
implements ActionListener {
    public static final String VERSAO_LAYOUT = "versaoLayout";
    public static final String CODIGO_CONVENIO = "codigoConvenio";
    private JLabel labelLayout = new JLabel("Vers\u00e3o do Layout");
    private JLabel labelCodigoConvenio = new JLabel("C\u00f3digo do Conv\u00eanio");
    private JComboBox comboLayout = new JComboBox<Object>(new Object[]{VersaoLayout.VERSAO_LAYOUT_1});
    private TTextField textCodigoConvenio = new TTextField(6, 1);
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private boolean ok = false;

    public ConfigurarIbcm(JDialog owner) {
        super((Dialog)owner, "Configurando Ibcm");
        this.montaTela();
    }

    public ConfigurarIbcm(JFrame owner) {
        super((Frame)owner, "Configurando Ibcm");
        this.montaTela();
    }

    public void montaTela() {
        this.setSize(new Dimension(220, 150));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panelCentro.add((Component)this.labelLayout, c);
        ++c.gridy;
        panelCentro.add((Component)this.comboLayout, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelCodigoConvenio, c);
        ++c.gridy;
        panelCentro.add((Component)this.textCodigoConvenio, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonSalvar);
        panelBotoes.add(this.buttonCancelar);
        ++c.gridy;
        panelCentro.add((Component)panelBotoes, c);
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        Funcoes.montaEnter((JComponent)panelCentro);
        Funcoes.montaEnter((JComponent)panelBotoes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.ok = e.getSource() == this.buttonSalvar;
        if (this.ok && this.comboLayout.getSelectedIndex() == -1) {
            Funcoes.mensagem(this, "A vers\u00e3o do layout deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(this.comboLayout);
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textCodigoConvenio)) {
            Funcoes.mensagem(this, "O c\u00f3digo do conv\u00eanio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoConvenio);
            return;
        }
        this.setVisible(false);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setXML(String xml) {
        if (xml != null) {
            this.textCodigoConvenio.setText(StringUtil.getValor(xml, CODIGO_CONVENIO));
            VersaoLayout aux = StringUtil.getValor(xml, VERSAO_LAYOUT) == null ? VersaoLayout.VERSAO_LAYOUT_1 : VersaoLayout.get(StringUtil.getValor(xml, VERSAO_LAYOUT));
            this.comboLayout.setSelectedItem((Object)aux);
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(Ibcm.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag(CODIGO_CONVENIO, this.textCodigoConvenio.getText()));
        buf.append(StringUtil.getTag(VERSAO_LAYOUT, String.valueOf(((VersaoLayout)((Object)this.comboLayout.getSelectedItem())).codigo)));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    public static enum VersaoLayout {
        VERSAO_LAYOUT_1(1, "Vers\u00e3o 1");

        public Integer codigo;
        public String descricao;

        private VersaoLayout(Integer codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public static VersaoLayout get(String versao) {
            if (versao != null && !Funcoes.textoVazio(versao) && Integer.parseInt(versao) == 1) {
                return VERSAO_LAYOUT_1;
            }
            return VERSAO_LAYOUT_1;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

