/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.Operadoras;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfigurarElegibilidade
extends JDialog
implements ActionListener {
    public static final String ENVIAR = "enviar";
    public static final String CONFIGURACAO_ELEGIBILIDADE = "configuracaoElegibilidade";
    public static final String CONFIGURACAO_PROCEDIMENTO = "configuracaoProcedimento";
    public static final String CONFIGURACAO_AUTORIZACAO_PROCEDIMENTO = "configuracaoAutorizacao";
    public static final String CAMINHO_WEB_SERVICE = "caminhoWebService";
    public static final String CAMINHO_WEB_SERVICE_SOLICITACAO = "caminhoWebServiceSolicitacao";
    public static final String MSG_VALIDAR = "mensagemValidar";
    public static final String MSG_RECUSAR = "mensagemRecusar";
    public static final String SEQUENCIAL_TRANSACAO = "sequencialTransacao";
    public static final String CNPJ_PRESTADOR = "cnpjPrestador";
    public static final String CODIGO_PRESTADOR = "codigoPrestador";
    public static final String CONVENIO_REGISTRO_ANS = "registroANS";
    public static final String OPERADORA = "operadora";
    public static final String LOGIN = "login";
    public static final String SENHA = "senha";
    public static final String TOKEN = "token";
    public static final String TAG_TOKEN = "api_token=";
    public static final String TAG_CODIGO_SOLICITACAO = "&codigo_solicitacao=";
    public static final String USUARIO_CARTAO = "&usuario_cartao=";
    public static final String NUMERO_GUIA = "&numero_guia=";
    public static final String NAO_ATUALIZA_GUIA = "true";
    private TTextField textCamimnhoWebService = new TTextField(150, 3);
    private TTextField textMensagemValidar = new TTextField(150, 3);
    private TTextField textMensagemResucar = new TTextField(150, 3);
    private TTextField textSequencialTransacao = new TTextField(4, 1);
    private TTextField textCodigoPrestador = new TTextField(18, 3);
    private TTextField textRegistroANS = new TTextField(7, 1);
    private TTextField textLogin = new TTextField(50, 3);
    private TTextField textSenha = new TTextField(50, 3);
    private TTextField textCaminhoWebServiceSolicitacao = new TTextField(150, 3);
    private JLabel registroANS = new JLabel("Registro ANS:");
    private JLabel codigoPrestador = new JLabel("C\u00f3digo do prestador:");
    private JLabel labelSequencialTransacao = new JLabel("Seq. Transa\u00e7\u00e3o:");
    private JLabel labelCaminhoWebServiceSolicitacao = new JLabel("Caminho webservice solicita\u00e7\u00e3o:");
    private JLabel labelCaminhoWebService = new JLabel("Caminho webservice:");
    private JLabel labelMensagemValidar = new JLabel("Msg. Validar:");
    private JLabel labelMensagemRecusar = new JLabel("Msg. Recusar:");
    private JLabel labelCodigoPrestador = new JLabel("C\u00f3digo Prestador:");
    private JLabel labelLogin = new JLabel("Login:");
    private JLabel labelSenha = new JLabel("Senha:");
    private JLabel labelToken = new JLabel("Token:");
    private TTextField textToken = new TTextField(500, 3);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JCheckBox checkBoxNaoAtualizarGuia = new JCheckBox();
    public static final String TIPO_PESSOA_JURIDICA = "J";
    private JLabel labelOperadora = new JLabel("Operadora:");
    JComboBox<Operadoras> comboOperadora = new SteppedComboBox((Object[])Operadoras.values());
    private boolean ok = false;
    private boolean isElebilidade = false;
    private boolean isProcedimento = false;

    public ConfigurarElegibilidade(Window owner, boolean isElebilidade, boolean isProcedimento) {
        super(owner, isElebilidade ? "Configurando elegibilidade" : "Configurando solicita\u00e7\u00e3o/autoriza\u00e7\u00e3o de procedimentos");
        this.isElebilidade = isElebilidade;
        this.isProcedimento = isProcedimento;
        this.setSize(new Dimension(550, this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && !isElebilidade || isProcedimento ? 350 : 340));
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelCentro.setBorder(new TitledBorder("Configura\u00e7\u00e3o"));
        panelBotoes.add(this.buttonSalvar);
        panelBotoes.add(this.buttonCancelar);
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        this.add((Component)panelBotoes, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.gridheight = 1;
        c.fill = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 2, 2, 0);
        panelCentro.add((Component)this.labelCaminhoWebService, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        panelCentro.add((Component)this.textCamimnhoWebService, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.labelMensagemValidar, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        panelCentro.add((Component)this.textMensagemValidar, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.labelMensagemRecusar, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        this.textMensagemResucar.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textMensagemResucar, c);
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        panelCentro.add((Component)this.labelSequencialTransacao, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        this.textSequencialTransacao.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textSequencialTransacao, c);
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        panelCentro.add((Component)this.registroANS, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        this.textRegistroANS.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textRegistroANS, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.labelCodigoPrestador, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        this.textCodigoPrestador.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textCodigoPrestador, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.labelOperadora, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        this.comboOperadora.setPreferredSize(new Dimension(20, 20));
        this.comboOperadora.setMinimumSize(new Dimension(20, 20));
        panelCentro.add(this.comboOperadora, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.labelLogin, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        this.textCodigoPrestador.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textLogin, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentro.add((Component)this.labelSenha, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.textSenha.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textSenha, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.labelToken, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        this.textToken.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textToken, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentro.add((Component)this.labelCaminhoWebServiceSolicitacao, c);
        c.fill = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.textSenha.setPreferredSize(new Dimension(350, 20));
        panelCentro.add((Component)this.textCaminhoWebServiceSolicitacao, c);
        if (isProcedimento) {
            this.checkBoxNaoAtualizarGuia.setText("N\u00e3o atualizar n\u00famero de guia dos exames");
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            panelCentro.add((Component)this.checkBoxNaoAtualizarGuia, c);
        }
        this.visualizarToken();
        this.visualizarCaminhoSolicitacao();
        this.textSequencialTransacao.setEditable(false);
        this.buttonCancelar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.comboOperadora.addActionListener(event -> {
            this.visualizarToken();
            this.visualizarCaminhoSolicitacao();
            this.checkBoxNaoAtualizarGuia.setEnabled(((Operadoras)((Object)((Object)this.comboOperadora.getSelectedItem()))).naoAtualizaGuia());
        });
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            if (this.isElebilidade) {
                xml.abrir(CONFIGURACAO_ELEGIBILIDADE);
            } else if (this.isProcedimento) {
                xml.abrir(CONFIGURACAO_PROCEDIMENTO);
            } else {
                xml.abrir(CONFIGURACAO_AUTORIZACAO_PROCEDIMENTO);
            }
            xml.escrever(CAMINHO_WEB_SERVICE, this.textCamimnhoWebService.getText());
            xml.escrever(MSG_VALIDAR, this.textMensagemValidar.getText());
            xml.escrever(MSG_RECUSAR, this.textMensagemResucar.getText());
            xml.escrever(SEQUENCIAL_TRANSACAO, this.textSequencialTransacao.getText());
            xml.escrever(CODIGO_PRESTADOR, this.textCodigoPrestador.getText());
            xml.escrever(CONVENIO_REGISTRO_ANS, this.textRegistroANS.getText());
            xml.escrever(OPERADORA, String.valueOf(((Operadoras)((Object)this.comboOperadora.getSelectedItem())).getCodigo()));
            xml.escrever(LOGIN, this.textLogin.getText());
            xml.escrever(SENHA, this.textSenha.getText());
            if (this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA)) {
                xml.escrever(TOKEN, this.textToken.getText());
                xml.escrever(CAMINHO_WEB_SERVICE_SOLICITACAO, this.textCaminhoWebServiceSolicitacao.getText());
            }
            if (this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_ITAPEVA) || this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_ITUVERAVA)) {
                xml.escrever(NAO_ATUALIZA_GUIA, String.valueOf(this.checkBoxNaoAtualizarGuia.isSelected()));
            }
            if (this.isElebilidade) {
                xml.fechar(CONFIGURACAO_ELEGIBILIDADE);
            } else if (this.isProcedimento) {
                xml.fechar(CONFIGURACAO_PROCEDIMENTO);
            } else {
                xml.fechar(CONFIGURACAO_AUTORIZACAO_PROCEDIMENTO);
            }
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar o xml de configura\u00e7\u00e3o." + e.getMessage(), e.getStackTrace());
            return "";
        }
        return xml.getXML();
    }

    public void setXML(String xml) {
        if (Funcoes.textoVazio(xml)) {
            this.textSequencialTransacao.setText("0");
            return;
        }
        String valor = StringUtil.getValor(xml, CAMINHO_WEB_SERVICE);
        this.textCamimnhoWebService.setText(valor);
        valor = StringUtil.getValor(xml, MSG_VALIDAR);
        this.textMensagemValidar.setText(valor);
        valor = StringUtil.getValor(xml, MSG_RECUSAR);
        this.textMensagemResucar.setText(valor);
        valor = StringUtil.getValor(xml, SEQUENCIAL_TRANSACAO);
        valor = Funcoes.textoVazio(valor) ? "0" : valor;
        this.textSequencialTransacao.setText(valor);
        valor = StringUtil.getValor(xml, CODIGO_PRESTADOR);
        this.textCodigoPrestador.setText(valor);
        valor = StringUtil.getValor(xml, CONVENIO_REGISTRO_ANS);
        this.textRegistroANS.setText(valor);
        String codigoOperadora = StringUtil.getValor(xml, OPERADORA);
        if (!Funcoes.textoVazio(codigoOperadora)) {
            for (int i = 0; i < this.comboOperadora.getItemCount(); ++i) {
                Operadoras operadora = this.comboOperadora.getItemAt(i);
                if (operadora.getCodigo() != Integer.parseInt(codigoOperadora)) continue;
                this.comboOperadora.setSelectedIndex(i);
                this.visualizarToken();
                this.visualizarCaminhoSolicitacao();
                break;
            }
        }
        valor = StringUtil.getValor(xml, LOGIN);
        this.textLogin.setText(valor);
        valor = StringUtil.getValor(xml, SENHA);
        this.textSenha.setText(valor);
        if (this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_ITAPEVA) || this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_ITUVERAVA)) {
            valor = StringUtil.getValor(xml, NAO_ATUALIZA_GUIA);
            this.checkBoxNaoAtualizarGuia.setSelected(Boolean.valueOf(StringUtil.getValor(xml, NAO_ATUALIZA_GUIA)));
        }
        if (this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA)) {
            valor = StringUtil.getValor(xml, TOKEN);
            this.textToken.setText(valor);
            valor = StringUtil.getValor(xml, CAMINHO_WEB_SERVICE_SOLICITACAO);
            this.textCaminhoWebServiceSolicitacao.setText(valor);
        }
        this.controlaCampos();
    }

    private void visualizarToken() {
        this.setSize(new Dimension(550, this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && !this.isElebilidade || this.isProcedimento ? 350 : 340));
        this.setResizable(false);
        this.checkBoxNaoAtualizarGuia.setVisible(this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) || this.isProcedimento);
        this.textToken.setVisible(this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && !this.isProcedimento && !this.isElebilidade);
        this.labelToken.setVisible(this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && !this.isProcedimento && !this.isElebilidade);
    }

    private void visualizarCaminhoSolicitacao() {
        this.setSize(new Dimension(550, this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && !this.isElebilidade || this.isProcedimento ? 365 : 330));
        this.setResizable(false);
        this.labelCaminhoWebServiceSolicitacao.setVisible(this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && !this.isProcedimento && !this.isElebilidade);
        this.textCaminhoWebServiceSolicitacao.setVisible(this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && !this.isProcedimento && !this.isElebilidade);
    }

    private void controlaCampos() {
    }

    private void limparCampos() {
        this.textCamimnhoWebService.clear();
        this.textCaminhoWebServiceSolicitacao.clear();
        this.textMensagemValidar.clear();
        this.textMensagemResucar.clear();
        this.textSequencialTransacao.clear();
        this.textCodigoPrestador.clear();
        this.textRegistroANS.clear();
        this.comboOperadora.setSelectedIndex(0);
        this.textLogin.clear();
        this.textSenha.clear();
        this.controlaCampos();
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.ok = e.getSource() == this.buttonSalvar;
        if (this.ok) {
            if (Funcoes.textoVazio(this.textCamimnhoWebService)) {
                Funcoes.mensagem(this, "Informe o caminho do webservice.", 2);
                ScreenUtil.requisitarFoco(this.textCamimnhoWebService);
                return;
            }
            if (Funcoes.textoVazio(this.textMensagemValidar)) {
                Funcoes.mensagem(this, "Informe a mensagem de validar.", 2);
                ScreenUtil.requisitarFoco(this.textMensagemValidar);
                return;
            }
            if (Funcoes.textoVazio(this.textMensagemResucar)) {
                Funcoes.mensagem(this, "Informe a mensagem de recusar.", 2);
                ScreenUtil.requisitarFoco(this.textMensagemResucar);
                return;
            }
            if (String.valueOf(((Operadoras)((Object)this.comboOperadora.getSelectedItem())).getCodigo()).equalsIgnoreCase(String.valueOf(Operadoras.OPERADORA_UNIMED_UBERABA.getCodigo())) && Funcoes.textoVazio(this.textLogin)) {
                Funcoes.mensagem(this, "Informe o login.", 2);
                ScreenUtil.requisitarFoco(this.textLogin);
                return;
            }
            if (String.valueOf(((Operadoras)((Object)this.comboOperadora.getSelectedItem())).getCodigo()).equalsIgnoreCase(String.valueOf(Operadoras.OPERADORA_UNIMED_UBERABA.getCodigo())) && Funcoes.textoVazio(this.textSenha)) {
                Funcoes.mensagem(this, "Informe a senha.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return;
            }
            if (this.comboOperadora.getSelectedItem().equals((Object)Operadoras.OPERADORA_UNIMED_JOACABA) && Funcoes.textoVazio(this.textCaminhoWebServiceSolicitacao)) {
                Funcoes.mensagem(this, "Informe o caminho do webservice de solicita\u00e7\u00e3o.", 2);
                ScreenUtil.requisitarFoco(this.textCaminhoWebServiceSolicitacao);
                return;
            }
            this.setVisible(false);
        } else {
            this.setVisible(false);
        }
    }
}

