/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Statement;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ConfigurarCompetenciaProcedimentoBPA
extends AbstractDialogoOKCancelar
implements ActionListener {
    TTextField textAnoProducao = new TTextField(4, 1);
    TTextField textMesProducao = new TTextField(2, 1);
    private JLabel labelAno = new JLabel("Ano Produ\u00e7\u00e3o:");
    private JLabel labelMes = new JLabel("M\u00eas Produ\u00e7\u00e3o:");
    private boolean ok = false;
    private String codigoFilial = "";
    private String codigoConvenio = "";
    private String xmlBPA;

    public ConfigurarCompetenciaProcedimentoBPA(Frame owner) {
        super(owner, "Compet\u00eancia de realiza\u00e7\u00e3o do procedimento");
        this.setSize(new Dimension(260, 118));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfigurarCompetenciaProcedimentoBPA.this.setVisible(false);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelAno, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.labelMes, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.textAnoProducao.setPreferredSize(new Dimension(180, 20));
        this.textAnoProducao.setMinimumSize(new Dimension(180, 20));
        this.getPanelCentral().add((Component)this.textAnoProducao, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 2;
        this.textMesProducao.setPreferredSize(new Dimension(20, 20));
        this.textMesProducao.setMinimumSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.textMesProducao, c);
        ++c.gridx;
        c.anchor = 13;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)new JLabel(), c);
        this.montaBotaoServicosClassificacao();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void montaBotaoServicosClassificacao() {
        JPanel panelBotoes = this.getPanelBotoesDireita();
        panelBotoes.removeAll();
        panelBotoes.add(this.buttonOK);
        panelBotoes.add(this.buttonCancelar);
    }

    public boolean validaMesProducao(String mesProducao) {
        if (Funcoes.textoVazio(mesProducao)) {
            return false;
        }
        int mes = Integer.parseInt(mesProducao);
        return mes > 0 && mes < 13;
    }

    public boolean validaAnoProducao(String anoProducao) {
        if (Funcoes.textoVazio(anoProducao)) {
            return false;
        }
        int ano = Integer.parseInt(anoProducao);
        return ano > 1900;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ok = e.getSource() == this.buttonOK;
        Object o = e.getSource();
        if (this.ok) {
            boolean mesProducaoOk = this.validaMesProducao(this.textMesProducao.getText());
            boolean anoProducaoOk = this.validaAnoProducao(this.textAnoProducao.getText());
            if (Funcoes.textoVazio(this.textAnoProducao.getText()) || Funcoes.textoVazio(this.textMesProducao) || !mesProducaoOk || !anoProducaoOk) {
                Funcoes.mensagem(this, "M\u00eas/Ano Produ\u00e7\u00e3o devem ser informados corretamente.", 2);
                ScreenUtil.requisitarFoco(this.textAnoProducao);
                return;
            }
            StringBuilder xml = new StringBuilder(this.xmlBPA);
            StringUtil.setValor(xml, "AnoProducao", this.textAnoProducao.getText());
            StringUtil.setValor(xml, "MesProducao", this.textMesProducao.getText());
            this.gravaAlteracoesBPAConvenio(xml);
            this.setVisible(false);
        } else if (o == this.buttonCancelar) {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gravaAlteracoesBPAConvenio(StringBuilder xml) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        Object rs = null;
        try {
            if (!Funcoes.textoVazio(this.codigoConvenio) && !Funcoes.textoVazio(this.codigoFilial)) {
                buf.setLength(0);
                buf.append(" update convenios ");
                buf.append("    set con_faturaeletronica = '").append((CharSequence)xml).append("' ");
                buf.append("  where fil_codigo = ").append(this.codigoFilial);
                buf.append("    and con_codigo = ").append(this.codigoConvenio);
                Conexao.executeUpdate(String.valueOf(this.codigoFilial), st, buf.toString());
                Conexao.arquivaSQL();
            }
            if (st == null) return;
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar dados. " + e.getMessage(), e.getStackTrace());
                if (st == null) return;
            }
            catch (Throwable throwable) {
                if (st == null) throw throwable;
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
        return;
    }

    public boolean ok() {
        return this.ok;
    }

    public void setXML(String configBPA) {
        String anoProducao = "";
        String anoMes = "";
        if (!Funcoes.textoVazio(configBPA)) {
            anoProducao = StringUtil.getValor(configBPA, "AnoProducao");
            anoMes = StringUtil.getValor(configBPA, "MesProducao");
            this.textAnoProducao.setText(anoProducao);
            this.textMesProducao.setText(anoMes);
        }
        this.xmlBPA = configBPA;
    }

    public String getTextAnoProducao() {
        return this.textAnoProducao.getText();
    }

    public void setTextAnoProducao(TTextField textAnoProducao) {
        this.textAnoProducao = textAnoProducao;
    }

    public String getTextMesProducao() {
        return this.textMesProducao.getText();
    }

    public void setTextMesProducao(TTextField textMesProducao) {
        this.textMesProducao = textMesProducao;
    }

    public String getCodigoFilial() {
        return this.codigoFilial;
    }

    public void setCodigoFilial(String codigoFilial) {
        this.codigoFilial = codigoFilial;
    }

    public String getCodigoConvenio() {
        return this.codigoConvenio;
    }

    public void setCodigoConvenio(String codigoConvenio) {
        this.codigoConvenio = codigoConvenio;
    }
}

