/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.laboratorio.util.faturamento.eletronico.ICS;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ConfiguradorICS
extends JDialog
implements ActionListener {
    protected static final String CODIGO_CONTRATADO = "codigoContratado";
    protected static final String RAZAO_SOCIAL_CONTRATADO = "razaoSocialContratado";
    protected static final String SEQUENCIAL_ARQUIVO = "sequencialArquivo";
    private JLabel labelCodigoContratado = new JLabel("C\u00f3digo do Contratado no ICS");
    private TTextField textCodigoContratado = new TTextField(6, 1);
    private JLabel labelRazaoSocialContratado = new JLabel("Raz\u00e3o Social do Contratado");
    private TTextField textRazaoSocialContratado = new TTextField(40, 3);
    private JLabel labelSequenciaEnvio = new JLabel("Sequ\u00eancia de Envio");
    private TTextField textSequenciaEnvio = new TTextField(6, 1);
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private boolean ok = false;

    public ConfiguradorICS(JDialog owner) {
        super((Dialog)owner, "Configurando ICS");
        this.montaTela();
    }

    public ConfiguradorICS(JFrame owner) {
        super((Frame)owner, "Configurando ICS");
        this.montaTela();
    }

    public void montaTela() {
        this.setSize(new Dimension(330, 200));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panelCentro.add((Component)this.labelCodigoContratado, c);
        ++c.gridy;
        panelCentro.add((Component)this.textCodigoContratado, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelRazaoSocialContratado, c);
        ++c.gridy;
        panelCentro.add((Component)this.textRazaoSocialContratado, c);
        ++c.gridy;
        panelCentro.add((Component)this.labelSequenciaEnvio, c);
        ++c.gridy;
        panelCentro.add((Component)this.textSequenciaEnvio, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonSalvar);
        panelBotoes.add(this.buttonCancelar);
        ++c.gridy;
        panelCentro.add((Component)panelBotoes, c);
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        Funcoes.montaEnter((JComponent)panelCentro);
        Funcoes.montaEnter((JComponent)panelBotoes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.ok = e.getSource() == this.buttonSalvar;
        if (this.ok && Funcoes.textoVazio(this.textCodigoContratado)) {
            Funcoes.mensagem(this, "O c\u00f3digo do contratado deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoContratado);
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textRazaoSocialContratado)) {
            Funcoes.mensagem(this, "A raz\u00e3o social do contratado deve ser preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textRazaoSocialContratado);
            return;
        }
        if (this.ok && Funcoes.textoVazio(this.textSequenciaEnvio)) {
            Funcoes.mensagem(this, "A sequ\u00eancia do arquivo deve ser preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textSequenciaEnvio);
            return;
        }
        this.setVisible(false);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setXML(String xml) {
        if (xml != null) {
            this.textCodigoContratado.setText(StringUtil.getValor(xml, CODIGO_CONTRATADO));
            this.textRazaoSocialContratado.setText(StringUtil.getValor(xml, RAZAO_SOCIAL_CONTRATADO));
            this.textSequenciaEnvio.setText(StringUtil.getValor(xml, SEQUENCIAL_ARQUIVO));
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(ICS.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag(CODIGO_CONTRATADO, this.textCodigoContratado.getText()));
        buf.append(StringUtil.getTag(RAZAO_SOCIAL_CONTRATADO, this.textRazaoSocialContratado.getText()));
        buf.append(StringUtil.getTag(SEQUENCIAL_ARQUIVO, this.textSequenciaEnvio.getText()));
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }
}

