/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento.eletronico;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.AbstractErroFaturamento;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DetalhamentoErroFaturamento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.PadraoLogradouro;
import jalis.laboratorio.recepcao.util.RacaCorPaciente;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ConfigurarCompetenciaProcedimentoBPA;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.GuiaVirtual;
import jalis.laboratorio.util.faturamento.eletronico.JanelaConfiguracaoFaturamentoBPA;
import jalis.laboratorio.util.faturamento.eletronico.Requisicao;
import jalis.laboratorio.util.faturamento.eletronico.VisualizaErrosBPA;
import jalis.laboratorio.util.faturamento.eletronico.bpa.ConfigurarBPA;
import jalis.laboratorio.util.faturamento.eletronico.bpa.DadosHeader;
import jalis.laboratorio.util.faturamento.eletronico.bpa.DadosLinha;
import jalis.laboratorio.util.faturamento.eletronico.bpa.OrgaoDestino;
import jalis.laboratorio.util.faturamento.eletronico.bpa.OrigemInformacoes;
import jalis.laboratorio.util.faturamento.eletronico.bpa.Raca;
import jalis.laboratorio.util.faturamento.eletronico.bpa.TipoBPA;
import jalis.laboratorio.util.faturamento.eletronico.tiss.DadosTiss;
import jalis.service.cadastro.ConvenioService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JFrame;

public class BPA
extends AbstractFaturamentoEletronico
implements FaturamentoEletronico {
    public static final String TAGANOPRODUCAO = "AnoProducao";
    public static final String TAGMESRODUCAO = "MesProducao";
    public static final String TAGNOMEDESTINO = "NomeDestino";
    public static final String TAGCNPJRESPONSAVEL = "CnpjResponsavel";
    public static final String TAGNOMEORGAOORIGEM = "NomeOrgaoOrigem";
    public static final String TAGSIGLAORGAOORIGEM = "SiglaOrgaoOrigem";
    public static final String TAGCNSPROFISSIONAL = "CnsProfissional";
    public static final String TAGCBOPADRAO = "CBOPadrao";
    public static final String TAGCID10PADRAO = "CID10Padrao";
    public static final String TAGCARATERATENDIMENTO = "CaraterAtendimento";
    public static final String TAGORGAODESTINO = "OrgaoDestino";
    public static final String TAGIGNORARCOBOSMEDICO = "ConsideraCBOExecutante";
    private DadosHeader header = new DadosHeader();
    private static ArrayList<DadosLinha> linhas;
    private static Registro config;
    int folhaConsolidado = 1;
    int seqFolhaConsolidado = 0;
    int folhaIndividualizado = 1;
    int seqFolhaIndividualizado = 0;
    String xmlBPA;
    ConvenioService convenioService;
    Object[] listaServicosClassificacao;
    public static final String[] CARATER_ATENDIMENTO;

    public BPA() {
        linhas = new ArrayList();
        this.convenioService = new ConvenioService();
    }

    public DadosHeader getHeader() {
        return this.header;
    }

    public void adicionarLinha(DadosLinha dadosLinha) {
        if (dadosLinha != null) {
            linhas.add(dadosLinha);
        }
    }

    public static String getNomeProtocolo() {
        return "BPA";
    }

    public static String getExtensaoArquivo() {
        String xml = config.getString("con_faturaeletronica");
        String retornoExtensao = BPA.extensaoArquivoBPA(xml);
        return retornoExtensao;
    }

    private static String extensaoArquivoBPA(String xml) {
        String mesArquivo = StringUtil.getValor(xml, TAGMESRODUCAO);
        switch (BPA.validarExtensaoArquivo(mesArquivo)) {
            case "1": {
                return "Jan";
            }
            case "2": {
                return "Fev";
            }
            case "3": {
                return "Mar";
            }
            case "4": {
                return "Abr";
            }
            case "5": {
                return "Mai";
            }
            case "6": {
                return "Jun";
            }
            case "7": {
                return "Jul";
            }
            case "8": {
                return "Ago";
            }
            case "9": {
                return "Set";
            }
            case "10": {
                return "Out";
            }
            case "11": {
                return "Nov";
            }
            case "12": {
                return "Dez";
            }
        }
        return null;
    }

    public static String validarExtensaoArquivo(String mesArquivo) {
        if (mesArquivo.startsWith("0")) {
            return mesArquivo.replaceAll("0", "");
        }
        return mesArquivo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ArquivoFaturamentoEletronico> criarArquivo(Object owner, int codigoFatura, String codigoConvenio, String diretorioArquivos) {
        Statement st;
        ArrayList<ArquivoFaturamentoEletronico> retorno;
        block7: {
            retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            st = Conexao.getStatement();
            try {
                String codigoDaFilial = Variaveis.filialPadrao;
                String xmlFaturaEletronica = this.convenioService.getXmlDoConvenio(codigoDaFilial, codigoConvenio);
                boolean isOK = this.verificaConfiguracaoAnoMes(codigoDaFilial, codigoConvenio, xmlFaturaEletronica);
                if (!isOK) break block7;
                StringBuilder buf = new StringBuilder();
                buf.append("select a.con_codigo, b.con_faturaeletronica, b.con_ordemfatura ");
                buf.append("from fatura a ");
                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                buf.append("where a.fil_codigo = ").append(codigoDaFilial);
                buf.append(" and a.fat_codigo = ").append(codigoFatura);
                buf.append(" and a.fat_datacancelamento is null ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                String ordemFatura = null;
                if (rs.next()) {
                    xmlFaturaEletronica = rs.getString("con_faturaeletronica");
                    config.setValor("con_faturaeletronica", xmlFaturaEletronica);
                    config.setValor("con_codigo", codigoConvenio);
                    ordemFatura = rs.getString("con_ordemfatura");
                }
                if (config == null) break block7;
                retorno = this.gerarArquivo(owner, st, codigoFatura, codigoConvenio, ordemFatura, rs);
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BPA");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private boolean verificaConfiguracaoAnoMes(String filial, String convenio, String xmlFaturamento) {
        ConfigurarCompetenciaProcedimentoBPA config = new ConfigurarCompetenciaProcedimentoBPA(Laboratorio.getInstancia());
        config.setCodigoFilial(String.valueOf(filial));
        config.setCodigoConvenio(String.valueOf(convenio));
        config.setXML(xmlFaturamento);
        config.setVisible(true);
        return config.isOk();
    }

    public ArrayList<ArquivoFaturamentoEletronico> gerarArquivo(Object owner, Statement st, int codigoFatura, String codigoConvenio, String ordemFatura, ResultSet re) throws SQLException {
        StringBuilder conteudo = new StringBuilder();
        BPA bpa = new BPA();
        if (this.getDadosRequisicao(codigoFatura, bpa)) {
            bpa.getHeader().setAnoProducao(StringUtil.getInt(config.getValor("con_faturaeletronica").toString(), TAGANOPRODUCAO));
            bpa.getHeader().setMesProducao(StringUtil.getInt(config.getValor("con_faturaeletronica").toString(), TAGMESRODUCAO));
            bpa.getHeader().setNomeDestino(StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGNOMEDESTINO));
            bpa.getHeader().setCnpjResponsavel(StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGCNPJRESPONSAVEL));
            bpa.getHeader().setNomeOrgaoOrigem(StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGNOMEORGAOORIGEM));
            bpa.getHeader().setSiglaOrgaoOrigem(StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGSIGLAORGAOORIGEM));
            bpa.getHeader().setCnsProfissional(StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGCNSPROFISSIONAL));
            String orgao = StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGORGAODESTINO);
            if (orgao.equals(OrgaoDestino.ESTADUAL.toString())) {
                bpa.getHeader().setOrgaoDestino(OrgaoDestino.ESTADUAL);
            } else {
                bpa.getHeader().setOrgaoDestino(OrgaoDestino.MUNICIPAL);
            }
            StringBuilder nomeArquivo = new StringBuilder();
            nomeArquivo.append("BPA").append(StringUtil.getInt(config.getValor("con_faturaeletronica").toString(), TAGANOPRODUCAO));
            nomeArquivo.append(Funcoes.preencheZero(StringUtil.getInt(config.getValor("con_faturaeletronica").toString(), TAGMESRODUCAO), 2));
            if (bpa.getHeader().validarDados(linhas).size() <= 0) {
                conteudo.append(bpa.getHeader().gerarLinha(linhas));
                conteudo.append(bpa.getHeader().gerarLinhasExames(linhas));
            }
            ArrayList<ArquivoFaturamentoEletronico> retorno = new ArrayList<ArquivoFaturamentoEletronico>();
            retorno.add(new ArquivoFaturamentoEletronico(nomeArquivo.toString(), conteudo.toString()));
            return retorno;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getDadosRequisicao(int codigoFatura, BPA bpa) {
        Statement st = Conexao.getStatement();
        String codPacIndividualizado = "";
        String codPacConsolidado = "";
        HashMap<String, String> examesNaoConfigurados = new HashMap<String, String>();
        try {
            ResultSet rs = Conexao.executeQuery(st, this.getSql(codigoFatura));
            String cboPadrao = StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGCBOPADRAO);
            String cid10Padrao = StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGCID10PADRAO);
            while (rs.next()) {
                DadosLinha dadosLinha = new DadosLinha();
                String codigoProcedimento = rs.getString("dtp_codamb");
                String tipoBPA = rs.getString("exa_tipobpa");
                String racaPaciente = rs.getString("pac_cor");
                int nacionalidadePaciente = rs.getInt("nli_codigo");
                int etniaPaciente = rs.getInt("ein_codigo");
                String cbo = this.getCbo(rs.getString("med_cbo"), cboPadrao);
                String ibgeCidade = rs.getString("cid_codigoibge");
                ResultSet servico = this.getInfoServico(codigoProcedimento);
                if (Funcoes.textoVazio(codPacIndividualizado) && Funcoes.textoVazio(codPacConsolidado)) {
                    codPacIndividualizado = rs.getString("pac_codigo");
                    codPacConsolidado = rs.getString("pac_codigo");
                }
                bpa.getHeader().setCnesRealizante(rs.getString("fil_cnes"));
                if (!Funcoes.textoVazio(cbo)) {
                    dadosLinha.setCodigoCBO(cbo);
                }
                dadosLinha.setCodigoProcedimento(!Funcoes.textoVazio(codigoProcedimento) ? Long.parseLong(StringUtil.removeCaracteresNaoNumericos(codigoProcedimento)) : 0L);
                if (Funcoes.textoVazio(tipoBPA)) {
                    if (!examesNaoConfigurados.containsKey(rs.getString("exa_codigo"))) {
                        examesNaoConfigurados.put(rs.getString("exa_codigo"), rs.getString("exa_descricao") + " (" + rs.getString("exa_codigo") + ")");
                    }
                } else if (tipoBPA.equalsIgnoreCase(TipoBPA.INDIVIDUALIZADO.getSigla())) {
                    this.infoPaginaIndividualizado(codPacIndividualizado, rs, dadosLinha);
                    dadosLinha.setTipo(TipoBPA.INDIVIDUALIZADO);
                    codPacIndividualizado = rs.getString("pac_codigo");
                    dadosLinha.setRequisicao(rs.getInt("req_codigo"));
                    dadosLinha.setFilial(rs.getInt("fil_codigo"));
                } else {
                    this.infoPaginaConsolidado(codPacConsolidado, rs, dadosLinha);
                    dadosLinha.setTipo(TipoBPA.CONSOLIDADO);
                    codPacConsolidado = rs.getString("pac_codigo");
                }
                dadosLinha.setQuantidade(rs.getInt("contagem"));
                dadosLinha.setOrigemInformacoes(OrigemInformacoes.OUTROS_SISTEMAS);
                dadosLinha.setDataAtendimento(rs.getDate("req_dtfatura"));
                dadosLinha.setCid10(!Funcoes.textoVazio(rs.getString("c10_codigo")) ? rs.getString("c10_codigo") : cid10Padrao);
                dadosLinha.setCaraterAtendimento(StringUtil.getValor(config.getValor("con_faturaeletronica").toString(), TAGCARATERATENDIMENTO));
                dadosLinha.setAutorizacaoEstabelecimento(rs.getString("exr_codautorizacao"));
                if (!Funcoes.textoVazio(racaPaciente)) {
                    switch (racaPaciente) {
                        case "P": {
                            dadosLinha.setRacaPaciente(Raca.PARDA);
                            break;
                        }
                        case "N": {
                            dadosLinha.setRacaPaciente(Raca.NEGRO);
                            break;
                        }
                        case "B": {
                            dadosLinha.setRacaPaciente(Raca.BRANCO);
                            break;
                        }
                        case "A": {
                            dadosLinha.setRacaPaciente(Raca.AMARELA);
                            break;
                        }
                        case "M": {
                            dadosLinha.setRacaPaciente(Raca.INDIGENA);
                        }
                    }
                }
                dadosLinha.setEtniaPaciente(etniaPaciente == 0 ? 0 : etniaPaciente);
                dadosLinha.setNacionalidadePaciente(nacionalidadePaciente == 0 ? 10 : nacionalidadePaciente);
                if (servico != null) {
                    dadosLinha.setCodigoServico(servico.getInt("abp_servico"));
                    dadosLinha.setClassificacaoServico(servico.getInt("abp_classificacao"));
                } else {
                    dadosLinha.setCodigoServico(0);
                    dadosLinha.setClassificacaoServico(0);
                }
                dadosLinha.setSequenciaEquipe(Funcoes.textoVazio(rs.getString("uns_sequencialequipe")) ? -1 : rs.getInt("uns_sequencialequipe"));
                dadosLinha.setCodigoAreaEquipe(Funcoes.textoVazio(rs.getString("uns_areaequipe")) ? -1 : rs.getInt("uns_areaequipe"));
                dadosLinha.setCnpjOPM("");
                dadosLinha.setCnsPaciente(!Funcoes.textoVazio(rs.getString("req_cartaosus")) ? rs.getString("req_cartaosus") : "");
                dadosLinha.setSexoPaciente(rs.getString("pac_sexo"));
                dadosLinha.setNomePaciente(rs.getString("pac_nome"));
                dadosLinha.setDataNascimentoPaciente(rs.getDate("pac_datanasc"));
                dadosLinha.setIdade(rs.getInt("req_idade"));
                if (!Funcoes.textoVazio(ibgeCidade) && ibgeCidade.length() <= 6) {
                    dadosLinha.setIbgeCidadePaciente(ibgeCidade);
                } else if (!Funcoes.textoVazio(ibgeCidade)) {
                    ibgeCidade = ibgeCidade.substring(0, 6);
                    dadosLinha.setIbgeCidadePaciente(ibgeCidade);
                }
                dadosLinha.setCepPaciente(rs.getString("pac_cep"));
                PadraoLogradouro logradouro = PadraoLogradouro.get(rs.getString("pac_tipologradouroendereco"));
                if (logradouro != null) {
                    dadosLinha.setLogradouroPaciente(logradouro.getCodigo());
                } else {
                    dadosLinha.setLogradouroPaciente(PadraoLogradouro.TIPO_LOGRADOURO_RUA.getCodigo());
                }
                dadosLinha.setEnderecoPaciente(rs.getString("pac_endereco"));
                dadosLinha.setNumeroPaciente(rs.getString("pac_numeroendereco"));
                dadosLinha.setComplementoPaciente(rs.getString("pac_complemento"));
                dadosLinha.setBairroPaciente(Funcoes.textoVazio(rs.getString("bai_descricao")) ? "" : rs.getString("bai_descricao"));
                dadosLinha.setTelefonePaciente(rs.getString("pac_fone"));
                dadosLinha.setEmailPaciente(rs.getString("pac_email"));
                dadosLinha.setIdentificaoNacionalEquipe(0);
                bpa.adicionarLinha(dadosLinha);
            }
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "BPA");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        if (!examesNaoConfigurados.isEmpty() && null != examesNaoConfigurados) {
            VisualizaErrosBPA.novaInstancia(Laboratorio.getInstancia(), "Exames n\u00e3o configurados.", examesNaoConfigurados, false);
            return false;
        }
        return true;
    }

    private String getCbo(String cbo, String cboPadrao) {
        if (!Funcoes.textoVazio(cbo)) {
            cbo = StringUtil.removeCaracteresNaoNumericos(StringUtil.getValor(cbo, "codigo"));
        } else if (!Funcoes.textoVazio(cboPadrao)) {
            cbo = StringUtil.removeCaracteresNaoNumericos(cboPadrao);
        }
        if (this.ignorarCboMedico()) {
            cbo = StringUtil.removeCaracteresNaoNumericos(cboPadrao);
        }
        return cbo;
    }

    private boolean ignorarCboMedico() {
        boolean ignorarCbo = StringUtil.getBoolean(config.getValor("con_faturaeletronica").toString(), TAGIGNORARCOBOSMEDICO);
        return ignorarCbo;
    }

    private void infoPaginaIndividualizado(String codPacAnterior, ResultSet rs, DadosLinha dadosLinha) throws SQLException {
        if (codPacAnterior.equalsIgnoreCase(rs.getString("pac_codigo"))) {
            if (this.seqFolhaIndividualizado < 20) {
                ++this.seqFolhaIndividualizado;
            } else {
                ++this.folhaIndividualizado;
                this.seqFolhaIndividualizado = 1;
            }
            dadosLinha.setFolha(this.folhaIndividualizado);
            dadosLinha.setSequencialFolha(this.seqFolhaIndividualizado);
        } else {
            ++this.folhaIndividualizado;
            this.seqFolhaIndividualizado = 1;
            dadosLinha.setFolha(this.folhaIndividualizado);
            dadosLinha.setSequencialFolha(this.seqFolhaIndividualizado);
        }
    }

    private void infoPaginaConsolidado(String codPacAnterior, ResultSet rs, DadosLinha dadosLinha) throws SQLException {
        if (codPacAnterior.equalsIgnoreCase(rs.getString("pac_codigo"))) {
            if (this.seqFolhaConsolidado < 20) {
                ++this.seqFolhaConsolidado;
            } else {
                ++this.folhaConsolidado;
                this.seqFolhaConsolidado = 1;
            }
            dadosLinha.setFolha(this.folhaConsolidado);
            dadosLinha.setSequencialFolha(this.seqFolhaConsolidado);
        } else {
            ++this.folhaConsolidado;
            this.seqFolhaConsolidado = 1;
            dadosLinha.setFolha(this.folhaConsolidado);
            dadosLinha.setSequencialFolha(this.seqFolhaConsolidado);
        }
    }

    private ResultSet getInfoServico(String codigoProcedimento) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        String tmp = codigoProcedimento;
        if (!Funcoes.textoVazio(tmp) && StringUtil.removeCaracteresNaoNumericos(tmp).trim().length() >= 2) {
            tmp = StringUtil.removeCaracteresNaoNumericos(tmp);
            tmp = tmp.substring(0, tmp.trim().length() - 1);
        }
        buf.append("SELECT abp_servico, abp_classificacao ");
        buf.append("FROM ambbpa ");
        buf.append("WHERE fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" AND abp_codigoamb = '").append(StringUtil.removeCaracteresNaoNumericos(tmp)).append("'");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs;
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private StringBuilder getSql(int codigoFatura) {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append(ParametrosGerais.getPrecoMetodologia() ? "count(dtm_codamb)" : "count(dtp_codamb)").append(" as contagem ");
        buf.append("      ,b.fil_codigo ");
        buf.append("      ,b.req_dtfatura ");
        buf.append("      ,b.req_codigo ");
        buf.append("      ,b.fil_codigo ");
        buf.append("      ,c.pac_nome ");
        buf.append("      ,c.pac_datanasc ");
        buf.append("      ,b.req_data ");
        buf.append("      ,b.med_crm ");
        buf.append("      ,exm.exa_descricao ");
        buf.append("      ,exm.exa_codigo ");
        buf.append("      ,c.pac_codigo ");
        buf.append("      ,c.pac_sexo ");
        buf.append("      ,c.pac_endereco ");
        buf.append("      ,c.ein_codigo ");
        buf.append("      ,c.nli_codigo ");
        buf.append("      ,c.pac_numeroendereco ");
        buf.append("      ,c.pac_fone ");
        buf.append("      ,ba.bai_descricao ");
        buf.append("      ,c.pac_cep ");
        buf.append("      ,b.req_matricula ");
        buf.append("      ,exr.exr_datadigita ");
        buf.append("      ,cid.cid_codigoibge ");
        buf.append("      ,fil.fil_cnes ");
        buf.append("      ,b.uns_codigo ");
        buf.append("      ,medi.med_cbo");
        buf.append("      ,medi.med_nome ");
        buf.append("      ,medi.med_uf");
        buf.append("      ,exr.exr_codautorizacao");
        buf.append("      ,exm.exa_tipobpa");
        buf.append("      ,reqC.c10_codigo");
        buf.append("      ,COALESCE(NULLIF(b.req_cartaosus, ''), c.pac_cartaosus)   as req_cartaosus");
        buf.append("      ,uns.uns_sequencialequipe");
        buf.append("      ,uns.uns_areaequipe");
        buf.append("      ,c.pac_tipologradouroendereco");
        buf.append("      ,c.pac_complemento");
        buf.append("      ,c.pac_email");
        buf.append("      ,c.pac_cor");
        buf.append("      ,b.req_idade");
        buf.append(ParametrosGerais.getPrecoMetodologia() ? " ,n.dtm_codamb as dtp_codamb" : " ,n.dtp_codamb");
        buf.append("  from faturarequisicao a ");
        buf.append("  join faturaexamerequisicao e on a.fil_codigo = e.fil_codigo and a.fil_kodigo = e.fil_kodigo and a.fat_codigo = e.fat_codigo and a.req_codigo = e.req_codigo ");
        buf.append("  join requisicao b on a.fil_kodigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("  left join requisicaocid10 reqC ON reqC.req_codigo = b.req_codigo AND reqC.fil_codigo = b.fil_codigo");
        buf.append("  join medico medi  on medi.med_crm = b.med_crm and medi.fil_codigo = b.fil_codigo and medi.med_uf = b.med_uf and medi.med_conselho = b.med_conselho");
        buf.append("  join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
        buf.append("  join fatura fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo ");
        buf.append("  join exames exm on e.fil_kodigo = exm.fil_codigo and e.exa_codfilho = exm.exa_codigo ");
        buf.append("  join convenios con on b.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
        buf.append("  left join bairro ba on c.fil_codigo = ba.fil_codigo and c.bai_codigo = ba.bai_codigo ");
        buf.append("  join examerequisicao exr on b.fil_codigo = exr.fil_codigo and b.req_codigo = exr.req_codigo and e.exa_codigo = exr.exa_codigo and e.mco_codigo = exr.mco_codigo ");
        buf.append("  left join cidades cid on c.fil_codigo = cid.fil_codigo and c.cid_codigo = cid.cid_codigo ");
        buf.append("  left join filiais_postocoleta fil on b.fil_codigo = fil.fil_codigo ");
        buf.append("  left join unidadesaude uns on b.fil_codigo = uns.fil_codigo and b.uns_codigo = uns.uns_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("  left join detalhetabelaprecometodologia n on e.fil_codigo = n.fil_codigo and e.exa_codfilho = n.exa_codigo and e.mco_codfilho = n.mco_codigo and con.tpe_codigo = n.tpe_codigo and exr.met_codigo = n.met_codigo ");
        } else {
            buf.append("  left join detalhetabelapreco n on e.fil_codigo = n.fil_codigo and e.exa_codfilho = n.exa_codigo and e.mco_codfilho = n.mco_codigo and con.tpe_codigo = n.tpe_codigo ");
        }
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and a.fat_codigo = ").append(codigoFatura);
        buf.append("   and fat.fat_datacancelamento is null ");
        buf.append("   and b.req_excluida = false ");
        buf.append(" group by b.fil_codigo ");
        buf.append("         ,b.req_dtfatura ");
        buf.append("         ,b.req_codigo ");
        buf.append("         ,b.fil_codigo ");
        buf.append("         ,c.pac_nome ");
        buf.append("         ,c.pac_datanasc ");
        buf.append("         ,b.req_data ");
        buf.append("         ,b.med_crm ");
        buf.append("         ,exm.exa_descricao ");
        buf.append(ParametrosGerais.getPrecoMetodologia() ? " ,n.dtm_codamb" : " ,n.dtp_codamb");
        buf.append("         ,c.pac_codigo ");
        buf.append("         ,c.pac_sexo ");
        buf.append("         ,c.pac_mae ");
        buf.append("         ,c.pac_endereco ");
        buf.append("         ,c.pac_numeroendereco ");
        buf.append("         ,c.pac_fone ");
        buf.append("         ,c.pac_cartaosus ");
        buf.append("         ,ba.bai_descricao ");
        buf.append("         ,c.pac_cep ");
        buf.append("         ,c.pac_cpf ");
        buf.append("         ,b.req_matricula ");
        buf.append("         ,exr.exr_datadigita ");
        buf.append("         ,cid.cid_codigoibge ");
        buf.append("         ,fil.fil_cnes ");
        buf.append("         ,b.uns_codigo ");
        buf.append("         ,medi.med_cbo");
        buf.append("         ,medi.med_nome");
        buf.append("         ,medi.med_uf");
        buf.append("         ,exr.exr_codautorizacao");
        buf.append("         ,reqC.c10_codigo");
        buf.append("         ,b.req_cartaosus");
        buf.append("         ,exm.exa_tipobpa");
        buf.append("         ,exm.exa_codigo ");
        buf.append("         ,uns.uns_sequencialequipe");
        buf.append("         ,uns.uns_areaequipe");
        buf.append("         ,c.pac_tipologradouroendereco");
        buf.append("         ,c.pac_complemento");
        buf.append("         ,c.pac_email");
        buf.append("         ,c.pac_cor");
        buf.append("         ,b.req_idade");
        buf.append("      \t ,c.ein_codigo ");
        buf.append("      \t ,c.nli_codigo ");
        buf.append(" order by b.fil_codigo ");
        buf.append("         ,b.req_codigo");
        buf.append("         ,c.pac_codigo");
        return buf;
    }

    private ArrayList<DadosTiss> carregaRequisicoesFaturamento(Statement st, int codigoFatura, String ordemFatura) throws SQLException, XMLStringBuilderException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.req_codigo ");
        bui.append("      ,a.fil_kodigo ");
        bui.append("      ,COALESCE(c.con_codrepasse = a.con_codigo, false) as isRepasse ");
        bui.append("      ,CASE WHEN con.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(c.req_titular), ''), pac.pac_nome) ELSE pac.pac_nome END as ordemPaciente ");
        bui.append("  from faturarequisicao a ");
        bui.append("  join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        bui.append("  join requisicao c on a.fil_kodigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
        bui.append("  join paciente pac on c.fil_codigo = pac.fil_codigo and c.pac_codigo = pac.pac_codigo ");
        bui.append("  join convenios con on b.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
        bui.append("  join medico med on c.fil_codigo = med.fil_codigo and c.med_crm = med.med_crm and c.med_uf = med.med_uf and c.med_conselho = med.med_conselho ");
        bui.append(" where b.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append("   and b.fat_codigo = ").append(codigoFatura);
        bui.append("   and b.fat_datacancelamento is null ");
        bui.append("   and c.req_excluida = false ");
        bui.append(" order by  ");
        if (ordemFatura == null || ordemFatura.equals("R")) {
            bui.append(" c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("D")) {
            bui.append(" c.req_data, c.fil_codigo, c.req_codigo ");
        } else if (ordemFatura.equals("F")) {
            bui.append(" c.req_dtfatura, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("N")) {
            bui.append(" ordemPaciente, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("G")) {
            bui.append(" c.req_guia, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("M")) {
            bui.append(" c.req_matricula, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("E")) {
            bui.append(" med.med_nome, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("C")) {
            bui.append(" med.med_crm, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("X")) {
            bui.append(" c.req_data, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("T")) {
            bui.append(" c.des_codigo, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("P")) {
            bui.append(" c.req_data, pac.pac_nome, c.fil_codigo, a.req_codigo ");
        } else if (ordemFatura.equals("W")) {
            bui.append(" c.ent_codempresa, c.fil_codigo, c.req_codigo ");
        }
        bui.append(" ,c.con_codigo ");
        ResultSet rs = Conexao.executeQuery(st, bui);
        ArrayList<Requisicao> requisicoes = new ArrayList<Requisicao>();
        while (rs.next()) {
            requisicoes.add(new Requisicao(rs.getInt("fil_kodigo"), rs.getInt("req_codigo"), rs.getBoolean("isRepasse")));
        }
        ArrayList<DadosTiss> listaRequisicoes = new ArrayList<DadosTiss>();
        return listaRequisicoes;
    }

    @Override
    public String configurar(JFrame parent, String xml) {
        String retorno = xml;
        ConfigurarBPA conf = new ConfigurarBPA(parent, this.getListaDadosAdicionais());
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.ok()) {
            retorno = this.criaXML(conf);
            config = this.parseDadosXML(retorno);
            if (conf.getArrayServicosClassificacao().size() > 0) {
                this.setListaDadosAdicionais(conf.getArrayServicosClassificacao().toArray());
            }
        }
        return retorno;
    }

    @Override
    public boolean solicitarDiretorioNoInicio() {
        return false;
    }

    @Override
    public String[] situacoesPermitidasExame(String xml) {
        return null;
    }

    @Override
    public boolean validarCasasDecimais() {
        return true;
    }

    @Override
    public String getCodificacaoArquivo() {
        return null;
    }

    @Override
    public void verificaErrosFatura(ArrayList<DadosFaturamento> requisicoes, Registro configuracaoConvenio) {
        if (requisicoes != null && requisicoes.size() > 0 && configuracaoConvenio != null) {
            for (int k = 0; k < requisicoes.size(); ++k) {
                DadosFaturamento requisicaoFaturada = requisicoes.get(k);
                if (requisicaoFaturada == null) continue;
                requisicaoFaturada.clearProblemas();
                if (!requisicaoFaturada.getFaturar()) continue;
                if (Funcoes.textoVazio(requisicaoFaturada.getEnderecoPaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.ENDERECO_PACIENTE, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getLogradouroPaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.LOGRADOURO, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getCepPaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CEP, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getCidadePaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CIDADE, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getBairroPaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.BAIRRO, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getNumeroEndereco())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.NUMERO_ENDERECO, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getCodigoIbge())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CODIGO_IBGE, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getCodigoCnesExecutante())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CODIGO_CNES, null, null));
                }
                if (Funcoes.textoVazio(StringUtil.getValor(requisicaoFaturada.getFaturaEletronica(), TAGCNSPROFISSIONAL))) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CNS_PROFISSIONAL, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getXmlCbo())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.CODIGO_CBO, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getNacionalidadePaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.NACIONALIDADE_PACIENTE, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getRacaCorPaciente())) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.RACA_COR_PACIENTE, null, null));
                }
                if (!Funcoes.textoVazio(requisicaoFaturada.getRacaCorPaciente()) && (requisicaoFaturada.getRacaCorPaciente().equals("O") || requisicaoFaturada.getRacaCorPaciente().equals("I"))) {
                    requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.RACA_COR_PACIENTE, null, null));
                }
                if (Funcoes.textoVazio(requisicaoFaturada.getRacaCorPaciente()) || !requisicaoFaturada.getRacaCorPaciente().equals("M") || !Funcoes.textoVazio(requisicaoFaturada.getEtniaPaciente())) continue;
                requisicaoFaturada.addProblema(new DetalhamentoErroFaturamento(ErrosFaturamento.ETNIA_PACIENTE, null, null));
            }
        }
    }

    @Override
    public ArrayList<GuiaVirtual.Campo> getCamposObrigatorios(String versao) {
        return null;
    }

    @Override
    public int[] getColunasObrigatoriasSolicitados() {
        return new int[]{0, 1, 2, 3, 4};
    }

    @Override
    public int[] getColunasObrigatoriasExecutados() {
        return new int[]{0, 1, 2, 3, 4};
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampo> getCamposIncorretos(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasSolicitados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroExame> getColunasIncorretasExecutados(DadosFaturamento requisicao, String guia) {
        return null;
    }

    @Override
    public Registro parseXMLConfiguracao(String xml) {
        if (xml == null || Funcoes.textoVazio(xml)) {
            return null;
        }
        Registro reg = new Registro();
        reg.setValor("protocolo", BPA.getNomeProtocolo());
        reg.setValor("anoProducao", StringUtil.getValor(xml, TAGANOPRODUCAO));
        reg.setValor("mesProducao", StringUtil.getValor(xml, TAGMESRODUCAO));
        reg.setValor("nomeDestino", StringUtil.getValor(xml, TAGNOMEDESTINO));
        reg.setValor("cnpjResponsavel", StringUtil.getValor(xml, TAGCNPJRESPONSAVEL));
        reg.setValor("nomeOrgaoOrigem", StringUtil.getValor(xml, TAGNOMEORGAOORIGEM));
        reg.setValor("siglaOrgaoOrigem", StringUtil.getValor(xml, TAGSIGLAORGAOORIGEM));
        reg.setValor("cnsProfissional", StringUtil.getValor(xml, TAGCNSPROFISSIONAL));
        reg.setValor(TAGCBOPADRAO, StringUtil.getValor(xml, TAGCBOPADRAO));
        reg.setValor(TAGCID10PADRAO, StringUtil.getValor(xml, TAGCID10PADRAO));
        reg.setValor("caraterAtendimento", StringUtil.getValor(xml, TAGCARATERATENDIMENTO));
        reg.setValor("orgaoDestino", StringUtil.getValor(xml, TAGORGAODESTINO));
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean gravaAlteracoes(DadosFaturamento requisicao, String guia, Registro configuracao) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        Object rs = null;
        try {
            if (this.temAtualizacao(requisicao)) {
                buf.setLength(0);
                buf.append(" update paciente set ");
                buf.append("     pac_endereco = ").append(StringUtil.textoDBEscape(requisicao.getEnderecoPaciente()));
                buf.append("    ,pac_tipologradouroendereco = ").append(StringUtil.textoDBEscape(requisicao.getLogradouroPaciente()));
                buf.append("    ,pac_cep = '").append(requisicao.getCepPaciente()).append("' ");
                buf.append("    ,bai_codigo = ").append(StringUtil.textoDBEscape(requisicao.getBairroPaciente()));
                buf.append("    ,cid_codigo = ").append(StringUtil.textoDBEscape(requisicao.getCidadePaciente()));
                buf.append("    ,pac_cartaosus = '").append(requisicao.getCnsPaciente()).append("' ");
                buf.append("    ,pac_numeroendereco = ").append(StringUtil.textoDBEscape(requisicao.getNumeroEndereco()));
                buf.append("    ,pac_complemento = ").append(StringUtil.textoDBEscape(requisicao.getComplementoEndereco()));
                buf.append("    ,nli_codigo = ").append(requisicao.getNacionalidadePaciente());
                buf.append("    ,pac_cor = ").append(StringUtil.textoDBEscape(requisicao.getRacaCorPaciente()));
                if (!Funcoes.textoVazio(requisicao.getEtniaPaciente())) {
                    buf.append("    ,ein_codigo = ").append(requisicao.getEtniaPaciente());
                }
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and pac_codigo = ").append(requisicao.getCodigoPaciente());
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            if (this.temAtualizacao(requisicao)) {
                buf.setLength(0);
                buf.append(" update cidades ");
                buf.append("    set cid_codigoibge = '").append(requisicao.getCodigoIbge()).append("' ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and cid_codigo = ").append(requisicao.getCidadePaciente());
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            if (this.temAtualizacao(requisicao)) {
                buf.setLength(0);
                buf.append(" update requisicao set ");
                buf.append(" req_cartaosus = '").append(requisicao.getCnsPaciente()).append("' ");
                buf.append("  where fil_codigo = ").append(requisicao.getCodigoFilial());
                buf.append("    and req_codigo = ").append(requisicao.getRequisicao());
                Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, buf.toString());
            }
            if (requisicao.getCodigoFilial() > 0) {
                for (int i = 0; i < requisicao.getExamesCount(); ++i) {
                    DadosExameFaturamento exame = requisicao.getExame(i);
                    buf.setLength(0);
                    String codigo = exame.getCodigoExame();
                    SalvaDados salvar = new SalvaDados("exames", 2);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("exa_codigo", 2, false, true, StringUtil.textoDBEscape(codigo));
                    salvar.adicionaCampo("exa_tipobpa", 0, false, false, StringUtil.textoDBEscape(exame.getTipoBPA()));
                    DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaExame());
                    Conexao.arquivaSQL();
                }
            }
            if (st == null) return true;
        }
        catch (Exception e) {
            boolean bl;
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar dados. " + e.getMessage(), e.getStackTrace());
                bl = false;
                if (st == null) return bl;
            }
            catch (Throwable throwable) {
                if (st == null) throw throwable;
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return true;
    }

    private boolean temAtualizacao(DadosFaturamento requisicao) {
        return requisicao.getCodigoFilial() > 0 && requisicao.getCodigoPaciente() > 0;
    }

    @Override
    public void preencheValoresCampos(DadosFaturamento requisicao, Registro configuracaoEletronico, String guia) {
        JanelaConfiguracaoFaturamentoBPA.codigoConvenio.setValor(Integer.toString(requisicao.getCodigoConvenio()));
        JanelaConfiguracaoFaturamentoBPA.descricaoConvenio.setValor(requisicao.getRazaoConvenioPrincipal());
        JanelaConfiguracaoFaturamentoBPA.codigoCNES.setValor(requisicao.getCodigoCnesExecutante());
        JanelaConfiguracaoFaturamentoBPA.cnpjResponsavel.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGCNPJRESPONSAVEL));
        JanelaConfiguracaoFaturamentoBPA.nomdeDestino.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGNOMEDESTINO));
        JanelaConfiguracaoFaturamentoBPA.caraterAtendimento.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGCARATERATENDIMENTO));
        JanelaConfiguracaoFaturamentoBPA.cnsProfissional.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGCNSPROFISSIONAL));
        JanelaConfiguracaoFaturamentoBPA.codigoCid10Convenio.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGCID10PADRAO));
        JanelaConfiguracaoFaturamentoBPA.nomeOrgaoOrigem.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGNOMEORGAOORIGEM));
        JanelaConfiguracaoFaturamentoBPA.siglaOrgaoOrigem.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGSIGLAORGAOORIGEM));
        JanelaConfiguracaoFaturamentoBPA.orgaoDestino.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGORGAODESTINO));
        JanelaConfiguracaoFaturamentoBPA.cboExecutante.setValor(StringUtil.getValor(requisicao.getFaturaEletronica(), TAGCBOPADRAO));
        JanelaConfiguracaoFaturamentoBPA.codigoRequisicao.setValor(Integer.toString(requisicao.getRequisicao()));
        JanelaConfiguracaoFaturamentoBPA.nomePaciente.setValor(requisicao.getNomePaciente());
        JanelaConfiguracaoFaturamentoBPA.nomeMedico.setValor(requisicao.getNomeMedico());
        JanelaConfiguracaoFaturamentoBPA.cboMedico.setValor(StringUtil.getValor(requisicao.getXmlCbo(), "codigo"));
        this.preencherRacaCorPaciente(requisicao);
        this.preencherEtniaPaciente(requisicao);
        this.preencherNacionalidadePaciente(requisicao);
        JanelaConfiguracaoFaturamentoBPA.lograudouroPaciente.setValor(Tipos.tipoLogradouroDescricao(requisicao.getLogradouroPaciente()));
        JanelaConfiguracaoFaturamentoBPA.lograudouroPaciente.setValor(Tipos.tipoLogradouroDescricao(requisicao.getLogradouroPaciente()));
        JanelaConfiguracaoFaturamentoBPA.enderecoPaciente.setValor(requisicao.getEnderecoPaciente());
        JanelaConfiguracaoFaturamentoBPA.numeroEndereco.setValor(requisicao.getNumeroEndereco());
        JanelaConfiguracaoFaturamentoBPA.complementoEndereco.setValor(requisicao.getComplementoEndereco());
        JanelaConfiguracaoFaturamentoBPA.bairroEnderecoDescricao.setValor(requisicao.getBairroPacienteDescricao());
        JanelaConfiguracaoFaturamentoBPA.bairroEndereco.setValor(requisicao.getBairroPaciente());
        JanelaConfiguracaoFaturamentoBPA.cidadeEndereco.setValor(requisicao.getCidadePaciente());
        JanelaConfiguracaoFaturamentoBPA.cidadeEnderecoDesc.setValor(requisicao.getCidadePacienteNome());
        JanelaConfiguracaoFaturamentoBPA.codigoIbge.setValor(requisicao.getCodigoIbge());
        JanelaConfiguracaoFaturamentoBPA.cepEndereco.setValor(requisicao.getCepPaciente());
        JanelaConfiguracaoFaturamentoBPA.codigoCnsPasciente.setValor(requisicao.getCnsPaciente());
    }

    private void preencherRacaCorPaciente(DadosFaturamento requisicao) {
        RacaCorPaciente rcp = RacaCorPaciente.NAO_INFORMADO;
        String codRacaCor = requisicao.getRacaCorPaciente();
        if (!Funcoes.textoVazio(codRacaCor)) {
            rcp = RacaCorPaciente.getRacaCorPorCodigo(codRacaCor);
        }
        boolean racaCorNaoInformada = rcp.equals((Object)RacaCorPaciente.OUTRO) || rcp.equals((Object)RacaCorPaciente.NAO_INFORMADO);
        JanelaConfiguracaoFaturamentoBPA.racaCorPaciente.setValor(rcp.toString());
        JanelaConfiguracaoFaturamentoBPA.racaCorPaciente.setEnabled(racaCorNaoInformada);
    }

    private void preencherEtniaPaciente(DadosFaturamento requisicao) {
        String codEtnia = requisicao.getEtniaPaciente();
        String descricaoEtnia = requisicao.getEtniaDescricao();
        String codRacaCor = requisicao.getRacaCorPaciente();
        RacaCorPaciente rcp = RacaCorPaciente.NAO_INFORMADO;
        if (!Funcoes.textoVazio(codRacaCor)) {
            rcp = RacaCorPaciente.getRacaCorPorCodigo(codRacaCor);
        }
        JanelaConfiguracaoFaturamentoBPA.etniaPaciente.setValor(codEtnia);
        JanelaConfiguracaoFaturamentoBPA.etniaPacienteDesc.setValor(descricaoEtnia);
        if (rcp.equals((Object)RacaCorPaciente.INDIGENA) && !Funcoes.textoVazio(codEtnia) && !Funcoes.textoVazio(descricaoEtnia)) {
            JanelaConfiguracaoFaturamentoBPA.etniaPacienteDesc.setEnabled(false);
        }
    }

    private void preencherNacionalidadePaciente(DadosFaturamento requisicao) {
        String nacionalidade = requisicao.getNacionalidadePaciente();
        String descricaoNacionalidade = requisicao.getNacionalidadeDescricao();
        JanelaConfiguracaoFaturamentoBPA.nacionalidadePaciente.setValor(nacionalidade);
        JanelaConfiguracaoFaturamentoBPA.nacionalidadePacienteDesc.setValor(descricaoNacionalidade);
        JanelaConfiguracaoFaturamentoBPA.nacionalidadePaciente.setEnabled(Funcoes.textoVazio(nacionalidade));
        JanelaConfiguracaoFaturamentoBPA.nacionalidadePacienteDesc.setEnabled(Funcoes.textoVazio(descricaoNacionalidade));
    }

    @Override
    public void preencheValoresTabelas(DadosFaturamento requisicao, String guia) {
        if (requisicao != null) {
            JanelaConfiguracaoFaturamentoBPA.procedimentos.clear();
            boolean isAgruparAmb = requisicao.getAgruparAmb();
            LinkedHashMap<String, Object[]> listaExames = new LinkedHashMap<String, Object[]>();
            for (int i = 0; i < requisicao.getExamesCount(); ++i) {
                DadosExameFaturamento exame = requisicao.getExame(i);
                if (isAgruparAmb) {
                    Object obj = null;
                    Object v = listaExames.get(exame.getCodigoAMB());
                    obj = v;
                    if (v != null) {
                        Object[] linha;
                        if (!(obj instanceof Object[]) || (linha = (Object[])obj) == null) continue;
                        linha[2] = linha[2] + ", " + exame.getNomeExame();
                        linha[3] = Integer.parseInt(linha[3].toString()) + 1;
                        linha[4] = (Double)linha[4] + exame.getValorTotalExame().doubleValue();
                        linha[5] = ArraysUtil.concatenar((DadosExameFaturamento[])linha[5], new DadosExameFaturamento[]{exame});
                        continue;
                    }
                    listaExames.put(exame.getCodigoAMB(), new Object[]{exame.getDataExame(), requisicao.getTipoTabela(), exame.getNomeExame(), 1, exame.getValorTotalExame().doubleValue(), new DadosExameFaturamento[]{exame}});
                    continue;
                }
                String exameTipoBPA = Funcoes.textoVazio(exame.getTipoBPA()) ? "I" : exame.getTipoBPA();
                boolean exameBPAIndividualizado = exameTipoBPA.equalsIgnoreCase("I");
                boolean exameBPAConsolidado = exameTipoBPA.equalsIgnoreCase("C");
                JanelaConfiguracaoFaturamentoBPA.procedimentos.addLinha(new Object[]{exame.getCodigoAMB(), exame.getNomeExame(), exameBPAIndividualizado, exameBPAConsolidado, exame});
            }
        }
    }

    @Override
    public void getValoresPreenchidos(DadosFaturamento requisicao, ArrayList<DadosExameFaturamento> exames, Registro configuracaoEletronico) {
        try {
            Object logradouroPaciente = JanelaConfiguracaoFaturamentoBPA.lograudouroPaciente.getValor();
            if (logradouroPaciente != null) {
                requisicao.setLogradouroPaciente(Tipos.tipoLogradouro(logradouroPaciente.toString()));
            } else {
                requisicao.setLogradouroPaciente("");
            }
            Object enderecoPaciente = JanelaConfiguracaoFaturamentoBPA.enderecoPaciente.getValor();
            if (enderecoPaciente != null) {
                requisicao.setEnderecoPaciente(enderecoPaciente.toString());
            } else {
                requisicao.setEnderecoPaciente("");
            }
            Object cidadeEndereco = JanelaConfiguracaoFaturamentoBPA.cidadeEndereco.getValor();
            if (cidadeEndereco != null) {
                requisicao.setCidadePaciente(cidadeEndereco.toString());
                requisicao.setCidadePacienteNome(JanelaConfiguracaoFaturamentoBPA.cidadeEnderecoDesc.getValor().toString());
            } else {
                requisicao.setCidadePaciente("");
                requisicao.setCidadePacienteNome("");
            }
            Object bairroEndereco = JanelaConfiguracaoFaturamentoBPA.bairroEndereco.getValor();
            if (bairroEndereco != null) {
                requisicao.setBairroPaciente(bairroEndereco.toString());
                requisicao.setBairroPacienteDescricao("");
            } else {
                requisicao.setBairroPaciente(null);
                requisicao.setBairroPacienteDescricao("");
            }
            Object numeroEndereco = JanelaConfiguracaoFaturamentoBPA.numeroEndereco.getValor();
            if (numeroEndereco != null) {
                requisicao.setNumeroEndereco(numeroEndereco.toString());
            } else {
                requisicao.setNumeroEndereco("");
            }
            Object cepEndereco = JanelaConfiguracaoFaturamentoBPA.cepEndereco.getValor();
            if (cepEndereco != null) {
                requisicao.setCepPaciente(cepEndereco.toString());
            } else {
                requisicao.setCepPaciente("");
            }
            Object codigoIbge = JanelaConfiguracaoFaturamentoBPA.codigoIbge.getValor();
            if (codigoIbge != null) {
                requisicao.setCodigoIbge(codigoIbge.toString());
            } else {
                requisicao.setCodigoIbge("");
            }
            Object codigoCnsDoPaciente = JanelaConfiguracaoFaturamentoBPA.codigoCnsPasciente.getValor();
            if (codigoCnsDoPaciente != null) {
                requisicao.setCnsPaciente(codigoCnsDoPaciente.toString());
            } else {
                requisicao.setCnsPaciente("");
            }
            Object complementoEndPaciente = JanelaConfiguracaoFaturamentoBPA.complementoEndereco.getValor();
            if (complementoEndPaciente != null) {
                requisicao.setComplementoEndereco(complementoEndPaciente.toString());
            } else {
                requisicao.setComplementoEndereco("");
            }
            RacaCorPaciente racaCorPaciente = (RacaCorPaciente)((Object)JanelaConfiguracaoFaturamentoBPA.racaCorPaciente.getValor());
            requisicao.setRacaCorPaciente(racaCorPaciente != null ? racaCorPaciente.getCodigo() : RacaCorPaciente.NAO_INFORMADO.getCodigo());
            Object etniaPaciente = JanelaConfiguracaoFaturamentoBPA.etniaPaciente.getValor();
            if (etniaPaciente != null) {
                requisicao.setEtniaPaciente(etniaPaciente.toString());
                requisicao.setEtniaDescricao(JanelaConfiguracaoFaturamentoBPA.etniaPacienteDesc.getValor().toString());
            } else {
                requisicao.setEtniaPaciente("");
                requisicao.setEtniaDescricao("");
            }
            Object nacionalidadePaciente = JanelaConfiguracaoFaturamentoBPA.nacionalidadePaciente.getValor();
            if (nacionalidadePaciente != null) {
                requisicao.setNacionalidadePaciente(nacionalidadePaciente.toString());
                requisicao.setNacionalidadeDescricao(JanelaConfiguracaoFaturamentoBPA.nacionalidadePacienteDesc.getValor().toString());
            } else {
                requisicao.setNacionalidadePaciente("");
                requisicao.setNacionalidadeDescricao("");
            }
            requisicao.setExames(exames);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), e.getMessage(), 2);
        }
    }

    @Override
    public void aplicarModificacoesGerais(ArrayList<DadosFaturamento> requisicoes, DadosFaturamento requisicao, DadosFaturamento requisicaoModificada, Registro configuracaoEletronico, Registro configuracaoEletronicoModificada) {
        if (requisicoes == null || requisicao == null || requisicaoModificada == null || configuracaoEletronico == null || configuracaoEletronicoModificada == null) {
            return;
        }
        for (int i = 0; i < requisicoes.size(); ++i) {
            DadosFaturamento requisicaoAux = requisicoes.get(i);
            if (requisicaoAux == requisicaoModificada || requisicao.getCodigoPaciente() != requisicaoAux.getCodigoPaciente()) continue;
            requisicaoAux.setLogradouroPaciente(requisicaoModificada.getLogradouroPaciente());
            requisicaoAux.setEnderecoPaciente(requisicaoModificada.getEnderecoPaciente());
            requisicaoAux.setNumeroEndereco(requisicaoModificada.getNumeroEndereco());
            requisicaoAux.setBairroPaciente(requisicaoModificada.getBairroPaciente());
            requisicaoAux.setCidadePaciente(requisicaoModificada.getCidadePaciente());
            requisicaoAux.setComplementoEndereco(requisicaoModificada.getComplementoEndereco());
            requisicaoAux.setCodigoIbge(requisicaoModificada.getCodigoIbge());
            requisicaoAux.setCepPaciente(requisicaoModificada.getCepPaciente());
            requisicaoAux.setCnsPaciente(requisicaoModificada.getCnsPaciente());
        }
    }

    private Registro parseDadosXML(String xml) {
        if (xml == null || Funcoes.textoVazio(xml)) {
            return null;
        }
        Registro reg = new Registro();
        reg.setValor("protocolo", BPA.getNomeProtocolo());
        reg.setValor("anoProducao", StringUtil.getValor(xml, TAGANOPRODUCAO));
        reg.setValor("mesProducao", StringUtil.getValor(xml, TAGMESRODUCAO));
        reg.setValor("nomeDestino", StringUtil.getValor(xml, TAGNOMEDESTINO));
        reg.setValor("cnpjResponsavel", StringUtil.getValor(xml, TAGCNPJRESPONSAVEL));
        reg.setValor("nomeOrgaoOrigem", StringUtil.getValor(xml, TAGNOMEORGAOORIGEM));
        reg.setValor("siglaOrgaoOrigem", StringUtil.getValor(xml, TAGSIGLAORGAOORIGEM));
        reg.setValor("cnsProfissional", StringUtil.getValor(xml, TAGCNSPROFISSIONAL));
        reg.setValor(TAGCBOPADRAO, StringUtil.getValor(xml, TAGCBOPADRAO));
        reg.setValor(TAGCID10PADRAO, StringUtil.getValor(xml, TAGCID10PADRAO));
        reg.setValor("caraterAtendimento", StringUtil.getValor(xml, TAGCARATERATENDIMENTO));
        reg.setValor("orgaoDestino", StringUtil.getValor(xml, TAGORGAODESTINO));
        reg.setValor("consideraCBOExecutante", StringUtil.getValor(xml, TAGIGNORARCOBOSMEDICO));
        return reg;
    }

    private String criaXML(ConfigurarBPA r) {
        boolean seq = false;
        if (r == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder("<faturamentoEletronico>");
        buf.append("<protocolo>").append(BPA.getNomeProtocolo()).append("</protocolo>");
        buf.append("<NomeDestino>").append(r.getTextNomeDestino()).append("</NomeDestino>");
        buf.append("<NomeOrgaoOrigem>").append(r.getTextNomeOrgaoOrigem()).append("</NomeOrgaoOrigem>");
        buf.append("<SiglaOrgaoOrigem>").append(r.getTextSiglaOrgaoOrigem()).append("</SiglaOrgaoOrigem>");
        buf.append("<CnpjResponsavel>").append(r.getTextCNPJResponsavel()).append("</CnpjResponsavel>");
        buf.append("<AnoProducao>").append(r.getTextAnoProducao()).append("</AnoProducao>");
        buf.append("<MesProducao>").append(r.getTextMesProducao()).append("</MesProducao>");
        buf.append("<CnsProfissional>").append(r.getTextCnsProfissional()).append("</CnsProfissional>");
        buf.append("<CBOPadrao>").append(r.getTextCBOPadrao()).append("</CBOPadrao>");
        buf.append("<CID10Padrao>").append(r.getTextCID10Padrao()).append("</CID10Padrao>");
        buf.append("<CaraterAtendimento>").append(r.getComboCaraterAtendimento().getSelectedIndex()).append("</CaraterAtendimento>");
        buf.append("<OrgaoDestino>").append(r.getComboOrgaoDestino().getSelectedItem()).append("</OrgaoDestino>");
        buf.append("<ConsideraCBOExecutante>").append(Funcoes.booleanToString(r.getCheckIgnorarCBOSMedico().isSelected())).append("</ConsideraCBOExecutante>");
        buf.append("</faturamentoEletronico>");
        return buf.toString();
    }

    @Override
    public Object[] getListaDadosAdicionais() {
        return this.listaServicosClassificacao;
    }

    @Override
    public void setListaDadosAdicionais(Object[] listaDadosAdicionais) {
        this.listaServicosClassificacao = listaDadosAdicionais;
    }

    @Override
    public ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> getCamposIncorretosBPA(DadosFaturamento requisicao, String guia) {
        ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA> lista = new ArrayList<AbstractFaturamentoEletronico.ErroCampoBPA>();
        for (int i = 0; i < requisicao.getListaProblemas().size(); ++i) {
            DetalhamentoErroFaturamento erro = requisicao.getListaProblemas().get(i);
            int codigoErro = erro.getErro().getCodigoErro();
            if (codigoErro == ErrosFaturamento.ENDERECO_PACIENTE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.enderecoPaciente, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.LOGRADOURO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.lograudouroPaciente, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CIDADE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.cidadeEnderecoDesc, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.BAIRRO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.bairroEnderecoDescricao, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CEP.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.cepEndereco, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.NUMERO_ENDERECO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.numeroEndereco, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CODIGO_IBGE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.codigoIbge, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CODIGO_CNES.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.codigoCNES, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CODIGO_CBO.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.cboExecutante, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.CNS_PROFISSIONAL.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.cnsProfissional, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.RACA_COR_PACIENTE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.racaCorPaciente, erro));
                continue;
            }
            if (codigoErro == ErrosFaturamento.ETNIA_PACIENTE.getCodigoErro()) {
                lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.etniaPacienteDesc, erro));
                continue;
            }
            if (codigoErro != ErrosFaturamento.NACIONALIDADE_PACIENTE.getCodigoErro()) continue;
            lista.add(new AbstractFaturamentoEletronico.ErroCampoBPA(JanelaConfiguracaoFaturamentoBPA.nacionalidadePacienteDesc, erro));
        }
        return lista.size() > 0 ? lista : null;
    }

    @Override
    public ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> getCamposObrigatoriosBPA() {
        ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA> campos = new ArrayList<JanelaConfiguracaoFaturamentoBPA.CampoBPA>();
        campos.add(JanelaConfiguracaoFaturamentoBPA.enderecoPaciente);
        campos.add(JanelaConfiguracaoFaturamentoBPA.lograudouroPaciente);
        campos.add(JanelaConfiguracaoFaturamentoBPA.bairroEnderecoDescricao);
        campos.add(JanelaConfiguracaoFaturamentoBPA.cidadeEnderecoDesc);
        campos.add(JanelaConfiguracaoFaturamentoBPA.numeroEndereco);
        campos.add(JanelaConfiguracaoFaturamentoBPA.codigoIbge);
        campos.add(JanelaConfiguracaoFaturamentoBPA.codigoCnsPasciente);
        campos.add(JanelaConfiguracaoFaturamentoBPA.cepEndereco);
        campos.add(JanelaConfiguracaoFaturamentoBPA.bairroEnderecoDescricao);
        campos.add(JanelaConfiguracaoFaturamentoBPA.bairroEndereco);
        campos.add(JanelaConfiguracaoFaturamentoBPA.racaCorPaciente);
        campos.add(JanelaConfiguracaoFaturamentoBPA.etniaPaciente);
        campos.add(JanelaConfiguracaoFaturamentoBPA.etniaPacienteDesc);
        campos.add(JanelaConfiguracaoFaturamentoBPA.nacionalidadePaciente);
        campos.add(JanelaConfiguracaoFaturamentoBPA.nacionalidadePacienteDesc);
        return campos;
    }

    static {
        config = new Registro();
        CARATER_ATENDIMENTO = new String[]{"- SEM INFORMA\u00c7\u00c3O", "1 - ELETIVO", "2 - URG\u00caNCIA", "3 - ACIDENTE NO LOCAL DE TRABALHO OU A SERVI\u00c7O DA EMPRESA", "4 - ACIDENTE NO TRAJETO PARA O TRABALHO", "5 - OUTROS TIPOS DE ACIDENTES DE TR\u00c2NSITO", "6 - OUTROS TIPOS DE LES\u00d5ES E EVEN. POR AGENTES QU\u00cdMICOS OU F\u00cdSICOS"};
    }

    private static enum ErrosFaturamento implements AbstractErroFaturamento
    {
        ENDERECO_PACIENTE(1, "Endere\u00e7o do paciente n\u00e3o informado."),
        LOGRADOURO(2, "Logradouro do paciente n\u00e3o informado."),
        NUMERO_ENDERECO(3, "N\u00famero do endere\u00e7o do paciente n\u00e3o informado."),
        BAIRRO(4, "Bairro do paciente n\u00e3o informado."),
        CEP(5, "CEP do paciente n\u00e3o informado."),
        CIDADE(6, "Cidade do paciente n\u00e3o informada."),
        CODIGO_IBGE(7, "C\u00f3digo IBGE da Cidade/Munic\u00edpio n\u00e3o informado."),
        CNS_PROFISSIONAL(8, "CNS Profissional n\u00e3o informado na configura\u00e7\u00e3o BPA."),
        CNS_PACIENTE(9, "CNS do paciente n\u00e3o informado"),
        CODIGO_CNES(10, "CNES n\u00e3o informado na Filial."),
        CODIGO_CBO(11, "CBO do profissional n\u00e3o informado."),
        RACA_COR_PACIENTE(12, "Ra\u00e7a/cor do paciente n\u00e3o informado"),
        ETNIA_PACIENTE(13, "Etnia do paciente ind\u00edgena n\u00e3o informada"),
        NACIONALIDADE_PACIENTE(14, "Nacionalidade do paciente n\u00e3o informada");

        private int codigoErro = 0;
        private String descricao = null;

        private ErrosFaturamento(Integer codigoErro, String descricao) {
            this.codigoErro = codigoErro;
            this.descricao = descricao;
        }

        @Override
        public String toString() {
            return this.descricao;
        }

        @Override
        public int getCodigoErro() {
            return this.codigoErro;
        }
    }
}

