/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.util.faturamento.LinhasRemovidasListener;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class LinhasTabela
extends DefaultTableModel {
    private ArrayList linhas;
    private ArrayList<LinhasRemovidasListener> removidasListener = new ArrayList();

    public LinhasTabela() {
        this.linhas = new ArrayList();
    }

    @Override
    public int getRowCount() {
        if (this.linhas != null) {
            return this.linhas.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.linhas.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof DadosFaturamento) {
            this.linhas.set(rowIndex, aValue);
        }
    }

    public void adicionaLinha(Object dados) {
        if (dados != null) {
            this.linhas.add(dados);
        }
    }

    public void removeLinha(int linha) {
        if (this.linhas != null && this.linhas.size() - 1 >= linha) {
            this.linhas.remove(linha);
            this.fireLinhasRemovidas();
        }
    }

    public void addLinhasRemovidasListener(LinhasRemovidasListener l) {
        if (!this.removidasListener.contains(l)) {
            this.removidasListener.add(l);
        }
    }

    public void removeLinhasRemovidasListener(LinhasRemovidasListener l) {
        if (this.removidasListener.contains(l)) {
            this.removidasListener.remove(l);
        }
    }

    private void fireLinhasRemovidas() {
        for (LinhasRemovidasListener l : this.removidasListener) {
            l.linhaRemovida();
        }
    }

    public void removeListenerLinhasRemovidas() {
        this.removidasListener.clear();
    }
}

