/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.model.enums.EnumTipoRateio;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.table.TableModel;

public class ImprimirResumoFatura {
    private static final String SELECT;
    private static final String GROUP_BY;
    public static String[] CAMPOS;

    public static void imprimir(int codigoFatura, int convenio) throws SQLException {
        ImprimirResumoFatura.imprimir(codigoFatura, convenio, false);
    }

    private static boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    public static void imprimir(int codigoFatura, int convenio, boolean exibirModal) throws SQLException {
        StringBuilder buf = new StringBuilder(SELECT);
        buf.append(" where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.fat_codigo = ");
        buf.append(String.valueOf(codigoFatura));
        buf.append(" and a.fat_datacancelamento is null ");
        buf.append(GROUP_BY);
        buf.append(" order by a.fil_codigo, ");
        if (ImprimirResumoFatura.isAlimentos()) {
            buf.append("set.set_tipoalimentos,");
        }
        buf.append("exm.exa_descricao ");
        Statement st = Conexao.getStatement();
        StringBuilder sb = new StringBuilder();
        sb.append("select con_ordemfatura, con_viasfatura, con_faturaeletronica from convenios where fil_codigo = ");
        sb.append(Variaveis.filialPadrao);
        sb.append(" and con_codigo = ");
        sb.append(convenio);
        ResultSet rsOrdem = Conexao.executeQuery(st, sb.toString());
        int qtdeCopias = 1;
        String ordemFatura = "R";
        if (rsOrdem.next()) {
            qtdeCopias = DBUtil.campoNull(rsOrdem.getString("con_viasfatura")) ? 1 : rsOrdem.getInt("con_viasfatura");
            ordemFatura = rsOrdem.getString("con_ordemfatura");
        }
        System.gc();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            ModeloGridTable modeloDados = new ModeloGridTable(CAMPOS);
            String xmlFatura = ImprimirResumoFatura.buscaFaturaEletronicaDoConvenio(convenio);
            String protocolo = StringUtil.getValor(xmlFatura, "protocolo");
            String cnpjIpergs = StringUtil.getValor(xmlFatura, "cnpjFilial");
            int qtdeMicrobiologica = 0;
            int qtdeFisicoQuimico = 0;
            int qtdeOutros = 0;
            int qtdeCromatografia = 0;
            BigDecimal totalMicrobiologica = BigDecimal.ZERO;
            BigDecimal totalFiscoQuimico = BigDecimal.ZERO;
            BigDecimal totalOutros = BigDecimal.ZERO;
            BigDecimal totalCromatografia = BigDecimal.ZERO;
            do {
                modeloDados.addLine(new Object[CAMPOS.length]);
                for (String campo : CAMPOS) {
                    int coluna = -1;
                    if (!ImprimirResumoFatura.achaColuna(rs, campo) || (coluna = modeloDados.findColumn(campo)) <= -1) continue;
                    if (modeloDados.getColumnName(coluna).equalsIgnoreCase("tipoLogradouroConvenio") || modeloDados.getColumnName(coluna).equalsIgnoreCase("tipoLogradouroCobrancaConvenio")) {
                        modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(campo)), modeloDados.getRowCount() - 1, coluna);
                    }
                    if (modeloDados.getColumnName(coluna).equalsIgnoreCase("cnpjFilial")) {
                        if (!Funcoes.textoVazio(protocolo)) {
                            if (!Funcoes.textoVazio(cnpjIpergs) && protocolo.equalsIgnoreCase("IPERGS")) {
                                modeloDados.setValueAt(cnpjIpergs, modeloDados.getRowCount() - 1, coluna);
                            } else {
                                modeloDados.setValueAt(rs.getString(campo), modeloDados.getRowCount() - 1, coluna);
                            }
                        } else {
                            modeloDados.setValueAt(rs.getObject(campo), modeloDados.getRowCount() - 1, coluna);
                        }
                    } else {
                        modeloDados.setValueAt(rs.getObject(campo), modeloDados.getRowCount() - 1, coluna);
                    }
                    if (!ImprimirResumoFatura.isOrdenaSetorAlimentos(ordemFatura)) continue;
                    if (EnumTipoRateio.isMicrobiologico(rs.getString("tipoSetor"))) {
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalMicrobiologia")) {
                            qtdeMicrobiologica += rs.getInt("quantidadeexame");
                            continue;
                        }
                        if (!modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalMicrobiologia")) continue;
                        totalMicrobiologica = totalMicrobiologica.add(rs.getBigDecimal("valorTotalExamesRequisicao"));
                        continue;
                    }
                    if (EnumTipoRateio.isFisicoQuimico(rs.getString("tipoSetor"))) {
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalFisicoQuimico")) {
                            qtdeFisicoQuimico += rs.getInt("quantidadeexame");
                            continue;
                        }
                        if (!modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalFisicoQuimico")) continue;
                        totalFiscoQuimico = totalFiscoQuimico.add(rs.getBigDecimal("valorTotalExamesRequisicao"));
                        continue;
                    }
                    if (EnumTipoRateio.isOutros(rs.getString("tipoSetor"))) {
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalOutros")) {
                            qtdeOutros += rs.getInt("quantidadeexame");
                            continue;
                        }
                        if (!modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalOutros")) continue;
                        totalOutros = totalOutros.add(rs.getBigDecimal("valorTotalExamesRequisicao"));
                        continue;
                    }
                    if (!EnumTipoRateio.isCromatografia(rs.getString("tipoSetor"))) continue;
                    if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalCromatografia")) {
                        qtdeCromatografia += rs.getInt("quantidadeexame");
                        continue;
                    }
                    if (!modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalCromatografia")) continue;
                    totalCromatografia = totalCromatografia.add(rs.getBigDecimal("valorTotalExamesRequisicao"));
                }
            } while (rs.next());
            if (ImprimirResumoFatura.isOrdenaSetorAlimentos(ordemFatura)) {
                String tipoRateio = "";
                for (int j = 0; j < modeloDados.getRowCount(); ++j) {
                    for (String campo : CAMPOS) {
                        int coluna = -1;
                        if (!ImprimirResumoFatura.achaColuna(rs, campo) || (coluna = modeloDados.findColumn(campo)) <= -1) continue;
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("tipoSetor")) {
                            tipoRateio = (String)modeloDados.getValueAt(j, coluna);
                        }
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalMicrobiologia")) {
                            modeloDados.setValueAt(qtdeMicrobiologica, modeloDados.getRowCount() - 1, coluna);
                        } else if (modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalMicrobiologia")) {
                            modeloDados.setValueAt(totalMicrobiologica, j, coluna);
                        }
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalFisicoQuimico")) {
                            modeloDados.setValueAt(qtdeFisicoQuimico, j, coluna);
                        } else if (modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalFisicoQuimico")) {
                            modeloDados.setValueAt(totalFiscoQuimico, j, coluna);
                        }
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalOutros")) {
                            modeloDados.setValueAt(qtdeOutros, j, coluna);
                        } else if (modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalOutros")) {
                            modeloDados.setValueAt(totalOutros, j, coluna);
                        }
                        if (modeloDados.getColumnName(coluna).equalsIgnoreCase("quantidadeTotalCromatografia")) {
                            modeloDados.setValueAt(qtdeCromatografia, j, coluna);
                            continue;
                        }
                        if (!modeloDados.getColumnName(coluna).equalsIgnoreCase("valorTotalCromatografia")) continue;
                        modeloDados.setValueAt(totalCromatografia, j, coluna);
                    }
                }
            }
            Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
            gerador.setPreVisualizar(true);
            gerador.setCopias(qtdeCopias);
            gerador.setImpressora(ParametrosLocais.getParametro("impressoraFatura"));
            buf.delete(0, buf.length());
            buf.append("select con_modeloresumo from convenios where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and con_codigo = ");
            buf.append(String.valueOf(convenio));
            ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
            System.gc();
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("con_modeloresumo"))) {
                gerador.executar(rsLayout.getString("con_modeloresumo"), (TableModel)modeloDados, exibirModal);
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
        }
        rs.close();
        Conexao.fecharStatement(st);
    }

    private static boolean isOrdenaSetorAlimentos(String ordemFatura) {
        return ImprimirResumoFatura.isAlimentos() && ImprimirResumoFatura.isTipoSetorRequisicao(ordemFatura);
    }

    private static boolean isTipoSetorRequisicao(String ordemFatura) {
        return ordemFatura.equals("S");
    }

    private static String buscaFaturaEletronicaDoConvenio(int convenio) {
        StringBuffer sql = new StringBuffer();
        sql.append("select con_faturaeletronica from convenios ");
        sql.append("where con_codigo = ");
        sql.append(convenio);
        sql.append(" and fil_codigo = ");
        sql.append(Variaveis.filialPadrao);
        String result = null;
        Statement st = null;
        try {
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                result = rs.getString("con_faturaeletronica");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean achaColuna(ResultSet result, String coluna) {
        if (result != null) {
            try {
                if (result.findColumn(coluna) > 0) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    static {
        CAMPOS = new String[]{"codigoUsuarioFatura", "nomeUsuarioFatura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeCobrancaConvenio", "descricaoCidadeCobrancaConvenio", "estadoCidadeCobrancaConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroCobrancaConvenio", "descricaoBairroCobrancaConvenio", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxfilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "cnpjConvenio", "inscricaoConvenio", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "enderecoCobrancaConvenio", "complementoCobrancaConvenio", "cepCobrancaConvenio", "codigoExame", "descricaoExame", "ambExameMaterial", "ambExame", "cbhpmExame", "chExame", "valorExame", "valorMateriaisExame", "custoCBHPMExame", "UCOCBHPMExame", "porteCBHPMExame", "valorPorteCBHPMExame", "ambTabelaPreco", "codigoFatura", "dataInicioFatura", "dataFinalFatura", "dataEmissaoFatura", "dataVencimentoFatura", "mensagemFatura", "valorAdicionalFatura", "valorDespesaCobrancaFatura", "percentualDescontoFatura", "percentualAcrescimoFatura", "totalMateriaisFatura", "totalCHFatura", "totalExamesFatura", "quantidadeExamesFatura", "quantidadeRequisicoesFatura", "numeroNotaFiscal", "dataEmissaoNotaFiscal", "quantidadeExame", "valorTotalExamesRequisicao", "valorTotalMateriaisRequisicao", "valorTotalExamesCHRequisicao", "ceiConvenio", "quantidadeGuiasFatura"};
        if (ImprimirResumoFatura.isAlimentos()) {
            CAMPOS = ArraysUtil.concatenar(CAMPOS, new String[]{"tipoSetor", "quantidadeTotalFisicoQuimico", "valorTotalFisicoQuimico", "quantidadeTotalMicrobiologia", "valorTotalMicrobiologia", "quantidadeTotalOutros", "valorTotalOutros", "quantidadeTotalCromatografia", "valorTotalCromatografia"});
        }
        StringBuilder buf = new StringBuilder("select ");
        buf.append("count(c.exa_codfilho) as quantidadeExame, ");
        buf.append("sum(c.fer_total) as valorTotalExamesRequisicao,  ");
        buf.append("sum(c.fer_totalmateriais) as valorTotalMateriaisRequisicao, ");
        buf.append("sum(c.fer_totalch) as valorTotalExamesCHRequisicao,  ");
        buf.append("usrfatura.usr_codigo as codigoUsuarioFatura, usrfatura.usr_nome as nomeUsuarioFatura, ");
        buf.append("cidcon.cid_codigo as codigoCidadeConvenio, cidcon.cid_nome as descricaoCidadeConvenio, cidcon.cid_uf as estadoCidadeConvenio, ");
        buf.append("cidcobcon.cid_codigo as codigoCidadeCobrancaConvenio, cidcobcon.cid_nome as descricaoCidadeCobrancaConvenio, cidcobcon.cid_uf as estadoCidadeCobrancaConvenio, ");
        buf.append("baicon.bai_codigo as codigoBairroConvenio, baicon.bai_descricao as descricaoBairroConvenio,  ");
        buf.append("baicobcon.bai_codigo as codigoBairroCobrancaConvenio, baicobcon.bai_descricao as descricaoBairroCobrancaConvenio, ");
        buf.append("a.fil_codigo as codigoFilial, f.fil_descricao as descricaoFilial, f.fil_cnpj as cnpjFilial,  ");
        buf.append("f.fil_endereco as enderecoFilial, f.fil_complemento as complementoFilial, f.fil_cep as cepFilial, ");
        buf.append("f.fil_fone as foneFilial, f.fil_fax as faxFilial, f.fil_razaosocial as razaoSocialFilial,  ");
        buf.append("cidfil.cid_codigo as codigoCidadeFilial, cidfil.cid_nome as descricaoCidadeFilial, cidfil.cid_uf as estadoCidadeFilial, ");
        buf.append("baifil.bai_codigo as codigoBairroFilial, baifil.bai_descricao as descricaoBairroFilial,  ");
        buf.append("conv.con_codigo as codigoConvenio, conv.con_fantasia as fantasiaConvenio, conv.con_razao as razaoSocialConvenio, ");
        buf.append("conv.con_endereco as enderecoConvenio, conv.con_numeroendereco as numeroEnderecoConvenio, conv.con_complemento as complementoConvenio, conv.con_cep as cepConvenio,  ");
        buf.append("conv.con_cnpjcpf as cnpjConvenio, conv.con_inscrest as inscricaoConvenio,  ");
        buf.append("conv.con_endcobranca as enderecoCobrancaConvenio, conv.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, conv.con_complcobranca as complementoCobrancaConvenio, conv.con_cepcobranca as cepCobrancaConvenio, ");
        buf.append("conv.con_tipologradouroendereco as tipoLogradouroConvenio, conv.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
        buf.append("conv.con_fone as foneConvenio, conv.con_email1 as email1Convenio, conv.con_email2 as email2Convenio, conv.con_site as siteConvenio,  ");
        buf.append("a.fat_codigo as codigoFatura,  ");
        buf.append("c.exa_codfilho as codigoExame, exm.exa_descricao as descricaoExame, ");
        buf.append("emc.emc_codigocbhpm as cbhpmExame, emc.emc_codigoamb as ambExameMaterial,  ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), preco.dtp_codamb) as ambTabelaPreco, ");
            buf.append("COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), preco.dtp_codamb) as ambExame, ");
        } else {
            buf.append("preco.dtp_codamb as ambTabelaPreco, ");
            buf.append("preco.dtp_codamb as ambExame, ");
        }
        buf.append("a.fat_dtinicio as dataInicioFatura, a.fat_dtfim as dataFinalFatura, a.fat_dtemis as dataEmissaoFatura, a.fat_dtvenc as dataVencimentoFatura, ");
        buf.append("a.fat_adicional as valorAdicionalFatura, a.fat_despcobranca as valorDespesaCobrancaFatura,  ");
        buf.append("a.fat_percdesconto as percentualDescontoFatura, a.fat_totalmateriais as totalMateriaisFatura,  ");
        buf.append("a.fat_percacrescimo as percentualAcrescimoFatura,  ");
        buf.append("a.fat_totalexamesch as totalCHFatura, a.fat_totalexames as totalExamesFatura, a.fat_mensagem as mensagemFatura, ");
        buf.append("a.fat_qtdeexames as quantidadeExamesFatura, a.fat_qtderequisicao as quantidadeRequisicoesFatura,  a.fat_qtdeguias as quantidadeGuiasFatura, ");
        if (ImprimirResumoFatura.isAlimentos()) {
            buf.append("pal.pal_codigo as codigoProdutoAlimento, ");
            buf.append("pal.pal_descricao as descricaoProdutoAlimento, ");
            buf.append("set.set_tipoalimentos as tipoSetor, ");
            buf.append("'' as quantidadeTotalFisicoQuimico, ");
            buf.append("'' as valorTotalFisicoQuimico, ");
            buf.append("'' as quantidadeTotalMicrobiologia, ");
            buf.append("'' as valorTotalMicrobiologia, ");
            buf.append("'' as quantidadeTotalOutros, ");
            buf.append("'' as valorTotalOutros, ");
            buf.append("'' as quantidadeTotalCromatografia, ");
            buf.append("'' as valorTotalCromatografia, ");
        }
        buf.append("nota.nfi_numero as numeroNotaFiscal, nota.nfi_dataemissao as dataEmissaoNotaFiscal ");
        buf.append(", conv.con_cei as ceiConvenio ");
        buf.append("from fatura a  ");
        buf.append("left join faturarequisicao b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append("left join faturaexamerequisicao c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo and b.fil_kodigo = c.fil_kodigo and b.req_codigo = c.req_codigo ");
        buf.append("left join requisicao d on b.fil_kodigo = d.fil_codigo and b.req_codigo = d.req_codigo ");
        buf.append("left join filiais_postocoleta f on a.fil_codigo = f.fil_codigo  ");
        buf.append("left join usuario usrfatura on a.usr_codigo = usrfatura.usr_codigo  ");
        buf.append("left join convenios conv on a.fil_codigo = conv.fil_codigo and a.con_codigo = conv.con_codigo ");
        buf.append(" left join examerequisicao exr on b.fil_kodigo = exr.fil_codigo and b.req_codigo = exr.req_codigo and c.exa_codigo = exr.exa_codigo and c.mco_codigo = exr.mco_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on a.fil_codigo = dtm.fil_codigo and c.exa_codfilho = dtm.exa_codigo and c.mco_codfilho = dtm.mco_codigo and conv.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
        }
        buf.append(" left join detalhetabelapreco preco on a.fil_codigo = preco.fil_codigo and c.exa_codfilho = preco.exa_codigo and c.mco_codfilho = preco.mco_codigo and conv.tpe_codigo = preco.tpe_codigo ");
        buf.append("left join cidades cidcon on conv.fil_codigo = cidcon.fil_codigo and conv.cid_codigo = cidcon.cid_codigo ");
        buf.append("left join bairro baicon on conv.fil_codigo = baicon.fil_codigo and conv.bai_codigo = baicon.bai_codigo  ");
        buf.append("left join cidades cidcobcon on conv.fil_codigo = cidcobcon.fil_codigo and conv.cid_codcobranca = cidcobcon.cid_codigo ");
        buf.append("left join bairro baicobcon on conv.fil_codigo = baicobcon.fil_codigo and conv.bai_codcobranca = baicobcon.bai_codigo  ");
        buf.append("left join exames exm on c.fil_kodigo = exm.fil_codigo and c.exa_codfilho = exm.exa_codigo  ");
        buf.append("left join examematcoleta emc on c.fil_kodigo = emc.fil_codigo and c.exa_codfilho = emc.exa_codigo and c.mco_codfilho = emc.mco_codigo ");
        buf.append("left join faturanotafiscal notafatura on a.fil_codigo = notafatura.fil_codigo and a.fat_codigo = notafatura.fat_codigo ");
        buf.append("left join notafiscal nota on notafatura.fil_codigo = nota.fil_codigo and notafatura.nfi_codigo = nota.nfi_codigo  ");
        buf.append("left join cidades cidfil on f.fil_codigo = cidfil.fil_codigo and f.cid_codigo = cidfil.cid_codigo  ");
        buf.append("left join bairro baifil on f.fil_codigo = baifil.fil_codigo and f.bai_codigo = baifil.bai_codigo  ");
        if (ImprimirResumoFatura.isAlimentos()) {
            buf.append("left join categoriaprodutoalimentos cpl on d.fil_codigo = cpl.fil_codigo and d.cpl_codigo = cpl.cpl_codigo ");
            buf.append("left join produtoalimentos pal on d.fil_codigo = pal.fil_codigo and pal.pal_codigo = d.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo ");
            buf.append(" left join examesetor ese on exm.fil_codigo = ese.fil_codigo and exm.exa_codigo = ese.exa_codigo and ese.ese_default = TRUE ");
            buf.append(" left join setores set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        }
        SELECT = buf.toString();
        buf.setLength(0);
        buf.append("group by  ");
        buf.append("usrfatura.usr_codigo, usrfatura.usr_nome,  ");
        buf.append("cidcon.cid_codigo, cidcon.cid_nome, cidcon.cid_uf,  ");
        buf.append("cidcobcon.cid_codigo, cidcobcon.cid_nome, cidcobcon.cid_uf, ");
        buf.append("baicon.bai_codigo, baicon.bai_descricao,  ");
        buf.append("baicobcon.bai_codigo, baicobcon.bai_descricao,  ");
        buf.append("a.fil_codigo, f.fil_descricao, f.fil_cnpj,  ");
        buf.append("f.fil_endereco, f.fil_complemento, f.fil_cep,  ");
        buf.append("f.fil_fone, f.fil_fax, f.fil_razaosocial,  ");
        buf.append("cidfil.cid_codigo, cidfil.cid_nome, cidfil.cid_uf, ");
        buf.append("baifil.bai_codigo, baifil.bai_descricao,  ");
        buf.append("conv.con_codigo, conv.con_fantasia, conv.con_razao,  ");
        buf.append("conv.con_endereco, conv.con_numeroendereco, conv.con_numeroendcobranca, ");
        buf.append("conv.con_tipologradouroendereco, conv.con_tipologradouroendcobranca, conv.con_complemento, conv.con_cep, ");
        buf.append("conv.con_cnpjcpf, conv.con_inscrest,  ");
        buf.append("conv.con_endcobranca, conv.con_complcobranca, conv.con_cepcobranca, ");
        buf.append("conv.con_fone, conv.con_email1, conv.con_email2, conv.con_site, ");
        buf.append("a.fat_codigo, ");
        buf.append("c.exa_codfilho, exm.exa_descricao,  ");
        buf.append("emc.emc_codigocbhpm, emc.emc_codigoamb,  ");
        buf.append("a.fat_dtinicio, a.fat_dtfim, a.fat_dtemis, a.fat_dtvenc, ");
        buf.append("a.fat_adicional, a.fat_despcobranca,  ");
        buf.append("a.fat_percdesconto, a.fat_totalmateriais, ");
        buf.append("a.fat_percacrescimo,  ");
        buf.append("a.fat_totalexamesch, a.fat_totalexames, a.fat_mensagem, ");
        buf.append("a.fat_qtdeexames, a.fat_qtderequisicao,  a.fat_qtdeguias, ");
        buf.append("nota.nfi_numero, nota.nfi_dataemissao, ");
        if (ImprimirResumoFatura.isAlimentos()) {
            buf.append("pal.pal_codigo, ");
            buf.append("pal.pal_descricao, ");
            buf.append("set.set_tipoalimentos, ");
        }
        buf.append(" preco.dtp_codamb ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" ,dtm.dtm_codamb ");
        }
        buf.append(", conv.con_cei ");
        GROUP_BY = buf.toString();
    }
}

