/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.enums.EnumTipoRateio;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class ImprimirFatura {
    private static final HashMap<String, String> MAPA_TODOS_CAMPOS_DISPONIVEIS;
    private static final String LIGACOES;
    private static HashMap<MedicoVO, String> listaUNCPMedicos;
    private static String[] perguntasFilial;
    public static String[] COLUNAS_AGRUPADAS;
    public static String[] CAMPOS;
    public static String[] CAMPOS_ALIMENTOS;

    public static String[] getCampos() {
        Object[] campos = CAMPOS;
        perguntasFilial = RecepcaoUtil.getPerguntasFilial(Variaveis.filialPadrao);
        if (perguntasFilial.length > 0) {
            campos = ArraysUtil.concatenar(campos, perguntasFilial);
        }
        Arrays.sort(campos);
        return campos;
    }

    public static void imprimir(int codigoFatura, int convenio, boolean exibirModal) throws SQLException {
        ImprimirFatura.imprimir(codigoFatura, convenio, false, exibirModal);
    }

    private static boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    /*
     * WARNING - void declaration
     */
    public static void imprimir(int codigoFatura, int convenio, boolean agruparExames, boolean exibirModal) throws SQLException {
        String layoutRelatorio = ImprimirFatura.getLayoutRelatorio(convenio);
        if (Funcoes.textoVazio(layoutRelatorio)) {
            Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
            return;
        }
        HashMap<String, String> camposObrigatorios = new HashMap<String, String>();
        camposObrigatorios.put("tipoSetor", "set.set_tipoalimentos");
        camposObrigatorios.put("codigoFilialFaturada", "b.fil_kodigo");
        camposObrigatorios.put("codigoRequisicao", "d.req_codigo");
        camposObrigatorios.put("codigoExamePai", "c.exa_codigo");
        camposObrigatorios.put("codigoMaterialPai", "c.mco_codigo");
        camposObrigatorios.put("codigoExame", "c.exa_codfilho");
        camposObrigatorios.put("codigoMaterial", "mcol.mco_codigo");
        camposObrigatorios.put("codigoConvenio", "conv.con_codigo");
        camposObrigatorios.put("codigoMetodo", "met.met_codigo");
        camposObrigatorios.put("contadorLinha", "null");
        camposObrigatorios.put("ambExame", "null");
        camposObrigatorios.put("conselhoMedico", "med.med_conselho");
        camposObrigatorios.put("crmMedico", "med.med_crm");
        camposObrigatorios.put("estadoCrmMedico", "med.med_uf");
        camposObrigatorios.put("estadoCrmMedico", "med.med_uf");
        camposObrigatorios.put("perguntasRequisicao", "d.req_perguntas");
        camposObrigatorios.put("ordemPaciente", "CASE WHEN conv.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(d.req_titular), ''), pac.pac_nome) ELSE pac.pac_nome END");
        camposObrigatorios.put("cid10", " (select c10.c10_codigo from requisicaocid10 c10 where d.fil_codigo = c10.fil_codigo and d.req_codigo = c10.req_codigo limit 1) ");
        HashMap<String, String> camposUtilizados = Relatorio.getCamposBancoLayout(layoutRelatorio, MAPA_TODOS_CAMPOS_DISPONIVEIS, camposObrigatorios);
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append(Relatorio.getFieldsSelect(camposUtilizados));
        buf.append(LIGACOES);
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and a.fat_codigo = ").append(String.valueOf(codigoFatura));
        buf.append("   and a.fat_datacancelamento is null ");
        buf.append("   and d.req_excluida = false ");
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append(" and exmsetor.ese_default = true ");
        }
        buf.append(" order by ");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        Statement stOrdenacaoTiss = Conexao.getStatement();
        StringBuilder sb = new StringBuilder();
        sb.append("select con_ordemfatura, con_viasfatura, con_faturaeletronica, con_respostafatura from convenios where fil_codigo = ");
        sb.append(Variaveis.filialPadrao);
        sb.append(" and con_codigo = ");
        sb.append(convenio);
        ResultSet rsOrdem = Conexao.executeQuery(st, sb.toString());
        String ordemFatura = "R";
        int qtdeCopias = 1;
        String xmlConfEletronico = null;
        Integer grade = 0;
        String uncpLaboratorio = null;
        String mesAnoConfEletronico = null;
        boolean considerarFatura = false;
        if (rsOrdem.next()) {
            xmlConfEletronico = rsOrdem.getString("con_faturaeletronica");
            considerarFatura = rsOrdem.getBoolean("con_respostafatura");
            ordemFatura = rsOrdem.getString("con_ordemfatura");
            int n = qtdeCopias = DBUtil.campoNull(rsOrdem.getString("con_viasfatura")) ? 1 : rsOrdem.getInt("con_viasfatura");
            if (ImprimirFatura.isAlimentos()) {
                buf.append(" des.des_descricao, ");
            }
            if (ordemFatura == null || ordemFatura.equals("R")) {
                buf.append(" c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("D")) {
                buf.append(" d.req_data, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("F")) {
                buf.append(" d.req_dtfatura, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("N")) {
                buf.append(" ordemPaciente, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("G")) {
                buf.append(" d.req_guia, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("M")) {
                buf.append(" d.req_matricula, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("E")) {
                buf.append(" med.med_nome, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("C")) {
                buf.append(" med.med_crm, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("X")) {
                buf.append(" d.req_data, exr.exr_guia, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("T")) {
                buf.append(" d.des_codigo, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("P")) {
                buf.append(" d.req_data, pac.pac_nome, c.fil_kodigo, c.req_codigo, ");
            } else if (ordemFatura.equals("A")) {
                buf.append(" conv.con_codigo, ala_descricao nulls first, c.req_codigo asc, ");
            } else if (ordemFatura.equals("W")) {
                buf.append(" entidadepaciente.ent_razaosocial, c.fil_codigo, c.req_codigo asc, ");
            } else if (ordemFatura.equals("Z")) {
                buf.append(" entidadepaciente.ent_razaosocial, ordemPaciente, c.fil_kodigo, c.req_codigo, ");
            } else if (ImprimirFatura.isTipoSetorRequisicao(ordemFatura)) {
                buf.append(" set.set_tipoalimentos,  c.fil_kodigo, c.req_codigo, ");
            }
        }
        buf.append(" conprinc.con_codigo ");
        if (ParametrosGerais.getOrdemComprovante().equals("A")) {
            buf.append(" ,exr.exr_ordem, exr.exa_codigo, exr.mco_codigo ");
        } else {
            if (ParametrosGerais.getOrdenarSetor()) {
                buf.append(" ,exmsetor.set_codigo ");
            }
            if (ParametrosGerais.getOrdemComprovante().equals("C")) {
                buf.append(" ,exr.exa_codigo, exr.mco_codigo ");
            } else if (ParametrosGerais.getOrdemComprovante().equals("P")) {
                buf.append(" ,emc.emc_pagina, emc.emc_ordem, exr.exa_codigo, exr.mco_codigo ");
            }
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        String protocolo = "";
        String cnpjFilial = "";
        String cnpjFilialConectada = "";
        String razaoSocialFilialConectada = "";
        if (rs.next()) {
            void var31_40;
            int i;
            if (!Funcoes.textoVazio(xmlConfEletronico)) {
                String auxGrade;
                String aux = StringUtil.getValor(xmlConfEletronico, "medicos");
                if (!Funcoes.textoVazio(aux)) {
                    listaUNCPMedicos = new HashMap();
                    String[] arrayMedicos = StringUtil.getValores(aux, "medico");
                    for (int i2 = 0; i2 < arrayMedicos.length; ++i2) {
                        String xmlMedico = arrayMedicos[i2];
                        String conselhoAux = StringUtil.getValor(xmlMedico, "conselho");
                        String string = StringUtil.getValor(xmlMedico, "crm");
                        String ufAux = StringUtil.getValor(xmlMedico, "uf");
                        String uncp = StringUtil.getValor(xmlMedico, "uncp");
                        if (Funcoes.textoVazio(conselhoAux) || Funcoes.textoVazio(string) || Funcoes.textoVazio(ufAux) || Funcoes.textoVazio(uncp) || !Funcoes.isNumeric(uncp)) continue;
                        MedicoVO medicoVO = new MedicoVO();
                        medicoVO.setConselho(conselhoAux);
                        medicoVO.setCrm(string);
                        medicoVO.setUf(ufAux);
                        listaUNCPMedicos.put(medicoVO, "UNCP" + uncp);
                    }
                }
                ResultSet faturaEletronicaConvenioRS = ImprimirFatura.buscaFaturaEletronicaDoConvenio(convenio);
                String xmlFatura = "";
                while (faturaEletronicaConvenioRS.next()) {
                    xmlFatura = faturaEletronicaConvenioRS.getString("con_faturaeletronica");
                    cnpjFilialConectada = faturaEletronicaConvenioRS.getString("fil_cnpj");
                    razaoSocialFilialConectada = faturaEletronicaConvenioRS.getString("fil_razaosocial");
                }
                if (!Funcoes.textoVazio(xmlFatura)) {
                    protocolo = StringUtil.getValor(xmlFatura, "protocolo");
                    cnpjFilial = StringUtil.getValor(xmlFatura, "cnpjFilial");
                }
                if (!Funcoes.textoVazio(auxGrade = StringUtil.getValor(xmlConfEletronico, "grade")) && Funcoes.isNumeric(auxGrade)) {
                    grade = Integer.parseInt(auxGrade);
                }
                uncpLaboratorio = StringUtil.getValor(xmlConfEletronico, "codigoLocal");
                String auxMesReferencia = StringUtil.getValor(xmlConfEletronico, "mesReferencia");
                Integer n = Funcoes.textoVazio(auxMesReferencia) ? 0 : Integer.parseInt(auxMesReferencia) + 1;
                mesAnoConfEletronico = StringUtil.preencheString("" + n, 2, '0', 1) + StringUtil.getValor(xmlConfEletronico, "anoReferencia");
            }
            String[] listaCamposUtilizados = new String[camposUtilizados.size()];
            Iterator<String> it = camposUtilizados.keySet().iterator();
            int i3 = 0;
            while (it.hasNext()) {
                listaCamposUtilizados[i3] = it.next().toString();
                ++i3;
            }
            String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(Variaveis.filialPadrao);
            if (perguntasFilial.length > 0) {
                List<String> listaComparacao = Arrays.asList(listaCamposUtilizados);
                ArrayList<String> perguntasNaoEncontardas = new ArrayList<String>();
                for (String pergunta : perguntasFilial) {
                    if (listaComparacao.contains(pergunta)) continue;
                    perguntasNaoEncontardas.add(pergunta);
                }
                listaCamposUtilizados = ArraysUtil.concatenar(listaCamposUtilizados, perguntasNaoEncontardas.toArray(new String[perguntasNaoEncontardas.size()]));
            }
            ModeloGridTable modeloDados = new ModeloGridTable(listaCamposUtilizados);
            int qtdeExames = 0;
            boolean bl = false;
            int qtdeFisicoQuimico = 0;
            int qtdeOutros = 0;
            int qtdeCromatografia = 0;
            BigDecimal totalMicrobiologica = BigDecimal.ZERO;
            BigDecimal totalFiscoQuimico = BigDecimal.ZERO;
            BigDecimal totalOutros = BigDecimal.ZERO;
            BigDecimal totalCromatografia = BigDecimal.ZERO;
            do {
                Map<Object, Object> respostasRequisicao = new HashMap();
                if (perguntasFilial.length > 0 && considerarFatura) {
                    respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                }
                int linhaRequisicaoAgrupada = -1;
                if (agruparExames) {
                    linhaRequisicaoAgrupada = modeloDados.localizar(modeloDados.findColumn("codigoRequisicao"), rs.getString("codigorequisicao"));
                }
                if (linhaRequisicaoAgrupada < 0 || !agruparExames) {
                    modeloDados.addLine(new Object[listaCamposUtilizados.length]);
                }
                for (i = 0; i < listaCamposUtilizados.length; ++i) {
                    if (listaCamposUtilizados[i].equals("contadorLinha") && linhaRequisicaoAgrupada < 0) {
                        int coluna = modeloDados.findColumn(listaCamposUtilizados[i]);
                        modeloDados.setValueAt(modeloDados.getRowCount(), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, coluna);
                    } else if (agruparExames && ArraysUtil.contem(COLUNAS_AGRUPADAS, listaCamposUtilizados[i], true)) {
                        int linha;
                        String s = listaCamposUtilizados[i];
                        int coluna = modeloDados.findColumn(s);
                        String tmp = rs.getString(s);
                        int n = linha = linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1;
                        if (coluna > -1) {
                            String novoValor = modeloDados.getValueAt(linha, coluna) != null ? modeloDados.getValueAt(linha, coluna).toString() : "";
                            novoValor = !Funcoes.textoVazio(novoValor) ? novoValor + ", " + tmp : tmp;
                            modeloDados.setValueAt(novoValor, linha, coluna);
                        }
                    } else if (ImprimirFatura.achaColuna(rs, listaCamposUtilizados[i])) {
                        if (listaCamposUtilizados[i].equalsIgnoreCase("numeroNotaFiscal")) {
                            modeloDados.setValueAt(ImprimirFatura.pegaNumeroNotaFiscal(st3, Variaveis.filialPadrao, String.valueOf(codigoFatura)), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("dataEmissaoNotaFiscal")) {
                            modeloDados.setValueAt(ImprimirFatura.pegaDataEmissaoNotaFiscal(st3, Variaveis.filialPadrao, String.valueOf(codigoFatura)), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenioPrincipal") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroConvenioPrincipal") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroPaciente") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroConvenioFatura") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroConvenio") || listaCamposUtilizados[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                            modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(listaCamposUtilizados[i])), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("ambExame")) {
                            modeloDados.setValueAt(Impressao.pegaAMB(rs.getString("codigoFilialFaturada"), rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), rs.getString("codigoMetodo")), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("uncpMedico") && listaUNCPMedicos != null) {
                            modeloDados.setValueAt(ImprimirFatura.getUNCPMedico(rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("estadoCrmMedico")), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("totalCHFatura") || listaCamposUtilizados[i].equalsIgnoreCase("valorCHConvenio")) {
                            modeloDados.setValueAt(rs.getBigDecimal(listaCamposUtilizados[i]), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("grade")) {
                            modeloDados.setValueAt(grade + qtdeExames / 50, linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("uncpLaboratorio")) {
                            modeloDados.setValueAt(uncpLaboratorio, linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("mesAnoFaturamentoEletronico")) {
                            modeloDados.setValueAt(mesAnoConfEletronico, linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("cnpjfilial")) {
                            int linha = linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1;
                            int coluna = i;
                            String cnpj = rs.getString("cnpjfilial");
                            if (!Funcoes.textoVazio(protocolo)) {
                                cnpj = !Funcoes.textoVazio(cnpjFilial) && protocolo.equalsIgnoreCase("IPERGS") ? cnpjFilial : cnpjFilialConectada;
                            }
                            modeloDados.setValueAt(cnpj, linha, coluna);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("razaosocialfilial")) {
                            if (!Funcoes.textoVazio(protocolo) && protocolo.equalsIgnoreCase("IPERGS")) {
                                modeloDados.setValueAt(razaoSocialFilialConectada, linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                            } else {
                                modeloDados.setValueAt(rs.getObject(listaCamposUtilizados[i]), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                            }
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("perguntasRequisicao") && !DBUtil.campoNull(rs.getString("perguntasRequisicao")) && !Funcoes.textoVazio(rs.getString("perguntasRequisicao")) && considerarFatura) {
                            if (perguntasFilial.length > 0) {
                                int linha = linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1;
                                for (Map.Entry<Object, Object> resposta : respostasRequisicao.entrySet()) {
                                    if (modeloDados.findColumn((String)resposta.getKey()) < 0) continue;
                                    modeloDados.setValueAt(resposta.getValue(), linha, modeloDados.findColumn((String)resposta.getKey()));
                                }
                            }
                        } else if (perguntasFilial.length > 0 && considerarFatura) {
                            String nomeCampo = listaCamposUtilizados[i];
                            ArrayList camposPergunta = new ArrayList();
                            respostasRequisicao.forEach((k, v) -> camposPergunta.add(k));
                            if (!camposPergunta.contains(nomeCampo)) {
                                modeloDados.setValueAt(rs.getObject(listaCamposUtilizados[i]), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                            }
                        } else {
                            modeloDados.setValueAt(rs.getObject(listaCamposUtilizados[i]), linhaRequisicaoAgrupada > -1 ? linhaRequisicaoAgrupada : modeloDados.getRowCount() - 1, i);
                        }
                    }
                    if (!ImprimirFatura.isOrdenaSetorAlimentos(ordemFatura)) continue;
                    if (EnumTipoRateio.isMicrobiologico(rs.getString("tipoSetor"))) {
                        if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalMicrobiologia")) {
                            ++var31_40;
                            continue;
                        }
                        if (!listaCamposUtilizados[i].equalsIgnoreCase("valorTotalMicrobiologia")) continue;
                        totalMicrobiologica = totalMicrobiologica.add(rs.getBigDecimal("valorexame"));
                        continue;
                    }
                    if (EnumTipoRateio.isFisicoQuimico(rs.getString("tipoSetor"))) {
                        if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalFisicoQuimico")) {
                            ++qtdeFisicoQuimico;
                            continue;
                        }
                        if (!listaCamposUtilizados[i].equalsIgnoreCase("valorTotalFisicoQuimico")) continue;
                        totalFiscoQuimico = totalFiscoQuimico.add(rs.getBigDecimal("valorexame"));
                        continue;
                    }
                    if (EnumTipoRateio.isOutros(rs.getString("tipoSetor"))) {
                        if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalOutros")) {
                            ++qtdeOutros;
                            continue;
                        }
                        if (!listaCamposUtilizados[i].equalsIgnoreCase("valorTotalOutros")) continue;
                        totalOutros = totalOutros.add(rs.getBigDecimal("valorexame"));
                        continue;
                    }
                    if (!EnumTipoRateio.isCromatografia(rs.getString("tipoSetor"))) continue;
                    if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalCromatografia")) {
                        ++qtdeCromatografia;
                        continue;
                    }
                    if (!listaCamposUtilizados[i].equalsIgnoreCase("valorTotalCromatografia")) continue;
                    totalCromatografia = totalCromatografia.add(rs.getBigDecimal("valorexame"));
                }
                ++qtdeExames;
            } while (rs.next());
            if (ImprimirFatura.isOrdenaSetorAlimentos(ordemFatura)) {
                String tipoRateio = "";
                for (int j = 0; j < modeloDados.getRowCount(); ++j) {
                    for (i = 0; i < listaCamposUtilizados.length; ++i) {
                        int numcampo = i;
                        if (listaCamposUtilizados[i].equalsIgnoreCase("tipoSetor")) {
                            tipoRateio = (String)modeloDados.getValueAt(j, i);
                        }
                        if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalMicrobiologia")) {
                            modeloDados.setValueAt((int)var31_40, j, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("valorTotalMicrobiologia")) {
                            modeloDados.setValueAt(totalMicrobiologica, j, i);
                        }
                        if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalFisicoQuimico")) {
                            modeloDados.setValueAt(qtdeFisicoQuimico, j, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("valorTotalFisicoQuimico")) {
                            modeloDados.setValueAt(totalFiscoQuimico, j, i);
                        }
                        if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalOutros")) {
                            modeloDados.setValueAt(qtdeOutros, j, i);
                        } else if (listaCamposUtilizados[i].equalsIgnoreCase("valorTotalOutros")) {
                            modeloDados.setValueAt(totalOutros, j, i);
                        }
                        if (listaCamposUtilizados[i].equalsIgnoreCase("quantidadeTotalCromatografia")) {
                            modeloDados.setValueAt(qtdeCromatografia, j, i);
                            continue;
                        }
                        if (!listaCamposUtilizados[i].equalsIgnoreCase("valorTotalCromatografia")) continue;
                        modeloDados.setValueAt(totalCromatografia, j, i);
                    }
                }
            }
            Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
            gerador.setPreVisualizar(true);
            gerador.setCopias(qtdeCopias);
            gerador.setImpressora(ParametrosLocais.getParametro("impressoraFatura"));
            gerador.executar(layoutRelatorio, (TableModel)modeloDados, exibirModal);
        }
        rs.close();
        Conexao.fecharStatement(st, st2, st3);
    }

    private static boolean isOrdenaSetorAlimentos(String ordemFatura) {
        return ImprimirFatura.isAlimentos() && ImprimirFatura.isTipoSetorRequisicao(ordemFatura);
    }

    private static boolean isTipoSetorRequisicao(String ordemFatura) {
        return ordemFatura.equals("S");
    }

    private static ResultSet buscaFaturaEletronicaDoConvenio(int convenio) throws SQLException {
        StringBuilder faturaSQL = new StringBuilder();
        faturaSQL.append("select c.con_faturaeletronica , f.fil_cnpj, f.fil_razaosocial from convenios c ");
        faturaSQL.append("left join filiais_postocoleta f on c.fil_codigo = f.fil_codigo ");
        faturaSQL.append("where c.fil_codigo = ");
        faturaSQL.append(Variaveis.filialPadrao);
        faturaSQL.append(" and c.con_codigo = ");
        faturaSQL.append(convenio);
        Statement faturaSt = Conexao.getStatement();
        return Conexao.executeQuery(faturaSt, faturaSQL.toString());
    }

    private static String getUNCPMedico(String conselho, String crm, String uf) {
        if (listaUNCPMedicos == null) {
            return null;
        }
        MedicoVO medicoAux = new MedicoVO();
        medicoAux.setConselho(conselho);
        medicoAux.setCrm(crm);
        medicoAux.setUf(uf);
        for (MedicoVO aux : listaUNCPMedicos.keySet()) {
            if (!aux.equals(medicoAux)) continue;
            return listaUNCPMedicos.get(aux);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLayoutRelatorio(int codigoConvenio) throws SQLException {
        Statement st;
        block3: {
            String string;
            StringBuilder buf = new StringBuilder();
            buf.append(" select con_modfatura ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and con_codigo = ").append(String.valueOf(codigoConvenio));
            st = Conexao.getStatement();
            try {
                ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
                if (!rsLayout.next() || Funcoes.textoVazio(rsLayout.getString("con_modfatura"))) break block3;
                string = rsLayout.getString("con_modfatura");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return string;
        }
        String string = null;
        Conexao.fecharStatement(st);
        return string;
    }

    private static boolean getOrdenacaoTiss(Statement st, String filial, int convenio) throws SQLException {
        String filialAux;
        String string = filialAux = filial == null ? Variaveis.filialPadrao : filial;
        if (filialAux != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" select con_faturaeletronica ");
            sb.append("   from convenios ");
            sb.append("  where fil_codigo = ").append(filialAux);
            sb.append("    and con_codigo = ").append(convenio);
            ResultSet rsFatura = Conexao.executeQuery(st, sb.toString());
            if (rsFatura.next()) {
                String conf;
                String eletronico = rsFatura.getString("con_faturaeletronica");
                return eletronico != null && !Funcoes.textoVazio(eletronico) && (conf = StringUtil.getValor(eletronico, "faturamentoEletronico")) != null && !Funcoes.textoVazio(conf) && (conf = StringUtil.getValor(conf, "ordenacaoTiss")) != null && !Funcoes.textoVazio(conf) && conf.toUpperCase().equalsIgnoreCase("TRUE");
            }
            return false;
        }
        return false;
    }

    private static boolean achaColuna(ResultSet result, String coluna) {
        if (result != null) {
            try {
                if (result.findColumn(coluna) > 0) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private static Date pegaDataEmissaoNotaFiscal(Statement st, String filial, String fatura) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.nfi_dataemissao ");
        buf.append("   from notafiscal a ");
        buf.append("   left join faturanotafiscal notafatura on a.fil_codigo = notafatura.fil_codigo and a.nfi_codigo = notafatura.nfi_codigo ");
        buf.append("  where ((a.nfi_numerorps IS NULL and a.nfi_situacao IN ('").append("A").append("','").append("I").append("')) ");
        buf.append("      or (a.nfi_numerorps IS NOT NULL and a.nfi_situacao = '").append("A").append("') ) ");
        buf.append("    and a.fil_codigo = ").append(filial);
        buf.append("    and notafatura.fat_codigo = ").append(fatura);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getTimestamp("nfi_dataemissao");
        }
        return null;
    }

    private static Long pegaNumeroNotaFiscal(Statement st, String filial, String fatura) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.nfi_numero ");
        buf.append("   from notafiscal a ");
        buf.append("   left join faturanotafiscal notafatura on a.fil_codigo = notafatura.fil_codigo and a.nfi_codigo = notafatura.nfi_codigo ");
        buf.append("  where ((a.nfi_numerorps IS NULL and a.nfi_situacao in ('").append("A").append("','").append("I").append("')) ");
        buf.append("      or (a.nfi_numerorps IS NOT NULL and a.nfi_situacao = '").append("A").append("') ) ");
        buf.append(" and a.fil_codigo = ").append(filial);
        buf.append(" and notafatura.fat_codigo = ").append(fatura);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getLong(1);
        }
        return null;
    }

    static {
        listaUNCPMedicos = null;
        perguntasFilial = RecepcaoUtil.getPerguntasFilial(Variaveis.filialPadrao);
        COLUNAS_AGRUPADAS = new String[]{"codigoExameAgrupado", "descricaoExameAgrupado", "codigoExamePaiAgrupado", "codigoMaterialPaiAgrupado", "ambExameAgrupado", "cbhpmExameAgrupado", "chExameAgrupado", "valorExameAgrupado", "valorMateriaisExameAgrupado", "custoCBHPMExameAgrupado", "UCOCBHPMExameAgrupado", "porteCBHPMExameAgrupado", "valorPorteCBHPMExameAgrupado", "descricaoMaterialAgrupado", "codigoMaterialAgrupado", "abreviaturaMaterialAgrupado", "dataColetaExameAgrupado", "horaColetaExameAgrupado", "usuarioColetaExameAgrupado", "descricaoPrazoAgrupado", "codigoPrazoAgrupado", "codigoMetodoAgrupado", "situacaoExameAgrupado", "descricaoMetodoAgrupado", "materialInformadoExameAgrupado", "autorizacaoExameAgrupado"};
        CAMPOS = new String[]{"numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "tipoLogradouroCobrancaConvenioPrincipal", "numeroEnderecoConvenioPrincipal", "tipoLogradouroConvenioPrincipal", "tipoLogradouroCobrancaPaciente", "tipoLogradouroPaciente", "numeroEnderecoConvenioFatura", "tipoLogradouroConvenioFatura", "numeroEnderecoConvenio", "tipoLogradouroConvenio", "tipoLogradouroMedico", "numeroEnderecoMedico", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "titularRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "valorExamesCHRequisicao", "guiaRequisicao", "nomePlanoRequisicao", "dataValidadeCarteiraRequisicao", "validadeGuiaRequisicao", "observacaoRequisicao", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoSituacao", "descricaoSituacao", "codigoUsuario", "nomeUsuario", "codigoUsuarioFatura", "nomeUsuarioFatura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeCobrancaConvenio", "descricaoCidadeCobrancaConvenio", "estadoCidadeCobrancaConvenio", "codigoCidadeConvenioFatura", "descricaoCidadeConvenioFatura", "dataGuiaRequisicao", "estadoCidadeConvenioFatura", "codigoCidadeCobrancaConvenioFatura", "descricaoCidadeCobrancaConvenioFatura", "estadoCidadeCobrancaConvenioFatura", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroCobrancaConvenio", "descricaoBairroCobrancaConvenio", "codigoBairroConvenioFatura", "descricaoBairroConvenioFatura", "codigoBairroCobrancaConvenioFatura", "descricaoBairroCobrancaConvenioFatura", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "codigoFilialFaturada", "codigoFilialRequisicaoFaturada", "cepFilial", "foneFilial", "faxfilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "cnpjConvenio", "inscricaoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "enderecoCobrancaConvenio", "complementoCobrancaConvenio", "cepCobrancaConvenio", "codigoConvenioFatura", "fantasiaConvenioFatura", "razaoSocialConvenioFatura", "enderecoConvenioFatura", "cnpjConvenioFatura", "inscricaoConvenioFatura", "complementoConvenioFatura", "cepConvenioFatura", "foneConvenioFatura", "email1ConvenioFatura", "email2ConvenioFatura", "siteConvenioFatura", "enderecoCobrancaConvenioFatura", "complementoCobrancaConvenioFatura", "cepCobrancaConvenioFatura", "codigoPaciente", "nomePaciente", "sexoPaciente", "dataNascimentoPaciente", "rgPaciente", "cpfPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "perguntasRequisicao", "fantasiaResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "cargoResponsavelRequisicao", "rgResponsavelRequisicao", "cpfResponsavelRequisicao", "codigoExame", "descricaoExame", "codigoExamePai", "codigoMaterialPai", "ambExame", "cbhpmExame", "chExame", "valorExame", "valorMateriaisExame", "custoCBHPMExame", "UCOCBHPMExame", "porteCBHPMExame", "valorPorteCBHPMExame", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "usuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "situacaoExame", "descricaoMetodo", "materialInformadoExame", "autorizacaoExame", "numeroNotaIPERGSExame", "guiaExame", "codigoFatura", "motivoPrazoCarenciaExame", "dataInicioFatura", "dataFinalFatura", "dataEmissaoFatura", "dataVencimentoFatura", "mensagemFatura", "valorAdicionalFatura", "valorDespesaCobrancaFatura", "percentualDescontoFatura", "percentualAcrescimoFatura", "totalMateriaisFatura", "totalCHFatura", "totalExamesFatura", "quantidadeExamesFatura", "quantidadeRequisicoesFatura", "numeroNotaFiscal", "dataEmissaoNotaFiscal", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "areaProdutoRequisicao", "nomeResponsavelRequisicao_", "cargoResponsavelRequisicao_", "emailResponsavelRequisicao_", "foneResponsavelRequisicao_", "nomeResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "foneResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "contadorLinha", "descricaoAcrescimo", "descricaoDesconto", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "codigoConvenioPrincipal", "razaoConvenioPrincipal", "fantasiaConvenioPrincipal", "enderecoConvenioPrincipal", "enderecoConvenioPrincipal", "cepConvenioPrincipal", "cnpjConvenioPrincipal", "inscricaoConvenioPrincipal", "enderecoCobrancaConvenioPrincipal", "complementoCobrancaConvenioPrincipal", "cepCobrancaConvenioPrincipal", "foneConvenioPrincipal", "email1ConvenioPrincipal", "email2ConvenioPrincipal", "siteConvenioPrincipal", "matriculaConvenioPrincipal", "valorExameRequisicao", "valorDescontoRequisicao", "valorAcrescimoRequisicao", "valorTotalExamesRequisicao", "profissaoPaciente", "cartaoSUSPaciente", "cartaoSUSRequisicao", "cid10", "uncpMedico", "valorCHConvenio", "grade", "uncpLaboratorio", "mesAnoFaturamentoEletronico", "tipoSetor", "ceiConvenio", "quantidadeGuiasFatura", "empresaPaciente", "codigoEmpresaPaciente"};
        CAMPOS_ALIMENTOS = new String[]{"percentualBonusConvenio", "percentualAcrescimoConvenio", "quantidadeTotalFisicoQuimico", "valorTotalFisicoQuimico", "quantidadeTotalMicrobiologia", "valorTotalMicrobiologia", "quantidadeTotalOutros", "valorTotalOutros", "quantidadeTotalCromatografia", "valorTotalCromatografia", "ordemCompra"};
        CAMPOS = ArraysUtil.concatenar(CAMPOS, COLUNAS_AGRUPADAS);
        if (ImprimirFatura.isAlimentos()) {
            CAMPOS = ArraysUtil.concatenar(CAMPOS, CAMPOS_ALIMENTOS);
        }
        HashMap listaCampos = new HashMap();
        HashMap<String, String> campos = new HashMap<String, String>();
        campos.put("cartaoSUSRequisicao", "d.req_cartaosus");
        campos.put("codigoRequisicao", "d.req_codigo");
        campos.put("dataRequisicao", "d.req_data");
        campos.put("dataGuiaRequisicao", "d.req_dataguia");
        campos.put("dataFaturaRequisicao", "d.req_dtfatura");
        campos.put("urgenteRequisicao", "d.req_urgente");
        campos.put("horaRequisicao", "d.req_hora");
        campos.put("dataEntregaRequisicao", "d.req_dataentregaprev");
        campos.put("horaEntregaRequisicao", "d.req_horaentregaprev");
        campos.put("totalRequisicao", "b.fre_total");
        campos.put("horaFaturaRequisicao", "d.req_horafatura");
        campos.put("gestanteRequisicao", "d.req_gestante");
        campos.put("idadeRequisicao", "d.req_idade");
        campos.put("anoMesRequisicao", "d.req_anomes");
        campos.put("matriculaRequisicao", "CASE WHEN conv.con_codigo <> conprinc.con_codigo THEN d.req_matricularepasse ELSE d.req_matricula END");
        campos.put("nomePlanoRequisicao", "d.req_nomeplano");
        campos.put("dataValidadeCarteiraRequisicao", "CASE WHEN conv.con_codigo <> conprinc.con_codigo THEN d.req_validadecarteirarepasse ELSE d.req_validadecarteira END");
        campos.put("observacaoRequisicao", "d.req_obs");
        campos.put("validadeGuiaRequisicao", "CASE WHEN conv.con_codigo <> conprinc.con_codigo THEN d.req_validadeguiarepasse ELSE d.req_validadeguia END");
        campos.put("avisarPacienteRequisicao", "d.req_avisarpaciente");
        campos.put("titularRequisicao", "d.req_titular");
        campos.put("guiaRequisicao", "CASE WHEN conv.con_codigo <> conprinc.con_codigo THEN d.req_guiarepasse ELSE d.req_guia END");
        campos.put("valorExamesRequisicao", "b.fre_totalexames");
        campos.put("valorMateriaisRequisicao", "b.fre_totalmateriais");
        campos.put("valorExamesCHRequisicao", "b.fre_totalch");
        campos.put("quartoRequisicao", "d.req_quarto");
        campos.put("leitoRequisicao", "d.req_leito");
        campos.put("codigoAla", "d.ala_codigo");
        campos.put("descricaoAla", "ala.ala_descricao");
        campos.put("codigoSituacao", "sit.sit_codigo");
        campos.put("descricaoSituacao", "sit.sit_descricao");
        campos.put("codigoUsuario", "usr.usr_codigo");
        campos.put("nomeUsuario", "usr.usr_nome");
        campos.put("codigoUsuarioFatura", "usrfatura.usr_codigo");
        campos.put("nomeUsuarioFatura", "usrfatura.usr_nome");
        campos.put("codigoCidadeConvenio", "cidcon.cid_codigo");
        campos.put("descricaoCidadeConvenio", "cidcon.cid_nome");
        campos.put("estadoCidadeConvenio", "cidcon.cid_uf");
        campos.put("codigoCidadeCobrancaConvenio", "cidcobcon.cid_codigo");
        campos.put("descricaoCidadeCobrancaConvenio", "cidcobcon.cid_nome");
        campos.put("estadoCidadeCobrancaConvenio", "cidcobcon.cid_uf");
        campos.put("codigoCidadeConvenioFatura", "cidconfat.cid_codigo");
        campos.put("descricaoCidadeConvenioFatura", "cidconfat.cid_nome");
        campos.put("estadoCidadeConvenioFatura", "cidconfat.cid_uf");
        campos.put("codigoCidadeCobrancaConvenioFatura", "cidcobconfat.cid_codigo");
        campos.put("descricaoCidadeCobrancaConvenioFatura", "cidcobconfat.cid_nome");
        campos.put("estadoCidadeCobrancaConvenioFatura", "cidcobconfat.cid_uf");
        campos.put("codigoCidadeMedico", "cidmed.cid_codigo");
        campos.put("descricaoCidadeMedico", "cidmed.cid_nome");
        campos.put("estadoCidadeMedico", "cidmed.cid_uf");
        campos.put("codigoCidadeDestino", "ciddes.cid_codigo");
        campos.put("descricaoCidadeDestino", "ciddes.cid_nome");
        campos.put("estadoCidadeDestino", "ciddes.cid_uf");
        campos.put("codigoCidadeColeta", "cidcol.cid_codigo");
        campos.put("descricaoCidadeColeta", "cidcol.cid_nome");
        campos.put("estadoCidadeColeta", "cidcol.cid_uf");
        campos.put("codigoCidadeUnidadeSaude", "ciduns.cid_codigo");
        campos.put("descricaoCidadeUnidadeSaude", "ciduns.cid_nome");
        campos.put("estadoCidadeUnidadeSaude", "ciduns.cid_uf");
        campos.put("codigoCidadePaciente", "cidpac.cid_codigo");
        campos.put("descricaoCidadePaciente", "cidpac.cid_nome");
        campos.put("estadoCidadePaciente", "cidpac.cid_uf");
        campos.put("codigoBairroConvenio", "baicon.bai_codigo");
        campos.put("descricaoBairroConvenio", "baicon.bai_descricao");
        campos.put("codigoBairroCobrancaConvenio", "baicobcon.bai_codigo");
        campos.put("descricaoBairroCobrancaConvenio", "baicobcon.bai_descricao");
        campos.put("codigoBairroConvenioFatura", "baiconfat.bai_codigo");
        campos.put("descricaoBairroConvenioFatura", "baiconfat.bai_descricao");
        campos.put("codigoBairroCobrancaConvenioFatura", "baicobconfat.bai_codigo");
        campos.put("descricaoBairroCobrancaConvenioFatura", "baicobconfat.bai_descricao");
        campos.put("codigoBairroMedico", "baimed.bai_codigo");
        campos.put("descricaoBairroMedico", "baimed.bai_descricao");
        campos.put("codigoBairroDestino", "baides.bai_codigo");
        campos.put("descricaoBairroDestino", "baides.bai_descricao");
        campos.put("codigoBairroColeta", "baicol.bai_codigo");
        campos.put("descricaoBairroColeta", "baicol.bai_descricao");
        campos.put("codigoBairroPaciente", "baipac.bai_codigo");
        campos.put("descricaoBairroPaciente", "baipac.bai_descricao");
        campos.put("codigoDestino", "des.des_codigo");
        campos.put("descricaoDestino", "des.des_descricao");
        campos.put("enderecoDestino", "des.des_endereco");
        campos.put("complementoDestino", "des.des_complemento");
        campos.put("cepDestino", "des.des_cep");
        campos.put("foneDestino", "des.des_fone");
        campos.put("codigoColeta", "col.col_codigo");
        campos.put("descricaoColeta", "col.col_descricao");
        campos.put("enderecoColeta", "col.col_endereco");
        campos.put("complementoColeta", "col.col_complemento");
        campos.put("cepColeta", "col.col_cep");
        campos.put("foneColeta", "col.col_fone");
        campos.put("codigoUnidadeSaude", "uns.uns_codigo");
        campos.put("descricaoUnidadeSaude", "uns.uns_descricao");
        campos.put("enderecoUnidadeSaude", "uns.uns_endereco");
        campos.put("complementoUnidadeSaude", "uns.uns_complemento");
        campos.put("cepUnidadeSaude", "uns.uns_cep");
        campos.put("foneUnidadeSaude", "uns.uns_fone");
        campos.put("codigoFilial", "g.fil_codigo");
        campos.put("descricaoFilial", "g.fil_descricao");
        campos.put("cnpjFilial", "g.fil_cnpj");
        campos.put("enderecoFilial", "g.fil_endereco");
        campos.put("complementoFilial", "g.fil_complemento");
        campos.put("cepFilial", "g.fil_cep");
        campos.put("foneFilial", "g.fil_fone");
        campos.put("faxFilial", "g.fil_fax");
        campos.put("razaoSocialFilial", "g.fil_razaosocial");
        campos.put("codigoCidadeFilial", "cidfil.cid_codigo");
        campos.put("descricaoCidadeFilial", "cidfil.cid_nome");
        campos.put("estadoCidadeFilial", "cidfil.cid_uf");
        campos.put("codigoBairroFilial", "baifil.bai_codigo");
        campos.put("descricaoBairroFilial", "baifil.bai_descricao");
        campos.put("nomeMedico", "med.med_nome");
        campos.put("tratamentoMedico", "med.med_abrev");
        campos.put("enderecoMedico", "med.med_endereco");
        campos.put("numeroEnderecoMedico", "med.med_numeroendereco");
        campos.put("tipoLogradouroMedico", "med.med_tipologradouroendereco");
        campos.put("complementoMedico", "med.med_complemento");
        campos.put("cepMedico", "med.med_cep");
        campos.put("foneMedico", "med.med_fone");
        campos.put("celularMedico", "med.med_celular");
        campos.put("faxMedico", "med.med_fax");
        campos.put("emailMedico", "med.med_email");
        campos.put("codigoConvenio", "conv.con_codigo");
        campos.put("fantasiaConvenio", "conv.con_fantasia");
        campos.put("razaoSocialConvenio", "conv.con_razao");
        campos.put("enderecoConvenio", "conv.con_endereco");
        campos.put("numeroEnderecoConvenio", "conv.con_numeroendereco");
        campos.put("tipoLogradouroConvenio", "conv.con_tipologradouroendereco");
        campos.put("complementoConvenio", "conv.con_complemento");
        campos.put("cepConvenio", "conv.con_cep");
        campos.put("cnpjConvenio", "conv.con_cnpjcpf");
        campos.put("inscricaoConvenio", "conv.con_inscrest");
        campos.put("enderecoCobrancaConvenio", "conv.con_endcobranca");
        campos.put("complementoCobrancaConvenio", "conv.con_complcobranca");
        campos.put("cepCobrancaConvenio", "conv.con_cepcobranca");
        campos.put("foneConvenio", "conv.con_fone");
        campos.put("email1Convenio", "conv.con_email1");
        campos.put("email2Convenio", "conv.con_email2");
        campos.put("siteConvenio", "conv.con_site");
        campos.put("cid10", " (select c10.c10_codigo from requisicaocid10 c10 where d.fil_codigo = c10.fil_codigo and d.req_codigo = c10.req_codigo limit 1) ");
        campos.put("uncpMedico", "''");
        campos.put("valorCHConvenio", "conv.con_valorch");
        campos.put("conselhoMedico", "med.med_conselho");
        campos.put("crmMedico", "med.med_crm");
        campos.put("estadoCrmMedico", "med.med_uf");
        campos.put("grade", "''");
        campos.put("uncpLaboratorio", "''");
        campos.put("mesAnoFaturamentoEletronico", "''");
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            campos.put("percentualBonusConvenio", "conv.con_bonus");
            campos.put("percentualAcrescimoConvenio", "conv.con_acrescimo");
            campos.put("percentualBonusConvenioFatura", "convfat.con_bonus");
            campos.put("percentualAcrescimoConvenioFatura", "convfat.con_acrescimo");
        }
        campos.put("codigoConvenioFatura", "convfat.con_codigo");
        campos.put("fantasiaConvenioFatura", "convfat.con_fantasia");
        campos.put("razaoSocialConvenioFatura", "convfat.con_razao");
        campos.put("enderecoConvenioFatura", "convfat.con_endereco");
        campos.put("numeroEnderecoConvenioFatura", "convfat.con_numeroendereco");
        campos.put("tipoLogradouroConvenioFatura", "convfat.con_tipologradouroendereco");
        campos.put("complementoConvenioFatura", "convfat.con_complemento");
        campos.put("cepConvenioFatura", "convfat.con_cep");
        campos.put("cnpjConvenioFatura", "convfat.con_cnpjcpf");
        campos.put("inscricaoConvenioFatura", "convfat.con_inscrest");
        campos.put("enderecoCobrancaConvenioFatura", "convfat.con_endcobranca");
        campos.put("complementoCobrancaConvenioFatura", "convfat.con_complcobranca");
        campos.put("cepCobrancaConvenioFatura", "convfat.con_cepcobranca");
        campos.put("foneConvenioFatura", "convfat.con_fone");
        campos.put("email1ConvenioFatura", "convfat.con_email1");
        campos.put("email2ConvenioFatura", "convfat.con_email2");
        campos.put("siteConvenioFatura", "convfat.con_site");
        campos.put("codigoPaciente", "pac.pac_codigo");
        campos.put("nomePaciente", "pac.pac_nome");
        campos.put("sexoPaciente", "pac.pac_sexo");
        campos.put("dataNascimentoPaciente", "pac.pac_datanasc");
        campos.put("rgPaciente", "pac.pac_rg");
        campos.put("cpfPaciente", "pac.pac_cpf");
        campos.put("fonePaciente", "pac.pac_fone");
        campos.put("celularPaciente", "pac.pac_celular");
        campos.put("faxPaciente", "pac.pac_fax");
        campos.put("foneComercialPaciente", "pac.pac_fonecomercial");
        campos.put("enderecoPaciente", "pac.pac_endereco");
        campos.put("numeroEnderecoPaciente", "pac.pac_numeroendereco");
        campos.put("tipoLogradouroPaciente", "pac.pac_tipologradouroendereco");
        campos.put("complementoPaciente", "pac.pac_complemento");
        campos.put("cepPaciente", "pac.pac_cep");
        campos.put("emailPaciente", "pac.pac_email");
        campos.put("foneContatoPaciente", "pac.pac_fonecontato");
        campos.put("contatoPaciente", "pac.pac_nomecontato");
        campos.put("profissaoPaciente", "pac.pac_profissao");
        campos.put("cartaoSUSPaciente", "pac.pac_cartaosus");
        campos.put("codigoFilialFaturada", "b.fil_kodigo");
        campos.put("codigoFilialRequisicaoFaturada", "b.fil_kodigo || '_' || d.req_codigo");
        campos.put("codigoFatura", "a.fat_codigo");
        campos.put("perguntasRequisicao", "d.req_perguntas");
        campos.put("codigoExame", "c.exa_codfilho");
        campos.put("descricaoExame", "exm.exa_descricao");
        campos.put("codigoExamePai", "c.exa_codigo");
        campos.put("codigoMaterialPai", "c.mco_codigo");
        campos.put("chExame", "c.fer_totalch");
        campos.put("valorExame", "c.fer_total");
        campos.put("valorExameRequisicao", "calculaprecototalexamerequisicao(c.fil_codigo, conv.con_codigo, c.req_codigo, c.exa_codigo, c.mco_codigo, false, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, conv.con_precosdiferenciados, conv.con_reajuste, conv.con_cobrmaterial, conv.con_percpgtomaterial, conv.con_percpgto, conv.con_tpcalcfatu, conv.con_tpcalcch, conv.con_perguntarpercbalcao, conv.con_acrescimo, conv.con_bonus, conv.tpe_codigo, conv.con_acrescimoporte, conv.con_acrescimouco, conv.con_descontoporte, conv.con_descontouco, conv.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", exr.met_codigo)");
        campos.put("valorDescontoRequisicao", "COALESCE(d.req_vlrdesconto, 0)");
        campos.put("valorAcrescimoRequisicao", "COALESCE(d.req_vlracrescimo, 0)");
        StringBuilder campoAux = new StringBuilder();
        campoAux.append("COALESCE((select SUM(aux.valor) from (select calculaprecototalexamerequisicao(fer.fil_codigo, con.con_codigo ,fer.req_codigo ,fer.exa_codigo ,fer.mco_codigo ,false ,false ,true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, conv.con_precosdiferenciados, conv.con_reajuste, conv.con_cobrmaterial, conv.con_percpgtomaterial, conv.con_percpgto, conv.con_tpcalcfatu, conv.con_tpcalcch, conv.con_perguntarpercbalcao, conv.con_acrescimo, conv.con_bonus, conv.tpe_codigo, conv.con_acrescimoporte, conv.con_acrescimouco, conv.con_descontoporte, conv.con_descontouco, conv.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(") as valor ");
        campoAux.append("            from faturaexamerequisicao fer ");
        campoAux.append("                ,convenios con ");
        campoAux.append("           where fer.fil_codigo = c.fil_codigo ");
        campoAux.append("             and fer.fat_codigo = c.fat_codigo ");
        campoAux.append("             and fer.fil_kodigo = c.fil_Kodigo ");
        campoAux.append("             and fer.req_codigo = c.req_codigo ");
        campoAux.append("             and con.con_codigo = b.con_codigo) as aux), 0) ");
        campoAux.append(" - COALESCE(d.req_vlrdesconto) + COALESCE(d.req_vlracrescimo)");
        campos.put("valorTotalExamesRequisicao", campoAux.toString());
        campos.put("custoCBHPMExame", "c.fer_custocbhpm");
        campos.put("UCOCBHPMExame", "c.fer_ucocbhpm");
        campos.put("porteCBHPMExame", "c.fer_portecbhpm");
        campos.put("valorPorteCBHPMExame", "c.fer_valorportecbhpm");
        campos.put("valorMateriaisExame", "c.fer_totalmateriais");
        campos.put("cbhpmExame", "emc.emc_codigocbhpm");
        campos.put("numeroNotaIPERGSExame", " c.fer_notaipergs");
        campos.put("codigoMaterial", "mcol.mco_codigo");
        campos.put("descricaoMaterial", "mcol.mco_descricao");
        campos.put("abreviaturaMaterial", "mcol.mco_abreviatura");
        campos.put("codigoPrazo", "prazo.prz_codigo");
        campos.put("descricaoPrazo", "prazo.prz_descricao");
        campos.put("codigoMetodo", "met.met_codigo");
        campos.put("descricaoMetodo", "met.met_descricao");
        campos.put("codigoExameAgrupado", "c.exa_codfilho");
        campos.put("descricaoExameAgrupado", "exm.exa_descricao");
        campos.put("codigoExamePaiAgrupado", "c.exa_codigo");
        campos.put("codigoMaterialPaiAgrupado", "c.mco_codigo");
        campos.put("chExameAgrupado", "c.fer_totalch");
        campos.put("valorExameAgrupado", "c.fer_total");
        campos.put("custoCBHPMExameAgrupado", "c.fer_custocbhpm");
        campos.put("UCOCBHPMExameAgrupado", "c.fer_ucocbhpm");
        campos.put("porteCBHPMExameAgrupado", "c.fer_portecbhpm");
        campos.put("valorPorteCBHPMExameAgrupado", "c.fer_valorportecbhpm");
        campos.put("valorMateriaisExameAgrupado", "c.fer_totalmateriais");
        campos.put("cbhpmExameAgrupado", "emc.emc_codigocbhpm");
        campos.put("codigoMaterialAgrupado", "mcol.mco_codigo");
        campos.put("descricaoMaterialAgrupado", "mcol.mco_descricao");
        campos.put("abreviaturaMaterialAgrupado", "mcol.mco_abreviatura");
        campos.put("codigoPrazoAgrupado", "prazo.prz_codigo");
        campos.put("descricaoPrazoAgrupado", "prazo.prz_descricao");
        campos.put("codigoMetodoAgrupado", "met.met_codigo");
        campos.put("descricaoMetodoAgrupado", "met.met_descricao");
        campos.put("dataInicioFatura", "a.fat_dtinicio");
        campos.put("dataFinalFatura", "a.fat_dtfim");
        campos.put("dataEmissaoFatura", "a.fat_dtemis");
        campos.put("dataVencimentoFatura", "a.fat_dtvenc");
        campos.put("valorAdicionalFatura", "a.fat_adicional");
        campos.put("valorDespesaCobrancaFatura", "a.fat_despcobranca");
        campos.put("percentualDescontoFatura", "a.fat_percdesconto");
        campos.put("totalMateriaisFatura", "a.fat_totalmateriais");
        campos.put("percentualAcrescimoFatura", "a.fat_percacrescimo");
        campos.put("totalCHFatura", "a.fat_totalexamesch");
        campos.put("totalExamesFatura", "a.fat_totalexames");
        campos.put("mensagemFatura", "a.fat_mensagem");
        campos.put("quantidadeExamesFatura", "a.fat_qtdeexames");
        campos.put("quantidadeRequisicoesFatura", "a.fat_qtderequisicao");
        campos.put("quantidadeGuiasFatura", "a.fat_qtdeguias");
        campos.put("descricaoAcrescimo", "a.fat_descricaoacrescimo");
        campos.put("descricaoDesconto", "a.fat_descricaodesconto");
        campos.put("numeroNotaFiscal", "null");
        campos.put("dataEmissaoNotaFiscal", "null");
        campos.put("descricaoProdutoRequisicao", "d.req_descricaoproduto");
        campos.put("dataFabricacaoProdutoRequisicao", "d.req_datafabricacao");
        campos.put("numeroRegistroProdutoRequisicao", "d.req_numeroregistroproduto");
        campos.put("temperaturaColetaProdutoRequisicao", "d.req_temperaturacoletaproduto");
        campos.put("numeroLoteProdutoRequisicao", "d.req_numeroloteproduto");
        campos.put("dataValidadeProdutoRequisicao", "d.req_datavalidade");
        campos.put("marcaProdutoRequisicao", "d.req_marcaproduto");
        campos.put("dataColetaProdutoRequisicao", "d.req_datacoletaproduto");
        campos.put("horaColetaProdutoRequisicao", "d.req_horacoletaproduto");
        campos.put("lacreProdutoRequisicao", "d.req_lacreproduto");
        campos.put("lacreContraProvaProdutoRequisicao", "d.req_lacreprodutocontra");
        campos.put("lacreContraProvaEmpresaProdutoRequisicao", "d.req_lacreprodutocontraempresa");
        campos.put("documentoReferenciaProdutoRequisicao", "d.req_doctoreferenciaproduto");
        campos.put("temperaturaRecebimentoProdutoRequisicao", "d.req_temperaturarecebimento");
        campos.put("caracteristicasSanitariasProdutoRequisicao", "d.req_sanitariasproduto");
        campos.put("condicoesAmbientaisProdutoRequisicao", "d.req_condicoesambproduto");
        campos.put("procedimentoColetaProdutoRequisicao", "d.req_procedimentocoletaproduto");
        campos.put("tipoRecebimentoProdutoRequisicao", "d.req_tiporecebimentoproduto");
        campos.put("partidaProdutoRequisicao", "d.req_partidaproduto");
        campos.put("qtdeAmostrasProdutoRequisicao", "d.req_qtdeamostraproduto");
        campos.put("qtdeUnidadeProdutoRequisicao", "d.req_qtdeunidadeproduto");
        campos.put("codigoUnidadeProdutoRequisicao", "d.unm_codigo");
        campos.put("descricaoUnidadeProdutoRequisicao", "unidademedida.unm_descricao");
        campos.put("codigoEmbalagemProdutoRequisicao", "d.emb_codigo");
        campos.put("descricaoEmbalagemProdutoRequisicao", "emb.emb_descricao");
        campos.put("anoPRPProdutoRequisicao", "d.req_anoprpproduto");
        campos.put("cicloPRPProdutoRequisicao", "d.req_cicloprpproduto");
        campos.put("amostraPRPProdutoRequisicao", "d.req_amostraprpproduto");
        campos.put("amostraSupervisaoPRPProdutoRequisicao", "d.req_amostrasupprpproduto");
        campos.put("horaInicioTurnoPRPProdutoRequisicao", "d.req_horainicioturnoprpproduto");
        campos.put("linhaPRPProdutoRequisicao", "d.req_linhaprpproduto");
        campos.put("volumeAbatePRPProdutoRequisicao", "d.req_volumeabateprpproduto");
        campos.put("turnoPRPProdutoRequisicao", "d.req_turnoprpproduto");
        campos.put("areaProdutoRequisicao", "d.req_areaproduto");
        campos.put("nomeResponsavelRequisicao_", "paccontatos.pco_nome");
        campos.put("cargoResponsavelRequisicao_", "paccontatos.pco_cargo");
        campos.put("emailResponsavelRequisicao_", "paccontatos.pco_email");
        campos.put("foneResponsavelRequisicao_", "paccontatos.pco_fone");
        campos.put("nomeResponsavelRequisicao", "ent.ent_fantasia");
        campos.put("cargoResponsavelRequisicao", "ent.ent_cargo");
        campos.put("emailResponsavelRequisicao", "ent.ent_email");
        campos.put("foneResponsavelRequisicao", "ent.ent_fone");
        campos.put("dataRecebimentoProdutoRequisicao", "d.req_datarecebimentoproduto");
        campos.put("horaRecebimentoProdutoRequisicao", "d.req_horarecebimentoproduto");
        campos.put("localColetaProdutoRequisicao", "d.req_localcoletaproduto");
        campos.put("numeroSolicitacaoProdutoRequisicao", "d.req_nrsolicitacaoproduto");
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            campos.put("codigoProdutoAlimento", "pal.pal_codigo");
            campos.put("descricaoProdutoAlimento", "pal.pal_descricao");
            campos.put("codigoCategoriaProdutoAlimento", "cpl.cpl_codigo");
            campos.put("descricaoCategoriaProdutoAlimento", "cpl.cpl_descricao");
            campos.put("tipoSetor", "set.set_tipoalimentos");
            campos.put("ordemCompra", "d.req_ordemcompra");
            campos.put("quantidadeTotalFisicoQuimico", "''");
            campos.put("valorTotalFisicoQuimico", "''");
            campos.put("quantidadeTotalMicrobiologia", "''");
            campos.put("valorTotalMicrobiologia", "''");
            campos.put("quantidadeTotalOutros", "''");
            campos.put("valorTotalOutros", "''");
            campos.put("quantidadeTotalCromatografia", "''");
            campos.put("valorTotalCromatografia", "''");
        } else {
            campos.put("codigoProdutoAlimento", "''");
            campos.put("descricaoProdutoAlimento", "''");
            campos.put("codigoCategoriaProdutoAlimento", "''");
            campos.put("descricaoCategoriaProdutoAlimento", "''");
        }
        campos.put("razaoSocialPaciente", "pac.pac_razaosocial");
        campos.put("cnpjPaciente", "pac.pac_cnpj");
        campos.put("inscricaoEstadualPaciente", "pac.pac_ie");
        campos.put("proprietarioPaciente", "pac.pac_proprietario");
        campos.put("sifPaciente", "pac.pac_sif");
        campos.put("empresaPaciente", "entidadepaciente.ent_razaosocial");
        campos.put("codigoEmpresaPaciente", "entidadepaciente.ent_codigo");
        campos.put("enderecoCobrancaPaciente", "pac.pac_enderecocobranca");
        campos.put("numeroEnderecoCobrancaPaciente", "pac.pac_numeroenderecocobranca");
        campos.put("tipoLogradouroCobrancaPaciente", "pac.pac_tipologradouroendcobranca");
        campos.put("complementoCobrancaPaciente", "pac.pac_complementocobranca");
        campos.put("cepCobrancaPaciente", "pac.pac_cepcobranca");
        campos.put("foneCobrancaPaciente", "pac.pac_fonecobranca");
        campos.put("responsavelCobrancaPaciente", "pac.pac_responsavelcobranca");
        campos.put("codigoBairroCobrancaPaciente", "pac.bai_codigocobranca");
        campos.put("descricaoBairroCobrancaPaciente", "baicobranca.bai_descricao");
        campos.put("codigoCidadeCobrancaPaciente", "pac.cid_codigocobranca");
        campos.put("descricaoCidadeCobrancaPaciente", "cidcobranca.cid_nome");
        campos.put("estadoCidadeCobrancaPaciente", "cidcobranca.cid_uf");
        campos.put("fantasiaResponsavelRequisicao", "ent.ent_fantasia");
        campos.put("razaoSocialResponsavelRequisicao", "ent.ent_razaosocial");
        campos.put("cargoResponsavelRequisicao", "ent.ent_cargo");
        campos.put("rgResponsavelRequisicao", "ent.ent_rgie");
        campos.put("cpfResponsavelRequisicao", "ent.ent_cpfcnpj");
        campos.put("codigoConvenioPrincipal", "COALESCE(conprinc.con_codigo, conv.con_codigo)");
        campos.put("razaoConvenioPrincipal", "COALESCE(conprinc.con_razao, conv.con_razao)");
        campos.put("fantasiaConvenioPrincipal", "COALESCE(conprinc.con_fantasia, conv.con_fantasia)");
        campos.put("tipoLogradouroConvenioPrincipal", "COALESCE(conprinc.con_tipologradouroendereco, conv.con_tipologradouroendereco)");
        campos.put("numeroEnderecoConvenioPrincipal", "COALESCE(conprinc.con_numeroendereco, conv.con_numeroendereco)");
        campos.put("enderecoConvenioPrincipal", "COALESCE(conprinc.con_endereco, conv.con_endereco)");
        campos.put("enderecoConvenioPrincipal", "COALESCE(conprinc.con_complemento, conv.con_complemento)");
        campos.put("cepConvenioPrincipal", "COALESCE(conprinc.con_cep, conv.con_cep)");
        campos.put("cnpjConvenioPrincipal", "COALESCE(conprinc.con_cnpjcpf, conv.con_cnpjcpf)");
        campos.put("inscricaoConvenioPrincipal", "COALESCE(conprinc.con_inscrest, conv.con_inscrest)");
        campos.put("enderecoCobrancaConvenioPrincipal", "COALESCE(conprinc.con_endcobranca, conv.con_endcobranca)");
        campos.put("numeroEnderecoCobrancaConvenioPrincipal", "COALESCE(conprinc.con_numeroendcobranca, conv.con_numeroendcobranca)");
        campos.put("tipoLogradouroCobrancaConvenioPrincipal", "COALESCE(conprinc.con_tipologradouroendcobranca, conv.con_tipologradouroendcobranca)");
        campos.put("complementoCobrancaConvenioPrincipal", "COALESCE(conprinc.con_complcobranca, conv.con_complcobranca)");
        campos.put("cepCobrancaConvenioPrincipal", "COALESCE(conprinc.con_cepcobranca, conv.con_cepcobranca)");
        campos.put("foneConvenioPrincipal", "COALESCE(conprinc.con_fone, conv.con_fone)");
        campos.put("email1ConvenioPrincipal", "COALESCE(conprinc.con_email1, conv.con_email1)");
        campos.put("email2ConvenioPrincipal", "COALESCE(conprinc.con_email2, conv.con_email2)");
        campos.put("siteConvenioPrincipal", "COALESCE(conprinc.con_site, conv.con_site)");
        campos.put("matriculaConvenioPrincipal", "d.req_matricula");
        campos.put("ordemPaciente", "CASE WHEN conv.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(d.req_titular), ''), pac.pac_nome) ELSE pac.pac_nome END");
        campos.put("ambExameAgrupado", "");
        campos.put("dataColetaExameAgrupado", "exr.exr_datamaterial");
        campos.put("horaColetaExameAgrupado", "exr.exr_datamaterial");
        campos.put("usuarioColetaExameAgrupado", "exr.usr_codmaterial");
        campos.put("situacaoExameAgrupado", "exr.exr_situacao");
        campos.put("descricaoMetodoAgrupado", "met.met_descricao");
        campos.put("materialInformadoExameAgrupado", "exr.exr_descricaomaterial");
        campos.put("autorizacaoExameAgrupado", "exr.exr_codautorizacao");
        campos.put("dataColetaExame", "exr.exr_datamaterial");
        campos.put("horaColetaExame", "exr.exr_datamaterial");
        campos.put("situacaoExame", "exr.exr_situacao");
        campos.put("autorizacaoExame", "exr.exr_codautorizacao");
        campos.put("motivoPrazoCarenciaExame", "exr.exr_motivoprazo");
        campos.put("usuarioColetaExame", "exr.usr_codmaterial");
        campos.put("materialInformadoExame", "exr.exr_descricaomaterial");
        campos.put("ambExame", "''");
        campos.put("dataColetaExameAgrupado", "exr.exr_datamaterial");
        campos.put("horaColetaExameAgrupado", "exr.exr_datamaterial");
        campos.put("situacaoExameAgrupado", "exr.exr_situacao");
        campos.put("autorizacaoExameAgrupado", "exr.exr_codautorizacao");
        campos.put("motivoPrazoCarenciaExameAgrupado", "exr.exr_motivoprazo");
        campos.put("usuarioColetaExameAgrupado", "exr.usr_codmaterial");
        campos.put("materialInformadoExameAgrupado", "exr.exr_descricaomaterial");
        campos.put("ambExameAgrupado", "''");
        campos.put("guiaExame", "COALESCE(exg.exg_guia, exr.exr_guia)");
        campos.put("ceiConvenio", "conv.con_cei");
        if (perguntasFilial.length > 0) {
            for (String s : perguntasFilial) {
                campos.put(s, "''");
            }
        }
        MAPA_TODOS_CAMPOS_DISPONIVEIS = campos;
        StringBuilder buf = new StringBuilder();
        buf.append(" from fatura a ");
        buf.append("left join faturarequisicao b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append("left join faturaexamerequisicao c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo and b.fil_kodigo = c.fil_kodigo and b.req_codigo = c.req_codigo ");
        buf.append("left join requisicao d on b.fil_kodigo = d.fil_codigo and b.req_codigo = d.req_codigo ");
        buf.append("left join examerequisicao exr on c.fil_kodigo = exr.fil_codigo and c.req_codigo = exr.req_codigo and c.exa_codigo = exr.exa_codigo and c.mco_codigo = exr.mco_codigo ");
        buf.append("left join examerequisicaoguiaagrupada exg on c.fil_kodigo = exg.fil_codigo and c.req_codigo = exg.req_codigo and c.exa_codigo = exg.exa_codigo and c.mco_codigo = exg.mco_codigo and c.exa_codfilho = exg.exa_codfilho and c.mco_codfilho = exg.mco_codfilho ");
        buf.append("left join filiais_postocoleta f on a.fil_codigo = f.fil_codigo ");
        buf.append("left join filiais_postocoleta g on c.fil_kodigo = g.fil_codigo ");
        buf.append("left join cidades cidfil on g.fil_codigo = cidfil.fil_codigo and g.cid_codigo = cidfil.cid_codigo ");
        buf.append("left join bairro baifil on g.fil_codigo = baifil.fil_codigo and g.bai_codigo = baifil.bai_codigo ");
        buf.append("left join situacao sit on d.fil_codigo = sit.fil_codigo and d.sit_codigo = sit.sit_codigo ");
        buf.append("left join usuario usr on d.usr_codigo = usr.usr_codigo ");
        buf.append("left join usuario usrfatura on a.usr_codigo = usrfatura.usr_codigo ");
        buf.append("left join convenios conv on b.fil_codigo = conv.fil_codigo and b.con_codigo = conv.con_codigo ");
        buf.append("left join cidades cidcon on conv.fil_codigo = cidcon.fil_codigo and conv.cid_codigo = cidcon.cid_codigo ");
        buf.append("left join bairro baicon on conv.fil_codigo = baicon.fil_codigo and conv.bai_codigo = baicon.bai_codigo ");
        buf.append("left join cidades cidcobcon on conv.fil_codigo = cidcobcon.fil_codigo and conv.cid_codcobranca = cidcobcon.cid_codigo ");
        buf.append("left join bairro baicobcon on conv.fil_codigo = baicobcon.fil_codigo and conv.bai_codcobranca = baicobcon.bai_codigo ");
        buf.append("left join convenios convfat on a.fil_codigo = convfat.fil_codigo and a.con_codigo = convfat.con_codigo ");
        buf.append("left join cidades cidconfat on convfat.fil_codigo = cidconfat.fil_codigo and convfat.cid_codigo = cidconfat.cid_codigo ");
        buf.append("left join bairro baiconfat on convfat.fil_codigo = baiconfat.fil_codigo and convfat.bai_codigo = baiconfat.bai_codigo ");
        buf.append("left join cidades cidcobconfat on convfat.fil_codigo = cidcobconfat.fil_codigo and convfat.cid_codcobranca = cidcobconfat.cid_codigo ");
        buf.append("left join bairro baicobconfat on convfat.fil_codigo = baicobconfat.fil_codigo and convfat.bai_codcobranca = baicobconfat.bai_codigo ");
        buf.append("left join medico med on d.fil_codigo = med.fil_codigo and d.med_conselho = med.med_conselho and d.med_crm = med.med_crm and d.med_uf = med.med_uf ");
        buf.append("left join cidades cidmed on med.fil_codigo = cidmed.fil_codigo and med.cid_codigo = cidmed.cid_codigo ");
        buf.append("left join bairro baimed on med.fil_codigo = baimed.fil_codigo and med.bai_codigo = baimed.bai_codigo ");
        buf.append("left join destino des on d.fil_codigo = des.fil_codigo and d.des_codigo = des.des_codigo ");
        buf.append("left join alahospital ala on d.fil_codigo = ala.fil_codigo and d.ala_codigo = ala.ala_codigo ");
        buf.append("left join cidades ciddes on des.fil_codigo = ciddes.fil_codigo and des.cid_codigo = ciddes.cid_codigo ");
        buf.append("left join bairro baides on des.fil_codigo = baides.fil_codigo and des.bai_codigo = baides.bai_codigo ");
        buf.append("left join coletas col on d.fil_codigo = col.fil_codigo and d.col_codigo = col.col_codigo ");
        buf.append("left join cidades cidcol on col.fil_codigo = cidcol.fil_codigo and col.cid_codigo = cidcol.cid_codigo ");
        buf.append("left join unidadesaude uns on d.fil_codigo = uns.fil_codigo and d.uns_codigo = uns.uns_codigo ");
        buf.append("left join cidades ciduns on uns.fil_codigo = ciduns.fil_codigo and uns.cid_codigo = ciduns.cid_codigo ");
        buf.append("left join bairro baicol on col.fil_codigo = baicol.fil_codigo and col.bai_codigo = baicol.bai_codigo ");
        buf.append("left join paciente pac on d.fil_codigo = pac.fil_codigo and d.pac_codigo = pac.pac_codigo ");
        buf.append("left join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
        buf.append("left join bairro baipac on pac.fil_codigo = baipac.fil_codigo and pac.bai_codigo = baipac.bai_codigo ");
        buf.append("left join exames exm on c.fil_kodigo = exm.fil_codigo and c.exa_codfilho = exm.exa_codigo ");
        buf.append("left join materialcoleta mcol on c.fil_kodigo = mcol.fil_codigo and c.mco_codfilho = mcol.mco_codigo ");
        buf.append("left join examematcoleta emc on c.fil_kodigo = emc.fil_codigo and c.exa_codfilho = emc.exa_codigo and c.mco_codfilho = emc.mco_codigo ");
        buf.append("left join prazoentrega prazo on emc.fil_codigo = prazo.fil_codigo and emc.prz_codigo = prazo.prz_codigo ");
        buf.append("left join metodologia met on emc.fil_codigo = met.fil_codigo and emc.met_codigo = met.met_codigo ");
        buf.append("left join unidademedida on d.fil_codigo = unidademedida.fil_codigo and d.unm_codigo = unidademedida.unm_codigo ");
        buf.append("left join pacientescontatos paccontatos on d.fil_codigo = paccontatos.fil_codigo and d.pac_codigo = paccontatos.pac_codigo and d.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join entidade ent on d.fil_codigo = ent.fil_codigo and d.ent_codigo = ent.ent_codigo ");
        buf.append("left join cidades cidcobranca on pac.fil_codigo = cidcobranca.fil_codigo and pac.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("left join bairro baicobranca on pac.fil_codigo = baicobranca.fil_codigo and pac.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("left join embalagemproduto emb on d.fil_codigo = emb.fil_codigo and d.emb_codigo = emb.emb_codigo ");
        if (ImprimirFatura.isAlimentos()) {
            buf.append("left join categoriaprodutoalimentos cpl on d.fil_codigo = cpl.fil_codigo and d.cpl_codigo = cpl.cpl_codigo ");
            buf.append("left join produtoalimentos pal on d.fil_codigo = pal.fil_codigo and pal.pal_codigo = d.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo ");
        }
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append("left join examesetor exmsetor on exm.fil_codigo = exmsetor.fil_codigo and exm.exa_codigo = exmsetor.exa_codigo ");
        }
        buf.append(" left join examesetor ese on exm.fil_codigo = ese.fil_codigo and exm.exa_codigo = ese.exa_codigo and ese.ese_default = TRUE ");
        buf.append(" left join setores set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        buf.append(" left join convenios \t     \tconprinc on d.fil_codigo = conprinc.fil_codigo and d.con_codigo      \t\t= conprinc.con_codigo ");
        buf.append(" left join conveniosrepasse\tcre \t\t on d.fil_codigo = cre.fil_codigo \t\t and conprinc.con_codigo \t= cre.con_codigo    \tand d.con_codigo = cre.con_codrepasse ");
        buf.append(" left join entidade\tentidadepaciente \ton d.fil_codigo = entidadepaciente.fil_codigo and d.ent_codempresa \t= entidadepaciente.ent_codigo ");
        LIGACOES = buf.toString();
    }
}

