/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.financeiro.faturamento.ResumoFaturamento;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.faturamento.AlterarValor;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RepaintManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.codec.binary.Base64;

public class FuncoesGerais {
    public static final int ADICIONAL = 1;
    public static final int DESPESAS = 2;
    public static final int DESCONTO = 3;

    public static LinhasTabela pegaModeloFatura(JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JScrollPane scroll;
            Component o = panel.getComponent(i);
            if (!(o instanceof JScrollPane) || !((scroll = (JScrollPane)o).getViewport().getView() instanceof JTable)) continue;
            return (LinhasTabela)((JTable)scroll.getViewport().getView()).getModel();
        }
        return null;
    }

    public static void atualizaModeloFatura(JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JScrollPane scroll;
            Component o = panel.getComponent(i);
            if (!(o instanceof JScrollPane) || !((scroll = (JScrollPane)o).getViewport().getView() instanceof JTable)) continue;
            int selecionado = ((JTable)scroll.getViewport().getView()).getSelectedRow();
            ((LinhasTabela)((JTable)scroll.getViewport().getView()).getModel()).fireTableStructureChanged();
            if (selecionado < 0) continue;
            ((JTable)scroll.getViewport().getView()).getSelectionModel().setSelectionInterval(selecionado, selecionado);
        }
    }

    public static int pegaLinhaSelecionada(JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JScrollPane scroll;
            Component o = panel.getComponent(i);
            if (!(o instanceof JScrollPane) || !((scroll = (JScrollPane)o).getViewport().getView() instanceof JTable)) continue;
            return ((JTable)scroll.getViewport().getView()).getSelectedRow();
        }
        return -1;
    }

    public static void repaintTabela(JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JScrollPane scroll;
            Component o = panel.getComponent(i);
            if (!(o instanceof JScrollPane) || !((scroll = (JScrollPane)o).getViewport().getView() instanceof JTable)) continue;
            JTable tabela = (JTable)scroll.getViewport().getView();
            ((DefaultTableModel)tabela.getModel()).fireTableCellUpdated(tabela.getRowCount() - 1, 1);
            if (tabela.getCellEditor() != null) {
                tabela.getCellEditor().stopCellEditing();
            }
            RepaintManager.currentManager(Laboratorio.getInstancia()).addInvalidComponent(tabela);
            RepaintManager.currentManager(Laboratorio.getInstancia()).validateInvalidComponents();
        }
    }

    public static void repaintTabela(JTable tabela) {
        if (tabela.getCellEditor() != null) {
            tabela.getCellEditor().stopCellEditing();
        }
        ((AbstractTableModel)tabela.getModel()).fireTableDataChanged();
        RepaintManager.currentManager(Laboratorio.getInstancia()).addInvalidComponent(tabela);
        RepaintManager.currentManager(Laboratorio.getInstancia()).validateInvalidComponents();
    }

    public static void repaintTabela(JPanel panel, int linha) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JScrollPane scroll;
            Component o = panel.getComponent(i);
            if (!(o instanceof JScrollPane) || !((scroll = (JScrollPane)o).getViewport().getView() instanceof JTable)) continue;
            JTable tabela = (JTable)scroll.getViewport().getView();
            ((DefaultTableModel)tabela.getModel()).fireTableCellUpdated(linha, 1);
            if (tabela.getCellEditor() != null) {
                tabela.getCellEditor().stopCellEditing();
            }
            RepaintManager.currentManager(Laboratorio.getInstancia()).addInvalidComponent(tabela);
            RepaintManager.currentManager(Laboratorio.getInstancia()).validateInvalidComponents();
        }
    }

    public static JTable pegaTabela(JPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JScrollPane scroll;
            Component o = panel.getComponent(i);
            if (!(o instanceof JScrollPane) || !((scroll = (JScrollPane)o).getViewport().getView() instanceof JTable)) continue;
            return (JTable)scroll.getViewport().getView();
        }
        return null;
    }

    public static void removeExamesDeselecionadosFaturamento(JPanel panel) {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(panel);
        for (int i = 0; linhas != null && i < linhas.getRowCount(); ++i) {
            if (!(linhas.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
            DadosFaturamento req = (DadosFaturamento)linhas.getValueAt(i, 0);
            ArrayList<DadosExameFaturamento> exames = req.getExames();
            for (int j = 0; j < exames.size(); ++j) {
                DadosExameFaturamento exa = exames.get(j);
                if (exa.getFaturar()) continue;
                exames.remove(j);
                --j;
            }
            if (exames.size() != 0) continue;
            linhas.removeLinha(i);
            --i;
        }
    }

    public static boolean haExamesFaturamento(JPanel panel) {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(panel);
        for (int i = 0; linhas != null && i < linhas.getRowCount(); ++i) {
            if (!(linhas.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
            DadosFaturamento req = (DadosFaturamento)linhas.getValueAt(i, 0);
            ArrayList<DadosExameFaturamento> exames = req.getExames();
            for (int j = 0; j < exames.size(); ++j) {
                DadosExameFaturamento exa = exames.get(j);
                if (!exa.getFaturar()) continue;
                return true;
            }
        }
        return false;
    }

    public static void mudaValor(Window owner, int campo, DadosTotalGeral dados) {
        AlterarValor alterar = null;
        if (campo == 1) {
            alterar = new AlterarValor(owner, true);
            alterar.setMensagem("Adicional");
            alterar.setValor(dados.getAdicional().doubleValue(), dados.getDescricaoAcrescimo());
        } else if (campo == 3) {
            alterar = new AlterarValor(owner, true);
            alterar.setMensagem("Desconto");
            alterar.setValor(dados.getPercentualBonus().doubleValue(), true, dados.getDescricaoDesconto());
        } else if (campo == 2) {
            alterar = new AlterarValor(owner, false);
            alterar.setMensagem("Despesas");
            alterar.setValor(dados.getCobranca().doubleValue(), "");
        }
        if (alterar != null) {
            alterar.setVisible(true);
            if (alterar.isOK()) {
                if (campo == 1) {
                    if (alterar.isPercentual()) {
                        dados.setAdicional(dados.getTotalExames().add(dados.getTotalMateriais()).multiply(new BigDecimal(String.valueOf(alterar.getValor()))).divide(new BigDecimal(100), dados.getCasasDecimais(), dados.getTipoArredondamento()));
                    } else {
                        dados.setAdicional(new BigDecimal(String.valueOf(alterar.getValor())).setScale(dados.getCasasDecimais(), dados.getTipoArredondamento()));
                    }
                    if (dados.getAdicional().compareTo(BigDecimal.ZERO) == 0) {
                        dados.setDescricaoAcrescimo("");
                    } else {
                        dados.setDescricaoAcrescimo(alterar.getDescricao());
                    }
                } else if (campo == 3) {
                    if (alterar.isPercentual()) {
                        dados.setPercentualBonus(new BigDecimal(String.valueOf(alterar.getValor())));
                    } else if (dados.getTotal().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal p = new BigDecimal(String.valueOf(alterar.getValor())).setScale(dados.getCasasDecimais(), dados.getTipoArredondamento()).multiply(new BigDecimal(100)).setScale(dados.getCasasDecimais(), dados.getTipoArredondamento());
                        BigDecimal divisor = dados.getTotalExames().add(dados.getTotalMateriais());
                        BigDecimal percentual = BigDecimal.ZERO;
                        if (divisor.compareTo(BigDecimal.ZERO) > 0) {
                            percentual = p.divide(divisor, 4, RoundingMode.UP);
                        }
                        dados.setPercentualBonus(percentual);
                    }
                    if (dados.getPercentualBonus().compareTo(BigDecimal.ZERO) == 0) {
                        dados.setDescricaoDesconto("");
                    } else {
                        dados.setDescricaoDesconto(alterar.getDescricao());
                    }
                } else if (campo == 2) {
                    if (alterar.isPercentual()) {
                        dados.setCobranca(dados.getTotal().multiply(new BigDecimal(String.valueOf(alterar.getValor()))).divide(new BigDecimal(100), dados.getCasasDecimais(), dados.getTipoArredondamento()));
                    } else {
                        dados.setCobranca(new BigDecimal(String.valueOf(alterar.getValor())).setScale(dados.getCasasDecimais(), dados.getTipoArredondamento()));
                    }
                }
                BigDecimal total = dados.getTotalExames().add(dados.getTotalMateriais());
                dados.setTotal(total.subtract(total.multiply(dados.getPercentualBonus()).divide(new BigDecimal(100), dados.getCasasDecimais(), dados.getTipoArredondamento())).add(dados.getAdicional()).add(dados.getCobranca()));
            }
        }
    }

    public static void reenviarRequisicaoWeb(Statement st, Statement st2, String filial, String codigoRequisicao) throws Exception {
        if (Variaveis.exportarWebFilial) {
            StringBuilder buf = new StringBuilder("select a.req_codigo, a.req_data, a.req_hora, b.des_descricao, a.des_codigo, ");
            buf.append("c.col_descricao, a.con_codigo, a.req_idade, a.req_anomes, d.pac_datanasc, a.req_senhaweb, a.ent_codigo, ");
            buf.append("a.med_conselho, a.med_crm, a.med_uf, b.des_enviarweb, a.req_total, a.req_totpago, a.pac_codigo ");
            buf.append("from requisicao a ");
            buf.append("left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
            buf.append("left join coletas c on a.fil_codigo = c.fil_codigo and a.col_codigo = c.col_codigo ");
            buf.append("left join paciente d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo ");
            buf.append("where a.fil_codigo = ").append(filial);
            buf.append(" and a.req_codigo = ").append(codigoRequisicao);
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next() && rs.getBoolean("des_enviarweb")) {
                String[] comandoRequisicao = new String[38];
                comandoRequisicao[0] = "codigoBase";
                comandoRequisicao[1] = Variaveis.codigoBaseWeb;
                comandoRequisicao[2] = "codigoRequisicao";
                comandoRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(filial, rs.getString("req_codigo"), st2);
                comandoRequisicao[4] = "dataRequisicao";
                comandoRequisicao[5] = Funcoes.formataData(rs.getDate("req_data"));
                comandoRequisicao[6] = "horaRequisicao";
                comandoRequisicao[7] = rs.getString("req_hora");
                comandoRequisicao[8] = "destinoRequisicao";
                comandoRequisicao[9] = rs.getString("des_descricao");
                comandoRequisicao[10] = "coletaRequisicao";
                comandoRequisicao[11] = rs.getString("col_descricao");
                comandoRequisicao[12] = "codigoConvenioRequisicao";
                comandoRequisicao[13] = rs.getString("con_codigo");
                comandoRequisicao[14] = "idadeRequisicao";
                comandoRequisicao[15] = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                comandoRequisicao[16] = "dataNascimentoRequisicao";
                comandoRequisicao[17] = !DBUtil.campoNull(rs.getString("pac_datanasc")) ? Funcoes.formataData(rs.getDate("pac_datanasc")) : "";
                comandoRequisicao[18] = "senhaRequisicao";
                comandoRequisicao[19] = rs.getString("req_senhaweb");
                comandoRequisicao[20] = "conselhoMedicoRequisicao";
                comandoRequisicao[21] = rs.getString("med_conselho");
                comandoRequisicao[22] = "crmMedicoRequisicao";
                comandoRequisicao[23] = rs.getString("med_crm");
                comandoRequisicao[24] = "ufMedicoRequisicao";
                comandoRequisicao[25] = rs.getString("med_uf");
                comandoRequisicao[26] = "valorPagoRequisicao";
                comandoRequisicao[27] = Funcoes.limpaDecimal(rs.getString("req_totpago"));
                comandoRequisicao[28] = "valorRequisicao";
                comandoRequisicao[29] = Funcoes.limpaDecimal(rs.getString("req_total"));
                comandoRequisicao[30] = "codigoPacienteRequisicao";
                comandoRequisicao[31] = rs.getString("pac_codigo");
                comandoRequisicao[32] = "codigoDestinoRequisicao";
                comandoRequisicao[33] = rs.getString("des_codigo");
                comandoRequisicao[34] = "entidadeRequisicao";
                comandoRequisicao[35] = DBUtil.campoNull(rs.getString("ent_codigo")) ? "null" : rs.getString("ent_codigo");
                comandoRequisicao[36] = "resultadoPdfRequisicao";
                String tmp = "";
                if (ExportaWeb.isGerarPdfResultado(st, filial)) {
                    RetornoImpressaoResultados retornoPdf = ImpressaoResultados.imprimirExamesPdfWeb(filial, codigoRequisicao, false);
                    tmp = retornoPdf.getResultadoPdfWeb() != null ? new Base64().encodeAsString(retornoPdf.getResultadoPdfWeb()) : "";
                }
                comandoRequisicao[37] = tmp;
                DBUtil.insereExportaWeb(st, "requisicao", "I", comandoRequisicao);
                FuncoesGerais.exportaExameRequisicaoWeb(st, st2, filial, codigoRequisicao);
            }
        }
    }

    private static void exportaExameRequisicaoWeb(Statement st, Statement st2, String filial, String requisicao) throws Exception {
        boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, filial);
        StringBuilder buf = new StringBuilder();
        buf.append("select a.exa_codigo, a.mco_codigo, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.usr_codassina, b.usr_nome, a.exr_situacao, ");
        buf.append("a.exr_datamaterial, r.con_codigo, r.des_codigo, r.req_idade, r.req_anomes, a.met_codigo ");
        buf.append("from examerequisicao a ");
        buf.append("left join usuario b on a.usr_codassina = b.usr_codigo ");
        buf.append("left join requisicao r on a.fil_codigo = r.fil_codigo and a.req_codigo = r.req_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo = ").append(requisicao);
        ResultSet rs = Conexao.executeQuery(st2, buf);
        if (rs.next()) {
            DadosMaterial m = ExameUtil.getDadosMaterial(filial, rs.getInt("mco_codigo"));
            DadosExames d = ExameUtil.getDadosExame(filial, rs.getString("exa_codigo"), m);
            String[] comandoExameRequisicao = new String[32];
            comandoExameRequisicao[0] = "codigoBase";
            comandoExameRequisicao[1] = Variaveis.codigoBaseWeb;
            comandoExameRequisicao[2] = "codigoRequisicao";
            comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st);
            comandoExameRequisicao[4] = "codigoExameRequisicao";
            comandoExameRequisicao[5] = d.getCodigo();
            comandoExameRequisicao[6] = "materialExameRequisicao";
            comandoExameRequisicao[7] = String.valueOf(m.getCodigo());
            comandoExameRequisicao[8] = "descricaoMaterialExameRequisicao";
            comandoExameRequisicao[9] = m.getDescricao();
            comandoExameRequisicao[10] = "dataColetaExameRequisicao";
            comandoExameRequisicao[11] = rs.getString("exr_situacao") == null || rs.getString("exr_situacao").equals("F") || rs.getString("exr_situacao").equals("R") ? "" : Funcoes.formataData(rs.getDate("exr_datamaterial"));
            comandoExameRequisicao[12] = "horaColetaExameRequisicao";
            comandoExameRequisicao[13] = rs.getString("exr_situacao") == null || rs.getString("exr_situacao").equals("F") || rs.getString("exr_situacao").equals("R") || DBUtil.campoNull(rs.getString("exr_datamaterial")) || Funcoes.textoVazio(rs.getString("exr_datamaterial")) ? "" : Funcoes.formataHora(rs.getDate("exr_datamaterial"), false);
            comandoExameRequisicao[14] = "paginaExameRequisicao";
            comandoExameRequisicao[15] = "null";
            comandoExameRequisicao[16] = "ordemExameRequisicao";
            comandoExameRequisicao[17] = "null";
            comandoExameRequisicao[18] = "situacaoExameRequisicao";
            comandoExameRequisicao[19] = rs.getString("exr_situacao");
            comandoExameRequisicao[20] = "assinaturaExameRequisicao";
            comandoExameRequisicao[21] = rs.getString("usr_codassina");
            comandoExameRequisicao[22] = "nomeAssinaturaExameRequisicao";
            comandoExameRequisicao[23] = rs.getString("usr_nome");
            comandoExameRequisicao[24] = "resultadoExameRequisicao";
            String rst = "";
            Map<String, Object> map = null;
            if (!resultadoPdf && !Funcoes.textoVazio(rs.getString("exr_resultado"))) {
                String resultado = rs.getString("exr_resultado");
                map = ResultadosUtil.geraResultadoParaWeb(st, String.valueOf(filial), requisicao, d.getCodigo(), String.valueOf(m.getCodigo()), resultado, false);
                rst = map != null && map.get("laudo") != null ? (String)map.get("laudo") : "";
            }
            comandoExameRequisicao[25] = resultadoPdf || rst == null ? "" : rst;
            comandoExameRequisicao[26] = "dataEnvioExameRequisicao";
            comandoExameRequisicao[27] = "current_timestamp";
            comandoExameRequisicao[28] = "resultadoTextoExameRequisicao";
            String resultadoTexto = ResultadosUtil.geraResultadoTextoParaWeb(st, filial, rs.getString("con_codigo"), rs.getString("des_codigo"), rs.getInt("req_idade"), rs.getString("req_anomes"), d.getCodigo(), m.getCodigo(), rs.getString("met_codigo"), rst);
            comandoExameRequisicao[29] = resultadoPdf ? "" : resultadoTexto;
            DBUtil.insereExportaWeb(String.valueOf(filial), st, "requisicaoexame", "I", true, comandoExameRequisicao);
            Map imagens = null;
            String[] comandoExcluiImagens = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st), "codigoExameRequisicao", d.getCodigo(), "materialExameRequisicao", String.valueOf(m.getCodigo())};
            DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "D", comandoExcluiImagens);
            if (map != null && !(imagens = (Map)map.get("imagens")).isEmpty()) {
                String[] comandoInserirImagens = new String[12];
                comandoInserirImagens[0] = "codigoBase";
                comandoInserirImagens[2] = "codigoRequisicao";
                comandoInserirImagens[4] = "codigoExameRequisicao";
                comandoInserirImagens[6] = "materialExameRequisicao";
                comandoInserirImagens[8] = "codigoImagemExame";
                comandoInserirImagens[10] = "imagemExame";
                for (Integer i : imagens.keySet()) {
                    comandoInserirImagens[1] = Variaveis.codigoBaseWeb;
                    comandoInserirImagens[3] = IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st);
                    comandoInserirImagens[5] = d.getCodigo();
                    comandoInserirImagens[7] = String.valueOf(m.getCodigo());
                    comandoInserirImagens[9] = i.toString();
                    comandoInserirImagens[11] = (String)imagens.get(i);
                    DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "I", comandoInserirImagens);
                }
            }
            ExportaWeb.atualizaPaginaOrdemExameWeb(st, String.valueOf(Variaveis.filialPadrao), requisicao, Variaveis.codigoBaseWeb);
        }
    }

    public static boolean convenioRepasseFaturado(Statement st, DadosFaturamento dadosFaturamento) throws SQLException {
        StringBuilder buf = new StringBuilder("select con_codrepasse from requisicao where ");
        buf.append("fil_codigo = ").append(dadosFaturamento.getCodigoFilial());
        buf.append(" and req_codigo = ").append(dadosFaturamento.getRequisicao());
        ResultSet rs = Conexao.executeQuery(st, buf);
        return rs.next() && !DBUtil.campoNull(rs.getString("con_codrepasse")) && rs.getInt("con_codrepasse") == dadosFaturamento.getCodigoConvenio();
    }

    public static Integer[] achaExame(DadosFaturamento d, DadosExameFaturamento e, boolean buscarExamePai) {
        for (int i = 0; i < d.getExamesCount(); ++i) {
            DadosExameFaturamento x = d.getExame(i);
            if (!x.getCodigoExame().equals(e.getCodigoExame()) || x.getCodigoMaterial() != e.getCodigoMaterial()) continue;
            return new Integer[]{i};
        }
        if (buscarExamePai) {
            ArrayList<Integer> exames = new ArrayList<Integer>();
            for (int i = 0; i < d.getExamesCount(); ++i) {
                DadosExameFaturamento x = d.getExame(i);
                if (!x.getExamePai().getCodigo().equals(e.getCodigoExame()) || x.getExamePai().getMaterial() != e.getCodigoMaterial().intValue()) continue;
                exames.add(i);
            }
            if (!exames.isEmpty()) {
                return (Integer[])exames.toArray();
            }
            return null;
        }
        return null;
    }

    public static void montaLegenda(JPanel panel) {
        panel.setLayout(new FlowLayout(0, 5, 0));
        panel.setPreferredSize(new Dimension(100, 15));
        JLabel l1 = new JLabel("Requisi\u00e7\u00e3o incompleta (fat. eletr\u00f4nico)");
        JLabel l3 = new JLabel("Deve guia");
        JLabel l4 = new JLabel("Motivo de prazo");
        JLabel l5 = new JLabel("Sem confer\u00eancia");
        JLabel l2 = new JLabel("Exame proibido");
        l1.setIcon(ImagemUtils.criarImagemLegenda(8, 8, EditorDadosFaturamento.COR_INCOMPLETO_REQUISICAO, Color.BLACK));
        l3.setIcon(ImagemUtils.criarImagemLegenda(8, 8, EditorDadosFaturamento.COR_DEVE_GUIA, Color.BLACK));
        l4.setIcon(ImagemUtils.criarImagemLegenda(8, 8, EditorDadosFaturamento.COR_MOTIVO_PRAZO, Color.BLACK));
        l5.setIcon(ImagemUtils.criarImagemLegenda(8, 8, EditorDadosFaturamento.COR_SEM_CONFERENCIA, Color.BLACK));
        l2.setIcon(ImagemUtils.carregaImagemJalis("warning.png"));
        l1.setFont(new Font(l1.getFont().getName(), 0, 8));
        l3.setFont(new Font(l1.getFont().getName(), 0, 8));
        l4.setFont(new Font(l1.getFont().getName(), 0, 8));
        l5.setFont(new Font(l1.getFont().getName(), 0, 8));
        l2.setFont(new Font(l1.getFont().getName(), 0, 8));
        panel.add(l1);
        panel.add(l3);
        panel.add(l4);
        panel.add(l5);
        panel.add(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int pegaCodigoSetorExame(String filial, String exame) {
        int retorno;
        Statement st;
        block4: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select set_codigo from examesetor where ");
            buf.append("fil_codigo = ").append(filial);
            buf.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
            buf.append(" and ese_default = true ");
            retorno = -1;
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                retorno = rs.getInt("set_codigo");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Util: 620");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static String criaResumoFatura(Statement st, String filial, int qtdeParcelas, boolean retornarHTML, String ... faturas) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select sum(a.fer_total) as total, b.set_codigo, c.set_descricao ");
        buf.append("from faturaexamerequisicao a ");
        buf.append("left join examesetor b on a.fil_kodigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and b.ese_default = true ");
        buf.append("left join setores c on b.fil_codigo = c.fil_codigo and b.set_codigo = c.set_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        StringBuilder tmp = new StringBuilder();
        for (String s : faturas) {
            if (tmp.length() > 0) {
                tmp.append(", ");
            }
            tmp.append(s);
        }
        buf.append(" and fat_codigo in (").append(tmp.toString()).append(") ");
        buf.append("group by b.set_codigo, c.set_descricao ");
        buf.append(" order by c.set_descricao");
        ResultSet rs = Conexao.executeQuery(st, buf);
        ResumoFaturamento resumo = new ResumoFaturamento(qtdeParcelas);
        while (rs.next()) {
            resumo.adicionaSetor(rs.getInt("set_codigo"), rs.getString("set_descricao"), rs.getDouble("total"));
        }
        return retornarHTML ? resumo.getResumoHTML() : resumo.getResumo();
    }

    public static String validaNotaFiscalEmitida(Statement st, String filial, String codigoFatura, String situacaoNota) throws SQLException {
        boolean isEletronico = !Funcoes.textoVazio(ParametrosGerais.getIpWsNfse()) && !Funcoes.textoVazio(ParametrosGerais.getPortaWsNfse());
        StringBuilder buf = new StringBuilder();
        buf.append(" select nfi.nfi_numero as nfi_numero");
        buf.append("   from faturanotafiscal fnf ");
        buf.append("       ,notafiscal nfi ");
        buf.append("  where fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo ");
        if (!Funcoes.textoVazio(situacaoNota) && !isEletronico) {
            buf.append("    and nfi.nfi_situacao = '").append(situacaoNota).append("' ");
        }
        buf.append("    and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
        buf.append("      or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("') ) ");
        buf.append("    and fnf.fil_codigo = ").append(filial);
        buf.append("    and fnf.fat_codigo = ").append(codigoFatura);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        buf.delete(0, buf.length());
        int i = 0;
        while (rs.next()) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(rs.getString("nfi_numero"));
            ++i;
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    public static String validaNotaFiscalImpressa(Statement st, String filial, String codigoFatura) throws SQLException {
        return FuncoesGerais.validaNotaFiscalEmitida(st, filial, codigoFatura, "I");
    }

    public static Integer validaNotaFiscalImpressa(String filial, String codigoNotaFiscal) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nfi.nfi_codigo ");
        buf.append("   from notafiscal nfi ");
        buf.append("  where nfi.nfi_situacao = '").append("I").append("' ");
        buf.append("    and nfi.nfi_numerorps IS NULL ");
        buf.append("    and nfi.fil_codigo = ").append(filial);
        buf.append("    and nfi.fat_codigo = ").append(codigoNotaFiscal);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next() && !DBUtil.campoNull(rs.getString("nfi_codigo"))) {
            return rs.getInt("nfi_codigo");
        }
        return null;
    }

    public static String validaNotaFiscalCanceladaEstornada(String filial, String codigoNotaFiscal) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nfi.nfi_situacao ");
        buf.append("   from notafiscal nfi ");
        buf.append("  where nfi.nfi_situacao in ('").append("C").append("', '").append("E").append("') ");
        buf.append("    and nfi.nfi_numerorps IS NULL ");
        buf.append("    and nfi.fil_codigo = ").append(filial);
        buf.append("    and nfi.fat_codigo = ").append(codigoNotaFiscal);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next() && !DBUtil.campoNull(rs.getString("nfi_situacao"))) {
            return rs.getString("nfi_situacao");
        }
        return null;
    }
}

