/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ExamesNaoFaturar
extends AbstractDialogoOKCancelar {
    private final int CODIGO_EXAME = 0;
    private final int ABREVIATURA_MATERIAL = 1;
    private final int DESCRICAO_EXAME = 2;
    private final int FATURAR_EXAME = 3;
    private final int CODIGO_MATERIAL = 4;
    private final int DADOS_EXAME_FATURAMENTO = 5;
    private final int EXAME_FATURAMENTO = 6;
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Descri\u00e7\u00e3o", "Fat."}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 3 && !((Boolean)this.getValueAt(row, 6)).booleanValue()) {
                Funcoes.mensagem(ExamesNaoFaturar.this, "O exame n\u00e3o pode ser marcado para n\u00e3o faturar devido \u00e0 situa\u00e7\u00e3o de faturamento.", 2);
            }
            return col == 3 && (Boolean)this.getValueAt(row, 6) != false;
        }
    };
    private JTable tableExames = new JTable(this.modeloExames);
    private boolean ok = false;

    public static ExamesNaoFaturar getNovaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new ExamesNaoFaturar((Frame)owner);
        }
        return new ExamesNaoFaturar((Dialog)owner);
    }

    public ExamesNaoFaturar(Frame pai) {
        super(pai, "Exames para n\u00e3o faturar");
        this.montaTela(pai);
    }

    public ExamesNaoFaturar(Dialog pai) {
        super(pai, "Exames para n\u00e3o faturar");
        this.montaTela(pai);
    }

    private void montaTela(Component pai) {
        this.setSize(new Dimension(300, 400));
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new BorderLayout());
        panelCentral.add((Component)new JScrollPane(this.tableExames), "Center");
        this.tableExames.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.modeloExames.setColumnSize(new int[]{60, 40, 0, 30}, this.tableExames);
        this.setLocationRelativeTo(pai);
    }

    public void setExames(String filial, ArrayList<DadosExameFaturamento> exames) throws SQLException {
        this.modeloExames.clear();
        for (DadosExameFaturamento exm : exames) {
            DadosExamePaiAgrupamento pai = exm.getExamePai();
            ArrayList lista = new ArrayList();
            lista.add(exm);
            if (pai == null) {
                this.modeloExames.addLine(new Object[]{exm.getCodigoExame(), exm.getAbreviaturaMaterial(), exm.getNomeExame(), exm.getFaturar(), exm.getCodigoMaterial(), lista});
                continue;
            }
            DadosMaterial m = ExameUtil.getDadosMaterial(filial, pai.getMaterial());
            DadosExames e = ExameUtil.getDadosExame(filial, pai.getCodigo(), m);
            int pos = this.exameJaAdicionado(pai.getCodigo(), m.getCodigo());
            if (pos == -1) {
                this.modeloExames.addLine(new Object[]{pai.getCodigo(), m.getAbreviatura(), e.getDescricao(), exm.getFaturar(), m.getCodigo(), lista, !exm.getSituacaoExame().equalsIgnoreCase("A")});
                continue;
            }
            lista = (ArrayList)this.modeloExames.getValueAt(pos, 5);
            lista.add(exm);
        }
    }

    public ArrayList<DadosExameFaturamento> getExamesDesmarcados() {
        ArrayList<DadosExameFaturamento> retorno = new ArrayList<DadosExameFaturamento>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            boolean b = (Boolean)this.modeloExames.getValueAt(i, 3);
            if (b) continue;
            retorno.addAll((ArrayList)this.modeloExames.getValueAt(i, 5));
        }
        return retorno;
    }

    private int exameJaAdicionado(String exame, int material) {
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!this.modeloExames.getValueAt(i, 0).toString().equalsIgnoreCase(exame) || Integer.parseInt(this.modeloExames.getValueAt(i, 4).toString()) != material) continue;
            return i;
        }
        return -1;
    }

    private boolean todosDesmarcados() {
        boolean retorno = true;
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            Object o = this.modeloExames.getValueAt(i, 3);
            if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) continue;
            retorno = false;
            break;
        }
        return retorno;
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public boolean acaoOk() {
        this.ok = true;
        return this.ok;
    }
}

