/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.ParametrosGerais;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosMaterialFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.laboratorio.util.faturamento.BotaoExame;
import jalis.laboratorio.util.faturamento.CheckExame;
import jalis.laboratorio.util.faturamento.SelecaoListener;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class EditorDadosFaturamentoRemover
extends JPanel
implements TableCellEditor,
TableCellRenderer {
    public static final Color COR_INCOMPLETO_REQUISICAO = new Color(255, 255, 191, 255);
    public static final Color COR_INCOMPLETO_EXAME = new Color(153, 100, 255, 255);
    public static final Color COR_DEVE_GUIA = Color.RED;
    public static final Color COR_MOTIVO_PRAZO = Color.GRAY;
    public static final Color COR_SEM_CONFERENCIA = Color.MAGENTA;
    JButton buttonRequisicao = new JButton("+");
    private JLabel labelRequisicao = new JLabel();
    private JLabel labelData = new JLabel();
    private JLabel labelNome = new JLabel();
    private JLabel labelConvenio = new JLabel();
    private JLabel labelMatricula = new JLabel();
    private JLabel labelSubtotal = new JLabel("Subtotal");
    private JLabel labelTotalCH = new JLabel();
    private JLabel labelTotalValor = new JLabel();
    private JTable tabela;
    private JCheckBox checkRequisicao = new JCheckBox();
    private final int TAMANHO_INICIAL = 30;
    private final int TAMANHO_LINHA = 15;
    private final int TAMANHO_ENTRE_LINHAS = 1;
    private boolean showCheckBox = true;
    private Color corFrente;
    private Font fonte = new Font(this.labelRequisicao.getFont().getName(), 0, 10);

    public EditorDadosFaturamentoRemover(JTable tabela, boolean showCheckBox) {
        this.setPreferredSize(new Dimension(10, 30));
        this.showCheckBox = showCheckBox;
        this.tabela = tabela;
        this.setLayout(new GridBagLayout());
        this.corFrente = this.labelRequisicao.getForeground();
        this.labelRequisicao.setFont(this.fonte);
        this.labelData.setFont(this.fonte);
        this.labelNome.setFont(this.fonte);
        this.labelConvenio.setFont(this.fonte);
        this.labelMatricula.setFont(this.fonte);
        this.checkRequisicao.setBounds(1, 3, 15, 14);
        this.checkRequisicao.setOpaque(false);
        this.checkRequisicao.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRequisicao.setBounds(1, 3, 14, 14);
        this.buttonRequisicao.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorDadosFaturamentoRemover.this.tabela.getSelectedRow() > -1) {
                    DadosFaturamento dados;
                    dados.setRequisicaoExpandida(!(dados = (DadosFaturamento)EditorDadosFaturamentoRemover.this.tabela.getModel().getValueAt(EditorDadosFaturamentoRemover.this.tabela.getSelectedRow(), 0)).getRequisicaoExpandida());
                }
                EditorDadosFaturamentoRemover.this.stopCellEditing();
            }
        });
        this.checkRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorDadosFaturamentoRemover.this.tabela.getSelectedRow() > -1) {
                    DadosFaturamento dados;
                    dados.setFaturar(!(dados = (DadosFaturamento)EditorDadosFaturamentoRemover.this.tabela.getModel().getValueAt(EditorDadosFaturamentoRemover.this.tabela.getSelectedRow(), 0)).getFaturar());
                    for (int i = 0; i < dados.getExamesCount(); ++i) {
                        dados.getExame(i).setFaturar(dados.getFaturar());
                    }
                }
                EditorDadosFaturamentoRemover.this.stopCellEditing();
                EditorDadosFaturamentoRemover.this.fireSelecionado();
            }
        });
    }

    private void atualizaDados(DadosFaturamento dados, JTable table, int row, boolean isSelected, boolean isEditing) {
        this.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        int tamanhoPainel = 30;
        int contaLinha = 0;
        this.labelRequisicao.setText(Funcoes.preencheZero(String.valueOf(dados.getRequisicao()), 8));
        this.labelData.setText(Funcoes.formataData("dd/MM", dados.getDataRequisicao()));
        if (dados.getTitularDependente().equals("T")) {
            this.labelNome.setText(dados.getNomeTitular());
        } else {
            this.labelNome.setText(dados.getNomePaciente());
        }
        this.labelConvenio.setText(dados.getConvenioFantasia());
        this.labelMatricula.setText(dados.getMatricula());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 4, 0, 0);
        this.checkRequisicao.setPreferredSize(new Dimension(15, 14));
        this.checkRequisicao.setMinimumSize(new Dimension(15, 14));
        if (this.showCheckBox) {
            this.add((Component)this.checkRequisicao, constraints);
        }
        constraints.gridx = 1;
        this.add((Component)this.labelRequisicao, constraints);
        constraints.gridx = 2;
        this.add((Component)this.labelData, constraints);
        constraints.gridx = 3;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        this.add((Component)this.labelNome, constraints);
        constraints.gridx = 5;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.labelConvenio.setPreferredSize(new Dimension(80, (int)this.labelNome.getPreferredSize().getHeight()));
        this.labelConvenio.setMinimumSize(this.labelConvenio.getPreferredSize());
        this.labelConvenio.setMaximumSize(this.labelConvenio.getPreferredSize());
        this.add((Component)this.labelConvenio, constraints);
        constraints.gridx = 6;
        this.labelMatricula.setPreferredSize(new Dimension(80, (int)this.labelNome.getPreferredSize().getHeight()));
        this.labelMatricula.setMinimumSize(this.labelMatricula.getPreferredSize());
        this.labelMatricula.setMaximumSize(this.labelMatricula.getPreferredSize());
        this.add((Component)this.labelMatricula, constraints);
        constraints.gridx = 7;
        constraints.anchor = 13;
        this.buttonRequisicao.setPreferredSize(new Dimension(14, 14));
        this.buttonRequisicao.setMinimumSize(new Dimension(14, 14));
        this.add((Component)this.buttonRequisicao, constraints);
        Font font = new Font(this.buttonRequisicao.getFont().getName(), 0, 10);
        this.buttonRequisicao.setFont(font);
        this.buttonRequisicao.setText(dados.getRequisicaoExpandida() ? "-" : "+");
        this.checkRequisicao.setSelected(dados.getFaturar());
        this.setBorder(!dados.isGuiaConferida() ? BorderFactory.createLineBorder(COR_SEM_CONFERENCIA) : null);
        if (dados.getDeveGuia()) {
            this.labelRequisicao.setForeground(COR_DEVE_GUIA);
        } else {
            this.labelRequisicao.setForeground(this.corFrente);
        }
        this.labelData.setForeground(this.labelRequisicao.getForeground());
        this.labelNome.setForeground(this.labelRequisicao.getForeground());
        this.labelConvenio.setForeground(this.labelRequisicao.getForeground());
        this.labelMatricula.setForeground(this.labelRequisicao.getForeground());
        if (dados.getRequisicaoExpandida()) {
            for (int i = 0; i < dados.getExamesCount(); ++i) {
                DadosExameFaturamento exame = dados.getExame(i);
                JLabel labelExame = new JLabel(exame.getCodigoExame());
                JLabel labelMaterial = new JLabel(exame.getAbreviaturaMaterial());
                JLabel labelDescricao = new JLabel(exame.getNomeExame());
                JLabel labelCH = new JLabel(Funcoes.formataDecimal(exame.getValorCHExame().doubleValue()));
                JLabel labelValor = new JLabel("R$ " + Funcoes.formataDecimal("0." + Funcoes.preencheZero("0", ParametrosGerais.getCasasPrecoExame()), exame.getValorExame().setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).doubleValue()));
                JLabel labelAMB = new JLabel(exame.getCodigoAMB());
                if (exame.getExameExpandido()) {
                    labelValor.setText("R$ " + Funcoes.formataDecimal(exame.getValorExame().subtract(exame.getValorMaterial()).doubleValue()));
                }
                labelCH.setHorizontalAlignment(4);
                labelValor.setHorizontalAlignment(4);
                labelExame.setFont(this.labelRequisicao.getFont());
                labelMaterial.setFont(this.labelRequisicao.getFont());
                labelDescricao.setFont(this.labelRequisicao.getFont());
                labelCH.setFont(this.labelRequisicao.getFont());
                labelValor.setFont(this.labelRequisicao.getFont());
                labelAMB.setFont(this.labelRequisicao.getFont());
                if (!Funcoes.textoVazio(exame.getMotivoPrazo())) {
                    labelExame.setForeground(COR_MOTIVO_PRAZO);
                } else if (Funcoes.textoVazio(exame.getCodigoAMB())) {
                    labelExame.setForeground(COR_INCOMPLETO_EXAME);
                } else {
                    labelExame.setForeground(this.corFrente);
                }
                labelMaterial.setForeground(labelExame.getForeground());
                labelDescricao.setForeground(labelExame.getForeground());
                labelCH.setForeground(labelExame.getForeground());
                labelValor.setForeground(labelExame.getForeground());
                labelAMB.setForeground(labelExame.getForeground());
                labelAMB.setPreferredSize(new Dimension(70, 10));
                labelCH.setPreferredSize(new Dimension(40, 10));
                constraints.gridx = 0;
                constraints.gridy = ++contaLinha;
                constraints.weightx = 0.0;
                constraints.gridwidth = 1;
                constraints.anchor = 17;
                CheckExame checkExame = new CheckExame();
                checkExame.setMargin(new Insets(0, 0, 0, 0));
                checkExame.setPreferredSize(new Dimension(15, 14));
                checkExame.setMinimumSize(new Dimension(15, 14));
                if (this.showCheckBox) {
                    this.add((Component)checkExame, constraints);
                }
                constraints.gridx = 1;
                this.add((Component)labelExame, constraints);
                constraints.gridx = 2;
                this.add((Component)labelMaterial, constraints);
                constraints.gridx = 3;
                constraints.fill = 2;
                constraints.weightx = 1.0;
                this.add((Component)labelDescricao, constraints);
                constraints.gridx = 4;
                constraints.fill = 0;
                constraints.weightx = 0.0;
                constraints.anchor = 13;
                this.add((Component)labelAMB, constraints);
                constraints.gridx = 5;
                this.add((Component)labelCH, constraints);
                constraints.gridx = 6;
                this.add((Component)labelValor, constraints);
                checkExame.setExame(exame);
                checkExame.setOpaque(false);
                checkExame.setSelected(exame.getFaturar());
                checkExame.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int linha;
                        if (((CheckExame)e.getSource()).getExame() != null) {
                            CheckExame b = (CheckExame)e.getSource();
                            b.getExame().setFaturar(!b.getExame().getFaturar());
                        }
                        if ((linha = EditorDadosFaturamentoRemover.this.tabela.getSelectedRow()) > -1 && EditorDadosFaturamentoRemover.this.tabela.getValueAt(linha, 0) instanceof DadosFaturamento) {
                            DadosFaturamento f = (DadosFaturamento)EditorDadosFaturamentoRemover.this.tabela.getValueAt(linha, 0);
                            boolean marcar = false;
                            for (int i = 0; i < f.getExamesCount(); ++i) {
                                if (marcar) continue;
                                marcar = f.getExame(i).getFaturar();
                            }
                            f.setFaturar(marcar);
                        }
                        EditorDadosFaturamentoRemover.this.stopCellEditing();
                        EditorDadosFaturamentoRemover.this.fireSelecionado();
                    }
                });
                if (exame.getMateriaisCount() > 0) {
                    BotaoExame buttonExame = new BotaoExame(exame.getExameExpandido() ? "-" : "+");
                    buttonExame.setFont(font);
                    buttonExame.setMargin(new Insets(0, 0, 0, 0));
                    buttonExame.setExame(exame);
                    buttonExame.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (((BotaoExame)e.getSource()).getExame() != null) {
                                BotaoExame b = (BotaoExame)e.getSource();
                                b.getExame().setExameExpandido(!b.getExame().getExameExpandido());
                            }
                            EditorDadosFaturamentoRemover.this.stopCellEditing();
                        }
                    });
                    constraints.gridx = 6;
                    constraints.anchor = 17;
                    buttonExame.setPreferredSize(new Dimension(14, 14));
                    buttonExame.setMinimumSize(new Dimension(14, 14));
                    this.add((Component)buttonExame, constraints);
                    if (exame.getExameExpandido()) {
                        for (int j = 0; j < exame.getMateriaisCount(); ++j) {
                            DadosMaterialFaturamento materiais = exame.getMaterial(j);
                            JLabel labelCodMaterial = new JLabel(String.valueOf(materiais.getCodigo()));
                            JLabel labelDescMaterial = new JLabel(materiais.getDescricao());
                            JLabel labelQtdeMaterial = new JLabel(Funcoes.formataDecimal(materiais.getQuantidade().doubleValue()));
                            JLabel labelTotalMaterial = new JLabel(Funcoes.formataDecimal(materiais.getQuantidade().multiply(materiais.getValor()).doubleValue()));
                            labelCodMaterial.setFont(this.labelRequisicao.getFont());
                            labelDescMaterial.setFont(this.labelRequisicao.getFont());
                            labelQtdeMaterial.setFont(this.labelRequisicao.getFont());
                            labelTotalMaterial.setFont(this.labelRequisicao.getFont());
                            constraints.gridx = 2;
                            constraints.gridy = ++contaLinha;
                            constraints.anchor = 17;
                            this.add((Component)labelCodMaterial, constraints);
                            constraints.gridx = 3;
                            constraints.fill = 2;
                            constraints.weightx = 1.0;
                            this.add((Component)labelDescMaterial, constraints);
                            constraints.gridx = 4;
                            constraints.fill = 0;
                            constraints.weightx = 0.0;
                            constraints.anchor = 13;
                            this.add((Component)labelQtdeMaterial, constraints);
                            constraints.gridx = 5;
                            this.add((Component)labelTotalMaterial, constraints);
                            tamanhoPainel += 16;
                        }
                    }
                }
                tamanhoPainel += 16;
            }
        }
        constraints.gridx = 4;
        constraints.gridy = ++contaLinha;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.labelSubtotal.setHorizontalAlignment(4);
        this.add((Component)this.labelSubtotal, constraints);
        this.labelTotalCH.setText(Funcoes.formataDecimal(dados.getValorTotalCH().doubleValue()));
        this.labelTotalValor.setText("R$ " + Funcoes.formataDecimal("0.00", dados.getValorTotal().setScale(2, ParametrosGerais.getArredondamentoPrecoExame()).doubleValue()));
        this.labelSubtotal.setFont(this.labelRequisicao.getFont());
        this.labelTotalCH.setFont(this.labelRequisicao.getFont());
        this.labelTotalValor.setFont(this.labelRequisicao.getFont());
        constraints.gridx = 5;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        this.add((Component)this.labelTotalCH, constraints);
        constraints.gridx = 6;
        this.add((Component)this.labelTotalValor, constraints);
        if (table.getRowHeight(row) != tamanhoPainel + 5) {
            table.setRowHeight(row, tamanhoPainel + 5);
            this.setPreferredSize(new Dimension(20, tamanhoPainel + 5));
            this.revalidate();
        }
        if (!isSelected && dados.haProblemas()) {
            this.setBackground(COR_INCOMPLETO_REQUISICAO);
            this.setOpaque(true);
        }
    }

    private void atualizaTotalGeral(DadosTotalGeral total, JTable table, int row, boolean isSelected) {
        this.removeAll();
        GridBagConstraints cons = new GridBagConstraints();
        int tamanhoPainel = 105;
        JLabel labelQtdeRequisicoes = new JLabel("Quantidade de requisi\u00e7\u00f5es:");
        JLabel labelVQtdeRequisicoes = new JLabel(String.valueOf(total.getQtdeRequisicoes()));
        JLabel labelQtdeExames = new JLabel("Quantidade de exames:");
        JLabel labelVQtdeExames = new JLabel(String.valueOf(total.getQtdeExames()));
        JLabel labelTotalExames = new JLabel("Total exames:");
        JLabel labelVTotalExames = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalExames().doubleValue()));
        JLabel labelTotalExamesCH = new JLabel("Total exames (CH):");
        JLabel labelVTotalExamesCH = new JLabel(Funcoes.formataDecimal(total.getTotalExamesCH().doubleValue()));
        JLabel labelTotalMateriais = new JLabel("Total materiais:");
        JLabel labelVTotalMateriais = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalMateriais().doubleValue()));
        JLabel labelSubtotal = new JLabel("Subtotal:");
        JLabel labelVSubtotal = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalExames().add(total.getTotalMateriais()).doubleValue()));
        JLabel labelDesconto = new JLabel("Desconto:");
        JLabel labelVDesconto = new JLabel(Funcoes.formataDecimal(total.getPercentualBonus().doubleValue()) + "%");
        JLabel labelAcrescimo = new JLabel("Acr\u00e9scimo:");
        JLabel labelVAcrescimo = new JLabel(Funcoes.formataDecimal(total.getPercentualAcrescimo().doubleValue()) + "%");
        JLabel labelAdicional = new JLabel("Adicional:");
        JLabel labelVAdicional = new JLabel("R$ " + Funcoes.formataDecimal(total.getAdicional().doubleValue()));
        JLabel labelDespesas = new JLabel("Despesas de cobran\u00e7a:");
        JLabel labelVDespesas = new JLabel("R$ " + Funcoes.formataDecimal(total.getCobranca().doubleValue()));
        JLabel labelTotalGeral = new JLabel("Total geral:");
        JLabel labelVTotalGeral = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotal().doubleValue()));
        labelQtdeRequisicoes.setHorizontalAlignment(4);
        labelQtdeExames.setHorizontalAlignment(4);
        labelTotalExames.setHorizontalAlignment(4);
        labelTotalExamesCH.setHorizontalAlignment(4);
        labelTotalMateriais.setHorizontalAlignment(4);
        labelSubtotal.setHorizontalAlignment(4);
        labelDesconto.setHorizontalAlignment(4);
        labelAcrescimo.setHorizontalAlignment(4);
        labelAdicional.setHorizontalAlignment(4);
        labelDespesas.setHorizontalAlignment(4);
        labelTotalGeral.setHorizontalAlignment(4);
        labelVQtdeRequisicoes.setHorizontalAlignment(4);
        labelVQtdeExames.setHorizontalAlignment(4);
        labelVTotalExames.setHorizontalAlignment(4);
        labelVTotalExamesCH.setHorizontalAlignment(4);
        labelVTotalMateriais.setHorizontalAlignment(4);
        labelVSubtotal.setHorizontalAlignment(4);
        labelVDesconto.setHorizontalAlignment(4);
        labelVAcrescimo.setHorizontalAlignment(4);
        labelVAdicional.setHorizontalAlignment(4);
        labelVDespesas.setHorizontalAlignment(4);
        labelVTotalGeral.setHorizontalAlignment(4);
        labelQtdeRequisicoes.setFont(this.fonte);
        labelQtdeExames.setFont(this.fonte);
        labelTotalExames.setFont(this.fonte);
        labelTotalExamesCH.setFont(this.fonte);
        labelTotalMateriais.setFont(this.fonte);
        labelSubtotal.setFont(this.fonte);
        labelDesconto.setFont(this.fonte);
        labelAcrescimo.setFont(this.fonte);
        labelAdicional.setFont(this.fonte);
        labelDespesas.setFont(this.fonte);
        labelTotalGeral.setFont(this.fonte);
        labelVQtdeRequisicoes.setFont(this.fonte);
        labelVQtdeExames.setFont(this.fonte);
        labelVTotalExames.setFont(this.fonte);
        labelVTotalExamesCH.setFont(this.fonte);
        labelVTotalMateriais.setFont(this.fonte);
        labelVSubtotal.setFont(this.fonte);
        labelVDesconto.setFont(this.fonte);
        labelVAcrescimo.setFont(this.fonte);
        labelVAdicional.setFont(this.fonte);
        labelVDespesas.setFont(this.fonte);
        labelVTotalGeral.setFont(this.fonte);
        int contaLinha = 0;
        labelQtdeRequisicoes.setFont(this.fonte);
        cons.gridx = 0;
        cons.gridy = contaLinha++;
        cons.weightx = 1.0;
        cons.fill = 2;
        this.add((Component)labelQtdeRequisicoes, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelQtdeExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelTotalExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelTotalExamesCH, cons);
        if (total.getTotalMateriais().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelTotalMateriais, cons);
        }
        ++contaLinha;
        cons.gridy = contaLinha++;
        this.add((Component)labelSubtotal, cons);
        if (total.getPercentualAcrescimo().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelAcrescimo, cons);
        }
        if (total.getPercentualBonus().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelDesconto, cons);
        }
        if (total.getAdicional().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelAdicional, cons);
        }
        if (total.getCobranca().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelDespesas, cons);
        }
        cons.gridy = ++contaLinha;
        this.add((Component)labelTotalGeral, cons);
        contaLinha = 0;
        cons.gridx = 1;
        cons.gridy = contaLinha++;
        cons.weightx = 1.0;
        cons.fill = 2;
        this.add((Component)labelVQtdeRequisicoes, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelVQtdeExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelVTotalExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelVTotalExamesCH, cons);
        if (total.getTotalMateriais().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelVTotalMateriais, cons);
            tamanhoPainel += 15;
        }
        ++contaLinha;
        cons.gridy = contaLinha++;
        this.add((Component)labelVSubtotal, cons);
        if (total.getPercentualAcrescimo().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelVAcrescimo, cons);
            tamanhoPainel += 15;
        }
        if (total.getPercentualBonus().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelVDesconto, cons);
            tamanhoPainel += 15;
        }
        if (total.getAdicional().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelVAdicional, cons);
            tamanhoPainel += 15;
        }
        if (total.getCobranca().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelVDespesas, cons);
            tamanhoPainel += 15;
        }
        ++contaLinha;
        cons.gridy = contaLinha++;
        this.add((Component)labelVTotalGeral, cons);
        cons.gridx = 2;
        cons.weightx = 0.0;
        cons.fill = 0;
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setPreferredSize(new Dimension(14, 14));
        p.setMinimumSize(new Dimension(14, 14));
        this.add((Component)p, cons);
        if (!Funcoes.textoVazio(total.getMensagem())) {
            cons.gridx = 0;
            cons.gridy = contaLinha;
            cons.gridwidth = 2;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.anchor = 18;
            JTextArea txt = new JTextArea();
            txt.setFont(this.fonte);
            txt.setFocusable(false);
            txt.setEditable(false);
            txt.setBorder(null);
            txt.setText(total.getMensagem());
            txt.setOpaque(false);
            this.add((Component)txt, cons);
            tamanhoPainel += 30;
        }
        if (table.getRowHeight(row) != tamanhoPainel + 5) {
            table.setRowHeight(row, tamanhoPainel + 5);
            this.setPreferredSize(new Dimension(20, tamanhoPainel + 5));
            this.revalidate();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.marcaSelecao(table, true);
        if (value instanceof DadosFaturamento) {
            DadosFaturamento d = (DadosFaturamento)value;
            this.atualizaDados(d, table, row, isSelected, true);
        } else if (value instanceof DadosTotalGeral) {
            this.atualizaTotalGeral((DadosTotalGeral)value, table, row, isSelected);
        }
        if (!table.hasFocus()) {
            table.setRowSelectionInterval(row, row);
            table.requestFocus();
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.marcaSelecao(table, isSelected);
        if (value instanceof DadosFaturamento) {
            DadosFaturamento d = (DadosFaturamento)value;
            this.atualizaDados(d, table, row, isSelected, false);
        } else if (value instanceof DadosTotalGeral) {
            this.atualizaTotalGeral((DadosTotalGeral)value, table, row, isSelected);
        }
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        return this;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] ouvintes = (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].editingCanceled(new ChangeEvent(this));
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] ouvintes = (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].editingStopped(new ChangeEvent(this));
        }
    }

    private void marcaSelecao(JTable table, boolean isSelected) {
        this.setOpaque(isSelected);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        }
    }

    public void addSelecaoListener(SelecaoListener l) {
        this.listenerList.add(SelecaoListener.class, l);
    }

    public void removeSelecaoListener(SelecaoListener l) {
        this.listenerList.remove(SelecaoListener.class, l);
    }

    private void fireSelecionado() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = 0; i <= ouvintes.length - 2; i += 2) {
            if (ouvintes[i] != SelecaoListener.class) continue;
            ((SelecaoListener)ouvintes[i + 1]).selecionado();
        }
    }
}

