/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosMaterialFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.laboratorio.util.faturamento.BotaoExame;
import jalis.laboratorio.util.faturamento.CheckExame;
import jalis.laboratorio.util.faturamento.SelecaoListener;
import jalis.model.enums.EnumTipoRateio;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class EditorDadosFaturamento
extends JPanel
implements TableCellEditor,
TableCellRenderer {
    public static final Color COR_INCOMPLETO_REQUISICAO = new Color(255, 255, 191, 255);
    public static final Color COR_DEVE_GUIA = Color.RED;
    public static final Color COR_MOTIVO_PRAZO = Color.GRAY;
    public static final Color COR_SEM_CONFERENCIA = Color.MAGENTA;
    JButton buttonRequisicao = new JButton("+");
    private final JLabel labelTipoAlimento = new JLabel();
    private final JLabel labelRequisicao = new JLabel();
    private final JLabel labelData = new JLabel();
    private final JLabel labelConvenio = new JLabel();
    private final JLabel labelConvenioPrincipal = new JLabel();
    private final JLabel labelMatricula = new JLabel();
    private final JLabel labelSubtotal = new JLabel("Subtotal:");
    private final JLabel labelTotalCH = new JLabel();
    private final JLabel labelTotalValor = new JLabel();
    private final JLabel labelGuiaRequisicaoNomePaciente = new JLabel();
    private final JLabel labelMedico = new JLabel();
    private final JLabel labelCRMMedico = new JLabel();
    private final JTable tabela;
    private final JCheckBox checkRequisicao = new JCheckBox();
    private final int TAMANHO_INICIAL = 55;
    private final int TAMANHO_LINHA = 15;
    private final int TAMANHO_ENTRE_LINHAS = 1;
    private boolean showCheckBox = true;
    private String ordemFatura = null;
    private boolean isVerificarConferidos = false;
    private final Color corFrente;
    private final Font fonte = new Font(this.labelRequisicao.getFont().getName(), 0, 10);

    public void setCheckBoxVisivel(boolean isVisivel) {
        this.showCheckBox = isVisivel;
    }

    public EditorDadosFaturamento(JTable tabela, boolean showCheckBox, String ordemFatura, boolean isVerificarConferidos) {
        this.showCheckBox = showCheckBox;
        this.ordemFatura = ordemFatura;
        this.isVerificarConferidos = isVerificarConferidos;
        this.tabela = tabela;
        this.setLayout(new GridBagLayout());
        this.corFrente = this.labelRequisicao.getForeground();
        this.labelTipoAlimento.setName("tipoRateio");
        this.labelTipoAlimento.setFont(new Font("DIALOG", 0, 15));
        this.labelRequisicao.setFont(this.fonte);
        this.labelData.setFont(this.fonte);
        this.labelGuiaRequisicaoNomePaciente.setFont(this.fonte);
        this.labelConvenio.setFont(this.fonte);
        this.labelConvenioPrincipal.setFont(this.fonte);
        this.labelMatricula.setFont(this.fonte);
        this.labelMedico.setFont(this.fonte);
        this.labelCRMMedico.setFont(this.fonte);
        Dimension d = new Dimension(15, 15);
        this.checkRequisicao.setMinimumSize(d);
        this.checkRequisicao.setPreferredSize(d);
        this.checkRequisicao.setOpaque(false);
        this.checkRequisicao.setMargin(new Insets(0, 0, 0, 0));
        d = new Dimension(15, 15);
        this.buttonRequisicao.setMinimumSize(d);
        this.buttonRequisicao.setPreferredSize(d);
        this.buttonRequisicao.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorDadosFaturamento.this.tabela.getSelectedRow() > -1) {
                    DadosFaturamento dados;
                    dados.setRequisicaoExpandida(!(dados = (DadosFaturamento)EditorDadosFaturamento.this.tabela.getModel().getValueAt(EditorDadosFaturamento.this.tabela.getSelectedRow(), 0)).getRequisicaoExpandida());
                }
                EditorDadosFaturamento.this.stopCellEditing();
            }
        });
        this.checkRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorDadosFaturamento.this.tabela.getSelectedRow() > -1 && EditorDadosFaturamento.this.tabela.getModel().getValueAt(EditorDadosFaturamento.this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento) {
                    DadosFaturamento dados;
                    dados.setFaturar(!(dados = (DadosFaturamento)EditorDadosFaturamento.this.tabela.getModel().getValueAt(EditorDadosFaturamento.this.tabela.getSelectedRow(), 0)).getFaturar());
                    for (int i = 0; i < dados.getExamesCount(); ++i) {
                        dados.getExame(i).setFaturar(dados.getFaturar());
                    }
                }
                EditorDadosFaturamento.this.stopCellEditing();
                EditorDadosFaturamento.this.fireSelecionado();
            }
        });
    }

    public JCheckBox getCheckBoxRequisicao() {
        if (this.checkRequisicao.isVisible() && this.checkRequisicao.isEnabled()) {
            return this.checkRequisicao;
        }
        return null;
    }

    public void expandir() {
        if (this.tabela.getSelectedRow() > -1 && this.tabela.getModel().getValueAt(this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento) {
            DadosFaturamento dados = (DadosFaturamento)this.tabela.getModel().getValueAt(this.tabela.getSelectedRow(), 0);
            dados.setRequisicaoExpandida(true);
        }
        this.stopCellEditing();
    }

    public void recolher() {
        if (this.tabela.getSelectedRow() > -1 && this.tabela.getModel().getValueAt(this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento) {
            DadosFaturamento dados = (DadosFaturamento)this.tabela.getModel().getValueAt(this.tabela.getSelectedRow(), 0);
            dados.setRequisicaoExpandida(false);
        }
        this.stopCellEditing();
    }

    /*
     * Unable to fully structure code
     */
    private void atualizaDados(DadosFaturamento dados, JTable table, int row, boolean isSelected, boolean isEditing) {
        block6: {
            block5: {
                this.removeComponentes(row);
                rateioEncontrado = false;
                constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(0, 4, 0, 0);
                constraints.gridy = 0;
                constraints.weightx = 0.0;
                constraints.fill = 0;
                exames = dados.getExames();
                if (!Variaveis.tipoFilialPadrao.equals("A") || !dados.getOrdemFatura().equals("S")) break block5;
                for (EnumTipoRateio enumTipoRateio : tiposRateio = EnumTipoRateio.values()) {
                    if (dados.getTipoRateio() == null || !dados.getTipoRateio().equals(enumTipoRateio.getCodigo())) continue;
                    rateioEncontrado = true;
                    if (!dados.isRateio()) ** GOTO lbl-1000
                    if (!EnumTipoRateio.getCodigo(this.labelTipoAlimento.getText()).equals(dados.getTipoRateio())) {
                        constraints = this.adicionaLabel(constraints, EnumTipoRateio.getDescricao(enumTipoRateio.getCodigo()));
                    } else if (!dados.isRateio()) {
                        this.remove(this.labelTipoAlimento);
                    } else {
                        constraints = this.adicionaLabel(constraints, EnumTipoRateio.getDescricao(enumTipoRateio.getCodigo()));
                    }
                    this.atualizaDados(dados, table, row, isSelected, isEditing, constraints, rateioEncontrado);
                }
                break block6;
            }
            this.atualizaDados(dados, table, row, isSelected, isEditing, constraints, false);
        }
    }

    private GridBagConstraints adicionaLabel(GridBagConstraints constraints, String descricao) {
        this.labelTipoAlimento.setText(descricao);
        constraints.gridwidth = 2;
        this.add((Component)this.labelTipoAlimento, constraints);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        return constraints;
    }

    private void removeComponentes(int row) {
        Component[] componentes = this.getComponents();
        boolean labelAtivo = false;
        for (Component component : componentes) {
            if (component.getName() != null && component.getName().equals("tipoRateio")) continue;
            this.remove(component);
        }
    }

    private void atualizaDados(DadosFaturamento dados, JTable table, int row, boolean isSelected, boolean isEditing, GridBagConstraints constraints, boolean rateioEncontrado) {
        int tamanhoPainel = 55;
        Font fonteAtual = new Font(this.buttonRequisicao.getFont().getName(), 0, 10);
        Color corAtual = null;
        this.preencheDados(dados);
        if (!Variaveis.tipoFilialPadrao.equals("A") || !dados.getOrdemFatura().equalsIgnoreCase("S") || rateioEncontrado) {
            this.checkRequisicao.setSelected(dados.getFaturar());
            Dimension d = new Dimension(15, 15);
            this.checkRequisicao.setPreferredSize(d);
            this.checkRequisicao.setMinimumSize(d);
            if (this.showCheckBox) {
                constraints.gridwidth = 1;
                this.add((Component)this.checkRequisicao, constraints);
                ++constraints.gridx;
                constraints.gridwidth = 2;
                constraints.fill = 2;
                this.labelRequisicao.setHorizontalAlignment(4);
                this.labelRequisicao.setToolTipText("c\u00f3digo da requisi\u00e7\u00e3o");
                this.add((Component)this.labelRequisicao, constraints);
                constraints.gridx += 2;
            } else {
                constraints.gridwidth = 3;
                this.labelRequisicao.setHorizontalAlignment(4);
                this.labelRequisicao.setToolTipText("c\u00f3digo da requisi\u00e7\u00e3o");
                this.add((Component)this.labelRequisicao, constraints);
                constraints.gridx += 3;
            }
            constraints.gridwidth = 1;
            ++constraints.gridx;
            this.labelData.setToolTipText("data da requisi\u00e7\u00e3o");
            this.add((Component)this.labelData, constraints);
            ++constraints.gridx;
            constraints.gridwidth = 6;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            this.labelGuiaRequisicaoNomePaciente.setToolTipText("nome do paciente");
            this.add((Component)this.labelGuiaRequisicaoNomePaciente, constraints);
            constraints.gridx += 6;
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            d = new Dimension(15, 15);
            this.buttonRequisicao.setPreferredSize(d);
            this.buttonRequisicao.setMinimumSize(d);
            this.buttonRequisicao.setFont(fonteAtual);
            this.buttonRequisicao.setHorizontalAlignment(0);
            this.buttonRequisicao.setText(dados.getRequisicaoExpandida() ? "-" : "+");
            this.add((Component)this.buttonRequisicao, constraints);
            ++constraints.gridy;
            if (this.showCheckBox) {
                constraints.gridx = 1;
                constraints.weightx = 1.0;
                constraints.fill = 2;
                constraints.gridwidth = 7;
                d = new Dimension(20, 15);
                this.labelConvenio.setMinimumSize(d);
                this.labelConvenio.setToolTipText("fantasia do conv\u00eanio");
                this.add((Component)this.labelConvenio, constraints);
                constraints.gridx += 7;
            } else {
                constraints.gridx = 0;
                constraints.gridwidth = 8;
                constraints.weightx = 1.0;
                constraints.fill = 2;
                this.labelConvenio.setToolTipText("fantasia do conv\u00eanio");
                this.add((Component)this.labelConvenio, constraints);
                constraints.gridx += 8;
            }
            if (dados.getRequisicaoExpandida()) {
                constraints.gridwidth = 3;
                constraints.weightx = 0.0;
                d = new Dimension(80, 15);
                this.labelMatricula.setPreferredSize(d);
                this.labelMatricula.setMinimumSize(d);
                this.labelMatricula.setToolTipText("matr\u00edcula do paciente");
                this.add((Component)this.labelMatricula, constraints);
                if (dados.getCodigoConvenio() != dados.getCodigoConvenioPrincipal()) {
                    ++constraints.gridy;
                    if (this.showCheckBox) {
                        constraints.gridx = 1;
                        constraints.weightx = 1.0;
                        constraints.fill = 2;
                        constraints.gridwidth = 7;
                        d = new Dimension(20, 15);
                        this.labelConvenioPrincipal.setMinimumSize(d);
                        this.labelConvenioPrincipal.setToolTipText("nome do conv\u00eanio principal");
                        this.add((Component)this.labelConvenioPrincipal, constraints);
                        constraints.gridx += 7;
                    } else {
                        constraints.gridx = 0;
                        constraints.gridwidth = 8;
                        constraints.weightx = 1.0;
                        constraints.fill = 2;
                        this.labelConvenioPrincipal.setToolTipText("nome do conv\u00eanio principal");
                        this.add((Component)this.labelConvenioPrincipal, constraints);
                        constraints.gridx += 8;
                    }
                    tamanhoPainel += 15;
                }
                if (this.ordemFatura != null && (this.ordemFatura.equalsIgnoreCase("E") || this.ordemFatura.equalsIgnoreCase("C"))) {
                    ++constraints.gridy;
                    constraints = this.adicionaCamposMedico(constraints);
                    tamanhoPainel += 15;
                }
            }
            this.verificaConferidos(dados.isGuiaConferida());
            corAtual = this.corFrente;
            if (dados.getDeveGuia()) {
                corAtual = COR_DEVE_GUIA;
            }
            this.labelRequisicao.setForeground(corAtual);
            this.labelData.setForeground(corAtual);
            this.labelConvenio.setForeground(corAtual);
            this.labelMatricula.setForeground(corAtual);
            this.labelGuiaRequisicaoNomePaciente.setForeground(corAtual);
            if (dados.getRequisicaoExpandida()) {
                for (int i = 0; i < dados.getExamesCount(); ++i) {
                    DadosExameFaturamento exame = dados.getExame(i);
                    JLabel labelExame = new JLabel(exame.getCodigoExame());
                    JLabel labelMaterial = new JLabel(exame.getAbreviaturaMaterial());
                    JLabel labelDescricao = new JLabel(exame.getNomeExame());
                    JLabel labelCH = new JLabel(Funcoes.formataDecimal(exame.getValorCHExame().doubleValue()));
                    BigDecimal valorExame = exame.getValorExame() != null ? exame.getValorExame() : exame.getValorTotalExame();
                    JLabel labelValor = new JLabel("R$ " + Funcoes.formataDecimal("0." + Funcoes.preencheZero("0", dados.getCasasDecimais()), valorExame.add(exame.getValorMaterial()).setScale(dados.getCasasDecimais(), dados.getTipoArredondamento()).doubleValue()));
                    JLabel labelAMB = new JLabel(exame.getCodigoAMB());
                    JLabel labelGuiaExame = new JLabel(exame.getCodigoGuia());
                    if (exame.getExameExpandido()) {
                        labelValor.setText("R$ " + Funcoes.formataDecimal("0." + Funcoes.preencheZero("0", dados.getCasasDecimais()), valorExame.setScale(dados.getCasasDecimais(), dados.getTipoArredondamento()).doubleValue()));
                    }
                    labelExame.setFont(fonteAtual);
                    labelMaterial.setFont(fonteAtual);
                    labelDescricao.setFont(fonteAtual);
                    labelCH.setFont(fonteAtual);
                    labelValor.setFont(fonteAtual);
                    labelAMB.setFont(fonteAtual);
                    labelGuiaExame.setFont(fonteAtual);
                    corAtual = !Funcoes.textoVazio(exame.getMotivoPrazo()) ? COR_MOTIVO_PRAZO : (exame.getDeveGuia() ? COR_DEVE_GUIA : this.corFrente);
                    labelExame.setForeground(corAtual);
                    labelMaterial.setForeground(corAtual);
                    labelDescricao.setForeground(corAtual);
                    labelCH.setForeground(corAtual);
                    labelValor.setForeground(corAtual);
                    labelAMB.setForeground(corAtual);
                    labelGuiaExame.setForeground(corAtual);
                    labelCH.setPreferredSize(new Dimension(40, 15));
                    ++constraints.gridy;
                    constraints.gridx = 1;
                    constraints.weightx = 0.0;
                    constraints.anchor = 17;
                    CheckExame checkExame = new CheckExame();
                    checkExame.setMargin(new Insets(0, 0, 0, 0));
                    checkExame.setPreferredSize(new Dimension(15, 15));
                    checkExame.setMinimumSize(new Dimension(15, 15));
                    if (this.showCheckBox) {
                        constraints.gridwidth = 1;
                        this.add((Component)checkExame, constraints);
                        ++constraints.gridx;
                        labelExame.setToolTipText("c\u00f3digo do exame");
                        if (exame.isProibido()) {
                            labelExame.setIcon(ImagemUtils.carregaImagemJalis("warning.png"));
                        }
                        labelExame.setHorizontalTextPosition(4);
                        this.add((Component)labelExame, constraints);
                        ++constraints.gridx;
                    } else {
                        constraints.gridx = 0;
                        constraints.gridwidth = 1;
                        JLabel labelAux = new JLabel();
                        d = new Dimension(20, 15);
                        labelAux.setPreferredSize(d);
                        labelAux.setMinimumSize(d);
                        this.add((Component)labelAux, constraints);
                        constraints.gridwidth = 2;
                        ++constraints.gridx;
                        labelExame.setToolTipText("c\u00f3digo do exame");
                        if (exame.isProibido()) {
                            labelExame.setIcon(ImagemUtils.carregaImagemJalis("warning.png"));
                        }
                        labelExame.setHorizontalTextPosition(4);
                        this.add((Component)labelExame, constraints);
                        constraints.gridwidth = 1;
                        constraints.gridx += 2;
                    }
                    labelMaterial.setToolTipText("material do exame");
                    this.add((Component)labelMaterial, constraints);
                    ++constraints.gridx;
                    constraints.fill = 2;
                    constraints.weightx = 1.0;
                    constraints.gridwidth = 3;
                    labelDescricao.setToolTipText("descri\u00e7\u00e3o do exame");
                    this.add((Component)labelDescricao, constraints);
                    constraints.gridx += 3;
                    constraints.fill = 0;
                    constraints.weightx = 0.0;
                    constraints.gridwidth = 1;
                    constraints.anchor = 17;
                    labelGuiaExame.setToolTipText("c\u00f3digo da guia do exame");
                    this.add((Component)labelGuiaExame, constraints);
                    ++constraints.gridx;
                    constraints.anchor = 17;
                    labelAMB.setToolTipText("c\u00f3digo AMB do exame");
                    this.add((Component)labelAMB, constraints);
                    ++constraints.gridx;
                    constraints.anchor = 13;
                    labelCH.setHorizontalAlignment(4);
                    labelCH.setToolTipText("valor CH  do exame");
                    this.add((Component)labelCH, constraints);
                    ++constraints.gridx;
                    labelValor.setHorizontalAlignment(4);
                    labelValor.setToolTipText("valor do exame (R$)");
                    this.add((Component)labelValor, constraints);
                    checkExame.setExame(exame);
                    checkExame.setOpaque(false);
                    checkExame.setSelected(exame.getFaturar());
                    checkExame.setEnabled(exame.isMarcadoNaoFaturar());
                    checkExame.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EditorDadosFaturamento.this.checkExamePerformed(e);
                        }
                    });
                    if (exame.getMateriaisCount() > 0) {
                        BotaoExame buttonExame = new BotaoExame(exame.getExameExpandido() ? "-" : "+");
                        buttonExame.setFont(fonteAtual);
                        buttonExame.setMargin(new Insets(0, 0, 0, 0));
                        buttonExame.setExame(exame);
                        buttonExame.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (((BotaoExame)e.getSource()).getExame() != null) {
                                    BotaoExame b = (BotaoExame)e.getSource();
                                    b.getExame().setExameExpandido(!b.getExame().getExameExpandido());
                                }
                                EditorDadosFaturamento.this.stopCellEditing();
                            }
                        });
                        ++constraints.gridx;
                        constraints.anchor = 17;
                        d = new Dimension(15, 15);
                        buttonExame.setPreferredSize(d);
                        buttonExame.setMinimumSize(d);
                        this.add((Component)buttonExame, constraints);
                        if (exame.getExameExpandido()) {
                            for (int j = 0; j < exame.getMateriaisCount(); ++j) {
                                DadosMaterialFaturamento materiais = exame.getMaterial(j);
                                JLabel labelCodMaterial = new JLabel(String.valueOf(materiais.getCodigo()));
                                JLabel labelDescMaterial = new JLabel(materiais.getDescricao());
                                JLabel labelQtdeMaterial = new JLabel(Funcoes.formataDecimal(materiais.getQuantidade().doubleValue()));
                                JLabel labelTotalMaterial = new JLabel(Funcoes.formataDecimal(materiais.getQuantidade().multiply(materiais.getValor()).doubleValue()));
                                labelCodMaterial.setFont(this.labelRequisicao.getFont());
                                labelDescMaterial.setFont(this.labelRequisicao.getFont());
                                labelQtdeMaterial.setFont(this.labelRequisicao.getFont());
                                labelTotalMaterial.setFont(this.labelRequisicao.getFont());
                                constraints.gridx = 2;
                                ++constraints.gridy;
                                constraints.anchor = 17;
                                labelCodMaterial.setHorizontalAlignment(4);
                                labelCodMaterial.setToolTipText("c\u00f3digo do material");
                                this.add((Component)labelCodMaterial, constraints);
                                ++constraints.gridx;
                                constraints.fill = 2;
                                constraints.weightx = 1.0;
                                constraints.gridwidth = 6;
                                labelDescMaterial.setToolTipText("descri\u00e7\u00e3o do material");
                                this.add((Component)labelDescMaterial, constraints);
                                constraints.gridx += 6;
                                constraints.fill = 0;
                                constraints.weightx = 0.0;
                                constraints.anchor = 13;
                                constraints.gridwidth = 1;
                                labelQtdeMaterial.setHorizontalAlignment(4);
                                labelQtdeMaterial.setToolTipText("quantidade do material");
                                this.add((Component)labelQtdeMaterial, constraints);
                                ++constraints.gridx;
                                labelTotalMaterial.setHorizontalAlignment(4);
                                labelTotalMaterial.setToolTipText("valor total do material (R$)");
                                this.add((Component)labelTotalMaterial, constraints);
                                tamanhoPainel += 16;
                            }
                        }
                    }
                    tamanhoPainel += 16;
                }
            }
            constraints.gridx = 7;
            if (dados.getRequisicaoExpandida()) {
                ++constraints.gridy;
            }
            constraints.fill = 0;
            constraints.weightx = dados.getRequisicaoExpandida() ? 0.0 : 1.0;
            Font fonteTotalizacao = this.labelRequisicao.getFont().deriveFont(2);
            constraints.gridwidth = 2;
            constraints.anchor = 13;
            this.labelSubtotal.setFont(fonteTotalizacao);
            this.labelSubtotal.setHorizontalAlignment(4);
            this.add((Component)this.labelSubtotal, constraints);
            this.labelTotalCH.setText(Funcoes.formataDecimal(dados.getValorTotalCH().doubleValue()));
            this.labelTotalValor.setText("R$ " + Funcoes.formataDecimal("0.00", dados.getValorTotal().add(dados.getValorTotalMateriais()).setScale(2, dados.getTipoArredondamento()).doubleValue()));
            this.labelTotalCH.setFont(fonteTotalizacao);
            this.labelTotalValor.setFont(fonteTotalizacao);
            constraints.weightx = 0.0;
            constraints.gridwidth = 1;
            constraints.gridx += 2;
            this.add((Component)this.labelTotalCH, constraints);
            ++constraints.gridx;
            this.add((Component)this.labelTotalValor, constraints);
            if (table.getRowHeight(row) != tamanhoPainel + 5) {
                table.setRowHeight(row, tamanhoPainel + 5);
                this.revalidate();
            }
            if (!isSelected && dados.haProblemas()) {
                StringBuilder buf = new StringBuilder();
                buf.append("<html>Dados incompletos/incorretos para a gera\u00e7\u00e3o do faturamento eletr\u00f4nico.");
                this.setToolTipText(buf.toString());
                this.setBackground(COR_INCOMPLETO_REQUISICAO);
                this.setOpaque(true);
            }
        }
    }

    private void checkExamePerformed(ActionEvent e) {
        DadosFaturamento f;
        boolean isMarcado = false;
        if (((CheckExame)e.getSource()).getExame() != null) {
            CheckExame b = (CheckExame)e.getSource();
            isMarcado = !b.getExame().getFaturar();
            b.getExame().setFaturar(isMarcado);
        }
        DadosExamePaiAgrupamento pai = ((CheckExame)e.getSource()).getExame().getExamePai();
        int linha = this.tabela.getSelectedRow();
        if (linha > -1 && this.tabela.getValueAt(linha, 0) instanceof DadosFaturamento && pai != null) {
            f = (DadosFaturamento)this.tabela.getValueAt(linha, 0);
            for (int i = 0; i < f.getExamesCount(); ++i) {
                DadosExamePaiAgrupamento paiAux = f.getExame(i).getExamePai();
                if (paiAux == null || !pai.getCodigo().equalsIgnoreCase(paiAux.getCodigo()) || pai.getMaterial() != paiAux.getMaterial()) continue;
                f.getExame(i).setFaturar(isMarcado);
            }
        }
        if ((linha = this.tabela.getSelectedRow()) > -1 && this.tabela.getValueAt(linha, 0) instanceof DadosFaturamento) {
            f = (DadosFaturamento)this.tabela.getValueAt(linha, 0);
            boolean marcar = false;
            for (int i = 0; i < f.getExamesCount(); ++i) {
                if (marcar) continue;
                marcar = f.getExame(i).getFaturar();
            }
            f.setFaturar(marcar);
        }
        this.stopCellEditing();
        this.fireSelecionado();
    }

    private GridBagConstraints adicionaCamposMedico(GridBagConstraints constraints) {
        Integer gridx = 1;
        Integer weightx = 1;
        Integer weightxCrm = 0;
        Integer gridwidth = 6;
        if (!this.showCheckBox) {
            gridx = 0;
            weightx = 1;
            gridwidth = 7;
        }
        constraints.gridx = gridx;
        constraints.gridwidth = gridwidth;
        constraints.weightx = weightx.intValue();
        constraints.fill = 2;
        this.labelMedico.setToolTipText("nome do m\u00e9dico");
        this.add((Component)this.labelMedico, constraints);
        constraints.gridx += gridwidth.intValue();
        constraints.weightx = 0.0;
        constraints.gridwidth = 3;
        this.labelCRMMedico.setToolTipText("CRM do m\u00e9dico");
        this.add((Component)this.labelCRMMedico, constraints);
        return constraints;
    }

    private void verificaConferidos(boolean isGuiaConferida) {
        if (this.isVerificarConferidos) {
            this.setBorder(!isGuiaConferida ? BorderFactory.createLineBorder(COR_SEM_CONFERENCIA) : BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        } else {
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }
    }

    private void preencheDados(DadosFaturamento dados) {
        this.labelRequisicao.setText(Funcoes.preencheZero(dados.getCodigoFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(String.valueOf(dados.getRequisicao()), ParametrosGerais.getDigitosTuboRequisicao()));
        this.labelData.setText(Funcoes.formataData("dd/MM/yy", dados.getDataRequisicao()));
        this.labelConvenio.setText(dados.getConvenioFantasia());
        this.labelConvenioPrincipal.setText("Conv. Principal: " + dados.getFantasiaConvenioPrincipal());
        this.labelMatricula.setText(dados.getMatricula());
        this.labelMedico.setText(dados.getNomeMedico());
        this.labelCRMMedico.setText(dados.getCRMMedico());
        this.labelGuiaRequisicaoNomePaciente.setText(dados.getNomePaciente());
        if (dados.getTitularDependente().equals("T") && Funcoes.textoVazio(dados.getNomeTitular())) {
            this.labelGuiaRequisicaoNomePaciente.setText(dados.getNomePaciente());
        }
    }

    private void atualizaTotalGeral(DadosTotalGeral total, JTable table, int row, boolean isSelected) {
        int width;
        FontMetrics met;
        this.removeAll();
        this.setBorder(null);
        GridBagConstraints cons = new GridBagConstraints();
        int tamanhoPainel = 120;
        JLabel labelQtdeRequisicoes = new JLabel("Quantidade de requisi\u00e7\u00f5es:");
        JLabel labelVQtdeRequisicoes = new JLabel(String.valueOf(total.getQtdeRequisicoes()));
        JLabel labelQtdeGuias = new JLabel("Quantidade de guias da fatura:");
        JLabel labelVQtdeGuias = new JLabel(String.valueOf(total.getQtdeGuias()));
        JLabel labelQtdeExames = new JLabel("Quantidade de exames:");
        JLabel labelVQtdeExames = new JLabel(String.valueOf(total.getQtdeExames()));
        JLabel labelTotalExames = new JLabel("Total exames:");
        JLabel labelVTotalExames = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalExames().doubleValue()));
        JLabel labelTotalExamesCH = new JLabel("Total exames (CH):");
        JLabel labelVTotalExamesCH = new JLabel(Funcoes.formataDecimal(total.getTotalExamesCH().doubleValue()));
        JLabel labelTotalMateriais = new JLabel("Total materiais:");
        JLabel labelVTotalMateriais = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalMateriais().doubleValue()));
        JLabel labelSubtotal = new JLabel("Subtotal:");
        JLabel labelVSubtotal = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalExames().add(total.getTotalMateriais()).doubleValue()));
        JLabel labelDesconto = new JLabel("Desconto:");
        JLabel labelVDesconto = new JLabel("(" + Funcoes.formataDecimal(total.getPercentualBonus().doubleValue()) + "%)   R$ " + Funcoes.formataDecimal(total.getTotalExames().add(total.getTotalMateriais()).multiply(total.getPercentualBonus().divide(new BigDecimal(100))).setScale(total.getCasasDecimais(), total.getTipoArredondamento()).doubleValue()));
        JLabel labelAcrescimo = new JLabel("Acr\u00e9scimo:");
        JLabel labelVAcrescimo = new JLabel(Funcoes.formataDecimal(total.getPercentualAcrescimo().doubleValue()) + "%");
        JLabel labelAdicional = new JLabel("Adicional:");
        JLabel labelVAdicional = new JLabel("(" + Funcoes.formataDecimal((total.getAdicional().doubleValue() + total.getTotalExames().add(total.getTotalMateriais()).doubleValue()) / total.getTotalExames().add(total.getTotalMateriais()).doubleValue() * 100.0 - 100.0) + "%)   R$ " + Funcoes.formataDecimal(total.getAdicional().doubleValue()));
        JLabel labelDespesas = new JLabel("Despesas de cobran\u00e7a:");
        JLabel labelVDespesas = new JLabel("R$ " + Funcoes.formataDecimal(total.getCobranca().doubleValue()));
        JLabel labelTotalGeral = new JLabel("Total geral:");
        JLabel labelVTotalGeral = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotal().doubleValue()));
        JLabel labelDescricaoDesconto = new JLabel("<html><p align='right' valign='top'>" + total.getDescricaoDesconto() + "</p></html>");
        JLabel labelDescricaoAcrescimo = new JLabel("<html><p align='right' valign='top'>" + total.getDescricaoAcrescimo() + "</p></html>");
        JLabel labelQtdeExamesMicrobiologia = new JLabel("Quantidade de exames Microbiologia:");
        JLabel labelVQtdeExamesMicrobiologia = new JLabel(String.valueOf(total.getQtdeMicrobiologia()));
        JLabel labelTotalExamesMicrobiologia = new JLabel("Total geral Microbiologia:");
        JLabel labelVTotalExamesMicrobiologia = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalMicrobiologia().doubleValue()));
        JLabel labelQtdeExamesFiscoQuimico = new JLabel("Quantidade de exames Fisco-Quimico:");
        JLabel labelVQtdeExamesFiscoQuimico = new JLabel(String.valueOf(total.getQtdeFiscoQuimico()));
        JLabel labelTotalExamesFiscoQuimico = new JLabel("Total geral Fisco-Quimico:");
        JLabel labelVTotalExamesFiscoQuimico = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalFisicoQuimico().doubleValue()));
        JLabel labelQtdeExamesCromatografia = new JLabel("Quantidade de exames Cromatografia:");
        JLabel labelVQtdeExamesCromatografia = new JLabel(String.valueOf(total.getQtdeCromatografia()));
        JLabel labelTotalExamesCromatografia = new JLabel("Total geral Cromatografia:");
        JLabel labelVTotalExamesCromatografia = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalCromatografia().doubleValue()));
        JLabel labelQtdeExamesOutros = new JLabel("Quantidade de exames Outros-Terceiros:");
        JLabel labelVQtdeExamesOutros = new JLabel(String.valueOf(total.getQtdeOutros()));
        JLabel labelTotalExamesOutros = new JLabel("Total geral Outros-Terceiros:");
        JLabel labelVTotalExamesOutros = new JLabel("R$ " + Funcoes.formataDecimal(total.getTotalOutros().doubleValue()));
        labelDescricaoDesconto.setHorizontalAlignment(4);
        labelDescricaoDesconto.setVerticalAlignment(1);
        labelDescricaoAcrescimo.setHorizontalAlignment(4);
        labelDescricaoAcrescimo.setVerticalAlignment(1);
        labelQtdeRequisicoes.setHorizontalAlignment(4);
        labelQtdeGuias.setHorizontalAlignment(4);
        labelQtdeExames.setHorizontalAlignment(4);
        labelTotalExames.setHorizontalAlignment(4);
        labelTotalExamesCH.setHorizontalAlignment(4);
        labelTotalMateriais.setHorizontalAlignment(4);
        labelSubtotal.setHorizontalAlignment(4);
        labelDesconto.setHorizontalAlignment(4);
        labelAcrescimo.setHorizontalAlignment(4);
        labelAdicional.setHorizontalAlignment(4);
        labelDespesas.setHorizontalAlignment(4);
        labelTotalGeral.setHorizontalAlignment(4);
        labelVQtdeRequisicoes.setHorizontalAlignment(4);
        labelVQtdeExames.setHorizontalAlignment(4);
        labelVQtdeGuias.setHorizontalAlignment(4);
        labelVTotalExames.setHorizontalAlignment(4);
        labelVTotalExamesCH.setHorizontalAlignment(4);
        labelVTotalMateriais.setHorizontalAlignment(4);
        labelVSubtotal.setHorizontalAlignment(4);
        labelVDesconto.setHorizontalAlignment(4);
        labelVAcrescimo.setHorizontalAlignment(4);
        labelVAdicional.setHorizontalAlignment(4);
        labelVDespesas.setHorizontalAlignment(4);
        labelVTotalGeral.setHorizontalAlignment(4);
        labelQtdeExamesMicrobiologia.setHorizontalAlignment(4);
        labelVQtdeExamesMicrobiologia.setHorizontalAlignment(4);
        labelTotalExamesMicrobiologia.setHorizontalAlignment(4);
        labelVTotalExamesMicrobiologia.setHorizontalAlignment(4);
        labelQtdeExamesFiscoQuimico.setHorizontalAlignment(4);
        labelVQtdeExamesFiscoQuimico.setHorizontalAlignment(4);
        labelTotalExamesFiscoQuimico.setHorizontalAlignment(4);
        labelVTotalExamesFiscoQuimico.setHorizontalAlignment(4);
        labelQtdeExamesCromatografia.setHorizontalAlignment(4);
        labelVQtdeExamesCromatografia.setHorizontalAlignment(4);
        labelTotalExamesCromatografia.setHorizontalAlignment(4);
        labelVTotalExamesCromatografia.setHorizontalAlignment(4);
        labelQtdeExamesOutros.setHorizontalAlignment(4);
        labelVQtdeExamesOutros.setHorizontalAlignment(4);
        labelTotalExamesOutros.setHorizontalAlignment(4);
        labelVTotalExamesOutros.setHorizontalAlignment(4);
        Font fonte = new Font(this.labelRequisicao.getFont().getName(), 0, 10);
        fonte = fonte.deriveFont(1);
        labelQtdeRequisicoes.setFont(fonte);
        labelQtdeGuias.setFont(fonte);
        labelQtdeExames.setFont(fonte);
        labelTotalExames.setFont(fonte);
        labelTotalExamesCH.setFont(fonte);
        labelTotalMateriais.setFont(fonte);
        labelSubtotal.setFont(fonte);
        labelDesconto.setFont(fonte);
        labelAcrescimo.setFont(fonte);
        labelAdicional.setFont(fonte);
        labelDespesas.setFont(fonte);
        labelTotalGeral.setFont(fonte);
        labelDescricaoDesconto.setFont(fonte);
        labelDescricaoAcrescimo.setFont(fonte);
        labelVQtdeRequisicoes.setFont(fonte);
        labelVQtdeExames.setFont(fonte);
        labelVQtdeGuias.setFont(fonte);
        labelVTotalExames.setFont(fonte);
        labelVTotalExamesCH.setFont(fonte);
        labelVTotalMateriais.setFont(fonte);
        labelVSubtotal.setFont(fonte);
        labelVDesconto.setFont(fonte);
        labelVAcrescimo.setFont(fonte);
        labelVAdicional.setFont(fonte);
        labelVDespesas.setFont(fonte);
        labelVTotalGeral.setFont(fonte);
        int contaLinha = 0;
        if (Variaveis.tipoFilialPadrao.equals("A") && this.ordemFatura.equalsIgnoreCase("S")) {
            labelQtdeExamesMicrobiologia.setFont(fonte);
            labelVQtdeExamesMicrobiologia.setFont(fonte);
            labelTotalExamesMicrobiologia.setFont(fonte);
            labelVTotalExamesMicrobiologia.setFont(fonte);
            labelQtdeExamesFiscoQuimico.setFont(fonte);
            labelVQtdeExamesFiscoQuimico.setFont(fonte);
            labelTotalExamesFiscoQuimico.setFont(fonte);
            labelVTotalExamesFiscoQuimico.setFont(fonte);
            labelQtdeExamesCromatografia.setFont(fonte);
            labelVQtdeExamesCromatografia.setFont(fonte);
            labelTotalExamesCromatografia.setFont(fonte);
            labelVTotalExamesCromatografia.setFont(fonte);
            labelQtdeExamesOutros.setFont(fonte);
            labelVQtdeExamesOutros.setFont(fonte);
            labelTotalExamesOutros.setFont(fonte);
            labelVTotalExamesOutros.setFont(fonte);
            labelQtdeRequisicoes.setFont(fonte);
            cons.gridx = 0;
            cons.gridy = contaLinha;
            cons.weightx = 1.0;
            cons.fill = 2;
            this.add((Component)labelQtdeExamesFiscoQuimico, cons);
            ++cons.gridx;
            cons.gridy = contaLinha++;
            this.add((Component)labelVQtdeExamesFiscoQuimico, cons);
            ++cons.gridy;
            cons.gridx = 0;
            this.add((Component)labelTotalExamesFiscoQuimico, cons);
            ++cons.gridx;
            this.add((Component)labelVTotalExamesFiscoQuimico, cons);
            ++cons.gridy;
            cons.gridx = 0;
            this.add((Component)labelQtdeExamesMicrobiologia, cons);
            ++cons.gridx;
            this.add((Component)labelVQtdeExamesMicrobiologia, cons);
            ++cons.gridy;
            cons.gridx = 0;
            this.add((Component)labelTotalExamesMicrobiologia, cons);
            ++cons.gridx;
            this.add((Component)labelVTotalExamesMicrobiologia, cons);
            ++cons.gridy;
            cons.gridx = 0;
            this.add((Component)labelQtdeExamesCromatografia, cons);
            ++cons.gridx;
            this.add((Component)labelVQtdeExamesCromatografia, cons);
            ++cons.gridy;
            cons.gridx = 0;
            this.add((Component)labelTotalExamesCromatografia, cons);
            ++cons.gridx;
            this.add((Component)labelVTotalExamesCromatografia, cons);
            ++cons.gridy;
            cons.gridx = 0;
            this.add((Component)labelQtdeExamesOutros, cons);
            ++cons.gridx;
            this.add((Component)labelVQtdeExamesOutros, cons);
            ++cons.gridy;
            cons.gridx = 0;
            this.add((Component)labelTotalExamesOutros, cons);
            ++cons.gridx;
            this.add((Component)labelVTotalExamesOutros, cons);
        }
        contaLinha = 0;
        cons.gridx = 2;
        cons.weightx = 1.0;
        cons.gridy = contaLinha++;
        cons.fill = 2;
        this.add((Component)labelQtdeRequisicoes, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelQtdeExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelQtdeGuias, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelTotalExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelTotalExamesCH, cons);
        if (total.getTotalMateriais().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelTotalMateriais, cons);
        }
        ++contaLinha;
        cons.gridy = contaLinha++;
        this.add((Component)labelSubtotal, cons);
        if (total.getPercentualAcrescimo().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelAcrescimo, cons);
        }
        if (total.getPercentualBonus().compareTo(BigDecimal.ZERO) > 0) {
            ++contaLinha;
            cons.gridy = contaLinha++;
            this.add((Component)labelDesconto, cons);
            if (!Funcoes.textoVazio(total.getDescricaoDesconto())) {
                cons.gridy = contaLinha;
            }
        }
        if (total.getAdicional().compareTo(BigDecimal.ZERO) > 0) {
            ++contaLinha;
            cons.gridy = contaLinha++;
            this.add((Component)labelAdicional, cons);
            if (!Funcoes.textoVazio(total.getDescricaoAcrescimo())) {
                cons.gridy = contaLinha;
            }
        }
        if (total.getCobranca().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelDespesas, cons);
        }
        cons.gridy = ++contaLinha;
        this.add((Component)labelTotalGeral, cons);
        contaLinha = 0;
        cons.gridx = 3;
        cons.gridy = contaLinha++;
        cons.fill = 2;
        this.add((Component)labelVQtdeRequisicoes, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelVQtdeExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelVQtdeGuias, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelVTotalExames, cons);
        cons.gridy = contaLinha++;
        this.add((Component)labelVTotalExamesCH, cons);
        if (total.getTotalMateriais().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelVTotalMateriais, cons);
            tamanhoPainel += 15;
        }
        ++contaLinha;
        cons.gridy = contaLinha++;
        this.add((Component)labelVSubtotal, cons);
        if (total.getPercentualAcrescimo().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = contaLinha;
            this.add((Component)labelVAcrescimo, cons);
            tamanhoPainel += 15;
        }
        if (total.getPercentualBonus().compareTo(BigDecimal.ZERO) > 0) {
            ++contaLinha;
            cons.gridy = contaLinha++;
            this.add((Component)labelVDesconto, cons);
            tamanhoPainel += 15;
            if (!Funcoes.textoVazio(total.getDescricaoDesconto())) {
                cons.gridx = 0;
                cons.gridwidth = 2;
                cons.gridy = contaLinha;
                this.add((Component)labelDescricaoDesconto, cons);
                tamanhoPainel += 15;
                met = labelDescricaoDesconto.getFontMetrics(labelDescricaoDesconto.getFont());
                width = met.stringWidth(total.getDescricaoDesconto());
                if (this.tabela.getWidth() > 0 && (width + 100) / this.tabela.getWidth() >= 1) {
                    tamanhoPainel += 15;
                    labelDescricaoDesconto.setMinimumSize(new Dimension(labelDescricaoDesconto.getWidth(), 30));
                }
                cons.gridx = 2;
                cons.gridwidth = 2;
            }
        }
        if (total.getAdicional().compareTo(BigDecimal.ZERO) > 0) {
            ++contaLinha;
            cons.gridy = contaLinha++;
            this.add((Component)labelVAdicional, cons);
            tamanhoPainel += 15;
            if (!Funcoes.textoVazio(total.getDescricaoAcrescimo())) {
                cons.gridx = 0;
                cons.gridwidth = 2;
                cons.gridy = contaLinha;
                this.add((Component)labelDescricaoAcrescimo, cons);
                tamanhoPainel += 15;
                met = labelDescricaoAcrescimo.getFontMetrics(labelDescricaoAcrescimo.getFont());
                width = met.stringWidth(total.getDescricaoAcrescimo());
                if (this.tabela.getWidth() > 0 && (width + 100) / this.tabela.getWidth() >= 1) {
                    tamanhoPainel += 15;
                    labelDescricaoAcrescimo.setMinimumSize(new Dimension(labelDescricaoAcrescimo.getWidth(), 30));
                }
                cons.gridx = 2;
                cons.gridwidth = 2;
            }
        }
        if (total.getCobranca().compareTo(BigDecimal.ZERO) > 0) {
            cons.gridy = ++contaLinha;
            this.add((Component)labelVDespesas, cons);
            tamanhoPainel += 15;
        }
        ++contaLinha;
        cons.gridy = contaLinha++;
        this.add((Component)labelVTotalGeral, cons);
        cons.gridx = 2;
        cons.weightx = 0.0;
        cons.fill = 0;
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setPreferredSize(new Dimension(14, 14));
        p.setMinimumSize(new Dimension(14, 14));
        this.add((Component)p, cons);
        if (!Funcoes.textoVazio(total.getMensagem())) {
            cons.gridx = 0;
            cons.gridy = contaLinha;
            cons.gridwidth = 2;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.anchor = 18;
            JTextArea txt = new JTextArea();
            txt.setFont(fonte);
            txt.setFocusable(false);
            txt.setEditable(false);
            txt.setBorder(null);
            txt.setText(total.getMensagem());
            txt.setOpaque(false);
            this.add((Component)txt, cons);
            tamanhoPainel += 15 * this.getQuantidadeQuebrasLinhaString(total.getMensagem());
        }
        if (table.getRowHeight(row) != tamanhoPainel + 5) {
            table.setRowHeight(row, tamanhoPainel + 5);
            this.revalidate();
        }
    }

    private int getQuantidadeQuebrasLinhaString(String mensagem) {
        if (Funcoes.textoVazio(mensagem)) {
            return 0;
        }
        int qtde = 0;
        for (int i = 0; i < mensagem.length(); ++i) {
            if (!mensagem.substring(i, i + 1).contains("\n")) continue;
            ++qtde;
        }
        return qtde;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (table.getRowCount() - 1 > row) {
            this.marcaSelecao(table, true);
        } else {
            this.desmarcaSelecao(table, true);
        }
        if (value instanceof DadosFaturamento) {
            DadosFaturamento d = (DadosFaturamento)value;
            this.atualizaDados(d, table, row, true, true);
        } else if (value instanceof DadosTotalGeral) {
            this.atualizaTotalGeral((DadosTotalGeral)value, table, row, isSelected);
        }
        if (!table.hasFocus()) {
            table.setRowSelectionInterval(row, row);
            table.requestFocus();
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.marcaSelecao(table, isSelected);
        if (value instanceof DadosFaturamento) {
            DadosFaturamento d = (DadosFaturamento)value;
            this.atualizaDados(d, table, row, isSelected, false);
        } else if (value instanceof DadosTotalGeral) {
            this.atualizaTotalGeral((DadosTotalGeral)value, table, row, isSelected);
        }
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        return this;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] ouvintes = (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].editingCanceled(new ChangeEvent(this));
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] ouvintes = (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].editingStopped(new ChangeEvent(this));
        }
    }

    private void marcaSelecao(JTable table, boolean isSelected) {
        this.setOpaque(isSelected);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        }
        this.invalidate();
    }

    private void desmarcaSelecao(JTable table, boolean isSelected) {
        this.setOpaque(false);
        if (isSelected) {
            this.setBackground(table.getBackground());
        }
    }

    public void addSelecaoListener(SelecaoListener l) {
        this.listenerList.add(SelecaoListener.class, l);
    }

    public void removeSelecaoListener(SelecaoListener l) {
        this.listenerList.remove(SelecaoListener.class, l);
    }

    private void fireSelecionado() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = 0; i <= ouvintes.length - 2; i += 2) {
            if (ouvintes[i] != SelecaoListener.class) continue;
            ((SelecaoListener)ouvintes[i + 1]).selecionado();
        }
    }
}

