/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.laboratorio.util.faturamento.ConvenioCotaExameBeanAux;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.model.enums.EnumTipoRateio;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;

public class Calculos {
    public static void calculaPrecoExame(DadosFaturamento dados, DadosExameFaturamento exame, ResultSet rs, String reajusteConvenio, boolean utilizarPrecosDiferenciados) throws SQLException {
        BigDecimal totalMateriais = BigDecimal.ZERO;
        BigDecimal valorExameAux = BigDecimal.ZERO;
        for (int i = 0; i < exame.getMateriaisCount(); ++i) {
            totalMateriais.add(exame.getMaterial(i).getValor().multiply(exame.getMaterial(i).getQuantidade()));
        }
        if (dados.getTipoCalculoFatura().equals("R")) {
            BigDecimal valorExame = new BigDecimal(0);
            valorExame = !dados.isTabelaTipoCBHPM() ? (dados.getTipoCalculoCH().equals("M") ? rs.getBigDecimal("exr_vlrchexame").multiply(rs.getBigDecimal("exr_vlrch")) : rs.getBigDecimal("exr_vlrchexame").divide(rs.getBigDecimal("exr_vlrch"))) : rs.getBigDecimal("exr_vlrchexame").multiply(rs.getBigDecimal("exr_valorporte")).add(rs.getBigDecimal("exr_valorcusto").multiply(rs.getBigDecimal("exr_valoruco")));
            valorExame = valorExame.multiply(new BigDecimal(100).subtract(rs.getBigDecimal("exr_vlrbalcaoconvenio")).divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame()));
            exame.setValorExame(valorExame.add(totalMateriais));
            exame.setValorBalcao(rs.getBigDecimal("exr_vlrbalcaoconvenio"));
            exame.setValorMaterial(totalMateriais);
            if (!exame.isConvenioRepasse()) {
                exame.setValorCHExame(rs.getBigDecimal("exr_vlrchexame"));
                exame.setValorCH(rs.getBigDecimal("exr_vlrch"));
                exame.setValorPorteCBHPM(rs.getBigDecimal("exr_valorporte"));
                exame.setUcoCBHPM(rs.getBigDecimal("exr_valoruco"));
                exame.setCustoCBHPM(rs.getBigDecimal("exr_valorcusto"));
                exame.setPorteCBHPM(rs.getString("exr_porte"));
            } else {
                exame.setValorCHExame(rs.getBigDecimal("exr_vlrchexamerepasse"));
                exame.setValorCH(rs.getBigDecimal("exr_vlrchrepasse"));
                exame.setValorPorteCBHPM(rs.getBigDecimal("exr_valorporterepasse"));
                exame.setUcoCBHPM(rs.getBigDecimal("exr_valorucorepasse"));
                exame.setCustoCBHPM(rs.getBigDecimal("exr_valorcustorepasse"));
                exame.setPorteCBHPM(rs.getString("exr_porterepasse"));
            }
        } else {
            String reajuste;
            BigDecimal valor = rs.getBigDecimal("dtp_valor");
            valorExameAux = rs.getBigDecimal("dtp_valor");
            String portePorConvenio = null;
            BigDecimal valorPortePorConvenio = null;
            BigDecimal percentualPorConvenio = null;
            BigDecimal valorPorConvenio = null;
            if (utilizarPrecosDiferenciados) {
                if (!DBUtil.campoNull(rs.getString("cpr_valor"))) {
                    valor = rs.getBigDecimal("cpr_valor");
                    valorExameAux = rs.getBigDecimal("cpr_valor");
                    valorPorConvenio = rs.getBigDecimal("cpr_valor");
                }
                if (!DBUtil.campoNull(rs.getString("tpp_porteconvenio"))) {
                    portePorConvenio = rs.getString("tpp_porteconvenio");
                }
                if (!DBUtil.campoNull(rs.getString("tpp_valorconvenio"))) {
                    valorPortePorConvenio = rs.getBigDecimal("tpp_valorconvenio");
                }
                if (!DBUtil.campoNull(rs.getString("cpr_percentual"))) {
                    percentualPorConvenio = rs.getBigDecimal("cpr_percentual");
                }
            }
            if (!Funcoes.textoVazio(reajuste = reajusteConvenio)) {
                String[] indices;
                for (String indice : indices = reajuste.split("\\+")) {
                    if (!Funcoes.isNumeric(indice)) continue;
                    BigDecimal percentualIndice = new BigDecimal(Funcoes.limpaDecimal(indice));
                    valor = valor.add(valor.multiply(percentualIndice).divide(new BigDecimal(100), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
                    valorExameAux = valorExameAux.add(valorExameAux.multiply(percentualIndice).divide(new BigDecimal(100), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
                }
            }
            valor = valor != null && dados.getValorBalcao() != null && dados.getValorBalcao().compareTo(new BigDecimal(100)) < 0 ? valor.multiply(new BigDecimal(100).subtract(dados.getValorBalcao())).divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0);
            BigDecimal valorPorte = valorPortePorConvenio != null ? valorPortePorConvenio : (DBUtil.campoNull(rs.getString("tpp_valor")) ? new BigDecimal(0) : rs.getBigDecimal("tpp_valor"));
            BigDecimal valorUCO = dados.getValorUCO();
            if (valor.compareTo(BigDecimal.ZERO) > 0) {
                if (!dados.isTabelaTipoCBHPM()) {
                    if (dados.getTipoCalculoCH().equals("M")) {
                        valor = valor.multiply(dados.getValorCHConvenio());
                        valorExameAux = valorExameAux.multiply(dados.getValorCHConvenio());
                    } else {
                        valor = valor.divide(dados.getValorCHConvenio(), ParametrosGerais.getArredondamentoPrecoExame());
                        valorExameAux = valorExameAux.divide(dados.getValorCHConvenio(), ParametrosGerais.getArredondamentoPrecoExame());
                    }
                } else {
                    BigDecimal valorDescontoPorte = rs.getBigDecimal("con_descontoporte");
                    BigDecimal valorDescontoUCO = rs.getBigDecimal("con_descontouco");
                    BigDecimal valorAcrescimoPorte = rs.getBigDecimal("con_acrescimoporte");
                    BigDecimal valorAcrescimoUCO = rs.getBigDecimal("con_acrescimouco");
                    if (valorAcrescimoPorte.compareTo(BigDecimal.ZERO) > 0) {
                        valorPorte = valorPorte.add(valorPorte.multiply(valorAcrescimoPorte.divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame())));
                    }
                    if (valorDescontoPorte.compareTo(BigDecimal.ZERO) > 0) {
                        valorPorte = valorPorte.subtract(valorPorte.multiply(valorDescontoPorte.divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame())));
                    }
                    if (valorAcrescimoUCO.compareTo(BigDecimal.ZERO) > 0) {
                        valorUCO = valorUCO.add(valorUCO.multiply(valorAcrescimoUCO.divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame())));
                    }
                    if (valorDescontoUCO.compareTo(BigDecimal.ZERO) > 0) {
                        valorUCO = valorUCO.subtract(valorUCO.multiply(valorDescontoUCO.divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame())));
                    }
                    BigDecimal percentual = percentualPorConvenio != null ? percentualPorConvenio : rs.getBigDecimal("dtp_percentual");
                    valor = percentual.multiply(valorPorte).add(valor.multiply(valorUCO));
                    valorExameAux = percentual.multiply(valorPorte).add(valorExameAux.multiply(valorUCO));
                }
                if (dados.getValorBalcao().compareTo(BigDecimal.ZERO) <= 0) {
                    if (dados.getValorAcrescimo().compareTo(BigDecimal.ZERO) > 0) {
                        valor = valor.add(valor.multiply(dados.getValorAcrescimo()).divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame()));
                    }
                    if (dados.getValorBonus().compareTo(BigDecimal.ZERO) > 0) {
                        valor = valor.subtract(valor.multiply(dados.getValorBonus()).divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame()));
                    }
                }
            }
            if (!exame.isConvenioRepasse()) {
                exame.setValorExame(valor.add(totalMateriais));
                exame.setValorBalcao(dados.getValorBalcao().multiply(valorExameAux).divide(new BigDecimal(100)));
            } else {
                exame.setValorExame(dados.getValorBalcao().multiply(valorExameAux).divide(new BigDecimal(100)));
                exame.setValorBalcao(BigDecimal.ZERO);
            }
            exame.setValorCHExame(valorPorConvenio != null ? valorPorConvenio : rs.getBigDecimal("dtp_valor"));
            exame.setValorCH(dados.getValorCHConvenio());
            if (dados.isTabelaTipoCBHPM()) {
                exame.setValorCHExame(percentualPorConvenio != null ? percentualPorConvenio : rs.getBigDecimal("dtp_percentual"));
            }
            exame.setValorMaterial(totalMateriais);
            if (!exame.isConvenioRepasse()) {
                exame.setUcoCBHPM(valorUCO);
                exame.setCustoCBHPM(valorPorConvenio != null ? valorPorConvenio : rs.getBigDecimal("dtp_valor"));
                exame.setPorteCBHPM(portePorConvenio != null ? portePorConvenio : rs.getString("tpp_porte"));
                exame.setValorPorteCBHPM(valorPorte);
            } else {
                exame.setUcoCBHPMRepasse(valorUCO);
                exame.setCustoCBHPMRepasse(valorPorConvenio != null ? valorPorConvenio : rs.getBigDecimal("dtp_valor"));
                exame.setPorteCBHPMRepasse(portePorConvenio != null ? portePorConvenio : rs.getString("tpp_porte"));
                exame.setValorPorteCBHPMRepasse(valorPorte);
            }
        }
    }

    public static void calculaTotalRequisicao(DadosFaturamento dados) {
        BigDecimal total = new BigDecimal(0);
        BigDecimal totalCH = new BigDecimal(0);
        BigDecimal totalMateriais = new BigDecimal(0);
        Integer qFisicoQuimico = 0;
        Integer qMicrobiologia = 0;
        Integer qOutros = 0;
        for (int i = 0; i < dados.getExamesCount(); ++i) {
            DadosExameFaturamento d = dados.getExame(i);
            if (!d.getFaturar()) continue;
            total = total.add(d.getValorExame() != null ? d.getValorExame() : new BigDecimal(0));
            totalCH = totalCH.add(d.getValorCHExame() != null ? d.getValorCHExame() : new BigDecimal(0));
            totalMateriais = totalMateriais.add(d.getValorMaterial() != null ? d.getValorMaterial() : new BigDecimal(0));
        }
        dados.setValorTotal(total.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
        dados.setValorTotalCH(totalCH);
        dados.setValorTotalExames(total.subtract(totalMateriais));
        dados.setValorTotalMateriais(totalMateriais);
    }

    public static void calculaTotalRequisicao(DadosFaturamento dados, int casasDecimais, RoundingMode tipoArredondamento) {
        BigDecimal total = new BigDecimal(0);
        BigDecimal totalCH = new BigDecimal(0);
        BigDecimal totalMateriais = new BigDecimal(0);
        Integer qFisicoQuimico = 0;
        Integer qMicrobiologia = 0;
        Integer qOutros = 0;
        for (int i = 0; i < dados.getExamesCount(); ++i) {
            DadosExameFaturamento d = dados.getExame(i);
            if (!d.getFaturar()) continue;
            total = total.add(d.getValorExame() != null ? d.getValorExame().setScale(casasDecimais, tipoArredondamento) : new BigDecimal(0));
            totalCH = totalCH.add(d.getValorCHExame() != null ? d.getValorCHExame().setScale(casasDecimais, tipoArredondamento) : new BigDecimal(0));
            totalMateriais = totalMateriais.add(d.getValorMaterial() != null ? d.getValorMaterial().setScale(casasDecimais, tipoArredondamento) : new BigDecimal(0));
        }
        dados.setValorTotal(total.setScale(casasDecimais, tipoArredondamento));
        dados.setValorTotalCH(totalCH);
        dados.setValorTotalExames(total.subtract(totalMateriais));
        dados.setValorTotalMateriais(totalMateriais);
    }

    public static void calculaTotal(Statement st, int linhaTotal, JTable tabela, LinhasTabela modelo) throws SQLException {
        if (linhaTotal > modelo.getRowCount() || !(modelo.getValueAt(linhaTotal, 0) instanceof DadosTotalGeral) || tabela == null || tabela.getRowCount() <= 1) {
            return;
        }
        StringBuilder buf = new StringBuilder("");
        DadosTotalGeral total = (DadosTotalGeral)modelo.getValueAt(linhaTotal, 0);
        int qtdeExames = 0;
        int qtdeRequisicao = 0;
        int qtdeGuias = 0;
        int qMicrobiologia = 0;
        int qFisicoQuimico = 0;
        int qOutros = 0;
        int qCromatografia = 0;
        BigDecimal totalExamesCH = new BigDecimal(0);
        BigDecimal totalGeral = new BigDecimal(0);
        BigDecimal totalExames = new BigDecimal(0);
        BigDecimal totalMateriais = new BigDecimal(0);
        BigDecimal adicional = new BigDecimal(0);
        BigDecimal cobranca = new BigDecimal(0);
        BigDecimal xx = new BigDecimal(0);
        BigDecimal totalFisicoQuimico = new BigDecimal(0);
        BigDecimal totalMicrobiologia = new BigDecimal(0);
        BigDecimal totalOutros = new BigDecimal(0);
        BigDecimal totalCromatografia = new BigDecimal(0);
        Integer codigoConvenio = null;
        Integer codigoFilial = null;
        ArrayList<String> listaGuia = new ArrayList<String>();
        for (int i = 0; i < modelo.getRowCount(); ++i) {
            if (!(modelo.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
            DadosFaturamento fatura = (DadosFaturamento)modelo.getValueAt(i, 0);
            if (Funcoes.objectIsNull(codigoConvenio)) {
                codigoFilial = fatura.getCodigoFilial();
                codigoConvenio = fatura.getCodigoConvenio();
            }
            BigDecimal tempTotalExamesCH = new BigDecimal(0);
            BigDecimal tempTotalExames = new BigDecimal(0);
            BigDecimal tempTotalMateriais = new BigDecimal(0);
            if (fatura.getFaturar()) {
                if (!Funcoes.textoVazio(fatura.getGuia()) && listaGuia.indexOf(fatura.getGuia()) < 0) {
                    listaGuia.add(fatura.getGuia());
                }
                ++qtdeRequisicao;
                for (int j = 0; j < fatura.getExamesCount(); ++j) {
                    DadosExameFaturamento exameFatura = fatura.getExame(j);
                    if (!exameFatura.getFaturar()) continue;
                    ++qtdeExames;
                    tempTotalExamesCH = tempTotalExamesCH.add(exameFatura.getValorCHExame());
                    tempTotalExames = tempTotalExames.add(exameFatura.getValorExame().setScale(total.getCasasDecimais(), total.getTipoArredondamento()));
                    tempTotalMateriais = tempTotalMateriais.add(exameFatura.getValorMaterial().setScale(2, total.getTipoArredondamento()));
                    String tipoAlimentos = "";
                    if (!Funcoes.textoVazio(exameFatura.getCodigoGuia()) && !listaGuia.contains(exameFatura.getCodigoGuia())) {
                        listaGuia.add(exameFatura.getCodigoGuia());
                    }
                    if (!Calculos.isOrdenaFaturaAlimentos(fatura.getOrdemFatura())) continue;
                    if (EnumTipoRateio.isMicrobiologico(exameFatura.getTipoAlimentos())) {
                        totalMicrobiologia = totalMicrobiologia.add(exameFatura.getValorExame());
                        ++qMicrobiologia;
                    }
                    if (EnumTipoRateio.isFisicoQuimico(exameFatura.getTipoAlimentos())) {
                        totalFisicoQuimico = totalFisicoQuimico.add(exameFatura.getValorExame());
                        ++qFisicoQuimico;
                    }
                    if (EnumTipoRateio.isOutros(exameFatura.getTipoAlimentos())) {
                        totalOutros = totalOutros.add(exameFatura.getValorExame());
                        ++qOutros;
                    }
                    if (!EnumTipoRateio.isCromatografia(exameFatura.getTipoAlimentos())) continue;
                    totalCromatografia = totalCromatografia.add(exameFatura.getValorExame());
                    ++qCromatografia;
                }
            }
            xx = xx.add(tempTotalExames.setScale(2, total.getTipoArredondamento()));
            totalExames = totalExames.add(tempTotalExames.setScale(2, total.getTipoArredondamento()));
            totalExamesCH = totalExamesCH.add(tempTotalExamesCH.setScale(2, total.getTipoArredondamento()));
            totalMateriais = totalMateriais.add(tempTotalMateriais.setScale(2, total.getTipoArredondamento()));
        }
        totalGeral = totalGeral.add(totalExames.setScale(2, total.getTipoArredondamento()).add(totalMateriais).setScale(2, total.getTipoArredondamento()));
        qtdeGuias = listaGuia.size();
        total.setQtdeRequisicoes(qtdeRequisicao);
        total.setQtdeGuias(qtdeGuias);
        total.setQtdeExames(qtdeExames);
        total.setTotalExamesCH(totalExamesCH.setScale(2, total.getTipoArredondamento()));
        total.setTotalMateriais(totalMateriais.setScale(2, total.getTipoArredondamento()));
        total.setTotalExames(totalExames.setScale(2, total.getTipoArredondamento()));
        total.setTotalFisicoQuimico(totalFisicoQuimico);
        total.setTotalMicrobiologia(totalMicrobiologia.setScale(2, total.getTipoArredondamento()));
        total.setTotalOutros(totalOutros.setScale(2, total.getTipoArredondamento()));
        total.setTotalCromatografia(totalCromatografia);
        total.setQtdeFiscoQuimico(qFisicoQuimico);
        total.setQtdeMicrobiologia(qMicrobiologia);
        total.setQtdeOutros(qOutros);
        total.setQtdeCromatografia(qCromatografia);
        buf.delete(0, buf.length());
        buf.append("select coalesce(sum(dco_vlrcobranca), 0) as somacobranca from despcobranca ");
        buf.append(" where ");
        buf.append(Calculos.pegaConvenios(tabela, "fil_codigo", "con_codigo"));
        buf.append(" and dco_vlrmin <= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and dco_vlrmax >= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            cobranca = rs.getBigDecimal("somacobranca").compareTo(BigDecimal.ZERO) > 0 ? rs.getBigDecimal("somacobranca") : total.getCobranca();
        }
        total.setCobranca(cobranca);
        buf.delete(0, buf.length());
        buf.append("select coalesce(sum(adc_vlradicional), 0) as somaadicional from adicionalfatura ");
        buf.append(" where ");
        buf.append(Calculos.pegaConvenios(tabela, "fil_codigo", "con_codigo"));
        buf.append(" and adc_vlrinicial <= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and adc_vlrfim >= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            adicional = rs.getBigDecimal("somaadicional").compareTo(BigDecimal.ZERO) > 0 ? rs.getBigDecimal("somaadicional") : total.getAdicional();
        }
        total.setAdicional(adicional);
        BigDecimal desconto = totalGeral.multiply(total.getPercentualBonus().divide(new BigDecimal(100))).setScale(2, total.getTipoArredondamento());
        total.setTotal(totalGeral.add(adicional).add(cobranca).subtract(desconto).setScale(2, total.getTipoArredondamento()));
        rs.close();
    }

    private static boolean isOrdenaFaturaAlimentos(String ordemFatura) {
        return Variaveis.tipoFilialPadrao.equals("A") && ordemFatura.equalsIgnoreCase("S");
    }

    private static void calculaCotaExame(int linhaTotal, LinhasTabela modeloTabela, int codigoConvenio) throws SQLException {
        ArrayList<ConvenioCotaExameBeanAux> convenioCotaExameBeanAuxs = new ArrayList<ConvenioCotaExameBeanAux>();
        BigDecimal valorAdicional = BigDecimal.ZERO;
        valorAdicional.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        DadosTotalGeral dadosTotalGeral = (DadosTotalGeral)modeloTabela.getValueAt(linhaTotal, 0);
        ArrayList<ConvenioCotaExameBeanAux> examCotaMsg = new ArrayList<ConvenioCotaExameBeanAux>();
        Integer codigoRequisicaoAnterior = -1;
        for (int i = 0; i < modeloTabela.getRowCount(); ++i) {
            if (!(modeloTabela.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
            ArrayList listaPai = new ArrayList();
            Iterator<ConvenioCotaExameBeanAux> requisicao = (DadosFaturamento)modeloTabela.getValueAt(i, 0);
            ArrayList<DadosExameFaturamento> exames = ((DadosFaturamento)((Object)requisicao)).getExames();
            if (codigoRequisicaoAnterior == -1) {
                codigoRequisicaoAnterior = ((DadosFaturamento)((Object)requisicao)).getRequisicao();
            }
            Set situacoesAcordado = null;
            try {
                situacoesAcordado = new ConvenioService().loadCotaExameSituacao(" where fil_codigo = " + ((DadosFaturamento)((Object)requisicao)).getCodigoFilial() + " and con_codigo = " + ((DadosFaturamento)((Object)requisicao)).getCodigoConvenio() + " and sit_codigo = " + ((DadosFaturamento)((Object)requisicao)).getCodigoSituacao());
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            if (!situacoesAcordado.isEmpty()) continue;
            for (DadosExameFaturamento dadosExameFaturamento : exames) {
                if (!dadosExameFaturamento.getFaturar()) continue;
                ConvenioCotaExameBeanAux cotaExameBeanAux = new ConvenioCotaExameBeanAux();
                cotaExameBeanAux.setCon_codigo(((DadosFaturamento)((Object)requisicao)).getCodigoConvenio());
                cotaExameBeanAux.setExa_codigo(dadosExameFaturamento.getCodigoExame());
                cotaExameBeanAux.setMco_codigo(dadosExameFaturamento.getCodigoMaterial());
                cotaExameBeanAux.setDescricaoMaterial(dadosExameFaturamento.getDescricaoMaterial());
                if (ParametrosGerais.getPrecoMetodologia() && dadosExameFaturamento.getCodigoMetodologia() != null) {
                    cotaExameBeanAux.setMet_codigo(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                } else {
                    cotaExameBeanAux.setMet_codigo(0);
                }
                if (dadosExameFaturamento.getCodigoMetodologia() != null) {
                    cotaExameBeanAux.setMet_codigo_orginal(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                } else {
                    cotaExameBeanAux.setMet_codigo_orginal(0);
                }
                DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(String.valueOf(((DadosFaturamento)((Object)requisicao)).getCodigoFilial()), dadosExameFaturamento.getCodigoMaterial());
                DadosExames dadosExames = ExameUtil.getDadosExame(String.valueOf(((DadosFaturamento)((Object)requisicao)).getCodigoFilial()), dadosExameFaturamento.getCodigoExame(), dadosMaterial);
                DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(String.valueOf(((DadosFaturamento)((Object)requisicao)).getCodigoFilial()), ((DadosFaturamento)((Object)requisicao)).getCodigoConvenio());
                ExameUtil.calculaPrecoExame(String.valueOf(((DadosFaturamento)((Object)requisicao)).getCodigoFilial()), dadosExames, dadosMaterial, dadosConvenios, false, true, true, null, null, Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                cotaExameBeanAux.setValorTotalExame(dadosExames.getValorExame());
                if (!convenioCotaExameBeanAuxs.contains(cotaExameBeanAux)) {
                    cotaExameBeanAux.somaQuantidadeExame();
                    convenioCotaExameBeanAuxs.add(cotaExameBeanAux);
                } else {
                    int posicao = convenioCotaExameBeanAuxs.indexOf(cotaExameBeanAux);
                    ((ConvenioCotaExameBeanAux)convenioCotaExameBeanAuxs.get(posicao)).somaQuantidadeExame();
                }
                if (codigoRequisicaoAnterior.intValue() == ((DadosFaturamento)((Object)requisicao)).getRequisicao()) continue;
                codigoRequisicaoAnterior = ((DadosFaturamento)((Object)requisicao)).getRequisicao();
            }
        }
        ExameService exameService = new ExameService();
        List<ConvenioCotaExameBeanAux> acordados = exameService.getAcordados(String.valueOf(codigoConvenio));
        for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : convenioCotaExameBeanAuxs) {
            List<ConvenioCotaExameBeanAux> exameCota = exameService.obterCotaExame(convenioCotaExameBeanAux);
            Integer qtdRealizada = convenioCotaExameBeanAux.getCct_quantidade();
            for (ConvenioCotaExameBeanAux map : exameCota) {
                Integer qtdAcordada = map.getCct_quantidade();
                Integer diferenca = qtdAcordada - qtdRealizada;
                if (diferenca > 0) {
                    valorAdicional = valorAdicional.add(convenioCotaExameBeanAux.getValorTotalExame().multiply(new BigDecimal(diferenca)));
                    convenioCotaExameBeanAux.setAcordada(qtdAcordada);
                    convenioCotaExameBeanAux.setDiferenca(diferenca);
                    examCotaMsg.add(convenioCotaExameBeanAux);
                }
                acordados.remove(map);
            }
        }
        for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : acordados) {
            DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getMco_codigo());
            convenioCotaExameBeanAux.setDescricaoMaterial(dadosMaterial.getDescricao());
            DadosExames dadosExames = ExameUtil.getDadosExame(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getExa_codigo(), dadosMaterial);
            DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getCon_codigo());
            ExameUtil.calculaPrecoExame(convenioCotaExameBeanAux.getFil_codigo().toString(), dadosExames, dadosMaterial, dadosConvenios, false, true, true, null, null, convenioCotaExameBeanAux.getMet_codigo_orginal());
            valorAdicional = valorAdicional.add(dadosExames.getValorExame().multiply(new BigDecimal(convenioCotaExameBeanAux.getCct_quantidade())));
            convenioCotaExameBeanAux.setAcordada(convenioCotaExameBeanAux.getCct_quantidade());
            convenioCotaExameBeanAux.setDiferenca(convenioCotaExameBeanAux.getCct_quantidade());
            convenioCotaExameBeanAux.setCct_quantidade(0);
            examCotaMsg.add(convenioCotaExameBeanAux);
        }
        dadosTotalGeral.reprocessaAdicional(valorAdicional);
        StringBuilder msg = new StringBuilder("");
        if (!examCotaMsg.isEmpty()) {
            msg.append("O valor adicional refere-se aos exames que n\u00e3o atingiram a cota m\u00ednima contratada:");
            boolean i = false;
            for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : examCotaMsg) {
                msg.append("\n");
                msg.append("Exame: \"" + convenioCotaExameBeanAux.getExa_codigo());
                msg.append("\", material: \"").append(convenioCotaExameBeanAux.getDescricaoMaterial()).append("\"");
                msg.append(" -> cota contratada ").append(convenioCotaExameBeanAux.getAcordada()).append(", ");
                msg.append("cota atingida ").append(convenioCotaExameBeanAux.getCct_quantidade()).append(", ");
                msg.append("diferen\u00e7a ").append(convenioCotaExameBeanAux.getDiferenca()).append(".");
            }
            dadosTotalGeral.setMensagem(!Funcoes.textoVazio(dadosTotalGeral.getMensagem().trim()) ? " " + msg.toString() : msg.toString());
        } else {
            dadosTotalGeral.setMensagem("");
        }
    }

    public static String pegaConvenios(JTable tabela, String campoFilial, String campoConvenio) {
        int i;
        ArrayList<String> convenios = new ArrayList<String>();
        StringBuilder bui = new StringBuilder();
        for (i = 0; i < tabela.getRowCount(); ++i) {
            if (!(tabela.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
            DadosFaturamento dados = (DadosFaturamento)tabela.getValueAt(i, 0);
            bui.delete(0, bui.length());
            bui.append("(");
            bui.append(campoFilial);
            bui.append(" = ");
            bui.append(dados.getCodigoFilial());
            bui.append(" and ");
            bui.append(campoConvenio);
            bui.append(" = ");
            bui.append(dados.getCodigoConvenio());
            bui.append(")");
            if (convenios.indexOf(bui.toString()) >= 0) continue;
            convenios.add(bui.toString());
        }
        bui.delete(0, bui.length());
        bui.append("(");
        for (i = 0; i < convenios.size(); ++i) {
            bui.append((String)convenios.get(i));
            if (i >= convenios.size() - 1) continue;
            bui.append(" or ");
        }
        bui.append(")");
        return bui.toString();
    }
}

