/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.TabelaANS;
import jalis.comum.TelaLocalizar;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.DadosMaterialUtilizado;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosMaterialFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.Calculos;
import jalis.laboratorio.util.faturamento.ConvenioCotaExameBeanAux;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.faturamento.LinhasRemovidasListener;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.laboratorio.util.faturamento.SelecaoListener;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FabricaFaturaEletronica;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.enums.EnumTipoRateio;
import jalis.model.utils.ThreadDaoException;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.exame.ExameService;
import jalis.service.financeiro.FaturaExamesService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BuscaRequisicoes
extends Thread
implements LinhasRemovidasListener {
    private final EventListenerList listenerList = new EventListenerList();
    private JPanel panelProgresso = null;
    private JPanel panelMensagens = null;
    private JPanel panel = null;
    private JButton button = null;
    private Frame owner = null;
    private JTable tabela = null;
    private JScrollPane scroll = null;
    private LinhasTabela modeloTabela = null;
    private JProgressBar progresso = null;
    private int linha = 5;
    private int casasDecimais = ParametrosGerais.getCasasPrecoExame();
    private String[] filtroColeta = null;
    private String[] filtroDestino = null;
    private String[] filtroEstacao = null;
    private String[] filtroConvenio = null;
    private String[] filtroSetor = null;
    private String[] filtroGrupo = null;
    private String[] filtroMedicoConselho = null;
    private String[] filtroMedicoCrm = null;
    private String[] filtroMedicoUF = null;
    private String[] filtroSituacao = null;
    private String[] filtroSituacaoExames = null;
    private String[] filtroPaciente = null;
    private String[] filtroExame = null;
    private String[] filtroUnidadeSaude = null;
    private String[] filtroEmpresa = null;
    private String dataInicio = null;
    private String dataFim = null;
    private String horaInicio = null;
    private String horaFim = null;
    private boolean apenasConferidas = false;
    private boolean isVerificarConferidos = false;
    private boolean isExibirNaoFaturar = false;
    private RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
    private boolean apenasComResultado = false;
    private String textoFiltroConvenio = "";
    private boolean showCheckBox = false;
    private Map<String, DadosExames> listaExames;
    private Map<String, DadosConvenios> listaConvenios;
    private Map<String, DadosMaterial> listaMateriais;
    private PreparedStatement psAgrupSemLigacao = null;
    private PreparedStatement psAgrup = null;
    private PreparedStatement psAgrupIgConv = null;
    private PreparedStatement psAgrupIgMat = null;
    private PreparedStatement psAgrupIgConvMat = null;
    private PreparedStatement psMatCol = null;
    private PreparedStatement psMatColPadrao = null;
    private ExameService exameService = new ExameService();
    private ConvenioService convenioService = new ConvenioService();

    public BuscaRequisicoes(Frame owner, JPanel panel, JButton button, boolean showCheckBox, boolean isVerificarConferidos, boolean isExibirNaoFaturar) {
        super("Thread - consulta faturamento");
        this.setPriority(5);
        this.panel = panel;
        this.button = button;
        this.owner = owner;
        this.showCheckBox = showCheckBox;
        this.isVerificarConferidos = isVerificarConferidos;
        this.isExibirNaoFaturar = isExibirNaoFaturar;
        this.panel.setLayout(new GridBagLayout());
        this.panelMensagens = new JPanel(new GridLayout(0, 1));
        this.panelProgresso = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panel.add((Component)this.panelProgresso, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panel.add((Component)this.panelMensagens, c);
        this.inicializaPreparedStatements();
    }

    private void inicializaPreparedStatements() {
        StringBuilder aux = new StringBuilder();
        aux.append(" select a.exa_codfilho as exa_codigo ");
        aux.append("       ,a.mco_codfilho as mco_codigo ");
        aux.append("       ,NULLIF(TRIM(a.exg_guia), '') as exr_guia");
        aux.append("       ,a.exg_validadeguia ");
        aux.append("       ,a.exg_dataguia ");
        aux.append("       ,a.fil_codigo ");
        aux.append("       ,a.exg_deveguia ");
        aux.append("       ,emc.met_codigo as codigoMetodo ");
        aux.append("       ,emc.emc_pagina ");
        aux.append("       ,emc.emc_ordem ");
        aux.append("       ,ese.set_codigo ");
        aux.append("   from examerequisicaoguiaagrupada a ");
        aux.append("   join examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codfilho = emc.exa_codigo and a.mco_codfilho = emc.mco_codigo ");
        aux.append("   left join examesetor ese on emc.fil_codigo = ese.fil_codigo and emc.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
        aux.append("  where a.fil_codigo = ? ");
        aux.append("    and a.req_codigo = ? ");
        aux.append("    and a.exa_codigo = ? ");
        aux.append("    and a.mco_codigo = ? ");
        this.psAgrupSemLigacao = Conexao.getPreparedStatement(aux.toString());
        aux.setLength(0);
        aux.append(" select a.exa_kodigo as exa_codigo ");
        aux.append("       ,a.mco_kodigo as mco_codigo ");
        aux.append("       ,NULLIF(TRIM(exg.exg_guia), '') as exr_guia");
        aux.append("       ,exg.exg_validadeguia ");
        aux.append("       ,exg.exg_dataguia ");
        aux.append("       ,a.fil_codigo ");
        aux.append("       ,emc.met_codigo as codigoMetodo ");
        aux.append("       ,emc.emc_pagina ");
        aux.append("       ,emc.emc_ordem ");
        aux.append("       ,ese.set_codigo ");
        aux.append("   from exameagrupaexameconvenio \t\ta ");
        aux.append("   left join examerequisicaoguiaagrupada exg on a.fil_codigo = exg.fil_codigo and a.exa_kodigo = exg.exa_codfilho and exg.req_codigo = ? ");
        aux.append("   join examematcoleta emc on exg.fil_codigo = emc.fil_codigo and exg.exa_codfilho = emc.exa_codigo and exg.mco_codfilho = emc.mco_codigo ");
        aux.append("   left join examesetor ese on emc.fil_codigo = ese.fil_codigo and emc.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
        aux.append("  where a.fil_codigo = ? ");
        aux.append("    and a.exa_codigo = ? ");
        aux.append("    and a.mco_codigo = ? ");
        aux.append("    and a.aec_tipo   = ? ");
        aux.append("    and a.con_codigo = ? ");
        this.psAgrup = Conexao.getPreparedStatement(aux.toString());
        aux.setLength(0);
        aux.append(" select distinct eae.exa_kodigo \tas exa_codigo ");
        aux.append("       ,eae.mco_kodigo \tas mco_codigo ");
        aux.append("       ,NULLIF(TRIM(exg.exg_guia), '') as exr_guia ");
        aux.append("       ,exg.exg_validadeguia ");
        aux.append("       ,exg.exg_dataguia ");
        aux.append("       ,a.fil_codigo ");
        aux.append("       ,emc.met_codigo as codigoMetodo ");
        aux.append("       ,emc.emc_pagina ");
        aux.append("       ,emc.emc_ordem ");
        aux.append("       ,ese.set_codigo ");
        aux.append("   from agrupaexameconvenio a ");
        aux.append("   left join exameagrupaexameconvenio \t eae on a.fil_codigo = eae.fil_codigo and a.exa_codigo = eae.exa_codigo and a.mco_codigo = eae.mco_codigo and eae.aec_tipo = '").append("F").append("' and a.con_codigo = eae.con_codigo ");
        aux.append("   left join examerequisicaoguiaagrupada exg on a.fil_codigo = exg.fil_codigo and eae.exa_kodigo = exg.exa_codfilho and exg.req_codigo = ? ");
        aux.append("   join examematcoleta emc on exg.fil_codigo = emc.fil_codigo and exg.exa_codfilho = emc.exa_codigo and exg.mco_codfilho = emc.mco_codigo ");
        aux.append("   left join examesetor ese on emc.fil_codigo = ese.fil_codigo and emc.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
        aux.append("  where a.fil_codigo = ? ");
        aux.append("    and a.exa_codigo = ? ");
        aux.append("    and a.mco_codigo = ? ");
        aux.append("    and a.aec_tipo   = ? ");
        aux.append("    and a.aec_ignorarconvenio = true ");
        this.psAgrupIgConv = Conexao.getPreparedStatement(aux.toString());
        aux.setLength(0);
        aux.append(" select distinct eae.exa_kodigo as exa_codigo ");
        aux.append("       ,NULLIF(TRIM(exg.exg_guia), '') as exr_guia ");
        aux.append("       ,exg.exg_validadeguia ");
        aux.append("       ,exg.exg_dataguia ");
        aux.append("       ,a.fil_codigo ");
        aux.append("       ,emc.met_codigo as codigoMetodo ");
        aux.append("       ,emc.emc_pagina ");
        aux.append("       ,emc.emc_ordem ");
        aux.append("       ,ese.set_codigo ");
        aux.append("   from agrupaexameconvenio \t\t\ta ");
        aux.append("   left join exameagrupaexameconvenio eae on a.fil_codigo = eae.fil_codigo and a.exa_codigo = eae.exa_codigo and a.con_codigo = eae.con_codigo and a.mco_codigo = eae.mco_codigo ");
        aux.append("   left join examerequisicaoguiaagrupada exg on a.fil_codigo = exg.fil_codigo and eae.exa_kodigo = exg.exa_codfilho and exg.req_codigo = ? ");
        aux.append("   join examematcoleta emc on exg.fil_codigo = emc.fil_codigo and exg.exa_codfilho = emc.exa_codigo and exg.mco_codfilho = emc.mco_codigo ");
        aux.append("   left join examesetor ese on emc.fil_codigo = ese.fil_codigo and emc.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
        aux.append("  where a.fil_codigo = ? ");
        aux.append("    and a.con_codigo = ? ");
        aux.append("    and a.exa_codigo = ? ");
        aux.append("    and a.aec_tipo   = ? ");
        aux.append("    and eae.aec_tipo = ? ");
        aux.append("    and a.aec_ignorarmaterial = true ");
        this.psAgrupIgMat = Conexao.getPreparedStatement(aux.toString());
        aux.setLength(0);
        aux.append(" select distinct eae.exa_kodigo as exa_codigo ");
        aux.append("       ,NULLIF(TRIM(exg.exg_guia), '') as exr_guia ");
        aux.append("       ,exg.exg_validadeguia ");
        aux.append("       ,exg.exg_dataguia ");
        aux.append("       ,a.fil_codigo ");
        aux.append("       ,emc.met_codigo as codigoMetodo ");
        aux.append("       ,emc.emc_pagina ");
        aux.append("       ,emc.emc_ordem ");
        aux.append("       ,ese.set_codigo ");
        aux.append("   from agrupaexameconvenio \t\t\ta ");
        aux.append("   left join exameagrupaexameconvenio eae on a.fil_codigo = eae.fil_codigo and a.exa_codigo = eae.exa_codigo and a.con_codigo = eae.con_codigo and a.mco_codigo = eae.mco_codigo ");
        aux.append("   left join examerequisicaoguiaagrupada exg on a.fil_codigo = exg.fil_codigo and eae.exa_kodigo = exg.exa_codfilho and exg.req_codigo = ? ");
        aux.append("   join examematcoleta emc on exg.fil_codigo = emc.fil_codigo and exg.exa_codfilho = emc.exa_codigo and exg.mco_codfilho = emc.mco_codigo ");
        aux.append("   left join examesetor ese on emc.fil_codigo = ese.fil_codigo and emc.exa_codigo = ese.exa_codigo and ese.ese_default = true ");
        aux.append("  where a.fil_codigo = ? ");
        aux.append("    and a.exa_codigo = ? ");
        aux.append("    and a.aec_tipo   = ? ");
        aux.append("    and eae.aec_tipo = ? ");
        aux.append("    and a.aec_ignorarconvenio = true ");
        aux.append("    and a.aec_ignorarmaterial = true ");
        this.psAgrupIgConvMat = Conexao.getPreparedStatement(aux.toString());
        aux.setLength(0);
        aux.append(" select a.mco_codigo ");
        aux.append("   from examematcoleta a ");
        aux.append("  where a.fil_codigo = ? ");
        aux.append("    and a.exa_codigo = ? ");
        aux.append("    and a.mco_codigo = ? ");
        this.psMatCol = Conexao.getPreparedStatement(aux.toString());
        aux.setLength(0);
        aux.append(" select a.mco_codigo ");
        aux.append("   from examematcoleta a ");
        aux.append("  where a.fil_codigo = ? ");
        aux.append("    and a.exa_codigo = ? ");
        aux.append("    and a.emc_default = true ");
        this.psMatColPadrao = Conexao.getPreparedStatement(aux.toString());
    }

    public BuscaRequisicoes() {
        this.inicializaPreparedStatements();
    }

    public void setFiltroExame(String[] filtroExame) {
        this.filtroExame = filtroExame;
    }

    public void setFiltroUnidadeSaude(String[] filtroUnidadeSaude) {
        this.filtroUnidadeSaude = filtroUnidadeSaude;
    }

    public String[] getFiltroEmpresa() {
        return this.filtroEmpresa;
    }

    public void setFiltroEmpresa(String[] filtroEmpresa) {
        this.filtroEmpresa = filtroEmpresa;
    }

    public void setApenasComResultado(boolean apenasComResultado) {
        this.apenasComResultado = apenasComResultado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        Statement stTemp;
        Statement st;
        block27: {
            this.listaExames = new HashMap<String, DadosExames>();
            this.listaConvenios = new HashMap<String, DadosConvenios>();
            this.listaMateriais = new HashMap<String, DadosMaterial>();
            this.progresso = new JProgressBar(0, 100);
            this.progresso.setMinimumSize(new Dimension(300, 20));
            this.progresso.setPreferredSize(new Dimension(300, 20));
            this.progresso.setStringPainted(true);
            this.panelProgresso.add(this.progresso);
            this.panelProgresso.revalidate();
            this.progresso.setString("Analisando filtros...");
            int contador = 0;
            st = Conexao.getStatement();
            stTemp = Conexao.getStatement();
            this.fireIniciouExecucao();
            try {
                this.casasDecimais = ParametrosGerais.getCasasPrecoExame();
                this.arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
                Arrays.sort(this.filtroConvenio);
                DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(this.filtroConvenio[0]));
                if (!Funcoes.objectIsNull(dadosConvenio) && dadosConvenio.getConvenioUtilizarCasasDecimais()) {
                    this.casasDecimais = dadosConvenio.getConvenioCasasPrecoExame();
                    this.arredondamentoPreco = dadosConvenio.getConvenioTipoArredondamentoPrecoRoundingMode();
                }
                this.progresso.setString("Selecionando requisi\u00e7\u00f5es...");
                String sql = this.sqlRequisicoes(st, null, null, null, null, null, false, this.isExibirNaoFaturar);
                ResultSet rs = Conexao.executeQuery(st, sql);
                StringBuilder buf = new StringBuilder();
                if (rs.next()) {
                    this.progresso.setString("Validando exames...");
                    this.tabela = new JTable(){

                        @Override
                        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                            return 10;
                        }
                    };
                    this.modeloTabela = new LinhasTabela();
                    this.tabela.setModel(this.modeloTabela);
                    this.scroll = new JScrollPane(this.tabela);
                    this.tabela.setSelectionMode(0);
                    this.tabela.setDefaultRenderer(Object.class, new EditorDadosFaturamento(this.tabela, this.showCheckBox, rs.getString("ordemFatura"), this.isVerificarConferidos));
                    this.tabela.setDefaultEditor(Object.class, new EditorDadosFaturamento(this.tabela, this.showCheckBox, rs.getString("ordemFatura"), this.isVerificarConferidos));
                    this.tabela.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (BuscaRequisicoes.this.tabela.getSelectedRow() >= 0) {
                                EditorDadosFaturamento editor = (EditorDadosFaturamento)BuscaRequisicoes.this.tabela.getCellEditor(BuscaRequisicoes.this.tabela.getSelectedRow(), 0);
                                if (e.getKeyCode() == 32) {
                                    JCheckBox check = editor.getCheckBoxRequisicao();
                                    if (check != null) {
                                        check.doClick();
                                    }
                                } else if (e.getKeyCode() == 37) {
                                    editor.recolher();
                                    FuncoesGerais.repaintTabela(BuscaRequisicoes.this.panel, BuscaRequisicoes.this.tabela.getSelectedRow());
                                } else if (e.getKeyCode() == 39) {
                                    editor.expandir();
                                    FuncoesGerais.repaintTabela(BuscaRequisicoes.this.panel, BuscaRequisicoes.this.tabela.getSelectedRow());
                                }
                            }
                        }
                    });
                    this.tabela.setShowGrid(false);
                    buf.delete(0, buf.length());
                    buf.append("<html>Ctrl + I - informa\u00e7\u00f5es da requisi\u00e7\u00e3o<br>");
                    buf.append("F2 - localizar requisi\u00e7\u00e3o</html>");
                    this.tabela.setToolTipText(buf.toString());
                    this.modeloTabela.addLinhasRemovidasListener(this);
                    this.tabela.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (e.getKeyCode() == 113) {
                                TelaLocalizar localizar = new TelaLocalizar(BuscaRequisicoes.this.owner);
                                localizar.adicionaCampo("Requisi\u00e7\u00e3o", "Paciente", "Matr\u00edcula", "Titular");
                                localizar.setVisible(true);
                                if (localizar.getPosicaoCampo() == 0) {
                                    Funcoes.processarFuncaoNumeroTubo(null, localizar.getCampoTexto());
                                }
                                if (localizar.isOK()) {
                                    int campo = localizar.getPosicaoCampo();
                                    int linha = -1;
                                    String buscar = campo == 0 ? Funcoes.preencheZero(localizar.getTexto(), 8) : localizar.getTexto();
                                    for (int i = 0; i < BuscaRequisicoes.this.tabela.getRowCount(); ++i) {
                                        DadosFaturamento dados;
                                        if (!(BuscaRequisicoes.this.tabela.getValueAt(i, 0) instanceof DadosFaturamento) || (dados = (DadosFaturamento)BuscaRequisicoes.this.tabela.getValueAt(i, 0)) == null) continue;
                                        if (campo == 0 && Funcoes.isNumeric(buscar) && dados.getRequisicao() == Integer.parseInt(buscar)) {
                                            linha = i;
                                            break;
                                        }
                                        if (campo == 1 && dados.getNomePaciente() != null && dados.getNomePaciente().toUpperCase().startsWith(buscar.toUpperCase())) {
                                            linha = i;
                                            break;
                                        }
                                        if (campo == 0 && dados.getMatricula() != null && dados.getMatricula().equalsIgnoreCase(buscar)) {
                                            linha = i;
                                            break;
                                        }
                                        if (campo != 0 || dados.getNomeTitular() == null || !dados.getNomeTitular().equalsIgnoreCase(buscar)) continue;
                                        linha = i;
                                        break;
                                    }
                                    if (linha > -1) {
                                        BuscaRequisicoes.this.tabela.setRowSelectionInterval(linha, linha);
                                        BuscaRequisicoes.this.tabela.scrollRectToVisible(BuscaRequisicoes.this.tabela.getCellRect(linha, 0, false));
                                    }
                                }
                            } else if (e.getKeyCode() == 73 && e.isControlDown() && BuscaRequisicoes.this.tabela.getSelectedRow() > -1 && BuscaRequisicoes.this.tabela.getValueAt(BuscaRequisicoes.this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento && BuscaRequisicoes.this.owner instanceof Laboratorio) {
                                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)((Laboratorio)BuscaRequisicoes.this.owner).getRootPane().getGlassPane();
                                InfoRequisicao info = new InfoRequisicao(BuscaRequisicoes.this.owner, glassPaneMensagem);
                                DadosFaturamento dados = (DadosFaturamento)BuscaRequisicoes.this.tabela.getValueAt(BuscaRequisicoes.this.tabela.getSelectedRow(), 0);
                                info.setRequisicao(String.valueOf(dados.getCodigoFilial()), dados.getRequisicao());
                                info.setVisible(true);
                                ((Laboratorio)BuscaRequisicoes.this.owner).getRootPane().setGlassPane(glassPaneMensagem);
                            }
                        }
                    });
                    ((EditorDadosFaturamento)this.tabela.getDefaultEditor(Object.class)).addSelecaoListener(new SelecaoListener(){

                        @Override
                        public void selecionado() {
                            try {
                                if (BuscaRequisicoes.this.modeloTabela.getValueAt(BuscaRequisicoes.this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento) {
                                    Calculos.calculaTotalRequisicao((DadosFaturamento)BuscaRequisicoes.this.modeloTabela.getValueAt(BuscaRequisicoes.this.tabela.getSelectedRow(), 0), BuscaRequisicoes.this.casasDecimais, BuscaRequisicoes.this.arredondamentoPreco);
                                    BuscaRequisicoes.this.calculaTotal(BuscaRequisicoes.this.modeloTabela.getRowCount() - 1);
                                    BuscaRequisicoes.this.tabela.repaint();
                                }
                            }
                            catch (Exception ex) {
                                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BuscaRequisicoes");
                            }
                        }
                    });
                    this.tabela.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (BuscaRequisicoes.this.tabela.getSelectedRow() == BuscaRequisicoes.this.tabela.getRowCount() - 1) {
                                BuscaRequisicoes.this.tabela.getSelectionModel().clearSelection();
                            }
                        }
                    });
                    this.scroll.setBounds(5, 70, this.panel.getWidth() - 10, 200);
                    int requisicaoAnterior = -1;
                    int filialAnterior = -1;
                    int convenioAnterior = -1;
                    DadosFaturamento d = new DadosFaturamento();
                    d.setCasasDecimais(this.casasDecimais);
                    d.setTipoArredondamento(this.arredondamentoPreco);
                    rs.beforeFirst();
                    int contadorTotal = 0;
                    while (rs.next()) {
                        ++contadorTotal;
                    }
                    this.progresso.setMaximum(contadorTotal);
                    String rateio = "";
                    rs.beforeFirst();
                    while (rs.next()) {
                        this.progresso.setString("Validando exames - " + Math.round(++contador * 100 / contadorTotal) + "%");
                        this.progresso.setValue(contador);
                        if (filialAnterior == -1 && requisicaoAnterior == -1) {
                            filialAnterior = rs.getInt("fil_codigo");
                            requisicaoAnterior = rs.getInt("req_codigo");
                            convenioAnterior = rs.getInt("con_codigo");
                            if (!rateio.equalsIgnoreCase(rs.getString("set_tipoalimentos"))) {
                                d.setRateio(true);
                            }
                            d.setTipoRateio(rs.getString("set_tipoalimentos"));
                            rateio = d.getTipoRateio();
                            this.adicionaRequisicao(d, rs);
                            this.adicionaExame(d, rs, rs.getString("set_tipoalimentos"));
                            continue;
                        }
                        if (rs.getString("ordemFatura").equalsIgnoreCase("S") && !rateio.equalsIgnoreCase(rs.getString("set_tipoalimentos")) || filialAnterior != rs.getInt("fil_codigo") || requisicaoAnterior != rs.getInt("req_codigo") || convenioAnterior != rs.getInt("con_codigo")) {
                            requisicaoAnterior = rs.getInt("req_codigo");
                            filialAnterior = rs.getInt("fil_codigo");
                            convenioAnterior = rs.getInt("con_codigo");
                            if (d.getExamesCount() > 0) {
                                Calculos.calculaTotalRequisicao(d, this.casasDecimais, this.arredondamentoPreco);
                                this.modeloTabela.adicionaLinha(d);
                            }
                            d = new DadosFaturamento();
                            if (!rateio.equalsIgnoreCase(rs.getString("set_tipoalimentos"))) {
                                d.setRateio(true);
                            }
                            d.setTipoRateio(rs.getString("set_tipoalimentos"));
                            d.setCasasDecimais(this.casasDecimais);
                            d.setTipoArredondamento(this.arredondamentoPreco);
                            rateio = d.getTipoRateio();
                            this.adicionaRequisicao(d, rs);
                            this.adicionaExame(d, rs, rs.getString("set_tipoalimentos"));
                            continue;
                        }
                        if (filialAnterior != rs.getInt("fil_codigo") || requisicaoAnterior != rs.getInt("req_codigo") || convenioAnterior != rs.getInt("con_codigo")) continue;
                        this.adicionaExame(d, rs, rs.getString("set_tipoalimentos"));
                    }
                    if (d.getExamesCount() > 0) {
                        Calculos.calculaTotalRequisicao(d, this.casasDecimais, this.arredondamentoPreco);
                        this.modeloTabela.adicionaLinha(d);
                    }
                    if (this.modeloTabela.getRowCount() > 0) {
                        for (int i = 0; i < this.modeloTabela.getRowCount(); ++i) {
                            if (!(this.modeloTabela.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
                            DadosFaturamento requisicao = (DadosFaturamento)this.modeloTabela.getValueAt(i, 0);
                            ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
                            Collections.sort(exames);
                            boolean faturar = false;
                            for (int j = 0; j < exames.size(); ++j) {
                                if (!exames.get(j).getFaturar()) continue;
                                faturar = true;
                                break;
                            }
                            requisicao.setFaturar(faturar);
                        }
                        DadosTotalGeral total = new DadosTotalGeral();
                        this.modeloTabela.adicionaLinha(total);
                        this.tabela.getSelectionModel().removeIndexInterval(this.modeloTabela.getRowCount() - 1, this.modeloTabela.getRowCount() - 1);
                        int linhaTotal = this.modeloTabela.getRowCount() - 1;
                        this.calculaTotal(linhaTotal);
                        this.panel.removeAll();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BuscaRequisicoes.this.panel.setLayout(new BorderLayout());
                                BuscaRequisicoes.this.panel.add((Component)BuscaRequisicoes.this.scroll, "Center");
                                BuscaRequisicoes.this.panel.revalidate();
                            }
                        });
                        this.tabela.requestFocus();
                    } else {
                        this.panelProgresso.removeAll();
                        this.panelProgresso.add(new JLabel("N\u00e3o h\u00e1 requisi\u00e7\u00f5es no per\u00edodo selecionado"));
                        this.panelProgresso.revalidate();
                        this.panelProgresso.repaint();
                    }
                    break block27;
                }
                this.panelProgresso.removeAll();
                this.panelProgresso.add(new JLabel("N\u00e3o h\u00e1 requisi\u00e7\u00f5es no per\u00edodo selecionado"));
                this.panelProgresso.revalidate();
                this.panelProgresso.repaint();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BuscaRequisicoes (299)");
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(stTemp);
                this.button.setEnabled(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuscaRequisicoes.this.fireTerminouExecucao();
                    }
                });
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace());
                {
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        Conexao.fecharStatement(stTemp);
                        this.button.setEnabled(true);
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(stTemp);
                this.button.setEnabled(true);
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(stTemp);
        this.button.setEnabled(true);
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        if (this.modeloTabela != null) {
            block28: {
                String xml;
                block29: {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select con_faturaeletronica ");
                    buf.append("   from convenios ");
                    buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("    and con_codigo = ").append(this.filtroConvenio[0]);
                    st = Conexao.getStatement();
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block28;
                    xml = rs.getString("con_faturaeletronica");
                    if (xml != null && !Funcoes.textoVazio(xml)) break block29;
                    Conexao.fecharStatement(st);
                    System.gc();
                    return;
                }
                try {
                    String protocolo = StringUtil.getValor(xml, "protocolo");
                    FaturamentoEletronico fat = FabricaFaturaEletronica.novoFaturamentoEletronico(protocolo);
                    Registro reg = ((AbstractFaturamentoEletronico)((Object)fat)).parseXMLConfiguracao(xml);
                    ArrayList<DadosFaturamento> requisicoes = new ArrayList<DadosFaturamento>();
                    for (int i = 0; i < this.modeloTabela.getRowCount(); ++i) {
                        if (!(this.modeloTabela.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
                        requisicoes.add((DadosFaturamento)this.modeloTabela.getValueAt(i, 1));
                    }
                    ((AbstractFaturamentoEletronico)((Object)fat)).verificaErrosFatura(requisicoes, reg);
                    this.calculaTotal(this.modeloTabela.getRowCount() - 1);
                    this.tabela.repaint();
                }
                catch (Exception ex) {
                    try {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar configura\u00e7\u00e3o de eletr\u00f4nico do conv\u00eanio.\n" + ex.getMessage(), ex.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        System.gc();
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    System.gc();
                }
            }
            Conexao.fecharStatement(st);
            System.gc();
        }
    }

    private void calculaCotaExame(int linhaTotal) {
        try {
            ArrayList<ConvenioCotaExameBeanAux> convenioCotaExameBeanAuxs = new ArrayList<ConvenioCotaExameBeanAux>();
            BigDecimal valorAdicional = BigDecimal.ZERO;
            valorAdicional.setScale(this.casasDecimais, this.arredondamentoPreco);
            DadosTotalGeral dadosTotalGeral = (DadosTotalGeral)this.modeloTabela.getValueAt(linhaTotal, 0);
            ArrayList<ConvenioCotaExameBeanAux> examCotaMsg = new ArrayList<ConvenioCotaExameBeanAux>();
            Integer codigoRequisicaoAnterior = -1;
            for (int i = 0; i < this.modeloTabela.getRowCount(); ++i) {
                Set situacoesAcordado;
                if (!(this.modeloTabela.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
                Iterator<ConvenioCotaExameBeanAux> listaPai = new ArrayList();
                DadosFaturamento requisicao = (DadosFaturamento)this.modeloTabela.getValueAt(i, 0);
                ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
                if (codigoRequisicaoAnterior == -1) {
                    codigoRequisicaoAnterior = requisicao.getRequisicao();
                }
                if (!(situacoesAcordado = this.convenioService.loadCotaExameSituacao(" where fil_codigo = " + requisicao.getCodigoFilial() + " and con_codigo = " + requisicao.getCodigoConvenio() + " and sit_codigo = " + requisicao.getCodigoSituacao())).isEmpty()) continue;
                for (DadosExameFaturamento dadosExameFaturamento : exames) {
                    if (!dadosExameFaturamento.getFaturar()) continue;
                    ConvenioCotaExameBeanAux cotaExameBeanAux = new ConvenioCotaExameBeanAux();
                    cotaExameBeanAux.setCon_codigo(requisicao.getCodigoConvenio());
                    cotaExameBeanAux.setExa_codigo(dadosExameFaturamento.getCodigoExame());
                    cotaExameBeanAux.setMco_codigo(dadosExameFaturamento.getCodigoMaterial());
                    cotaExameBeanAux.setDescricaoMaterial(dadosExameFaturamento.getDescricaoMaterial());
                    if (ParametrosGerais.getPrecoMetodologia() && dadosExameFaturamento.getCodigoMetodologia() != null) {
                        cotaExameBeanAux.setMet_codigo(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                    } else {
                        cotaExameBeanAux.setMet_codigo(0);
                    }
                    if (dadosExameFaturamento.getCodigoMetodologia() != null) {
                        cotaExameBeanAux.setMet_codigo_orginal(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                    } else {
                        cotaExameBeanAux.setMet_codigo_orginal(0);
                    }
                    DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(String.valueOf(requisicao.getCodigoFilial()), dadosExameFaturamento.getCodigoMaterial());
                    DadosExames dadosExames = ExameUtil.getDadosExame(String.valueOf(requisicao.getCodigoFilial()), dadosExameFaturamento.getCodigoExame(), dadosMaterial);
                    DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(String.valueOf(requisicao.getCodigoFilial()), requisicao.getCodigoConvenio());
                    ExameUtil.calculaPrecoExame(String.valueOf(requisicao.getCodigoFilial()), dadosExames, dadosMaterial, dadosConvenios, false, true, true, null, null, Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                    cotaExameBeanAux.setValorTotalExame(dadosExames.getValorExame());
                    if (!convenioCotaExameBeanAuxs.contains(cotaExameBeanAux)) {
                        cotaExameBeanAux.somaQuantidadeExame();
                        convenioCotaExameBeanAuxs.add(cotaExameBeanAux);
                    } else {
                        int posicao = convenioCotaExameBeanAuxs.indexOf(cotaExameBeanAux);
                        ((ConvenioCotaExameBeanAux)convenioCotaExameBeanAuxs.get(posicao)).somaQuantidadeExame();
                    }
                    if (codigoRequisicaoAnterior.intValue() == requisicao.getRequisicao()) continue;
                    codigoRequisicaoAnterior = requisicao.getRequisicao();
                }
            }
            List<ConvenioCotaExameBeanAux> acordados = this.exameService.getAcordados(this.filtroConvenio[0]);
            for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : convenioCotaExameBeanAuxs) {
                List<ConvenioCotaExameBeanAux> exameCota = this.exameService.obterCotaExame(convenioCotaExameBeanAux);
                Integer qtdRealizada = convenioCotaExameBeanAux.getCct_quantidade();
                for (ConvenioCotaExameBeanAux map : exameCota) {
                    Integer qtdAcordada = map.getCct_quantidade();
                    Integer diferenca = qtdAcordada - qtdRealizada;
                    if (diferenca > 0) {
                        valorAdicional = valorAdicional.add(convenioCotaExameBeanAux.getValorTotalExame().multiply(new BigDecimal(diferenca)));
                        convenioCotaExameBeanAux.setAcordada(qtdAcordada);
                        convenioCotaExameBeanAux.setDiferenca(diferenca);
                        examCotaMsg.add(convenioCotaExameBeanAux);
                    }
                    acordados.remove(map);
                }
            }
            for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : acordados) {
                DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getMco_codigo());
                convenioCotaExameBeanAux.setDescricaoMaterial(dadosMaterial.getDescricao());
                DadosExames dadosExames = ExameUtil.getDadosExame(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getExa_codigo(), dadosMaterial);
                DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getCon_codigo());
                ExameUtil.calculaPrecoExame(convenioCotaExameBeanAux.getFil_codigo().toString(), dadosExames, dadosMaterial, dadosConvenios, false, true, true, null, null, convenioCotaExameBeanAux.getMet_codigo_orginal());
                valorAdicional = valorAdicional.add(dadosExames.getValorExame().multiply(new BigDecimal(convenioCotaExameBeanAux.getCct_quantidade())));
                convenioCotaExameBeanAux.setAcordada(convenioCotaExameBeanAux.getCct_quantidade());
                convenioCotaExameBeanAux.setDiferenca(convenioCotaExameBeanAux.getCct_quantidade());
                convenioCotaExameBeanAux.setCct_quantidade(0);
                examCotaMsg.add(convenioCotaExameBeanAux);
            }
            dadosTotalGeral.reprocessaAdicional(valorAdicional);
            StringBuilder msg = new StringBuilder("");
            if (!examCotaMsg.isEmpty()) {
                msg.append("O valor adicional refere-se aos exames que n\u00e3o atingiram a cota m\u00ednima contratada:");
                boolean i = false;
                for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : examCotaMsg) {
                    msg.append("\n");
                    msg.append("Exame: \"" + convenioCotaExameBeanAux.getExa_codigo());
                    msg.append("\", material: \"").append(convenioCotaExameBeanAux.getDescricaoMaterial()).append("\"");
                    msg.append(" -> cota contratada ").append(convenioCotaExameBeanAux.getAcordada()).append(", ");
                    msg.append("cota atingida ").append(convenioCotaExameBeanAux.getCct_quantidade()).append(", ");
                    msg.append("diferen\u00e7a ").append(convenioCotaExameBeanAux.getDiferenca()).append(".");
                }
                dadosTotalGeral.setMensagem(!Funcoes.textoVazio(dadosTotalGeral.getMensagem().trim()) ? " " + msg.toString() : msg.toString());
            } else {
                dadosTotalGeral.setMensagem("");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel recalcular cotas de exames", e.getStackTrace());
        }
    }

    public ArrayList<DadosFaturamento> buscaDadosFaturamento(String sqlRequisicoes) throws SQLException {
        Object d = null;
        this.listaExames = new HashMap<String, DadosExames>();
        this.listaConvenios = new HashMap<String, DadosConvenios>();
        this.listaMateriais = new HashMap<String, DadosMaterial>();
        ArrayList<DadosFaturamento> lista = new ArrayList();
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sqlRequisicoes.toString());
        if (rs.next() && this.isOrdenaFaturaAlimentos(rs.getString("ordemFatura"))) {
            return this.buscaRequisicoesFaturamentoSetor(rs);
        }
        lista = this.buscaRequisicoesFaturamento(rs);
        Conexao.fecharStatement(st);
        return lista;
    }

    private ArrayList<DadosFaturamento> buscaRequisicoesFaturamentoSetor(ResultSet rs) throws SQLException {
        int filialAnterior = -1;
        int requisicaoAnterior = -1;
        int convenioAnterior = -1;
        DadosFaturamento d = null;
        ArrayList<DadosFaturamento> lista = new ArrayList<DadosFaturamento>();
        EnumTipoRateio[] tipoRateio = EnumTipoRateio.values();
        rs.beforeFirst();
        for (EnumTipoRateio enumTipoRateio : tipoRateio) {
            rs.beforeFirst();
            while (rs.next()) {
                if (!enumTipoRateio.getCodigo().equalsIgnoreCase(rs.getString("set_tipoalimentos"))) continue;
                if (filialAnterior == -1 && requisicaoAnterior == -1) {
                    filialAnterior = rs.getInt("fil_codigo");
                    requisicaoAnterior = rs.getInt("req_codigo");
                    convenioAnterior = rs.getInt("con_codigo");
                    d = new DadosFaturamento();
                    d.setTipoRateio(enumTipoRateio.getCodigo());
                    lista.add(d);
                    this.adicionaRequisicao(d, rs);
                    this.adicionaExame(d, rs, enumTipoRateio.getCodigo());
                    continue;
                }
                if (filialAnterior != rs.getInt("fil_codigo") || requisicaoAnterior != rs.getInt("req_codigo") || convenioAnterior != rs.getInt("con_codigo")) {
                    filialAnterior = rs.getInt("fil_codigo");
                    requisicaoAnterior = rs.getInt("req_codigo");
                    convenioAnterior = rs.getInt("con_codigo");
                    d = new DadosFaturamento();
                    lista.add(d);
                    d.setTipoRateio(enumTipoRateio.getCodigo());
                    this.adicionaRequisicao(d, rs);
                    this.adicionaExame(d, rs, enumTipoRateio.getCodigo());
                    continue;
                }
                if (filialAnterior != rs.getInt("fil_codigo") || requisicaoAnterior != rs.getInt("req_codigo") || convenioAnterior != rs.getInt("con_codigo")) continue;
                this.adicionaExame(d, rs, enumTipoRateio.getCodigo());
            }
        }
        if (lista.size() == 0) {
            return null;
        }
        return lista;
    }

    private ArrayList<DadosFaturamento> buscaRequisicoesFaturamento(ResultSet rs) throws SQLException {
        int filialAnterior = -1;
        int requisicaoAnterior = -1;
        int convenioAnterior = -1;
        DadosFaturamento d = null;
        ArrayList<DadosFaturamento> lista = new ArrayList<DadosFaturamento>();
        rs.beforeFirst();
        while (rs.next()) {
            if (filialAnterior == -1 && requisicaoAnterior == -1) {
                filialAnterior = rs.getInt("fil_codigo");
                requisicaoAnterior = rs.getInt("req_codigo");
                convenioAnterior = rs.getInt("con_codigo");
                d = new DadosFaturamento();
                lista.add(d);
                this.adicionaRequisicao(d, rs);
                this.adicionaExame(d, rs);
                continue;
            }
            if (filialAnterior != rs.getInt("fil_codigo") || requisicaoAnterior != rs.getInt("req_codigo") || convenioAnterior != rs.getInt("con_codigo")) {
                filialAnterior = rs.getInt("fil_codigo");
                requisicaoAnterior = rs.getInt("req_codigo");
                convenioAnterior = rs.getInt("con_codigo");
                d = new DadosFaturamento();
                lista.add(d);
                this.adicionaRequisicao(d, rs);
                this.adicionaExame(d, rs);
                continue;
            }
            if (filialAnterior != rs.getInt("fil_codigo") || requisicaoAnterior != rs.getInt("req_codigo") || convenioAnterior != rs.getInt("con_codigo")) continue;
            this.adicionaExame(d, rs);
        }
        if (lista.size() == 0) {
            return null;
        }
        return lista;
    }

    private void calculaTotal(int linhaTotal) throws SQLException {
        if (linhaTotal > this.modeloTabela.getRowCount() || !(this.modeloTabela.getValueAt(linhaTotal, 0) instanceof DadosTotalGeral)) {
            return;
        }
        StringBuilder buf = new StringBuilder("");
        DadosTotalGeral total = (DadosTotalGeral)this.modeloTabela.getValueAt(linhaTotal, 0);
        total.setCasasDecimais(this.casasDecimais);
        total.setTipoArredondamento(this.arredondamentoPreco);
        Statement st = Conexao.getStatement();
        int qtdeExames = 0;
        int qtdeRequisicao = 0;
        int qtdeGuias = 0;
        Integer qMicrobiologia = 0;
        Integer qFisicoQuimico = 0;
        Integer qOutros = 0;
        Integer qCromatografia = 0;
        BigDecimal totalExamesCH = new BigDecimal(0);
        BigDecimal totalGeral = new BigDecimal(0);
        BigDecimal totalExames = new BigDecimal(0);
        BigDecimal totalMateriais = new BigDecimal(0);
        BigDecimal adicional = new BigDecimal(0);
        BigDecimal cobranca = new BigDecimal(0);
        BigDecimal totalMicrobiologia = new BigDecimal(0);
        BigDecimal totalFisicoQuimico = new BigDecimal(0);
        BigDecimal totalOutros = new BigDecimal(0);
        BigDecimal totalCromatografia = new BigDecimal(0);
        Integer codigoConvenio = null;
        Integer codigoFilial = null;
        ArrayList<String> listaGuia = new ArrayList<String>();
        for (int i = 0; i < this.modeloTabela.getRowCount(); ++i) {
            if (!(this.modeloTabela.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
            DadosFaturamento fatura = (DadosFaturamento)this.modeloTabela.getValueAt(i, 0);
            codigoFilial = fatura.getCodigoFilial();
            BigDecimal tempTotalExamesCH = new BigDecimal(0);
            BigDecimal tempTotalExames = new BigDecimal(0);
            BigDecimal tempTotalMateriais = new BigDecimal(0);
            codigoConvenio = fatura.getCodigoConvenio();
            if (fatura.getFaturar()) {
                if (!Funcoes.textoVazio(fatura.getGuia()) && listaGuia.indexOf(fatura.getGuia()) < 0) {
                    listaGuia.add(fatura.getGuia());
                }
                ++qtdeRequisicao;
                for (int j = 0; j < fatura.getExamesCount(); ++j) {
                    Integer n;
                    Integer n2;
                    DadosExameFaturamento exameFatura = fatura.getExame(j);
                    if (!exameFatura.getFaturar()) continue;
                    ++qtdeExames;
                    if (exameFatura.getCodigoGuia() != null && listaGuia.indexOf(exameFatura.getCodigoGuia()) < 0) {
                        listaGuia.add(exameFatura.getCodigoGuia());
                    }
                    tempTotalExamesCH = tempTotalExamesCH.add(exameFatura.getValorCHExame().setScale(this.casasDecimais, this.arredondamentoPreco));
                    tempTotalExames = tempTotalExames.add(exameFatura.getValorTotalExame().setScale(this.casasDecimais, this.arredondamentoPreco));
                    tempTotalMateriais = tempTotalMateriais.add(exameFatura.getValorMaterial().setScale(this.casasDecimais, this.arredondamentoPreco));
                    if (!this.isOrdenaFaturaAlimentos(fatura.getOrdemFatura())) continue;
                    if (EnumTipoRateio.isMicrobiologico(exameFatura.getTipoAlimentos())) {
                        totalMicrobiologia = totalMicrobiologia.add(exameFatura.getValorExame());
                        n2 = qMicrobiologia;
                        n = qMicrobiologia = Integer.valueOf(qMicrobiologia + 1);
                    }
                    if (EnumTipoRateio.isFisicoQuimico(exameFatura.getTipoAlimentos())) {
                        totalFisicoQuimico = totalFisicoQuimico.add(exameFatura.getValorExame());
                        n2 = qFisicoQuimico;
                        n = qFisicoQuimico = Integer.valueOf(qFisicoQuimico + 1);
                    }
                    if (EnumTipoRateio.isOutros(exameFatura.getTipoAlimentos())) {
                        totalOutros = totalOutros.add(exameFatura.getValorExame());
                        n2 = qOutros;
                        n = qOutros = Integer.valueOf(qOutros + 1);
                    }
                    if (!EnumTipoRateio.isCromatografia(exameFatura.getTipoAlimentos())) continue;
                    totalCromatografia = totalCromatografia.add(exameFatura.getValorExame());
                    n2 = qCromatografia;
                    n = qCromatografia = Integer.valueOf(qCromatografia + 1);
                }
            }
            totalExames = totalExames.add(tempTotalExames.setScale(this.casasDecimais, this.arredondamentoPreco));
            totalExamesCH = totalExamesCH.add(tempTotalExamesCH.setScale(this.casasDecimais, this.arredondamentoPreco));
            totalMateriais = totalMateriais.add(tempTotalMateriais.setScale(this.casasDecimais, this.arredondamentoPreco));
        }
        qtdeGuias = listaGuia.size();
        totalGeral = totalGeral.add(totalExames.add(totalMateriais).setScale(2, this.arredondamentoPreco));
        total.setQtdeGuias(qtdeGuias);
        total.setQtdeFiscoQuimico(qFisicoQuimico);
        total.setQtdeMicrobiologia(qMicrobiologia);
        total.setQtdeOutros(qOutros);
        total.setQtdeCromatografia(qCromatografia);
        total.setTotalFisicoQuimico(totalFisicoQuimico);
        total.setTotalMicrobiologia(totalMicrobiologia);
        total.setTotalOutros(totalOutros);
        total.setTotalCromatografia(totalCromatografia);
        total.setQtdeRequisicoes(qtdeRequisicao);
        total.setQtdeExames(qtdeExames);
        total.setTotalExamesCH(totalExamesCH.setScale(2, this.arredondamentoPreco));
        total.setTotalMateriais(totalMateriais.setScale(2, this.arredondamentoPreco));
        total.setTotalExames(totalExames.setScale(2, this.arredondamentoPreco));
        total.setCodigoConvenio(codigoConvenio);
        buf.delete(0, buf.length());
        buf.append("select coalesce(sum(dco_vlrcobranca), 0) as somacobranca from despcobranca ");
        buf.append(" where ");
        buf.append(this.textoFiltroConvenio.replaceAll("con.fil_codigo", "fil_codigo").replaceAll("con.con_codigo", "con_codigo"));
        buf.append(" and dco_vlrmin <= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and dco_vlrmax >= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and dco_ispercentual = false");
        buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            cobranca = rs.getBigDecimal("somacobranca").compareTo(BigDecimal.ZERO) > 0 ? rs.getBigDecimal("somacobranca") : total.getCobranca();
            total.setCobranca(cobranca);
        }
        buf.delete(0, buf.length());
        buf.append("select coalesce(avg(dco_vlrcobranca), 0) as mediacobranca from despcobranca ");
        buf.append(" where ");
        buf.append(this.textoFiltroConvenio.replaceAll("con.fil_codigo", "fil_codigo").replaceAll("con.con_codigo", "con_codigo"));
        buf.append(" and dco_vlrmin <= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and dco_vlrmax >= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and dco_ispercentual = true ");
        buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next() && rs.getBigDecimal("mediacobranca").compareTo(BigDecimal.ZERO) > 0) {
            cobranca = totalGeral.multiply(rs.getBigDecimal("mediacobranca")).divide(new BigDecimal(100), this.arredondamentoPreco);
            total.setCobranca(total.getCobranca().add(cobranca));
        }
        buf.delete(0, buf.length());
        buf.append("select coalesce(sum(adc_vlradicional), 0) as somaadicional from adicionalfatura ");
        buf.append(" where ");
        buf.append(this.textoFiltroConvenio.replaceAll("con.fil_codigo", "fil_codigo").replaceAll("con.con_codigo", "con_codigo"));
        buf.append(" and adc_vlrinicial <= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and adc_vlrfim >= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and adc_ispercentual = false");
        buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            adicional = rs.getBigDecimal("somaadicional").compareTo(BigDecimal.ZERO) > 0 ? rs.getBigDecimal("somaadicional") : total.getAdicional();
            total.setAdicional(adicional);
        }
        buf.delete(0, buf.length());
        buf.append("select coalesce(avg(adc_vlradicional), 0) as mediaadicional from adicionalfatura ");
        buf.append(" where ");
        buf.append(this.textoFiltroConvenio.replaceAll("con.fil_codigo", "fil_codigo").replaceAll("con.con_codigo", "con_codigo"));
        buf.append(" and adc_vlrinicial <= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and adc_vlrfim >= ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(totalGeral)));
        buf.append(" and adc_ispercentual = true");
        buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next() && rs.getBigDecimal("mediaadicional").compareTo(BigDecimal.ZERO) > 0) {
            adicional = totalGeral.multiply(rs.getBigDecimal("mediaadicional")).divide(new BigDecimal(100), this.arredondamentoPreco).setScale(2, this.arredondamentoPreco);
            total.setAdicional(total.getAdicional().add(adicional));
        }
        BigDecimal desconto = totalGeral.multiply(total.getPercentualBonus().divide(new BigDecimal(100))).setScale(2, this.arredondamentoPreco);
        total.setTotal(totalGeral.add(adicional).add(cobranca).subtract(desconto).setScale(2, this.arredondamentoPreco));
        rs.close();
        Conexao.fecharStatement(st);
        if (new ConvenioService().getConvenioUtilizaCotaExame(codigoFilial.toString(), codigoConvenio.toString())) {
            this.calculaCotaExame(linhaTotal);
        }
    }

    private void adicionaRequisicao(DadosFaturamento d, ResultSet rs) throws SQLException {
        int codigoDaFilial = rs.getInt("fil_codigo");
        d.setCodigoFilial(codigoDaFilial);
        d.setCnpjFilial(rs.getString("fil_cnpj"));
        d.setRazaoSocialFilial(rs.getString("fil_razaosocial"));
        d.setCid10(rs.getString("cid10"));
        d.setRequisicao(rs.getInt("req_codigo"));
        d.setFaturar(true);
        d.setRequisicaoExpandida(true);
        d.setGuiaConferida(rs.getBoolean("guiaconferida"));
        int codigoDoConvenio = rs.getInt("con_codigo");
        d.setCodigoConvenio(codigoDoConvenio);
        d.setConvenioRazao(rs.getString("con_razao"));
        d.setConvenioFantasia(rs.getString("con_fantasia"));
        d.setConvenioRepasse(rs.getBoolean("isConvenioRepasse"));
        d.setCodigoConvenioPrincipal(rs.getInt("codigoConvenioPrincipal"));
        d.setRazaoConvenioPrincipal(rs.getString("razaoConvenioPrincipal"));
        d.setFantasiaConvenioPrincipal(rs.getString("fantasiaConvenioPrincipal"));
        d.setNomeMedico(rs.getString("med_nome"));
        d.setCRMMedico(rs.getString("med_crm"));
        d.setUFMedico(rs.getString("med_uf"));
        d.setConselhoMedico(rs.getString("med_conselho"));
        String cbosDoMedico = rs.getString("med_cbo");
        if (Funcoes.textoVazio(cbosDoMedico)) {
            try {
                cbosDoMedico = this.buscaCbosDoConvenio(codigoDaFilial, codigoDoConvenio);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        d.setXmlCbo(cbosDoMedico);
        d.setValorBalcao(rs.getBigDecimal("con_percpgto"));
        d.setCodigoPaciente(rs.getInt("pac_codigo"));
        d.setNomePaciente(rs.getString("pac_nome"));
        d.setRacaCorPaciente(rs.getString("pac_cor"));
        d.setNacionalidadePaciente(rs.getString("nli_codigo"));
        d.setEtniaPaciente(rs.getString("ein_codigo"));
        d.setNacionalidadeDescricao(rs.getString("nli_descricao"));
        d.setEtniaDescricao(rs.getString("ein_descricao"));
        d.setMatricula(rs.getString("req_matricula"));
        d.setNomePlano(rs.getString("req_nomeplano"));
        d.setValidadeCarteira(rs.getDate("req_validadecarteira"));
        d.setDataRequisicao(rs.getDate("req_data"));
        d.setDataFaturaRequisicao(rs.getDate("req_dtfatura"));
        d.setHoraRequisicao(rs.getTime("req_hora"));
        d.setHoraFaturaRequisicao(rs.getTime("req_horafatura"));
        d.setCodigoColeta(rs.getString("col_codigo"));
        d.setCodigoDestino(rs.getString("des_codigo"));
        d.setCodigoSituacao(DBUtil.campoNull(rs.getString("sit_codigo")) ? -1 : rs.getInt("sit_codigo"));
        d.setDescricaoSituacao(rs.getString("sit_descricao"));
        d.setDescricaoColeta(rs.getString("col_descricao"));
        d.setDescricaoDestino(rs.getString("des_descricao"));
        d.setNomeTitular(rs.getString("req_titular"));
        d.setFaturarFaltaMaterial(rs.getBoolean("con_fatfmaterial"));
        d.setFaturarRecoleta(rs.getBoolean("con_faturarrecoleta"));
        d.setValorMulta(rs.getBigDecimal("con_multa"));
        d.setValorMora(rs.getBigDecimal("con_mora"));
        d.setValorBonus(rs.getBigDecimal("con_bonus"));
        d.setValorAcrescimo(rs.getBigDecimal("con_acrescimo"));
        d.setTipoCalculoFatura(rs.getString("con_tpcalcfatu"));
        d.setTipoCalculoCH(rs.getString("con_tpcalcch"));
        d.setCobrarMaterial(rs.getBoolean("con_cobrmaterial"));
        d.setValorCHConvenio(rs.getBigDecimal("con_valorch"));
        d.setOrdemFatura(rs.getString("con_ordemfatura"));
        d.setTitularDependente(rs.getString("con_titdep"));
        d.setFaturarFiliais(rs.getBoolean("con_fatfiliais"));
        d.setDeveGuia(rs.getBoolean("req_deveguia"));
        d.setCodigoAla(rs.getString("ala_codigo"));
        d.setDescricaoAla(rs.getString("ala_descricao"));
        d.setQuarto(rs.getString("req_quarto"));
        d.setLeito(rs.getString("req_leito"));
        d.setPercentualBalcaoMaterial(rs.getBigDecimal("con_percpgtomaterial"));
        d.setTabelaTipoCBHPM(rs.getBoolean("tpe_tipocbhpm"));
        d.setValorUCO(rs.getBigDecimal("tpe_uco"));
        d.setAgruparAmb(rs.getBoolean("con_agrupaambguia"));
        d.setCodigoTabelaPreco(rs.getInt("tpe_codigoconvenio"));
        d.setTipoTabela(TabelaANS.TiposTabela.getTipo(rs.getString("tpe_tabelaans") == null ? "" : rs.getString("tpe_tabelaans")));
        d.setEnderecoPaciente(rs.getString("pac_endereco"));
        d.setLogradouroPaciente(rs.getString("pac_tipologradouroendereco"));
        d.setCepPaciente(rs.getString("pac_cep"));
        d.setBairroPaciente(rs.getString("bai_codigo"));
        d.setBairroPacienteDescricao(rs.getString("bai_descricao"));
        d.setCidadePaciente(rs.getString("cid_codigo"));
        d.setCidadePacienteNome(rs.getString("cid_nome"));
        d.setCodigoCNES(rs.getString("fil_cnes"));
        d.setCnsPaciente(rs.getString("req_cartaosus"));
        d.setNumeroEndereco(rs.getString("pac_numeroendereco"));
        d.setComplementoEndereco(rs.getString("pac_complemento"));
        d.setCodigoIbge(rs.getString("cid_codigoibge"));
        String nomeProtocolo = rs.getString("con_faturaeletronica");
        if (!Funcoes.textoVazio(nomeProtocolo) && (nomeProtocolo = StringUtil.getValor(nomeProtocolo, "protocolo")) != null && !Funcoes.textoVazio(nomeProtocolo)) {
            d.setProtocoloEletronico(nomeProtocolo);
        }
        if (rs.getString("req_guia") == null || rs.getString("req_guia").equalsIgnoreCase("-1") || Funcoes.textoVazio(rs.getString("req_guia"))) {
            d.setGuia(null);
        } else {
            d.setGuia(rs.getString("req_guia"));
        }
        if (rs.getString("req_guia") != null && !rs.getString("req_guia").equalsIgnoreCase("-1") && !Funcoes.textoVazio(rs.getString("req_guia"))) {
            d.setGuiaRepasse(rs.getString("req_guia"));
        }
        if (rs.getString("req_guiaprincipal") == null || rs.getString("req_guiaprincipal").equalsIgnoreCase("-1") || Funcoes.textoVazio(rs.getString("req_guiaprincipal"))) {
            d.setGuiaPrincipal(null);
        } else {
            d.setGuiaPrincipal(rs.getString("req_guiaprincipal"));
        }
        d.setValidadeGuiaRepasse(rs.getDate("req_validadeguia"));
        d.setCodigoMedicoOperadora(rs.getString("mec_codigooperadora"));
        d.setFaturaEletronica(rs.getString("con_faturaeletronica"));
        d.setNomeProtocolo(nomeProtocolo);
        d.setCpfMedico(rs.getString("med_cpf"));
        d.setCodigoCnesExecutante(rs.getString("fil_cnes"));
    }

    private String buscaCbosDoConvenio(int codigoDaFilial, int codigoDoConvenio) throws ThreadDaoException {
        HashMap<String, Object> condicoesParaBuscarOBean = new HashMap<String, Object>();
        condicoesParaBuscarOBean.put("fil_codigo", codigoDaFilial);
        condicoesParaBuscarOBean.put("con_codigo", codigoDoConvenio);
        ConvenioBean bean = (ConvenioBean)this.convenioService.getBean(condicoesParaBuscarOBean);
        String faturaEletronica = bean.getFaturaEletronica();
        String tagDoCBOPadrao = "CBOPadrao";
        String CBOSPadraoDoConvenio = "";
        if (!Funcoes.textoVazio(faturaEletronica)) {
            CBOSPadraoDoConvenio = StringUtil.getValor(faturaEletronica, tagDoCBOPadrao);
        }
        return CBOSPadraoDoConvenio;
    }

    private void adicionaExame(DadosFaturamento d, ResultSet rs) throws SQLException {
        this.adicionaExame(d, rs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adicionaExame(DadosFaturamento d, ResultSet rs, String tipoRateio) throws SQLException {
        if (!d.getFaturarFaltaMaterial() && rs.getString("exr_situacao") != null && rs.getString("exr_situacao").equals("F") || !d.getFaturarRecoleta() && rs.getString("exr_situacao") != null && rs.getString("exr_situacao").equals("R") || !DBUtil.campoNull(rs.getString("exr_datacortesia"))) {
            return;
        }
        boolean exameAlterado = ExameUtil.corrigeAgrupamentoExame(rs.getInt("fil_codigo"), rs.getInt("req_codigo"), rs.getString("exa_codigo"), rs.getInt("mco_codigo"), rs.getInt("con_codigo"));
        if (exameAlterado) {
            int i = 1;
            this.psAgrupSemLigacao.setInt(i++, rs.getInt("fil_codigo"));
            this.psAgrupSemLigacao.setInt(i++, rs.getInt("req_codigo"));
            this.psAgrupSemLigacao.setString(i++, rs.getString("exa_codigo"));
            this.psAgrupSemLigacao.setInt(i++, rs.getInt("mco_codigo"));
            try (ResultSet rsAgrupa = null;){
                rsAgrupa = this.psAgrupSemLigacao.executeQuery();
                while (rsAgrupa.next()) {
                    if (this.localizaExame(d, rsAgrupa.getString("exa_codigo"), rsAgrupa.getInt("mco_codigo"))) continue;
                    String codigoFilial = rs.getString("fil_codigo");
                    DadosMaterial mat = this.getDadosMaterial(codigoFilial, rsAgrupa.getInt("mco_codigo"));
                    DadosExames exame = this.getDadosExames(codigoFilial, rsAgrupa.getString("exa_codigo"), mat);
                    DadosConvenios convenioCalc = this.getDadosConvenios(codigoFilial, rs);
                    ExameUtil.calculaPrecoExame(codigoFilial, exame, mat, convenioCalc, false, true, false, rs.getInt("req_codigo"), null, Integer.parseInt(exame.getCodMetodo()));
                    DadosExameFaturamento dados = new DadosExameFaturamento(exame.getCodigo());
                    dados.setProibido(exame.getProibido());
                    dados.setCodigoMaterial(mat.getCodigo());
                    dados.setCodigoAutorizacao(rs.getString("exr_codautorizacao"));
                    dados.setDataAutorizacao(rs.getDate("exr_dataautorizacao"));
                    dados.setValidadeAutorizacao(rs.getDate("exr_datavalidadeautorizacao"));
                    dados.setNomeExame(exame.getDescricao());
                    dados.setValorMaterial(exame.getValorMaterial());
                    dados.setDataExame(rs.getDate("exr_data"));
                    dados.setCodigoUsuarioExame(rs.getString("usr_codigo"));
                    dados.setDescricaoMaterial(mat.getDescricao());
                    dados.setAbreviaturaMaterial(mat.getAbreviatura());
                    dados.setCodigoAMB(ExameUtil.getCodigoAMB(codigoFilial, exame.getCodigo(), mat.getCodigo(), rs.getInt("con_codigo"), Integer.parseInt(exame.getCodMetodo())));
                    dados.setCodigoMetodologia(rsAgrupa.getString("codigoMetodo"));
                    dados.setCodigoCBHPM(exame.getCBHPM());
                    dados.setMotivoPrazo(rs.getString("exr_motivoprazo"));
                    dados.setSituacaoExame(rs.getString("exr_situacao"));
                    dados.setExamePai(new DadosExamePaiAgrupamento(rs.getString("exa_codigo"), rs.getInt("mco_codigo")), false);
                    dados.setTipoBPA(rs.getString("exa_tipobpa"));
                    dados.setValidadeGuia(rsAgrupa.getDate("exg_validadeguia"));
                    dados.setTipoAlimentos(rs.getString("set_tipoalimentos"));
                    if (rs.getInt("con_codigo") == rs.getInt("codigoconvenioprincipal")) {
                        dados.setDataGuia(rsAgrupa.getDate("exg_dataguia"));
                        dados.setCodigoGuia(rsAgrupa.getString("exr_guia"));
                    } else {
                        dados.setDataGuia(rs.getDate("req_dataguia"));
                        dados.setCodigoGuia(rs.getString("exr_guia"));
                    }
                    dados.setFaturar(rs.getString("exr_naofaturar") == null ? ExameUtil.proibidoConvenio(exame, convenioCalc) != 9 : !rs.getBoolean("exr_naofaturar"));
                    dados.setOrdemAdicao(rs.getInt("exr_ordem"));
                    dados.setOrdemExame(rs.getInt("emc_ordem"));
                    dados.setPaginaExame(rs.getInt("emc_pagina"));
                    dados.setCodigoSetor(rs.getInt("set_codigo"));
                    if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
                        dados.setDeveGuia(false);
                    } else {
                        dados.setDeveGuia(rsAgrupa.getBoolean("exg_deveguia"));
                    }
                    BigDecimal valorExame = BigDecimal.ZERO;
                    BigDecimal valorTotalExame = BigDecimal.ZERO;
                    if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
                        if (rs.getString("tipocalculo").equalsIgnoreCase("P")) {
                            BigDecimal aux = exame.getValorExame().divide(new BigDecimal(1).subtract(rs.getBigDecimal("con_percpgto").divide(new BigDecimal(100), RoundingMode.HALF_UP)), RoundingMode.HALF_UP);
                            BigDecimal auxTotal = exame.getValor().divide(new BigDecimal(1).subtract(rs.getBigDecimal("con_percpgto").divide(new BigDecimal(100), RoundingMode.HALF_UP)), RoundingMode.HALF_UP);
                            valorExame = aux.multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                            valorTotalExame = auxTotal.multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                        } else {
                            valorExame = exame.getValorExame().multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                            valorTotalExame = exame.getValor().multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                        }
                    } else {
                        valorExame = exame.getValorExame();
                        valorTotalExame = exame.getValor();
                    }
                    dados.setCasasDecimais(this.casasDecimais);
                    dados.setTipoArredondamento(this.arredondamentoPreco);
                    dados.setValorExame(valorExame);
                    dados.setValorTotalExame(valorTotalExame);
                    dados.setValorCHExame(exame.getValorCH().setScale(this.casasDecimais, this.arredondamentoPreco));
                    dados.setValorCH(convenioCalc.getCH());
                    dados.setValorBalcao(rs.getBigDecimal("exr_vlrbalcaoconvenio"));
                    dados.setUcoCBHPM(rs.getBigDecimal("exr_valoruco"));
                    dados.setCustoCBHPM(rs.getBigDecimal("exr_valorcusto"));
                    dados.setValorPorteCBHPM(rs.getBigDecimal("exr_valorporte"));
                    dados.setPorteCBHPM(rs.getString("exr_porte"));
                    dados.setFaturado(rs.getObject("exr_datafatura") != null);
                    dados.setConvenioRepasse(rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal"));
                    dados.setTipoCalculo(rs.getString("tipoCalculo"));
                    for (int j = 0; j < exame.getMateriaisFaturamento().size(); ++j) {
                        dados.adicionaMaterial(exame.getMateriaisFaturamento().get(j));
                    }
                    d.adicionaExame(dados);
                }
            }
        } else if (rs.getInt("agrupamento") > 0 && rs.getInt("agrupamento2") == 0) {
            int i = 1;
            this.psAgrup.setInt(i++, rs.getInt("req_codigo"));
            this.psAgrup.setInt(i++, rs.getInt("fil_codigo"));
            this.psAgrup.setString(i++, rs.getString("exa_codigo"));
            this.psAgrup.setInt(i++, rs.getInt("mco_codigo"));
            this.psAgrup.setString(i++, "F");
            this.psAgrup.setInt(i++, rs.getInt("codigoConvenioPrincipal"));
            ResultSet rsAgrupa = this.psAgrup.executeQuery();
            if (rsAgrupa.next()) {
                rsAgrupa.beforeFirst();
            } else {
                i = 1;
                this.psAgrupIgConv.setInt(i++, rs.getInt("req_codigo"));
                this.psAgrupIgConv.setInt(i++, rs.getInt("fil_codigo"));
                this.psAgrupIgConv.setString(i++, rs.getString("exa_codigo"));
                this.psAgrupIgConv.setInt(i++, rs.getInt("mco_codigo"));
                this.psAgrupIgConv.setString(i++, "F");
                rsAgrupa = this.psAgrupIgConv.executeQuery();
            }
            while (rsAgrupa.next()) {
                if (this.localizaExame(d, rsAgrupa.getString("exa_codigo"), rsAgrupa.getInt("mco_codigo"))) continue;
                String codigoFilial = rs.getString("fil_codigo");
                DadosMaterial mat = this.getDadosMaterial(codigoFilial, rsAgrupa.getInt("mco_codigo"));
                DadosExames exame = this.getDadosExames(codigoFilial, rsAgrupa.getString("exa_codigo"), mat);
                DadosConvenios convenioCalc = this.getDadosConvenios(codigoFilial, rs);
                ExameUtil.calculaPrecoExame(codigoFilial, exame, mat, convenioCalc, false, true, false, rs.getInt("req_codigo"), null, Integer.parseInt(exame.getCodMetodo()));
                DadosExameFaturamento dados = new DadosExameFaturamento(exame.getCodigo());
                dados.setProibido(exame.getProibido());
                dados.setCodigoMaterial(mat.getCodigo());
                dados.setCodigoAutorizacao(rs.getString("exr_codautorizacao"));
                dados.setDataAutorizacao(rs.getDate("exr_dataautorizacao"));
                dados.setValidadeAutorizacao(rs.getDate("exr_datavalidadeautorizacao"));
                dados.setNomeExame(exame.getDescricao());
                dados.setValorMaterial(exame.getValorMaterial());
                dados.setDataExame(rs.getDate("exr_data"));
                dados.setCodigoUsuarioExame(rs.getString("usr_codigo"));
                dados.setDescricaoMaterial(mat.getDescricao());
                dados.setAbreviaturaMaterial(mat.getAbreviatura());
                dados.setCodigoAMB(ExameUtil.getCodigoAMB(codigoFilial, exame.getCodigo(), mat.getCodigo(), rs.getInt("con_codigo"), Integer.parseInt(exame.getCodMetodo())));
                dados.setCodigoMetodologia(rsAgrupa.getString("codigoMetodo"));
                dados.setCodigoCBHPM(exame.getCBHPM());
                dados.setMotivoPrazo(rs.getString("exr_motivoprazo"));
                dados.setSituacaoExame(rs.getString("exr_situacao"));
                dados.setTipoAlimentos(rs.getString("set_tipoalimentos"));
                if (!Funcoes.textoVazio(rs.getString("codigoExamePai")) && !Funcoes.textoVazio(rs.getString("materialExamePai"))) {
                    dados.setExamePai(new DadosExamePaiAgrupamento(rs.getString("codigoExamePai"), rs.getInt("materialExamePai")), true);
                } else {
                    dados.setExamePai(new DadosExamePaiAgrupamento(rs.getString("exa_codigo"), rs.getInt("mco_codigo")), false);
                }
                dados.setValidadeGuia(rsAgrupa.getDate("exg_validadeguia") == null ? rs.getDate("exr_validadeguia") : rsAgrupa.getDate("exg_validadeguia"));
                if (rs.getInt("con_codigo") == rs.getInt("codigoconvenioprincipal")) {
                    dados.setDataGuia(rsAgrupa.getDate("exg_dataguia") == null ? rs.getDate("exr_dataguia") : rsAgrupa.getDate("exg_dataguia"));
                    dados.setCodigoGuia(rsAgrupa.getString("exr_guia") == null || Funcoes.textoVazio(rsAgrupa.getString("exr_guia")) ? rs.getString("req_guia") : rsAgrupa.getString("exr_guia"));
                } else {
                    dados.setDataGuia(rs.getDate("req_dataguia"));
                    dados.setCodigoGuia(rs.getString("exr_guia"));
                }
                dados.setFaturar(rs.getString("exr_naofaturar") == null ? ExameUtil.proibidoConvenio(exame, convenioCalc) != 9 : !rs.getBoolean("exr_naofaturar"));
                dados.setOrdemAdicao(rs.getInt("exr_ordem"));
                dados.setOrdemExame(rsAgrupa.getInt("emc_ordem"));
                dados.setPaginaExame(rsAgrupa.getInt("emc_pagina"));
                dados.setCodigoSetor(rsAgrupa.getInt("set_codigo"));
                if (dados.getCodigoGuia() == null || dados.getCodigoGuia().equalsIgnoreCase("-1")) {
                    dados.setCodigoGuia(null);
                }
                if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
                    dados.setDeveGuia(false);
                } else {
                    dados.setDeveGuia(rs.getBoolean("exr_deveguia"));
                }
                BigDecimal valorExame = BigDecimal.ZERO;
                BigDecimal valorTotalExame = BigDecimal.ZERO;
                if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
                    if (rs.getString("tipocalculo").equalsIgnoreCase("P")) {
                        BigDecimal aux = exame.getValorExame().divide(new BigDecimal(1).subtract(rs.getBigDecimal("con_percpgto").divide(new BigDecimal(100), RoundingMode.HALF_UP)), RoundingMode.HALF_UP);
                        BigDecimal auxTotal = exame.getValor().divide(new BigDecimal(1).subtract(rs.getBigDecimal("con_percpgto").divide(new BigDecimal(100), RoundingMode.HALF_UP)), RoundingMode.HALF_UP);
                        valorExame = aux.multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                        valorTotalExame = auxTotal.multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                    } else {
                        valorExame = exame.getValorExame().multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                        valorTotalExame = exame.getValor().multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                    }
                } else {
                    valorExame = exame.getValorExame();
                    valorTotalExame = exame.getValor();
                }
                dados.setCasasDecimais(this.casasDecimais);
                dados.setTipoArredondamento(this.arredondamentoPreco);
                dados.setValorExame(valorExame);
                dados.setValorTotalExame(valorTotalExame);
                dados.setValorCHExame(exame.getValorCH().setScale(this.casasDecimais, this.arredondamentoPreco));
                dados.setValorCH(convenioCalc.getCH());
                dados.setValorBalcao(rs.getBigDecimal("exr_vlrbalcaoconvenio"));
                dados.setUcoCBHPM(rs.getBigDecimal("exr_valoruco"));
                dados.setCustoCBHPM(rs.getBigDecimal("exr_valorcusto"));
                dados.setValorPorteCBHPM(rs.getBigDecimal("exr_valorporte"));
                dados.setPorteCBHPM(rs.getString("exr_porte"));
                dados.setFaturado(rs.getObject("exr_datafatura") != null);
                dados.setConvenioRepasse(rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal"));
                dados.setTipoCalculo(rs.getString("tipoCalculo"));
                for (int j = 0; j < exame.getMateriaisFaturamento().size(); ++j) {
                    dados.adicionaMaterial(exame.getMateriaisFaturamento().get(j));
                }
                d.adicionaExame(dados);
            }
            rsAgrupa.close();
        } else if (rs.getInt("agrupamento2") > 0) {
            int i = 1;
            this.psAgrupIgMat.setInt(i++, rs.getInt("req_codigo"));
            this.psAgrupIgMat.setInt(i++, rs.getInt("fil_codigo"));
            this.psAgrupIgMat.setInt(i++, rs.getInt("con_codigo"));
            this.psAgrupIgMat.setString(i++, rs.getString("exa_codigo"));
            this.psAgrupIgMat.setString(i++, "F");
            this.psAgrupIgMat.setString(i++, "F");
            ResultSet rsAgrupa = this.psAgrupIgMat.executeQuery();
            if (rsAgrupa.next()) {
                rsAgrupa.beforeFirst();
            } else {
                i = 1;
                this.psAgrupIgConvMat.setInt(i++, rs.getInt("req_codigo"));
                this.psAgrupIgConvMat.setInt(i++, rs.getInt("fil_codigo"));
                this.psAgrupIgConvMat.setString(i++, rs.getString("exa_codigo"));
                this.psAgrupIgConvMat.setString(i++, "F");
                this.psAgrupIgConvMat.setString(i++, "F");
                rsAgrupa = this.psAgrupIgConvMat.executeQuery();
            }
            if (rsAgrupa.next()) {
                do {
                    String codigoFilial = rs.getString("fil_codigo");
                    DadosConvenios convenioCalc = this.getDadosConvenios(codigoFilial, rs);
                    i = 1;
                    this.psMatCol.setInt(i++, rsAgrupa.getInt("fil_codigo"));
                    this.psMatCol.setString(i++, rsAgrupa.getString("exa_codigo"));
                    this.psMatCol.setInt(i++, rs.getInt("mco_codigo"));
                    ResultSet rsMaterial = this.psMatCol.executeQuery();
                    DadosMaterial mat = null;
                    if (rsMaterial.next()) {
                        mat = this.getDadosMaterial(codigoFilial, rsMaterial.getInt("mco_codigo"));
                    } else {
                        i = 1;
                        this.psMatColPadrao.setInt(i++, rsAgrupa.getInt("fil_codigo"));
                        this.psMatColPadrao.setString(i++, rsAgrupa.getString("exa_codigo"));
                        rsMaterial = this.psMatColPadrao.executeQuery();
                        if (!rsMaterial.next()) {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Material padr\u00e3o do exame " + rsAgrupa.getString("exa_codigo") + " n\u00e3o encontrado.", null);
                            continue;
                        }
                        mat = this.getDadosMaterial(codigoFilial, rsMaterial.getInt("mco_codigo"));
                    }
                    DadosExames exame = this.getDadosExames(codigoFilial, rsAgrupa.getString("exa_codigo"), mat);
                    if (this.localizaExame(d, exame.getCodigo(), mat.getCodigo())) continue;
                    ExameUtil.calculaPrecoExame(codigoFilial, exame, mat, convenioCalc, false, true, false, rs.getInt("req_codigo"), null, Integer.parseInt(exame.getCodMetodo()));
                    DadosExameFaturamento dados = new DadosExameFaturamento(exame.getCodigo());
                    dados.setProibido(exame.getProibido());
                    dados.setCodigoMaterial(mat.getCodigo());
                    dados.setCodigoAutorizacao(rs.getString("exr_codautorizacao"));
                    dados.setDataAutorizacao(rs.getDate("exr_dataautorizacao"));
                    dados.setValidadeAutorizacao(rs.getDate("exr_datavalidadeautorizacao"));
                    dados.setNomeExame(exame.getDescricao());
                    dados.setValorMaterial(exame.getValorMaterial());
                    dados.setDataExame(rs.getDate("exr_data"));
                    dados.setCodigoUsuarioExame(rs.getString("usr_codigo"));
                    dados.setDescricaoMaterial(mat.getDescricao());
                    dados.setAbreviaturaMaterial(mat.getAbreviatura());
                    dados.setCodigoAMB(ExameUtil.getCodigoAMB(codigoFilial, exame.getCodigo(), mat.getCodigo(), rs.getInt("con_codigo"), Integer.parseInt(exame.getCodMetodo())));
                    dados.setCodigoMetodologia(rsAgrupa.getString("codigoMetodo"));
                    dados.setCodigoCBHPM(exame.getCBHPM());
                    dados.setMotivoPrazo(rs.getString("exr_motivoprazo"));
                    dados.setSituacaoExame(rs.getString("exr_situacao"));
                    if (!Funcoes.textoVazio(rs.getString("codigoExamePai")) && !Funcoes.textoVazio(rs.getString("materialExamePai"))) {
                        dados.setExamePai(new DadosExamePaiAgrupamento(rs.getString("codigoExamePai"), rs.getInt("materialExamePai")), true);
                    } else {
                        dados.setExamePai(new DadosExamePaiAgrupamento(rs.getString("exa_codigo"), rs.getInt("mco_codigo")), false);
                    }
                    dados.setValidadeGuia(rsAgrupa.getDate("exg_validadeguia"));
                    if (rs.getInt("con_codigo") == rs.getInt("codigoconvenioprincipal")) {
                        dados.setDataGuia(rsAgrupa.getDate("exg_dataguia") == null ? rs.getDate("exr_dataguia") : rsAgrupa.getDate("exg_dataguia"));
                        dados.setCodigoGuia(rsAgrupa.getString("exr_guia") == null ? rs.getString("req_guia") : rsAgrupa.getString("exr_guia"));
                    } else {
                        dados.setDataGuia(rs.getDate("req_dataguia"));
                        dados.setCodigoGuia(rs.getString("exr_guia"));
                    }
                    dados.setFaturar(rs.getString("exr_naofaturar") == null ? ExameUtil.proibidoConvenio(exame, convenioCalc) != 9 : !rs.getBoolean("exr_naofaturar"));
                    dados.setOrdemAdicao(rs.getInt("exr_ordem"));
                    dados.setOrdemExame(rsAgrupa.getInt("emc_ordem"));
                    dados.setPaginaExame(rsAgrupa.getInt("emc_pagina"));
                    dados.setCodigoSetor(rsAgrupa.getInt("set_codigo"));
                    if (dados.getCodigoGuia().equalsIgnoreCase("-1")) {
                        dados.setCodigoGuia(null);
                    }
                    if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
                        dados.setDeveGuia(false);
                    } else {
                        dados.setDeveGuia(rs.getBoolean("exr_deveguia"));
                    }
                    BigDecimal valorExame = BigDecimal.ZERO;
                    BigDecimal valorTotalExame = BigDecimal.ZERO;
                    if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
                        if (rs.getString("tipocalculo").equalsIgnoreCase("P")) {
                            BigDecimal aux = exame.getValorExame().divide(new BigDecimal(1).subtract(rs.getBigDecimal("con_percpgto").divide(new BigDecimal(100), RoundingMode.HALF_UP)), RoundingMode.HALF_UP);
                            BigDecimal auxTotal = exame.getValor().divide(new BigDecimal(1).subtract(rs.getBigDecimal("con_percpgto").divide(new BigDecimal(100), RoundingMode.HALF_UP)), RoundingMode.HALF_UP);
                            valorExame = aux.multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                            valorTotalExame = auxTotal.multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                        } else {
                            valorTotalExame = exame.getValor().multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                            valorExame = exame.getValorExame().multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal(100) : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                        }
                    } else {
                        valorTotalExame = exame.getValor();
                        valorExame = exame.getValorExame();
                    }
                    dados.setCasasDecimais(this.casasDecimais);
                    dados.setTipoArredondamento(this.arredondamentoPreco);
                    dados.setValorTotalExame(valorTotalExame);
                    dados.setValorExame(valorExame);
                    dados.setValorCHExame(exame.getValorCH().setScale(2, this.arredondamentoPreco));
                    dados.setValorCH(convenioCalc.getCH());
                    dados.setValorBalcao(rs.getBigDecimal("exr_vlrbalcaoconvenio"));
                    dados.setUcoCBHPM(rs.getBigDecimal("exr_valoruco"));
                    dados.setCustoCBHPM(rs.getBigDecimal("exr_valorcusto"));
                    dados.setValorPorteCBHPM(rs.getBigDecimal("exr_valorporte"));
                    dados.setPorteCBHPM(rs.getString("exr_porte"));
                    dados.setFaturado(rs.getObject("exr_datafatura") != null);
                    dados.setConvenioRepasse(rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal"));
                    dados.setTipoCalculo(rs.getString("tipoCalculo"));
                    for (int j = 0; j < exame.getMateriaisFaturamento().size(); ++j) {
                        dados.adicionaMaterial(exame.getMateriaisFaturamento().get(j));
                    }
                    d.adicionaExame(dados);
                } while (rsAgrupa.next());
            }
        } else {
            if (this.localizaExame(d, rs.getString("exa_codigo"), rs.getInt("mco_codigo"))) {
                return;
            }
            String codigoFilial = rs.getString("fil_codigo");
            DadosMaterial mat = this.getDadosMaterial(codigoFilial, rs.getInt("mco_codigo"));
            DadosExames exame = this.getDadosExames(codigoFilial, rs.getString("exa_codigo"), mat);
            DadosConvenios convenioCalc = this.getDadosConvenios(codigoFilial, rs);
            ExameUtil.calculaPrecoExame(codigoFilial, exame, mat, convenioCalc, false, true, false, rs.getInt("req_codigo"), null, Integer.parseInt(exame.getCodMetodo()));
            DadosExameFaturamento dados = new DadosExameFaturamento(exame.getCodigo());
            dados.setProibido(exame.getProibido());
            dados.setCodigoMaterial(mat.getCodigo());
            dados.setCodigoAutorizacao(rs.getString("exr_codautorizacao"));
            dados.setDataAutorizacao(rs.getDate("exr_dataautorizacao"));
            dados.setValidadeAutorizacao(rs.getDate("exr_datavalidadeautorizacao"));
            dados.setNomeExame(rs.getString("exa_descricao"));
            dados.setValorMaterial(exame.getValorMaterial());
            dados.setDataExame(rs.getDate("exr_data"));
            dados.setCodigoUsuarioExame(rs.getString("usr_codigo"));
            dados.setDescricaoMaterial(rs.getString("mco_descricao"));
            dados.setAbreviaturaMaterial(rs.getString("mco_abreviatura"));
            dados.setCodigoAMB(ExameUtil.getCodigoAMB(codigoFilial, exame.getCodigo(), mat.getCodigo(), rs.getInt("con_codigo"), Integer.parseInt(exame.getCodMetodo())));
            dados.setCodigoMetodologia(rs.getString("met_codigo"));
            dados.setCodigoCBHPM(rs.getString("codigocbhpm"));
            dados.setMotivoPrazo(rs.getString("exr_motivoprazo"));
            dados.setSituacaoExame(rs.getString("exr_situacao"));
            dados.setTipoBPA(rs.getString("exa_tipobpa"));
            dados.setTipoAlimentos(rs.getString("set_tipoalimentos"));
            if (!Funcoes.textoVazio(rs.getString("codigoExamePai")) && !Funcoes.textoVazio(rs.getString("materialExamePai"))) {
                dados.setExamePai(new DadosExamePaiAgrupamento(rs.getString("codigoExamePai"), rs.getInt("materialExamePai")), true);
            } else {
                dados.setExamePai(new DadosExamePaiAgrupamento(rs.getString("exa_codigo"), rs.getInt("mco_codigo")), false);
            }
            if (rs.getInt("con_codigo") == rs.getInt("codigoconvenioprincipal")) {
                dados.setDataGuia(rs.getDate("exr_dataguia"));
                dados.setCodigoGuia(rs.getString("exr_guia"));
            } else {
                dados.setDataGuia(rs.getDate("req_dataguia"));
                dados.setCodigoGuia(rs.getString("exr_guia"));
            }
            dados.setValidadeGuia(rs.getDate("exr_validadeguia"));
            dados.setFaturar(rs.getString("exr_naofaturar") == null ? ExameUtil.proibidoConvenio(exame, convenioCalc) != 9 : !rs.getBoolean("exr_naofaturar"));
            dados.setOrdemAdicao(rs.getInt("exr_ordem"));
            dados.setOrdemExame(rs.getInt("emc_ordem"));
            dados.setPaginaExame(rs.getInt("emc_pagina"));
            dados.setCodigoSetor(rs.getInt("set_codigo"));
            if (dados.getCodigoGuia() != null && dados.getCodigoGuia().equalsIgnoreCase("-1")) {
                dados.setCodigoGuia(null);
            }
            if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
                dados.setDeveGuia(false);
            } else {
                dados.setDeveGuia(rs.getBoolean("exr_deveguia"));
            }
            BigDecimal valorExame = BigDecimal.ZERO;
            if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal") && rs.getBigDecimal("con_percpgto") != null) {
                if (rs.getString("tipocalculo").equalsIgnoreCase("P")) {
                    BigDecimal divisor = new BigDecimal(1).subtract(rs.getBigDecimal("con_percpgto").divide(new BigDecimal("100"), this.arredondamentoPreco));
                    divisor = divisor.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : divisor;
                    BigDecimal aux = exame.getValorExame().divide(divisor, this.arredondamentoPreco);
                    valorExame = aux.multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal("100") : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal("100"), this.arredondamentoPreco);
                } else {
                    valorExame = exame.getValorExame().multiply(rs.getBigDecimal("con_percpgto") == null ? new BigDecimal("100") : rs.getBigDecimal("con_percpgto")).divide(new BigDecimal("100"), this.arredondamentoPreco);
                }
            } else {
                valorExame = exame.getValorExame();
            }
            if (convenioCalc.getTipoCalculoFatura().equalsIgnoreCase("R")) {
                valorExame = new BigDecimal(0);
                valorExame = !exame.getTabelaPreco().isTipoCBHPM() ? (convenioCalc.getTipoCalculo().equalsIgnoreCase("M") ? rs.getBigDecimal("exr_vlrchexame").multiply(rs.getBigDecimal("exr_vlrch")) : rs.getBigDecimal("exr_vlrchexame").divide(rs.getBigDecimal("exr_vlrch"))) : rs.getBigDecimal("exr_vlrchexame").multiply(rs.getBigDecimal("exr_valorporte")).add(rs.getBigDecimal("exr_valorcusto").multiply(rs.getBigDecimal("exr_valoruco")));
                valorExame = valorExame.multiply(new BigDecimal("100").subtract(rs.getBigDecimal("exr_vlrbalcaoconvenio")).divide(new BigDecimal("100"), this.arredondamentoPreco));
                valorExame = valorExame.subtract(valorExame.multiply(new BigDecimal(String.valueOf(convenioCalc.getBonus()))).divide(new BigDecimal("100"), this.arredondamentoPreco));
                valorExame = valorExame.add(valorExame.multiply(new BigDecimal(String.valueOf(convenioCalc.getAcrescimo()))).divide(new BigDecimal("100"), this.arredondamentoPreco));
                dados.setCasasDecimais(this.casasDecimais);
                dados.setTipoArredondamento(this.arredondamentoPreco);
                dados.setValorExame(valorExame);
                dados.setValorTotalExame(valorExame);
                dados.setValorCHExame(rs.getBigDecimal("exr_vlrchexame").setScale(2, this.arredondamentoPreco));
                dados.setValorCH(rs.getBigDecimal("exr_vlrch"));
            } else {
                dados.setCasasDecimais(this.casasDecimais);
                dados.setTipoArredondamento(this.arredondamentoPreco);
                dados.setValorTotalExame(valorExame);
                dados.setValorExame(valorExame);
                dados.setValorCHExame(exame.getValorCH().setScale(this.casasDecimais, this.arredondamentoPreco));
                dados.setValorCH(convenioCalc.getCH());
            }
            dados.setValorBalcao(rs.getBigDecimal("exr_vlrbalcaoconvenio"));
            dados.setUcoCBHPM(rs.getBigDecimal("exr_valoruco"));
            dados.setCustoCBHPM(rs.getBigDecimal("exr_valorcusto"));
            dados.setValorPorteCBHPM(rs.getBigDecimal("exr_valorporte"));
            dados.setPorteCBHPM(rs.getString("exr_porte"));
            dados.setFaturado(rs.getObject("exr_datafatura") != null);
            dados.setConvenioRepasse(rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal"));
            dados.setTipoCalculo(rs.getString("tipoCalculo"));
            for (int j = 0; j < exame.getMateriaisFaturamento().size(); ++j) {
                dados.adicionaMaterial(exame.getMateriaisFaturamento().get(j));
            }
            d.adicionaExame(dados);
        }
    }

    private DadosMaterial getDadosMaterial(String codigoFilial, int codigoMaterial) throws SQLException {
        DadosMaterial mat = this.listaMateriais.get(codigoFilial + "." + codigoMaterial);
        if (mat == null) {
            mat = ExameUtil.getDadosMaterial(codigoFilial, codigoMaterial);
            this.listaMateriais.put(codigoFilial + "." + codigoMaterial, mat);
        }
        return mat;
    }

    private DadosExames getDadosExames(String codigoFilial, String codigoExame, DadosMaterial mat) throws SQLException {
        DadosExames exame = this.listaExames.get(codigoFilial + codigoExame + mat.getCodigo());
        if (exame == null) {
            exame = ExameUtil.getDadosExame(codigoFilial, codigoExame, mat);
            this.listaExames.put(codigoFilial + codigoExame + mat.getCodigo(), exame);
        }
        return exame;
    }

    private DadosConvenios getDadosConvenios(String codigoFilial, ResultSet rs) throws SQLException {
        DadosConvenios convenioCalc = null;
        if (rs.getInt("con_codigo") != rs.getInt("codigoconvenioprincipal")) {
            if (rs.getString("tipocalculo").equalsIgnoreCase("P")) {
                convenioCalc = this.listaConvenios.get(codigoFilial + rs.getInt("codigoconvenioprincipal"));
                if (convenioCalc == null) {
                    convenioCalc = ConvenioUtil.getDadosConvenios(codigoFilial, rs.getInt("codigoconvenioprincipal"));
                    this.listaConvenios.put(codigoFilial + rs.getInt("codigoconvenioprincipal"), convenioCalc);
                }
            } else {
                convenioCalc = this.listaConvenios.get(codigoFilial + rs.getInt("con_codigo"));
                if (convenioCalc == null) {
                    convenioCalc = ConvenioUtil.getDadosConvenios(codigoFilial, rs.getInt("con_codigo"));
                    this.listaConvenios.put(codigoFilial + rs.getInt("con_codigo"), convenioCalc);
                }
            }
        } else {
            convenioCalc = this.listaConvenios.get(codigoFilial + rs.getInt("con_codigo"));
            if (convenioCalc == null) {
                convenioCalc = ConvenioUtil.getDadosConvenios(codigoFilial, rs.getInt("con_codigo"));
                this.listaConvenios.put(codigoFilial + rs.getInt("con_codigo"), convenioCalc);
            }
        }
        return convenioCalc;
    }

    private boolean localizaExame(DadosFaturamento d, String exame, int material) {
        for (int i = 0; i < d.getExamesCount(); ++i) {
            DadosExameFaturamento exm = d.getExame(i);
            if (!exm.getCodigoExame().equals(exame) || exm.getCodigoMaterial() != material) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pegaMateriais(DadosFaturamento d, DadosExameFaturamento dados) throws SQLException {
        Statement stMaterial = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.mat_codigo, a.mer_qtde, a.mer_valor, ");
        buf.append("b.mat_descricao, b.mat_valorunit, c.mex_cobrarbalcao ");
        buf.append("from materialexamerequis a ");
        buf.append("left join material b on a.fil_codigo = b.fil_codigo and a.mat_codigo = b.mat_codigo ");
        buf.append("left join materialexame c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and a.mat_codigo = c.mat_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(d.getCodigoFilial());
        buf.append(" and a.req_codigo = ");
        buf.append(d.getRequisicao());
        buf.append(" and a.exa_codigo = '");
        buf.append(dados.getCodigoExame());
        buf.append("' and a.mco_codigo = ");
        buf.append(String.valueOf(dados.getCodigoMaterial()));
        buf.append("order by a.mat_codigo ");
        try (ResultSet rsMaterial = null;){
            rsMaterial = stMaterial.executeQuery(buf.toString());
            while (rsMaterial.next()) {
                DadosMaterialFaturamento mat = new DadosMaterialFaturamento();
                mat.setCodigo(rsMaterial.getInt("mat_codigo"));
                mat.setDescricao(rsMaterial.getString("mat_descricao"));
                BigDecimal valor = d.getTipoCalculoFatura().equals("T") ? rsMaterial.getBigDecimal("mat_valorunit") : rsMaterial.getBigDecimal("mer_valor");
                if (d.getPercentualBalcaoMaterial() != null && d.getPercentualBalcaoMaterial().doubleValue() > 0.0 && !DBUtil.campoNull(rsMaterial.getString("mex_cobrarbalcao")) && rsMaterial.getBoolean("mex_cobrarbalcao")) {
                    valor = valor.subtract(valor.multiply(d.getPercentualBalcaoMaterial()).divide(new BigDecimal(100), this.arredondamentoPreco));
                    mat.setValorDiferencaBalcao(valor.multiply(d.getPercentualBalcaoMaterial()).divide(new BigDecimal(100), this.arredondamentoPreco));
                }
                mat.setValor(valor);
                mat.setQuantidade(rsMaterial.getBigDecimal("mer_qtde"));
                dados.adicionaMaterial(mat);
            }
        }
        Conexao.fecharStatement(stMaterial);
    }

    private void pegaMateriais(DadosExameFaturamento dados, DadosExames dadosExame) {
        if (dadosExame == null) {
            return;
        }
        ArrayList materiais = dadosExame.getMatUtilizado();
        if (materiais != null) {
            for (int i = 0; i < materiais.size(); ++i) {
                DadosMaterialUtilizado material = (DadosMaterialUtilizado)materiais.get(i);
                DadosMaterialFaturamento mat = new DadosMaterialFaturamento();
                mat.setCodigo(material.getCodigo());
                mat.setDescricao(material.getDescricao());
                mat.setValor(material.getValor());
                mat.setQuantidade(material.getQtde());
                dados.adicionaMaterial(mat);
            }
        }
    }

    private boolean isOrdenaFaturaAlimentos(String ordemFatura) {
        return Variaveis.tipoFilialPadrao.equals("A") && ordemFatura.equalsIgnoreCase("S");
    }

    private void mostraMensagem(String mensagem) {
        JLabel label = new JLabel(mensagem);
        this.panelMensagens.add(label);
        label.setBounds(10, this.linha, 350, 25);
        this.panelMensagens.revalidate();
        this.panelMensagens.getTopLevelAncestor().repaint();
        this.linha += 15;
    }

    public void setFiltroColeta(String ... filtro) {
        this.filtroColeta = filtro;
    }

    public void setFiltroDestino(String ... filtro) {
        this.filtroDestino = filtro;
    }

    public void setFiltroEstacao(String ... filtro) {
        this.filtroEstacao = filtro;
    }

    public void setFiltroConvenio(String ... filtro) {
        this.filtroConvenio = filtro;
    }

    public void setFiltroSetor(String ... filtro) {
        this.filtroSetor = filtro;
    }

    public void setFiltroGrupo(String ... filtro) {
        this.filtroGrupo = filtro;
    }

    public void setFiltroMedicoCrm(String ... filtro) {
        this.filtroMedicoCrm = filtro;
    }

    public void setFiltroMedicoConselho(String ... filtro) {
        this.filtroMedicoConselho = filtro;
    }

    public void setFiltroMedicoUF(String ... filtro) {
        this.filtroMedicoUF = filtro;
    }

    public void setFiltroSituacao(String ... filtro) {
        this.filtroSituacao = filtro;
    }

    public void setFiltroSituacaoExames(String ... filtro) {
        this.filtroSituacaoExames = filtro;
    }

    public void setFiltroPaciente(String ... filtro) {
        this.filtroPaciente = filtro;
    }

    public void setDataInicio(String data) {
        this.dataInicio = data;
    }

    public void setDataFim(String data) {
        this.dataFim = data;
    }

    public void setHoraInicio(String hora) {
        this.horaInicio = hora;
    }

    public void setHoraFim(String hora) {
        this.horaFim = hora;
    }

    public void setApenasConferidas(boolean b) {
        this.apenasConferidas = b;
    }

    @Override
    public void linhaRemovida() {
        try {
            this.calculaTotal(this.modeloTabela.getRowCount() - 1);
            this.tabela.repaint();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BuscaRequisicoes (718)");
        }
    }

    public String sqlRequisicoes(Statement st, String filial, String codigoConvenio, String codigoRequisicao, String guiaRequisicao, String guiaExames, boolean trazerFaturados, boolean isExibirNaoFaturar) throws Exception {
        FaturaExamesService serviceFaturaExames = new FaturaExamesService();
        serviceFaturaExames.setApenasConferidas(this.apenasConferidas);
        serviceFaturaExames.setDataFim(this.dataFim);
        serviceFaturaExames.setDataInicio(this.dataInicio);
        serviceFaturaExames.setExibirNaoFaturar(isExibirNaoFaturar);
        serviceFaturaExames.setFiltroColeta(this.filtroColeta);
        serviceFaturaExames.setFiltroConvenio(this.filtroConvenio);
        serviceFaturaExames.setFiltroDestino(this.filtroDestino);
        serviceFaturaExames.setFiltroEstacao(this.filtroEstacao);
        serviceFaturaExames.setFiltroExame(this.filtroExame);
        serviceFaturaExames.setFiltroGrupo(this.filtroGrupo);
        serviceFaturaExames.setFiltroMedicoConselho(this.filtroMedicoConselho);
        serviceFaturaExames.setFiltroMedicoCrm(this.filtroMedicoCrm);
        serviceFaturaExames.setFiltroMedicoUF(this.filtroMedicoUF);
        serviceFaturaExames.setFiltroPaciente(this.filtroPaciente);
        serviceFaturaExames.setFiltroSetor(this.filtroSetor);
        serviceFaturaExames.setFiltroSituacao(this.filtroSituacao);
        serviceFaturaExames.setFiltroSituacaoExames(this.filtroSituacaoExames);
        serviceFaturaExames.setFiltroUnidadeSaude(this.filtroUnidadeSaude);
        serviceFaturaExames.setFiltroEmpresa(this.filtroEmpresa);
        serviceFaturaExames.setHoraFim(this.horaFim);
        serviceFaturaExames.setHoraInicio(this.horaInicio);
        serviceFaturaExames.setTextoFiltroConvenio(this.textoFiltroConvenio);
        serviceFaturaExames.setVerificarConferidos(this.isVerificarConferidos);
        serviceFaturaExames.setApenasComResultados(this.apenasComResultado);
        String sql = serviceFaturaExames.sqlRequisicoes(st, filial, codigoConvenio, codigoRequisicao, guiaRequisicao, guiaExames, trazerFaturados, isExibirNaoFaturar);
        this.textoFiltroConvenio = serviceFaturaExames.getTextoFiltroConvenio();
        return sql;
    }

    public void addThreadListener(ThreadFinalizadaListener listener) {
        this.listenerList.add(ThreadFinalizadaListener.class, listener);
    }

    public void removeThreadListener(ThreadFinalizadaListener listener) {
        this.listenerList.remove(ThreadFinalizadaListener.class, listener);
    }

    private void fireIniciouExecucao() {
        ThreadFinalizadaListener[] lis = (ThreadFinalizadaListener[])this.listenerList.getListeners(ThreadFinalizadaListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].threadIniciada(new EventObject(this));
        }
    }

    private void fireTerminouExecucao() {
        ThreadFinalizadaListener[] lis = (ThreadFinalizadaListener[])this.listenerList.getListeners(ThreadFinalizadaListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].threadFinalizada(new EventObject(this));
        }
    }
}

