/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.TabelaANS;
import jalis.comum.TelaLocalizar;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosMaterialFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.Calculos;
import jalis.laboratorio.util.faturamento.ConvenioCotaExameBeanAux;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.faturamento.LinhasRemovidasListener;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.laboratorio.util.faturamento.SelecaoListener;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FabricaFaturaEletronica;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.enums.EnumTipoRateio;
import jalis.model.utils.ThreadDaoException;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BuscaFatura
extends Thread
implements LinhasRemovidasListener {
    private final EventListenerList listenerList = new EventListenerList();
    private final JPanel panelProgresso;
    private final JPanel panelMensagens;
    private final JPanel panel;
    private final JButton button;
    private final Frame owner;
    private JTable tabela;
    private JScrollPane scroll;
    private LinhasTabela modeloTabela;
    private JProgressBar progresso;
    private int linha = 5;
    private String codigoFatura;
    private String ordemFatura = null;
    private boolean showCheckBox = false;
    private boolean pararSeConferida = false;
    private boolean conferida = false;
    private boolean permitirAbrirConferida = false;
    private boolean mostrarMensagemSeConferida = true;
    private boolean acessoAlterarTodosCamposFatEletronico = false;
    private boolean isVerificarConferidos = false;
    private int casasDecimais = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode tipoArredondamento = ParametrosGerais.getArredondamentoPrecoExame();
    private Map<String, DadosExames> listaExames;
    private Map<String, DadosMaterial> listaMateriais;
    private Map<String, String> listaAMB;
    private ConvenioService convenioService = new ConvenioService();
    private ExameService exameService = new ExameService();
    private Integer codigoConvenio = null;
    private JLabel labelValorRestante = null;
    private List<Registro> requisicoesSemPedidoGuia = new ArrayList<Registro>();

    public BuscaFatura(Frame owner, JPanel panel, JButton button, boolean showCheckBox, boolean permitirAbrirConferida, boolean mostrarMensagemSeConferida, boolean isVerificarConferidos, ThreadFinalizadaListener telaListener) {
        this(owner, panel, button, showCheckBox, permitirAbrirConferida, isVerificarConferidos, telaListener);
        this.mostrarMensagemSeConferida = mostrarMensagemSeConferida;
        this.isVerificarConferidos = isVerificarConferidos;
    }

    public BuscaFatura(Frame owner, JPanel panel, JButton button, boolean showCheckBox, boolean permitirAbrirConferida, boolean isVerificarConferidos, ThreadFinalizadaListener telaListener) {
        super("Thread - busca faturamento");
        this.setPriority(5);
        this.panel = panel;
        this.button = button;
        this.owner = owner;
        this.showCheckBox = showCheckBox;
        this.permitirAbrirConferida = permitirAbrirConferida;
        this.isVerificarConferidos = isVerificarConferidos;
        this.panel.setLayout(new GridBagLayout());
        this.panelMensagens = new JPanel(new GridLayout(0, 1));
        this.panelProgresso = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panel.add((Component)this.panelProgresso, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panel.add((Component)this.panelMensagens, c);
        if (telaListener != null) {
            this.addThreadListener(telaListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block56: {
            block57: {
                block60: {
                    block55: {
                        block54: {
                            block53: {
                                this.listaExames = new HashMap<String, DadosExames>();
                                this.listaMateriais = new HashMap<String, DadosMaterial>();
                                this.listaAMB = new HashMap<String, String>();
                                this.progresso = new JProgressBar(0, 100);
                                this.progresso.setMinimumSize(new Dimension(300, 20));
                                this.progresso.setPreferredSize(new Dimension(300, 20));
                                this.progresso.setStringPainted(true);
                                this.panelProgresso.add(this.progresso);
                                this.panelProgresso.revalidate();
                                this.progresso.setString("Analisando filtros...");
                                st = Conexao.getStatement();
                                stTemp = Conexao.getStatement();
                                total = null;
                                this.fireIniciouExecucao();
                                mensagemPopUp = null;
                                this.progresso.setString("Selecionando requisi\u00e7\u00f5es...");
                                sql = this.sqlFaturadas(st);
                                try {
                                    BuscaFatura.sleep(10L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                rs = Conexao.executeQuery(st, sql);
                                try {
                                    BuscaFatura.sleep(10L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                buf = new StringBuilder();
                                if (!rs.next()) ** GOTO lbl284
                                this.casasDecimais = ParametrosGerais.getCasasPrecoExame();
                                this.tipoArredondamento = ParametrosGerais.getArredondamentoPrecoExame();
                                dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, rs.getInt("conveniobase"));
                                if (!Funcoes.objectIsNull(dadosConvenio) && dadosConvenio.getConvenioUtilizarCasasDecimais()) {
                                    this.casasDecimais = dadosConvenio.getConvenioCasasPrecoExame();
                                    this.tipoArredondamento = dadosConvenio.getConvenioTipoArredondamentoPrecoRoundingMode();
                                }
                                this.ordemFatura = rs.getString("ordemFatura");
                                this.codigoConvenio = rs.getInt("con_codigo");
                                if (DBUtil.campoNull(rs.getString("fat_dtconferencia"))) ** GOTO lbl62
                                if (!this.pararSeConferida) break block53;
                                this.panelProgresso.removeAll();
                                this.panelProgresso.add(new JLabel("Fatura j\u00e1 conferida"));
                                this.panelProgresso.revalidate();
                                this.panelProgresso.repaint();
                                Conexao.fecharStatement(new Statement[]{st});
                                this.button.setEnabled(true);
                                Conexao.fecharStatement(new Statement[]{st});
                                Conexao.fecharStatement(new Statement[]{stTemp});
                                if (this.button != null) {
                                    this.button.setEnabled(true);
                                }
                                this.fireTerminouExecucao();
                                System.gc();
                                return;
                            }
                            this.conferida = true;
                            if (this.mostrarMensagemSeConferida) {
                                mensagemPopUp = "A fatura j\u00e1 foi conferida.";
                            }
lbl62:
                            // 4 sources

                            situacaoNotaFiscal = null;
                            numeroNotaFiscal = null;
                            isEletronica = false;
                            stNota = Conexao.getStatement();
                            try {
                                bufNota = new StringBuilder();
                                bufNota.append(" select nfi_situacao as situacao ");
                                bufNota.append("       ,nfi_numero as numero ");
                                bufNota.append("       ,nfi.nfi_numerorps IS NOT NULL as isEletronica ");
                                bufNota.append("   from faturanotafiscal fnf ");
                                bufNota.append("   join notafiscal nfi on fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo ");
                                bufNota.append("                  and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
                                bufNota.append("                   or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("') ) ");
                                bufNota.append("  where fnf.fil_codigo = ").append(Variaveis.filialPadrao);
                                bufNota.append("    and fnf.fat_codigo = ").append(this.codigoFatura);
                                rsNota = Conexao.executeQuery(stNota, bufNota.toString());
                                if (!rsNota.next() || rsNota.getString("situacao") == null || !rsNota.getString("situacao").equalsIgnoreCase("A") && !rsNota.getString("situacao").equalsIgnoreCase("I") && !rsNota.getString("situacao").equalsIgnoreCase("A")) break block54;
                                situacaoNotaFiscal = rsNota.getString("situacao");
                                numeroNotaFiscal = rsNota.getString("numero");
                                isEletronica = rsNota.getBoolean("isEletronica");
                            }
                            catch (Exception e) {
                                try {
                                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as notas fiscais associadas \u00e0 fatura.\n" + e.getMessage(), e.getStackTrace());
                                }
                                catch (Throwable var15_23) {
                                    Conexao.fecharStatement(new Statement[]{stNota});
                                    throw var15_23;
                                }
                                Conexao.fecharStatement(new Statement[]{stNota});
                            }
                        }
                        Conexao.fecharStatement(new Statement[]{stNota});
                        if (this.permitirAbrirConferida) break block55;
                        if (situacaoNotaFiscal == null) ** GOTO lbl139
                        c = new GridBagConstraints();
                        c.gridx = 0;
                        c.gridy = 0;
                        if (situacaoNotaFiscal.equalsIgnoreCase("A")) {
                            this.panelProgresso.removeAll();
                            this.panelProgresso.add((Component)new JLabel("A fatura possui uma nota fiscal aberta."), c);
                            ++c.gridy;
                            this.panelProgresso.add((Component)new JLabel("Estorne a nota fiscal antes de prosseguir."), c);
                            ++c.gridy;
                            this.panelProgresso.add((Component)new JLabel("Nota Fiscal n\u00famero: \"" + numeroNotaFiscal + "\"."), c);
                            this.panelProgresso.revalidate();
                            this.panelProgresso.repaint();
                        } else {
                            this.panelProgresso.removeAll();
                            this.panelProgresso.add((Component)new JLabel("A fatura possui uma nota fiscal impressa."), c);
                            ++c.gridy;
                            this.panelProgresso.add((Component)new JLabel("Cancele a nota fiscal antes de prosseguir."), c);
                            ++c.gridy;
                            this.panelProgresso.add((Component)new JLabel("Nota Fiscal n\u00famero: " + numeroNotaFiscal + "."), c);
                            this.panelProgresso.revalidate();
                            this.panelProgresso.repaint();
                        }
                        Conexao.fecharStatement(new Statement[]{st});
                        this.button.setEnabled(true);
                        Conexao.fecharStatement(new Statement[]{st});
                        Conexao.fecharStatement(new Statement[]{stTemp});
                        if (this.button != null) {
                            this.button.setEnabled(true);
                        }
                        this.fireTerminouExecucao();
                        System.gc();
                        return;
                    }
                    if (situacaoNotaFiscal != null && this.mostrarMensagemSeConferida) {
                        mensagemPopUp = mensagemPopUp != null ? mensagemPopUp + "\nA fatura possui uma ou mais notas fiscais associadas." : "A fatura possui uma ou mais notas fiscais associadas.";
                    }
lbl139:
                    // 4 sources

                    if (mensagemPopUp != null) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), mensagemPopUp, 2);
                    }
                    maximoProgresso = DBUtil.qtdeRegistros(rs);
                    this.progresso.setMaximum(maximoProgresso);
                    this.progresso.setString("Validando requisi\u00e7\u00f5es...");
                    this.tabela = new JTable();
                    this.modeloTabela = new LinhasTabela();
                    this.tabela.setModel(this.modeloTabela);
                    this.scroll = new JScrollPane(this.tabela);
                    this.tabela.setDefaultRenderer(Object.class, new EditorDadosFaturamento(this.tabela, mensagemPopUp == null ? this.showCheckBox : false, this.ordemFatura, this.isVerificarConferidos));
                    this.tabela.setDefaultEditor(Object.class, new EditorDadosFaturamento(this.tabela, mensagemPopUp == null ? this.showCheckBox : false, this.ordemFatura, this.isVerificarConferidos));
                    this.tabela.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (BuscaFatura.this.tabela.getSelectedRow() >= 0) {
                                EditorDadosFaturamento editor = (EditorDadosFaturamento)BuscaFatura.this.tabela.getCellEditor(BuscaFatura.this.tabela.getSelectedRow(), 0);
                                if (e.getKeyCode() == 32) {
                                    JCheckBox check = editor.getCheckBoxRequisicao();
                                    if (check != null) {
                                        check.doClick();
                                    }
                                } else if (e.getKeyCode() == 37) {
                                    editor.recolher();
                                    FuncoesGerais.repaintTabela(BuscaFatura.this.panel, BuscaFatura.this.tabela.getSelectedRow());
                                } else if (e.getKeyCode() == 39) {
                                    editor.expandir();
                                    FuncoesGerais.repaintTabela(BuscaFatura.this.panel, BuscaFatura.this.tabela.getSelectedRow());
                                }
                            }
                        }
                    });
                    this.tabela.setShowGrid(false);
                    buf.delete(0, buf.length());
                    buf.append("<html>Ctrl + I - informa\u00e7\u00f5es da requisi\u00e7\u00e3o<br>");
                    buf.append("F2 - localizar requisi\u00e7\u00e3o</html>");
                    this.tabela.setToolTipText(buf.toString());
                    this.modeloTabela.addLinhasRemovidasListener(this);
                    this.tabela.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (e.getKeyCode() == 113) {
                                TelaLocalizar localizar = new TelaLocalizar(BuscaFatura.this.owner);
                                localizar.adicionaCampo("Requisi\u00e7\u00e3o", "Paciente", "Matr\u00edcula", "Titular");
                                localizar.setVisible(true);
                                if (localizar.isOK()) {
                                    int campo = localizar.getPosicaoCampo();
                                    int linha = -1;
                                    String buscar = campo == 0 ? Funcoes.preencheZero(localizar.getTexto(), 8) : localizar.getTexto();
                                    for (int i = 0; i < BuscaFatura.this.tabela.getRowCount(); ++i) {
                                        DadosFaturamento dados;
                                        if (!(BuscaFatura.this.tabela.getValueAt(i, 0) instanceof DadosFaturamento) || (dados = (DadosFaturamento)BuscaFatura.this.tabela.getValueAt(i, 0)) == null) continue;
                                        if (campo == 0 && Funcoes.isNumeric(buscar) && dados.getRequisicao() == Integer.parseInt(buscar)) {
                                            linha = i;
                                            break;
                                        }
                                        if (campo == 1 && dados.getNomePaciente() != null && dados.getNomePaciente().toUpperCase().startsWith(buscar.toUpperCase())) {
                                            linha = i;
                                            break;
                                        }
                                        if (campo == 0 && dados.getMatricula() != null && dados.getMatricula().equalsIgnoreCase(buscar)) {
                                            linha = i;
                                            break;
                                        }
                                        if (campo != 0 || dados.getNomeTitular() == null || !dados.getNomeTitular().equalsIgnoreCase(buscar)) continue;
                                        linha = i;
                                        break;
                                    }
                                    if (linha > -1) {
                                        BuscaFatura.this.tabela.setRowSelectionInterval(linha, linha);
                                        BuscaFatura.this.tabela.scrollRectToVisible(BuscaFatura.this.tabela.getCellRect(linha, 0, false));
                                    }
                                }
                            } else if (e.getKeyCode() == 73 && e.isControlDown() && BuscaFatura.this.tabela.getSelectedRow() > -1 && BuscaFatura.this.tabela.getValueAt(BuscaFatura.this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento && BuscaFatura.this.owner instanceof Laboratorio) {
                                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)((Laboratorio)BuscaFatura.this.owner).getRootPane().getGlassPane();
                                InfoRequisicao info = new InfoRequisicao(BuscaFatura.this.owner, glassPaneMensagem);
                                DadosFaturamento dados = (DadosFaturamento)BuscaFatura.this.tabela.getValueAt(BuscaFatura.this.tabela.getSelectedRow(), 0);
                                info.setRequisicao(String.valueOf(dados.getCodigoFilial()), dados.getRequisicao());
                                info.setVisible(true);
                                ((Laboratorio)BuscaFatura.this.owner).getRootPane().setGlassPane(glassPaneMensagem);
                            }
                        }
                    });
                    ((EditorDadosFaturamento)this.tabela.getDefaultEditor(Object.class)).addSelecaoListener(new SelecaoListener(){

                        @Override
                        public void selecionado() {
                            Statement st = Conexao.getStatement();
                            try {
                                DadosFaturamento dados = (DadosFaturamento)BuscaFatura.this.modeloTabela.getValueAt(BuscaFatura.this.tabela.getSelectedRow(), 0);
                                Calculos.calculaTotalRequisicao(dados, BuscaFatura.this.casasDecimais, BuscaFatura.this.tipoArredondamento);
                                Calculos.calculaTotal(st, BuscaFatura.this.modeloTabela.getRowCount() - 1, BuscaFatura.this.tabela, BuscaFatura.this.modeloTabela);
                                if (!Funcoes.objectIsNull(BuscaFatura.this.labelValorRestante)) {
                                    StringBuilder mensagem = new StringBuilder("Valor restante a faturar: R$ ");
                                    mensagem.append(BuscaFatura.this.valorRestante()).append(".");
                                    BuscaFatura.this.labelValorRestante.setText(mensagem.toString());
                                    BuscaFatura.this.labelValorRestante.updateUI();
                                }
                                if (new ConvenioService().getConvenioUtilizaCotaExame("" + dados.getCodigoFilial(), BuscaFatura.this.codigoConvenio.toString())) {
                                    BuscaFatura.this.calculaCotaExame(BuscaFatura.this.modeloTabela.getRowCount() - 1);
                                }
                                BuscaFatura.this.tabela.repaint();
                            }
                            catch (Exception ex) {
                                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BuscaFatura");
                            }
                            Conexao.fecharStatement(st);
                        }
                    });
                    this.tabela.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (BuscaFatura.this.tabela.getSelectedRow() == BuscaFatura.this.tabela.getRowCount() - 1) {
                                BuscaFatura.this.tabela.getSelectionModel().clearSelection();
                            }
                        }
                    });
                    this.scroll.setBounds(5, 70, this.panel.getWidth() - 10, 200);
                    requisicaoAnterior = -1;
                    filialAnterior = -1;
                    d = new DadosFaturamento();
                    d.setCasasDecimais(this.casasDecimais);
                    d.setTipoArredondamento(this.tipoArredondamento);
                    requisicaoAdicionada = false;
                    hashColunas = new HashMap<String, Integer>();
                    rsMeta = rs.getMetaData();
                    for (j = 1; j <= rsMeta.getColumnCount(); ++j) {
                        hashColunas.put(rsMeta.getColumnName(j).toLowerCase(), j);
                    }
                    rateio = "";
                    qMicrobiologia = 0;
                    qFisicoQuimico = 0;
                    qOutros = 0;
                    qCromatografia = 0;
                    totalMicrobiologia = new BigDecimal(0);
                    totalFisicoQuimico = new BigDecimal(0);
                    totalOutros = new BigDecimal(0);
                    totalCromatografia = BigDecimal.ZERO;
                    while (rs.next()) {
                        if (total == null) {
                            total = new DadosTotalGeral();
                            total.setQtdeGuias(rs.getInt((Integer)hashColunas.get("fat_qtdeguias")));
                            total.setAdicional(rs.getBigDecimal((Integer)hashColunas.get("fat_adicional")));
                            total.setCobranca(rs.getBigDecimal((Integer)hashColunas.get("fat_despcobranca")));
                            total.setMensagem(rs.getString(hashColunas.get("fat_mensagem")));
                            total.setPercentualBonus(rs.getBigDecimal(hashColunas.get("fat_percdesconto")));
                            total.setPercentualAcrescimo(rs.getBigDecimal(hashColunas.get("fat_percacrescimo")));
                            total.setQtdeExames(rs.getInt(hashColunas.get("fat_qtdeexames")));
                            total.setQtdeRequisicoes(rs.getInt(hashColunas.get("fat_qtderequisicao")));
                            total.setTotalExames(rs.getBigDecimal(hashColunas.get("fat_totalexames")));
                            total.setTotalExamesCH(rs.getBigDecimal(hashColunas.get("fat_totalexamesch")));
                            total.setTotalMateriais(rs.getBigDecimal(hashColunas.get("fat_totalmateriais")));
                            total.setCodigoConvenio(rs.getInt(hashColunas.get("con_codigo")));
                            total.setCodigoFatura(rs.getInt(hashColunas.get("fat_codigo")));
                            total.setDescricaoAcrescimo(rs.getString(hashColunas.get("fat_descricaoacrescimo")));
                            total.setDescricaoDesconto(rs.getString(hashColunas.get("fat_descricaodesconto")));
                            total.setVencimento(rs.getDate(hashColunas.get("fat_dtvenc")));
                            total.setCasasDecimais(this.casasDecimais);
                            total.setTipoArredondamento(this.tipoArredondamento);
                            soma = total.getTotalExames().add(total.getTotalMateriais());
                            if (total.getPercentualBonus().compareTo(BigDecimal.ZERO) > 0) {
                                soma = soma.subtract(soma.multiply(total.getPercentualBonus()).divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame()));
                            }
                            total.setTotal(soma.add(total.getAdicional()).add(total.getCobranca()));
                        }
                        if (this.isOrdenaFaturaAlimentos()) {
                            if (EnumTipoRateio.isMicrobiologico(rs.getString("set_tipoalimentos"))) {
                                totalMicrobiologia = totalMicrobiologia.add(rs.getBigDecimal("fer_total"));
                                var29_39 = qMicrobiologia;
                                var30_40 = qMicrobiologia = Integer.valueOf(qMicrobiologia + 1);
                                total.setQtdeMicrobiologia(qMicrobiologia);
                                total.setTotalMicrobiologia(totalMicrobiologia);
                            }
                            if (EnumTipoRateio.isFisicoQuimico(rs.getString("set_tipoalimentos"))) {
                                totalFisicoQuimico = totalFisicoQuimico.add(rs.getBigDecimal("fer_total"));
                                var29_39 = qFisicoQuimico;
                                var30_40 = qFisicoQuimico = Integer.valueOf(qFisicoQuimico + 1);
                                total.setQtdeFiscoQuimico(qFisicoQuimico);
                                total.setTotalFisicoQuimico(totalFisicoQuimico);
                            }
                            if (EnumTipoRateio.isOutros(rs.getString("set_tipoalimentos"))) {
                                totalOutros = totalOutros.add(rs.getBigDecimal("fer_total"));
                                var29_39 = qOutros;
                                var30_40 = qOutros = Integer.valueOf(qOutros + 1);
                                total.setQtdeOutros(qOutros);
                                total.setTotalOutros(totalOutros);
                            }
                            if (EnumTipoRateio.isCromatografia(rs.getString("set_tipoalimentos"))) {
                                totalCromatografia = totalCromatografia.add(rs.getBigDecimal("fer_total"));
                                var29_39 = qCromatografia;
                                var30_40 = qCromatografia = Integer.valueOf(qCromatografia + 1);
                                total.setQtdeCromatografia(qCromatografia);
                                total.setTotalCromatografia(totalCromatografia);
                            }
                        }
                        if (filialAnterior == -1 && requisicaoAnterior == -1) {
                            filialAnterior = rs.getInt((Integer)hashColunas.get("fil_kodigo"));
                            requisicaoAnterior = rs.getInt((Integer)hashColunas.get("req_codigo"));
                            if (!requisicaoAdicionada) {
                                d.setDadosTotalGeral(total);
                                if (!rateio.equalsIgnoreCase(rs.getString("set_tipoalimentos"))) {
                                    d.setRateio(true);
                                }
                                d.setTipoRateio(rs.getString("set_tipoalimentos"));
                                rateio = d.getTipoRateio();
                                this.adicionaRequisicao(d, rs, stTemp, hashColunas);
                                requisicaoAdicionada = true;
                            }
                            this.adicionaExame(d, rs, hashColunas);
                        } else if (this.isOrdenaFaturaAlimentos() && !rateio.equalsIgnoreCase(rs.getString("set_tipoalimentos")) || filialAnterior != rs.getInt((Integer)hashColunas.get("fil_kodigo")) || requisicaoAnterior != rs.getInt((Integer)hashColunas.get("req_codigo"))) {
                            filialAnterior = rs.getInt((Integer)hashColunas.get("fil_kodigo"));
                            requisicaoAnterior = rs.getInt((Integer)hashColunas.get("req_codigo"));
                            if (d.getExamesCount() > 0) {
                                Calculos.calculaTotalRequisicao(d, this.casasDecimais, this.tipoArredondamento);
                                this.modeloTabela.adicionaLinha(d);
                            }
                            d = new DadosFaturamento();
                            if (!rateio.equalsIgnoreCase(rs.getString("set_tipoalimentos"))) {
                                d.setRateio(true);
                            }
                            d.setTipoRateio(rs.getString("set_tipoalimentos"));
                            d.setCasasDecimais(this.casasDecimais);
                            d.setTipoArredondamento(this.tipoArredondamento);
                            rateio = d.getTipoRateio();
                            d.setDadosTotalGeral(total);
                            this.adicionaRequisicao(d, rs, stTemp, hashColunas);
                            requisicaoAdicionada = true;
                            this.adicionaExame(d, rs, hashColunas);
                        } else if (filialAnterior == rs.getInt(hashColunas.get("fil_kodigo")) && requisicaoAnterior == rs.getInt(hashColunas.get("req_codigo"))) {
                            this.adicionaExame(d, rs, hashColunas);
                        }
                        this.progresso.setValue(this.progresso.getValue() + 1);
                    }
                    if (d.getExamesCount() > 0) {
                        Calculos.calculaTotalRequisicao(d, this.casasDecimais, this.tipoArredondamento);
                        this.modeloTabela.adicionaLinha(d);
                    }
                    if (total != null) {
                        this.modeloTabela.adicionaLinha(total);
                    }
                    this.panel.removeAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BuscaFatura.this.panel.setLayout(new BorderLayout());
                            BuscaFatura.this.panel.add((Component)BuscaFatura.this.scroll, "Center");
                            BuscaFatura.this.panel.revalidate();
                        }
                    });
                    this.tabela.requestFocus();
                    break block60;
lbl284:
                    // 1 sources

                    this.panelProgresso.removeAll();
                    this.panelProgresso.add(new JLabel("N\u00e3o h\u00e1 requisi\u00e7\u00f5es para a fatura selecionada"));
                    this.panelProgresso.revalidate();
                    this.panelProgresso.repaint();
                }
                if (this.modeloTabela == null) break block56;
                buf.setLength(0);
                buf.append(" select con_faturaeletronica ");
                buf.append("   from convenios ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and con_codigo = ").append(this.codigoConvenio);
                st = Conexao.getStatement();
                rsAux = Conexao.executeQuery(st, buf.toString());
                if (!rsAux.next()) ** GOTO lbl327
                xml = rsAux.getString("con_faturaeletronica");
                if (xml != null && !Funcoes.textoVazio(xml)) break block57;
                Conexao.fecharStatement(new Statement[]{st});
                Conexao.fecharStatement(new Statement[]{st});
                Conexao.fecharStatement(new Statement[]{stTemp});
                if (this.button != null) {
                    this.button.setEnabled(true);
                }
                this.fireTerminouExecucao();
                System.gc();
                return;
            }
            try {
                protocolo = StringUtil.getValor(xml, "protocolo");
                fat = FabricaFaturaEletronica.novoFaturamentoEletronico(protocolo);
                reg = ((AbstractFaturamentoEletronico)fat).parseXMLConfiguracao(xml);
                requisicoes = new ArrayList<DadosFaturamento>();
                for (i = 0; i < this.modeloTabela.getRowCount(); ++i) {
                    if (!(this.modeloTabela.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
                    requisicoes.add((DadosFaturamento)this.modeloTabela.getValueAt(i, 1));
                }
                ((AbstractFaturamentoEletronico)fat).verificaErrosFatura(requisicoes, reg);
lbl327:
                // 2 sources

                Conexao.fecharStatement(new Statement[]{st});
                break block56;
                {
                    catch (Exception ex) {
                        try {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar configura\u00e7\u00e3o de eletr\u00f4nico do conv\u00eanio.\n" + ex.getMessage(), ex.getStackTrace());
                        }
                        catch (Throwable var31_41) {
                            Conexao.fecharStatement(new Statement[]{st});
                            throw var31_41;
                        }
                        Conexao.fecharStatement(new Statement[]{st});
                    }
                }
            }
            catch (SQLException ex) {
                try {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BuscaFatura (263)");
                }
                catch (Throwable var32_42) {
                    Conexao.fecharStatement(new Statement[]{st});
                    Conexao.fecharStatement(new Statement[]{stTemp});
                    if (this.button != null) {
                        this.button.setEnabled(true);
                    }
                    this.fireTerminouExecucao();
                    System.gc();
                    throw var32_42;
                }
                Conexao.fecharStatement(new Statement[]{st});
                Conexao.fecharStatement(new Statement[]{stTemp});
                if (this.button != null) {
                    this.button.setEnabled(true);
                }
                this.fireTerminouExecucao();
                System.gc();
            }
        }
        Conexao.fecharStatement(new Statement[]{st});
        Conexao.fecharStatement(new Statement[]{stTemp});
        if (this.button != null) {
            this.button.setEnabled(true);
        }
        this.fireTerminouExecucao();
        System.gc();
    }

    private boolean isOrdenaFaturaAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A") && this.ordemFatura.equalsIgnoreCase("S");
    }

    private final String valorRestante() {
        String valor = Funcoes.formataDecimal(0);
        if (!Funcoes.objectIsNull(this.modeloTabela.getValueAt(this.modeloTabela.getRowCount() - 1, 0)) && this.modeloTabela.getValueAt(this.modeloTabela.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
            valor = Funcoes.formataDecimal(((DadosTotalGeral)this.modeloTabela.getValueAt(this.modeloTabela.getRowCount() - 1, 0)).getTotal().doubleValue());
        }
        return valor;
    }

    public void setAtualizaLabelValorRestante(JLabel label) {
        this.labelValorRestante = label;
    }

    private void calculaCotaExame(int linhaTotal) {
        try {
            ArrayList<ConvenioCotaExameBeanAux> convenioCotaExameBeanAuxs = new ArrayList<ConvenioCotaExameBeanAux>();
            BigDecimal valorAdicional = BigDecimal.ZERO;
            valorAdicional.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
            DadosTotalGeral dadosTotalGeral = (DadosTotalGeral)this.modeloTabela.getValueAt(linhaTotal, 0);
            ArrayList<ConvenioCotaExameBeanAux> examCotaMsg = new ArrayList<ConvenioCotaExameBeanAux>();
            StringBuilder msg = new StringBuilder();
            Integer codigoRequisicaoAnterior = 0;
            ArrayList<DadosExamePaiAgrupamento> listaPai = new ArrayList<DadosExamePaiAgrupamento>();
            for (int i = 0; i < this.modeloTabela.getRowCount(); ++i) {
                if (!(this.modeloTabela.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
                DadosFaturamento requisicao = (DadosFaturamento)this.modeloTabela.getValueAt(i, 0);
                ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
                Set situacoesAcordado = this.convenioService.loadCotaExameSituacao(" where fil_codigo = " + requisicao.getCodigoFilial() + " and con_codigo = " + requisicao.getCodigoConvenio() + " and sit_codigo = " + requisicao.getCodigoSituacao());
                if (!situacoesAcordado.isEmpty()) continue;
                for (DadosExameFaturamento dadosExameFaturamento : exames) {
                    if (!dadosExameFaturamento.getFaturar()) continue;
                    if (!dadosExameFaturamento.getCodigoExame().equalsIgnoreCase(dadosExameFaturamento.getExamePai().getCodigo()) || dadosExameFaturamento.getCodigoMaterial() != dadosExameFaturamento.getCodigoMaterial()) {
                        if (listaPai.contains(dadosExameFaturamento.getExamePai()) && codigoRequisicaoAnterior.intValue() == requisicao.getRequisicao()) continue;
                        if (codigoRequisicaoAnterior.intValue() != requisicao.getRequisicao()) {
                            listaPai.clear();
                        }
                        listaPai.add(dadosExameFaturamento.getExamePai());
                    }
                    ConvenioCotaExameBeanAux cotaExameBeanAux = new ConvenioCotaExameBeanAux();
                    if (listaPai != null && !listaPai.isEmpty()) {
                        cotaExameBeanAux.setCon_codigo(requisicao.getCodigoConvenio());
                        cotaExameBeanAux.setExa_codigo(dadosExameFaturamento.getExamePai().getCodigo());
                        cotaExameBeanAux.setMco_codigo(dadosExameFaturamento.getExamePai().getMaterial());
                        if (ParametrosGerais.getPrecoMetodologia() && dadosExameFaturamento.getCodigoMetodologia() != null) {
                            cotaExameBeanAux.setMet_codigo(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                        } else {
                            cotaExameBeanAux.setMet_codigo(0);
                        }
                        if (dadosExameFaturamento.getCodigoMetodologia() != null) {
                            cotaExameBeanAux.setMet_codigo_orginal(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                        } else {
                            cotaExameBeanAux.setMet_codigo_orginal(0);
                        }
                        DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(String.valueOf(requisicao.getCodigoFilial()), dadosExameFaturamento.getCodigoMaterial());
                        DadosExames dadosExames = ExameUtil.getDadosExame(String.valueOf(requisicao.getCodigoFilial()), dadosExameFaturamento.getExamePai().getCodigo(), dadosMaterial);
                        DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(String.valueOf(requisicao.getCodigoFilial()), requisicao.getCodigoConvenio());
                        ExameUtil.calculaPrecoExame(String.valueOf(requisicao.getCodigoFilial()), dadosExames, dadosMaterial, dadosConvenios, false, true, true, null, null, Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                        cotaExameBeanAux.setValorTotalExame(dadosExames.getValorExame());
                        if (!convenioCotaExameBeanAuxs.contains(cotaExameBeanAux)) {
                            cotaExameBeanAux.somaQuantidadeExame();
                            convenioCotaExameBeanAuxs.add(cotaExameBeanAux);
                        } else {
                            int posicao = convenioCotaExameBeanAuxs.indexOf(cotaExameBeanAux);
                            ((ConvenioCotaExameBeanAux)convenioCotaExameBeanAuxs.get(posicao)).somaQuantidadeExame();
                        }
                    } else {
                        cotaExameBeanAux.setCon_codigo(requisicao.getCodigoConvenio());
                        cotaExameBeanAux.setExa_codigo(dadosExameFaturamento.getCodigoExame());
                        cotaExameBeanAux.setMco_codigo(dadosExameFaturamento.getCodigoMaterial());
                        cotaExameBeanAux.setDadosExamePai(dadosExameFaturamento.getExamePai());
                        if (ParametrosGerais.getPrecoMetodologia() && dadosExameFaturamento.getCodigoMetodologia() != null) {
                            cotaExameBeanAux.setMet_codigo(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                        } else {
                            cotaExameBeanAux.setMet_codigo(0);
                        }
                        if (dadosExameFaturamento.getCodigoMetodologia() != null) {
                            cotaExameBeanAux.setMet_codigo_orginal(Integer.parseInt(dadosExameFaturamento.getCodigoMetodologia()));
                        } else {
                            cotaExameBeanAux.setMet_codigo_orginal(0);
                        }
                        cotaExameBeanAux.setValorTotalExame(dadosExameFaturamento.getValorTotalExame());
                        if (!convenioCotaExameBeanAuxs.contains(cotaExameBeanAux)) {
                            cotaExameBeanAux.somaQuantidadeExame();
                            convenioCotaExameBeanAuxs.add(cotaExameBeanAux);
                        } else {
                            int posicao = convenioCotaExameBeanAuxs.indexOf(cotaExameBeanAux);
                            ((ConvenioCotaExameBeanAux)convenioCotaExameBeanAuxs.get(posicao)).somaQuantidadeExame();
                        }
                    }
                    if (codigoRequisicaoAnterior.intValue() == requisicao.getRequisicao()) continue;
                    codigoRequisicaoAnterior = requisicao.getRequisicao();
                }
            }
            List<ConvenioCotaExameBeanAux> acordados = this.exameService.getAcordados(this.codigoConvenio.toString());
            for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : convenioCotaExameBeanAuxs) {
                List<ConvenioCotaExameBeanAux> exameCota = this.exameService.obterCotaExame(convenioCotaExameBeanAux);
                Integer qtdRealizada = convenioCotaExameBeanAux.getCct_quantidade();
                for (ConvenioCotaExameBeanAux map : exameCota) {
                    Integer qtdAcordada = map.getCct_quantidade();
                    Integer diferenca = qtdAcordada - qtdRealizada;
                    if (diferenca > 0) {
                        valorAdicional = valorAdicional.add(convenioCotaExameBeanAux.getValorTotalExame().multiply(new BigDecimal(diferenca)));
                        convenioCotaExameBeanAux.setAcordada(qtdAcordada);
                        convenioCotaExameBeanAux.setDiferenca(diferenca);
                        examCotaMsg.add(convenioCotaExameBeanAux);
                    }
                    acordados.remove(map);
                }
            }
            for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : acordados) {
                DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getMco_codigo());
                DadosExames dadosExames = ExameUtil.getDadosExame(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getExa_codigo(), dadosMaterial);
                DadosConvenios dadosConvenios = ConvenioUtil.getDadosConvenios(convenioCotaExameBeanAux.getFil_codigo().toString(), convenioCotaExameBeanAux.getCon_codigo());
                ExameUtil.calculaPrecoExame(convenioCotaExameBeanAux.getFil_codigo().toString(), dadosExames, dadosMaterial, dadosConvenios, false, true, true, null, null, convenioCotaExameBeanAux.getMet_codigo_orginal());
                valorAdicional = valorAdicional.add(dadosExames.getValorExame().multiply(new BigDecimal(convenioCotaExameBeanAux.getCct_quantidade())));
                convenioCotaExameBeanAux.setAcordada(convenioCotaExameBeanAux.getCct_quantidade());
                convenioCotaExameBeanAux.setDiferenca(convenioCotaExameBeanAux.getCct_quantidade());
                convenioCotaExameBeanAux.setCct_quantidade(0);
                examCotaMsg.add(convenioCotaExameBeanAux);
            }
            dadosTotalGeral.reprocessaAdicional(valorAdicional);
            if (!examCotaMsg.isEmpty()) {
                msg.append("O valor adicional refere-se aos exames: ");
                for (ConvenioCotaExameBeanAux convenioCotaExameBeanAux : examCotaMsg) {
                    msg.append(convenioCotaExameBeanAux.getExa_codigo()).append(" ");
                    msg.append("(cota contratada ").append(convenioCotaExameBeanAux.getAcordada()).append(", ");
                    msg.append("cota atingida ").append(convenioCotaExameBeanAux.getCct_quantidade()).append(", ");
                    msg.append("diferenca ").append(convenioCotaExameBeanAux.getDiferenca()).append(") ");
                }
                msg.append("que n\u00e3o atingiram o valor m\u00ednimo contratado.");
                dadosTotalGeral.setMensagem(!Funcoes.textoVazio(dadosTotalGeral.getMensagem().trim()) ? " " + msg.toString() : msg.toString());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel recalcular cotas de exames", e.getStackTrace());
        }
    }

    private void adicionaRequisicao(DadosFaturamento d, ResultSet rs, Statement st, HashMap<String, Integer> hashColunas) throws SQLException {
        d.setCodigoFilial(rs.getInt(hashColunas.get("fil_kodigo")));
        d.setCnpjFilial(rs.getString(hashColunas.get("fil_cnpj")));
        d.setRazaoSocialFilial(rs.getString(hashColunas.get("fil_razaosocial")));
        int codigoDaFilial = rs.getInt(hashColunas.get("fil_codigo"));
        d.setRequisicao(codigoDaFilial);
        d.setFaturar(true);
        d.setRequisicaoExpandida(true);
        d.setGuiaConferida(rs.getBoolean(hashColunas.get("guiaconferida")));
        int codigoDoConvenio = rs.getInt(hashColunas.get("con_codigo"));
        d.setCodigoConvenio(codigoDoConvenio);
        d.setConvenioRazao(rs.getString(hashColunas.get("con_razao")));
        d.setConvenioFantasia(rs.getString(hashColunas.get("con_fantasia")));
        d.setNomeMedico(rs.getString(hashColunas.get("med_nome")));
        d.setCRMMedico(rs.getString(hashColunas.get("med_crm")));
        d.setUFMedico(rs.getString(hashColunas.get("med_uf")));
        d.setConselhoMedico(rs.getString(hashColunas.get("med_conselho")));
        String cbosDoMedico = rs.getString("med_cbo");
        if (Funcoes.textoVazio(cbosDoMedico)) {
            try {
                cbosDoMedico = this.buscaCbosDoConvenio(codigoDaFilial, codigoDoConvenio);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        d.setXmlCbo(cbosDoMedico);
        d.setValorBalcao(rs.getBigDecimal(hashColunas.get("con_percpgto")));
        d.setNomePaciente(rs.getString(hashColunas.get("pac_nome")));
        d.setCodigoPaciente(rs.getInt(hashColunas.get("pac_codigo")));
        d.setDataRequisicao(rs.getDate(hashColunas.get("req_data")));
        d.setDataFaturaRequisicao(rs.getDate(hashColunas.get("req_dtfatura")));
        d.setHoraRequisicao(rs.getTime(hashColunas.get("req_hora")));
        d.setHoraFaturaRequisicao(rs.getTime(hashColunas.get("req_horafatura")));
        d.setRequisicao(rs.getInt(hashColunas.get("req_codigo")));
        d.setCodigoColeta(rs.getString(hashColunas.get("col_codigo")));
        d.setCodigoDestino(rs.getString(hashColunas.get("des_codigo")));
        d.setCodigoSituacao(DBUtil.campoNull(rs.getString(hashColunas.get("sit_codigo"))) ? -1 : rs.getInt(hashColunas.get("sit_codigo")));
        d.setDescricaoSituacao(rs.getString(hashColunas.get("sit_descricao")));
        d.setDescricaoColeta(rs.getString(hashColunas.get("col_descricao")));
        d.setDescricaoDestino(rs.getString(hashColunas.get("des_descricao")));
        d.setNomeTitular(rs.getString(hashColunas.get("req_titular")));
        d.setFaturarFaltaMaterial(rs.getBoolean(hashColunas.get("con_fatfmaterial")));
        d.setFaturarRecoleta(rs.getBoolean(hashColunas.get("con_faturarrecoleta")));
        d.setValorMulta(rs.getBigDecimal(hashColunas.get("con_multa")));
        d.setValorMora(rs.getBigDecimal(hashColunas.get("con_mora")));
        d.setValorBonus(rs.getBigDecimal(hashColunas.get("con_bonus")));
        d.setValorAcrescimo(rs.getBigDecimal(hashColunas.get("con_acrescimo")));
        d.setTipoCalculoFatura(rs.getString(hashColunas.get("con_tpcalcfatu")));
        d.setTipoCalculoCH(rs.getString(hashColunas.get("con_tpcalcch")));
        d.setCobrarMaterial(rs.getBoolean(hashColunas.get("con_cobrmaterial")));
        d.setPercentualBalcaoMaterial(rs.getBigDecimal(hashColunas.get("con_percpgtomaterial")));
        d.setValorCHConvenio(rs.getBigDecimal(hashColunas.get("con_valorch")));
        d.setOrdemFatura(rs.getString(hashColunas.get("con_ordemfatura")));
        d.setTitularDependente(rs.getString(hashColunas.get("con_titdep")));
        d.setFaturarFiliais(rs.getBoolean(hashColunas.get("con_fatfiliais")));
        d.setCnpjCpf(rs.getString(hashColunas.get("con_cnpjcpf")));
        d.setDeveGuia(rs.getBoolean(hashColunas.get("req_deveguia")));
        d.setCodigoAla(rs.getString(hashColunas.get("ala_codigo")));
        d.setDescricaoAla(rs.getString(hashColunas.get("ala_descricao")));
        d.setQuarto(rs.getString(hashColunas.get("req_quarto")));
        d.setLeito(rs.getString(hashColunas.get("req_leito")));
        d.setTabelaTipoCBHPM(rs.getBoolean(hashColunas.get("tpe_tipocbhpm")));
        d.setTipoTabela(TabelaANS.TiposTabela.getTipo(rs.getString(hashColunas.get("tpe_tabelaans")) == null ? "" : rs.getString(hashColunas.get("tpe_tabelaans"))));
        d.setCodigoTabelaPreco(rs.getInt(hashColunas.get("tpe_codigo")));
        d.setDataInicioFatura(rs.getDate(hashColunas.get("fat_dtinicio")));
        d.setDataFinalFatura(rs.getDate(hashColunas.get("fat_dtfim")));
        d.setCidadeConvenio(rs.getString(hashColunas.get("cid_nome")));
        d.setUfConvenio(rs.getString("cid_uf"));
        d.setCodigoConvenioPrincipal(rs.getInt(hashColunas.get("codigoconvenioprincipal")));
        d.setRazaoConvenioPrincipal(rs.getString(hashColunas.get("razaoconvenioprincipal")));
        d.setFantasiaConvenioPrincipal(rs.getString(hashColunas.get("fantasiaconvenioprincipal")));
        d.setBairroPaciente(rs.getString("bai_codigo"));
        d.setEnderecoPaciente(rs.getString("pac_endereco"));
        d.setComplementoEndereco(rs.getString("pac_complemento"));
        d.setLogradouroPaciente(rs.getString("pac_tipologradouroendereco"));
        d.setCepPaciente(rs.getString("pac_cep"));
        d.setCidadePaciente(rs.getString("cid_codigo"));
        d.setCidadePacienteNome(rs.getString("cidadepaciente"));
        d.setCodigoIbge(rs.getString("cid_codigoibge"));
        d.setBairroPacienteDescricao(rs.getString("bai_descricao"));
        d.setNumeroEndereco(rs.getString("pac_numeroendereco"));
        d.setCnsPaciente(rs.getString("req_cartaosus"));
        if (codigoDoConvenio == rs.getInt(hashColunas.get("con_codrepasse"))) {
            d.setGuiaRepasse(rs.getString(hashColunas.get("req_guiarepasse")));
            d.setValidadeGuiaRepasse(rs.getDate(hashColunas.get("req_validadeguiarepasse")));
            d.setGuiaPrincipal(rs.getString(hashColunas.get("req_guiaprincipalrepasse")));
            d.setMatricula(rs.getString(hashColunas.get("req_matricularepasse")));
            d.setNomePlano(rs.getString(hashColunas.get("req_nomeplanorepasse")));
            d.setValidadeCarteira(rs.getDate(hashColunas.get("req_validadecarteirarepasse")));
        } else {
            d.setGuia(rs.getString(hashColunas.get("req_guia")));
            d.setGuiaPrincipal(rs.getString(hashColunas.get("req_guiaprincipal")));
            d.setMatricula(rs.getString(hashColunas.get("req_matricula")));
            d.setNomePlano(rs.getString(hashColunas.get("req_nomeplano")));
            d.setValidadeCarteira(rs.getDate(hashColunas.get("req_validadecarteira")));
        }
        String nomeProtocolo = rs.getString(hashColunas.get("con_faturaeletronica"));
        if (!Funcoes.textoVazio(nomeProtocolo) && (nomeProtocolo = StringUtil.getValor(nomeProtocolo, "protocolo")) != null && !Funcoes.textoVazio(nomeProtocolo)) {
            d.setProtocoloEletronico(nomeProtocolo);
        }
        d.setCodigoMedicoOperadora(rs.getString(hashColunas.get("mec_codigooperadora")));
        d.setFaturaEletronica(rs.getString(hashColunas.get("con_faturaeletronica")));
        d.setNomeProtocolo(nomeProtocolo);
        d.setCpfMedico(rs.getString(hashColunas.get("med_cpf")));
        d.setCodigoCnesExecutante(rs.getString(hashColunas.get("fil_cnes")));
        d.setNacionalidadePaciente(rs.getString(hashColunas.get("nli_codigo")));
        d.setRacaCorPaciente(rs.getString(hashColunas.get("pac_cor")));
        d.setDadosAlterados(false, true);
        this.adicionarRequisicaoSemPedidoGuia(d);
    }

    private void adicionarRequisicaoSemPedidoGuia(DadosFaturamento dadosFaturamento) {
        if (dadosFaturamento.getDeveGuia()) {
            Registro registro = new Registro();
            registro.setValor("deveGuia", dadosFaturamento.getDeveGuia());
            registro.setValor("codigoFilial", dadosFaturamento.getCodigoFilial());
            registro.setValor("codigoRequisicao", dadosFaturamento.getRequisicao());
            this.requisicoesSemPedidoGuia.add(registro);
        }
    }

    private String buscaCbosDoConvenio(int codigoDaFilial, int codigoDoConvenio) throws ThreadDaoException {
        HashMap<String, Object> condicoesParaBuscarOBean = new HashMap<String, Object>();
        condicoesParaBuscarOBean.put("fil_codigo", codigoDaFilial);
        condicoesParaBuscarOBean.put("con_codigo", codigoDoConvenio);
        ConvenioBean bean = (ConvenioBean)this.convenioService.getBean(condicoesParaBuscarOBean);
        String faturaEletronica = bean.getFaturaEletronica();
        String tagDoCBOPadrao = "CBOPadrao";
        String CBOSPadraoDoConvenio = StringUtil.getValor(faturaEletronica, tagDoCBOPadrao);
        return CBOSPadraoDoConvenio;
    }

    private void adicionaExame(DadosFaturamento d, ResultSet rs, HashMap<String, Integer> hashColunas) throws SQLException {
        Statement st = Conexao.getStatement();
        if (!DBUtil.campoNull(rs.getString(hashColunas.get("exr_datacortesia")))) {
            return;
        }
        if (this.localizaExame(d, rs.getString(hashColunas.get("exa_codigo")), rs.getInt(hashColunas.get("mco_codigo")))) {
            return;
        }
        DadosExameFaturamento dados = new DadosExameFaturamento(rs.getString(hashColunas.get("exa_codigo")));
        dados.setCodigoMaterial(rs.getInt(hashColunas.get("mco_codigo")));
        dados.setCodigoAutorizacao(rs.getString(hashColunas.get("exr_codautorizacao")));
        dados.setDataAutorizacao(rs.getDate(hashColunas.get("exr_dataautorizacao")));
        dados.setValidadeAutorizacao(rs.getDate(hashColunas.get("exr_datavalidadeautorizacao")));
        dados.setNomeExame(rs.getString(hashColunas.get("exa_descricao")));
        dados.setDataExame(rs.getDate(hashColunas.get("exr_data")));
        dados.setDataColeta(rs.getDate(hashColunas.get("exr_datamaterial")));
        dados.setDataConferencia(rs.getDate(hashColunas.get("exr_dataassina")));
        dados.setCodigoUsuarioExame(rs.getString(hashColunas.get("usr_codigo")));
        dados.setDescricaoMaterial(rs.getString(hashColunas.get("mco_descricao")));
        dados.setAbreviaturaMaterial(rs.getString(hashColunas.get("mco_abreviatura")));
        dados.setCodigoAMB(rs.getString(hashColunas.get("codigoamb")));
        dados.setCodigoCBHPM(rs.getString(hashColunas.get("codigocbhpm")));
        dados.setMotivoPrazo(rs.getString(hashColunas.get("exr_motivoprazo")));
        dados.setSituacaoExame(rs.getString(hashColunas.get("exr_situacao")));
        dados.setCodigoMetodologia(rs.getString(hashColunas.get("met_codigo")));
        dados.setTipoBPA(rs.getString("exa_tipobpa"));
        dados.setTipoAlimentos(rs.getString("set_tipoalimentos"));
        if (d.getCobrarMaterial()) {
            this.pegaMateriais(d, dados);
        }
        if (!DBUtil.campoNull(rs.getString(hashColunas.get("exa_codfilho"))) || !Funcoes.textoVazio(rs.getString(hashColunas.get("exa_codfilho")))) {
            DadosExames exm;
            DadosExamePaiAgrupamento pai = new DadosExamePaiAgrupamento(rs.getString(hashColunas.get("exa_codigo")), rs.getInt(hashColunas.get("mco_codigo")));
            DadosMaterial dadosMaterial = this.listaMateriais.get(rs.getString(hashColunas.get("fil_kodigo")) + "." + rs.getInt(hashColunas.get("mco_codfilho")));
            if (dadosMaterial == null) {
                dadosMaterial = ExameUtil.getDadosMaterial(rs.getString(hashColunas.get("fil_kodigo")), rs.getInt(hashColunas.get("mco_codfilho")));
                this.listaMateriais.put(rs.getString(hashColunas.get("fil_kodigo")) + "." + rs.getInt(hashColunas.get("mco_codfilho")), dadosMaterial);
            }
            if ((exm = this.listaExames.get(rs.getString(hashColunas.get("fil_kodigo")) + "." + rs.getString(hashColunas.get("exa_codfilho")) + "." + dadosMaterial.getCodigo())) == null) {
                exm = ExameUtil.getDadosExame(rs.getString(hashColunas.get("fil_kodigo")), rs.getString(hashColunas.get("exa_codfilho")), dadosMaterial);
                this.listaExames.put(rs.getString(hashColunas.get("fil_kodigo")) + "." + rs.getString(hashColunas.get("exa_codfilho")) + "." + dadosMaterial.getCodigo(), exm);
            }
            dados.setCodigoExame(rs.getString(hashColunas.get("exa_codfilho")));
            dados.setCodigoMaterial(rs.getInt(hashColunas.get("mco_codfilho")));
            dados.setCodigoAutorizacao(rs.getString(hashColunas.get("exr_codautorizacao")));
            dados.setNomeExame(exm.getDescricao());
            dados.setDataExame(rs.getDate(hashColunas.get("exr_data")));
            dados.setCodigoUsuarioExame(rs.getString(hashColunas.get("usr_codigo")));
            dados.setDescricaoMaterial(dadosMaterial.getDescricao());
            dados.setAbreviaturaMaterial(dadosMaterial.getAbreviatura());
            dados.setTipoBPA(rs.getString("exa_tipobpa"));
            String amb = this.listaAMB.get(rs.getString(hashColunas.get("fil_kodigo")) + "." + rs.getString(hashColunas.get("exa_codfilho")) + "." + rs.getInt(hashColunas.get("mco_codfilho")) + "." + rs.getInt(hashColunas.get("con_codigo")) + (rs.getString(hashColunas.get("met_codigo")) == null ? "" : "." + rs.getInt(hashColunas.get("met_codigo"))));
            if (amb == null) {
                amb = ExameUtil.getCodigoAMB(rs.getString(hashColunas.get("fil_kodigo")), rs.getString(hashColunas.get("exa_codfilho")), rs.getInt(hashColunas.get("mco_codfilho")), rs.getInt(hashColunas.get("con_codigo")), rs.getString(hashColunas.get("met_codigo")) == null ? null : Integer.valueOf(rs.getInt(hashColunas.get("met_codigo"))));
            }
            dados.setCodigoAMB(amb);
            dados.setCodigoCBHPM(exm.getCBHPM());
            dados.setMotivoPrazo(rs.getString(hashColunas.get("exr_motivoprazo")));
            dados.setSituacaoExame(rs.getString(hashColunas.get("exr_situacao")));
            dados.setExamePai(pai, true);
            dados.setCodigoGuia(rs.getString(hashColunas.get("exr_guia")));
            dados.setDataGuia(rs.getDate(hashColunas.get("exr_dataguia")));
            dados.setValidadeGuia(rs.getDate(hashColunas.get("exr_validadeguia")));
            dados.setDeveGuia(rs.getBoolean(hashColunas.get("exr_deveguia")));
        }
        dados.setCasasDecimais(this.casasDecimais);
        dados.setTipoArredondamento(this.tipoArredondamento);
        dados.setValorExame(rs.getBigDecimal(hashColunas.get("fer_total")));
        dados.setValorTotalExame(rs.getBigDecimal(hashColunas.get("fer_total")));
        dados.setValorCHExame(rs.getBigDecimal(hashColunas.get("fer_totalch")));
        dados.setValorCH(rs.getBigDecimal(hashColunas.get("fer_valorch")));
        dados.setValorBalcao(rs.getBigDecimal(hashColunas.get("fer_vlrbalcaoconvenio")));
        dados.setValorMaterial(rs.getBigDecimal(hashColunas.get("exr_vlrmaterial")));
        if (!DBUtil.campoNull(rs.getString(hashColunas.get("fer_notaipergs")))) {
            dados.setNotaIPERGS(rs.getInt(hashColunas.get("fer_notaipergs")));
        }
        dados.setDadosAlterados(false, true);
        d.adicionaExame(dados);
    }

    private boolean localizaExame(DadosFaturamento d, String exame, int material) {
        for (int i = 0; i < d.getExamesCount(); ++i) {
            DadosExameFaturamento exm = d.getExame(i);
            if (!exm.getCodigoExame().equals(exame) || exm.getCodigoMaterial() != material) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pegaMateriais(DadosFaturamento d, DadosExameFaturamento dados) throws SQLException {
        Statement stMaterial = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.mat_codigo, a.mer_qtde, a.mer_valor, ");
        buf.append("b.mat_descricao, b.mat_valorunit, c.mex_cobrarbalcao ");
        buf.append("from materialexamerequis a ");
        buf.append("left join material b on a.fil_codigo = b.fil_codigo and a.mat_codigo = b.mat_codigo ");
        buf.append("left join materialexame c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and a.mat_codigo = c.mat_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(d.getCodigoFilial());
        buf.append(" and a.req_codigo = ");
        buf.append(d.getRequisicao());
        buf.append(" and a.exa_codigo = '");
        buf.append(dados.getCodigoExame());
        buf.append("' and a.mco_codigo = ");
        buf.append(String.valueOf(dados.getCodigoMaterial()));
        buf.append("order by a.mat_codigo ");
        try (ResultSet rsMaterial = null;){
            rsMaterial = stMaterial.executeQuery(buf.toString());
            while (rsMaterial.next()) {
                DadosMaterialFaturamento mat = new DadosMaterialFaturamento();
                mat.setCodigo(rsMaterial.getInt("mat_codigo"));
                mat.setDescricao(rsMaterial.getString("mat_descricao"));
                BigDecimal valor = d.getTipoCalculoFatura().equals("T") ? rsMaterial.getBigDecimal("mat_valorunit") : rsMaterial.getBigDecimal("mer_valor");
                if (d.getPercentualBalcaoMaterial() != null && d.getPercentualBalcaoMaterial().compareTo(BigDecimal.ZERO) > 0 && !DBUtil.campoNull(rsMaterial.getString("mex_cobrarbalcao")) && rsMaterial.getBoolean("mex_cobrarbalcao")) {
                    valor = valor.subtract(valor.multiply(d.getPercentualBalcaoMaterial()).divide(new BigDecimal(100), ParametrosGerais.getArredondamentoPrecoExame()));
                }
                mat.setValor(valor);
                mat.setQuantidade(rsMaterial.getBigDecimal("mer_qtde"));
                dados.adicionaMaterial(mat);
            }
        }
        Conexao.fecharStatement(stMaterial);
    }

    private void mostraMensagem(String mensagem) {
        JLabel label = new JLabel(mensagem);
        this.panelMensagens.add(label);
        label.setBounds(10, this.linha, 350, 25);
        this.panelMensagens.revalidate();
        this.panelMensagens.getTopLevelAncestor().repaint();
        this.linha += 15;
    }

    @Override
    public void linhaRemovida() {
        Statement st = Conexao.getStatement();
        try {
            Calculos.calculaTotal(st, this.modeloTabela.getRowCount() - 1, this.tabela, this.modeloTabela);
            this.tabela.repaint();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BuscaFatura");
        }
        Conexao.fecharStatement(st);
    }

    public void setCodigoFatura(String codigo) {
        this.codigoFatura = codigo;
    }

    public boolean getConferida() {
        return this.conferida;
    }

    public void setPararSeConferida(boolean b) {
        this.pararSeConferida = b;
    }

    private String sqlFaturadas(Statement st) throws SQLException {
        String ordemFatura = "R";
        String codigoConvenioBase = "0";
        StringBuilder sb = new StringBuilder();
        sb.append("select con_codigo from fatura where fil_codigo = ");
        sb.append(Variaveis.filialPadrao);
        sb.append(" and fat_codigo = ");
        sb.append(this.codigoFatura);
        sb.append(" and fat_datacancelamento is null ");
        ResultSet rsOrdem = Conexao.executeQuery(st, sb.toString());
        sb.delete(0, sb.length());
        if (rsOrdem.next()) {
            codigoConvenioBase = rsOrdem.getString("con_codigo");
            sb.append("select con_ordemfatura from convenios where fil_codigo = ");
            sb.append(Variaveis.filialPadrao);
            sb.append(" and con_codigo = ");
            sb.append(codigoConvenioBase);
        }
        rsOrdem.close();
        if (sb.length() > 0) {
            rsOrdem = Conexao.executeQuery(st, sb.toString());
            if (rsOrdem.next()) {
                ordemFatura = rsOrdem.getString("con_ordemfatura");
            }
            rsOrdem.close();
        }
        StringBuilder buf = new StringBuilder("");
        buf.append("select freq.con_codigo ");
        buf.append("      ,").append(codigoConvenioBase).append(" as conveniobase");
        buf.append("      ,b.req_codigo ");
        buf.append("      ,fexr.fil_codigo ");
        buf.append("      ,g.con_razao ");
        buf.append("      ,g.con_fantasia ");
        buf.append("      ,ent.ent_razaosocial ");
        buf.append("      ,f.med_nome ");
        buf.append("      ,g.con_percpgtomaterial ");
        buf.append("      ,f.med_cpf ");
        buf.append("      ,f.med_crm ");
        buf.append("      ,f.med_uf ");
        buf.append("      ,mec.mec_codigooperadora ");
        buf.append("      ,fexr.fer_total ");
        buf.append("      ,fexr.fer_totalch ");
        buf.append("      ,freq.fil_kodigo ");
        buf.append("      ,fil.fil_cnpj ");
        buf.append("      ,fil.fil_razaosocial ");
        buf.append("      ,fil.fil_cnes ");
        buf.append("      ,g.con_faturaeletronica ");
        buf.append("      ,fexr.fer_valorch ");
        buf.append("      ,b.req_matricula ");
        buf.append("      ,b.req_nomeplano ");
        buf.append("      ,a.fat_codigo ");
        buf.append("      ,a.fat_mensagem ");
        buf.append("      ,a.fat_adicional ");
        buf.append("      ,a.fat_despcobranca ");
        buf.append("      ,a.fat_percdesconto ");
        buf.append("      ,a.fat_percacrescimo ");
        buf.append("      ,a.fat_dtconferencia ");
        buf.append("      ,a.fat_totalmateriais ");
        buf.append("      ,a.fat_totalexamesch ");
        buf.append("      ,a.fat_totalexames ");
        buf.append("      ,a.fat_qtderequisicao ");
        buf.append("      ,a.fat_qtdeexames ");
        buf.append("      ,a.fat_descricaodesconto ");
        buf.append("      ,a.fat_descricaoacrescimo ");
        buf.append("      ,a.fat_dtvenc ");
        buf.append("      ,a.fat_dtinicio ");
        buf.append("      ,a.fat_dtfim ");
        buf.append("      ,f.med_conselho ");
        buf.append("      ,f.med_cbo ");
        buf.append("      ,fexr.fer_totalmateriais as exr_vlrmaterial ");
        buf.append("      ,fexr.fer_vlrbalcaoconvenio ");
        buf.append("      ,j.pac_nome, fexr.exa_codigo ");
        buf.append("      ,fexr.mco_codigo ");
        buf.append("      ,fexr.exa_codfilho ");
        buf.append("      ,fexr.mco_codfilho ");
        buf.append("      ,b.req_data ");
        buf.append("      ,b.req_dtfatura ");
        buf.append("      ,b.req_hora ");
        buf.append("      ,b.req_horafatura ");
        buf.append("      ,(b.req_dataguiaconferida is not null) as guiaconferida ");
        buf.append("      ,b.col_codigo ");
        buf.append("      ,b.des_codigo ");
        buf.append("      ,b.sit_codigo ");
        buf.append("      ,m.emc_codigocbhpm as codigoCBHPM ");
        buf.append("      ,h.sit_descricao ");
        buf.append("      ,k.col_descricao ");
        buf.append("      ,l.des_descricao ");
        buf.append("      ,b.req_titular ");
        buf.append("      ,g.con_percpgto ");
        buf.append("      ,g.con_fatfmaterial ");
        buf.append("      ,g.con_faturarrecoleta ");
        buf.append("      ,g.con_multa ");
        buf.append("      ,g.con_mora ");
        buf.append("      ,g.con_bonus ");
        buf.append("      ,g.con_acrescimo ");
        buf.append("      ,g.con_tpcalcfatu ");
        buf.append("      ,g.con_tpcalcch ");
        buf.append("      ,g.con_cobrmaterial ");
        buf.append("      ,g.con_valorch ");
        buf.append("      ,g.con_ordemfatura ");
        buf.append("      ,g.con_titdep ");
        buf.append("      ,g.con_fatfiliais ");
        buf.append("      ,g.con_cnpjcpf ");
        buf.append("      ,cidconv.cid_nome ");
        buf.append("      ,cidconv.cid_uf ");
        buf.append("      ,'").append(ordemFatura).append("' as ordemFatura ");
        buf.append("      ,b.req_deveguia ");
        buf.append("      ,b.req_quarto ");
        buf.append("      ,b.req_leito ");
        buf.append("      ,b.ala_codigo ");
        buf.append("      ,ala.ala_descricao ");
        buf.append("      ,t.tpe_codigo ");
        buf.append("      ,t.tpe_uco ");
        buf.append("      ,t.tpe_tipocbhpm ");
        buf.append("      ,t.tpe_tabelaans ");
        buf.append("      ,fexr.fer_notaipergs ");
        buf.append("      ,b.con_codrepasse ");
        buf.append("      ,b.req_guia ");
        buf.append("      ,b.req_guiaprincipal ");
        buf.append("      ,b.req_validadeguia ");
        buf.append("      ,b.req_guiarepasse ");
        buf.append("      ,b.req_guiaprincipalrepasse ");
        buf.append(" \t\t\t,b.req_matricularepasse ");
        buf.append(" \t\t\t,b.req_nomeplanorepasse ");
        buf.append(" \t\t\t,b.req_validadeguiarepasse ");
        buf.append("      ,b.req_validadecarteira ");
        buf.append("      ,b.req_validadecarteirarepasse ");
        buf.append("      ,b.req_cartaosus ");
        buf.append(" \t\t\t,COALESCE(conprinc.con_codigo, g.con_codigo) as codigoConvenioPrincipal ");
        buf.append(" \t\t\t,COALESCE(conprinc.con_razao, g.con_razao) as razaoConvenioPrincipal ");
        buf.append(" \t\t\t,COALESCE(conprinc.con_fantasia, g.con_fantasia) as fantasiaConvenioPrincipal ");
        buf.append("      ,fexr.met_codigo ");
        buf.append("      ,CASE WHEN g.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(b.req_titular), ''), j.pac_nome) ELSE j.pac_nome END as ordemPaciente ");
        buf.append("      ,exr.exa_codigo ");
        buf.append("      ,exr.exr_data ");
        buf.append("      ,exr.exr_dataassina ");
        buf.append("      ,exr.exr_datamaterial ");
        buf.append("      ,exr.exr_vlrmaterial ");
        buf.append("\t\t  ,exr.exr_codautorizacao ");
        buf.append("\t\t  ,exr.exr_dataautorizacao ");
        buf.append("\t\t  ,exr.exr_datavalidadeautorizacao ");
        buf.append("      ,exr.mco_codigo ");
        buf.append("      ,exr.usr_codigo ");
        buf.append("      ,exa.exa_descricao ");
        buf.append("      ,exa.exa_tipobpa ");
        buf.append("      ,mco.mco_descricao ");
        buf.append("      ,mco.mco_abreviatura ");
        buf.append("       ,d.set_codigo ");
        buf.append("       ,set.set_tipoalimentos ");
        buf.append("      ,exr.exr_situacao ");
        buf.append("      ,exr.exr_datacortesia ");
        buf.append("      ,exr.exr_motivoprazo ");
        buf.append("      ,exr.exr_situacao ");
        buf.append("      ,COALESCE(exg.exg_guia, exr.exr_guia) as exr_guia ");
        buf.append("      ,COALESCE(exg.exg_dataguia, exr.exr_dataguia) as exr_dataguia ");
        buf.append("      ,COALESCE(exg.exg_validadeguia, exr.exr_validadeguia) as exr_validadeguia ");
        buf.append("      ,COALESCE(exg.exg_deveguia, exr.exr_deveguia) as exr_deveguia ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("      ,COALESCE(dtm.dtm_valor, n.dtp_valor) as dtp_valor ");
            buf.append("      ,COALESCE(NULLIF(dtm.dtm_codamb, ''), n.dtp_codamb) as codigoAMB ");
        } else {
            buf.append("      ,n.dtp_valor ");
            buf.append("      ,n.dtp_codamb as codigoAMB ");
        }
        buf.append("       ,CASE WHEN g.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(b.req_titular), ''), j.pac_nome) ELSE j.pac_nome end ");
        buf.append("       ,j.pac_codigo ");
        buf.append("       ,j.pac_endereco ");
        buf.append("       ,j.pac_tipologradouroendereco ");
        buf.append("       ,j.pac_cep ");
        buf.append("       ,j.bai_codigo ");
        buf.append("       ,j.cid_codigo ");
        buf.append("       ,j.pac_complemento ");
        buf.append("       ,j.pac_numeroendereco ");
        buf.append("       ,j.pac_cartaosus ");
        buf.append("       ,j.pac_cor ");
        buf.append("       ,j.nli_codigo ");
        buf.append("       ,cid.cid_codigoibge ");
        buf.append("       ,cid.cid_nome as cidadePaciente");
        buf.append("       ,bai.bai_descricao ");
        buf.append("       ,exa.exa_tipobpa ");
        buf.append("       ,a.fat_qtdeguias ");
        buf.append(" from faturaexamerequisicao fexr ");
        buf.append(" left join faturarequisicao freq on fexr.fil_codigo = freq.fil_codigo and fexr.fat_codigo = freq.fat_codigo and fexr.fil_kodigo = freq.fil_kodigo and fexr.req_codigo = freq.req_codigo ");
        buf.append(" join filiais_postocoleta fil on freq.fil_kodigo = fil.fil_codigo ");
        buf.append(" left join fatura a on fexr.fil_codigo = a.fil_codigo and fexr.fat_codigo = a.fat_codigo ");
        buf.append(" left join requisicao b on freq.fil_kodigo = b.fil_codigo and freq.req_codigo = b.req_codigo ");
        buf.append(" left join examerequisicao exr on freq.fil_kodigo = exr.fil_codigo and freq.req_codigo = exr.req_codigo and fexr.exa_codigo = exr.exa_codigo and fexr.mco_codigo = exr.mco_codigo ");
        buf.append(" left join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append(" left join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append(" left join examerequisicaoguiaagrupada exg on exr.fil_codigo = exg.fil_codigo and exr.exa_codigo = exg.exa_codigo and exr.mco_codigo = exg.mco_codigo and exg.exa_codfilho = fexr.exa_codfilho and exg.mco_codfilho = fexr.mco_codfilho and exg.req_codigo = fexr.req_codigo ");
        buf.append(" left join medico f on b.fil_codigo = f.fil_codigo and b.med_conselho = f.med_conselho and b.med_crm = f.med_crm and b.med_uf = f.med_uf ");
        buf.append(" left join medicoconveniotiss mec on b.fil_codigo = mec.fil_codigo and b.con_codigo = mec.con_codigo and b.med_conselho = mec.med_conselho and b.med_crm = mec.med_crm and b.med_uf = mec.med_uf ");
        buf.append(" left join convenios g on freq.fil_codigo = g.fil_codigo and freq.con_codigo = g.con_codigo ");
        buf.append(" left join cidades cidconv on g.fil_codigo = cidconv.fil_codigo and g.cid_codigo = cidconv.cid_codigo ");
        buf.append(" left join situacao h on b.fil_codigo = h.fil_codigo and b.sit_codigo = h.sit_codigo ");
        buf.append(" left join examesetor d on fexr.fil_codigo = d.fil_codigo and fexr.exa_codigo = d.exa_codigo and d.ese_default = true ");
        buf.append(" left join setores set ON d.fil_codigo = set.fil_codigo and d.set_codigo   = set.set_codigo");
        buf.append(" left join paciente j on b.fil_codigo = j.fil_codigo and b.pac_codigo = j.pac_codigo ");
        buf.append("   left join cidades cid on j.fil_codigo = cid.fil_codigo and j.cid_codigo \t= cid.cid_codigo ");
        buf.append("   left join bairro bai on j.fil_codigo = bai.fil_codigo and j.bai_codigo \t= bai.bai_codigo ");
        buf.append(" left join coletas k on b.fil_codigo  = k.fil_codigo and b.col_codigo = k.col_codigo ");
        buf.append(" left join destino l on b.fil_codigo = l.fil_codigo and b.des_codigo = l.des_codigo ");
        buf.append(" left join alahospital ala on b.fil_codigo = ala.fil_codigo and b.ala_codigo = ala.ala_codigo ");
        buf.append(" left join examematcoleta m on fexr.fil_kodigo = m.fil_codigo and fexr.exa_codfilho = m.exa_codigo and fexr.mco_codfilho = m.mco_codigo  ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append(" left join detalhetabelaprecometodologia dtm on fexr.met_codigo IS NOT NULL and fexr.fil_codigo = dtm.fil_codigo and fexr.exa_codigo = dtm.exa_codigo and fexr.mco_codigo = dtm.mco_codigo and g.tpe_codigo = dtm.tpe_codigo and fexr.met_codigo = dtm.met_codigo ");
        }
        buf.append(" left join detalhetabelapreco n on fexr.fil_codigo = n.fil_codigo and fexr.exa_codigo = n.exa_codigo and fexr.mco_codigo = n.mco_codigo and g.tpe_codigo = n.tpe_codigo ");
        buf.append(" left join tabelaprecoexames t on n.fil_codigo = t.fil_codigo and n.tpe_codigo = t.tpe_codigo ");
        buf.append(" left join convenios \t     \tconprinc on b.fil_codigo = conprinc.fil_codigo and b.con_codigo      \t\t= conprinc.con_codigo ");
        buf.append(" left join conveniosrepasse\tcre \t\t on g.fil_codigo = cre.fil_codigo \t\t and conprinc.con_codigo \t= cre.con_codigo    \tand g.con_codigo = cre.con_codrepasse ");
        buf.append(" left join entidade ent on b.fil_codigo = ent.fil_codigo and b.ent_codempresa = ent.ent_codigo ");
        buf.append(" where fexr.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and fexr.fat_codigo = ");
        buf.append(this.codigoFatura);
        buf.append(" and a.fat_datacancelamento is null ");
        buf.append(" and b.req_excluida = false ");
        buf.append(" order by ");
        if (ordemFatura == null || ordemFatura.equals("R")) {
            buf.append(" freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("D")) {
            buf.append(" b.req_data, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("F")) {
            buf.append(" b.req_dtfatura, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("N")) {
            buf.append(" ordemPaciente, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("G")) {
            buf.append(" b.req_guia, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("M")) {
            buf.append(" b.req_matricula, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("E")) {
            buf.append(" f.med_nome, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("C")) {
            buf.append(" f.med_crm, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("X")) {
            buf.append(" b.req_data, exr.exr_guia, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("T")) {
            buf.append(" b.des_codigo, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("P")) {
            buf.append(" b.req_data, j.pac_nome, freq.fil_kodigo, b.req_codigo, ");
        } else if (ordemFatura.equals("S")) {
            buf.append(" set_tipoalimentos,  b.req_data, j.pac_nome, b.fil_codigo, b.req_codigo, d.set_codigo, ");
        } else if (ordemFatura.equals("W")) {
            buf.append(" ent.ent_razaosocial, b.fil_codigo, b.req_codigo, ");
        } else if (ordemFatura.equals("Z")) {
            buf.append(" ent.ent_razaosocial, ordemPaciente, freq.fil_kodigo, b.req_codigo, ");
        }
        buf.append(" conprinc.con_codigo ");
        if (ParametrosGerais.getOrdemComprovante().equals("A")) {
            buf.append(" ,exr.exr_ordem, exr.exa_codigo, exr.mco_codigo ");
        } else {
            if (ParametrosGerais.getOrdenarSetor()) {
                buf.append(" ,d.set_codigo ");
            }
            if (ParametrosGerais.getOrdemComprovante().equals("C")) {
                buf.append(" ,exr.exa_codigo, exr.mco_codigo ");
            } else if (ParametrosGerais.getOrdemComprovante().equals("P")) {
                buf.append(" ,emc_pagina, emc_ordem, exr.exa_codigo, exr.mco_codigo ");
            }
        }
        return buf.toString();
    }

    public void addThreadListener(ThreadFinalizadaListener listener) {
        this.listenerList.add(ThreadFinalizadaListener.class, listener);
    }

    public void removeThreadListener(ThreadFinalizadaListener listener) {
        this.listenerList.remove(ThreadFinalizadaListener.class, listener);
    }

    private void fireIniciouExecucao() {
        ThreadFinalizadaListener[] lis = (ThreadFinalizadaListener[])this.listenerList.getListeners(ThreadFinalizadaListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].threadIniciada(new EventObject(this));
        }
    }

    private void fireTerminouExecucao() {
        ThreadFinalizadaListener[] lis = (ThreadFinalizadaListener[])this.listenerList.getListeners(ThreadFinalizadaListener.class);
        for (int i = 0; i < lis.length; ++i) {
            lis[i].threadFinalizada(new EventObject(this));
        }
    }

    public void setRequisicoesSemPedidoGuia(List<Registro> requisicoesSemPedidoGuia) {
        this.requisicoesSemPedidoGuia = requisicoesSemPedidoGuia;
    }
}

