/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.comum.ParametrosGerais;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AlterarValor
extends JDialog
implements ActionListener {
    private JButton buttonSalvar = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JLabel labelValor = null;
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o (m\u00e1x. 100 caracteres)");
    private TTextField textValor = new TTextField(9 + ParametrosGerais.getCasasPrecoExame(), 2, ParametrosGerais.getCasasPrecoExame(), true);
    private JTextArea areaObservacao = new JTextArea(new TTextAreaDocument(100));
    private JScrollPane scrollObservacao = new JScrollPane();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private boolean ok = false;
    private boolean isAcrescimoDesconto = false;

    public AlterarValor(Window owner, boolean isAcrescimoDesconto) {
        super(owner);
        this.isAcrescimoDesconto = isAcrescimoDesconto;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setModal(true);
        if (this.isAcrescimoDesconto) {
            this.setSize(new Dimension(250, 220));
        } else {
            this.setSize(new Dimension(180, 102));
        }
        this.setLocationRelativeTo(this.getParent());
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(ScreenUtil.criarBordaVazia());
        this.add((Component)p, "Center");
        p.add((Component)this.panelBotoes, "South");
        p.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonSalvar.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.textValor.setToolTipText("% - define o valor como sendo percentual");
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.textValor.setPreferredSize(new Dimension(100, 20));
        this.textValor.setMinimumSize(new Dimension(100, 20));
        this.areaObservacao.setLineWrap(true);
        this.scrollObservacao.setViewportView(this.areaObservacao);
        this.scrollObservacao.setHorizontalScrollBarPolicy(31);
        this.scrollObservacao.setVerticalScrollBarPolicy(20);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        if (this.isAcrescimoDesconto) {
            this.labelValor = new JLabel("Valor");
            cons.fill = 0;
            cons.gridheight = 1;
            cons.gridwidth = 1;
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.gridx = 0;
            cons.gridy = 0;
            this.panelCentro.add((Component)this.labelValor, cons);
            ++cons.gridy;
            this.panelCentro.add((Component)this.textValor, cons);
            ++cons.gridy;
            this.panelCentro.add((Component)this.labelObservacao, cons);
            ++cons.gridy;
            cons.gridwidth = 2;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.fill = 1;
            this.panelCentro.add((Component)this.scrollObservacao, cons);
        } else {
            this.labelValor = new JLabel("Valor:");
            cons.fill = 0;
            cons.insets = new Insets(5, 1, 1, 1);
            cons.gridheight = 1;
            cons.gridwidth = 1;
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.gridx = 0;
            cons.gridy = 0;
            this.panelCentro.add((Component)this.labelValor, cons);
            ++cons.gridx;
            this.panelCentro.add((Component)this.textValor, cons);
            ++cons.gridy;
            cons.gridx = 0;
            cons.gridwidth = 2;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.fill = 2;
            this.panelCentro.add((Component)new JLabel(), cons);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AlterarValor.this.textValor.selectAll();
                ScreenUtil.requisitarFoco(AlterarValor.this.textValor);
            }
        });
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ok = e.getSource() == this.buttonSalvar;
        this.dispose();
    }

    public void setMensagem(String mensagem) {
        this.setTitle(mensagem);
    }

    public void setValor(Double valor, boolean isPercentual, String descricao) {
        if (isPercentual) {
            this.textValor.setText(Funcoes.formataDecimal(valor) + "%");
        } else {
            this.textValor.setText(Funcoes.formataDecimal(valor));
        }
        this.areaObservacao.setText(descricao);
    }

    public void setValor(Double valor, String descricao) {
        this.textValor.setText(Funcoes.formataDecimal(valor));
        this.areaObservacao.setText(descricao);
    }

    public double getValor() {
        if (Funcoes.isNumeric(this.limpaValor(this.retiraPercentual(this.textValor.getText())))) {
            return Double.parseDouble(this.limpaValor(this.retiraPercentual(this.textValor.getText())));
        }
        return 0.0;
    }

    public String getDescricao() {
        return this.areaObservacao.getText().replaceAll("\n", " ");
    }

    public boolean isPercentual() {
        return this.textValor.getText().indexOf("%") > 0;
    }

    private String retiraPercentual(String texto) {
        if (texto.indexOf("%") > 0) {
            return texto.substring(0, texto.indexOf("%")).replace(",", ".");
        }
        return texto.replace(",", ".");
    }

    private String limpaValor(String valor) {
        if (valor != null) {
            char[] c = valor.toCharArray();
            String retorno = "";
            for (int i = c.length - 1; i >= 0; --i) {
                String s = String.valueOf(c[i]);
                if (s.equals(".") || s.equals(",")) {
                    if (retorno.indexOf(".") >= 0) continue;
                    retorno = "." + retorno;
                    continue;
                }
                retorno = s + retorno;
            }
            return retorno;
        }
        return valor;
    }
}

