/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.faturamento;

import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AlterarDataFatura
extends JDialog
implements ActionListener {
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonData = ComponenteFactory.novoJButton(this, null, null, true);
    private JLabel label = new JLabel("Data de fatura");
    private JLabel labelIntervalo = new JLabel();
    private TTextField txtData = new TTextField(10, 4);
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints cons = new GridBagConstraints();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(this.grid);
    private Date dtinicial;
    private Date dtfinal;
    private JPanel jPanel = new JPanel();
    private boolean ok = false;

    public AlterarDataFatura(Window owner) {
        super(owner, "Alterar data de fatura");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public AlterarDataFatura(Window owner, Date dtinicial, Date dtfinal) {
        super(owner, "Alterar data de fatura");
        try {
            this.dtfinal = dtfinal;
            this.dtinicial = dtinicial;
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setModal(true);
        this.setSize(new Dimension(300, 125));
        this.setLocationRelativeTo(this.getParent());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.buttonData.setFocusable(false);
        this.txtData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AlterarDataFatura.this.buttonData.doClick();
                }
            }
        });
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.buttonOK.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.cons.gridx = 0;
        this.cons.gridy = 0;
        this.cons.fill = 0;
        this.cons.anchor = 17;
        if (this.dtfinal != null && this.dtinicial != null) {
            this.labelIntervalo.setText("Per\u00edodo: " + Funcoes.formataData(this.dtinicial) + " \u00e0 " + Funcoes.formataData(this.dtfinal));
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.label, "North");
            this.jPanel.add((Component)this.labelIntervalo, "South");
            this.panelCentro.add((Component)this.jPanel, this.cons);
        } else {
            this.setSize(new Dimension(300, 115));
            this.panelCentro.add((Component)this.label, this.cons);
        }
        ++this.cons.gridy;
        this.cons.fill = 2;
        this.cons.weightx = 1.0;
        this.txtData.setPreferredSize(new Dimension(20, 20));
        this.txtData.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.txtData, this.cons);
        this.cons.gridx = 1;
        this.cons.fill = 0;
        this.cons.weightx = 0.0;
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonData, this.cons);
        this.txtData.grabFocus();
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonData) {
            Funcoes.mostraData(this.txtData, this.buttonData, this.panelCentro, true);
        } else if (Funcoes.verificaData(this.txtData.getText())) {
            this.ok = e.getSource() == this.buttonOK;
            this.dispose();
        } else {
            Funcoes.mensagem(this, "Data inv\u00e1lida para fatura", 1);
            this.txtData.grabFocus();
        }
    }

    public void setData(String data) {
        this.txtData.setText(data);
    }

    public String getData() {
        if (Funcoes.verificaData(this.txtData.getText())) {
            return this.txtData.getText();
        }
        return "";
    }
}

