/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.caixa;

import jalis.comum.Tipos;
import jalis.laboratorio.util.caixa.DadosCaixa;
import jalis.laboratorio.util.caixa.DadosTotalCaixa;
import jalis.util.Funcoes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class RenderDadosCaixa
extends JPanel
implements TableCellRenderer {
    private JLabel labelCodigo = new JLabel();
    private JLabel labelData = new JLabel();
    private JLabel labelValor = new JLabel();
    private JLabel labelTipo = new JLabel();
    private JLabel labelObs = new JLabel();
    private JLabel labelTipoPagto = new JLabel();
    private JLabel labelEstacao = new JLabel();
    private JLabel labelUsuario = new JLabel();
    private JLabel label1 = new JLabel("Quantidade de lan\u00e7amentos:");
    private JLabel label2 = new JLabel("Quantidade de cr\u00e9ditos:");
    private JLabel label3 = new JLabel("Quantidade de d\u00e9bitos:");
    private JLabel label4 = new JLabel("Valor de cr\u00e9ditos:");
    private JLabel label5 = new JLabel("Valor de d\u00e9bitos:");
    private JLabel label6 = new JLabel("Total geral:");
    private JLabel labelLancamentos = new JLabel();
    private JLabel labelQtdeCreditos = new JLabel();
    private JLabel labelQtdeDebitos = new JLabel();
    private JLabel labelValorCreditos = new JLabel();
    private JLabel labelValorDebitos = new JLabel();
    private JLabel labelTotal = new JLabel();
    private Font fonte = new Font(this.labelCodigo.getFont().getName(), 0, 10);

    public RenderDadosCaixa() {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DadosCaixa) {
            this.atualizaDadosCaixa((DadosCaixa)value, table, row, isSelected);
        } else if (value instanceof DadosTotalCaixa) {
            this.atualizaDadosTotal((DadosTotalCaixa)value, table, row, isSelected);
        }
        this.setOpaque(isSelected);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        return this;
    }

    public void atualizaDadosCaixa(DadosCaixa dados, JTable table, int row, boolean isSelected) {
        this.labelCodigo.setFont(this.fonte);
        this.labelData.setFont(this.fonte);
        this.labelValor.setFont(this.fonte);
        this.labelTipo.setFont(this.fonte);
        this.labelObs.setFont(this.fonte);
        this.labelTipoPagto.setFont(this.fonte);
        this.labelUsuario.setFont(this.fonte);
        this.labelEstacao.setFont(this.fonte);
        this.labelUsuario.setFont(this.fonte);
        this.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        this.labelCodigo.setText(Funcoes.preencheZero(String.valueOf(dados.getCodigo()), 8));
        this.labelData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm", dados.getDataHora()));
        this.labelTipo.setText(Tipos.tipoLancamentoCaixa(dados.getTipo()));
        this.labelObs.setText(dados.getObs() + " " + (dados.isRequisicaoExcluida() ? "(Requisi\u00e7\u00e3o excluida)" : ""));
        this.labelTipoPagto.setText(Tipos.tipoPagamento(dados.getTipoPagamento()));
        this.labelUsuario.setText(dados.getCodigoUsuario());
        this.labelEstacao.setText(String.valueOf(dados.getCodigoEstacao()));
        if (dados.getTipo().equalsIgnoreCase("D")) {
            this.labelValor.setText("R$ (" + Funcoes.formataDecimal(dados.getValor()) + ")");
        } else {
            this.labelValor.setText("R$ " + Funcoes.formataDecimal(dados.getValor()));
        }
        this.labelValor.setHorizontalAlignment(4);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        this.add((Component)this.labelCodigo, constraints);
        constraints.gridx = 2;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.labelData, constraints);
        constraints.gridx = 3;
        this.labelTipo.setPreferredSize(new Dimension(45, (int)this.labelData.getPreferredSize().getHeight()));
        this.labelTipo.setMinimumSize(new Dimension(45, (int)this.labelData.getPreferredSize().getHeight()));
        this.add((Component)this.labelTipo, constraints);
        constraints.gridx = 4;
        this.labelTipoPagto.setPreferredSize(new Dimension(50, (int)this.labelData.getPreferredSize().getHeight()));
        this.labelTipoPagto.setMinimumSize(new Dimension(50, (int)this.labelData.getPreferredSize().getHeight()));
        this.add((Component)this.labelTipoPagto, constraints);
        constraints.gridx = 5;
        this.labelUsuario.setPreferredSize(new Dimension(50, (int)this.labelData.getPreferredSize().getHeight()));
        this.labelUsuario.setMinimumSize(new Dimension(50, (int)this.labelData.getPreferredSize().getHeight()));
        this.add((Component)this.labelUsuario, constraints);
        constraints.gridx = 6;
        this.labelEstacao.setPreferredSize(new Dimension(20, (int)this.labelData.getPreferredSize().getHeight()));
        this.labelEstacao.setMinimumSize(new Dimension(20, (int)this.labelData.getPreferredSize().getHeight()));
        this.add((Component)this.labelEstacao, constraints);
        constraints.gridx = 7;
        constraints.fill = 2;
        constraints.anchor = 13;
        constraints.weightx = 1.0;
        this.add((Component)this.labelValor, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 8;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 0;
        this.add((Component)this.labelObs, constraints);
        StringBuilder bui = new StringBuilder("<html>");
        bui.append("<table>");
        bui.append("<tr><td>C\u00f3digo:</td><td halign=right>");
        bui.append(dados.getCodigo());
        bui.append("</td></tr>");
        bui.append("<tr><td>Data:</td><td halign=right>");
        bui.append(Funcoes.formataData(dados.getDataHora()));
        bui.append("</td></tr>");
        bui.append("<tr><td>Tipo:</td><td halign=right>");
        bui.append(Tipos.tipoLancamentoCaixa(dados.getTipo()));
        bui.append("</td></tr>");
        bui.append("<tr><td>Tipo pagamento:</td><td halign=right>");
        bui.append(Tipos.tipoPagamento(dados.getTipoPagamento()));
        bui.append("</td></tr>");
        bui.append("<tr><td>Usu\u00e1rio:</td><td halign=right>");
        bui.append(dados.getNomeUsuario());
        bui.append("</td></tr>");
        bui.append("<tr><td>Esta\u00e7\u00e3o:</td><td halign=right>");
        bui.append(dados.getDescricaoEstacao());
        bui.append("</td></tr>");
        bui.append("<tr><td>Conta:</td><td halign=right>");
        bui.append(dados.getDescricaoEstacao());
        bui.append("</td></tr>");
        bui.append("<tr><td>Valor:</td><td><b>");
        bui.append("R$ " + Funcoes.formataDecimal(dados.getValor()));
        bui.append("</b></td></tr>");
        bui.append("<tr><td colspan=2>");
        bui.append(dados.getObs());
        bui.append("</td></tr>");
        if (dados.isRequisicaoExcluida()) {
            bui.append("<tr><td colspan=2><font color='red'>");
            bui.append("Requisi\u00e7\u00e3o excluida");
            bui.append("</font></td></tr>");
        }
        bui.append("</table></html>");
        this.setToolTipText(bui.toString());
        if (table.getRowHeight(row) < 40) {
            table.setRowHeight(row, 40);
            this.setPreferredSize(new Dimension(20, 35));
        }
        this.revalidate();
    }

    public void atualizaDadosTotal(DadosTotalCaixa dados, JTable table, int row, boolean isSelected) {
        this.labelLancamentos.setFont(this.fonte);
        this.labelQtdeCreditos.setFont(this.fonte);
        this.labelQtdeDebitos.setFont(this.fonte);
        this.labelValorCreditos.setFont(this.fonte);
        this.labelValorDebitos.setFont(this.fonte);
        this.labelTotal.setFont(this.fonte);
        this.label1.setFont(this.fonte);
        this.label2.setFont(this.fonte);
        this.label3.setFont(this.fonte);
        this.label4.setFont(this.fonte);
        this.label5.setFont(this.fonte);
        this.label6.setFont(this.fonte);
        this.label1.setHorizontalAlignment(4);
        this.label2.setHorizontalAlignment(4);
        this.label3.setHorizontalAlignment(4);
        this.label4.setHorizontalAlignment(4);
        this.label5.setHorizontalAlignment(4);
        this.label6.setHorizontalAlignment(4);
        this.removeAll();
        GridBagConstraints cons = new GridBagConstraints();
        this.label1.setHorizontalAlignment(4);
        this.label2.setHorizontalAlignment(4);
        this.label3.setHorizontalAlignment(4);
        this.label4.setHorizontalAlignment(4);
        this.label5.setHorizontalAlignment(4);
        this.label6.setHorizontalAlignment(4);
        this.labelLancamentos.setHorizontalAlignment(4);
        this.labelQtdeCreditos.setHorizontalAlignment(4);
        this.labelQtdeDebitos.setHorizontalAlignment(4);
        this.labelValorCreditos.setHorizontalAlignment(4);
        this.labelValorDebitos.setHorizontalAlignment(4);
        this.labelTotal.setHorizontalAlignment(4);
        this.labelLancamentos.setText(String.valueOf(dados.getQtdeLancamentos()));
        this.labelQtdeCreditos.setText(String.valueOf(dados.getQtdeCredito()));
        this.labelQtdeDebitos.setText(String.valueOf(dados.getQtdeDebito()));
        this.labelValorCreditos.setText("R$ " + Funcoes.formataDecimal(dados.getTotalCredito()));
        this.labelValorDebitos.setText("R$ " + Funcoes.formataDecimal(dados.getTotalDebito()));
        this.labelTotal.setText("R$ " + Funcoes.formataDecimal(dados.getTotalCredito() - dados.getTotalDebito()));
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.anchor = 13;
        this.add((Component)this.label1, cons);
        cons.gridy = 1;
        this.add((Component)this.label2, cons);
        cons.gridy = 2;
        this.add((Component)this.label3, cons);
        cons.gridy = 3;
        this.add((Component)this.label4, cons);
        cons.gridy = 4;
        this.add((Component)this.label5, cons);
        cons.gridy = 5;
        this.add((Component)this.label6, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.fill = 0;
        this.add((Component)this.labelLancamentos, cons);
        cons.gridy = 1;
        this.add((Component)this.labelQtdeCreditos, cons);
        cons.gridy = 2;
        this.add((Component)this.labelQtdeDebitos, cons);
        cons.gridy = 3;
        this.add((Component)this.labelValorCreditos, cons);
        cons.gridy = 4;
        this.add((Component)this.labelValorDebitos, cons);
        cons.gridy = 5;
        this.add((Component)this.labelTotal, cons);
        this.setToolTipText(null);
        if (table.getRowHeight(row) < 40) {
            table.setRowHeight(row, 95);
            this.setPreferredSize(new Dimension(20, 95));
        }
        this.revalidate();
    }
}

