/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.caixa;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.caixa.DadosCaixa;
import jalis.laboratorio.util.caixa.DadosTotalCaixa;
import jalis.laboratorio.util.caixa.RenderDadosCaixa;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class PesquisaCaixa
extends Thread {
    private JPanel panelProgresso;
    private JPanel panelMensagens;
    private JPanel panel;
    private JButton button;
    private Frame owner;
    private JTable tabela;
    private JScrollPane scroll;
    private ModeloGridTable modeloTabela;
    private JProgressBar progresso;
    private int linha = 5;
    private String[] filtroEstacao;
    private String[] filtroUsuario;
    private String[] filtroConta;
    private String dataInicio;
    private String dataFim;
    private String horaInicio;
    private String horaFim;
    private String pagamento = "";

    public PesquisaCaixa(Frame owner, JPanel panel, JButton button) {
        super("Thread - consulta caixa");
        this.setPriority(1);
        this.panel = panel;
        this.button = button;
        this.owner = owner;
        this.panel.setLayout(new BorderLayout());
        this.panelMensagens = new JPanel(null);
        this.panelProgresso = new JPanel(new BorderLayout());
        this.panel.add((Component)this.panelMensagens, "Center");
        this.panel.add((Component)this.panelProgresso, "South");
    }

    @Override
    public void run() {
        this.mostraMensagem("Analisando filtros...");
        Statement st = Conexao.getStatement();
        try {
            this.mostraMensagem("Selecionando lan\u00e7amentos...");
            ResultSet rs = Conexao.executeQuery(st, this.sqlLancamento());
            if (rs.next()) {
                int maximoProgresso = DBUtil.qtdeRegistros(rs);
                this.progresso = new JProgressBar(0, maximoProgresso);
                this.mostraMensagem("Validando lan\u00e7amentos...");
                this.panelProgresso.add((Component)this.progresso, "Center");
                this.panelProgresso.repaint();
                this.tabela = new JTable();
                this.modeloTabela = new ModeloGridTable(new String[]{""});
                this.tabela.setModel(this.modeloTabela);
                this.scroll = new JScrollPane(this.tabela);
                this.tabela.setDefaultRenderer(Object.class, new RenderDadosCaixa());
                this.tabela.setShowGrid(false);
                this.scroll.setBounds(5, 70, this.panel.getWidth() - 10, 200);
                while (rs.next()) {
                    this.adicionaLancamento(new DadosCaixa(), rs);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
                rs.close();
                DadosTotalCaixa total = new DadosTotalCaixa();
                this.calculaTotal(total);
                this.modeloTabela.addLine(new Object[]{total});
                this.panel.removeAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PesquisaCaixa.this.panel.setLayout(new BorderLayout());
                        PesquisaCaixa.this.panel.add((Component)PesquisaCaixa.this.scroll, "Center");
                        PesquisaCaixa.this.panel.revalidate();
                    }
                });
                this.tabela.requestFocus();
            } else {
                this.mostraMensagem("N\u00e3o h\u00e1 lan\u00e7amentos no per\u00edodo selecionado");
            }
        }
        catch (SQLException ex) {
            Funcoes.mensagem(this.owner, "N\u00e3o foi poss\u00edvel selecionar lan\u00e7amentos", 1);
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "PesquisaCaixa");
        }
        Conexao.fecharStatement(st);
        this.button.setEnabled(true);
    }

    private void calculaTotal(DadosTotalCaixa dados) throws SQLException {
        if (this.modeloTabela.getRowCount() < 1) {
            return;
        }
        for (int i = 0; i < this.modeloTabela.getRowCount(); ++i) {
            if (!(this.modeloTabela.getValueAt(i, 0) instanceof DadosCaixa)) continue;
            DadosCaixa caixa = (DadosCaixa)this.modeloTabela.getValueAt(i, 0);
            if (caixa.getTipo().equalsIgnoreCase("C")) {
                dados.setQtdeCredito(dados.getQtdeCredito() + 1);
                dados.setTotalCredito(dados.getTotalCredito() + caixa.getValor());
            } else {
                dados.setQtdeDebito(dados.getQtdeDebito() + 1);
                dados.setTotalDebito(dados.getTotalDebito() + caixa.getValor());
            }
            dados.setQtdeLancamentos(dados.getQtdeLancamentos() + 1);
        }
    }

    private void adicionaLancamento(DadosCaixa d, ResultSet rs) throws SQLException {
        d.setAgencia(rs.getString("lcx_agencia"));
        d.setBanco(rs.getInt("lcx_banco"));
        d.setCodigo(rs.getInt("lcx_codigo"));
        d.setCodigoConta(rs.getInt("cco_reduzido"));
        d.setCodigoEstacao(rs.getInt("est_codigo"));
        d.setCodigoRequisicao(rs.getInt("req_codigo"));
        d.setCodigoUsuario(rs.getString("usr_codigo"));
        d.setConciliacao(rs.getDate("lcx_conciliacao"));
        d.setConta(rs.getString("lcx_conta"));
        d.setContaConta(rs.getString("cco_conta"));
        d.setDataHora(rs.getTimestamp("lcx_datahora"));
        d.setDescricaoEstacao(rs.getString("est_descricao"));
        d.setDocumento(rs.getString("lcx_documento"));
        d.setNomeUsuario(rs.getString("usr_nome"));
        d.setNumeroCartao(rs.getString("lcx_nrcartao"));
        d.setNumeroCheque(rs.getString("lcx_nrcheque"));
        d.setObs(rs.getString("lcx_obs"));
        d.setOperadoraCartao(rs.getString("lcx_cartaocredito"));
        d.setTipo(rs.getString("lcx_tipo"));
        d.setTipoDocumento(rs.getString("lcx_tipodocumento"));
        d.setTipoPagamento(rs.getString("lcx_tipopagamento"));
        d.setTitularConta(rs.getString("cco_titular"));
        d.setValidadeCartao(rs.getDate("lcx_validadecartao"));
        d.setValor(rs.getDouble("lcx_valor"));
        d.setVencimento(rs.getDate("lcx_vencimento"));
        d.setRequisicaoExcluida(rs.getBoolean("req_excluida"));
        this.modeloTabela.addLine(new Object[]{d});
    }

    private void mostraMensagem(String mensagem) {
        JLabel label = new JLabel(mensagem);
        this.panelMensagens.add(label);
        label.setBounds(10, this.linha, 350, 25);
        this.panelMensagens.revalidate();
        this.panelMensagens.getTopLevelAncestor().repaint();
        this.linha += 15;
    }

    public void setFiltroEstacao(String ... filtro) {
        this.filtroEstacao = filtro;
    }

    public void setFiltroUsuario(String ... filtro) {
        this.filtroUsuario = filtro;
    }

    public void setFiltroConta(String ... filtro) {
        this.filtroConta = filtro;
    }

    public void setDataInicio(String data) {
        this.dataInicio = data;
    }

    public void setDataFim(String data) {
        this.dataFim = data;
    }

    public void setHoraInicio(String hora) {
        this.horaInicio = hora;
    }

    public void setHoraFim(String hora) {
        this.horaFim = hora;
    }

    public void setPagamento(String pagamento) {
        this.pagamento = pagamento;
    }

    private String sqlLancamento() throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder("");
        buf.append("select a.lcx_codigo, a.lcx_tipo, a.lcx_datahora, a.lcx_valor, a.lcx_banco, a.lcx_agencia, ");
        buf.append("a.lcx_documento, a.lcx_obs, a.lcx_tipodocumento, a.lcx_tipopagamento, a.usr_codigo, ");
        buf.append("a.cco_reduzido, a.lcx_nrcheque, a.lcx_validadecartao, a.lcx_nrcartao, a.lcx_cartaocredito, ");
        buf.append("a.lcx_conta, a.lcx_conciliacao, a.lcx_vencimento, a.est_codigo, r.req_excluida, ");
        buf.append("b.req_codigo, ");
        buf.append("c.usr_nome, d.est_descricao, e.cco_conta, e.cco_titular ");
        buf.append("from lanctocaixa a ");
        buf.append("join requisicaolanctocaixa b on a.fil_codigo = b.fil_codigo and a.lcx_codigo = b.lcx_codigo and a.est_codigo = b.est_codigo ");
        buf.append("join usuario c on a.usr_codigo = c.usr_codigo ");
        buf.append("join estacoes d on a.est_codigo = d.est_codigo ");
        buf.append("join contacorrente e on a.fil_codigo = e.fil_codigo and a.cco_reduzido = e.cco_reduzido ");
        buf.append("left join requisicao r on b.fil_codigo = r.fil_codigo and b.req_codigo = r.req_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        if (this.filtroEstacao != null && this.filtroEstacao.length > 0) {
            buf.append(" and a.est_codigo in (");
            for (i = 0; i < this.filtroEstacao.length; ++i) {
                buf.append(this.filtroEstacao[i]);
                if (i >= this.filtroEstacao.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroUsuario != null && this.filtroUsuario.length > 0) {
            buf.append(" and a.usr_codigo in (");
            for (i = 0; i < this.filtroUsuario.length; ++i) {
                buf.append("'");
                buf.append(this.filtroUsuario[i]);
                buf.append("'");
                if (i >= this.filtroUsuario.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroConta != null && this.filtroConta.length > 0) {
            buf.append(" and a.cco_reduzido in (");
            for (i = 0; i < this.filtroConta.length; ++i) {
                buf.append(this.filtroConta[i]);
                if (i >= this.filtroConta.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (Funcoes.verificaData(this.dataInicio)) {
            buf.append(" and cast(a.lcx_datahora as date) >= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.dataInicio));
            buf.append("' ");
        }
        if (Funcoes.verificaData(this.dataFim)) {
            buf.append(" and cast(a.lcx_datahora as date) <= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.dataFim));
            buf.append("' ");
        }
        if (Funcoes.verificaHora(this.horaInicio)) {
            buf.append(" and cast(a.lcx_datahora as time) >= '");
            buf.append(this.horaInicio);
            buf.append("' ");
        }
        if (Funcoes.verificaHora(this.horaInicio)) {
            buf.append(" and cast(a.lcx_datahora as time) <= '");
            buf.append(this.horaFim);
            buf.append("' ");
        }
        if (!Funcoes.textoVazio(this.pagamento)) {
            buf.append(" and a.lcx_tipopagamento IN ('");
            buf.append(this.pagamento);
            buf.append("') ");
        }
        buf.append(" order by a.lcx_codigo, a.lcx_tipo");
        return buf.toString();
    }
}

