/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.autocopia;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.mensagens.VerificaMensagens;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class ExportarEntreFilais
extends Thread {
    private boolean parar = false;
    private boolean exportando = false;
    private static String nomeCampo = "";
    String comandoErro = "";

    public ExportarEntreFilais() {
        super("Exportar entre filiais - thread");
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder buf = new StringBuilder("select * from exportafiliais where efi_exportado = false order by fil_codigo, efi_codigo limit 200");
        Statement apagar = Conexao.getStatement();
        try {
            Conexao.execute(Variaveis.filialPadrao, apagar, "delete from exportafiliais where efi_datahora < current_date - 10 and efi_exportado = true");
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(apagar);
        while (!this.parar) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            Statement st3 = Conexao.getStatement();
            String efi_codigo = "";
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.exportando = true;
                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
                    do {
                        boolean enviadoWeb = false;
                        String tipo = rs.getString("efi_tipooperacao");
                        String root = StringUtil.rootXML(rs.getString("efi_operacao"));
                        efi_codigo = rs.getString("efi_codigo");
                        if (Funcoes.textoVazio(root)) {
                            new Exception("Tabela n\u00e3o encontrada na exporta\u00e7\u00e3o");
                        }
                        if (tipo.equalsIgnoreCase("U")) {
                            String comando;
                            String[] codigo = ExportarEntreFilais.pegaCodigoCopia(rs.getString("efi_operacao"));
                            if (codigo != null) {
                                comando = ExportarEntreFilais.geraUpdate(rs.getString("efi_operacao"), rs.getString("fil_codigo"), codigo[1]);
                                if (!Funcoes.textoVazio(comando)) {
                                    this.comandoErro = comando;
                                    Conexao.execute(rs.getString("fil_codigo"), st2, this.comandoErro);
                                }
                            } else {
                                String requisicao = this.getCodigoRequisicaoCopia(st2, rs.getString("fil_codigo"), rs.getString("efi_operacao"));
                                comando = !Funcoes.textoVazio(requisicao) ? ExportarEntreFilais.geraUpdate(rs.getString("efi_operacao"), rs.getString("fil_codigo"), requisicao) : ExportarEntreFilais.geraInsert(rs.getString("efi_operacao"), rs.getString("fil_codigo"), DBUtil.getSequencia(st2, "requisicao", rs.getString("fil_codigo")), null, null);
                                if (!Funcoes.textoVazio(comando)) {
                                    this.comandoErro = comando;
                                    Conexao.execute(rs.getString("fil_codigo"), st2, this.comandoErro);
                                }
                            }
                        } else if (tipo.equalsIgnoreCase("E")) {
                            String requisicao = this.getCodigoRequisicaoCopia(st2, rs.getString("fil_codigo"), rs.getString("efi_operacao"));
                            String[] codigo = ExportarEntreFilais.pegaCodigoCopia(rs.getString("efi_operacao"));
                            if (requisicao != null) {
                                Conexao.arquivaSQL();
                                this.exportaWeb(st2, st3, rs.getInt("fil_codigo"), rs.getString("efi_operacao"), rs.getString("efi_tipooperacao"));
                                enviadoWeb = true;
                                this.comandoErro = ExportarEntreFilais.geraDelete(rs.getString("efi_operacao"), rs.getString("fil_codigo"), requisicao);
                                Conexao.execute(rs.getString("fil_codigo"), st2, this.comandoErro);
                                ExportarEntreFilais.verificaExclusaoRequisicao(st2, rs.getString("efi_operacao"), rs.getString("fil_codigo"), requisicao);
                            }
                        } else if (tipo.equalsIgnoreCase("I")) {
                            String xml = rs.getString("efi_operacao");
                            String sql = ExportarEntreFilais.geraSelect(xml);
                            this.inserir(st2, rs.getString("fil_codigo"), root, xml);
                        }
                        StringBuilder bui = new StringBuilder("update exportafiliais set efi_exportado = true where fil_codigo = ");
                        bui.append(rs.getString("fil_codigo"));
                        bui.append(" and efi_codigo = ");
                        bui.append(rs.getString("efi_codigo"));
                        Conexao.execute(rs.getString("fil_codigo"), st2, bui.toString());
                        if (enviadoWeb) continue;
                        Conexao.arquivaSQL();
                        this.exportaWeb(st2, st3, rs.getInt("fil_codigo"), rs.getString("efi_operacao"), rs.getString("efi_tipooperacao"));
                    } while (rs.next());
                    Conexao.arquivaSQL();
                }
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                this.exportando = false;
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, ex.getMessage() + "\n Mensagem: " + efi_codigo + "(" + nomeCampo + ")", ex.getStackTrace(), "Exportacao (133)+\n" + this.comandoErro);
                    this.parar = true;
                    this.exportando = false;
                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                    VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Mensagem ao exportar dados para filial");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    Conexao.fecharStatement(st2, st3);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2, st3);
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2, st3);
            try {
                if (this.parar) continue;
                ExportarEntreFilais.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void inserir(Statement st2, String filial, String root, String xml) throws SQLException {
        String[] codigo = ExportarEntreFilais.pegaCodigoCopia(xml);
        if (codigo == null) {
            String codigoRequisicao = "";
            if (root.equals("requisicao")) {
                codigoRequisicao = this.getCodigoRequisicaoCopia(st2, filial, xml);
                if (Funcoes.textoVazio(codigoRequisicao)) {
                    this.comandoErro = ExportarEntreFilais.geraInsert(xml, filial, DBUtil.getSequencia(st2, "requisicao", filial), null, null);
                    Conexao.execute(filial, st2, this.comandoErro);
                } else {
                    this.comandoErro = ExportarEntreFilais.geraUpdate(xml, filial, codigoRequisicao);
                    Conexao.execute(filial, st2, this.comandoErro);
                }
            } else {
                String requisicao = this.getCodigoRequisicaoCopia(st2, filial, xml);
                boolean continuar = true;
                boolean inserir = true;
                if ((root.equals("examerequisicao") || root.equals("requisicaomedicamento") || root.equals("requisicaocid10")) && !Funcoes.textoVazio(requisicao)) {
                    StringBuilder buf = new StringBuilder("select req_codigo from requisicao where fil_codigo = ");
                    buf.append(filial).append(" and req_codigo = ").append(requisicao);
                    ResultSet rs = Conexao.executeQuery(st2, buf);
                    continuar = rs.next();
                    if (continuar && root.equals("examerequisicao")) {
                        String exm = this.pegaValorCampoXML("examerequisicao", "exa_codigo", xml);
                        String mco = this.pegaValorCampoXML("examerequisicao", "mco_codigo", xml);
                        if (!Funcoes.textoVazio(exm) && !Funcoes.textoVazio(mco)) {
                            buf.setLength(0);
                            buf.append("select req_codigo, exr_excluido from examerequisicao where fil_codigo = ").append(filial);
                            buf.append(" and req_codigo = ").append(requisicao);
                            buf.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(exm));
                            buf.append(" and mco_codigo = ").append(mco);
                            rs = Conexao.executeQuery(st2, buf);
                            boolean bl = inserir = !rs.next();
                        }
                    }
                }
                if (continuar) {
                    if (inserir) {
                        this.comandoErro = ExportarEntreFilais.geraInsert(xml, filial, requisicao, null, null);
                        Conexao.execute(filial, st2, this.comandoErro);
                    } else {
                        this.comandoErro = ExportarEntreFilais.geraUpdate(xml, filial, requisicao);
                        Conexao.execute(filial, st2, this.comandoErro);
                    }
                }
            }
        }
    }

    public static String geraSelect(String xml) {
        String campos = "";
        String root = StringUtil.rootXML(xml);
        if (Funcoes.textoVazio(root) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, root))) {
            return "";
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        StringBuilder buf = new StringBuilder("select * from ");
        buf.append(root);
        for (String s : valores) {
            if (!StringUtil.getValor(s, "chave").equals("1")) continue;
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            nomeCampo = campo + " 188 " + valor;
            if (buf.indexOf("where") > 0) {
                buf.append(" and ");
            } else {
                buf.append(" where ");
            }
            buf.append(campo);
            buf.append(" = ");
            buf.append(ExportarEntreFilais.checkTipo(valor, tipo));
        }
        return buf.toString();
    }

    public static String geraInsert(String xml, String filialNova, String codigoNovo, String filialCopia, String codigoCopia) {
        String campo;
        String s;
        int i;
        String tabela = StringUtil.rootXML(xml);
        String campos = "";
        String filCopia = filialCopia;
        String reqCopia = codigoCopia;
        StringBuilder bufC = new StringBuilder("insert into ").append(tabela).append(" (");
        StringBuilder bufV = new StringBuilder(") values (");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, tabela)) || Funcoes.textoVazio(codigoNovo) || Funcoes.textoVazio(filialNova)) {
            return "";
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        if (filCopia == null || reqCopia == null) {
            for (i = 0; i < valores.length; ++i) {
                s = valores[i];
                campo = StringUtil.getValor(s, "nome");
                String valor = StringUtil.getValor(s, "valor");
                nomeCampo = campo + "230 " + valor;
                if (campo.equals("fil_codigo")) {
                    filCopia = valor;
                    continue;
                }
                if (!campo.equals("req_codigo")) continue;
                reqCopia = valor;
            }
        }
        for (i = 0; i < valores.length; ++i) {
            s = valores[i];
            campo = StringUtil.getValor(s, "nome");
            if (campo.equalsIgnoreCase("orc_codigo")) continue;
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            nomeCampo = campo + "242 " + valor;
            bufC.append(campo);
            if (campo.equals("fil_codigo")) {
                bufV.append(ExportarEntreFilais.checkTipo(filialNova, tipo));
            } else if (campo.equals("req_codigo")) {
                bufV.append(ExportarEntreFilais.checkTipo(codigoNovo, tipo));
            } else if (campo.equals("fil_codcopia")) {
                bufV.append(ExportarEntreFilais.checkTipo(filCopia, tipo));
            } else if (campo.equals("req_codcopia")) {
                bufV.append(ExportarEntreFilais.checkTipo(reqCopia, tipo));
            } else {
                bufV.append(ExportarEntreFilais.checkTipo(valor, tipo));
            }
            if (i >= valores.length - 1) continue;
            bufC.append(", ");
            bufV.append(", ");
        }
        return bufC.append(bufV.toString()).append(")").toString();
    }

    public static String geraUpdate(String xml, String filialNova, String codigoNovo) {
        String tabela = StringUtil.rootXML(xml);
        String campos = "";
        StringBuilder bufU = new StringBuilder("update ").append(tabela).append(" set ");
        StringBuilder bufW = new StringBuilder(" ");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, tabela))) {
            return "";
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        boolean apenasChavesNoComando = true;
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            if (campo.equalsIgnoreCase("orc_codigo")) continue;
            boolean pk = StringUtil.getValor(s, "chave").equalsIgnoreCase("1");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            nomeCampo = campo + " 293 " + valor;
            if (campo.equals("fil_codcopia") || campo.equals("req_codcopia")) continue;
            if (!pk) {
                apenasChavesNoComando = false;
                bufU.append(campo);
                bufU.append(" = ");
                bufU.append(ExportarEntreFilais.checkTipo(valor, tipo));
                if (i >= valores.length - 1) continue;
                bufU.append(", ");
                continue;
            }
            if (bufW.indexOf("where") > 0) {
                bufW.append(" and ");
            } else {
                bufW.append(" where ");
            }
            bufW.append(campo);
            bufW.append(" = ");
            if (campo.equals("fil_codigo")) {
                bufW.append(ExportarEntreFilais.checkTipo(filialNova, tipo));
                continue;
            }
            if (campo.equals("req_codigo")) {
                bufW.append(ExportarEntreFilais.checkTipo(codigoNovo, tipo));
                continue;
            }
            bufW.append(ExportarEntreFilais.checkTipo(valor, tipo));
        }
        if (!apenasChavesNoComando) {
            return bufU.append(bufW.toString()).toString();
        }
        return "";
    }

    public static String geraDelete(String xml, String filialNova, String codigoNovo) {
        String tabela = StringUtil.rootXML(xml);
        String campos = "";
        StringBuilder bufD = new StringBuilder("delete from ").append(tabela);
        StringBuilder bufW = new StringBuilder(" ");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, tabela))) {
            return "";
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            boolean pk = StringUtil.getValor(s, "chave").equalsIgnoreCase("1");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            nomeCampo = campo + "352 " + valor;
            if (campo.equals("fil_codcopia") || campo.equals("req_codcopia") || !pk) continue;
            if (bufW.indexOf("where") > 0) {
                bufW.append(" and ");
            } else {
                bufW.append(" where ");
            }
            bufW.append(campo);
            bufW.append(" = ");
            if (campo.equals("fil_codigo")) {
                bufW.append(ExportarEntreFilais.checkTipo(filialNova, tipo));
                continue;
            }
            if (campo.equals("req_codigo")) {
                bufW.append(ExportarEntreFilais.checkTipo(codigoNovo, tipo));
                continue;
            }
            bufW.append(ExportarEntreFilais.checkTipo(valor, tipo));
        }
        return bufD.append(bufW.toString()).toString();
    }

    private static String checkTipo(String valor, int tipo) {
        if (valor == null || Funcoes.textoVazio(valor) || valor.equalsIgnoreCase("null")) {
            return "null";
        }
        String retorno = "";
        switch (tipo) {
            case 4: {
                if (valor.equalsIgnoreCase("t") || valor.equalsIgnoreCase("true")) {
                    retorno = "true";
                    break;
                }
                retorno = "false";
                break;
            }
            case 2: {
                if (Funcoes.isNumeric(valor)) {
                    retorno = valor.replaceAll(",", ".");
                    break;
                }
                retorno = "null";
                break;
            }
            case 1: {
                if (Funcoes.verificaData("yyyy/MM/dd", valor)) {
                    retorno = "'" + valor + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            case 3: {
                if (Funcoes.verificaHora(valor)) {
                    retorno = "'" + valor + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            case 5: {
                if (Funcoes.verificaTimestamp("yyyy/MM/dd HH:mm:ss", valor)) {
                    retorno = "'" + valor + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            default: {
                retorno = StringUtil.textoDBEscape(valor);
            }
        }
        return ExportaFiliais.trocaSinais(retorno, true);
    }

    private static String[] pegaCodigoCopia(String xml) {
        String codigoFilialCopia = "";
        String codigoRequisicaoCopia = "";
        if (xml.indexOf("fil_codcopia") > 0 && xml.indexOf("req_codcopia") > 0) {
            String[] valores;
            String campos = "";
            String root = StringUtil.rootXML(xml);
            if (Funcoes.textoVazio(root) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, root))) {
                return null;
            }
            for (String s : valores = StringUtil.getValores(campos, "campo")) {
                if (StringUtil.getValor(s, "nome").equalsIgnoreCase("fil_codcopia")) {
                    codigoFilialCopia = StringUtil.getValor(s, "valor");
                    continue;
                }
                if (!StringUtil.getValor(s, "nome").equalsIgnoreCase("req_codcopia")) continue;
                codigoRequisicaoCopia = StringUtil.getValor(s, "valor");
            }
        }
        if (!(Funcoes.textoVazio(codigoFilialCopia) || Funcoes.textoVazio(codigoRequisicaoCopia) || codigoFilialCopia.equals("null") || codigoRequisicaoCopia.equals("null"))) {
            return new String[]{codigoFilialCopia, codigoRequisicaoCopia};
        }
        return null;
    }

    private String pegaValorCampoXML(String root, String campo, String xml) {
        String campos = "";
        if (!Funcoes.textoVazio(root) && !Funcoes.textoVazio(campos = StringUtil.getValor(xml, root))) {
            String[] valores;
            for (String s : valores = StringUtil.getValores(campos, "campo")) {
                if (!StringUtil.getValor(s, "nome").equalsIgnoreCase(campo)) continue;
                return StringUtil.getValor(s, "valor");
            }
        }
        return "";
    }

    private String getCodigoRequisicaoCopia(Statement st, String filial, String xml) throws SQLException {
        String campos = "";
        String root = StringUtil.rootXML(xml);
        if (Funcoes.textoVazio(root) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, root))) {
            return "";
        }
        String[] teste = ExportarEntreFilais.pegaCodigoRequisicaoCopiada(st, xml);
        if (teste != null) {
            return teste[1];
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        StringBuilder buf = new StringBuilder("select req_codigo from requisicao ");
        for (String s : valores) {
            if (!StringUtil.getValor(s, "chave").equals("1")) continue;
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (!campo.equals("fil_codigo") && !campo.equals("req_codigo")) continue;
            if (buf.indexOf("where") > 0) {
                buf.append(" and ");
            } else {
                buf.append(" where ");
            }
            if (campo.equals("fil_codigo")) {
                buf.append("fil_codcopia");
            } else if (campo.equals("req_codigo")) {
                buf.append("req_codcopia");
            } else {
                buf.append(campo);
            }
            buf.append(" = ");
            buf.append(ExportarEntreFilais.checkTipo(valor, tipo));
        }
        buf.append(" and fil_codigo = ");
        buf.append(filial);
        String retorno = "";
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            retorno = rs.getString("req_codigo");
        }
        return retorno;
    }

    private static void verificaExclusaoRequisicao(Statement st, String operacao, String filialNova, String requisicao) throws Exception {
        String tabela = StringUtil.rootXML(operacao);
        if (tabela.equalsIgnoreCase("examerequisicao") && !Funcoes.textoVazio(requisicao)) {
            StringBuilder buf = new StringBuilder("select exa_codigo from examerequisicao where fil_codigo = ");
            buf.append(filialNova);
            buf.append(" and req_codigo = ");
            buf.append(requisicao);
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (!rs.next()) {
                buf.delete(0, buf.length());
                buf.append("delete from requisicao where fil_codigo = ");
                buf.append(filialNova);
                buf.append(" and req_codigo = ");
                buf.append(requisicao);
                Conexao.execute(filialNova, st, buf);
                RecepcaoUtil.gravaLogExclusaoRequisicao(null, st, filialNova, requisicao);
            }
        }
    }

    private static String[] pegaCodigoRequisicaoCopiada(Statement st, String xml) throws SQLException {
        String campos = "";
        String root = StringUtil.rootXML(xml);
        if (Funcoes.textoVazio(root) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, root))) {
            return null;
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        StringBuilder buf = new StringBuilder("select fil_codcopia, req_codcopia from requisicao ");
        for (String s : valores) {
            if (!StringUtil.getValor(s, "chave").equals("1")) continue;
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (!campo.equals("fil_codigo") && !campo.equals("req_codigo")) continue;
            if (buf.indexOf("where") > 0) {
                buf.append(" and ");
            } else {
                buf.append(" where ");
            }
            buf.append(campo);
            buf.append(" = ");
            buf.append(ExportarEntreFilais.checkTipo(valor, tipo));
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next() && !DBUtil.campoNull(rs.getString("req_codcopia"))) {
            return new String[]{rs.getString("fil_codcopia"), rs.getString("req_codcopia")};
        }
        return null;
    }

    public void parar() {
        this.parar = true;
    }

    public boolean exportando() {
        return this.exportando;
    }

    private void exportaWeb(Statement st, Statement st2, int filial, String xml, String operacao) throws Exception {
        String codigoBase = "";
        StringBuilder buf = new StringBuilder("select fil_baseweb from filiais_postocoleta where fil_codigo = ");
        buf.append(filial);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (!rs.next() || DBUtil.campoNull(rs.getString("fil_baseweb")) || Funcoes.textoVazio(rs.getString("fil_baseweb"))) {
            return;
        }
        codigoBase = rs.getString("fil_baseweb");
        String root = StringUtil.rootXML(xml);
        if (!root.toUpperCase().equals("REQUISICAO") && !root.toUpperCase().equals("EXAMEREQUISICAO")) {
            return;
        }
        String[] codigo = ExportarEntreFilais.pegaCodigoCopia(xml);
        boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, String.valueOf(filial));
        if (root.toUpperCase().equals("REQUISICAO")) {
            if (codigo == null) {
                return;
            }
            buf.delete(0, buf.length());
            buf.append("select a.req_data, a.req_hora, b.des_descricao, c.col_descricao, a.des_codigo, ");
            buf.append("a.con_codigo, a.req_idade, a.req_anomes, d.pac_datanasc, a.req_senhaweb, a.ent_codigo, ");
            buf.append("a.pac_codigo, a.req_totpago,  a.req_total, a.med_crm, a.med_uf, a.med_conselho ");
            buf.append("from requisicao a ");
            buf.append("left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
            buf.append("left join coletas c on a.fil_codigo = c.fil_codigo and a.col_codigo = c.col_codigo ");
            buf.append("left join paciente d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(codigo[1]);
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                String[] comandoRequisicao = new String[]{"codigoBase", codigoBase, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(String.valueOf(filial), codigo[1], st2), "dataRequisicao", Funcoes.formataData(rs.getDate("req_data")), "horaRequisicao", rs.getString("req_hora"), "destinoRequisicao", rs.getString("des_descricao"), "coletaRequisicao", rs.getString("col_descricao"), "codigoConvenioRequisicao", rs.getString("con_codigo"), "idadeRequisicao", rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes")), "dataNascimentoRequisicao", !DBUtil.campoNull(rs.getString("pac_datanasc")) ? Funcoes.formataData(rs.getDate("pac_datanasc")) : "", "senhaRequisicao", rs.getString("req_senhaweb"), "conselhoMedicoRequisicao", rs.getString("med_conselho"), "crmMedicoRequisicao", rs.getString("med_crm"), "ufMedicoRequisicao", rs.getString("med_uf"), "valorPagoRequisicao", Funcoes.limpaDecimal(rs.getString("req_totpago")), "valorRequisicao", Funcoes.limpaDecimal(rs.getString("req_total")), "codigoPacienteRequisicao", rs.getString("pac_codigo"), "codigoDestinoRequisicao", rs.getString("des_codigo"), "entidadeRequisicao", DBUtil.campoNull(rs.getString("ent_codigo")) ? "null" : rs.getString("ent_codigo")};
                DBUtil.insereExportaWeb(String.valueOf(filial), st, "requisicao", operacao.equals("I") ? "I" : (operacao.equals("E") ? "D" : "A"), comandoRequisicao);
            }
        } else if (root.toUpperCase().equals("EXAMEREQUISICAO")) {
            String req = this.getCodigoRequisicaoCopia(st, String.valueOf(filial), xml);
            String codExame = this.pegaValorCampoXML("examerequisicao", "exa_codigo", xml);
            String codMaterial = this.pegaValorCampoXML("examerequisicao", "mco_codigo", xml);
            if (req == null || Funcoes.textoVazio(req) || codExame == null || Funcoes.textoVazio(codExame) || codMaterial == null || Funcoes.textoVazio(codMaterial) || !Funcoes.isNumeric(req) || !Funcoes.isNumeric(codMaterial)) {
                return;
            }
            buf.delete(0, buf.length());
            buf.append("select a.exa_codigo, a.mco_codigo, b.mco_descricao, a.exr_situacao, a.exr_dataassina, a.usr_codassina, ");
            buf.append("c.usr_nome, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, ");
            buf.append("a.exr_datamaterial, a.met_codigo, r.con_codigo, r.des_codigo, r.req_anomes, r.req_idade ");
            buf.append("from examerequisicao a ");
            buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append("left join usuario c on a.usr_codassina = c.usr_codigo ");
            buf.append("left join requisicao r on a.fil_codigo = r.fil_codigo and a.req_codigo = r.req_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(req);
            buf.append(" and a.exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
            buf.append(" and a.mco_codigo = ").append(codMaterial);
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                String exame = rs.getString("exa_codigo");
                String material = rs.getString("mco_codigo");
                String[] comandoExameRequisicao = new String[32];
                comandoExameRequisicao[0] = "codigoBase";
                comandoExameRequisicao[1] = codigoBase;
                comandoExameRequisicao[2] = "codigoRequisicao";
                comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(String.valueOf(filial), req, st2);
                comandoExameRequisicao[4] = "codigoExameRequisicao";
                comandoExameRequisicao[5] = exame;
                comandoExameRequisicao[6] = "materialExameRequisicao";
                comandoExameRequisicao[7] = material;
                comandoExameRequisicao[8] = "descricaoMaterialExameRequisicao";
                comandoExameRequisicao[9] = rs.getString("mco_descricao");
                comandoExameRequisicao[10] = "dataColetaExameRequisicao";
                comandoExameRequisicao[11] = !DBUtil.campoNull(rs.getString("exr_datamaterial")) ? Funcoes.formataData("dd/MM/yyyy", rs.getDate("exr_datamaterial")) : "";
                comandoExameRequisicao[12] = "horaColetaExameRequisicao";
                comandoExameRequisicao[13] = !DBUtil.campoNull(rs.getString("exr_datamaterial")) ? Funcoes.formataHora(rs.getDate("exr_datamaterial"), false) : "";
                comandoExameRequisicao[14] = "paginaExameRequisicao";
                comandoExameRequisicao[15] = "null";
                comandoExameRequisicao[16] = "ordemExameRequisicao";
                comandoExameRequisicao[17] = "null";
                comandoExameRequisicao[18] = "situacaoExameRequisicao";
                comandoExameRequisicao[19] = rs.getString("exr_situacao");
                comandoExameRequisicao[20] = "assinaturaExameRequisicao";
                comandoExameRequisicao[21] = !DBUtil.campoNull(rs.getString("exr_dataassina")) ? rs.getString("usr_codassina") : "";
                comandoExameRequisicao[22] = "nomeAssinaturaExameRequisicao";
                comandoExameRequisicao[23] = !DBUtil.campoNull(rs.getString("exr_dataassina")) ? rs.getString("usr_nome") : "";
                comandoExameRequisicao[24] = "resultadoExameRequisicao";
                String resultadoXML = rs.getString("exr_resultado");
                String resultado = "";
                Map<String, Object> map = null;
                if (!Funcoes.textoVazio(resultadoXML)) {
                    map = ResultadosUtil.geraResultadoParaWeb(st, String.valueOf(filial), req, rs.getString("exa_codigo"), rs.getString("mco_codigo"), resultadoXML, false);
                    resultado = map != null && map.get("laudo") != null ? (String)map.get("laudo") : "";
                }
                comandoExameRequisicao[25] = resultadoPdf ? "" : resultado;
                comandoExameRequisicao[26] = "dataEnvioExameRequisicao";
                comandoExameRequisicao[27] = "current_timestamp";
                comandoExameRequisicao[28] = "resultadoTextoExameRequisicao";
                String resultadoTexto = ResultadosUtil.geraResultadoTextoParaWeb(st, String.valueOf(filial), rs.getString("con_codigo"), rs.getString("des_codigo"), rs.getInt("req_idade"), rs.getString("req_anomes"), exame, Integer.valueOf(material), rs.getString("met_codigo"), resultadoXML);
                comandoExameRequisicao[29] = resultadoPdf ? "" : resultadoTexto;
                DBUtil.insereExportaWeb(String.valueOf(filial), st, "requisicaoexame", operacao.equals("I") ? "I" : (operacao.equals("E") ? "D" : "A"), true, comandoExameRequisicao);
                Map imagens = null;
                String[] comandoExcluiImagens = new String[]{"codigoBase", codigoBase, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(String.valueOf(filial), req, st2), "codigoExameRequisicao", exame, "materialExameRequisicao", material};
                DBUtil.insereExportaWeb(String.valueOf(filial), st, "requisicaoexameimagem", "D", comandoExcluiImagens);
                if (map != null && !(imagens = (Map)map.get("imagens")).isEmpty()) {
                    String[] comandoInserirImagens = new String[12];
                    comandoInserirImagens[0] = "codigoBase";
                    comandoInserirImagens[2] = "codigoRequisicao";
                    comandoInserirImagens[4] = "codigoExameRequisicao";
                    comandoInserirImagens[6] = "materialExameRequisicao";
                    comandoInserirImagens[8] = "codigoImagemExame";
                    comandoInserirImagens[10] = "imagemExame";
                    for (Integer i : imagens.keySet()) {
                        comandoInserirImagens[1] = codigoBase;
                        comandoInserirImagens[3] = IntegracaoUtil.formataCodigoRequisicao(String.valueOf(filial), req, st);
                        comandoInserirImagens[5] = exame;
                        comandoInserirImagens[7] = material;
                        comandoInserirImagens[9] = i.toString();
                        comandoInserirImagens[11] = (String)imagens.get(i);
                        DBUtil.insereExportaWeb(String.valueOf(filial), st, "requisicaoexameimagem", "I", false, comandoInserirImagens);
                    }
                }
                ExportaWeb.atualizaPaginaOrdemExameWeb(st, String.valueOf(filial), req, codigoBase);
                if (operacao.equals("E")) {
                    Util.gravaExclusaoExameRequisicao(st, String.valueOf(filial), req, exame, material);
                } else {
                    Util.gravaAlteracaoExameRequisicao(st, String.valueOf(filial), req, exame, material);
                }
            }
        }
    }
}

