/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.autocopia;

import jalis.comum.Conexao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.DBUtil;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ExportaFiliais {
    public static final String INSERIR = "I";
    public static final String EDITAR = "U";
    public static final String EXCLUIR = "E";

    public static void gravaRequisicao(int filial, long requisicao, String exame, int material, String operacaoRequisicao, String operacaoExame) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement stRemedio = Conexao.getStatement();
        ExportaFiliais.gravaRequisicao(filial, requisicao, exame, material, operacaoRequisicao, operacaoExame, st, stRemedio);
        st.close();
        stRemedio.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaRequisicao(int filial, long requisicao, String exame, int material, String operacaoRequisicao, String operacaoExame, Statement st, Statement stRemedio) throws SQLException {
        String[] filiais = ExportaFiliais.getFiliais(filial, exame, st);
        if (filiais.length == 0) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select * from requisicao where fil_codigo = ");
        buf.append(filial);
        buf.append(" and req_codigo = ");
        buf.append(requisicao);
        ResultSet rs = st.executeQuery(buf.toString());
        Registro camposRequisicao = null;
        if (rs.next()) {
            camposRequisicao = new Registro(rs);
        }
        buf.delete(0, buf.length());
        buf.append("select * from examerequisicao where fil_codigo = ");
        buf.append(filial);
        buf.append(" and req_codigo = ");
        buf.append(requisicao);
        buf.append(" and exa_codigo = '");
        buf.append(exame);
        buf.append("' and mco_codigo =  ");
        buf.append(material);
        Registro camposExame = null;
        try {
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                camposExame = new Registro(rs);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        for (String codigoFilial : filiais) {
            buf.delete(0, buf.length());
            buf.append("insert into exportafiliais(fil_codigo, efi_codigo, efi_datahora, ");
            buf.append(" efi_exportado, efi_operacao, efi_tipooperacao) values (");
            buf.append(codigoFilial);
            buf.append(", nextval('exportafiliais_");
            buf.append(codigoFilial);
            buf.append("_sequence'), current_timestamp, false, '");
            buf.append("<requisicao>");
            buf.append(ExportaFiliais.criaXML(camposRequisicao));
            buf.append("</requisicao>");
            buf.append("', '");
            buf.append(operacaoRequisicao);
            buf.append("')");
            st.execute(buf.toString());
            buf.delete(0, buf.length());
            buf.append("insert into exportafiliais(fil_codigo, efi_codigo, efi_datahora, ");
            buf.append(" efi_exportado, efi_operacao, efi_tipooperacao) values (");
            buf.append(codigoFilial);
            buf.append(", nextval('exportafiliais_");
            buf.append(codigoFilial);
            buf.append("_sequence'), current_timestamp, false, '");
            buf.append("<examerequisicao>");
            String xExame = ExportaFiliais.criaXML(camposExame);
            buf.append(xExame);
            buf.append("</examerequisicao>");
            buf.append("', '");
            buf.append(operacaoExame);
            buf.append("')");
            st.execute(buf.toString());
            buf.delete(0, buf.length());
            buf.append("insert into exportafiliais(fil_codigo, efi_codigo, efi_datahora, ");
            buf.append(" efi_exportado, efi_operacao, efi_tipooperacao) values (");
            buf.append(codigoFilial);
            buf.append(", nextval('exportafiliais_");
            buf.append(codigoFilial);
            buf.append("_sequence'), current_timestamp, false, '");
            buf.append("<requisicaomedicamento>");
            buf.append("<campo><nome>fil_codigo</nome><tipo>");
            buf.append(2);
            buf.append("</tipo><valor>");
            buf.append(filial);
            buf.append("</valor><chave>1</chave>");
            buf.append("</campo>");
            buf.append("<campo><nome>req_codigo</nome><tipo>");
            buf.append(2);
            buf.append("</tipo><valor>");
            buf.append(requisicao);
            buf.append("</valor><chave>1</chave>");
            buf.append("</campo>");
            buf.append(" </requisicaomedicamento>");
            buf.append("', '");
            buf.append(EXCLUIR);
            buf.append("')");
            st.execute(buf.toString());
            buf.delete(0, buf.length());
            buf.append("select * from requisicaomedicamento where fil_codigo = ");
            buf.append(filial);
            buf.append(" and req_codigo = ");
            buf.append(requisicao);
            try {
                rs = st.executeQuery(buf.toString());
                if (rs.next()) {
                    Registro camposMedicamento = null;
                    do {
                        camposMedicamento = new Registro(rs);
                        buf.delete(0, buf.length());
                        buf.append("insert into exportafiliais(fil_codigo, efi_codigo, efi_datahora, ");
                        buf.append(" efi_exportado, efi_operacao, efi_tipooperacao) values (");
                        buf.append(codigoFilial);
                        buf.append(", nextval('exportafiliais_");
                        buf.append(codigoFilial);
                        buf.append("_sequence'), current_timestamp, false, '");
                        buf.append("<requisicaomedicamento>");
                        buf.append(ExportaFiliais.criaXML(camposMedicamento));
                        buf.append("</requisicaomedicamento>");
                        buf.append("', '");
                        buf.append(INSERIR);
                        buf.append("')");
                        stRemedio.execute(buf.toString());
                    } while (rs.next());
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            buf.delete(0, buf.length());
            buf.append("insert into exportafiliais(fil_codigo, efi_codigo, efi_datahora, ");
            buf.append(" efi_exportado, efi_operacao, efi_tipooperacao) values (");
            buf.append(codigoFilial);
            buf.append(", nextval('exportafiliais_");
            buf.append(codigoFilial);
            buf.append("_sequence'), current_timestamp, false, '");
            buf.append("<requisicaocid10>");
            buf.append("<campo><nome>fil_codigo</nome><tipo>");
            buf.append(2);
            buf.append("</tipo><valor>");
            buf.append(filial);
            buf.append("</valor><chave>1</chave>");
            buf.append("</campo>");
            buf.append("<campo><nome>req_codigo</nome><tipo>");
            buf.append(2);
            buf.append("</tipo><valor>");
            buf.append(requisicao);
            buf.append("</valor><chave>1</chave>");
            buf.append("</campo>");
            buf.append(" </requisicaocid10>");
            buf.append("', '");
            buf.append(EXCLUIR);
            buf.append("')");
            st.execute(buf.toString());
            buf.delete(0, buf.length());
            buf.append("select * from requisicaocid10 where fil_codigo = ");
            buf.append(filial);
            buf.append(" and req_codigo = ");
            buf.append(requisicao);
            try {
                rs = st.executeQuery(buf.toString());
                if (!rs.next()) continue;
                Registro camposCid10 = null;
                do {
                    camposCid10 = new Registro(rs);
                    buf.delete(0, buf.length());
                    buf.append("insert into exportafiliais(fil_codigo, efi_codigo, efi_datahora, ");
                    buf.append(" efi_exportado, efi_operacao, efi_tipooperacao) values (");
                    buf.append(codigoFilial);
                    buf.append(", nextval('exportafiliais_");
                    buf.append(codigoFilial);
                    buf.append("_sequence'), current_timestamp, false, '");
                    buf.append("<requisicaocid10>");
                    buf.append(ExportaFiliais.criaXML(camposCid10));
                    buf.append("</requisicaocid10>");
                    buf.append("', '");
                    buf.append(INSERIR);
                    buf.append("')");
                    stRemedio.execute(buf.toString());
                } while (rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    public static void gravaExclusaoRequisicao(int filial, int requisicao) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("select * from requisicao where fil_codigo = ");
        buf.append(filial);
        buf.append(" and req_codigo = ");
        buf.append(requisicao);
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        Registro camposRequisicao = null;
        if (rs.next()) {
            camposRequisicao = new Registro(rs);
        }
        int fil = -1;
        int req = -1;
        if (camposRequisicao != null && camposRequisicao.getValor("fil_codcopia") != null) {
            fil = camposRequisicao.getInt("fil_codcopia");
            req = camposRequisicao.getInt("req_codcopia");
        }
        if (fil == -1 || req == -1) {
            return;
        }
        buf.delete(0, buf.length());
        buf.append("select fil_codigo, req_codigo from requisicao where fil_codcopia = ");
        buf.append(fil);
        buf.append(" and req_codcopia = ");
        buf.append(req);
        rs = Conexao.executeQuery(st, buf.toString());
        while (rs.next()) {
            if (rs.getInt("fil_codigo") == fil && rs.getInt("req_codigo") == req) continue;
            Registro r = new Registro(rs);
            buf.setLength(0);
            buf.append("select exa_codigo, mco_codigo from examerequisicao where ");
            buf.append("fil_codigo = ").append(r.getString("fil_codigo"));
            buf.append(" and req_codigo = ").append(r.getString("req_codigo"));
            ResultSet rs2 = Conexao.executeQuery(st2, buf);
            while (rs2.next()) {
                RecepcaoUtil.avisaResponsavelSetor(false, st3, r.getString("fil_codigo"), r.getString("req_codigo"), rs2.getString("exa_codigo"), rs2.getString("mco_codigo"), 1);
            }
            buf.delete(0, buf.length());
            buf.append("insert into exportafiliais(fil_codigo, efi_codigo, efi_datahora, ");
            buf.append(" efi_exportado, efi_operacao, efi_tipooperacao) values (");
            buf.append(rs.getString("fil_codigo"));
            buf.append(", nextval('exportafiliais_");
            buf.append(rs.getString("fil_codigo"));
            buf.append("_sequence'), current_timestamp, false, '");
            buf.append("<requisicao>");
            buf.append(ExportaFiliais.criaXML(r));
            buf.append("</requisicao>");
            buf.append("', '");
            buf.append(EDITAR);
            buf.append("')");
            Conexao.execute(rs.getString("fil_codigo"), st2, buf.toString());
        }
        Conexao.fecharStatement(st, st2, st3);
    }

    private static String[] getFiliais(int filial, String exame) throws SQLException {
        Statement st = Conexao.getStatement();
        String[] retorno = ExportaFiliais.getFiliais(filial, exame, st);
        Conexao.fecharStatement(st);
        return retorno;
    }

    private static String[] getFiliais(int filial, String exame, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select exa_codigo, fil_coddestino from filiaisexamesexportar where ");
        buf.append("fil_codigo = ");
        buf.append(filial);
        buf.append(" and exa_codigo = '");
        buf.append(exame);
        buf.append("' order by fil_coddestino ");
        ResultSet rs = st.executeQuery(buf.toString());
        String[] filiais = new String[DBUtil.qtdeRegistros(rs)];
        int pos = 0;
        while (rs.next()) {
            filiais[pos++] = rs.getString("fil_coddestino");
        }
        return filiais;
    }

    private static String criaXML(Registro reg) {
        StringBuilder buf = new StringBuilder();
        for (String key : reg.getKeySet()) {
            buf.append("<campo><nome>");
            buf.append(key);
            buf.append("</nome><tipo>");
            int tipoCampo = 0;
            Object valor = reg.getValor(key);
            tipoCampo = valor == null ? 2 : (reg.isBoolean(key) ? 4 : (reg.isNumber(key) ? 2 : (reg.isDate(key) ? 1 : (reg.isTime(key) ? 3 : (reg.isTimestamp(key) ? 5 : 0)))));
            buf.append(tipoCampo);
            buf.append("</tipo><valor>");
            buf.append(valor instanceof String ? StringUtil.textoDB(ExportaFiliais.trocaSinais(valor.toString(), false)) : valor);
            buf.append("</valor><chave>");
            buf.append(ExportaFiliais.isPK(key) ? "1" : "0");
            buf.append("</chave></campo>");
        }
        return buf.toString();
    }

    private static boolean isPK(String coluna) {
        return coluna.equalsIgnoreCase("fil_codigo") || coluna.equalsIgnoreCase("req_codigo") || coluna.equalsIgnoreCase("exa_codigo") || coluna.equalsIgnoreCase("mco_codigo");
    }

    public static String trocaSinais(String texto, boolean retornar) {
        if (retornar) {
            return texto.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        }
        return texto.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

