/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.CampoDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.TemplateDTO;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.MapaResolverExpressoesUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WhatsAppUtil {
    private static final String DD_MM_YYYY = "dd/MM/yyyy";
    private static final String CODIGOFILIAL = "codigofilial";
    private static final String CODIGOREQUISICAO = "codigorequisicao";
    private static final String CODIGO_REQUISICAO = "codigoRequisicao";
    private static final String CODIGO_FILIAL = "codigoFilial";
    private static final String CODIGO_PACIENTE = "codigoPaciente";
    private static final String WHATSAPP_PACIENTE = "whatsappPaciente";
    private static final String CELULAR_PACIENTE = "celularPaciente";
    private static final String WHATSAPP_AGENDAMENTO = "whatsappAgendamento";
    private static final String WHATSAPP_REQUISICAO = "whatsappRequisicao";
    private static final String WHATSAPP_SENHA_WEB = "whatsappSenhaWeb";
    private static final String WHATSAPP_RESULTADO = "whatsappResultado";
    private static final String WHATSAPP_RECOLETA = "whatsappRecoleta";
    private static final String WHATSAPP_ANIVERSARIO = "whatsappAniversario";
    private static final String REGEX_MASCARA_CELULAR = "^\\(?\\d{2}\\)?[\\s-]?[\\s9]?\\d{4}-?\\d{4}$";
    private static final String REGEX_MASCARA_CELULAR_PONTO = "^\\(?\\d{2}\\)?[\\s-]?[\\s9]?\\d{4}.?\\d{4}$";
    public static final int WPP_ENVIADO = 0;
    public static final int WPP_BLOQUEADO_PACIENTE = 1;
    public static final int WPP_JA_ENVIADO = 2;
    public static final int WPP_FILIAL_NAO_PERMITE = 3;
    private static final int TIPO_BLOQUEIO_WPP_CONVENIO_ANIVERSARIO = 0;
    private static final int TIPO_BLOQUEIO_WPP_CONVENIO_RECOLETA = 1;
    private static final int TIPO_BLOQUEIO_WPP_CONVENIO_RESULTADO = 2;
    private static String sqlInsereLog = null;
    private static String sqlDadosWhatsapp = null;
    private static String sqlDadosPaciente = null;
    private static String sqlMultiguiasEnviaramWhatsapp = null;
    private static String sqlQuantidadeExamesMultiguias = null;
    private static String sqlQuantidadeExamesProntosMultiguias = null;
    private static String sqlBloqueiosEnvioWhatsappConvenio = null;

    private WhatsAppUtil() {
    }

    public static boolean enviarWhatsapp(String codigoFilial, String celular, String jsonCampos, TipoWhatsapp tipoWhatsapp, Statement st, String codigoRequisicao, String codigoPaciente) throws NumberFormatException, SQLException {
        return WhatsAppUtil.enviarWhatsapp(codigoFilial, celular, jsonCampos, tipoWhatsapp, st, codigoRequisicao, codigoPaciente, ParametrosGerais.getTipoIntegracao());
    }

    public static boolean enviarWhatsapp(String codigoFilial, String celular, String jsonCampos, TipoWhatsapp tipoWhatsapp, Statement st, String codigoRequisicao, String codigoPaciente, String tipoWhatsappfilial) throws NumberFormatException, SQLException {
        PreparedStatement prstInsereLog = null;
        if (!Funcoes.textoVazio(celular = WhatsAppUtil.limpaCelular(celular))) {
            StringBuilder buf;
            jsonCampos = StringUtil.removerAcentos(jsonCampos);
            jsonCampos = StringUtil.textoDB(jsonCampos);
            if (tipoWhatsapp.equals((Object)TipoWhatsapp.FINANCEIRO)) {
                buf = new StringBuilder();
                buf.append(" insert into logwhatsapp(fil_codigo, wpp_codigo, wpp_datahora, wpp_situacao, wpp_celular, wpp_campos, wpp_origem, wpp_filial) values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logwhatsapp_").append(Integer.parseInt(codigoFilial)).append("_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(jsonCampos).append("'");
                buf.append(", '").append(tipoWhatsapp.getCodigo()).append("'");
                buf.append(", '").append(tipoWhatsappfilial).append("'");
                buf.append(")");
                sqlInsereLog = buf.toString();
            }
            if (WhatsAppUtil.tipoAniversarioSenhaWeb(tipoWhatsapp)) {
                buf = new StringBuilder();
                buf.append(" insert into logwhatsapp ");
                buf.append("  (fil_codigo, wpp_codigo, wpp_datahora, wpp_situacao, wpp_celular, wpp_campos, wpp_origem, pac_codigo, wpp_filial) values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logwhatsapp_").append(Integer.parseInt(codigoFilial)).append("_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(jsonCampos).append("'");
                buf.append(", '").append(tipoWhatsapp.getCodigo()).append("'");
                buf.append(", ").append(Integer.parseInt(codigoPaciente));
                buf.append(", '").append(tipoWhatsappfilial).append("'");
                buf.append(")");
                sqlInsereLog = buf.toString();
            }
            if (WhatsAppUtil.tipoRecoletaResultadoRequisicaoAgendamento(tipoWhatsapp)) {
                buf = new StringBuilder();
                buf.append(" insert into logwhatsapp ");
                buf.append("  (fil_codigo, wpp_codigo, wpp_datahora, wpp_situacao, wpp_celular, wpp_campos, wpp_origem, req_codigo, pac_codigo, wpp_filial) values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logwhatsapp_").append(Integer.parseInt(codigoFilial)).append("_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(jsonCampos).append("'");
                buf.append(", '").append(tipoWhatsapp.getCodigo()).append("'");
                buf.append(", ").append(Integer.parseInt(codigoRequisicao));
                buf.append(", ").append(Integer.parseInt(codigoPaciente));
                buf.append(", '").append(tipoWhatsappfilial).append("'");
                buf.append(")");
                sqlInsereLog = buf.toString();
            }
            if ((prstInsereLog = WhatsAppUtil.getPreparedStatement(st.getConnection(), sqlInsereLog)) != null) {
                prstInsereLog.executeUpdate();
            }
            if (WhatsAppUtil.tipoFilialIntegracao(tipoWhatsappfilial)) {
                buf = new StringBuilder();
                buf.append(" insert into logwhatsapp (fil_codigo, wpp_codigo, wpp_datahora, wpp_situacao, wpp_celular, wpp_campos, wpp_origem, wpp_filial");
                WhatsAppUtil.validaPacienteRequisicao(codigoRequisicao, codigoPaciente, buf);
                buf.append(") values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logwhatsapp_" + codigoFilial + "_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(jsonCampos).append("'");
                buf.append(", '").append(tipoWhatsapp.getCodigo()).append("'");
                buf.append(", '").append(tipoWhatsappfilial).append("'");
                WhatsAppUtil.addValorPacienteRequisicao(codigoRequisicao, codigoPaciente, buf);
                buf.append(")");
                IntegracaoUtil.insereComandoLog(st, codigoFilial, codigoFilial, buf.toString());
            }
            return true;
        }
        return false;
    }

    public static boolean criaLogWhatsappComDadosRequisicao(String codigoFilial, String codigoRequisicao, TipoWhatsapp tipoWhatsapp, Statement st, Statement st2) throws NumberFormatException, SQLException {
        return WhatsAppUtil.criaLogWhatsappComDadosRequisicao(codigoFilial, codigoRequisicao, tipoWhatsapp, st, st2, ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getConferencia(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), Variaveis.codigoBaseWeb);
    }

    public static boolean criaLogWhatsappComDadosRequisicao(String codigoFilial, String codigoRequisicao, TipoWhatsapp tipoWhatsapp, Statement st, Statement st2, String tipoWhatsappFilial, boolean conferencia, int digitosTuboFilial, int digitosTuboRequisicao, String codigoBaseWeb) throws NumberFormatException, SQLException {
        PreparedStatement prstDadosWhatsapp = null;
        WhatsAppUtil.validaCampos(codigoFilial, codigoRequisicao, tipoWhatsapp);
        prstDadosWhatsapp = WhatsAppUtil.getPreparedStatement(st.getConnection(), sqlDadosWhatsapp);
        ResultSet rs = null;
        if (prstDadosWhatsapp != null) {
            prstDadosWhatsapp.setInt(1, Integer.parseInt(codigoFilial));
            prstDadosWhatsapp.setInt(2, Integer.parseInt(codigoRequisicao));
            rs = prstDadosWhatsapp.executeQuery();
        }
        if (WhatsAppUtil.naoPossuiRetorno(rs)) {
            return false;
        }
        String whatsApp = null;
        if (WhatsAppUtil.isEnviarWhatsAppAniversario(tipoWhatsapp, st, rs)) {
            whatsApp = rs.getString(WHATSAPP_ANIVERSARIO);
        } else if (WhatsAppUtil.isEnviarWhatsAppRecoleta(tipoWhatsapp, st, rs)) {
            whatsApp = rs.getString(WHATSAPP_RECOLETA);
        } else if (WhatsAppUtil.isEnviarWhatsAppResultado(tipoWhatsapp, st, rs, conferencia)) {
            whatsApp = rs.getString(WHATSAPP_RESULTADO);
        } else if (WhatsAppUtil.isEnviarWhatsAppSenhaWeb(tipoWhatsapp, rs)) {
            whatsApp = rs.getString(WHATSAPP_SENHA_WEB);
        } else if (WhatsAppUtil.isEnviarWhatsAppRequisicao(tipoWhatsapp, rs)) {
            whatsApp = rs.getString(WHATSAPP_REQUISICAO);
        } else if (WhatsAppUtil.isEnviarWhatsAppAgendamento(tipoWhatsapp, rs)) {
            whatsApp = rs.getString(WHATSAPP_AGENDAMENTO);
        }
        if (Funcoes.textoVazio(whatsApp)) {
            return false;
        }
        String celularPaciente = rs.getString(CELULAR_PACIENTE);
        String whatsappPaciente = rs.getString(WHATSAPP_PACIENTE);
        String codigoPaciente = rs.getString(CODIGO_PACIENTE);
        if (WhatsAppUtil.isMensagemCelularValido(whatsApp, celularPaciente, whatsappPaciente)) {
            boolean enviado = WhatsAppUtil.enviarWhatsapp(codigoFilial, WhatsAppUtil.isCelularVazio(whatsappPaciente) ? celularPaciente : whatsappPaciente, WhatsAppUtil.parseCamposTemplateWhatsapp(whatsApp, WhatsAppUtil.getHashMapCampos(codigoFilial, rs, st2, false, digitosTuboFilial, digitosTuboRequisicao, codigoBaseWeb)), tipoWhatsapp, st, codigoRequisicao, codigoPaciente, tipoWhatsappFilial);
            return WhatsAppUtil.comitaWppEnviado(codigoFilial, codigoRequisicao, tipoWhatsapp, st, enviado);
        }
        return false;
    }

    private static boolean comitaWppEnviado(String codigoFilial, String codigoRequisicao, TipoWhatsapp tipoWhatsapp, Statement st, boolean enviado) throws SQLException {
        if (enviado) {
            if (tipoWhatsapp.equals((Object)TipoWhatsapp.RESULTADO)) {
                StringBuilder buf = new StringBuilder();
                buf.append(" update requisicao ");
                buf.append("    set req_wppresultadoenviada = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
                buf.append("  where fil_codigo = ").append(codigoFilial);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                st.executeUpdate(buf.toString());
            }
            st.getConnection().commit();
            return true;
        }
        st.getConnection().rollback();
        return false;
    }

    private static boolean isEnviarWhatsAppAgendamento(TipoWhatsapp tipoWhatsapp, ResultSet rs) throws SQLException {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.AGENDAMENTO) && WhatsAppUtil.podeEnviarWhatsappAgendamento(rs);
    }

    private static boolean isEnviarWhatsAppRequisicao(TipoWhatsapp tipoWhatsapp, ResultSet rs) throws SQLException {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.REQUISICAO) && WhatsAppUtil.podeEnviarWhatsappRequisicao(rs);
    }

    private static boolean isEnviarWhatsAppSenhaWeb(TipoWhatsapp tipoWhatsapp, ResultSet rs) throws SQLException {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.SENHA_WEB) && WhatsAppUtil.podeEnviarWhatsappSenhaWeb(rs);
    }

    private static boolean isEnviarWhatsAppResultado(TipoWhatsapp tipoWhatsapp, Statement st, ResultSet rs) throws SQLException {
        return WhatsAppUtil.isEnviarWhatsAppResultado(tipoWhatsapp, st, rs, ParametrosGerais.getConferencia());
    }

    private static boolean isEnviarWhatsAppResultado(TipoWhatsapp tipoWhatsapp, Statement st, ResultSet rs, boolean conferencia) throws SQLException {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.RESULTADO) && WhatsAppUtil.podeEnviarWhatsappResultado(rs, st, conferencia) && !rs.getBoolean("wppresultadoenviado");
    }

    private static boolean isEnviarWhatsAppRecoleta(TipoWhatsapp tipoWhatsapp, Statement st, ResultSet rs) throws SQLException {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.RECOLETA) && WhatsAppUtil.podeEnviarWhatsappRecoleta(rs, st);
    }

    private static boolean isEnviarWhatsAppAniversario(TipoWhatsapp tipoWhatsapp, Statement st, ResultSet rs) throws SQLException {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.ANIVERSARIO) && WhatsAppUtil.podeEnviarWhatsappAniversario(rs, st);
    }

    private static boolean isMensagemCelularValido(String whatsApp, String celularPaciente, String whatsappPaciente) {
        return !Funcoes.textoVazio(whatsApp) && (!WhatsAppUtil.isCelularVazio(celularPaciente) || !WhatsAppUtil.isCelularVazio(whatsappPaciente));
    }

    private static boolean naoPossuiRetorno(ResultSet rs) throws SQLException {
        return rs == null || !rs.next() || !rs.getBoolean("enviarWhatsapp");
    }

    public static boolean criaLogWhatsappSemDadosRequisicao(String codigoFilial, String codigoPaciente, TipoWhatsapp tipoWhatsapp, Statement st, Statement st2) throws NullPointerException, SQLException {
        return WhatsAppUtil.criaLogWhatsappSemDadosRequisicao(codigoFilial, codigoPaciente, tipoWhatsapp, st, st2, ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getConferencia());
    }

    public static boolean criaLogWhatsappSemDadosRequisicao(String codigoFilial, String codigoPaciente, TipoWhatsapp tipoWhatsapp, Statement st, Statement st2, String tipoWhatsappFilial, boolean conferencia) throws NullPointerException, SQLException {
        PreparedStatement prstDadosPaciente = null;
        WhatsAppUtil.validaCampos(codigoFilial, codigoPaciente, tipoWhatsapp);
        prstDadosPaciente = WhatsAppUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
        if (prstDadosPaciente == null) {
            throw new NullPointerException("N\u00e3o foi poss\u00edvel buscar dados do paciente.");
        }
        prstDadosPaciente.setInt(1, Integer.parseInt(codigoFilial));
        prstDadosPaciente.setInt(2, Integer.parseInt(codigoPaciente));
        ResultSet rs = prstDadosPaciente.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarWhatsapp")) {
            return false;
        }
        String whatsapp = null;
        if (WhatsAppUtil.isEnviarWhatsAppAniversario(tipoWhatsapp, st, rs)) {
            whatsapp = rs.getString(WHATSAPP_ANIVERSARIO);
        } else if (WhatsAppUtil.isEnviarWhatsAppRecoleta(tipoWhatsapp, st, rs)) {
            whatsapp = rs.getString(WHATSAPP_RECOLETA);
        } else if (WhatsAppUtil.isEnviarWhatsAppResultado(tipoWhatsapp, st, rs, conferencia)) {
            whatsapp = rs.getString(WHATSAPP_RESULTADO);
        } else if (WhatsAppUtil.isEnviarWhatsAppSenhaWeb(tipoWhatsapp, rs)) {
            whatsapp = rs.getString(WHATSAPP_SENHA_WEB);
        } else if (WhatsAppUtil.isEnviarWhatsAppRequisicao(tipoWhatsapp, rs)) {
            whatsapp = rs.getString(WHATSAPP_REQUISICAO);
        } else if (WhatsAppUtil.isEnviarWhatsAppAgendamento(tipoWhatsapp, rs)) {
            whatsapp = rs.getString(WHATSAPP_AGENDAMENTO);
        }
        if (Funcoes.textoVazio(whatsapp)) {
            return false;
        }
        String celularPaciente = rs.getString(CELULAR_PACIENTE);
        String whatsappPaciente = rs.getString(WHATSAPP_PACIENTE);
        String codigoRequisicao = null;
        if (WhatsAppUtil.isMensagemCelularValido(whatsapp, celularPaciente, whatsappPaciente)) {
            boolean enviado = WhatsAppUtil.enviarWhatsapp(codigoFilial, WhatsAppUtil.isCelularVazio(whatsappPaciente) ? celularPaciente : whatsappPaciente, WhatsAppUtil.parseCamposTemplateWhatsapp(whatsapp, WhatsAppUtil.getHashMapCampos(codigoFilial, rs, st2, true)), tipoWhatsapp, st, codigoRequisicao, codigoPaciente, tipoWhatsappFilial);
            return WhatsAppUtil.arquivaEnvio(st, enviado);
        }
        return false;
    }

    private static boolean arquivaEnvio(Statement st, boolean enviado) throws SQLException {
        if (enviado) {
            st.getConnection().commit();
            return true;
        }
        st.getConnection().rollback();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearWhatsappExamePronto(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select d.des_bloquearwhatsappexamepronto as des_bloquearwhatsappexamepronto, m.med_bloquearwhatsappexamepronto as med_bloquearwhatsappexamepronto");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = WhatsAppUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                if (prstEnviar != null) {
                    rs = prstEnviar.executeQuery();
                    while (rs.next()) {
                        retorno = rs.getBoolean("des_bloquearwhatsappexamepronto") || rs.getBoolean("med_bloquearwhatsappexamepronto");
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearWhatsappRecoleta(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select d.des_bloquearwhatsapprecoleta as des_bloquearwhatsapprecoleta, m.med_bloquearwhatsapprecoleta as med_bloquearwhatsapprecoleta");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = WhatsAppUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                if (prstEnviar != null) {
                    rs = prstEnviar.executeQuery();
                    while (rs.next()) {
                        retorno = rs.getBoolean("des_bloquearwhatsapprecoleta") || rs.getBoolean("med_bloquearwhatsapprecoleta");
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarWhatsappSenhaWeb(String codigoFilial, Statement st, boolean fecharStatement) {
        boolean retorno = false;
        try {
            block9: {
                StringBuilder buf = new StringBuilder();
                buf.append(" select fil_enviarwhatsapp ");
                buf.append("       ,fil_whatsappsenhaweb ");
                buf.append("   from filiais_postocoleta ");
                buf.append("  where fil_codigo = ? ");
                PreparedStatement prstEnviar = WhatsAppUtil.getPreparedStatement(st.getConnection(), buf.toString());
                if (prstEnviar == null) {
                    return false;
                }
                prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
                ResultSet rs = null;
                try {
                    rs = prstEnviar.executeQuery();
                    while (rs.next()) {
                        retorno = rs.getBoolean("fil_enviarwhatsapp") && rs.getBoolean("fil_whatsappsenhaweb");
                    }
                    if (rs == null) break block9;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        rs.close();
                    }
                    if (fecharStatement) {
                        Conexao.fecharStatement(st);
                    }
                    throw throwable;
                }
                rs.close();
            }
            if (fecharStatement) {
                Conexao.fecharStatement(st);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    public static String parseCamposTemplateWhatsapp(String jsonCampos, Map<String, Object> valores) {
        TemplateDTO template = TemplateDTO.parse(jsonCampos);
        for (CampoDTO campo : template.getHeader().getCampos()) {
            campo.setValor(WhatsAppUtil.parseValores(valores, new StringBuilder(campo.getValor())));
        }
        for (CampoDTO campo : template.getBody().getCampos()) {
            campo.setValor(WhatsAppUtil.parseValores(valores, new StringBuilder(campo.getValor())));
        }
        for (CampoDTO campo : template.getFooter().getCampos()) {
            campo.setValor(WhatsAppUtil.parseValores(valores, new StringBuilder(campo.getValor())));
        }
        for (CampoDTO campo : template.getButtons().getCampos()) {
            campo.setValor(WhatsAppUtil.parseValores(valores, new StringBuilder(campo.getValor())));
        }
        return template.toString();
    }

    public static String parseValores(Map<String, Object> valores, StringBuilder valorCampo) {
        if (valorCampo.toString().contains("2!")) {
            StringBuilder bui = new StringBuilder();
            String[] expressoes = MapaResolverExpressoesUtil.resolverExpressoes(valorCampo.toString(), MapaResolverExpressoesUtil.getCampos(SMSUtil.getInformacoesSMS(valores)), null, valores, false);
            for (int i = 0; i < expressoes.length; ++i) {
                expressoes[i] = StringUtil.removerAcentos(expressoes[i]);
            }
            MapaResolverExpressoesUtil.adicionarStrings(bui, expressoes, "", false);
            valorCampo = bui;
        } else {
            int pos = -1;
            while ((pos = valorCampo.indexOf("[")) > -1) {
                int posFim = valorCampo.indexOf("]", pos);
                String chave = valorCampo.substring(pos + 1, posFim);
                String valor = chave != null && valores.get(chave.trim().toLowerCase()) != null ? (String)valores.get(chave.trim().toLowerCase()) : "";
                valorCampo.delete(pos, posFim + 1);
                valorCampo.insert(pos, valor);
            }
        }
        return valorCampo.toString();
    }

    private static HashMap<String, Object> getHashMapCampos(String filial, ResultSet rs, Statement st, boolean isDadosPaciente) throws SQLException {
        return WhatsAppUtil.getHashMapCampos(filial, rs, st, isDadosPaciente, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), Variaveis.codigoBaseWeb);
    }

    private static HashMap<String, Object> getHashMapCampos(String filial, ResultSet rs, Statement st, boolean isDadosPaciente, int digitosTuboFilial, int digitosTuboRequisicao, String baseWeb) throws SQLException {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        if (!Funcoes.textoVazio(rs.getString(CODIGO_PACIENTE))) {
            mapa.put("codigopaciente", rs.getString(CODIGO_PACIENTE));
        }
        if (!isDadosPaciente) {
            WhatsAppUtil.getCamposRequisicao(filial, rs, st, mapa, digitosTuboFilial, digitosTuboRequisicao, baseWeb);
        } else {
            mapa.put("codigopacienteweb", rs.getString(CODIGO_PACIENTE));
        }
        if (!Funcoes.textoVazio(rs.getString("descricaoFilial"))) {
            mapa.put("descricaofilial", rs.getString("descricaoFilial"));
        }
        if (!Funcoes.textoVazio(rs.getString("enderecoFilial"))) {
            mapa.put("enderecofilial", rs.getString("enderecoFilial"));
        }
        if (!Funcoes.textoVazio(rs.getString("telefonefilial"))) {
            mapa.put("telefonefilial", rs.getString("telefonefilial"));
        }
        if (!Funcoes.textoVazio(rs.getString("cpfPaciente"))) {
            mapa.put("cpfpaciente", rs.getString("cpfPaciente"));
        }
        if (!Funcoes.textoVazio(rs.getString("senhaWebPaciente"))) {
            mapa.put("senhawebpaciente", rs.getString("senhaWebPaciente"));
        }
        if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
            mapa.put("nomepaciente", rs.getString("nomePaciente"));
        }
        mapa.put("nomesocialpaciente", WhatsAppUtil.getNomeSocial(rs));
        return mapa;
    }

    private static String getNomeSocial(ResultSet rs) throws SQLException {
        if (!Funcoes.textoVazio(rs.getString("nomeSocialPaciente"))) {
            return rs.getString("nomeSocialPaciente");
        }
        if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
            return rs.getString("nomePaciente");
        }
        return "";
    }

    private static void getCamposRequisicao(String filial, ResultSet rs, Statement st, HashMap<String, Object> mapa, int digitosTuboFilial, int digitosTuboRequisicao, String baseWeb) throws SQLException {
        if (!Funcoes.textoVazio(rs.getString(CODIGO_REQUISICAO))) {
            String codigo = IntegracaoUtil.formataCodigoRequisicao(filial, rs.getString(CODIGO_REQUISICAO), st, digitosTuboFilial, digitosTuboRequisicao);
            mapa.put(CODIGOREQUISICAO, codigo);
        }
        mapa.put("senhawebrequisicao", WhatsAppUtil.testaVazio(rs.getString("senhaWebRequisicao")));
        if (!Funcoes.textoVazio(rs.getString("dataRequisicao"))) {
            mapa.put("datarequisicao", Funcoes.formataData(DD_MM_YYYY, rs.getDate("dataRequisicao")));
        }
        if (!Funcoes.textoVazio(rs.getString("dataEntregaPrevistaRequisicao"))) {
            mapa.put("dataentregaprevistarequisicao", Funcoes.formataData(DD_MM_YYYY, rs.getDate("dataEntregaPrevistaRequisicao")));
        }
        if (!Funcoes.textoVazio(rs.getString("horaEntregaPrevistaRequisicao"))) {
            mapa.put("horaentregaprevistarequisicao", Funcoes.formataDataHora("HH:mm", rs.getString("horaEntregaPrevistaRequisicao")));
        }
        if (!Funcoes.textoVazio(rs.getString("dataAgenda"))) {
            mapa.put("dataagenda", Funcoes.formataData(DD_MM_YYYY, rs.getDate("dataAgenda")));
        }
        if (!Funcoes.textoVazio(rs.getString("horaAgenda"))) {
            mapa.put("horaagenda", Funcoes.formataDataHora("HH:mm", rs.getString("horaAgenda")));
        }
        mapa.put("telefonefilial", rs.getString("telefonefilial"));
        mapa.put("chaveacessorequisicao", ResultadosUtil.getChaveAcessoRequisicao(st, filial, rs.getString(CODIGO_REQUISICAO), rs.getString("senhaWebRequisicao"), baseWeb, digitosTuboFilial, digitosTuboRequisicao));
    }

    private static String testaVazio(String valor) {
        return Funcoes.textoVazio(valor) ? "" : valor;
    }

    public static boolean isCelularVazio(String celular) {
        return Funcoes.textoVazio(WhatsAppUtil.limpaCelular(celular)) || !celular.matches(REGEX_MASCARA_CELULAR) || !celular.matches(REGEX_MASCARA_CELULAR_PONTO);
    }

    private static boolean podeEnviarWhatsappAgendamento(ResultSet rs) throws SQLException {
        return WhatsAppUtil.podeEnviarWhatsappPaciente(rs) && rs.getBoolean("enviarWhatsappAgendamento") && !Funcoes.textoVazio(rs.getString(WHATSAPP_AGENDAMENTO));
    }

    private static boolean podeEnviarWhatsappRequisicao(ResultSet rs) throws SQLException {
        return WhatsAppUtil.podeEnviarWhatsappPaciente(rs) && rs.getBoolean("enviarWhatsappRequisicao") && !Funcoes.textoVazio(rs.getString(WHATSAPP_REQUISICAO));
    }

    private static boolean podeEnviarWhatsappSenhaWeb(ResultSet rs) throws SQLException {
        return WhatsAppUtil.podeEnviarWhatsappPaciente(rs) && rs.getBoolean("enviarWhatsappSenhaWeb") && !Funcoes.textoVazio(rs.getString(WHATSAPP_SENHA_WEB));
    }

    private static void validaCampos(String codigoFilial, String codigoRequisicao, TipoWhatsapp tipoWhatsapp) throws NullPointerException {
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new NullPointerException("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoRequisicao)) {
            throw new NullPointerException("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o informado.");
        }
        if (tipoWhatsapp == null) {
            throw new NullPointerException("Tipo do Whatsapp n\u00e3o informado.");
        }
    }

    private static boolean podeEnviarWhatsappRecoleta(ResultSet rs, Statement st) throws SQLException {
        return WhatsAppUtil.podeEnviarWhatsappPaciente(rs) && WhatsAppUtil.podeEnviarWhatsappConvenio(rs, st, 1) && rs.getBoolean("enviarWhatsappRecoleta") && !Funcoes.textoVazio(rs.getString(WHATSAPP_RECOLETA));
    }

    private static boolean podeEnviarWhatsappPaciente(ResultSet rs) throws SQLException {
        return !rs.getBoolean("bloquearWhatsappPaciente") && (!Funcoes.textoVazio(rs.getString(CELULAR_PACIENTE)) || !Funcoes.textoVazio(rs.getString(WHATSAPP_PACIENTE)));
    }

    private static boolean podeEnviarWhatsappAniversario(ResultSet rs, Statement st) throws SQLException {
        return WhatsAppUtil.podeEnviarWhatsappPaciente(rs) && WhatsAppUtil.podeEnviarWhatsappConvenio(rs, st, 0) && rs.getBoolean("enviarWhatsappAniversario") && !Funcoes.textoVazio(rs.getString(WHATSAPP_ANIVERSARIO));
    }

    public static PreparedStatement getPreparedStatement(Connection conexao, String sql) {
        try {
            return conexao.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean podeEnviarWhatsappConvenio(ResultSet rs, Statement st, int tipoBloqueioWhatsappConvenioResultado) throws SQLException {
        PreparedStatement prstBloqueiosEnvioWhatsappConvenio = null;
        if (rs.getString("codigoConvenio") == null) {
            return true;
        }
        prstBloqueiosEnvioWhatsappConvenio = WhatsAppUtil.getPreparedStatement(st.getConnection(), sqlBloqueiosEnvioWhatsappConvenio);
        if (prstBloqueiosEnvioWhatsappConvenio == null) {
            return false;
        }
        prstBloqueiosEnvioWhatsappConvenio.setInt(1, rs.getInt(CODIGO_FILIAL));
        prstBloqueiosEnvioWhatsappConvenio.setInt(2, rs.getInt("codigoConvenio"));
        try (ResultSet rsBloqueioEnvioWhatsAppConvenio = null;){
            rsBloqueioEnvioWhatsAppConvenio = prstBloqueiosEnvioWhatsappConvenio.executeQuery();
            if (rsBloqueioEnvioWhatsAppConvenio.next()) {
                if (tipoBloqueioWhatsappConvenioResultado == 2) {
                    boolean bl = !rsBloqueioEnvioWhatsAppConvenio.getBoolean("bloquearResultado");
                    return bl;
                }
                if (tipoBloqueioWhatsappConvenioResultado == 0) {
                    boolean bl = !rsBloqueioEnvioWhatsAppConvenio.getBoolean("bloquearAniversario");
                    return bl;
                }
                if (tipoBloqueioWhatsappConvenioResultado == 1) {
                    boolean bl = !rsBloqueioEnvioWhatsAppConvenio.getBoolean("bloquearRecoleta");
                    return bl;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean podeEnviarWhatsappResultado(ResultSet rs, Statement st, boolean conferencia) throws SQLException {
        PreparedStatement prstQuantidadeExamesProntosMultiguias = null;
        PreparedStatement prstQuantidadeExamesMultiguias = null;
        PreparedStatement prstMultiguiasEnviaramWhatsapp = null;
        StringBuilder buf = new StringBuilder();
        boolean podeEnviarWhatsappPaciente = WhatsAppUtil.podeEnviarWhatsappPaciente(rs);
        if (!podeEnviarWhatsappPaciente) {
            return false;
        }
        if (!WhatsAppUtil.filialPermiteEnviarSeparado(rs.getInt(CODIGOFILIAL), rs.getInt(CODIGOREQUISICAO), st) || ResultadosUtil.notificacaoJaEnviada(rs.getInt(CODIGOFILIAL), rs.getInt(CODIGOREQUISICAO), st, "fil_agruparmultiguiawhatsapp", "req_wppresultadoenviada")) {
            return false;
        }
        boolean podeEnviaWhatsappConvenio = WhatsAppUtil.podeEnviarWhatsappConvenio(rs, st, 2);
        if (!podeEnviaWhatsappConvenio) {
            return false;
        }
        prstMultiguiasEnviaramWhatsapp = WhatsAppUtil.getPreparedStatement(st.getConnection(), sqlMultiguiasEnviaramWhatsapp);
        prstQuantidadeExamesMultiguias = WhatsAppUtil.getPreparedStatement(st.getConnection(), sqlQuantidadeExamesMultiguias);
        buf.setLength(0);
        buf.append(" select count(*) as qtde ");
        buf.append("   from examerequisicao  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        buf.append("    and not exr_excluido ");
        buf.append("    and exr_situacao in (?, ?, ?");
        if (!conferencia) {
            buf.append(", ?");
        }
        buf.append(")");
        sqlQuantidadeExamesProntosMultiguias = buf.toString();
        prstQuantidadeExamesProntosMultiguias = WhatsAppUtil.getPreparedStatement(st.getConnection(), sqlQuantidadeExamesProntosMultiguias);
        if (prstMultiguiasEnviaramWhatsapp == null) {
            return false;
        }
        prstMultiguiasEnviaramWhatsapp.setInt(1, rs.getInt(CODIGOFILIAL));
        prstMultiguiasEnviaramWhatsapp.setInt(2, rs.getInt(CODIGOREQUISICAO));
        try (ResultSet rsMultiguiasEnviaramWhatsapp = null;){
            rsMultiguiasEnviaramWhatsapp = prstMultiguiasEnviaramWhatsapp.executeQuery();
            if (rsMultiguiasEnviaramWhatsapp.next() && rsMultiguiasEnviaramWhatsapp.getBoolean("whatsappEnviado")) {
                boolean bl = false;
                return bl;
            }
        }
        if (prstQuantidadeExamesMultiguias == null) {
            return false;
        }
        prstQuantidadeExamesMultiguias.setInt(1, rs.getInt(CODIGOFILIAL));
        prstQuantidadeExamesMultiguias.setInt(2, rs.getInt(CODIGOREQUISICAO));
        prstQuantidadeExamesMultiguias.setString(3, "A");
        if (prstQuantidadeExamesProntosMultiguias == null) {
            return false;
        }
        prstQuantidadeExamesProntosMultiguias.setInt(1, rs.getInt(CODIGOFILIAL));
        prstQuantidadeExamesProntosMultiguias.setInt(2, rs.getInt(CODIGOREQUISICAO));
        prstQuantidadeExamesProntosMultiguias.setString(3, "E");
        prstQuantidadeExamesProntosMultiguias.setString(4, "C");
        prstQuantidadeExamesProntosMultiguias.setString(5, "I");
        if (!conferencia) {
            prstQuantidadeExamesProntosMultiguias.setString(6, "L");
        }
        ResultSet rsTodosExames = prstQuantidadeExamesMultiguias.executeQuery();
        ResultSet rsExamesResultado = prstQuantidadeExamesProntosMultiguias.executeQuery();
        if (!rsTodosExames.next() || !rsExamesResultado.next()) {
            return false;
        }
        if (rsTodosExames.getInt("qtde") != rsExamesResultado.getInt("qtde")) {
            return false;
        }
        return rs.getBoolean("enviarWhatsappResultado") && !Funcoes.textoVazio(rs.getString(WHATSAPP_RESULTADO));
    }

    private static void addValorPacienteRequisicao(String codigoRequisicao, String codigoPaciente, StringBuilder buf) {
        if (!Funcoes.textoVazio(codigoRequisicao)) {
            buf.append(", ").append(Integer.parseInt(codigoRequisicao));
        }
        if (!Funcoes.textoVazio(codigoPaciente)) {
            buf.append(", ").append(Integer.parseInt(codigoPaciente));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean filialPermiteEnviarSeparado(int filial, int requisicao, Statement st) throws SQLException {
        String sql = "select (case when fil_agruparmultiguiawhatsapp is null then false else fil_agruparmultiguiawhatsapp end) as fil_agruparmultiguiawhatsapp from filiais_postocoleta where fil_codigo = ?";
        PreparedStatement psMultiguia = WhatsAppUtil.getPreparedStatement(st.getConnection(), sql);
        if (psMultiguia == null) {
            return false;
        }
        psMultiguia.setInt(1, filial);
        try (ResultSet rsFilialMultiguia = null;){
            rsFilialMultiguia = psMultiguia.executeQuery();
            boolean bFilialMultiguia = false;
            if (rsFilialMultiguia.next()) {
                bFilialMultiguia = rsFilialMultiguia.getBoolean("fil_agruparmultiguiawhatsapp");
            }
            if (bFilialMultiguia) {
                int n;
                StringBuilder listaRequisicoes = new StringBuilder();
                Integer[] integerArray = RecepcaoUtil.verificaMultiGuias(String.valueOf(filial), String.valueOf(requisicao), true);
                int n2 = integerArray.length;
                for (n = 0; n < n2; n += 1) {
                    int requisicaoAtual = integerArray[n];
                    if (!listaRequisicoes.toString().isEmpty()) {
                        listaRequisicoes.append(", ");
                    }
                    listaRequisicoes.append(requisicaoAtual);
                }
                StringBuilder buf = new StringBuilder("select (count(*) = sum(case when exr_situacao in ( '");
                buf.append("E").append("', '").append("C").append("', '").append("A").append("', '").append("I").append("' )");
                buf.append(" then 1 end)) as prontos from examerequisicao where fil_codigo = ").append(filial);
                buf.append(" and req_codigo in ( ").append((CharSequence)listaRequisicoes).append(" ) and not exr_excluido");
                ResultSet rsExamesProntos = Conexao.executeQuery(st, buf.toString());
                if (rsExamesProntos.next()) {
                    n = rsExamesProntos.getBoolean("prontos") ? 1 : 0;
                    return n != 0;
                }
            }
        }
        return true;
    }

    private static void validaPacienteRequisicao(String codigoRequisicao, String codigoPaciente, StringBuilder buf) {
        if (!Funcoes.textoVazio(codigoRequisicao)) {
            buf.append(", req_codigo");
        }
        if (!Funcoes.textoVazio(codigoPaciente)) {
            buf.append(", pac_codigo");
        }
    }

    private static boolean tipoAniversarioSenhaWeb(TipoWhatsapp tipoWhatsapp) {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.ANIVERSARIO) || tipoWhatsapp.equals((Object)TipoWhatsapp.SENHA_WEB);
    }

    private static boolean tipoFilialIntegracao(String tipoWhatsappfilial) {
        return tipoWhatsappfilial.equals("F") || tipoWhatsappfilial.equals("W");
    }

    private static boolean tipoRecoletaResultadoRequisicaoAgendamento(TipoWhatsapp tipoWhatsapp) {
        return tipoWhatsapp.equals((Object)TipoWhatsapp.RECOLETA) || tipoWhatsapp.equals((Object)TipoWhatsapp.RESULTADO) || tipoWhatsapp.equals((Object)TipoWhatsapp.REQUISICAO) || tipoWhatsapp.equals((Object)TipoWhatsapp.AGENDAMENTO);
    }

    public static String limpaCelular(String celular) {
        if (!Funcoes.textoVazio(celular)) {
            return StringUtil.limpaString(celular, new String[]{"(", ")", "-", " ", ".", ";"});
        }
        return "";
    }

    static {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append(" select pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,pac.pac_whatsapp as whatsappPaciente ");
        buf.append("       ,COALESCE(pac.pac_bloquearwhatsapp, false) as bloquearWhatsappPaciente ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_senhaweb as senhaWebRequisicao ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_dataentregaprev as dataEntregaPrevistaRequisicao ");
        buf.append("       ,req.req_horaentregaprev as horaEntregaPrevistaRequisicao ");
        buf.append("       ,req.req_wppresultadoenviada IS NOT NULL as wppResultadoEnviado ");
        buf.append("       ,cast(req.fil_codigo as varchar) || req.req_codigo as codigoPacienteWeb ");
        buf.append("       ,COALESCE(fil.fil_enviarwhatsapp, false) as enviarWhatsapp ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,fil.fil_whatsappaniversario as enviarWhatsappAniversario ");
        buf.append("       ,fil.fil_whatsappresultados as enviarWhatsappResultado ");
        buf.append("       ,fil.fil_whatsappsenhaweb as enviarWhatsappSenhaWeb ");
        buf.append("       ,fil.fil_whatsapprecoleta as enviarWhatsappRecoleta ");
        buf.append("       ,fil.fil_whatsapprequisicao as enviarWhatsappRequisicao ");
        buf.append("       ,fil.fil_whatsappresumofinanceiro as enviarWhatsappFinanceiro ");
        buf.append("       ,fil.fil_whatsappagendamento as enviarWhatsappAgendamento ");
        buf.append("       ,fil.fil_frasewhatsappaniversario as whatsappAniversario ");
        buf.append("       ,fil.fil_frasewhatsappresultados as whatsappResultado ");
        buf.append("       ,fil.fil_frasewhatsappsenhaweb as whatsappSenhaWeb ");
        buf.append("       ,fil.fil_frasewhatsapprecoleta as whatsappRecoleta ");
        buf.append("       ,fil.fil_frasewhatsapprequisicao as whatsappRequisicao ");
        buf.append("       ,fil.fil_frasewhatsappagendamento as whatsappAgendamento ");
        buf.append("       ,cast(agd.agd_datahoraagenda as date) as dataAgenda, cast(agd.agd_datahoraagenda as time) as horaAgenda ");
        buf.append("       ,fil.fil_fone as telefoneFilial ");
        buf.append("       ,fil.fil_endereco as enderecoFilial ");
        buf.append("       ,fil.fil_descricao as descricaoFilial ");
        buf.append("       ,'' as chaveAcessoRequisicao ");
        buf.append("   from requisicao req ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join filiais_postocoleta fil on req.fil_codigo = fil.fil_codigo ");
        buf.append("   left join agendamento agd on req.fil_codigo = agd.fil_codigo and req.req_codigo = agd.req_codigo and agd.agd_situacao = '").append("A").append("'");
        buf.append("  where req.fil_codigo = ? ");
        buf.append("    and req.req_codigo = ? ");
        buf.append(" order by agd.agd_codigo desc limit 1");
        sqlDadosWhatsapp = buf.toString();
        buf.setLength(0);
        buf.append(" select pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,pac.pac_whatsapp as whatsappPaciente ");
        buf.append("       ,COALESCE(pac.pac_bloquearwhatsapp, false) as bloquearWhatsappPaciente ");
        buf.append("       ,COALESCE(fil.fil_enviarwhatsapp, false) as enviarWhatsapp ");
        buf.append("       ,pac.con_codigo as codigoConvenio ");
        buf.append("       ,fil.fil_codigo as codigoFilial ");
        buf.append("       ,fil.fil_fone as telefoneFilial ");
        buf.append("       ,fil.fil_endereco as enderecoFilial ");
        buf.append("       ,fil.fil_descricao as descricaoFilial ");
        buf.append("       ,fil.fil_whatsappaniversario as enviarWhatsappAniversario ");
        buf.append("       ,fil.fil_whatsappresultados as enviarWhatsappResultado ");
        buf.append("       ,fil.fil_whatsappsenhaweb as enviarWhatsappSenhaWeb ");
        buf.append("       ,fil.fil_whatsapprecoleta as enviarWhatsappRecoleta ");
        buf.append("       ,fil.fil_whatsapprequisicao as enviarWhatsappRequisicao ");
        buf.append("       ,fil.fil_whatsappresumofinanceiro as enviarWhatsappFinanceiro ");
        buf.append("       ,fil.fil_whatsappresumofinanceiro as enviarWhatsappAgendamento ");
        buf.append("       ,fil.fil_frasewhatsappaniversario as whatsappAniversario ");
        buf.append("       ,fil.fil_frasewhatsappresultados as whatsappResultado ");
        buf.append("       ,fil.fil_frasewhatsappsenhaweb as whatsappSenhaWeb ");
        buf.append("       ,fil.fil_frasewhatsapprecoleta as whatsappRecoleta ");
        buf.append("       ,fil.fil_frasewhatsapprequisicao as whatsappRequisicao ");
        buf.append("       ,fil.fil_frasewhatsappagendamento as whatsappAgendamento ");
        buf.append("   from paciente pac ");
        buf.append("   join filiais_postocoleta fil on pac.fil_codigo = fil.fil_codigo ");
        buf.append("  where pac.fil_codigo = ? ");
        buf.append("    and pac.pac_codigo = ? ");
        sqlDadosPaciente = buf.toString();
        buf.setLength(0);
        buf.append(" select bool_or(CASE WHEN req_wppresultadoenviada is null then false else true end) as whatsappEnviado ");
        buf.append("   from requisicao where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        sqlMultiguiasEnviaramWhatsapp = buf.toString();
        buf.setLength(0);
        buf.append(" select count(*) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo  = ? ");
        buf.append("    and req_codigo  = ? ");
        buf.append("    and not exr_excluido ");
        buf.append("    and exr_situacao <> ? ");
        sqlQuantidadeExamesMultiguias = buf.toString();
        buf.setLength(0);
        buf.append(" select con_bloquearwhatsappexamepronto as bloquearResultado");
        buf.append("       ,con_bloquearwhatsapprecoleta as bloquearRecoleta ");
        buf.append("       ,con_bloquearwhatsappaniversario as bloquearAniversario ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and con_codigo = ? ");
        sqlBloqueiosEnvioWhatsappConvenio = buf.toString();
    }
}

