/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.AvisoAgendamentoSMS;
import jalis.laboratorio.cadastro.ConfiguradorDadosSMS;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.MapaResolverExpressoesUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SMSUtil {
    private static final String REGEX_MASCARA_CELULAR = "^\\(?\\d{2}\\)?[\\s-]?[\\s9]?\\d{4}-?\\d{4}$";
    private static final String REGEX_MASCARA_CELULAR_PONTO = "^\\(?\\d{2}\\)?[\\s-]?[\\s9]?\\d{4}.?\\d{4}$";
    public static final int SMS_ENVIADO = 0;
    public static final int SMS_BLOQUEADO_PACIENTE = 1;
    public static final int SMS_JA_ENVIADO = 2;
    public static final int SMS_FILIAL_NAO_PERMITE = 3;
    private static final int TIPO_BLOQUEIO_SMS_CONVENIO_ANIVERSARIO = 0;
    private static final int TIPO_BLOQUEIO_SMS_CONVENIO_RECOLETA = 1;
    private static final int TIPO_BLOQUEIO_SMS_CONVENIO_RESULTADO = 2;
    private static PreparedStatement prstInsereLog = null;
    private static PreparedStatement prstDadosSMS = null;
    private static PreparedStatement prstDadosPaciente = null;
    private static PreparedStatement prstMultiguiasEnviaramSms = null;
    private static PreparedStatement prstQuantidadeExamesMultiguias = null;
    private static PreparedStatement prstQuantidadeExamesProntosMultiguias = null;
    private static PreparedStatement prstBloqueiosEnvioSmsConvenio = null;
    private static String sqlInsereLog = null;
    private static String sqlDadosSMS = null;
    private static String sqlDadosPaciente = null;
    private static String sqlMultiguiasEnviaramSms = null;
    private static String sqlQuantidadeExamesMultiguias = null;
    private static String sqlQuantidadeExamesProntosMultiguias = null;
    private static String sqlBloqueiosEnvioSmsConvenio = null;
    public static String requisicaoCodigo = null;
    public static String pacienteCodigo = null;

    public static boolean enviarSMS(Component componentePai, String codigoFilial, String celular, String mensagem, ExportaSMS.TipoSMS tipoSMS, Statement st, String codigoRequisicao, String codigoPaciente) throws NumberFormatException, SQLException {
        return SMSUtil.enviarSMS(componentePai, codigoFilial, celular, mensagem, tipoSMS, st, codigoRequisicao, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), codigoPaciente, ParametrosGerais.getTipoIntegracao(), ParametrosGerais.isOcultarApenasFaturamento(), false);
    }

    public static boolean enviarSMS(Component componentePai, String codigoFilial, String celular, String mensagem, ExportaSMS.TipoSMS tipoSMS, Statement st, String codigoRequisicao, String codigoPaciente, Boolean isColetaWeb) throws NumberFormatException, SQLException {
        return SMSUtil.enviarSMS(componentePai, codigoFilial, celular, mensagem, tipoSMS, st, codigoRequisicao, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), codigoPaciente, ParametrosGerais.getTipoIntegracao(), ParametrosGerais.isOcultarApenasFaturamento(), isColetaWeb);
    }

    public static boolean enviarSMS(Component componentePai, String codigoFilial, String celular, String mensagem, ExportaSMS.TipoSMS tipoSMS, Statement st, String codigoRequisicao, int digitosTuboFilial, int digitosTuboRequisicao, String codigoPaciente, String tipoIntegracao, boolean isOcultarApenasFaturamento, Boolean isColetaWeb) throws NumberFormatException, SQLException {
        requisicaoCodigo = codigoRequisicao;
        pacienteCodigo = codigoPaciente;
        String[] camposBanco = tipoSMS.equals((Object)ExportaSMS.TipoSMS.AVISO_AGENDAMENTO) ? AvisoAgendamentoSMS.CAMPOS_DISPONIVEIS : ConfiguradorDadosSMS.camposDisponiveis;
        if (!Funcoes.textoVazio(celular = SMSUtil.limpaCelular(celular))) {
            StringBuilder buf;
            mensagem = StringUtil.removerAcentos(mensagem);
            if (tipoSMS.equals((Object)ExportaSMS.TipoSMS.FINANCEIRO)) {
                StringUtil.textoDB(mensagem);
            } else {
                mensagem = SMSUtil.getMensagemResolvida(mensagem, codigoFilial, codigoRequisicao, digitosTuboFilial, digitosTuboRequisicao, camposBanco, tipoSMS, isOcultarApenasFaturamento, st, isColetaWeb);
            }
            if (tipoSMS.equals((Object)ExportaSMS.TipoSMS.FINANCEIRO)) {
                buf = new StringBuilder();
                buf.append(" insert into logsms ");
                buf.append("  (fil_codigo, sms_codigo, sms_datahora, sms_situacao, sms_celular, sms_mensagem, sms_origem, sms_filial) values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logsms_").append(Integer.parseInt(codigoFilial)).append("_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(mensagem).append("'");
                buf.append(", '").append(tipoSMS.getCodigo()).append("'");
                buf.append(", '").append(tipoIntegracao).append("'");
                buf.append(")");
                sqlInsereLog = buf.toString();
            }
            if (tipoSMS.equals((Object)ExportaSMS.TipoSMS.ANIVERSARIO) || tipoSMS.equals((Object)ExportaSMS.TipoSMS.SENHA_WEB)) {
                buf = new StringBuilder();
                buf.append(" insert into logsms ");
                buf.append("  (fil_codigo, sms_codigo, sms_datahora, sms_situacao, sms_celular, sms_mensagem, sms_origem, pac_codigo, sms_filial) values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logsms_").append(Integer.parseInt(codigoFilial)).append("_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(mensagem).append("'");
                buf.append(", '").append(tipoSMS.getCodigo()).append("'");
                buf.append(", ").append(Integer.parseInt(codigoPaciente));
                buf.append(", '").append(tipoIntegracao).append("'");
                buf.append(")");
                sqlInsereLog = buf.toString();
            }
            if (tipoSMS.equals((Object)ExportaSMS.TipoSMS.RECOLETA) || tipoSMS.equals((Object)ExportaSMS.TipoSMS.RESULTADO) || tipoSMS.equals((Object)ExportaSMS.TipoSMS.REQUISICAO) || tipoSMS.equals((Object)ExportaSMS.TipoSMS.AGENDAMENTO)) {
                buf = new StringBuilder();
                buf.append(" insert into logsms ");
                buf.append("  (fil_codigo, sms_codigo, sms_datahora, sms_situacao, sms_celular, sms_mensagem, sms_origem, req_codigo, pac_codigo, sms_filial) values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logsms_").append(Integer.parseInt(codigoFilial)).append("_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(mensagem).append("'");
                buf.append(", '").append(tipoSMS.getCodigo()).append("'");
                buf.append(", ").append(Integer.parseInt(codigoRequisicao));
                buf.append(", ").append(Integer.parseInt(codigoPaciente));
                buf.append(", '").append(tipoIntegracao).append("'");
                buf.append(")");
                sqlInsereLog = buf.toString();
            }
            prstInsereLog = SMSUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
            prstInsereLog.executeUpdate();
            if (tipoIntegracao.equals("F") || tipoIntegracao.equals("W")) {
                buf = new StringBuilder();
                buf.append(" insert into logsms (fil_codigo, sms_codigo, sms_datahora, sms_situacao, sms_celular, sms_mensagem, sms_origem, sms_filial");
                if (!Funcoes.textoVazio(codigoRequisicao)) {
                    buf.append(", req_codigo");
                }
                if (!Funcoes.textoVazio(codigoPaciente)) {
                    buf.append(", pac_codigo");
                }
                buf.append(") values (");
                buf.append(Integer.parseInt(codigoFilial));
                buf.append(", ").append("nextval('logsms_" + codigoFilial + "_sequence')");
                buf.append(", '").append(new Timestamp(new Date().getTime())).append("'");
                buf.append(", '").append("E").append("'");
                buf.append(", '").append(celular).append("'");
                buf.append(", '").append(mensagem).append("'");
                buf.append(", '").append(tipoSMS.getCodigo()).append("'");
                buf.append(", '").append(tipoIntegracao).append("'");
                if (!Funcoes.textoVazio(codigoRequisicao)) {
                    buf.append(", ").append(Integer.parseInt(codigoRequisicao));
                }
                if (!Funcoes.textoVazio(codigoPaciente)) {
                    buf.append(", ").append(Integer.parseInt(codigoPaciente));
                }
                buf.append(")");
                IntegracaoUtil.insereComandoLog(st, codigoFilial, codigoFilial, buf.toString());
            }
            return true;
        }
        return false;
    }

    private static String getMensagemResolvida(String mensagem, String filial, String requisicao, int digitosTuboFilial, int digitosTuboRequisicao, String[] camposBanco, ExportaSMS.TipoSMS tipoSms, boolean isOcultarApenasFaturamento, Statement st, Boolean isColetaWeb) throws SQLException {
        ModeloGridTable info = SMSUtil.getInformacoesParaMensagemExpressao(filial, requisicao, digitosTuboFilial, digitosTuboRequisicao, camposBanco, tipoSms, isOcultarApenasFaturamento, st, isColetaWeb);
        StringBuilder bui = new StringBuilder();
        String[] expressoes = MapaResolverExpressoesUtil.resolverExpressoes(mensagem, MapaResolverExpressoesUtil.getCampos(info), null, null, false);
        MapaResolverExpressoesUtil.adicionarStrings(bui, expressoes, "", false);
        mensagem = bui.toString();
        return StringUtil.textoDB(mensagem);
    }

    public static boolean criaLogSmsComDadosRequisicao(String codigoFilial, String codigoRequisicao, ExportaSMS.TipoSMS tipoSms, Statement st, Statement st2) throws Exception {
        return SMSUtil.criaLogSmsComDadosRequisicao(codigoFilial, codigoRequisicao, tipoSms, st, st2, ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.isOcultarApenasFaturamento(), false);
    }

    public static boolean criaLogSmsComDadosRequisicao(String codigoFilial, String codigoRequisicao, ExportaSMS.TipoSMS tipoSms, Statement st, Statement st2, String tipoIntegracao, int digitosTuboFilial, int digitosTuboRequisicao, Boolean isOcultarApenasFaturamento, Boolean isColetaWeb) throws Exception {
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoRequisicao)) {
            throw new Exception("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o informado.");
        }
        if (tipoSms == null) {
            throw new Exception("Tipo do SMS n\u00e3o informado.");
        }
        prstDadosSMS = SMSUtil.getPreparedStatement(st.getConnection(), sqlDadosSMS);
        prstDadosSMS.setInt(1, Integer.parseInt(codigoFilial));
        prstDadosSMS.setInt(2, Integer.parseInt(codigoRequisicao));
        ResultSet rs = prstDadosSMS.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarSms")) {
            return false;
        }
        String sms = null;
        if (tipoSms.equals((Object)ExportaSMS.TipoSMS.ANIVERSARIO)) {
            if (!SMSUtil.podeEnviarSmsAniversario(rs, st)) {
                return false;
            }
            sms = rs.getString("smsAniversario");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.RECOLETA)) {
            if (!SMSUtil.podeEnviarSmsRecoleta(rs, st)) {
                return false;
            }
            sms = rs.getString("smsRecoleta");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.RESULTADO)) {
            if (!SMSUtil.podeEnviarSmsResultado(rs, st)) {
                return false;
            }
            if (rs.getBoolean("smsResultadoEnviado")) {
                return false;
            }
            sms = rs.getString("smsResultado");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.SENHA_WEB)) {
            if (!SMSUtil.podeEnviarSmsSenhaWeb(rs)) {
                return false;
            }
            sms = rs.getString("smsSenhaWeb");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.REQUISICAO)) {
            if (!SMSUtil.podeEnviarSmsRequisicao(rs)) {
                return false;
            }
            sms = rs.getString("smsRequisicao");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.AGENDAMENTO)) {
            if (!SMSUtil.podeEnviarSmsAgendamento(rs)) {
                return false;
            }
            sms = rs.getString("smsAgendamento");
        }
        if (Funcoes.textoVazio(sms)) {
            return false;
        }
        String celular = rs.getString("celularPaciente");
        String codigoPaciente = rs.getString("codigoPaciente");
        if (!Funcoes.textoVazio(sms) && !SMSUtil.isCelularVazio(celular)) {
            boolean enviado = SMSUtil.enviarSMS(null, codigoFilial, celular, SMSUtil.parseFraseSMS(sms, SMSUtil.getHashMapCampos(codigoFilial, rs, st2, digitosTuboFilial, digitosTuboRequisicao)), tipoSms, st, codigoRequisicao, digitosTuboFilial, digitosTuboRequisicao, codigoPaciente, tipoIntegracao, isOcultarApenasFaturamento, isColetaWeb);
            if (enviado) {
                if (tipoSms.equals((Object)ExportaSMS.TipoSMS.RESULTADO)) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update requisicao ");
                    buf.append("    set req_smsresultadoenviada = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
                    buf.append("  where fil_codigo = ").append(codigoFilial);
                    buf.append("    and req_codigo = ").append(codigoRequisicao);
                    st.executeUpdate(buf.toString());
                }
                st.getConnection().commit();
                return true;
            }
            st.getConnection().rollback();
            return false;
        }
        return false;
    }

    public static boolean criarLogParaReenvio(String filial, String paciente, String requisicao, ExportaSMS.TipoSMS tipoSms, String numeroDestino, String mensagem, Statement st, Statement st2) throws Exception {
        return SMSUtil.criarLogParaReenvio(filial, paciente, requisicao, tipoSms, numeroDestino, mensagem, st, st2, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), false);
    }

    public static boolean criarLogParaReenvio(String filial, String paciente, String requisicao, ExportaSMS.TipoSMS tipoSms, String numeroDestino, String mensagem, Statement st, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, Boolean isColetaWeb) throws Exception {
        String sms = mensagem;
        String celular = numeroDestino;
        SMSUtil.validarFilial(filial);
        SMSUtil.validarPaciente(paciente);
        SMSUtil.prepararStatement(filial, requisicao, paciente, st);
        ResultSet rs = prstDadosPaciente.executeQuery();
        boolean osDadosSaoValidos = SMSUtil.validarDadosDoSms(rs, tipoSms, celular, st);
        if (!osDadosSaoValidos) {
            return false;
        }
        String fraseDoSms = SMSUtil.parseFraseSMS(sms, SMSUtil.getHashMapCampos(filial, rs, st2, digitosTuboFilial, digitosTuboRequisicao));
        boolean enviado = SMSUtil.enviarSMS(null, filial, celular, fraseDoSms, tipoSms, st, requisicao, paciente, isColetaWeb);
        if (enviado) {
            st.getConnection().commit();
            return true;
        }
        st.getConnection().rollback();
        return false;
    }

    private static boolean validarDadosDoSms(ResultSet rs, ExportaSMS.TipoSMS tipoSms, String celular, Statement st) throws Exception {
        boolean rsValido = SMSUtil.validarResultSet(rs);
        boolean celularEhValido = !SMSUtil.isCelularVazio(celular);
        boolean osDadosSaoValidos = rsValido && celularEhValido;
        return osDadosSaoValidos;
    }

    private static boolean validarSms(ResultSet rs, ExportaSMS.TipoSMS tipoSms, Statement st) throws Exception {
        String sms = null;
        if (tipoSms.equals((Object)ExportaSMS.TipoSMS.ANIVERSARIO)) {
            if (!SMSUtil.podeEnviarSmsAniversario(rs, st)) {
                return false;
            }
            sms = rs.getString("smsAniversario");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.RECOLETA)) {
            if (!SMSUtil.podeEnviarSmsRecoleta(rs, st)) {
                return false;
            }
            sms = rs.getString("smsRecoleta");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.RESULTADO)) {
            if (!SMSUtil.podeReenviarSmsResultado(rs, st)) {
                return false;
            }
            sms = rs.getString("smsResultado");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.SENHA_WEB)) {
            if (!SMSUtil.podeEnviarSmsSenhaWeb(rs)) {
                return false;
            }
            sms = rs.getString("smsSenhaWeb");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.REQUISICAO)) {
            if (!SMSUtil.podeEnviarSmsRequisicao(rs)) {
                return false;
            }
            sms = rs.getString("smsRequisicao");
        }
        return true;
    }

    private static boolean podeReenviarSmsResultado(ResultSet rs, Statement st) throws Exception {
        boolean podeEnviarSmsPaciente = SMSUtil.podeEnviarSmsPaciente(rs);
        boolean podeEnviaSmsConvenio = SMSUtil.podeEnviarSmsConvenio(rs, st, 2);
        return podeEnviarSmsPaciente && podeEnviaSmsConvenio;
    }

    private static boolean validarResultSet(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return false;
        }
        return rs.getBoolean("enviarSms");
    }

    private static void prepararStatement(String filial, String requisicao, String paciente, Statement st) throws SQLException {
        boolean requisicaoVazia = Funcoes.textoVazio(requisicao);
        if (requisicaoVazia) {
            SMSUtil.preparaStatementeDadosPaciente(filial, paciente, st);
        } else {
            SMSUtil.preparaStatelemteDadoSms(filial, requisicao, st);
        }
    }

    private static void preparaStatementeDadosPaciente(String filial, String paciente, Statement st) throws SQLException {
        String sql = sqlDadosPaciente;
        prstDadosPaciente = SMSUtil.getPreparedStatement(st.getConnection(), sql);
        prstDadosPaciente.setInt(1, Integer.parseInt(filial));
        prstDadosPaciente.setInt(2, Integer.parseInt(paciente));
    }

    private static void preparaStatelemteDadoSms(String filial, String requisicao, Statement st) throws SQLException {
        String sql = sqlDadosSMS;
        prstDadosPaciente = SMSUtil.getPreparedStatement(st.getConnection(), sql);
        prstDadosPaciente.setInt(1, Integer.parseInt(filial));
        prstDadosPaciente.setInt(2, Integer.parseInt(requisicao));
    }

    private static void validarPaciente(String paciente) throws Exception {
        if (Funcoes.textoVazio(paciente)) {
            throw new Exception("C\u00f3digo do paciente n\u00e3o informado.");
        }
    }

    private static void validarFilial(String filial) throws Exception {
        if (Funcoes.textoVazio(filial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
    }

    public static boolean criaLogSmsSemDadosRequisicao(String codigoFilial, String codigoPaciente, ExportaSMS.TipoSMS tipoSms, Statement st, Statement st2) throws Exception {
        return SMSUtil.criaLogSmsSemDadosRequisicao(codigoFilial, codigoPaciente, tipoSms, st, st2, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getConferencia(), ParametrosGerais.isOcultarApenasFaturamento(), false);
    }

    public static boolean criaLogSmsSemDadosRequisicao(String codigoFilial, String codigoPaciente, ExportaSMS.TipoSMS tipoSms, Statement st, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, String tipoIntegracao, boolean conferencia, Boolean isOcultarApenasFaturamento, Boolean isColetaWeb) throws Exception {
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoPaciente)) {
            throw new Exception("C\u00f3digo do paciente n\u00e3o informado.");
        }
        prstDadosPaciente = SMSUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
        prstDadosPaciente.setInt(1, Integer.parseInt(codigoFilial));
        prstDadosPaciente.setInt(2, Integer.parseInt(codigoPaciente));
        ResultSet rs = prstDadosPaciente.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarSms")) {
            return false;
        }
        String sms = null;
        if (tipoSms.equals((Object)ExportaSMS.TipoSMS.ANIVERSARIO)) {
            if (!SMSUtil.podeEnviarSmsAniversario(rs, st)) {
                return false;
            }
            sms = rs.getString("smsAniversario");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.RECOLETA)) {
            if (!SMSUtil.podeEnviarSmsRecoleta(rs, st)) {
                return false;
            }
            sms = rs.getString("smsRecoleta");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.RESULTADO)) {
            if (!SMSUtil.podeEnviarSmsResultado(rs, st, conferencia)) {
                return false;
            }
            sms = rs.getString("smsResultado");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.SENHA_WEB)) {
            if (!SMSUtil.podeEnviarSmsSenhaWeb(rs)) {
                return false;
            }
            sms = rs.getString("smsSenhaWeb");
        } else if (tipoSms.equals((Object)ExportaSMS.TipoSMS.REQUISICAO)) {
            if (!SMSUtil.podeEnviarSmsRequisicao(rs)) {
                return false;
            }
            sms = rs.getString("smsRequisicao");
        }
        if (Funcoes.textoVazio(sms)) {
            return false;
        }
        String celular = rs.getString("celularPaciente");
        String codigoRequisicao = null;
        if (!Funcoes.textoVazio(sms) && !SMSUtil.isCelularVazio(celular)) {
            boolean enviado = SMSUtil.enviarSMS(null, codigoFilial, celular, SMSUtil.parseFraseSMS(sms, SMSUtil.getHashMapCampos(codigoFilial, rs, st2, digitosTuboFilial, digitosTuboRequisicao)), tipoSms, st, codigoRequisicao, digitosTuboFilial, digitosTuboRequisicao, codigoPaciente, tipoIntegracao, isOcultarApenasFaturamento, isColetaWeb);
            if (enviado) {
                st.getConnection().commit();
                return true;
            }
            st.getConnection().rollback();
            return false;
        }
        return false;
    }

    private static boolean podeEnviarSmsRequisicao(ResultSet rs) throws Exception {
        return SMSUtil.podeEnviarSmsPaciente(rs) && rs.getBoolean("enviarSmsRequisicao") && !Funcoes.textoVazio(rs.getString("smsRequisicao"));
    }

    private static boolean podeEnviarSmsAgendamento(ResultSet rs) throws Exception {
        return SMSUtil.podeEnviarSmsPaciente(rs) && rs.getBoolean("enviarSmsAgendamento") && !Funcoes.textoVazio(rs.getString("smsAgendamento"));
    }

    private static boolean podeEnviarSmsSenhaWeb(ResultSet rs) throws Exception {
        return SMSUtil.podeEnviarSmsPaciente(rs) && rs.getBoolean("enviarSmsSenhaWeb") && !Funcoes.textoVazio(rs.getString("smsSenhaWeb"));
    }

    private static boolean podeEnviarSmsResultado(ResultSet rs, Statement st) throws Exception {
        return SMSUtil.podeEnviarSmsResultado(rs, st, ParametrosGerais.getConferencia());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean podeEnviarSmsResultado(ResultSet rs, Statement st, boolean conferencia) throws Exception {
        StringBuilder buf = new StringBuilder();
        boolean podeEnviarSmsPaciente = SMSUtil.podeEnviarSmsPaciente(rs);
        if (!podeEnviarSmsPaciente) {
            return false;
        }
        if (!SMSUtil.filialPermiteEnviarSeparado(rs.getInt("codigofilial"), rs.getInt("codigorequisicao"), st) || ResultadosUtil.notificacaoJaEnviada(rs.getInt("codigofilial"), rs.getInt("codigorequisicao"), st, "fil_agruparmultiguiasms", "req_smsresultadoenviada")) {
            return false;
        }
        boolean podeEnviaSmsConvenio = SMSUtil.podeEnviarSmsConvenio(rs, st, 2);
        if (!podeEnviaSmsConvenio) {
            return false;
        }
        prstMultiguiasEnviaramSms = SMSUtil.getPreparedStatement(st.getConnection(), sqlMultiguiasEnviaramSms);
        prstQuantidadeExamesMultiguias = SMSUtil.getPreparedStatement(st.getConnection(), sqlQuantidadeExamesMultiguias);
        buf.setLength(0);
        buf.append(" select count(*) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        buf.append("    and not exr_excluido ");
        buf.append("    and exr_situacao in (?, ?, ?");
        if (!conferencia) {
            buf.append(", ?");
        }
        buf.append(")");
        sqlQuantidadeExamesProntosMultiguias = buf.toString();
        prstQuantidadeExamesProntosMultiguias = SMSUtil.getPreparedStatement(st.getConnection(), sqlQuantidadeExamesProntosMultiguias);
        prstMultiguiasEnviaramSms.setInt(1, rs.getInt("codigofilial"));
        prstMultiguiasEnviaramSms.setInt(2, rs.getInt("codigorequisicao"));
        try (ResultSet rsMultiguiasEnviaramSms = null;){
            rsMultiguiasEnviaramSms = prstMultiguiasEnviaramSms.executeQuery();
            if (rsMultiguiasEnviaramSms.next() && rsMultiguiasEnviaramSms.getBoolean("smsEnviado")) {
                boolean bl = false;
                return bl;
            }
        }
        prstQuantidadeExamesMultiguias.setInt(1, rs.getInt("codigofilial"));
        prstQuantidadeExamesMultiguias.setInt(2, rs.getInt("codigorequisicao"));
        prstQuantidadeExamesMultiguias.setString(3, "A");
        prstQuantidadeExamesProntosMultiguias.setInt(1, rs.getInt("codigofilial"));
        prstQuantidadeExamesProntosMultiguias.setInt(2, rs.getInt("codigorequisicao"));
        prstQuantidadeExamesProntosMultiguias.setString(3, "E");
        prstQuantidadeExamesProntosMultiguias.setString(4, "C");
        prstQuantidadeExamesProntosMultiguias.setString(5, "I");
        if (!conferencia) {
            prstQuantidadeExamesProntosMultiguias.setString(6, "L");
        }
        ResultSet rsTodosExames = prstQuantidadeExamesMultiguias.executeQuery();
        ResultSet rsExamesResultado = prstQuantidadeExamesProntosMultiguias.executeQuery();
        if (!rsTodosExames.next() || !rsExamesResultado.next()) {
            return false;
        }
        if (rsTodosExames.getInt("qtde") != rsExamesResultado.getInt("qtde")) {
            return false;
        }
        return podeEnviarSmsPaciente && podeEnviaSmsConvenio && rs.getBoolean("enviarSmsResultado") && !Funcoes.textoVazio(rs.getString("smsResultado"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean filialPermiteEnviarSeparado(int filial, int requisicao, Statement st) throws SQLException {
        String sql = "select (case when fil_agruparmultiguiasms is null then false else fil_agruparmultiguiasms end) as fil_agruparmultiguiasms from filiais_postocoleta where fil_codigo = ?";
        PreparedStatement psMultiguia = SMSUtil.getPreparedStatement(st.getConnection(), sql);
        psMultiguia.setInt(1, filial);
        try (ResultSet rsFilialMultiguia = null;){
            rsFilialMultiguia = psMultiguia.executeQuery();
            boolean bFilialMultiguia = false;
            if (rsFilialMultiguia.next()) {
                bFilialMultiguia = rsFilialMultiguia.getBoolean("fil_agruparmultiguiasms");
            }
            if (bFilialMultiguia) {
                int n;
                StringBuilder listaRequisicoes = new StringBuilder();
                Integer[] integerArray = RecepcaoUtil.verificaMultiGuias(String.valueOf(filial), String.valueOf(requisicao), true);
                int n2 = integerArray.length;
                for (n = 0; n < n2; n += 1) {
                    int requisicaoAtual = integerArray[n];
                    if (!listaRequisicoes.toString().isEmpty()) {
                        listaRequisicoes.append(", ");
                    }
                    listaRequisicoes.append(requisicaoAtual);
                }
                StringBuilder buf = new StringBuilder("select (count(*) = sum(case when exr_situacao in ( '");
                buf.append("E").append("', '").append("C").append("', '").append("A").append("', '").append("I").append("' )");
                buf.append(" then 1 end)) as prontos from examerequisicao where fil_codigo = ").append(filial);
                buf.append(" and req_codigo in ( ").append((CharSequence)listaRequisicoes).append(" ) and not exr_excluido");
                ResultSet rsExamesProntos = Conexao.executeQuery(st, buf.toString());
                if (rsExamesProntos.next()) {
                    n = rsExamesProntos.getBoolean("prontos") ? 1 : 0;
                    return n != 0;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean agrupaMultiguiaSMS(int filial, int requisicao, Statement st) throws SQLException {
        String sql = "select (case when fil_agruparmultiguiasms is null then false else fil_agruparmultiguiasms end) as fil_agruparmultiguiasms from filiais_postocoleta where fil_codigo = ?";
        PreparedStatement psMultiguia = SMSUtil.getPreparedStatement(st.getConnection(), sql);
        psMultiguia.setInt(1, filial);
        try (ResultSet rsFilialMultiguia = null;){
            rsFilialMultiguia = psMultiguia.executeQuery();
            boolean bFilialMultiguia = false;
            if (rsFilialMultiguia.next()) {
                bFilialMultiguia = rsFilialMultiguia.getBoolean("fil_agruparmultiguiasms");
            }
            boolean bl = bFilialMultiguia;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean podeEnviarSmsConvenio(ResultSet rs, Statement st, int tipoBloqueioSmsConvenioResultado) throws Exception {
        if (rs.getString("codigoConvenio") == null) {
            return true;
        }
        prstBloqueiosEnvioSmsConvenio = SMSUtil.getPreparedStatement(st.getConnection(), sqlBloqueiosEnvioSmsConvenio);
        prstBloqueiosEnvioSmsConvenio.setInt(1, rs.getInt("codigoFilial"));
        prstBloqueiosEnvioSmsConvenio.setInt(2, rs.getInt("codigoConvenio"));
        try (ResultSet rsBloqueioEnvioSmsConvenio = null;){
            rsBloqueioEnvioSmsConvenio = prstBloqueiosEnvioSmsConvenio.executeQuery();
            if (rsBloqueioEnvioSmsConvenio.next()) {
                if (tipoBloqueioSmsConvenioResultado == 2) {
                    boolean bl = !rsBloqueioEnvioSmsConvenio.getBoolean("bloquearResultado");
                    return bl;
                }
                if (tipoBloqueioSmsConvenioResultado == 0) {
                    boolean bl = !rsBloqueioEnvioSmsConvenio.getBoolean("bloquearAniversario");
                    return bl;
                }
                if (tipoBloqueioSmsConvenioResultado == 1) {
                    boolean bl = !rsBloqueioEnvioSmsConvenio.getBoolean("bloquearRecoleta");
                    return bl;
                }
            }
        }
        return true;
    }

    private static boolean podeEnviarSmsRecoleta(ResultSet rs, Statement st) throws Exception {
        return SMSUtil.podeEnviarSmsPaciente(rs) && SMSUtil.podeEnviarSmsConvenio(rs, st, 1) && rs.getBoolean("enviarSmsRecoleta") && !Funcoes.textoVazio(rs.getString("smsRecoleta"));
    }

    private static boolean podeEnviarSmsPaciente(ResultSet rs) throws Exception {
        return !rs.getBoolean("bloquearSmsPaciente") && !Funcoes.textoVazio(rs.getString("celularPaciente"));
    }

    private static boolean podeEnviarSmsAniversario(ResultSet rs, Statement st) throws Exception {
        return SMSUtil.podeEnviarSmsPaciente(rs) && SMSUtil.podeEnviarSmsConvenio(rs, st, 0) && rs.getBoolean("enviarSmsAniversario") && !Funcoes.textoVazio(rs.getString("smsAniversario"));
    }

    private static HashMap<String, Object> getHashMapCampos(String filial, ResultSet rs, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        try {
            if (!Funcoes.textoVazio(rs.getString("codigoPaciente"))) {
                mapa.put("codigopaciente", rs.getString("codigoPaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(Funcoes.preencheZero(rs.getString("codigoFilial"), digitosTuboFilial));
            buf.append(Funcoes.preencheZero(rs.getString("codigoRequisicao"), digitosTuboRequisicao));
            mapa.put("codigopacienteweb", buf.toString());
        }
        catch (SQLException buf) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("cpfPaciente"))) {
                mapa.put("cpfpaciente", rs.getString("cpfPaciente"));
            }
        }
        catch (SQLException buf) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("senhaWebPaciente"))) {
                mapa.put("senhawebpaciente", rs.getString("senhaWebPaciente"));
            }
        }
        catch (SQLException buf) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
                mapa.put("nomepaciente", rs.getString("nomePaciente").trim());
            }
        }
        catch (SQLException buf) {
            // empty catch block
        }
        try {
            mapa.put("nomeSocialPaciente", SMSUtil.getNomeSocial(rs));
        }
        catch (SQLException buf) {
            // empty catch block
        }
        try {
            mapa.put("nomeSocialPaciente", SMSUtil.getNomeSocial(rs));
            mapa.put("primeiroNomePaciente", SMSUtil.getPrimeiroNome(rs.getString("nomePaciente")));
            mapa.put("primeiroNomeSocialPaciente", SMSUtil.getPrimeiroNomeSocialPaciente(rs.getString("nomePaciente"), rs.getString("nomeSocialPaciente")));
        }
        catch (SQLException buf) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("codigoRequisicao"))) {
                String codigo = IntegracaoUtil.formataCodigoRequisicao(filial, rs.getString("codigoRequisicao"), st, digitosTuboFilial, digitosTuboRequisicao);
                mapa.put("codigorequisicao", codigo);
                mapa.put("codigoconvenio", rs.getInt("codigoConvenio"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("senhaWebRequisicao"))) {
                mapa.put("senhawebrequisicao", rs.getString("senhaWebRequisicao"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("dataRequisicao"))) {
                mapa.put("datarequisicao", Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataRequisicao")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("dataEntregaPrevistaRequisicao"))) {
                mapa.put("dataentregaprevistarequisicao", Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataEntregaPrevistaRequisicao")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("horaEntregaPrevistaRequisicao"))) {
                mapa.put("horaentregaprevistarequisicao", Funcoes.formataDataHora("HH:mm", rs.getString("horaEntregaPrevistaRequisicao")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("dataHoraAgenda"))) {
                mapa.put("datahoraagenda", Funcoes.formataDataEHora(rs.getString("dataHoraAgenda")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mapa;
    }

    public static String getPrimeiroNomeSocialPaciente(String nomePaciente, String nomeSocialPaciente) {
        return !Funcoes.textoVazio(SMSUtil.getPrimeiroNome(nomeSocialPaciente)) ? SMSUtil.getPrimeiroNome(nomeSocialPaciente) : SMSUtil.getPrimeiroNome(nomePaciente);
    }

    public static String getPrimeiroNome(String nomeCompleto) {
        String primeiroNome = nomeCompleto;
        if (!Funcoes.textoVazio(nomeCompleto) && nomeCompleto.contains(" ")) {
            primeiroNome = nomeCompleto.trim().split(" ")[0];
        }
        return !Funcoes.textoVazio(primeiroNome) ? primeiroNome.trim() : primeiroNome;
    }

    private static String getNomeSocial(ResultSet rs) throws SQLException {
        if (!Funcoes.textoVazio(rs.getString("nomeSocialPaciente"))) {
            return rs.getString("nomeSocialPaciente").trim();
        }
        if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
            return rs.getString("nomePaciente").trim();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String> getDadosParaFraseComRequisicao(String codigoFilial, String codigoRequisicao, Statement st) {
        HashMap<String, String> retorno = null;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.pac_codigo as codigoPaciente ");
            buf.append("       ,c.pac_cpf as cpfPaciente ");
            buf.append("       ,c.pac_senhaweb as senhaWebPaciente ");
            buf.append("       ,c.pac_nome as nomePaciente ");
            buf.append("       ,a.req_codigo as codigoRequisicao ");
            buf.append("       ,a.req_senhaweb as senhaWebRequisicao ");
            buf.append("       ,a.req_data as dataRequisicao ");
            buf.append("   from requisicao a ");
            buf.append("   left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
            buf.append("  where a.fil_codigo = ? ");
            buf.append("    and a.req_codigo = ? ");
            PreparedStatement prstDados = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstDados.setInt(1, Integer.parseInt(codigoFilial));
            prstDados.setInt(2, Integer.parseInt(codigoRequisicao));
            try (ResultSet rs = null;){
                rs = prstDados.executeQuery();
                if (rs.next()) {
                    ResultSetMetaData meta = rs.getMetaData();
                    retorno = new HashMap<String, String>();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        retorno.put(meta.getColumnName(i).toLowerCase(), rs.getString(meta.getColumnName(i)));
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar os dados.\n" + e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String> getDadosParaFraseComPaciente(String codigoFilial, String codigoPaciente, Statement st) {
        HashMap<String, String> retorno = null;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac_cpf as cpfPaciente ");
            buf.append("       ,pac_senhaweb as senhaWebPaciente ");
            buf.append("       ,pac_nome as nomePaciente ");
            buf.append("   from paciente ");
            buf.append("  where fil_codigo = ? ");
            buf.append("    and pac_codigo = ? ");
            PreparedStatement prstDados = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstDados.setInt(1, Integer.parseInt(codigoFilial));
            prstDados.setInt(2, Integer.parseInt(codigoPaciente));
            try (ResultSet rs = null;){
                rs = prstDados.executeQuery();
                if (rs.next()) {
                    ResultSetMetaData meta = rs.getMetaData();
                    retorno = new HashMap<String, String>();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        retorno.put(meta.getColumnName(i).toLowerCase(), rs.getString(meta.getColumnName(i)));
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar os dados.\n" + e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    private static String[] getArray(Map<String, Object> valores) {
        String[] retorno = new String[valores.size()];
        int contador = 0;
        Iterator<String> iterator = valores.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            retorno[contador] = key = iterator.next();
            ++contador;
        }
        return retorno;
    }

    public static ModeloGridTable getInformacoesSMS(Map<String, Object> valores) {
        ModeloGridTable modelo = new ModeloGridTable(SMSUtil.getArray(valores));
        modelo.addLine(new Object[valores.size()]);
        int contador = 0;
        for (Map.Entry<String, Object> entry : valores.entrySet()) {
            if (entry.getValue() != null) {
                modelo.setValueAt(entry.getValue(), modelo.getRowCount() - 1, contador);
            }
            ++contador;
        }
        return modelo;
    }

    public static String parseFraseSMS(String fraseOriginal, Map<String, Object> valores) {
        StringBuilder novaFrase = new StringBuilder(fraseOriginal);
        if (fraseOriginal.contains("2!")) {
            StringBuilder bui = new StringBuilder();
            String[] expressoes = MapaResolverExpressoesUtil.resolverExpressoes(fraseOriginal, MapaResolverExpressoesUtil.getCampos(SMSUtil.getInformacoesSMS(valores)), null, valores, false);
            for (int i = 0; i < expressoes.length; ++i) {
                expressoes[i] = StringUtil.removerAcentos(expressoes[i]);
            }
            MapaResolverExpressoesUtil.adicionarStrings(bui, expressoes, "", false);
            novaFrase = bui;
        } else {
            int pos = -1;
            while ((pos = novaFrase.indexOf("[")) > -1) {
                int posFim = novaFrase.indexOf("]", pos);
                String chave = novaFrase.substring(pos + 1, posFim);
                String valor = chave != null && valores.get(chave.trim().toLowerCase()) != null ? (String)valores.get(chave.trim().toLowerCase()) : "";
                novaFrase.delete(pos, posFim + 1);
                novaFrase.insert(pos, valor);
            }
        }
        return novaFrase.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarSMSResultadoPronto(String codigoFilial, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_enviarsms ");
            buf.append("       ,fil_smsresultados ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ? ");
            PreparedStatement prstEnviar = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                retorno = rs.next() && rs.getBoolean("fil_enviarsms") && rs.getBoolean("fil_smsresultados");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se a filial envia SMS de resultados prontos.\n" + e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarSMSRecoleta(String codigoFilial, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_enviarsms ");
            buf.append("       ,fil_smsrecoleta ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ? ");
            PreparedStatement prstEnviar = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                retorno = rs.next() && rs.getBoolean("fil_enviarsms") && rs.getBoolean("fil_smsrecoleta");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarSMSAniversario(String codigoFilial, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_enviarsms ");
            buf.append("       ,fil_smsaniversario ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ? ");
            PreparedStatement prstEnviar = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                retorno = rs.next() && rs.getBoolean("fil_enviarsms") && rs.getBoolean("fil_smsaniversario");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearSMSRecoleta(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select d.des_bloquearsmsrecoleta as des_bloquearsmsrecoleta, m.med_bloquearsmsrecoleta as med_bloquearsmsrecoleta");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                while (rs.next()) {
                    retorno = rs.getBoolean("des_bloquearsmsrecoleta") || rs.getBoolean("med_bloquearsmsrecoleta");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearSMSExamePronto(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select d.des_bloquearsmsexamepronto as des_bloquearsmsexamepronto, m.med_bloquearsmsexamepronto as med_bloquearsmsexamepronto");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                while (rs.next()) {
                    retorno = rs.getBoolean("des_bloquearsmsexamepronto") || rs.getBoolean("med_bloquearsmsexamepronto");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarSMSSenhaWeb(String codigoFilial, Statement st, boolean fecharStatement) {
        boolean retorno = false;
        try {
            block8: {
                StringBuilder buf = new StringBuilder();
                buf.append(" select fil_enviarsms ");
                buf.append("       ,fil_smssenhaweb ");
                buf.append("   from filiais_postocoleta ");
                buf.append("  where fil_codigo = ? ");
                PreparedStatement prstEnviar = SMSUtil.getPreparedStatement(st.getConnection(), buf.toString());
                prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
                ResultSet rs = null;
                try {
                    rs = prstEnviar.executeQuery();
                    while (rs.next()) {
                        retorno = rs.getBoolean("fil_enviarsms") && rs.getBoolean("fil_smssenhaweb");
                    }
                    if (rs == null) break block8;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        rs.close();
                    }
                    if (fecharStatement) {
                        Conexao.fecharStatement(st);
                    }
                    throw throwable;
                }
                rs.close();
            }
            if (fecharStatement) {
                Conexao.fecharStatement(st);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    public static String limpaCelular(String celular) {
        if (!Funcoes.textoVazio(celular)) {
            return StringUtil.limpaString(celular, new String[]{"(", ")", "-", " ", ".", ";"});
        }
        return "";
    }

    public static boolean isCelularVazio(String celular) {
        return Funcoes.textoVazio(SMSUtil.limpaCelular(celular)) || !celular.matches(REGEX_MASCARA_CELULAR) || !celular.matches(REGEX_MASCARA_CELULAR_PONTO);
    }

    public static PreparedStatement getPreparedStatement(Connection conexao, String sql) {
        try {
            return conexao.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public static String ajudaInterfaceModemSms() {
        StringBuilder ajuda = new StringBuilder();
        ajuda.append("Configura\u00e7\u00e3o de interface de modem SMS. \n \n");
        ajuda.append("1 - Com o modem conectado abra o gerenciador \n de dispositivos no gerenciador do computador.\n");
        ajuda.append("2 - Procure por modems na lista de componentes \n e selecione o modem SMS.\n");
        ajuda.append("3 - Nas propriedades do modem na aba modem configure \n a velocidade m\u00e1xima da porta.\n");
        ajuda.append("4 - Na aba diagn\u00f3stico clique sobre o bot\u00e3o consultar\n  modem para testar a conex\u00e3o com a porta.\n");
        ajuda.append("5 - Na aba avan\u00e7adas clique sobre o bot\u00e3o \n configura\u00e7\u00f5es avan\u00e7adas de porta.\n");
        ajuda.append("6 - Selecione o n\u00famero da porta COM.\n");
        ajuda.append("7 - Na aba avan\u00e7ados clique sobre o bot\u00e3o alterar \n prefer\u00eancias padr\u00e3o.\n");
        ajuda.append("8 - Na aba avan\u00e7ado especifique as configura\u00e7\u00f5es \n de hardware.\n");
        ajuda.append("9 - No gerenciador de dispositivos selecione as \n a porta do modem e abra as propriedades.\n");
        ajuda.append("10  - Na aba de configura\u00e7\u00f5es de porta configure as \n propriedades que ser\u00e3o as mesmas da tela de esta\u00e7\u00e3o.\n");
        ajuda.append("11  - Na tela de esta\u00e7\u00e3o no campo modem sms caso n\u00e3o \n tenha  portas disponivel confira os arquivos de configura\u00e7\u00e3o .jar e .dll ou .so.\n");
        ajuda.append("12  - Na tela de configurar modem coloque as mesmas configura\u00e7\u00f5es da porta do modem.\n");
        ajuda.append("13  - As bibliotecas rxtxSerial e rxtxParallel s\u00e3o diferentes para cada SO \n e devem ser configuradas juntas.\n");
        ajuda.append("14  - A biblioteca RXTXcomm.jar que ficar\u00e1 dentro da pasta do jre \n tamb\u00e9m tem sua vers\u00e3o para cada SO.\n");
        ajuda.append("15  - Por padr\u00e3o a bibliotecas .dll e .so para Linux \n devem ficar em /usr/lib e para Windows c:/Windows/system32.\n");
        ajuda.append("16  - Configurar a filial, esta\u00e7\u00e3o e o m\u00f3dulo do jalis que ir\u00e1 enviar SMS.\n");
        return ajuda.toString();
    }

    public static ModeloGridTable getInformacoesParaMensagemExpressao(String filial, String requisicao, int digitosTuboFilial, int digitosTuboRequisicao, String[] campoBanco, ExportaSMS.TipoSMS tipoSms, boolean isOcultarApenasFaturamento, Statement st, Boolean isColetaWeb) throws SQLException {
        if (st == null) {
            return null;
        }
        boolean agrupar = SMSUtil.agrupaMultiguiaSMS(Integer.valueOf(filial), Integer.valueOf(requisicao), st);
        StringBuilder buf = new StringBuilder("");
        buf.append("select a.exa_codigo, a.exr_situacao from examerequisicao a ");
        buf.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (isOcultarApenasFaturamento) {
            buf.append(" and a.exr_situacao <> 'A' ");
        }
        buf.append(" order by g.emc_pagina, g.emc_ordem, a.exa_codigo, a.mco_codigo ");
        ResultSet rs = isColetaWeb == false ? Conexao.executeQuery(st, buf.toString()) : st.executeQuery(buf.toString());
        StringBuilder exm = new StringBuilder("");
        while (rs.next()) {
            if (!Funcoes.textoVazio(exm.toString())) {
                exm.append(" ");
            }
            if (rs.getString("exr_situacao").equalsIgnoreCase("A")) {
                exm.append(rs.getString("exa_codigo")).append("^");
                continue;
            }
            exm.append(rs.getString("exa_codigo"));
        }
        Integer[] multiguiasTemp = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true);
        String multiguiaPrincipal = requisicao;
        for (Integer i : multiguiasTemp) {
            if (i >= Integer.parseInt(multiguiaPrincipal)) continue;
            multiguiaPrincipal = String.valueOf(i);
        }
        StringBuilder multiguias = new StringBuilder("");
        for (Integer i : multiguiasTemp) {
            if (multiguias.length() > 0) {
                multiguias.append(", ");
            }
            multiguias.append(i);
        }
        if (multiguiasTemp.length > 0) {
            SMSUtil.getExamesMultiguia(filial, requisicao, st, buf, rs, exm, multiguiasTemp);
        }
        return SMSUtil.getInformacoesSMS(filial, requisicao, digitosTuboFilial, digitosTuboRequisicao, campoBanco, st, agrupar, buf, exm, multiguiaPrincipal, multiguias, tipoSms, isColetaWeb);
    }

    private static ModeloGridTable getInformacoesSMS(String filial, String requisicao, int digitosTuboFilial, int digitosTuboRequisicao, String[] campoBanco, Statement st, boolean agrupar, StringBuilder buf, StringBuilder exm, String multiguiaPrincipal, StringBuilder multiguias, ExportaSMS.TipoSMS tipoSms, Boolean isColetaWeb) throws SQLException {
        buf.delete(0, buf.length());
        SMSUtil.getSQLInfoSMS(filial, requisicao, agrupar, buf, exm, multiguiaPrincipal, multiguias, tipoSms);
        ResultSet rs = isColetaWeb == false ? Conexao.executeQuery(st, buf.toString()) : st.executeQuery(buf.toString());
        String[] campos = campoBanco;
        ModeloGridTable modeloDados = new ModeloGridTable(campos);
        while (rs.next()) {
            modeloDados.addLine(new Object[campos.length]);
            String nomePaciente = Funcoes.textoVazio(rs.getString("nomePaciente")) ? "" : rs.getString("nomePaciente").split(" ")[0];
            for (int i = 0; i < campoBanco.length; ++i) {
                String data;
                if (campoBanco[i].equals("codigoPacienteWeb")) {
                    modeloDados.setValueAt(Funcoes.preencheZero(filial, digitosTuboFilial).concat(Funcoes.preencheZero(requisicao, digitosTuboRequisicao)), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (campoBanco[i].equals("dataRequisicao")) {
                    data = Funcoes.textoVazio(rs.getString("dataRequisicao")) ? "" : Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataRequisicao"));
                    modeloDados.setValueAt(data, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (campoBanco[i].equals("dataHoraAgenda")) {
                    data = Funcoes.textoVazio(rs.getString("dataHoraAgenda")) ? "" : Funcoes.formataDataEHora(rs.getString("dataHoraAgenda"));
                    modeloDados.setValueAt(data, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (campoBanco[i].equals("dataEntregaPrevistaRequisicao")) {
                    String dataprev = rs.getDate("dataEntregaPrevistaRequisicao") == null ? "" : Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataEntregaPrevistaRequisicao"));
                    modeloDados.setValueAt(dataprev, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (campoBanco[i].equals("horaEntregaPrevistaRequisicao")) {
                    String hora = Funcoes.textoVazio(rs.getString("horaEntregaPrevistaRequisicao")) ? "" : Funcoes.formataDataHora("HH:mm", rs.getString("horaEntregaPrevistaRequisicao"));
                    modeloDados.setValueAt(hora, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (campoBanco[i].equals("primeiroNomeSocialPaciente")) {
                    String nomeSocial = Funcoes.textoVazio(rs.getString("nomeSocialPaciente")) ? nomePaciente : rs.getString("nomeSocialPaciente").split(" ")[0];
                    modeloDados.setValueAt(nomeSocial, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (campoBanco[i].equals("primeiroNomePaciente")) {
                    modeloDados.setValueAt(nomePaciente, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (DBUtil.campoNull(rs.getString(campoBanco[i]))) {
                    modeloDados.setValueAt(null, modeloDados.getRowCount() - 1, i);
                    continue;
                }
                if (campoBanco[i].equals("nomeSocialPaciente")) {
                    modeloDados.setValueAt(SMSUtil.getNomeSocial(rs), modeloDados.getRowCount() - 1, i);
                    continue;
                }
                modeloDados.setValueAt(rs.getObject(campoBanco[i]), modeloDados.getRowCount() - 1, i);
            }
        }
        return modeloDados;
    }

    private static void getSQLInfoSMS(String filial, String requisicao, boolean agrupar, StringBuilder buf, StringBuilder exm, String multiguiaPrincipal, StringBuilder multiguias, ExportaSMS.TipoSMS tipoSms) {
        buf.append("select ");
        if (agrupar) {
            buf.append(multiguiaPrincipal);
        } else {
            buf.append("a.req_codigo");
        }
        buf.append(" as codigoRequisicao, a.req_data as dataRequisicao, a.req_dataentregaprev as dataEntregaPrevistaRequisicao,");
        buf.append(" a.req_horaentregaprev as horaEntregaPrevistaRequisicao,");
        buf.append(" a.req_senhaweb as senhaWebRequisicao,");
        buf.append("'" + exm.toString() + "' as codigosExames, ");
        buf.append(multiguiaPrincipal).append(" as codigoPrincipalMultiGuiaRequisicao, ");
        buf.append("'").append(multiguias.toString()).append("' as codigosMultiGuiaRequisicao, ");
        buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_senhaweb as senhaWebPaciente, ");
        buf.append("j.pac_cpf as cpfPaciente, ");
        buf.append("j.pac_nomesocial as nomeSocialPaciente, ");
        buf.append("agd.agd_datahoraagenda as dataHoraAgenda, a.con_codigo as codigoConvenio ");
        buf.append("from requisicao a ");
        buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("left join agendamento agd on a.fil_codigo = agd.fil_codigo and a.req_codigo = agd.req_codigo and agd.agd_situacao = '").append("A").append("' ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo");
        if (agrupar) {
            buf.append(" in ( ").append((CharSequence)multiguias).append(" )");
        } else {
            buf.append(" = ").append(requisicao);
        }
        if (!tipoSms.equals((Object)ExportaSMS.TipoSMS.AGENDAMENTO)) {
            buf.append(" and a.req_excluida = false ");
        }
        buf.append(" order by codigoRequisicao");
    }

    private static void getExamesMultiguia(String filial, String requisicao, Statement st, StringBuilder buf, ResultSet rs, StringBuilder exm, Integer[] multiguiasTemp) throws SQLException {
        for (Integer codigo : multiguiasTemp) {
            if (Integer.parseInt(requisicao) == codigo) continue;
            buf.delete(0, buf.length());
            buf.append("select a.exa_codigo, a.exr_situacao  from examerequisicao a ");
            buf.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append(" where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(codigo);
            buf.append(" and a.exr_excluido = false ");
            buf.append(" order by g.emc_pagina, g.emc_ordem, a.exa_codigo, a.mco_codigo ");
            rs = Conexao.executeQuery(st, buf.toString());
            if (!rs.next()) continue;
            do {
                if (exm.toString().indexOf("<") >= 0 && !exm.toString().trim().endsWith(">")) {
                    exm.append(" ");
                } else {
                    exm.append(" <");
                }
                if (rs.getString("exr_situacao").equalsIgnoreCase("A")) {
                    exm.append(rs.getString("exa_codigo")).append("^");
                    continue;
                }
                exm.append(rs.getString("exa_codigo"));
            } while (rs.next());
            exm.append(">");
        }
    }

    static {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append(" select pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,COALESCE(pac.pac_bloquearsms, false) as bloquearSmsPaciente ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_senhaweb as senhaWebRequisicao ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_dataentregaprev as dataEntregaPrevistaRequisicao ");
        buf.append("       ,req.req_horaentregaprev as horaEntregaPrevistaRequisicao ");
        buf.append("       ,req.req_smsresultadoenviada IS NOT NULL as smsResultadoEnviado ");
        buf.append("       ,cast(req.fil_codigo as varchar) || req.req_codigo as codigoPacienteWeb ");
        buf.append("       ,COALESCE(fil.fil_enviarsms, false) as enviarSms ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,fil.fil_smsaniversario as enviarSmsAniversario ");
        buf.append("       ,fil.fil_smsresultados as enviarSmsResultado ");
        buf.append("       ,fil.fil_smssenhaweb as enviarSmsSenhaWeb ");
        buf.append("       ,fil.fil_smsrecoleta as enviarSmsRecoleta ");
        buf.append("       ,fil.fil_smsrequisicao as enviarSmsRequisicao ");
        buf.append("       ,fil.fil_smsresumofinanceiro as enviarSmsFinanceiro ");
        buf.append("       ,fil.fil_smsagendamento as enviarSmsAgendamento ");
        buf.append("       ,fil.fil_frasesmsaniversario as smsAniversario ");
        buf.append("       ,fil.fil_frasesmsresultados as smsResultado ");
        buf.append("       ,fil.fil_frasesmssenhaweb as smsSenhaWeb ");
        buf.append("       ,fil.fil_frasesmsrecoleta as smsRecoleta ");
        buf.append("       ,fil.fil_frasesmsrequisicao as smsRequisicao ");
        buf.append("       ,fil.fil_frasesmsagendamento as smsAgendamento ");
        buf.append("       ,agd.agd_datahoraagenda as dataHoraAgenda");
        buf.append("   from requisicao req ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join filiais_postocoleta fil on req.fil_codigo = fil.fil_codigo ");
        buf.append("   left join agendamento agd on req.fil_codigo = agd.fil_codigo and req.req_codigo = agd.req_codigo and agd.agd_situacao = '").append("A").append("'");
        buf.append("  where req.fil_codigo = ? ");
        buf.append("    and req.req_codigo = ? ");
        buf.append(" order by agd.agd_codigo desc limit 1");
        sqlDadosSMS = buf.toString();
        buf.setLength(0);
        buf.append(" select pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,COALESCE(pac.pac_bloquearsms, false) as bloquearSmsPaciente ");
        buf.append("       ,COALESCE(fil.fil_enviarsms, false) as enviarSms ");
        buf.append("       ,pac.con_codigo as codigoConvenio ");
        buf.append("       ,fil.fil_codigo as codigoFilial ");
        buf.append("       ,fil.fil_smsaniversario as enviarSmsAniversario ");
        buf.append("       ,fil.fil_smsresultados as enviarSmsResultado ");
        buf.append("       ,fil.fil_smssenhaweb as enviarSmsSenhaWeb ");
        buf.append("       ,fil.fil_smsrecoleta as enviarSmsRecoleta ");
        buf.append("       ,fil.fil_smsrequisicao as enviarSmsRequisicao ");
        buf.append("       ,fil.fil_smsresumofinanceiro as enviarSmsFinanceiro ");
        buf.append("       ,fil.fil_smsresumofinanceiro as enviarSmsAgendamento ");
        buf.append("       ,fil.fil_frasesmsaniversario as smsAniversario ");
        buf.append("       ,fil.fil_frasesmsresultados as smsResultado ");
        buf.append("       ,fil.fil_frasesmssenhaweb as smsSenhaWeb ");
        buf.append("       ,fil.fil_frasesmsrecoleta as smsRecoleta ");
        buf.append("       ,fil.fil_frasesmsrequisicao as smsRequisicao ");
        buf.append("       ,fil.fil_frasesmsagendamento as smsAgendamento ");
        buf.append("   from paciente pac ");
        buf.append("   join filiais_postocoleta fil on pac.fil_codigo = fil.fil_codigo ");
        buf.append("  where pac.fil_codigo = ? ");
        buf.append("    and pac.pac_codigo = ? ");
        sqlDadosPaciente = buf.toString();
        buf.setLength(0);
        buf.append(" select bool_or(CASE WHEN req_smsresultadoenviada is null then false else true end) as smsEnviado ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        sqlMultiguiasEnviaramSms = buf.toString();
        buf.setLength(0);
        buf.append(" select count(*) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo  = ? ");
        buf.append("    and req_codigo  = ? ");
        buf.append("    and not exr_excluido ");
        buf.append("    and exr_situacao <> ? ");
        sqlQuantidadeExamesMultiguias = buf.toString();
        buf.setLength(0);
        buf.append(" select con_bloquearsmsexamepronto as bloquearResultado");
        buf.append("       ,con_bloquearsmsrecoleta as bloquearRecoleta ");
        buf.append("       ,con_bloquearsmsaniversario as bloquearAniversario ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and con_codigo = ? ");
        sqlBloqueiosEnvioSmsConvenio = buf.toString();
    }
}

