/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util;

import jalis.comum.Conexao;
import jalis.comum.MotivoExclusao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.RetornoPerguntas;
import jalis.mensagens.NovaMensagem;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;

public class RecepcaoUtil {
    public static final int AVISA_EXCLUSAO = 1;
    public static final int AVISA_INCLUSAO = 2;
    public static final int AVISA_RETIFICACAO = 3;

    public static HashMap<String, Object> preencheHashDados(String filial, String requisicao, String codigoExame, String codigoMaterial) throws SQLException {
        Statement st = Conexao.getStatement();
        RetornoPerguntas retorno = RecepcaoUtil.preencheHashDados(filial, requisicao, codigoExame, codigoMaterial, Variaveis.login, Variaveis.nomeUsuario, st, false, null, false);
        Conexao.fecharStatement(st);
        return retorno.getHashCamposDoBanco() == null ? null : retorno.getHashCamposDoBanco();
    }

    public static RetornoPerguntas preencheHashDados(String filial, String requisicao, String codigoExame, String codigoMaterial, String login, String nomeUsuario, Statement st, boolean isColetaWeb, String xml, boolean visualizar) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Funcoes.isNumeric(requisicao) || !Funcoes.isNumeric(codigoMaterial)) {
            return null;
        }
        DadosMaterial material = ExameUtil.getDadosMaterial(filial, Integer.parseInt(codigoMaterial), st);
        DadosExames dados = ExameUtil.getDadosExame(filial, codigoExame, material, st);
        map.put("valorChExame", dados.getValorCH());
        map.put("codigoExame", dados.getCodigo());
        map.put("descricaoExame", dados.getDescricao());
        map.put("ambExame", dados.getAMB());
        map.put("chExame", dados.getValor());
        map.put("valorExame", dados.getValorExame());
        map.put("valorMateriaisExame", dados.getValorMaterial());
        map.put("descricaoMaterial", material.getDescricao());
        map.put("codigoMaterial", material.getCodigo());
        map.put("descricaoPrazo", dados.getPrazo());
        map.put("codigoPrazo", dados.getCodPrazo());
        map.put("codigoMetodo", dados.getCodMetodo());
        map.put("descricaoMetodo", dados.getDescMetodo());
        map.put("abreviaturaMaterial", material.getAbreviatura());
        StringBuilder buf = new StringBuilder("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, ");
        buf.append("\ta.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, ");
        buf.append("\ta.req_dataentregaprev as dataEntregaRequisicao, a.req_dclinicos as dadosClinicosRequisicao, ");
        buf.append("\tcoalesce(a.req_obs, '') as observacaoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, ");
        buf.append("\ta.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao, ");
        buf.append("\ta.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, ");
        buf.append("\ta.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
        buf.append("\ta.req_idade as idadeRequisicao, a.req_anomes as anomesRequisicao, a.req_matricula as matriculaRequisicao, ");
        buf.append("\ta.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequsicao, ");
        buf.append("\ta.req_titular as titularRequisicao, a.req_peso as pesoRequisicao, a.req_altura as alturaRequisicao, ");
        buf.append("\ta.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao, ");
        buf.append("\ta.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, ");
        buf.append("\ta.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.sit_codigo as codigoSituacao, ");
        buf.append("\ta.usr_codigo as codigoUsuario, b.sit_descricao as descricaoSituacao, c.usr_nome as nomeUsuario, ");
        buf.append("\ta.des_codigo as codigoDestino, des.des_descricao as descricaoDestino, ");
        buf.append("\tdes.des_complemento as complementoDestino, des.des_endereco as enderecoDestino, ");
        buf.append("\tdes.des_fone as foneDestino, des.des_cep as cepDestino, ");
        buf.append("\tciddes.cid_codigo as codigoCidadeDestino, ciddes.cid_nome as descricaoCidadeDestino, ciddes.cid_uf as estadoCidadeDestino, ");
        buf.append("\tbaides.bai_codigo as codigoBairroDestino, baides.bai_descricao as descricaoBairroDestino, ");
        buf.append("\ta.col_codigo as codigoColeta, col.col_descricao as descricaoColeta, ");
        buf.append("\tcol.col_complemento as complementoColeta, col.col_endereco as enderecoColeta, ");
        buf.append("\tcol.col_fone as foneColeta, col.col_cep as cepColeta, ");
        buf.append("\tcidcol.cid_codigo as codigoCidadeColeta, cidcol.cid_nome as descricaoCidadecoleta, cidcol.cid_uf as estadoCidadeColeta, ");
        buf.append("\tbaicol.bai_codigo as codigoBairroColeta, baicol.bai_descricao as descricaoBairroColeta, ");
        buf.append("\ta.fil_codigo as codigoFilial, fil.fil_descricao as descricaoFilial, fil.fil_complemento as complementoFilial, ");
        buf.append("  fil.fil_endereco as enderecoFilial, fil.fil_fone as foneFilial, fil.fil_cep as cepFilial, ");
        buf.append("\tfil.fil_cnpj as cnpjFilial, fil.fil_fax as faxFilial, fil.fil_razaosocial as razaoSocialFilial, ");
        buf.append("\tcidfil.cid_codigo as codigoCidadeFilial, cidfil.cid_nome as descricaoCidadeFilial, cidfil.cid_uf as estadoCidadeFilial, ");
        buf.append("\tbaifil.bai_codigo as codigoBairroFilial, baifil.bai_descricao as descricaoBairroFilial, ");
        buf.append("\tmed.med_conselho as conselhoMedico, med.med_crm as crmMedico, med.med_uf as estadoCrmMedico, ");
        buf.append("\tmed.med_nome as nomeMedico, med.med_abrev as tratamentoMedico, ");
        buf.append("\tmed.med_endereco as enderecoMedico, med.med_complemento as complementoMedico, ");
        buf.append("\tmed.med_numeroendereco as numerEnderecoMedico, med.med_tipologradouroendereco as tipoLogradouroMedico, ");
        buf.append("\tmed.med_cep as cepMedico, med.med_fone as foneMedico, med.med_celular as celularMedico, ");
        buf.append("\tmed.med_fax as faxMedico, med.med_email as emailMedico, med.med_site as siteMedico, ");
        buf.append("\tcon.con_codigo as codigoConvenio, con.con_fantasia as fantasiaMedico, ");
        buf.append("\tcon.con_endereco as enderecoMedico, con.con_razao as razaoSocialConvenio, con.con_complemento as complementoConvenio, ");
        buf.append("\tcon.con_endereco as enderecoConvenio, con.con_numeroendereco as numeroEnderecoConvenio, ");
        buf.append("\tcon.con_tipologradouroendereco as tipoLogradouroConvenio, con.con_cep as cepConvenio, ");
        buf.append("\tcon.con_fone as foneConvenio, con.con_email1 as email1Convenio,  ");
        buf.append("\tcon.con_email2 as email2Convenio, con.con_site as siteConvenio, ");
        buf.append("\tpac.pac_codigo as codigoPaciente, pac.pac_nome as nomePaciente, ");
        buf.append("\tpac.pac_sexo as sexoPaciente, pac.pac_grpsangue as grupoSanguineoPaciente, ");
        buf.append("\tpac.pac_fatorrh as fatorrhPaciente, pac.pac_fatordu as fatorduPaciente, ");
        buf.append("\tpac.pac_datanasc as dataNascimentoPaciente, pac.pac_dum as dumPaciente, ");
        buf.append("\tpac.pac_cor as corPaciente, pac.pac_profissao as profissaoPaciente,  ");
        buf.append("\tpac.pac_rg as rgPaciente, pac.pac_cpf as cpfPaciente, ");
        buf.append("\tpac.pac_estcivil as estadoCivilPaciente, pac.pac_fone as fonePaciente, ");
        buf.append("\tpac.pac_celular as celularPaciente, pac.pac_fax as faxPaciente, ");
        buf.append("\tpac.pac_complemento as complementoPaciente, pac.pac_endereco as enderecoPaciente, ");
        buf.append("\tpac.pac_numeroendereco as numeroEnderecoPaciente, pac.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
        buf.append("\tpac.pac_fonecomercial as foneComercialPaciente, ");
        buf.append("\tpac.pac_email as emailPaciente, pac.pac_fonecontato as foneContatoPaciente, ");
        buf.append("\tpac.pac_nomecontato as nomeContatoPaciente, pac.cid_codigo as codigoCidadePaciente,  ");
        buf.append("\tpac.bai_codigo as codigoBairroPaciente, cidpac.cid_nome as descricaoCidadePaciente, ");
        buf.append("\tcidpac.cid_uf as estadoCidadePaciente, ");
        buf.append("\tbaipac.bai_descricao as descricaoBairroPaciente, pac.pac_cep as cepPaciente, ");
        buf.append("\texr.exr_situacao as descricaoSituacaoExame, ");
        buf.append("\texr.exr_situacao as situacaoExame, exr.exr_datamaterial as dataColetaExame, ");
        buf.append("\texr.usr_codmaterial as usuarioColetaExame, exr.exr_descricaomaterial as materialInformadoExame, ");
        buf.append("\texr.exr_dataentregaprev as dataEntregaExame, exr.exr_dataentregaprev as horaEntregaExame, ");
        buf.append("\texr.exr_codautorizacao as autorizacaoExame, ");
        buf.append("\tcoalesce(exr.exr_urgente, false) as urgenteExame ");
        buf.append("from examerequisicao exr ");
        buf.append("left join requisicao a on exr.fil_codigo = a.fil_codigo and exr.req_codigo = a.req_codigo ");
        buf.append("left join situacao b on a.fil_codigo = b.fil_codigo and a.sit_codigo = b.sit_codigo ");
        buf.append("left join usuario c on a.usr_codigo = c.usr_codigo ");
        buf.append("left join destino des on a.fil_codigo = des.fil_codigo and a.des_codigo = des.des_codigo ");
        buf.append("left join cidades ciddes on des.fil_codigo = ciddes.fil_codigo and des.cid_codigo = ciddes.cid_codigo ");
        buf.append("left join bairro baides on des.fil_codigo = baides.fil_codigo and des.bai_codigo = baides.bai_codigo ");
        buf.append("left join coletas col on a.fil_codigo = col.fil_codigo and a.col_codigo = col.col_codigo ");
        buf.append("left join cidades cidcol on col.fil_codigo = cidcol.fil_codigo and col.cid_codigo = cidcol.cid_codigo ");
        buf.append("left join bairro baicol on col.fil_codigo = baicol.fil_codigo and col.bai_codigo = baicol.bai_codigo ");
        buf.append("left join filiais_postocoleta fil on a.fil_codigo = fil.fil_codigo and a.fil_codigo = fil.fil_codigo ");
        buf.append("left join cidades cidfil on fil.fil_codigo = cidfil.fil_codigo and fil.cid_codigo = cidfil.cid_codigo ");
        buf.append("left join bairro baifil on fil.fil_codigo = baifil.fil_codigo and fil.bai_codigo = baifil.bai_codigo ");
        buf.append("left join medico med on a.fil_codigo = med.fil_codigo and a.med_conselho = med.med_conselho and a.med_crm = med.med_crm and a.med_uf = med.med_uf ");
        buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
        buf.append("left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
        buf.append("left join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
        buf.append("left join bairro baipac on pac.fil_codigo = baipac.fil_codigo and pac.bai_codigo = baipac.bai_codigo ");
        buf.append("where exr.fil_codigo = ");
        buf.append(filial);
        buf.append(" and exr.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and exr.exa_codigo = '");
        buf.append(codigoExame);
        buf.append("' and exr.mco_codigo = ");
        buf.append(codigoMaterial);
        buf.append(" and a.req_excluida = false and exr.exr_excluido = false ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                String fieldName = rs.getMetaData().getColumnName(i);
                if (fieldName.equals("descricaoSituacaoExame")) {
                    map.put(fieldName, Tipos.tipoSituacaoExame(rs.getString("situacaoExame")));
                    continue;
                }
                if (fieldName.equalsIgnoreCase("tipoLogradouroPaciente") || fieldName.equalsIgnoreCase("tipoLogradouroMedico") || fieldName.equalsIgnoreCase("tipoLogradouroConvenio")) {
                    map.put(fieldName, Tipos.tipoLogradouroDescricao(rs.getString(fieldName)));
                    continue;
                }
                if (fieldName.equals("sexoPaciente")) {
                    map.put(fieldName, Tipos.tipoSexo(rs.getString("sexoPaciente")));
                    continue;
                }
                if (fieldName.equals("corPaciente")) {
                    map.put(fieldName, Tipos.tipoCor(rs.getString("corPaciente")));
                    continue;
                }
                if (fieldName.equals("estadoCivilPaciente")) {
                    map.put(fieldName, Tipos.tipoEstadoCivil(rs.getString("estadoCivilPaciente")));
                    continue;
                }
                map.put(fieldName, rs.getObject(fieldName));
            }
            map.put("codigoUsuarioLogado", login);
            map.put("nomeUsuarioLogado", nomeUsuario);
        }
        rs.close();
        RetornoPerguntas retornoPerguntas = new RetornoPerguntas();
        if (isColetaWeb) {
            retornoPerguntas.setHashCamposDoBanco(map);
            Digitacao digitacao = new Digitacao();
            if (!visualizar) {
                digitacao.carregarCampos(xml, map, null, null, null, null, true, 1, null, null);
            } else {
                digitacao.carregarCampos(xml, null, null, null, null, null, false, 1, null, null);
            }
            retornoPerguntas.setDigitacao(digitacao);
            retornoPerguntas.setXmlPerguntas(digitacao.getResultadoObj().gerarResultado("resultado", false, true));
            return retornoPerguntas;
        }
        retornoPerguntas.setHashCamposDoBanco(map);
        return retornoPerguntas;
    }

    public static Integer[] verificaMultiGuias(String filial, String requisicao) throws SQLException {
        return RecepcaoUtil.verificaMultiGuias(filial, requisicao, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer[] verificaMultiGuias(String filial, String requisicao, boolean adicionarAtual) throws SQLException {
        Statement st = Conexao.getStatement();
        Integer[] retorno = null;
        try {
            retorno = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, adicionarAtual, false);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static Integer[] verificaMultiGuias(Statement st, String filial, String requisicao, boolean adicionarAtual) throws SQLException {
        return RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, adicionarAtual, false);
    }

    public static Integer[] verificaMultiGuias(Statement st, String filial, String requisicao, boolean adicionarAtual, boolean trazerExcluidas) throws SQLException {
        String sql = "select verificaMultiguiasJalis(" + filial + "," + requisicao + "," + adicionarAtual + "," + trazerExcluidas + ")";
        ArrayList<Integer> guias = new ArrayList<Integer>();
        try {
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                Integer[] requisicoes;
                Array arr = (Array)rs.getObject("verificaMultiguiasJalis");
                if (null == arr) continue;
                for (Integer req : requisicoes = (Integer[])arr.getArray()) {
                    guias.add(req);
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return guias.isEmpty() ? null : (Integer[])guias.stream().sorted().toArray(Integer[]::new);
    }

    public static String mensagemMultiGuias(String filial, String requisicao) throws SQLException {
        Integer[] guias = RecepcaoUtil.verificaMultiGuias(filial, requisicao);
        if (guias != null && guias.length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("A requisi\u00e7\u00e3o possui a");
            if (guias.length > 1) {
                buf.append("s seguintes multiguias:\n ");
            } else {
                buf.append(" seguinte multiguia:\n ");
            }
            for (int i = 0; i < guias.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(guias[i]);
            }
            return buf.toString();
        }
        return "";
    }

    public static void avisaResponsavelSetor(boolean isColetaWeb, Statement st, String filial, String requisicao, String exame, String codigoMaterial, int operacao) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("select b.usr_codigo, b.set_enviarmensagem from examesetor a ");
        buf.append("left join setores b on a.fil_codigo = b.fil_codigo and a.set_codigo = b.set_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.exa_codigo = '");
        buf.append(StringUtil.textoDB(exame));
        buf.append("' and a.ese_default = true");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next() && rs.getBoolean("set_enviarmensagem")) {
            String destino = rs.getString("usr_codigo");
            if (Funcoes.textoVazio(destino)) {
                return;
            }
            buf.delete(0, buf.length());
            buf.append(operacao == 1 ? "Exclus\u00e3o " : "Inclus\u00e3o ");
            buf.append("de exame na requisi\u00e7\u00e3o ").append(requisicao).append(".\n");
            buf.append("Exame ").append(operacao == 1 ? "exclu\u00eddo " : "adicionado ");
            buf.append(exame).append(" (").append(codigoMaterial).append(")\n");
            buf.append("Filial: ").append(filial).append("\n");
            buf.append("Usu\u00e1rio respons\u00e1vel: ").append(Variaveis.login).append("\n");
            buf.append("Data: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
            RecepcaoUtil.enviarMensagem(isColetaWeb, st, Variaveis.filialPadrao, Variaveis.login, destino, operacao == 1 ? "Exclus\u00e3o de exame" : "Inclus\u00e3o de exame", buf.toString(), false, "C");
        }
    }

    public static void enviarMensagem(boolean isColetaWeb, Statement st, String filialOrigem, String usuarioOrigem, String usuarioDestino, String assunto, String mensagem, boolean exigeResposta, String tipo) throws Exception {
        SalvaDados salvar = new SalvaDados("usuariomensagem", 0);
        ResultSet rs = st.executeQuery("select nextval('usuariomensagem_ume_codigo_seq')");
        String codigo = "-1";
        if (rs != null && rs.next()) {
            codigo = rs.getString(1);
        }
        salvar.adicionaCampo("ume_codigo", 2, false, false, codigo);
        salvar.adicionaCampo("usr_codorigem", 0, false, false, usuarioOrigem);
        salvar.adicionaCampo("usr_coddestino", 0, false, false, usuarioDestino);
        salvar.adicionaCampo("ume_assunto", 0, false, false, assunto);
        salvar.adicionaCampo("ume_mensagem", 0, false, false, mensagem);
        salvar.adicionaCampo("ume_confirmarleitura", 4, false, false, exigeResposta);
        if (isColetaWeb) {
            salvar.adicionaCampo("ume_datahora", 5, false, false, new Timestamp(new Date().getTime()));
        } else {
            Timestamp dataHoraServidor = new Timestamp(Funcoes.getDataHoraServidor().getTime());
            salvar.adicionaCampo("ume_datahora", 5, false, false, dataHoraServidor);
        }
        salvar.adicionaCampo("ume_tipo", 0, false, false, tipo);
        int hash = (codigo + usuarioOrigem + usuarioDestino + assunto + mensagem).hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        salvar.adicionaCampo("ume_hash", 2, false, false, hash);
        String comando = salvar.getComando();
        if (isColetaWeb) {
            st.executeUpdate(comando);
        } else {
            String[] filiaisIntegracao;
            Conexao.execute(Variaveis.filialPadrao, st, comando, true);
            for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
                salvar.removerCampo("ume_codigo");
                IntegracaoUtil.insereComandoLog(st, filialOrigem, filial, salvar.getComando());
            }
        }
    }

    public static void avisaResponsavelSetorRetificado(Statement st, String filial, String requisicao, String exame, String codigoMaterial) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("select b.set_enviarmensagem, b.set_enviarmensagemretificado, s.usr_codigo  ");
        buf.append(" from examesetor a ");
        buf.append("left join setores b on a.fil_codigo = b.fil_codigo and a.set_codigo = b.set_codigo ");
        buf.append("left join setoresusuario s on a.fil_codigo = s.fil_codigo and a.set_codigo = b.set_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and b.set_codigo = s.set_codigo ");
        buf.append(" and a.exa_codigo = '");
        buf.append(StringUtil.textoDB(exame));
        buf.append("' and a.ese_default = true");
        ResultSet rs = Conexao.executeQuery(st, buf);
        Statement st1 = Conexao.getStatement();
        while (rs.next()) {
            if (!rs.getBoolean("set_enviarmensagemretificado")) continue;
            String destino = rs.getString("usr_codigo");
            if (Funcoes.textoVazio(destino)) {
                return;
            }
            buf.delete(0, buf.length());
            buf.append("Retifica\u00e7\u00e3o de exame na requisi\u00e7\u00e3o ").append(requisicao).append(".\n");
            buf.append("Exame retificado ");
            buf.append(exame).append(" (").append(codigoMaterial).append(")\n");
            buf.append("Filial: ").append(filial).append("\n");
            buf.append("Usu\u00e1rio respons\u00e1vel: ").append(Variaveis.login).append("\n");
            buf.append("Data: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
            NovaMensagem.enviarMensagem(st1, Variaveis.login, destino, "Retifica\u00e7\u00e3o de exame", buf.toString(), false);
        }
    }

    public static void avisaResponsavelSetores(Statement st, String filial, String requisicao, String exame, String codigoMaterial, int operacao) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("select usr_codigo, set_enviarmensagemretificado from examesetor e  ");
        buf.append(" left join setores s on s.fil_codigo = e.fil_codigo and s.set_codigo = e.set_codigo ");
        buf.append(" where e.fil_codigo = ");
        buf.append(filial);
        buf.append(" and e.exa_codigo = '");
        buf.append(StringUtil.textoDB(exame));
        buf.append("' and e.ese_default = true");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next() && rs.getBoolean("set_enviarmensagemretificado")) {
            String destino = rs.getString("usr_codigo");
            if (Funcoes.textoVazio(destino)) {
                return;
            }
            buf.delete(0, buf.length());
            buf.append(operacao == 3 ? "Retifica\u00e7\u00e3o " : (operacao == 1 ? "Exclus\u00e3o " : "Inclus\u00e3o "));
            buf.append(operacao == 1 ? "Exclus\u00e3o " : "Inclus\u00e3o ");
            buf.append("de exame na requisi\u00e7\u00e3o ").append(requisicao).append(".\n");
            buf.append("Exame ").append(operacao == 1 ? "exclu\u00eddo " : "adicionado ");
            buf.append(exame).append(" (").append(codigoMaterial).append(")\n");
            buf.append("Filial: ").append(filial).append("\n");
            buf.append("Usu\u00e1rio respons\u00e1vel: ").append(Variaveis.login).append("\n");
            buf.append("Data: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
            NovaMensagem.enviarMensagem(st, Variaveis.login, "admin", operacao == 3 ? "Retifica\u00e7\u00e3o de exame" : (operacao == 1 ? "Exclus\u00e3o de exame" : "Inclus\u00e3o de exame"), buf.toString(), false);
        }
    }

    public static void gravaLogExclusaoRequisicao(Object pai, Statement st, String filial, String requisicao) throws Exception {
        MotivoExclusao m;
        StringBuilder buf = new StringBuilder();
        String codigoPaciente = "-1";
        String motivo = "Motivo n\u00e3o informado";
        if (ParametrosGerais.getPerguntarMotivoExclusao() && (m = MotivoExclusao.novaInstancia(pai)) != null) {
            m.setVisible(true);
            if (m.getOK() && !Funcoes.textoVazio(m.getMotivo())) {
                motivo = m.getMotivo();
            }
        }
        buf.append("select * from requisicao where fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<Registro> regs = new ArrayList<Registro>();
        ArrayList<String> tabelas = new ArrayList<String>();
        if (rs.next()) {
            codigoPaciente = rs.getString("pac_codigo");
            tabelas.add("requisicao");
            regs.add(new Registro(rs));
        }
        buf.delete(0, buf.length());
        buf.append("select * from paciente where fil_codigo = ").append(filial);
        buf.append(" and pac_codigo = ").append(codigoPaciente);
        rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            tabelas.add("paciente");
            regs.add(new Registro(rs));
        }
        buf.delete(0, buf.length());
        buf.append("select * from examerequisicao where fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            tabelas.add("examerequisicao");
            regs.add(new Registro(rs));
        }
        if (tabelas.size() > 0) {
            DBUtil.gravaLogXML(st, filial, regs.toArray(new Registro[regs.size()]), tabelas.toArray(new String[tabelas.size()]), "Requisi\u00e7\u00e3o", requisicao, new String[]{"fil_codigo, req_codigo, exa_codigo, mco_codigo"}, "E", motivo);
        }
    }

    public static String getMensagemPendenciaPaciente(Statement st, String filial, String codigoPaciente, String codigoRequisicao) throws SQLException {
        ResultSet rs;
        String retorno = "";
        int parametro = ParametrosGerais.getPendenciaPaciente();
        if (parametro == 0 || !Funcoes.isNumeric(codigoPaciente)) {
            return "";
        }
        boolean devedor = false;
        StringBuilder bui = new StringBuilder();
        if (parametro == 2 || parametro == 3) {
            bui.setLength(0);
            bui.append("select req_deveguia, req_totpago, req_total from requisicao where ");
            bui.append("fil_codigo = ").append(filial);
            bui.append(" and pac_codigo = ").append(codigoPaciente);
            bui.append(" and req_excluida = false ");
            if (codigoRequisicao != null && !Funcoes.textoVazio(codigoRequisicao)) {
                bui.append(" and req_codigo <> ").append(codigoRequisicao);
            }
            rs = Conexao.executeQuery(st, bui);
            while (rs.next()) {
                if (!rs.getBoolean("req_deveguia") && !(rs.getDouble("req_totpago") < rs.getDouble("req_total"))) continue;
                devedor = true;
                break;
            }
            if (devedor) {
                String tratamento = "Paciente";
                if (Variaveis.tipoFilialPadrao.equals("A")) {
                    tratamento = "Cliente";
                } else if (Variaveis.tipoFilialPadrao.equals("V")) {
                    tratamento = "Propriet\u00e1rio";
                }
                retorno = tratamento + " com pend\u00eancias, verifique as requisi\u00e7\u00f5es anteriores";
            }
        }
        if (parametro == 1 || parametro == 3) {
            bui.delete(0, bui.length());
            bui.append("select pac_observ from paciente where fil_codigo = ").append(filial);
            bui.append(" and pac_codigo = ").append(codigoPaciente);
            rs = Conexao.executeQuery(st, bui);
            if (rs.next() && !Funcoes.textoVazio(rs.getString("pac_observ"))) {
                retorno = parametro == 3 ? retorno + (Funcoes.textoVazio(retorno) ? "" : " e\n") + (!Funcoes.textoVazio(rs.getString("pac_observ")) ? rs.getString("pac_observ").trim() : "") : (!Funcoes.textoVazio(rs.getString("pac_observ")) ? rs.getString("pac_observ").trim() : "");
            }
        }
        return retorno;
    }

    public static boolean buscaDadosFilial(Component ownerMensagem, TTextField textFilial, JButton buttonFilial) {
        return RecepcaoUtil.buscaDadosFilial(ownerMensagem, textFilial, buttonFilial, true);
    }

    public static boolean buscaDadosFilial(Component ownerMensagem, TTextField textFilial, JButton buttonFilial, boolean desabilitarCampos) {
        boolean retorno = false;
        if (!Funcoes.textoVazio(textFilial.getText())) {
            String descricao = "N\u00e3o cadastrado";
            try {
                descricao = DBUtil.getDescricao("fil_codigo", "fil_descricao", textFilial.getText(), "filiais_postocoleta", true);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(ownerMensagem, ex.getMessage(), ex.getStackTrace(), "RecepcaoUtil (387)");
            }
            if (!descricao.equals("N\u00e3o cadastrado")) {
                retorno = true;
                if (desabilitarCampos) {
                    textFilial.setEnabled(false);
                    buttonFilial.setEnabled(false);
                }
            } else {
                Funcoes.mensagem(ownerMensagem, "Filial n\u00e3o localizada", 1);
                ScreenUtil.requisitarFoco(textFilial);
            }
        } else {
            ScreenUtil.requisitarFoco(textFilial);
        }
        return retorno;
    }

    public static HashMap<String, Object> getHashDadosCabecalho(String filial, String requisicao) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Funcoes.isNumeric(requisicao)) {
            return null;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, ");
        buf.append("\ta.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, ");
        buf.append("\ta.req_dataentregaprev as dataEntregaRequisicao, a.req_dclinicos as dadosClinicosRequisicao, ");
        buf.append("\tcoalesce(a.req_obs, '') as observacaoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, ");
        buf.append("\ta.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao, ");
        buf.append("\ta.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, ");
        buf.append("\ta.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
        buf.append("\ta.req_idade as idadeRequisicao, a.req_anomes as anomesRequisicao, a.req_matricula as matriculaRequisicao, ");
        buf.append("\ta.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequsicao, ");
        buf.append("\ta.req_titular as titularRequisicao, a.req_peso as pesoRequisicao, a.req_altura as alturaRequisicao, ");
        buf.append("\ta.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao, ");
        buf.append("\ta.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, ");
        buf.append("\ta.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.sit_codigo as codigoSituacao, ");
        buf.append("\ta.usr_codigo as codigoUsuario, b.sit_descricao as descricaoSituacao, c.usr_nome as nomeUsuario, ");
        buf.append("\ta.des_codigo as codigoDestino, des.des_descricao as descricaoDestino, ");
        buf.append("\tdes.des_complemento as complementoDestino, des.des_endereco as enderecoDestino, ");
        buf.append("\tdes.des_fone as foneDestino, des.des_cep as cepDestino, ");
        buf.append("\tciddes.cid_codigo as codigoCidadeDestino, ciddes.cid_nome as descricaoCidadeDestino, ciddes.cid_uf as estadoCidadeDestino, ");
        buf.append("\tbaides.bai_codigo as codigoBairroDestino, baides.bai_descricao as descricaoBairroDestino, ");
        buf.append("\ta.col_codigo as codigoColeta, col.col_descricao as descricaoColeta, ");
        buf.append("\tcol.col_complemento as complementoColeta, col.col_endereco as enderecoColeta, ");
        buf.append("\tcol.col_fone as foneColeta, col.col_cep as cepColeta, ");
        buf.append("\tcidcol.cid_codigo as codigoCidadeColeta, cidcol.cid_nome as descricaoCidadecoleta, cidcol.cid_uf as estadoCidadeColeta, ");
        buf.append("\tbaicol.bai_codigo as codigoBairroColeta, baicol.bai_descricao as descricaoBairroColeta, ");
        buf.append("\ta.fil_codigo as codigoFilial, fil.fil_descricao as descricaoFilial, fil.fil_complemento as complementoFilial, ");
        buf.append("\tfil.fil_endereco as enderecoFilial, fil.fil_fone as foneFilial, fil.fil_cep as cepFilial, ");
        buf.append("\tfil.fil_cnpj as cnpjFilial, fil.fil_fax as faxFilial, fil.fil_razaosocial as razaoSocialFilial, ");
        buf.append("\tcidfil.cid_codigo as codigoCidadeFilial, cidfil.cid_nome as descricaoCidadeFilial, cidfil.cid_uf as estadoCidadeFilial, ");
        buf.append("\tbaifil.bai_codigo as codigoBairroFilial, baifil.bai_descricao as descricaoBairroFilial, ");
        buf.append("\tmed.med_conselho as conselhoMedico, med.med_crm as crmMedico, med.med_uf as estadoCrmMedico, ");
        buf.append("\tmed.med_nome as nomeMedico, med.med_abrev as tratamentoMedico, ");
        buf.append("\tmed.med_endereco as enderecoMedico, med.med_complemento as complementoMedico, ");
        buf.append("\tmed.med_numeroendereco as numeroEnderecoMedico, med.med_tipologradouroendereco as tipoLogradouroMedico, ");
        buf.append("\tmed.med_cep as cepMedico, med.med_fone as foneMedico, med.med_celular as celularMedico, ");
        buf.append("\tmed.med_fax as faxMedico, med.med_email as emailMedico, med.med_site as siteMedico, ");
        buf.append("\tcon.con_codigo as codigoConvenio, con.con_fantasia as fantasiaMedico, con.con_fantasia as fantasiaConvenio, ");
        buf.append("\tcon.con_endereco as enderecoConvenio, con.con_razao as razaoSocialConvenio, con.con_complemento as complementoConvenio, ");
        buf.append("\tcon.con_numeroendereco as numeroEnderecoConvenio, con.con_tipologradouroendereco as tipoLogradouroConvenio, ");
        buf.append("\tcon.con_endereco as enderecoConvenio, con.con_cep as cepConvenio, ");
        buf.append("\tcon.con_fone as foneConvenio, con.con_email1 as email1Convenio,  ");
        buf.append("\tcon.con_email2 as email2Convenio, con.con_site as siteConvenio, ");
        buf.append("\tpac.pac_codigo as codigoPaciente, pac.pac_nome as nomePaciente, ");
        buf.append("\tpac.pac_sexo as sexoPaciente, pac.pac_grpsangue as grupoSanguineoPaciente, ");
        buf.append("\tpac.pac_fatorrh as fatorrhPaciente, pac.pac_fatordu as fatorduPaciente, ");
        buf.append("\tpac.pac_datanasc as dataNascimentoPaciente, pac.pac_dum as dumPaciente, ");
        buf.append("\tpac.pac_cor as corPaciente, pac.pac_profissao as profissaoPaciente,  ");
        buf.append("\tpac.pac_rg as rgPaciente, pac.pac_cpf as cpfPaciente, ");
        buf.append("\tpac.pac_estcivil as estadoCivilPaciente, pac.pac_fone as fonePaciente, ");
        buf.append("\tpac.pac_celular as celularPaciente, pac.pac_fax as faxPaciente, ");
        buf.append("\tpac.pac_complemento as complementoPaciente, pac.pac_endereco as enderecoPaciente, ");
        buf.append("\tpac.pac_numeroendereco as numeroEnderecoPaciente, pac.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
        buf.append("\tpac.pac_fonecomercial as foneComercialPaciente, ");
        buf.append("\tpac.pac_email as emailPaciente, pac.pac_fonecontato as foneContatoPaciente, ");
        buf.append("\tpac.pac_nomecontato as nomeContatoPaciente, pac.cid_codigo as codigoCidadePaciente,  ");
        buf.append("\tpac.bai_codigo as codigoBairroPaciente, cidpac.cid_nome as descricaoCidadePaciente, ");
        buf.append("\tcidpac.cid_uf as estadoCidadePaciente, ");
        buf.append("\tbaipac.bai_descricao as descricaoBairroPaciente, pac.pac_cep as cepPaciente, a.req_perguntas as perguntasRequisicao, ");
        buf.append("\ta.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.ala_codigo as codigoAlaHospital, ala.ala_descricao as descricaoAlaHospital, ");
        buf.append("a.uns_codigo as codigoUnidadeSaude, ");
        buf.append("saude.uns_descricao as descricaoUnidadeSaude, ");
        buf.append("pac.ent_codempresa as codigoEmpresaPaciente, ");
        buf.append("empresa.ent_fantasia as fantasiaEmpresaPaciente, ");
        buf.append(" a.req_prontuario as prontuarioRequisicao ");
        String tipoFilial = RecepcaoUtil.getTipoFilial(st, filial);
        if (tipoFilial.equals("A")) {
            buf.append(", a.req_descricaoproduto as descricaoProdutoRequisicao, ");
            buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
            buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
            buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
            buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
            buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
            buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
            buf.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
            buf.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
            buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
            buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
            buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
            buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
            buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
            buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
            buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
            buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
            buf.append("a.req_programa as programaRequisicao, ");
            buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
            buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
            buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
            buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
            buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
            buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
            buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
            buf.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
            buf.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
            buf.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
            buf.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
            buf.append("a.req_areaproduto as areaProdutoRequisicao, ");
            buf.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
            buf.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
            buf.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
            buf.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao ");
        } else if (tipoFilial.equals("V")) {
            buf.append(", pac.pac_proprietario as proprietarioPaciente ");
            buf.append(", rac.rac_descricao as descricaoRaca ");
            buf.append(", epe.epc_descricao as descricaoEspecie ");
        }
        buf.append("from requisicao a ");
        buf.append("left join situacao b on a.fil_codigo = b.fil_codigo and a.sit_codigo = b.sit_codigo ");
        buf.append("left join usuario c on a.usr_codigo = c.usr_codigo ");
        buf.append("left join destino des on a.fil_codigo = des.fil_codigo and a.des_codigo = des.des_codigo ");
        buf.append("left join cidades ciddes on des.fil_codigo = ciddes.fil_codigo and des.cid_codigo = ciddes.cid_codigo ");
        buf.append("left join bairro baides on des.fil_codigo = baides.fil_codigo and des.bai_codigo = baides.bai_codigo ");
        buf.append("left join coletas col on a.fil_codigo = col.fil_codigo and a.col_codigo = col.col_codigo ");
        buf.append("left join cidades cidcol on col.fil_codigo = cidcol.fil_codigo and col.cid_codigo = cidcol.cid_codigo ");
        buf.append("left join bairro baicol on col.fil_codigo = baicol.fil_codigo and col.bai_codigo = baicol.bai_codigo ");
        buf.append("left join filiais_postocoleta fil on a.fil_codigo = fil.fil_codigo and a.fil_codigo = fil.fil_codigo ");
        buf.append("left join cidades cidfil on fil.fil_codigo = cidfil.fil_codigo and fil.cid_codigo = cidfil.cid_codigo ");
        buf.append("left join bairro baifil on fil.fil_codigo = baifil.fil_codigo and fil.bai_codigo = baifil.bai_codigo ");
        buf.append("left join medico med on a.fil_codigo = med.fil_codigo and a.med_conselho = med.med_conselho and a.med_crm = med.med_crm and a.med_uf = med.med_uf ");
        buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
        buf.append("left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
        buf.append("left join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
        buf.append("left join bairro baipac on pac.fil_codigo = baipac.fil_codigo and pac.bai_codigo = baipac.bai_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and upper(a.ala_codigo) = upper(ala.ala_codigo) ");
        buf.append("left join unidadesaude saude on a.fil_codigo = saude.fil_codigo and a.uns_codigo = saude.uns_codigo ");
        buf.append("left join entidade empresa on pac.fil_codigo = empresa.fil_codigo and pac.ent_codempresa = empresa.ent_codigo ");
        if (tipoFilial.equals("A")) {
            buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        }
        if (tipoFilial.equals("V")) {
            buf.append("left join raca rac on pac.fil_codigo = rac.fil_codigo and pac.epc_codigo = rac.epc_codigo and pac.rac_codigo = rac.rac_codigo ");
            buf.append("left join especie epe on pac.fil_codigo = epe.fil_codigo and pac.epc_codigo = epe.epc_codigo ");
        }
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true)) ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                String fieldName = rs.getMetaData().getColumnName(i);
                if (fieldName.equalsIgnoreCase("tipoLogradouroPaciente") || fieldName.equalsIgnoreCase("tipoLogradouroMedico") || fieldName.equalsIgnoreCase("tipoLogradouroConvenio")) {
                    map.put(fieldName, Tipos.tipoLogradouroDescricao(rs.getString(fieldName)));
                    continue;
                }
                if (fieldName.equals("sexoPaciente")) {
                    map.put(fieldName, Tipos.tipoSexo(rs.getString("sexoPaciente")));
                    continue;
                }
                if (fieldName.equals("corPaciente")) {
                    map.put(fieldName, Tipos.tipoCor(rs.getString("corPaciente")));
                    continue;
                }
                if (fieldName.equals("estadoCivilPaciente")) {
                    map.put(fieldName, Tipos.tipoEstadoCivil(rs.getString("estadoCivilPaciente")));
                    continue;
                }
                if (fieldName.equalsIgnoreCase("observacaoRequisicao")) {
                    map.put(fieldName, rs.getString("observacaoRequisicao").replaceAll("\"", "&quot;"));
                    continue;
                }
                if (fieldName.equalsIgnoreCase("perguntasRequisicao")) {
                    Map<String, Object> p;
                    String perguntas = rs.getString("perguntasRequisicao");
                    if (Funcoes.textoVazio(perguntas) || (p = RecepcaoUtil.convertePerguntasParaHash(perguntas)) == null) continue;
                    map.putAll(p);
                    continue;
                }
                map.put(fieldName, rs.getObject(fieldName));
            }
        }
        return map.isEmpty() ? null : map;
    }

    private static Map<String, Object> convertePerguntasParaHash(String perguntas) {
        Map<String, Object> retorno = Resultado.getCamposResultado(perguntas);
        return retorno;
    }

    public static String mapToStringPHP(Map<String, Object> map) {
        StringBuilder buf = new StringBuilder();
        if (map != null) {
            for (String s : map.keySet()) {
                Object o = map.get(s);
                buf.append("$").append(StringUtil.limpaString(s, new String[]{"/", " "})).append("=\"");
                if (o == null) {
                    buf.append("");
                } else {
                    buf.append(o.toString());
                }
                buf.append("\";");
            }
        }
        return buf.toString();
    }

    public static String getMensagemPendenciaColetaPaciente(Statement st, String filial, String codigoPaciente, String requisicaoAtual) throws SQLException {
        String retorno = "";
        if (!ParametrosGerais.getPendenciaColeta()) {
            return "";
        }
        StringBuilder bui = new StringBuilder("select count(a.exa_codigo) as contagem from examerequisicao a ");
        bui.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and (a.exr_situacao = '").append("F").append("' or ");
        bui.append(" a.exr_situacao = '").append("R").append("') ");
        bui.append(" and b.pac_codigo = ").append(codigoPaciente);
        bui.append(" and a.exr_excluido = false and b.req_excluida = false ");
        if (!Funcoes.textoVazio(requisicaoAtual)) {
            bui.append(" and a.req_codigo <> ").append(requisicaoAtual);
        }
        ResultSet rs = Conexao.executeQuery(st, bui);
        boolean devedor = false;
        if (rs.next() && rs.getInt("contagem") > 0) {
            String ad = rs.getInt("contagem") > 1 ? "s" : "";
            retorno = "O paciente tem " + rs.getInt("contagem") + " exame" + ad + " n\u00e3o coletado" + ad + " ,\nverifique os exames das requisi\u00e7\u00f5es anteriores";
        }
        return retorno;
    }

    public static boolean requisicaoTemExamesDigitados(Statement st, String filial, String codigoRequisicao) throws SQLException {
        boolean retorno = false;
        StringBuilder bui = new StringBuilder("select exa_codigo from examerequisicao ");
        bui.append("where fil_codigo = ").append(filial);
        bui.append(" and req_codigo = ").append(codigoRequisicao);
        bui.append(" and exr_datadigita is not null");
        bui.append(" and exr_excluido = false ");
        ResultSet rs = Conexao.executeQuery(st, bui);
        retorno = rs.next();
        return retorno;
    }

    public static String[] geraCabecalhoRequisicaoParaWeb(Statement st, Statement st2, String filial, String codigoRequisicao, String codigoBaseWeb) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select a.req_data, a.req_hora, destino.des_descricao, coletas.col_descricao, a.con_codigo, a.pac_codigo, ");
        buf.append("a.req_idade, a.req_anomes, b.pac_datanasc, a.req_senhaweb, a.med_conselho, a.med_crm, a.med_uf ");
        buf.append("from requisicao a ");
        buf.append("left join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        buf.append("left join coletas on a.fil_codigo = coletas.fil_codigo and a.col_codigo = coletas.col_codigo ");
        buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo = ").append(codigoRequisicao);
        buf.append(" and a.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            String[] comandoRequisicao = new String[34];
            comandoRequisicao[0] = "codigoBase";
            comandoRequisicao[1] = codigoBaseWeb;
            comandoRequisicao[2] = "codigoRequisicao";
            comandoRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(filial, codigoRequisicao, st2);
            comandoRequisicao[4] = "dataRequisicao";
            comandoRequisicao[5] = Funcoes.formataData(rs.getDate("req_data"));
            comandoRequisicao[6] = "horaRequisicao";
            comandoRequisicao[7] = rs.getString("req_hora").length() > 4 ? rs.getString("req_hora").substring(0, 5) : rs.getString("req_hora");
            comandoRequisicao[8] = "destinoRequisicao";
            comandoRequisicao[9] = rs.getString("des_descricao");
            comandoRequisicao[10] = "coletaRequisicao";
            comandoRequisicao[11] = rs.getString("col_descricao");
            comandoRequisicao[12] = "codigoConvenioRequisicao";
            comandoRequisicao[13] = rs.getString("con_codigo");
            comandoRequisicao[14] = "idadeRequisicao";
            comandoRequisicao[15] = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
            comandoRequisicao[16] = "dataNascimentoRequisicao";
            comandoRequisicao[17] = DBUtil.campoNull("pac_datanasc") ? "" : Funcoes.formataData(rs.getDate("pac_datanasc"));
            comandoRequisicao[18] = "senhaRequisicao";
            comandoRequisicao[19] = rs.getString("req_senhaweb");
            comandoRequisicao[20] = "conselhoMedicoRequisicao";
            comandoRequisicao[21] = rs.getString("med_conselho");
            comandoRequisicao[22] = "crmMedicoRequisicao";
            comandoRequisicao[23] = rs.getString("med_crm");
            comandoRequisicao[24] = "ufMedicoRequisicao";
            comandoRequisicao[25] = rs.getString("med_uf");
            comandoRequisicao[26] = "codigoPacienteRequisicao";
            comandoRequisicao[27] = rs.getString("pac_codigo");
            comandoRequisicao[28] = "valorPagoRequisicao";
            buf.delete(0, buf.length());
            buf.append("select a.req_total, a.req_totpago, b.des_enviarweb from requisicao a ");
            buf.append("left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(codigoRequisicao);
            ResultSet rsValorPago = Conexao.executeQuery(st, buf.toString());
            double valorPago = 0.0;
            double valorTotal = 0.0;
            boolean enviarDestino = true;
            if (rsValorPago.next()) {
                valorTotal = rsValorPago.getDouble("req_total");
                valorPago = DBUtil.campoNull(rsValorPago.getString("req_totpago")) ? 0.0 : rsValorPago.getDouble("req_totpago");
                enviarDestino = rsValorPago.getBoolean("des_enviarweb");
            }
            comandoRequisicao[29] = Funcoes.limpaDecimal(String.valueOf(valorPago));
            comandoRequisicao[30] = "valorRequisicao";
            comandoRequisicao[31] = Funcoes.limpaDecimal(String.valueOf(valorTotal));
            comandoRequisicao[32] = "dadosCabecalhoRequisicao";
            HashMap<String, Object> cabec = RecepcaoUtil.getHashDadosCabecalho(filial, codigoRequisicao);
            comandoRequisicao[33] = RecepcaoUtil.mapToStringPHP(cabec);
            return enviarDestino ? comandoRequisicao : null;
        }
        return null;
    }

    public static boolean requisicaoTemExamesNoInterfaceamento(Statement st, String filial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws SQLException {
        boolean retorno = false;
        StringBuilder bui = new StringBuilder("select a.exa_codigo from interfaceexamerequisicao a ");
        bui.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append(" and a.req_codigo = ").append(codigoRequisicao);
        bui.append(" and a.ier_situacao < ").append(8);
        bui.append(" and b.exr_excluido = false ");
        ResultSet rs = Conexao.executeQuery(st, bui);
        retorno = rs.next();
        return retorno;
    }

    public static String getTipoFilial(Statement st, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder("select fil_tipobase from filiais_postocoleta where fil_codigo = ");
        buf.append(filial);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getString("fil_tipobase");
        }
        return "C";
    }

    public static boolean podeExcluirRequisicao(Component owner, Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder bufWhere = new StringBuilder();
        bufWhere.append("where fil_codigo = ").append(filial);
        bufWhere.append(" and req_codigo = ").append(requisicao);
        StringBuilder bufWhereExterno = new StringBuilder();
        bufWhereExterno.append("where fil_kodigo = ").append(filial);
        bufWhereExterno.append(" and req_codigo = ").append(requisicao);
        String sql = "select req_codigo from ";
        Statement st2 = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql + " requisicaolabexterno " + bufWhere.toString());
        if (rs.next()) {
            if (!UtilExportadores.podeExcluirRequisicaoLoteExternoAlvaro(requisicao, filial, st, st2, ParametrosGerais.isAgruparGuiasInterface())) {
                Funcoes.mensagem(owner, "A requisi\u00e7\u00e3o n\u00e3o pode ser excluida pois faz parte de um laborat\u00f3rio externo", 1);
                return false;
            }
            return true;
        }
        rs = Conexao.executeQuery(st, sql + " loteexternorequisicao " + bufWhereExterno.toString());
        if (rs.next()) {
            if (!UtilExportadores.podeExcluirRequisicaoLoteExternoAlvaro(requisicao, filial, st, st2, ParametrosGerais.isAgruparGuiasInterface())) {
                Funcoes.mensagem(owner, "A requisi\u00e7\u00e3o n\u00e3o pode ser excluida pois foi enviada para um laborat\u00f3rio de apoio", 1);
                return false;
            }
            return true;
        }
        Conexao.fecharStatement(st2);
        bufWhere.setLength(0);
        bufWhere.append("select a.fat_codigo from faturarequisicao a left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        bufWhere.append("where a.fil_kodigo = ").append(filial);
        bufWhere.append(" and a.req_codigo = ").append(requisicao);
        bufWhere.append(" and b.fat_datacancelamento is null ");
        rs = Conexao.executeQuery(st, bufWhere.toString());
        if (rs.next()) {
            Funcoes.mensagem(owner, "A requisi\u00e7\u00e3o n\u00e3o pode ser excluida pois faz parte de um faturamento", 1);
            return false;
        }
        return true;
    }

    public static boolean podeExcluirExameRequisicao(Component owner, Statement st, String filial, String requisicao, String exame, String codigoMaterial) throws SQLException {
        StringBuilder bufWhere = new StringBuilder();
        bufWhere.append("where fil_codigo = ").append(filial);
        bufWhere.append(" and req_codigo = ").append(requisicao);
        bufWhere.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        bufWhere.append(" and mco_codigo = ").append(codigoMaterial);
        String sql = "select exa_codigo from ";
        ResultSet rs = Conexao.executeQuery(st, sql + " loteexternoexamerequisicao " + bufWhere.toString());
        if (rs.next()) {
            Funcoes.mensagem(owner, "O exame n\u00e3o pode ser excluido pois foi enviado para um laborat\u00f3rio de apoio", 1);
            return false;
        }
        bufWhere.setLength(0);
        bufWhere.append("select a.fat_codigo from faturaexamerequisicao a left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        bufWhere.append("where a.fil_kodigo = ").append(filial);
        bufWhere.append(" and a.req_codigo = ").append(requisicao);
        bufWhere.append(" and b.fat_datacancelamento is not null ");
        bufWhere.append(" and a.exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        bufWhere.append(" and a.mco_codigo = ").append(codigoMaterial);
        rs = Conexao.executeQuery(st, bufWhere.toString());
        if (rs.next()) {
            Funcoes.mensagem(owner, "A requisi\u00e7\u00e3o n\u00e3o pode ser excluida pois faz parte de um faturamento", 1);
            return false;
        }
        return true;
    }

    public static String limpaMascaraMatricula(String mascara) {
        StringBuilder tmp = new StringBuilder("");
        for (int i = 0; i < mascara.length(); ++i) {
            if (!mascara.substring(i, i + 1).matches("[a-zA-Z|0-9]")) continue;
            tmp.append(mascara.substring(i, i + 1));
        }
        return tmp.toString();
    }

    public static String getExameImpresso(String codFilial, String codRequisicao) {
        try {
            ResultSet rs = null;
            Statement st = null;
            HashSet<String> exames = new HashSet<String>();
            StringBuilder sql = new StringBuilder();
            sql.append(" select exa_codigo from examerequisicao where fil_codigo = ");
            sql.append(codFilial);
            sql.append(" and req_codigo = ");
            sql.append(codRequisicao);
            sql.append(" and exr_dataimpresso is not null");
            st = Conexao.getStatement();
            rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                exames.add(rs.getString("exa_codigo"));
            }
            st.close();
            rs.close();
            if (exames.isEmpty()) {
                return "";
            }
            return Arrays.toString(exames.toArray());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getLocalizedMessage(), e.getStackTrace());
            return "";
        }
    }

    public static Integer getQtdeExamesSituacao(String filial, String requisicao, String ... situacoes) throws SQLException {
        return RecepcaoUtil.getQtdeExamesSituacao(Conexao.getStatement(), filial, requisicao, situacoes);
    }

    public static Integer getQtdeExamesSituacao(Statement st, String filial, String requisicao, String ... situacoes) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append("select count(req_codigo) as qtde ");
        buf.append("  from examerequisicao ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo in (").append(requisicao).append(")");
        buf.append("   and exr_excluido is false ");
        buf.append("   and exr_situacao in ('").append(StringUtil.implode(situacoes, "','")).append("')");
        ResultSet result = st.executeQuery(buf.toString());
        int retorno = 0;
        if (result.next() && result.getInt("qtde") > 0) {
            retorno = result.getInt("qtde");
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getQtdeExamesSituacaoMultiguia(String filial, String requisicao, String ... situacoes) throws SQLException {
        Statement st;
        block2: {
            Integer n;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.setLength(0);
            buf.append("select count(a.req_codigo) as qtde ");
            buf.append("  from examerequisicao a ");
            buf.append(" left join requisicaorequisicao d on a.req_codigo = d.req_codigo and a.fil_codigo = d.fil_codigo");
            buf.append(" where a.fil_codigo = ").append(filial);
            buf.append("   and d.req_codigo = ").append(requisicao);
            buf.append("   and a.exr_excluido is false ");
            buf.append("   and a.exr_situacao in ('").append(StringUtil.implode(situacoes, "','")).append("')");
            try {
                ResultSet rs = st.executeQuery(buf.toString());
                if (!rs.next() || rs.getInt("qtde") <= 0) break block2;
                n = rs.getInt("qtde");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return n;
        }
        Conexao.fecharStatement(st);
        return 0;
    }

    public static boolean getTodosExamesConferidos(Statement st, String filial, String codigoRequisicao) throws Exception {
        if (st == null) {
            throw new Exception("N\u00e3o foi possivel verificar se todos os exames da requisi\u00e7\u00e3o est\u00e3o conferidos. Statement = NULL.");
        }
        StringBuilder bui = new StringBuilder();
        bui.append(" select SUM(CASE WHEN exr_situacao IN ('").append("C").append("', '").append("I").append("', '").append("A").append("', '").append("E").append("') THEN 1 ELSE 0 END) = COUNT(*) as todosConferidos ");
        bui.append("   from examerequisicao ");
        bui.append("  where fil_codigo = ").append(filial);
        bui.append("    and req_codigo = ").append(codigoRequisicao);
        bui.append("    and not exr_excluido ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            return rs.getBoolean("todosConferidos");
        }
        return false;
    }

    public static String[] getPerguntasFilial(String filial) {
        return RecepcaoUtil.getPerguntasFilial(filial, Conexao.getStatement());
    }

    public static String[] getPerguntasFilial(String filial, Statement st) {
        String[] camposPergunta = new String[]{};
        try {
            String xmlPerguntas;
            StringBuilder buf = new StringBuilder("select fil_perguntas from filiais_postocoleta ");
            buf.append(" where fil_codigo = ").append(filial);
            ResultSet rs = st.executeQuery(buf.toString());
            String string = xmlPerguntas = rs.next() ? rs.getString("fil_perguntas") : "";
            if (!Funcoes.textoVazio(xmlPerguntas)) {
                camposPergunta = DialogoConfigurador.getCamposResultado(xmlPerguntas);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi possivel interpretar as perguntas da filial", ex.getStackTrace());
        }
        return camposPergunta;
    }

    public static String getTagValue(String xml, String tagName) {
        if (Funcoes.textoVazio(xml)) {
            return null;
        }
        return xml.split("<" + tagName + ">")[1].split("</" + tagName + ">")[0];
    }

    public static String removeTag(String xml, String tag) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, "");
        return sb.toString();
    }

    public static String addValorTag(String xml, String tag, String valor) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, valor);
        return sb.toString();
    }
}

