/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.MapaResolverExpressoesUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PushUtil {
    public static final int PUSH_ENVIADO = 0;
    public static final int PUSH_BLOQUEADO_PACIENTE = 1;
    public static final int PUSH_JA_ENVIADO = 2;
    public static final int PUSH_FILIAL_NAO_PERMITE = 3;
    private static final int TIPO_BLOQUEIO_PUSH_CONVENIO_ANIVERSARIO = 0;
    private static final int TIPO_BLOQUEIO_PUSH_CONVENIO_RECOLETA = 1;
    private static final int TIPO_BLOQUEIO_PUSH_CONVENIO_RESULTADO = 2;
    private static PreparedStatement prstInsereLog = null;
    private static PreparedStatement prstDadosPush = null;
    private static PreparedStatement prstDadosPaciente = null;
    private static PreparedStatement prstMultiguiasEnviaramPush = null;
    private static PreparedStatement prstQuantidadeExamesMultiguias = null;
    private static PreparedStatement prstQuantidadeExamesProntosMultiguias = null;
    private static PreparedStatement prstBloqueiosEnvioOPushConvenio = null;
    private static String sqlInsereLog = null;
    private static String sqlDadosPush = null;
    private static String sqlDadosPaciente = null;
    private static String sqlMultiguiasEnviaramPush = null;
    private static String sqlQuantidadeExamesMultiguias = null;
    private static String sqlBloqueiosEnvioPushConvenio = null;
    public static String requisicaoCodigo = null;
    public static String pacienteCodigo = null;

    public static boolean enviarPush(Component componentePai, String codigoFilial, String token, String titulo, String mensagem, TipoPush tipoPush, Statement st, String codigoRequisicao, String codigoPaciente, String tipoIntegracao) throws NumberFormatException, SQLException {
        requisicaoCodigo = codigoRequisicao;
        pacienteCodigo = codigoPaciente;
        String tipoPushFilial = tipoIntegracao;
        if (!Funcoes.textoVazio(token)) {
            mensagem = StringUtil.textoDB(mensagem);
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into logpushapp ");
            buf.append("  (fil_codigo, lpa_codigo, lpa_datahora, lpa_situacao, lpa_token, lpa_mensagem, lpa_titulo, lpa_origem, req_codigo, pac_codigo, lpa_filial) values (");
            buf.append(Integer.parseInt(codigoFilial));
            buf.append(", ").append("nextval('logpushapp_").append(Integer.parseInt(codigoFilial)).append("_sequence')");
            buf.append(", current_timestamp");
            buf.append(", '").append("E").append("'");
            buf.append(", ").append(StringUtil.textoDBEscape(token));
            buf.append(", ").append(StringUtil.textoDBEscape(mensagem));
            buf.append(", ").append(StringUtil.textoDBEscape(titulo));
            buf.append(", ").append(StringUtil.textoDBEscape(tipoPush.getCodigo()));
            buf.append(", ").append(Integer.parseInt(codigoRequisicao));
            buf.append(", ").append(Integer.parseInt(codigoPaciente));
            buf.append(", '").append(tipoPushFilial).append("'");
            buf.append(")");
            sqlInsereLog = buf.toString();
            prstInsereLog = PushUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
            prstInsereLog.executeUpdate();
            if (tipoPushFilial.equals("F") || tipoPushFilial.equals("W")) {
                IntegracaoUtil.insereComandoLog(st, codigoFilial, codigoFilial, buf.toString());
            }
            return true;
        }
        return false;
    }

    public static boolean criaLogPushComDadosRequisicao(String codigoFilial, String codigoRequisicao, TipoPush tipoPush, Statement st, Statement st2) throws Exception {
        return PushUtil.criaLogPushComDadosRequisicao(codigoFilial, codigoRequisicao, tipoPush, st, st2, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getTipoIntegracao());
    }

    public static boolean criaLogPushComDadosRequisicao(String codigoFilial, String codigoRequisicao, TipoPush tipoPush, Statement st, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, String tipoIntegracao) throws Exception {
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoRequisicao)) {
            throw new Exception("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o informado.");
        }
        if (tipoPush == null) {
            throw new Exception("Tipo do Push n\u00e3o informado.");
        }
        prstDadosPush = PushUtil.getPreparedStatement(st.getConnection(), sqlDadosPush);
        prstDadosPush.setInt(1, Integer.parseInt(codigoFilial));
        prstDadosPush.setInt(2, Integer.parseInt(codigoRequisicao));
        ResultSet rs = prstDadosPush.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarPush")) {
            return false;
        }
        String push = null;
        String titulo = null;
        if (tipoPush.equals((Object)TipoPush.ANIVERSARIO)) {
            if (!PushUtil.podeEnviarPushAniversario(rs, st)) {
                return false;
            }
            push = rs.getString("pushAniversario");
            titulo = rs.getString("tituloAniversario");
        } else if (tipoPush.equals((Object)TipoPush.RECOLETA)) {
            if (!PushUtil.podeEnviarPushRecoleta(rs, st)) {
                return false;
            }
            push = rs.getString("pushRecoleta");
            titulo = rs.getString("tituloRecoleta");
        } else if (tipoPush.equals((Object)TipoPush.RESULTADO)) {
            if (!PushUtil.podeEnviarPushResultado(rs, st)) {
                return false;
            }
            if (rs.getBoolean("pushResultadoEnviado")) {
                return false;
            }
            push = rs.getString("pushResultado");
            titulo = rs.getString("tituloResultado");
        } else if (tipoPush.equals((Object)TipoPush.REQUISICAO)) {
            if (!PushUtil.podeEnviarPushRequisicao(rs)) {
                return false;
            }
            push = rs.getString("pushRequisicao");
            titulo = rs.getString("tituloRequisicao");
        } else if (tipoPush.equals((Object)TipoPush.AGENDAMENTO)) {
            if (!PushUtil.podeenviarPushAgendamento(rs)) {
                return false;
            }
            push = rs.getString("pushAgendamento");
            titulo = rs.getString("tituloAgendamento");
        }
        if (Funcoes.textoVazio(push)) {
            return false;
        }
        String token = rs.getString("tokenPaciente");
        String codigoPaciente = rs.getString("codigoPaciente");
        if (!Funcoes.textoVazio(push) && !PushUtil.isTokenVazio(token)) {
            HashMap<String, Object> hash = PushUtil.getHashMapCampos(codigoFilial, rs, st2, digitosTuboFilial, digitosTuboRequisicao);
            boolean enviado = PushUtil.enviarPush(null, codigoFilial, token, PushUtil.parseFrasePush(titulo, hash), PushUtil.parseFrasePush(push, hash), tipoPush, st, codigoRequisicao, codigoPaciente, tipoIntegracao);
            if (enviado) {
                if (tipoPush.equals((Object)TipoPush.RESULTADO)) {
                    PushUtil.atualizarRequisicaoPushResultadoEnviado(st, codigoFilial, codigoRequisicao);
                }
                st.getConnection().commit();
                return true;
            }
            st.getConnection().rollback();
            return false;
        }
        return false;
    }

    private static void atualizarRequisicaoPushResultadoEnviado(Statement st, String codigoFilial, String requisicao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append("    set req_pushresultadoenviado = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and req_codigo = ").append(requisicao);
        st.executeUpdate(buf.toString());
    }

    private static boolean podeReenviarPushResultado(ResultSet rs, Statement st) throws Exception {
        boolean podeEnviarPushPaciente = PushUtil.podeEnviarPushPaciente(rs);
        boolean podeEnviaSmsConvenio = PushUtil.podeEnviarPushConvenio(rs, st, 2);
        return podeEnviarPushPaciente && podeEnviaSmsConvenio;
    }

    private static boolean validarResultSet(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return false;
        }
        return rs.getBoolean("enviarPush");
    }

    private static void prepararStatement(String filial, String requisicao, String paciente, Statement st) throws SQLException {
        boolean requisicaoVazia = Funcoes.textoVazio(requisicao);
        if (requisicaoVazia) {
            PushUtil.preparaStatementeDadosPaciente(filial, paciente, st);
        } else {
            PushUtil.preparaStatelemteDadoSms(filial, requisicao, st);
        }
    }

    private static void preparaStatementeDadosPaciente(String filial, String paciente, Statement st) throws SQLException {
        String sql = sqlDadosPaciente;
        prstDadosPaciente = PushUtil.getPreparedStatement(st.getConnection(), sql);
        prstDadosPaciente.setInt(1, Integer.parseInt(filial));
        prstDadosPaciente.setInt(2, Integer.parseInt(paciente));
    }

    private static void preparaStatelemteDadoSms(String filial, String requisicao, Statement st) throws SQLException {
        String sql = sqlDadosPush;
        prstDadosPaciente = PushUtil.getPreparedStatement(st.getConnection(), sql);
        prstDadosPaciente.setInt(1, Integer.parseInt(filial));
        prstDadosPaciente.setInt(2, Integer.parseInt(requisicao));
    }

    private static void validarPaciente(String paciente) throws Exception {
        if (Funcoes.textoVazio(paciente)) {
            throw new Exception("C\u00f3digo do paciente n\u00e3o informado.");
        }
    }

    private static void validarFilial(String filial) throws Exception {
        if (Funcoes.textoVazio(filial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
    }

    public static boolean criaLogSmsSemDadosRequisicao(String codigoFilial, String codigoPaciente, TipoPush tipoPush, Statement st, Statement st2) throws Exception {
        return PushUtil.criaLogSmsSemDadosRequisicao(codigoFilial, codigoPaciente, tipoPush, st, st2, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getTipoIntegracao());
    }

    public static boolean criaLogSmsSemDadosRequisicao(String codigoFilial, String codigoPaciente, TipoPush tipoPush, Statement st, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, String tipoIntegracao) throws Exception {
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoPaciente)) {
            throw new Exception("C\u00f3digo do paciente n\u00e3o informado.");
        }
        prstDadosPaciente = PushUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
        prstDadosPaciente.setInt(1, Integer.parseInt(codigoFilial));
        prstDadosPaciente.setInt(2, Integer.parseInt(codigoPaciente));
        ResultSet rs = prstDadosPaciente.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarPush")) {
            return false;
        }
        String push = null;
        String titulo = null;
        if (tipoPush.equals((Object)TipoPush.ANIVERSARIO)) {
            if (!PushUtil.podeEnviarPushAniversario(rs, st)) {
                return false;
            }
            push = rs.getString("pushAniversario");
            titulo = rs.getString("tituloAniversario");
        } else if (tipoPush.equals((Object)TipoPush.RECOLETA)) {
            if (!PushUtil.podeEnviarPushRecoleta(rs, st)) {
                return false;
            }
            push = rs.getString("pushRecoleta");
            titulo = rs.getString("tituloRecoleta");
        } else if (tipoPush.equals((Object)TipoPush.RESULTADO)) {
            if (!PushUtil.podeEnviarPushResultado(rs, st)) {
                return false;
            }
            push = rs.getString("pushResultado");
            titulo = rs.getString("tituloResultado");
        } else if (tipoPush.equals((Object)TipoPush.REQUISICAO)) {
            if (!PushUtil.podeEnviarPushRequisicao(rs)) {
                return false;
            }
            push = rs.getString("pushRequisicao");
            titulo = rs.getString("tituloRequisicao");
        }
        if (Funcoes.textoVazio(push)) {
            return false;
        }
        String token = rs.getString("tokenPaciente");
        String codigoRequisicao = null;
        if (!Funcoes.textoVazio(push) && !PushUtil.isTokenVazio(token)) {
            HashMap<String, Object> hash = PushUtil.getHashMapCampos(codigoFilial, rs, st2, digitosTuboFilial, digitosTuboRequisicao);
            boolean enviado = PushUtil.enviarPush(null, codigoFilial, token, PushUtil.parseFrasePush(titulo, hash), PushUtil.parseFrasePush(push, hash), tipoPush, st, codigoRequisicao, codigoPaciente, tipoIntegracao);
            if (enviado) {
                st.getConnection().commit();
                return true;
            }
            st.getConnection().rollback();
            return false;
        }
        return false;
    }

    private static boolean podeEnviarPushRequisicao(ResultSet rs) throws Exception {
        return PushUtil.podeEnviarPushPaciente(rs) && rs.getBoolean("enviarPushRequisicao") && !Funcoes.textoVazio(rs.getString("pushRequisicao"));
    }

    private static boolean podeenviarPushAgendamento(ResultSet rs) throws Exception {
        return PushUtil.podeEnviarPushPaciente(rs) && rs.getBoolean("enviarPushAgendamento") && !Funcoes.textoVazio(rs.getString("pushAgendamento"));
    }

    private static boolean podeEnviarPushSenhaWeb(ResultSet rs) throws Exception {
        return PushUtil.podeEnviarPushPaciente(rs) && rs.getBoolean("enviarPushSenhaWeb") && !Funcoes.textoVazio(rs.getString("pushSenhaWeb"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean podeEnviarPushResultado(ResultSet rs, Statement st) throws Exception {
        boolean podeEnviarPushPaciente = PushUtil.podeEnviarPushPaciente(rs);
        if (!podeEnviarPushPaciente) {
            return false;
        }
        if (!PushUtil.filialPermiteEnviarSeparado(rs.getInt("codigofilial"), rs.getInt("codigorequisicao"), st) || ResultadosUtil.notificacaoJaEnviada(rs.getInt("codigofilial"), rs.getInt("codigorequisicao"), st, "fil_agrupamultiguiapushapp", "req_pushresultadoenviado")) {
            return false;
        }
        boolean podeEnviaPushConvenio = PushUtil.podeEnviarPushConvenio(rs, st, 2);
        if (!podeEnviaPushConvenio) {
            return false;
        }
        prstMultiguiasEnviaramPush = PushUtil.getPreparedStatement(st.getConnection(), sqlMultiguiasEnviaramPush);
        prstQuantidadeExamesMultiguias = PushUtil.getPreparedStatement(st.getConnection(), sqlQuantidadeExamesMultiguias);
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(*) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        buf.append("    and not exr_excluido ");
        buf.append("    and exr_situacao in (?, ?, ?");
        if (!ParametrosGerais.getConferencia()) {
            buf.append(", ?");
        }
        buf.append(")");
        String sqlQuantidadeExamesProntosMultiguias = buf.toString();
        prstQuantidadeExamesProntosMultiguias = PushUtil.getPreparedStatement(st.getConnection(), sqlQuantidadeExamesProntosMultiguias);
        prstMultiguiasEnviaramPush.setInt(1, rs.getInt("codigofilial"));
        prstMultiguiasEnviaramPush.setInt(2, rs.getInt("codigorequisicao"));
        try (ResultSet rsMultiguiasEnviaramSms = null;){
            rsMultiguiasEnviaramSms = prstMultiguiasEnviaramPush.executeQuery();
            if (rsMultiguiasEnviaramSms.next() && rsMultiguiasEnviaramSms.getBoolean("pushEnviado")) {
                boolean bl = false;
                return bl;
            }
        }
        prstQuantidadeExamesMultiguias.setInt(1, rs.getInt("codigofilial"));
        prstQuantidadeExamesMultiguias.setInt(2, rs.getInt("codigorequisicao"));
        prstQuantidadeExamesMultiguias.setString(3, "A");
        prstQuantidadeExamesProntosMultiguias.setInt(1, rs.getInt("codigofilial"));
        prstQuantidadeExamesProntosMultiguias.setInt(2, rs.getInt("codigorequisicao"));
        prstQuantidadeExamesProntosMultiguias.setString(3, "E");
        prstQuantidadeExamesProntosMultiguias.setString(4, "C");
        prstQuantidadeExamesProntosMultiguias.setString(5, "I");
        if (!ParametrosGerais.getConferencia()) {
            prstQuantidadeExamesProntosMultiguias.setString(6, "L");
        }
        ResultSet rsTodosExames = prstQuantidadeExamesMultiguias.executeQuery();
        ResultSet rsExamesResultado = prstQuantidadeExamesProntosMultiguias.executeQuery();
        if (!rsTodosExames.next() || !rsExamesResultado.next()) {
            return false;
        }
        if (rsTodosExames.getInt("qtde") != rsExamesResultado.getInt("qtde")) {
            return false;
        }
        return podeEnviarPushPaciente && podeEnviaPushConvenio && rs.getBoolean("enviarPushResultado") && !Funcoes.textoVazio(rs.getString("pushResultado"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean filialPermiteEnviarSeparado(int filial, int requisicao, Statement st) throws SQLException {
        String sql = "select coalesce(fil_agrupamultiguiapushapp, false) as fil_agrupamultiguiapushapp from filiais_postocoleta where fil_codigo = ?";
        PreparedStatement psMultiguia = PushUtil.getPreparedStatement(st.getConnection(), sql);
        psMultiguia.setInt(1, filial);
        try (ResultSet rsFilialMultiguia = null;){
            rsFilialMultiguia = psMultiguia.executeQuery();
            boolean bFilialMultiguia = false;
            if (rsFilialMultiguia.next()) {
                bFilialMultiguia = rsFilialMultiguia.getBoolean("fil_agrupamultiguiapushapp");
            }
            if (bFilialMultiguia) {
                int n;
                StringBuilder listaRequisicoes = new StringBuilder();
                Integer[] integerArray = RecepcaoUtil.verificaMultiGuias(String.valueOf(filial), String.valueOf(requisicao), true);
                int n2 = integerArray.length;
                for (n = 0; n < n2; n += 1) {
                    int requisicaoAtual = integerArray[n];
                    if (!listaRequisicoes.toString().isEmpty()) {
                        listaRequisicoes.append(", ");
                    }
                    listaRequisicoes.append(requisicaoAtual);
                }
                StringBuilder buf = new StringBuilder("select (count(*) = sum(case when exr_situacao in ( '");
                buf.append("E").append("', '").append("C").append("', '").append("A").append("', '").append("I").append("' )");
                buf.append(" then 1 end)) as prontos from examerequisicao where fil_codigo = ").append(filial);
                buf.append(" and req_codigo in ( ").append((CharSequence)listaRequisicoes).append(" ) and not exr_excluido");
                ResultSet rsExamesProntos = Conexao.executeQuery(st, buf.toString());
                if (rsExamesProntos.next()) {
                    n = rsExamesProntos.getBoolean("prontos") ? 1 : 0;
                    return n != 0;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean podeEnviarPushConvenio(ResultSet rs, Statement st, int tipoBloqueioSmsConvenioResultado) throws Exception {
        if (rs.getString("codigoConvenio") == null) {
            return true;
        }
        prstBloqueiosEnvioOPushConvenio = PushUtil.getPreparedStatement(st.getConnection(), sqlBloqueiosEnvioPushConvenio);
        prstBloqueiosEnvioOPushConvenio.setInt(1, rs.getInt("codigoFilial"));
        prstBloqueiosEnvioOPushConvenio.setInt(2, rs.getInt("codigoConvenio"));
        try (ResultSet rsBloqueioEnvioSmsConvenio = null;){
            rsBloqueioEnvioSmsConvenio = prstBloqueiosEnvioOPushConvenio.executeQuery();
            if (rsBloqueioEnvioSmsConvenio.next()) {
                if (tipoBloqueioSmsConvenioResultado == 2) {
                    boolean bl = !rsBloqueioEnvioSmsConvenio.getBoolean("bloquearResultado");
                    return bl;
                }
                if (tipoBloqueioSmsConvenioResultado == 0) {
                    boolean bl = !rsBloqueioEnvioSmsConvenio.getBoolean("bloquearAniversario");
                    return bl;
                }
                if (tipoBloqueioSmsConvenioResultado == 1) {
                    boolean bl = !rsBloqueioEnvioSmsConvenio.getBoolean("bloquearRecoleta");
                    return bl;
                }
            }
        }
        return true;
    }

    private static boolean podeEnviarPushRecoleta(ResultSet rs, Statement st) throws Exception {
        return PushUtil.podeEnviarPushPaciente(rs) && PushUtil.podeEnviarPushConvenio(rs, st, 1) && rs.getBoolean("enviarPushRecoleta") && !Funcoes.textoVazio(rs.getString("pushRecoleta"));
    }

    private static boolean podeEnviarPushPaciente(ResultSet rs) throws Exception {
        return !rs.getBoolean("bloquearPushPaciente") && !Funcoes.textoVazio(rs.getString("tokenPaciente"));
    }

    private static boolean podeEnviarPushAniversario(ResultSet rs, Statement st) throws Exception {
        return PushUtil.podeEnviarPushPaciente(rs) && PushUtil.podeEnviarPushConvenio(rs, st, 0) && rs.getBoolean("enviarPushAniversario") && !Funcoes.textoVazio(rs.getString("pushAniversario"));
    }

    private static HashMap<String, Object> getHashMapCampos(String filial, ResultSet rs, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) throws SQLException {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        mapa.put("codigopaciente", rs.getString("codigoPaciente"));
        StringBuilder buf = new StringBuilder();
        buf.append(Funcoes.preencheZero(rs.getString("codigoFilial"), digitosTuboFilial));
        buf.append(Funcoes.preencheZero(rs.getString("codigoRequisicao"), digitosTuboRequisicao));
        mapa.put("codigopacienteweb", buf.toString());
        mapa.put("cpfpaciente", rs.getString("cpfPaciente"));
        mapa.put("senhawebpaciente", rs.getString("senhaWebPaciente"));
        mapa.put("nomepaciente", rs.getString("nomePaciente"));
        mapa.put("nomesocialpaciente", PushUtil.getNomeSocial(rs));
        if (!Funcoes.textoVazio(rs.getString("codigoRequisicao"))) {
            String codigo = IntegracaoUtil.formataCodigoRequisicao(filial, rs.getString("codigoRequisicao"), st, digitosTuboFilial, digitosTuboRequisicao);
            mapa.put("codigorequisicao", codigo);
        }
        mapa.put("senhawebrequisicao", rs.getString("senhaWebRequisicao"));
        mapa.put("datarequisicao", Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataRequisicao")));
        if (!Funcoes.textoVazio(rs.getString("dataEntregaPrevistaRequisicao"))) {
            mapa.put("dataentregaprevistarequisicao", Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataEntregaPrevistaRequisicao")));
        }
        if (!Funcoes.textoVazio(rs.getString("horaEntregaPrevistaRequisicao"))) {
            mapa.put("horaentregaprevistarequisicao", Funcoes.formataDataHora("HH:mm", rs.getString("horaEntregaPrevistaRequisicao")));
        }
        if (!Funcoes.textoVazio(rs.getString("dataHoraAgenda"))) {
            mapa.put("datahoraagenda", Funcoes.formataDataEHora(rs.getString("dataHoraAgenda")));
        }
        return mapa;
    }

    private static String getNomeSocial(ResultSet rs) throws SQLException {
        if (!Funcoes.textoVazio(rs.getString("nomeSocialPaciente"))) {
            return rs.getString("nomeSocialPaciente");
        }
        if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
            return rs.getString("nomePaciente");
        }
        return "";
    }

    public static String parseFrasePush(String fraseOriginal, Map<String, Object> valores) {
        StringBuilder novaFrase = new StringBuilder(fraseOriginal);
        if (fraseOriginal.contains("2!")) {
            StringBuilder bui = new StringBuilder();
            String[] expressoes = MapaResolverExpressoesUtil.resolverExpressoes(fraseOriginal, MapaResolverExpressoesUtil.getCampos(SMSUtil.getInformacoesSMS(valores)), null, valores, false);
            for (int i = 0; i < expressoes.length; ++i) {
                expressoes[i] = StringUtil.removerAcentos(expressoes[i]);
            }
            MapaResolverExpressoesUtil.adicionarStrings(bui, expressoes, "", false);
            novaFrase = bui;
        } else {
            int pos = -1;
            while ((pos = novaFrase.indexOf("[")) > -1) {
                int posFim = novaFrase.indexOf("]", pos);
                String chave = novaFrase.substring(pos + 1, posFim);
                String valor = chave != null && valores.get(chave.trim().toLowerCase()) != null ? (String)valores.get(chave.trim().toLowerCase()) : "";
                novaFrase.delete(pos, posFim + 1);
                novaFrase.insert(pos, valor);
            }
        }
        return novaFrase.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarPushResultadoPronto(String codigoFilial, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_enviarPush ");
            buf.append("       ,fil_pushresultados ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ? ");
            PreparedStatement prstEnviar = PushUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                retorno = rs.next() && rs.getBoolean("fil_enviarPush") && rs.getBoolean("fil_pushresultados");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se a filial envia push de resultados prontos.\n" + e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarPushRecoleta(String codigoFilial, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_enviarPush ");
            buf.append("       ,fil_pushrecoleta ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ? ");
            PreparedStatement prstEnviar = PushUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                retorno = rs.next() && rs.getBoolean("fil_enviarPush") && rs.getBoolean("fil_pushrecoleta");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFilialEnviarPushAniversario(String codigoFilial, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_enviarPush ");
            buf.append("       ,fil_pushaniversario ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ? ");
            PreparedStatement prstEnviar = PushUtil.getPreparedStatement(st.getConnection(), buf.toString());
            prstEnviar.setInt(1, Integer.parseInt(codigoFilial));
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                retorno = rs.next() && rs.getBoolean("fil_enviarPush") && rs.getBoolean("fil_pushaniversario");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearPushRecoleta(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select coalesce(d.des_bloquearpushrecoleta, false) as des_bloquearpushrecoleta, coalesce(m.med_bloquearpushrecoleta, false) as med_bloquearpushrecoleta");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = PushUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                while (rs.next()) {
                    retorno = rs.getBoolean("des_bloquearpushrecoleta") || rs.getBoolean("med_bloquearpushrecoleta");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearPushExamePronto(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select coalesce(d.des_bloquearpushexamepronto, false) as des_bloquearpushexamepronto, coalesce(m.med_bloquearpushexamepronto, false) as med_bloquearpushexamepronto");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = PushUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                while (rs.next()) {
                    retorno = rs.getBoolean("des_bloquearpushexamepronto") || rs.getBoolean("med_bloquearpushexamepronto");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    public static boolean isTokenVazio(String token) {
        return Funcoes.textoVazio(token);
    }

    public static PreparedStatement getPreparedStatement(Connection conexao, String sql) {
        try {
            return conexao.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            return null;
        }
    }

    static {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append(" select pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,pac.pac_tokenpushcelular as tokenPaciente ");
        buf.append("       ,COALESCE(pac.pac_bloquearpushapp, false) as bloquearPushPaciente ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_senhaweb as senhaWebRequisicao ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_dataentregaprev as dataEntregaPrevistaRequisicao ");
        buf.append("       ,req.req_horaentregaprev as horaEntregaPrevistaRequisicao ");
        buf.append("       ,req.req_pushresultadoenviado IS NOT NULL as pushResultadoEnviado ");
        buf.append("       ,cast(req.fil_codigo as varchar) || req.req_codigo as codigoPacienteWeb ");
        buf.append("       ,COALESCE(fil.fil_enviarpushapp, false) as enviarPush ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,fil.fil_pushaniversario as enviarPushAniversario ");
        buf.append("       ,fil.fil_pushresultados as enviarPushResultado ");
        buf.append("       ,fil.fil_pushrecoleta as enviarPushRecoleta ");
        buf.append("       ,fil.fil_pushrequisicao as enviarPushRequisicao ");
        buf.append("       ,fil.fil_pushagendamento as enviarPushAgendamento ");
        buf.append("       ,fil.fil_frasepushaniversario as pushAniversario ");
        buf.append("       ,fil.fil_frasepushresultados as pushResultado ");
        buf.append("       ,fil.fil_frasepushrecoleta as pushRecoleta ");
        buf.append("       ,fil.fil_frasepushrequisicao as pushRequisicao ");
        buf.append("       ,fil.fil_frasepushagendamento as pushAgendamento ");
        buf.append("       ,fil.fil_titulopushaniversario as tituloAniversario ");
        buf.append("       ,fil.fil_titulopushresultados as tituloResultado ");
        buf.append("       ,fil.fil_titulopushrecoleta as tituloRecoleta ");
        buf.append("       ,fil.fil_titulopushrequisicao as tituloRequisicao ");
        buf.append("       ,fil.fil_titulopushagendamento as tituloAgendamento ");
        buf.append("       ,agd.agd_datahoraagenda as dataHoraAgenda");
        buf.append("   from requisicao req ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join filiais_postocoleta fil on req.fil_codigo = fil.fil_codigo ");
        buf.append("   left join agendamento agd on req.fil_codigo = agd.fil_codigo and req.req_codigo = agd.req_codigo and agd.agd_situacao = '").append("A").append("'");
        buf.append("  where req.fil_codigo = ? ");
        buf.append("    and req.req_codigo = ? ");
        buf.append(" order by agd.agd_codigo desc limit 1");
        sqlDadosPush = buf.toString();
        buf.setLength(0);
        buf.append(" select pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_celular as celularPaciente ");
        buf.append("       ,pac.pac_tokenpushcelular as tokenPaciente ");
        buf.append("       ,COALESCE(pac.pac_bloquearpushapp, false) as bloquearPushPaciente ");
        buf.append("       ,COALESCE(fil.fil_enviarpushapp, false) as enviarPush ");
        buf.append("       ,pac.con_codigo as codigoConvenio ");
        buf.append("       ,fil.fil_codigo as codigoFilial ");
        buf.append("       ,fil.fil_pushaniversario as enviarPushAniversario ");
        buf.append("       ,fil.fil_pushresultados as enviarPushResultado ");
        buf.append("       ,fil.fil_pushrecoleta as enviarPushRecoleta ");
        buf.append("       ,fil.fil_pushrequisicao as enviarPushRequisicao ");
        buf.append("       ,fil.fil_pushresumofinanceiro as enviarPushAgendamento ");
        buf.append("       ,fil.fil_frasepushaniversario as pushAniversario ");
        buf.append("       ,fil.fil_frasepushresultados as pushResultado ");
        buf.append("       ,fil.fil_frasepushrecoleta as pushRecoleta ");
        buf.append("       ,fil.fil_frasepushrequisicao as pushRequisicao ");
        buf.append("       ,fil.fil_frasepushagendamento as pushAgendamento ");
        buf.append("       ,fil.fil_titulopushaniversario as tituloAniversario ");
        buf.append("       ,fil.fil_titulopushresultados as tituloResultado ");
        buf.append("       ,fil.fil_titulopushrecoleta as tituloRecoleta ");
        buf.append("       ,fil.fil_titulopushrequisicao as tituloRequisicao ");
        buf.append("       ,fil.fil_titulopushagendamento as tituloAgendamento ");
        buf.append("   from paciente pac ");
        buf.append("   join filiais_postocoleta fil on pac.fil_codigo = fil.fil_codigo ");
        buf.append("  where pac.fil_codigo = ? ");
        buf.append("    and pac.pac_codigo = ? ");
        sqlDadosPaciente = buf.toString();
        buf.setLength(0);
        buf.append(" select bool_or(CASE WHEN req_pushresultadoenviado is null then false else true end) as pushEnviado ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        sqlMultiguiasEnviaramPush = buf.toString();
        buf.setLength(0);
        buf.append(" select count(*) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo  = ? ");
        buf.append("    and req_codigo  = ? ");
        buf.append("    and not exr_excluido ");
        buf.append("    and exr_situacao <> ? ");
        sqlQuantidadeExamesMultiguias = buf.toString();
        buf.setLength(0);
        buf.append(" select con_bloquearpushexamepronto as bloquearResultado");
        buf.append("       ,con_bloquearpushrecoleta as bloquearRecoleta ");
        buf.append("       ,con_bloquearpushaniversario as bloquearAniversario ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and con_codigo = ? ");
        sqlBloqueiosEnvioPushConvenio = buf.toString();
    }
}

