/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.financeiro.util.TiposApropriacao;
import jalis.laboratorio.util.BandeirasCartoes;
import jalis.laboratorio.util.IncompatibleClassException;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ApropriaCentroCustoBean;
import jalis.model.bean.cadastro.financeiro.ApropriaPlanoContaBean;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.cadastro.financeiro.FormaPagamentoParcelaBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarCentroCustoBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.CentroCustoVO;
import jalis.model.vo.cadastro.financeiro.OrigemVO;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.cadastro.financeiro.ApropriaCentroCustoService;
import jalis.service.cadastro.financeiro.ApropriaPlanoContaService;
import jalis.service.cadastro.financeiro.OrigemService;
import jalis.service.financeiro.LancamentoCentroCustoService;
import jalis.service.financeiro.ReceberPagarCentroCustoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FinanceiroUtil {
    public static final int TIPO_APROPRIACAO_RECEBERPAGAR = 0;
    public static final int TIPO_APROPRIACAO_LANCAMENTO = 1;
    public static final int TIPO_APROPRIACAO_NOTAFISCAL = 2;
    public static final int TIPO_APROPRIACAO_BAIXA = 3;
    public static final int TIPO_APROPRIACAO_CAIXA = 4;
    public static final int TIPO_APROPRIACAO_REQUISICAO = 4;
    public static final Color COR_PLANOCONTA_ERRADO = ScreenUtil.clarearCor(Color.YELLOW, 125);
    public static final Color COR_CENTROCUSTO_ERRADO = ScreenUtil.clarearCor(Color.BLUE, 125);
    public static final Color COR_PLANOCONTA_CENTROCUSTO_ERRADO = ScreenUtil.clarearCor(Color.RED, 125);
    public static final Color COR_PLANOCONTA_NAO_CONFIGURADO = ScreenUtil.clarearCor(Color.GREEN, 125);
    public static final Color COR_CENTROCUSTO_NAO_CONFIGURADO = ScreenUtil.clarearCor(Color.DARK_GRAY, 125);
    public static final Color COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO = Color.ORANGE;
    public static final int TIPO_RATEIO_FRETE_PRIMEIRA_PARCELA = 0;
    public static final int TIPO_RATEIO_FRETE_ENTRE_PARCELAS = 1;
    public static final int TIPO_RATEIO_FRETE_ULTIMA_PARCELA = 2;

    public static BandeirasCartoes[] getCartoesCredito() {
        String xml = ParametrosGerais.getBandeirasCartoes();
        if (xml != null) {
            if (Funcoes.textoVazio(xml)) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 bandeiras de cart\u00f5es configuradas.", null);
                return null;
            }
            String[] cartoes = StringUtil.getValores(xml, "cartao");
            BandeirasCartoes[] retorno = new BandeirasCartoes[cartoes.length];
            for (int j = 0; j < cartoes.length; ++j) {
                BandeirasCartoes aux;
                String xmlCartao = cartoes[j];
                String bandeira = StringUtil.getValor(xmlCartao, "bandeira");
                String tipo = StringUtil.getValor(xmlCartao, "tipo");
                String prazo = StringUtil.getValor(xmlCartao, "prazo");
                retorno[j] = xmlCartao.indexOf("<bandeira>") >= 0 && bandeira != null ? (aux = new BandeirasCartoes(bandeira, tipo == null ? "" : tipo, prazo == null || Funcoes.textoVazio(prazo) ? 0 : Integer.parseInt(prazo))) : (aux = new BandeirasCartoes(xmlCartao, "", 0));
            }
            return retorno;
        }
        return null;
    }

    public static String montaXMLBandeiras(Object[] bandeiras) {
        StringBuilder buf = new StringBuilder();
        buf.append("<cartoes>");
        for (int i = 0; i < bandeiras.length; ++i) {
            BandeirasCartoes aux = (BandeirasCartoes)bandeiras[i];
            buf.append("<cartao>");
            buf.append("<bandeira>").append(aux.getBandeira()).append("</bandeira>");
            buf.append("<tipo>").append(aux.getOperacao()).append("</tipo>");
            buf.append("<prazo>").append(aux.getPrazo()).append("</prazo>");
            buf.append("</cartao>");
        }
        buf.append("</cartoes>");
        return buf.toString();
    }

    public static int getQuantidadeNiveisPlanoConta() {
        String mascara = ParametrosGerais.getMascaraPlanoConta();
        return StringUtil.contaOcorrencias(mascara, '.') + 1;
    }

    public static int getQuantidadeNiveisCentroCusto() {
        String mascara = ParametrosGerais.getMascaraCentroCusto();
        return StringUtil.contaOcorrencias(mascara, '.') + 1;
    }

    public static JPanel montaPanelLegenda(JPanel pnlLegenda) {
        if (pnlLegenda == null) {
            pnlLegenda = new JPanel(new GridBagLayout());
        } else if (!(pnlLegenda.getLayout() instanceof GridBagLayout)) {
            pnlLegenda.setLayout(new GridBagLayout());
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_PLANOCONTA_ERRADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Plano de Contas incorreto");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_CENTROCUSTO_ERRADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Centro de Custo incorreto");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_PLANOCONTA_CENTROCUSTO_ERRADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Plano de Contas e Centro de Custo incorreto");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        pnlLegenda.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_PLANOCONTA_NAO_CONFIGURADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Plano de Contas n\u00e3o configurado");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_CENTROCUSTO_NAO_CONFIGURADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Centro de Custo n\u00e3o configurado");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Plano de Contas e Centro de Custo n\u00e3o configurado");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        return pnlLegenda;
    }

    public static ArrayList<ReceberPagarBean> gerarParcelas(Double valorBruto, Double valorLiquido, Double valorIss, Double valorJuro, Double valorDesconto, Double valorAcrescimo, Double valorMulta, Double valorTaxa, Double valorIssRetido, Double valorInssRetido, Double valorCofinsRetido, Double valorCsllRetido, Double valorIrrfRetido, Double valorPisRetido, Double valorOutrasRetencoes, Date dataInicial, String pagarReceber, Set<FormaPagamentoParcelaBean> formaPagamentoParcelas) throws Exception {
        ArrayList<ReceberPagarBean> parcelas = new ArrayList<ReceberPagarBean>();
        if (!pagarReceber.equalsIgnoreCase("P") && !pagarReceber.equalsIgnoreCase("R")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Tipo (Receber/Pagar) n\u00e3o informado.", 2);
            return null;
        }
        if (formaPagamentoParcelas != null) {
            int qtdeParc = formaPagamentoParcelas.size();
            if (qtdeParc > 0) {
                int i;
                BigDecimal valorBrutoParc = valorBruto != null ? new BigDecimal(valorBruto).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorLiqParc = valorLiquido != null ? new BigDecimal(valorLiquido).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorIssParc = valorIss != null ? new BigDecimal(valorIss).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorJuroParc = valorJuro != null ? new BigDecimal(valorJuro).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorDescontoParc = valorDesconto != null ? new BigDecimal(valorDesconto).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorAcrescimoParc = valorAcrescimo != null ? new BigDecimal(valorAcrescimo).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorMultaParc = valorMulta != null ? new BigDecimal(valorMulta).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorTaxaParc = valorTaxa != null ? new BigDecimal(valorTaxa).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorIssRetidoParc = valorIssRetido != null ? new BigDecimal(valorIssRetido).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorInssRetidoParc = valorInssRetido != null ? new BigDecimal(valorInssRetido).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorCofinsRetidoParc = valorCofinsRetido != null ? new BigDecimal(valorCofinsRetido).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorCsllRetidoParc = valorCsllRetido != null ? new BigDecimal(valorCsllRetido).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorIrrfRetidoParc = valorIrrfRetido != null ? new BigDecimal(valorIrrfRetido).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorPisRetidoParc = valorPisRetido != null ? new BigDecimal(valorPisRetido).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal valorOutrasRetencoesParc = valorOutrasRetencoes != null ? new BigDecimal(valorOutrasRetencoes).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(0.0);
                BigDecimal divBrutoParc = valorBrutoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divLiqParc = valorLiqParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divIssParc = valorIssParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divJuroParc = valorJuroParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divDescontoParc = valorDescontoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divAcrescimoParc = valorAcrescimoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divMultaParc = valorMultaParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divTaxaParc = valorTaxaParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divIssRetidoParc = valorIssRetidoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divInssRetidoParc = valorInssRetidoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divCofinsRetidoParc = valorCofinsRetidoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divCsllRetidoParc = valorCsllRetidoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divIrrfRetidoParc = valorIrrfRetidoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divPisRetidoParc = valorPisRetidoParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                BigDecimal divOutrasRetencoesParc = valorOutrasRetencoesParc.divide(new BigDecimal(qtdeParc), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                valorBrutoParc = valorBrutoParc.setScale(2, RoundingMode.HALF_UP).subtract(divBrutoParc.multiply(new BigDecimal(qtdeParc)));
                valorLiqParc = valorLiqParc.setScale(2, RoundingMode.HALF_UP).subtract(divLiqParc.multiply(new BigDecimal(qtdeParc)));
                valorIssParc = valorIssParc.setScale(2, RoundingMode.HALF_UP).subtract(divIssParc.multiply(new BigDecimal(qtdeParc)));
                valorJuroParc = valorJuroParc.setScale(2, RoundingMode.HALF_UP).subtract(divJuroParc.multiply(new BigDecimal(qtdeParc)));
                valorDescontoParc = valorDescontoParc.setScale(2, RoundingMode.HALF_UP).subtract(divDescontoParc.multiply(new BigDecimal(qtdeParc)));
                valorAcrescimoParc = valorAcrescimoParc.setScale(2, RoundingMode.HALF_UP).subtract(divAcrescimoParc.multiply(new BigDecimal(qtdeParc)));
                valorMultaParc = valorMultaParc.setScale(2, RoundingMode.HALF_UP).subtract(divMultaParc.multiply(new BigDecimal(qtdeParc)));
                valorTaxaParc = valorTaxaParc.setScale(2, RoundingMode.HALF_UP).subtract(divTaxaParc.multiply(new BigDecimal(qtdeParc)));
                valorIssRetidoParc = valorIssRetidoParc.setScale(2, RoundingMode.HALF_UP).subtract(divIssRetidoParc.multiply(new BigDecimal(qtdeParc)));
                valorInssRetidoParc = valorInssRetidoParc.setScale(2, RoundingMode.HALF_UP).subtract(divInssRetidoParc.multiply(new BigDecimal(qtdeParc)));
                valorCofinsRetidoParc = valorCofinsRetidoParc.setScale(2, RoundingMode.HALF_UP).subtract(divCofinsRetidoParc.multiply(new BigDecimal(qtdeParc)));
                valorCsllRetidoParc = valorCsllRetidoParc.setScale(2, RoundingMode.HALF_UP).subtract(divCsllRetidoParc.multiply(new BigDecimal(qtdeParc)));
                valorIrrfRetidoParc = valorIrrfRetidoParc.setScale(2, RoundingMode.HALF_UP).subtract(divIrrfRetidoParc.multiply(new BigDecimal(qtdeParc)));
                valorPisRetidoParc = valorPisRetidoParc.setScale(2, RoundingMode.HALF_UP).subtract(divPisRetidoParc.multiply(new BigDecimal(qtdeParc)));
                valorOutrasRetencoesParc = valorOutrasRetencoesParc.setScale(2, RoundingMode.HALF_UP).subtract(divOutrasRetencoesParc.multiply(new BigDecimal(qtdeParc)));
                FormaPagamentoParcelaBean[] arrayFormaPgtoParc = new FormaPagamentoParcelaBean[formaPagamentoParcelas.size()];
                Object[] aux = formaPagamentoParcelas.toArray();
                block0: for (i = 0; i < aux.length; ++i) {
                    for (int j = 0; j < aux.length; ++j) {
                        FormaPagamentoParcelaBean it = (FormaPagamentoParcelaBean)aux[j];
                        if (it.getParcela() != i + 1) continue;
                        arrayFormaPgtoParc[i] = it;
                        continue block0;
                    }
                }
                for (i = 0; i < arrayFormaPgtoParc.length; ++i) {
                    FormaPagamentoParcelaBean fpg = arrayFormaPgtoParc[i];
                    ReceberPagarBean beanRP = new ReceberPagarBean();
                    beanRP.setParcela(fpg.getParcela());
                    beanRP.setDataVencimento(Funcoes.somaDias(dataInicial, fpg.getIntervalo()));
                    beanRP.setInserir(true);
                    boolean temProx = i != arrayFormaPgtoParc.length - 1;
                    beanRP.setIssValor(temProx ? divIssParc.doubleValue() : divIssParc.add(valorIssParc).doubleValue());
                    beanRP.setValor(temProx ? divBrutoParc.doubleValue() : divBrutoParc.add(valorBrutoParc).doubleValue());
                    beanRP.setValorJuro(temProx ? divJuroParc.doubleValue() : divJuroParc.add(valorJuroParc).doubleValue());
                    beanRP.setValorDesconto(temProx ? divDescontoParc.doubleValue() : divDescontoParc.add(valorDescontoParc).doubleValue());
                    beanRP.setValorAcrescimo(temProx ? divAcrescimoParc.doubleValue() : divAcrescimoParc.add(valorAcrescimoParc).doubleValue());
                    beanRP.setValorMulta(temProx ? divMultaParc.doubleValue() : divMultaParc.add(valorMultaParc).doubleValue());
                    beanRP.setTaxa(temProx ? divTaxaParc.doubleValue() : divTaxaParc.add(valorTaxaParc).doubleValue());
                    beanRP.setIssRetidoValor(temProx ? divIssRetidoParc.doubleValue() : divIssRetidoParc.add(valorIssRetidoParc).doubleValue());
                    beanRP.setInssRetidoValor(temProx ? divInssRetidoParc.doubleValue() : divInssRetidoParc.add(valorInssRetidoParc).doubleValue());
                    beanRP.setCofinsRetidoValor(temProx ? divCofinsRetidoParc.doubleValue() : divCofinsRetidoParc.add(valorCofinsRetidoParc).doubleValue());
                    beanRP.setCsllRetidoValor(temProx ? divCsllRetidoParc.doubleValue() : divCsllRetidoParc.add(valorCsllRetidoParc).doubleValue());
                    beanRP.setIrrfRetidoValor(temProx ? divIrrfRetidoParc.doubleValue() : divIrrfRetidoParc.add(valorIrrfRetidoParc).doubleValue());
                    beanRP.setPisRetidoValor(temProx ? divPisRetidoParc.doubleValue() : divPisRetidoParc.add(valorPisRetidoParc).doubleValue());
                    beanRP.setTipo(pagarReceber);
                    beanRP = FinanceiroUtil.atualizaTotalSemRecalculo(beanRP);
                    beanRP = (ReceberPagarBean)FinanceiroUtil.calculaPercentuais(beanRP);
                    parcelas.add(beanRP);
                }
            }
            return parcelas;
        }
        return null;
    }

    public static ArrayList<ReceberPagarBean> gerarParcelas(Double valorBruto, Double valorLiquido, Double valorIpi, Double valorIcms, Double valorDescontoNota, Double valorFreteNota, int tipoFrete, Date dataInicial, String pagarReceber, Set<FormaPagamentoParcelaBean> formaPagamentoParcelas) throws Exception {
        ArrayList<ReceberPagarBean> parcelas = new ArrayList<ReceberPagarBean>();
        if (!pagarReceber.equalsIgnoreCase("P") && !pagarReceber.equalsIgnoreCase("R")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Tipo (Receber/Pagar) n\u00e3o informado.", 2);
            return null;
        }
        if (formaPagamentoParcelas != null) {
            int qtdeParc = formaPagamentoParcelas.size();
            if (qtdeParc > 0) {
                BigDecimal valorBrutoParc = valorBruto != null ? new BigDecimal(String.valueOf(valorBruto)).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0.0);
                BigDecimal valorLiqParc = valorLiquido != null ? new BigDecimal(String.valueOf(valorLiquido)).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0.0);
                BigDecimal valorIpiParc = valorIpi != null ? new BigDecimal(String.valueOf(valorIpi)).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0.0);
                BigDecimal valorIcmsParc = valorIcms != null ? new BigDecimal(String.valueOf(valorIcms)).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0.0);
                BigDecimal valorDescParc = valorDescontoNota != null ? new BigDecimal(String.valueOf(valorDescontoNota)).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0.0);
                BigDecimal valorFreteParc = valorFreteNota != null ? new BigDecimal(String.valueOf(valorFreteNota)).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0.0);
                BigDecimal divBrutoParc = valorBrutoParc.divide(new BigDecimal(qtdeParc), ParametrosGerais.getArredondamentoPrecoExame()).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                BigDecimal divLiqParc = valorLiqParc.divide(new BigDecimal(qtdeParc), ParametrosGerais.getArredondamentoPrecoExame()).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                BigDecimal divIpiParc = valorIpiParc.divide(new BigDecimal(qtdeParc), ParametrosGerais.getArredondamentoPrecoExame()).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                BigDecimal divIcmsParc = valorIcmsParc.divide(new BigDecimal(qtdeParc), ParametrosGerais.getArredondamentoPrecoExame()).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                BigDecimal divDescParc = valorDescParc.divide(new BigDecimal(qtdeParc), ParametrosGerais.getArredondamentoPrecoExame()).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                BigDecimal divFreteParc = valorFreteParc.divide(new BigDecimal(qtdeParc), ParametrosGerais.getArredondamentoPrecoExame()).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                valorBrutoParc = valorBrutoParc.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).subtract(divBrutoParc.multiply(new BigDecimal(qtdeParc)));
                valorLiqParc = valorLiqParc.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).subtract(divLiqParc.multiply(new BigDecimal(qtdeParc)));
                valorIpiParc = valorIpiParc.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).subtract(divIpiParc.multiply(new BigDecimal(qtdeParc)));
                valorIcmsParc = valorIcmsParc.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).subtract(divIcmsParc.multiply(new BigDecimal(qtdeParc)));
                valorDescParc = valorDescParc.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).subtract(divDescParc.multiply(new BigDecimal(qtdeParc)));
                valorFreteParc = valorFreteParc.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).subtract(divFreteParc.multiply(new BigDecimal(qtdeParc)));
                FormaPagamentoParcelaBean[] arrayFormaPgtoParc = new FormaPagamentoParcelaBean[formaPagamentoParcelas.size()];
                Object[] aux = formaPagamentoParcelas.toArray();
                block0: for (int i = 0; i < aux.length; ++i) {
                    for (int j = 0; j < aux.length; ++j) {
                        FormaPagamentoParcelaBean it = (FormaPagamentoParcelaBean)aux[j];
                        if (it.getParcela() != i + 1) continue;
                        arrayFormaPgtoParc[i] = it;
                        continue block0;
                    }
                }
                BigDecimal somatorioValor = BigDecimal.ZERO;
                for (int i = 0; i < arrayFormaPgtoParc.length; ++i) {
                    FormaPagamentoParcelaBean fpg = arrayFormaPgtoParc[i];
                    ReceberPagarBean beanRP = new ReceberPagarBean();
                    beanRP.setParcela(fpg.getParcela());
                    beanRP.setDataVencimento(Funcoes.somaDias(dataInicial, fpg.getIntervalo()));
                    beanRP.setInserir(true);
                    boolean temProx = i != arrayFormaPgtoParc.length - 1;
                    BigDecimal valor = divBrutoParc;
                    BigDecimal valorTotal = divLiqParc;
                    BigDecimal valorIcmsAux = divIcmsParc;
                    BigDecimal valorIpiAux = divIpiParc;
                    BigDecimal valorDesconto = divDescParc;
                    if (!temProx) {
                        valor = divBrutoParc.add(valorBrutoParc).add(new BigDecimal(String.valueOf(valorBruto)));
                        valor = valor.subtract(new BigDecimal(String.valueOf(valorBruto)).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
                        valorTotal = divLiqParc.add(valorLiqParc);
                        valorTotal = valorTotal.add(new BigDecimal(String.valueOf(valorLiquido)));
                        valorTotal = valorTotal.subtract(new BigDecimal(String.valueOf(valorLiquido))).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        if (valorLiquido.doubleValue() != somatorioValor.add(valorTotal).doubleValue()) {
                            BigDecimal decimalValorLiquido = new BigDecimal(String.valueOf(valorLiquido));
                            valorTotal = decimalValorLiquido.subtract(somatorioValor);
                        }
                        valorIcmsAux = divIcmsParc.add(valorIcmsParc).add(new BigDecimal(String.valueOf(valorIcms)));
                        valorIcmsAux = valorIcmsAux.subtract(new BigDecimal(String.valueOf(valorIcms)));
                        valorIpiAux = divIpiParc.add(valorIpiParc).add(new BigDecimal(String.valueOf(valorIpi)));
                        valorIpiAux = valorIpiAux.subtract(new BigDecimal(String.valueOf(valorIpi)));
                        valorIpiAux = valorIpiAux.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        valorDesconto = valorDesconto.add(valorDescParc);
                    }
                    beanRP.setValor(valor.doubleValue());
                    beanRP.setValorTotal(valorTotal.setScale(2, RoundingMode.FLOOR).doubleValue());
                    beanRP.setValorIpi(valorIpiAux.doubleValue());
                    beanRP.setValorIcms(valorIcmsAux.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).doubleValue());
                    beanRP.setValorDesconto(valorDesconto.doubleValue());
                    somatorioValor = somatorioValor.add(valorTotal.setScale(2, RoundingMode.FLOOR));
                    if (tipoFrete == 1) {
                        beanRP.setValorFrete(temProx ? divFreteParc.doubleValue() : divFreteParc.add(valorFreteParc).doubleValue());
                    } else if (tipoFrete == 0 && i == 0) {
                        beanRP.setValorFrete(valorFreteNota);
                    } else if (tipoFrete == 2 && i == arrayFormaPgtoParc.length - 1) {
                        beanRP.setValorFrete(valorFreteNota);
                    } else {
                        beanRP.setValorFrete(0.0);
                    }
                    beanRP.setTipo(pagarReceber);
                    beanRP = (ReceberPagarBean)FinanceiroUtil.calculaPercentuais(beanRP);
                    parcelas.add(beanRP);
                }
            }
            return parcelas;
        }
        return null;
    }

    public static ArrayList<ReceberPagarBean> gerarParcelas(Double valorBruto, Double valorLiquido, Double percIrrf, Double percIss, Double percPis, Double percCsll, Double percCofins, Double percInss, Double valorIrrf, Double valorIss, Double valorPis, Double valorCsll, Double valorCofins, Double valorInss, Double valorJuro, Double valorDesconto, Double valorAcrescimo, Double valorMulta, Double valorTaxa, String pagarReceber, Date dataInicial, Integer qtdeParcelas, Integer intervaloDias) {
        ArrayList<ReceberPagarBean> parcelas = new ArrayList<ReceberPagarBean>();
        if (!pagarReceber.equalsIgnoreCase("P") && !pagarReceber.equalsIgnoreCase("R")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Tipo (Receber/Pagar) n\u00e3o informado.", 2);
            return null;
        }
        int casas = ParametrosGerais.getCasasPrecoExame();
        RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
        if (qtdeParcelas > 0) {
            BigDecimal valorBrutoParc = (valorBruto != null ? new BigDecimal(valorBruto.toString()) : new BigDecimal("0")).setScale(casas, round);
            BigDecimal valorLiqParc = (valorLiquido != null ? new BigDecimal(valorLiquido.toString()) : new BigDecimal("0")).setScale(casas, round);
            BigDecimal valorJuroParc = (valorJuro != null ? new BigDecimal(valorJuro.toString()) : new BigDecimal("0")).setScale(casas, round);
            BigDecimal valorDescontoParc = (valorDesconto != null ? new BigDecimal(valorDesconto.toString()) : new BigDecimal("0")).setScale(casas, round);
            BigDecimal valorAcrescimoParc = (valorAcrescimo != null ? new BigDecimal(valorAcrescimo.toString()) : new BigDecimal("0")).setScale(casas, round);
            BigDecimal valorMultaParc = (valorMulta != null ? new BigDecimal(valorMulta.toString()) : new BigDecimal("0")).setScale(casas, round);
            BigDecimal valorTaxaParc = (valorTaxa != null ? new BigDecimal(valorTaxa.toString()) : new BigDecimal("0")).setScale(casas, round);
            BigDecimal divBrutoParc = valorBrutoParc.divide(new BigDecimal(qtdeParcelas.toString()), round).setScale(casas, round);
            BigDecimal divLiqParc = valorLiqParc.divide(new BigDecimal(qtdeParcelas.toString()), round).setScale(casas, round);
            BigDecimal divJuroParc = valorJuroParc.divide(new BigDecimal(qtdeParcelas.toString()), round).setScale(casas, round);
            BigDecimal divDescontoParc = valorDescontoParc.divide(new BigDecimal(qtdeParcelas.toString()), round).setScale(casas, round);
            BigDecimal divAcrescimoParc = valorAcrescimoParc.divide(new BigDecimal(qtdeParcelas.toString()), round).setScale(casas, round);
            BigDecimal divMultaParc = valorMultaParc.divide(new BigDecimal(qtdeParcelas.toString()), round).setScale(casas, round);
            BigDecimal divTaxaParc = valorTaxaParc.divide(new BigDecimal(qtdeParcelas.toString()), round).setScale(casas, round);
            valorBrutoParc = valorBrutoParc.setScale(casas, round).subtract(divBrutoParc.multiply(new BigDecimal(qtdeParcelas.toString())));
            valorLiqParc = valorLiqParc.setScale(casas, round).subtract(divLiqParc.multiply(new BigDecimal(qtdeParcelas.toString())));
            valorJuroParc = valorJuroParc.setScale(casas, round).subtract(divJuroParc.multiply(new BigDecimal(qtdeParcelas.toString())));
            valorDescontoParc = valorDescontoParc.setScale(casas, round).subtract(divDescontoParc.multiply(new BigDecimal(qtdeParcelas.toString())));
            valorAcrescimoParc = valorAcrescimoParc.setScale(casas, round).subtract(divAcrescimoParc.multiply(new BigDecimal(qtdeParcelas.toString())));
            valorMultaParc = valorMultaParc.setScale(casas, round).subtract(divMultaParc.multiply(new BigDecimal(qtdeParcelas.toString())));
            valorTaxaParc = valorTaxaParc.setScale(casas, round).subtract(divTaxaParc.multiply(new BigDecimal(qtdeParcelas.toString())));
            for (int i = 0; i < qtdeParcelas; ++i) {
                ReceberPagarBean beanRP = new ReceberPagarBean();
                beanRP.setParcela(i + 1);
                if (intervaloDias == null) {
                    beanRP.setDataVencimento(Funcoes.somaMeses(dataInicial, i));
                } else {
                    beanRP.setDataVencimento(Funcoes.somaDias(dataInicial, intervaloDias * i));
                }
                beanRP.setInserir(true);
                boolean temProx = i != qtdeParcelas - 1;
                beanRP.setValor(temProx ? divBrutoParc.doubleValue() : divBrutoParc.add(valorBrutoParc).doubleValue());
                beanRP.setValorJuro(temProx ? divJuroParc.doubleValue() : divJuroParc.add(valorJuroParc).doubleValue());
                beanRP.setValorDesconto(temProx ? divDescontoParc.doubleValue() : divDescontoParc.add(valorDescontoParc).doubleValue());
                beanRP.setValorAcrescimo(temProx ? divAcrescimoParc.doubleValue() : divAcrescimoParc.add(valorAcrescimoParc).doubleValue());
                beanRP.setValorMulta(temProx ? divMultaParc.doubleValue() : divMultaParc.add(valorMultaParc).doubleValue());
                beanRP.setTaxa(temProx ? divTaxaParc.doubleValue() : divTaxaParc.add(valorTaxaParc).doubleValue());
                BigDecimal percIrrfParc = (percIrrf != null ? new BigDecimal(percIrrf.toString()) : new BigDecimal("0")).setScale(casas, round);
                BigDecimal percIssParc = (percIss != null ? new BigDecimal(percIss.toString()) : new BigDecimal("0")).setScale(casas, round);
                BigDecimal percPisParc = (percPis != null ? new BigDecimal(percPis.toString()) : new BigDecimal("0")).setScale(casas, round);
                BigDecimal percCsllParc = (percCsll != null ? new BigDecimal(percCsll.toString()) : new BigDecimal("0")).setScale(casas, round);
                BigDecimal percCofinsParc = (percCofins != null ? new BigDecimal(percCofins.toString()) : new BigDecimal("0")).setScale(casas, round);
                BigDecimal percInssParc = (percInss != null ? new BigDecimal(percInss.toString()) : new BigDecimal("0")).setScale(casas, round);
                BigDecimal divIrrfParc = percIrrfParc.multiply(new BigDecimal(beanRP.getValor())).divide(new BigDecimal("100"), round).setScale(casas, round);
                BigDecimal divIssParc = percIssParc.multiply(new BigDecimal(beanRP.getValor())).divide(new BigDecimal("100"), round).setScale(casas, round);
                BigDecimal divPisParc = percPisParc.multiply(new BigDecimal(beanRP.getValor())).divide(new BigDecimal("100"), round).setScale(casas, round);
                BigDecimal divCsllParc = percCsllParc.multiply(new BigDecimal(beanRP.getValor())).divide(new BigDecimal("100"), round).setScale(casas, round);
                BigDecimal divCofinsParc = percCofinsParc.multiply(new BigDecimal(beanRP.getValor())).divide(new BigDecimal("100"), round).setScale(casas, round);
                BigDecimal divInssParc = percInssParc.multiply(new BigDecimal(beanRP.getValor())).divide(new BigDecimal("100"), round).setScale(casas, round);
                percIrrfParc = new BigDecimal(valorIrrf.toString()).setScale(casas, round).subtract(divIrrfParc.multiply(new BigDecimal(qtdeParcelas.toString())));
                percIssParc = new BigDecimal(valorIss.toString()).setScale(casas, round).subtract(divIssParc.multiply(new BigDecimal(qtdeParcelas.toString())));
                percPisParc = new BigDecimal(valorPis.toString()).setScale(casas, round).subtract(divPisParc.multiply(new BigDecimal(qtdeParcelas.toString())));
                percCsllParc = new BigDecimal(valorCsll.toString()).setScale(casas, round).subtract(divCsllParc.multiply(new BigDecimal(qtdeParcelas.toString())));
                percCofinsParc = new BigDecimal(valorCofins.toString()).setScale(casas, round).subtract(divCofinsParc.multiply(new BigDecimal(qtdeParcelas.toString())));
                percInssParc = new BigDecimal(valorInss.toString()).setScale(casas, round).subtract(divInssParc.multiply(new BigDecimal(qtdeParcelas.toString())));
                beanRP.setIrrfValor(temProx ? divIrrfParc.doubleValue() : divIrrfParc.add(percIrrfParc).doubleValue());
                beanRP.setIssValor(temProx ? divIssParc.doubleValue() : divIssParc.add(percIssParc).doubleValue());
                beanRP.setPisValor(temProx ? divPisParc.doubleValue() : divPisParc.add(percPisParc).doubleValue());
                beanRP.setCsllValor(temProx ? divCsllParc.doubleValue() : divCsllParc.add(percCsllParc).doubleValue());
                beanRP.setCofinsValor(temProx ? divCofinsParc.doubleValue() : divCofinsParc.add(percCofinsParc).doubleValue());
                beanRP.setInssValor(temProx ? divInssParc.doubleValue() : divInssParc.add(percInssParc).doubleValue());
                beanRP.setIrrfPercentual((double)percIrrf);
                beanRP.setIssPercentual((double)percIss);
                beanRP.setPisPercentual((double)percPis);
                beanRP.setCsllPercentual((double)percCsll);
                beanRP.setCofinsPercentual((double)percCofins);
                beanRP.setInssPercentual((double)percInss);
                beanRP.setTipo(pagarReceber);
                beanRP = FinanceiroUtil.atualizaTotalSemRecalculo(beanRP);
                beanRP = (ReceberPagarBean)FinanceiroUtil.calculaPercentuais(beanRP);
                parcelas.add(beanRP);
            }
            return parcelas;
        }
        return null;
    }

    public static ContaCorrenteBean getContaCaixaPadrao(String filial) {
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        StringBuffer buf = new StringBuffer("");
        int codigo = -1;
        ContaCorrenteBean bean = null;
        codigo = ParametrosLocais.getParametro("contaCaixa") != null && Funcoes.isNumeric(ParametrosLocais.getParametro("contaCaixa")) ? Integer.parseInt(ParametrosLocais.getParametro("contaCaixa")) : ParametrosGerais.getContaCaixa();
        if (codigo > -1) {
            try {
                bean = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Funcoes.textoVazio(filial) ? Variaveis.filialPadrao : filial, String.valueOf(codigo));
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os dados da Conta Caixa: " + codigo + ".\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (bean == null || bean.getInativa().booleanValue()) {
            buf.delete(0, buf.length());
            buf.append("select cco_reduzido from contacorrente where fil_codigo = ");
            buf.append(Funcoes.textoVazio(filial) ? Variaveis.filialPadrao : filial);
            buf.append(" and upper(cco_tipo) = upper('");
            buf.append("X");
            buf.append("') and cco_inativa = false ");
            try {
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    codigo = rs.getInt("cco_reduzido");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar por uma Conta Caixa.\n" + e.getMessage(), e.getStackTrace());
            }
        } else {
            return bean;
        }
        if (codigo > -1) {
            try {
                bean = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, String.valueOf(codigo));
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os dados da Conta Caixa: " + codigo + ".\n" + e.getMessage(), e.getStackTrace());
            }
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenuma Conta Caixa padr\u00e3o foi encontrada, verifique a configura\u00e7\u00e3o da esta\u00e7\u00e3o.", 1);
        }
        return bean;
    }

    public static boolean contaInativa(Statement st, String filial, String codigoConta) throws SQLException {
        StringBuilder bui = new StringBuilder("select cco_inativa from contacorrente ");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and cco_reduzido = ").append(codigoConta);
        ResultSet rs = Conexao.executeQuery(st, bui);
        return rs.next() && rs.getBoolean(1);
    }

    public static Integer getHistoricoPadrao(Statement st, String filial, String codigoConta) throws SQLException {
        StringBuilder bui = new StringBuilder("select hpa_codigo from contacorrente ");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and cco_reduzido = ").append(codigoConta);
        ResultSet rs = Conexao.executeQuery(st, bui);
        return rs.next() ? Integer.valueOf(rs.getInt("hpa_codigo")) : null;
    }

    public static ReceberPagarBean atualizaTotalSemRecalculo(ReceberPagarBean titulo) {
        int CASAS = ParametrosGerais.getCasasPrecoExame();
        RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
        BigDecimal valor = new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString());
        if (titulo.getTipo().equalsIgnoreCase("R")) {
            valor = valor.add(new BigDecimal(titulo.getValorMulta() == null ? "0" : titulo.getValorMulta().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorJuro() == null ? "0" : titulo.getValorJuro().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorAcrescimo() == null ? "0" : titulo.getValorAcrescimo().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getValorDesconto() == null ? "0" : titulo.getValorDesconto().toString()));
            valor = valor.add(new BigDecimal(titulo.getTaxa() == null ? "0" : titulo.getTaxa().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorFrete() == null ? "0" : titulo.getValorFrete().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getCofinsValor() == null ? "0" : titulo.getCofinsValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getCsllValor() == null ? "0" : titulo.getCsllValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getInssValor() == null ? "0" : titulo.getInssValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getIrrfValor() == null ? "0" : titulo.getIrrfValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getPisValor() == null ? "0" : titulo.getPisValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getIssRetidoValor() == null ? "0" : titulo.getIssRetidoValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getInssRetidoValor() == null ? "0" : titulo.getInssRetidoValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getCofinsRetidoValor() == null ? "0" : titulo.getCofinsRetidoValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getCsllRetidoValor() == null ? "0" : titulo.getCsllRetidoValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getIrrfRetidoValor() == null ? "0" : titulo.getIrrfRetidoValor().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getPisRetidoValor() == null ? "0" : titulo.getPisRetidoValor().toString()));
        } else {
            valor = valor.add(new BigDecimal(titulo.getValorMulta() == null ? "0" : titulo.getValorMulta().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorJuro() == null ? "0" : titulo.getValorJuro().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorAcrescimo() == null ? "0" : titulo.getValorAcrescimo().toString()));
            valor = valor.subtract(new BigDecimal(titulo.getValorDesconto() == null ? "0" : titulo.getValorDesconto().toString()));
            valor = valor.add(new BigDecimal(titulo.getTaxa() == null ? "0" : titulo.getTaxa().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorFrete() == null ? "0" : titulo.getValorFrete().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorIcms() == null ? "0" : titulo.getValorIcms().toString()));
            valor = valor.add(new BigDecimal(titulo.getValorIpi() == null ? "0" : titulo.getValorIpi().toString()));
        }
        valor = valor.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        titulo.setValorTotal(valor.doubleValue());
        return titulo;
    }

    public static LancamentoBean atualizaTotalSemRecalculo(LancamentoBean titulo) {
        BigDecimal valor = null;
        valor = new BigDecimal(titulo.getValor() == null ? 0.0 : titulo.getValor());
        if (titulo.getTipo().equalsIgnoreCase("C")) {
            valor = valor.add(new BigDecimal(titulo.getValorMulta() == null ? 0.0 : titulo.getValorMulta()));
            valor = valor.add(new BigDecimal(titulo.getValorJuro() == null ? 0.0 : titulo.getValorJuro()));
            valor = valor.add(new BigDecimal(titulo.getValorAcrescimo() == null ? 0.0 : titulo.getValorAcrescimo()));
            valor = valor.subtract(new BigDecimal(titulo.getValorDesconto() == null ? 0.0 : titulo.getValorDesconto()));
        } else {
            valor = valor.subtract(new BigDecimal(titulo.getValorMulta() == null ? 0.0 : titulo.getValorMulta()));
            valor = valor.subtract(new BigDecimal(titulo.getValorJuro() == null ? 0.0 : titulo.getValorJuro()));
            valor = valor.subtract(new BigDecimal(titulo.getValorAcrescimo() == null ? 0.0 : titulo.getValorAcrescimo()));
            valor = valor.add(new BigDecimal(titulo.getValorDesconto() == null ? 0.0 : titulo.getValorDesconto()));
        }
        valor = valor.setScale(2, RoundingMode.HALF_UP);
        titulo.setValorTotal(valor.doubleValue());
        return titulo;
    }

    public static AbstractThreadBean atualizaTotal(AbstractThreadBean titulo) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.atualizaTotal((ReceberPagarBean)titulo);
        }
        return FinanceiroUtil.atualizaTotal((LancamentoBean)titulo);
    }

    private static AbstractThreadBean atualizaTotal(ReceberPagarBean titulo) {
        BigDecimal valor = new BigDecimal(0.0);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        if (titulo.getTipo().equalsIgnoreCase("R")) {
            valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
            valor = valor.add(titulo.getValorJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorJuro()));
            valor = valor.add(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
            valor = valor.subtract(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
            valor = valor.add(titulo.getTaxa() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getTaxa()));
            valor = valor.add(titulo.getValorFrete() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorFrete()));
            valor = valor.subtract(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
            valor = valor.subtract(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
            valor = valor.subtract(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
            valor = valor.subtract(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
            valor = valor.subtract(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
            valor = valor.subtract(titulo.getIssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssRetidoValor()));
            valor = valor.subtract(titulo.getInssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssRetidoValor()));
            valor = valor.subtract(titulo.getCofinsRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsRetidoValor()));
            valor = valor.subtract(titulo.getCsllRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllRetidoValor()));
            valor = valor.subtract(titulo.getIrrfRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfRetidoValor()));
            valor = valor.subtract(titulo.getPisRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisRetidoValor()));
        } else {
            valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
            valor = valor.add(titulo.getValorJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorJuro()));
            valor = valor.add(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
            valor = valor.subtract(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
            valor = valor.add(titulo.getTaxa() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getTaxa()));
            valor = valor.add(titulo.getValorFrete() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorFrete()));
            valor = valor.add(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
            valor = valor.add(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
            valor = valor.add(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
            valor = valor.add(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
            valor = valor.add(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
            valor = valor.subtract(titulo.getIssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssRetidoValor()));
            valor = valor.subtract(titulo.getInssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssRetidoValor()));
            valor = valor.subtract(titulo.getCofinsRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsRetidoValor()));
            valor = valor.subtract(titulo.getCsllRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllRetidoValor()));
            valor = valor.subtract(titulo.getIrrfRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfRetidoValor()));
            valor = valor.subtract(titulo.getPisRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisRetidoValor()));
        }
        valor = valor.setScale(2, RoundingMode.HALF_UP);
        titulo.setValorTotal(valor.doubleValue());
        return titulo;
    }

    private static AbstractThreadBean atualizaTotal(LancamentoBean titulo) {
        BigDecimal valor = new BigDecimal(0.0);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
        valor = valor.add(titulo.getValorJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorJuro()));
        valor = valor.add(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
        valor = valor.subtract(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
        valor = valor.setScale(2, RoundingMode.HALF_UP);
        titulo.setValorTotal(valor.doubleValue());
        return titulo;
    }

    public static Double getTotalSemImpostos(ReceberPagarBean titulo) {
        BigDecimal valor = new BigDecimal(0.0);
        if (titulo.getTipo().equalsIgnoreCase("R")) {
            valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
            valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
            valor = valor.add(titulo.getValorJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorJuro()));
            valor = valor.add(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
            valor = valor.subtract(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
        } else {
            valor = valor.subtract(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
            valor = valor.subtract(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
            valor = valor.subtract(titulo.getValorJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorJuro()));
            valor = valor.subtract(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
            valor = valor.add(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
        }
        valor = valor.setScale(2, RoundingMode.HALF_UP);
        return valor.doubleValue();
    }

    public static AbstractThreadBean atualizaValores(AbstractThreadBean titulo, Date dataConciliacao) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.atualizaValores((ReceberPagarBean)titulo, dataConciliacao);
        }
        return FinanceiroUtil.atualizaValores((LancamentoBean)titulo, dataConciliacao);
    }

    public static AbstractThreadBean atualizaValores(ReceberPagarBean titulo, Date dataConciliacao) {
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        if (dataConciliacao.compareTo(titulo.getDataVencimento()) > 0) {
            titulo = (ReceberPagarBean)FinanceiroUtil.calculaMulta(titulo, dataConciliacao);
            titulo = (ReceberPagarBean)FinanceiroUtil.calculaJuros(titulo, dataConciliacao);
            titulo = (ReceberPagarBean)FinanceiroUtil.calculaAcrescimo(titulo, dataConciliacao);
        }
        titulo = (ReceberPagarBean)FinanceiroUtil.calculaDesconto(titulo);
        BigDecimal valor = new BigDecimal(0.0);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
        valor = valor.add(titulo.getValorJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorJuro()));
        valor = valor.add(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
        valor = valor.subtract(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
        valor = valor.add(titulo.getTaxa() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getTaxa()));
        valor = valor.subtract(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
        valor = valor.subtract(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
        valor = valor.subtract(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
        valor = valor.subtract(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
        valor = valor.subtract(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
        valor = valor.subtract(titulo.getIssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssRetidoValor()));
        valor = valor.subtract(titulo.getInssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssRetidoValor()));
        valor = valor.subtract(titulo.getCofinsRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsRetidoValor()));
        valor = valor.subtract(titulo.getCsllRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllRetidoValor()));
        valor = valor.subtract(titulo.getIrrfRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfRetidoValor()));
        valor = valor.subtract(titulo.getPisRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisRetidoValor()));
        valor = valor.setScale(2, RoundingMode.HALF_UP);
        titulo.setValorTotal(valor.doubleValue());
        return titulo;
    }

    private static AbstractThreadBean atualizaValores(LancamentoBean titulo, Date dataConciliacao) {
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        titulo = (LancamentoBean)FinanceiroUtil.calculaMulta(titulo, dataConciliacao);
        titulo = (LancamentoBean)FinanceiroUtil.calculaJuros(titulo, dataConciliacao);
        titulo = (LancamentoBean)FinanceiroUtil.calculaAcrescimo(titulo, dataConciliacao);
        titulo = (LancamentoBean)FinanceiroUtil.calculaDesconto(titulo);
        BigDecimal valor = new BigDecimal(0.0);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
        valor = valor.add(titulo.getValorJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorJuro()));
        valor = valor.add(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
        valor = valor.subtract(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
        valor = valor.setScale(2, RoundingMode.HALF_UP);
        titulo.setValorTotal(valor.doubleValue());
        return titulo;
    }

    public static AbstractThreadBean calculaMulta(AbstractThreadBean titulo, Date dataConciliacao) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.calculaMulta((ReceberPagarBean)titulo, dataConciliacao);
        }
        return FinanceiroUtil.calculaMulta((LancamentoBean)titulo, dataConciliacao);
    }

    private static AbstractThreadBean calculaMulta(ReceberPagarBean titulo, Date dataConciliacao) {
        if (titulo == null || titulo.getDataVencimento() == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0).setScale(4);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        valor = valor.subtract(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
        valor = valor.subtract(titulo.getIssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssValor()));
        valor = valor.subtract(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
        valor = valor.subtract(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
        valor = valor.subtract(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
        valor = valor.subtract(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
        BigDecimal percMulta = new BigDecimal(0).setScale(4);
        percMulta = percMulta.add(new BigDecimal(titulo.getPercentualMulta() == null ? 0.0 : titulo.getPercentualMulta()).setScale(4, RoundingMode.HALF_UP));
        int dias = 0;
        if (dataConciliacao != null) {
            dias = Funcoes.daysBetween(titulo.getDataVencimento(), dataConciliacao);
        }
        if (dias > 0 || dataConciliacao == null) {
            percMulta = valor.multiply(percMulta).divide(new BigDecimal(100).setScale(4), RoundingMode.HALF_UP);
        } else if (dias == 0) {
            percMulta = new BigDecimal(0.0);
        }
        percMulta = percMulta.setScale(2, RoundingMode.HALF_UP);
        if (percMulta.doubleValue() < 0.0) {
            titulo.setValorMulta(0.0);
        } else {
            titulo.setValorMulta(percMulta.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    private static AbstractThreadBean calculaMulta(LancamentoBean titulo, Date dataConciliacao) {
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0).setScale(4);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        BigDecimal percMulta = new BigDecimal(0).setScale(4);
        percMulta = percMulta.add(new BigDecimal(titulo.getPercentualMulta() == null ? 0.0 : titulo.getPercentualMulta()).setScale(4, RoundingMode.HALF_UP));
        int dias = 0;
        dias = Funcoes.daysBetween(titulo.getDataVencimento(), dataConciliacao);
        if (dias > 0) {
            percMulta = valor.multiply(percMulta).divide(new BigDecimal(100).setScale(4), RoundingMode.HALF_UP);
        } else if (dias == 0) {
            percMulta = new BigDecimal(0.0);
        }
        percMulta = percMulta.setScale(2, RoundingMode.HALF_UP);
        if (percMulta.doubleValue() < 0.0) {
            titulo.setValorMulta(0.0);
        } else {
            titulo.setValorMulta(percMulta.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    public static AbstractThreadBean calculaJuros(AbstractThreadBean titulo, Date dataConciliacao) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.calculaJuros((ReceberPagarBean)titulo, dataConciliacao);
        }
        return FinanceiroUtil.calculaJuros((LancamentoBean)titulo, dataConciliacao);
    }

    private static AbstractThreadBean calculaJuros(ReceberPagarBean titulo, Date dataConciliacao) {
        BigDecimal valorJuros = new BigDecimal(0.0);
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0.0);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        valor = valor.subtract(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
        valor = valor.subtract(titulo.getIssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssValor()));
        valor = valor.subtract(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
        valor = valor.subtract(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
        valor = valor.subtract(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
        valor = valor.subtract(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
        BigDecimal valorMulta = new BigDecimal(0.0);
        valorMulta = valorMulta.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
        BigDecimal perc = new BigDecimal(0.0);
        perc = perc.add(titulo.getPercentualJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPercentualJuro()));
        String tipoJuro = "";
        String string = tipoJuro = titulo.getTipoJuro() == null ? "" : titulo.getTipoJuro();
        if (tipoJuro.equalsIgnoreCase("V")) {
            titulo.setPercentualJuro(0.0);
        } else {
            if (dataConciliacao.before(titulo.getDataVencimento())) {
                titulo.setValorJuro(0.0);
                return titulo;
            }
            if (titulo.getUsarValorMulta() != null && titulo.getUsarValorMulta().booleanValue()) {
                valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
            }
            Double periodo = FinanceiroUtil.getPeriodoCalculoJuro(titulo, dataConciliacao);
            perc = new BigDecimal(Math.pow(1.0 + perc.doubleValue() / 100.0, Double.parseDouble(Funcoes.limpaDecimal(Funcoes.formataDecimal("0.0000", periodo)))) - 1.0);
            valorJuros = valor.multiply(perc);
            valorJuros = valorJuros.setScale(2, RoundingMode.HALF_UP);
            titulo.setValorJuro(valorJuros.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    private static AbstractThreadBean calculaJuros(LancamentoBean titulo, Date dataConciliacao) {
        BigDecimal valorJuros = new BigDecimal(0.0);
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0.0);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        BigDecimal valorMulta = new BigDecimal(0.0);
        valorMulta = valorMulta.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
        BigDecimal perc = new BigDecimal(0.0);
        perc = perc.add(titulo.getPercentualJuro() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPercentualJuro()));
        String tipoJuro = "";
        String string = tipoJuro = titulo.getTipoJuro() == null ? "" : titulo.getTipoJuro();
        if (tipoJuro.equalsIgnoreCase("V")) {
            titulo.setPercentualJuro(0.0);
        } else {
            if (dataConciliacao.before(titulo.getDataVencimento())) {
                titulo.setValorJuro(0.0);
                return titulo;
            }
            if (titulo.getUsarValorMulta() != null && titulo.getUsarValorMulta().booleanValue()) {
                valor = valor.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
            }
            Double periodo = FinanceiroUtil.getPeriodoCalculoJuro(titulo, dataConciliacao);
            perc = new BigDecimal(Math.pow(1.0 + perc.doubleValue() / 100.0, Double.parseDouble(Funcoes.limpaDecimal(Funcoes.formataDecimal("0.0000", periodo)))) - 1.0);
            valorJuros = valor.multiply(perc);
            valorJuros = valorJuros.setScale(2, RoundingMode.HALF_UP);
            titulo.setValorJuro(valorJuros.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    private static Double getPeriodoCalculoJuro(ReceberPagarBean titulo, Date dataConciliacao) {
        String tipoJuro = "";
        tipoJuro = titulo.getTipoJuro() == null ? "" : titulo.getTipoJuro();
        BigDecimal periodo = new BigDecimal(0.0);
        GregorianCalendar dataConc = new GregorianCalendar();
        GregorianCalendar dataVenc = new GregorianCalendar();
        dataConc.setTime(dataConciliacao);
        dataVenc.setTime(titulo.getDataVencimento());
        if (tipoJuro.equalsIgnoreCase("D")) {
            periodo = new BigDecimal(Math.abs(Funcoes.daysBetween(titulo.getDataVencimento(), dataConciliacao)));
        } else if (tipoJuro.equalsIgnoreCase("M")) {
            int mesesEntreDatas = dataConc.get(2) - dataVenc.get(2);
            int anosEntreDatas = dataConc.get(1) - dataVenc.get(1);
            if ((mesesEntreDatas += anosEntreDatas * 12 - 1) == 0 && dataConc.get(2) == dataVenc.get(2)) {
                GregorianCalendar auxCalendar = new GregorianCalendar();
                auxCalendar.setTime(Funcoes.lastDayMonth(dataConciliacao));
                periodo = new BigDecimal(dataConc.get(5) - dataVenc.get(5) / auxCalendar.get(5));
            } else {
                GregorianCalendar auxCalendarConc = new GregorianCalendar();
                GregorianCalendar auxCalendarVenc = new GregorianCalendar();
                auxCalendarConc.setTime(Funcoes.lastDayMonth(dataConciliacao));
                auxCalendarVenc.setTime(Funcoes.lastDayMonth(titulo.getDataVencimento()));
                periodo = new BigDecimal((double)(auxCalendarVenc.get(5) - dataVenc.get(5) + 1)).divide(new BigDecimal((double)auxCalendarVenc.get(5)), RoundingMode.HALF_UP);
                periodo = periodo.add(new BigDecimal(mesesEntreDatas));
                periodo = periodo.add(new BigDecimal((double)(dataConc.get(5) - 1)).divide(new BigDecimal((double)auxCalendarConc.get(5)), RoundingMode.HALF_UP));
            }
        } else if (tipoJuro.equalsIgnoreCase("A")) {
            int anosEntreDatas = dataConc.get(1) - dataVenc.get(1);
            if (anosEntreDatas == 0 && dataConc.get(1) == dataVenc.get(1)) {
                int qtdeDiasEntreDatas = Funcoes.daysBetween(titulo.getDataVencimento(), dataConciliacao) + 1;
                int qtdeDiasAno = Funcoes.getQtdeDiasAno(dataConciliacao);
                periodo = new BigDecimal((double)qtdeDiasEntreDatas).divide(new BigDecimal((double)qtdeDiasAno), RoundingMode.HALF_UP);
            } else {
                int qtdeDiasAnoConc = Funcoes.getQtdeDiasAno(dataConciliacao);
                int qtdeDiasAnoVenc = Funcoes.getQtdeDiasAno(titulo.getDataVencimento());
                int qtdeDiasPassadosConc = Funcoes.daysBetween(Funcoes.firstDayYear(dataConciliacao), dataConciliacao);
                int qtdeDiasPassadosVenc = Funcoes.daysBetween(titulo.getDataVencimento(), Funcoes.lastDayYear(titulo.getDataVencimento()));
                periodo = new BigDecimal(qtdeDiasPassadosVenc + 1).divide(new BigDecimal((double)qtdeDiasAnoVenc), RoundingMode.HALF_UP);
                periodo = periodo.add(new BigDecimal(anosEntreDatas - 1));
                periodo = periodo.add(new BigDecimal(qtdeDiasPassadosConc).divide(new BigDecimal((double)qtdeDiasAnoConc), RoundingMode.HALF_UP));
            }
        }
        periodo = periodo.setScale(2, RoundingMode.HALF_UP);
        return periodo.doubleValue();
    }

    private static Double getPeriodoCalculoJuro(LancamentoBean titulo, Date dataConciliacao) {
        String tipoJuro = "";
        tipoJuro = titulo.getTipoJuro() == null ? "" : titulo.getTipoJuro();
        BigDecimal periodo = new BigDecimal(0.0);
        GregorianCalendar dataConc = new GregorianCalendar();
        GregorianCalendar dataVenc = new GregorianCalendar();
        dataConc.setTime(dataConciliacao);
        dataVenc.setTime(titulo.getDataVencimento());
        if (tipoJuro.equalsIgnoreCase("D")) {
            periodo = new BigDecimal(Math.abs(Funcoes.daysBetween(titulo.getDataVencimento(), dataConciliacao)));
        } else if (tipoJuro.equalsIgnoreCase("M")) {
            int mesesEntreDatas = dataConc.get(2) - dataVenc.get(2);
            int anosEntreDatas = dataConc.get(1) - dataVenc.get(1);
            if ((mesesEntreDatas += anosEntreDatas * 12 - 1) == 0 && dataConc.get(2) == dataVenc.get(2)) {
                GregorianCalendar auxCalendar = new GregorianCalendar();
                auxCalendar.setTime(Funcoes.lastDayMonth(dataConciliacao));
                periodo = new BigDecimal(dataConc.get(5) - dataVenc.get(5) / auxCalendar.get(5));
            } else {
                GregorianCalendar auxCalendarConc = new GregorianCalendar();
                GregorianCalendar auxCalendarVenc = new GregorianCalendar();
                auxCalendarConc.setTime(Funcoes.lastDayMonth(dataConciliacao));
                auxCalendarVenc.setTime(Funcoes.lastDayMonth(titulo.getDataVencimento()));
                periodo = new BigDecimal((double)(auxCalendarVenc.get(5) - dataVenc.get(5) + 1)).divide(new BigDecimal((double)auxCalendarVenc.get(5)), RoundingMode.HALF_UP);
                periodo = periodo.add(new BigDecimal(mesesEntreDatas));
                periodo = periodo.add(new BigDecimal((double)(dataConc.get(5) - 1)).divide(new BigDecimal((double)auxCalendarConc.get(5)), RoundingMode.HALF_UP));
            }
        } else if (tipoJuro.equalsIgnoreCase("A")) {
            int anosEntreDatas = dataConc.get(1) - dataVenc.get(1);
            if (anosEntreDatas == 0 && dataConc.get(1) == dataVenc.get(1)) {
                int qtdeDiasEntreDatas = Funcoes.daysBetween(titulo.getDataVencimento(), dataConciliacao) + 1;
                int qtdeDiasAno = Funcoes.getQtdeDiasAno(dataConciliacao);
                periodo = new BigDecimal((double)qtdeDiasEntreDatas).divide(new BigDecimal((double)qtdeDiasAno), RoundingMode.HALF_UP);
            } else {
                int qtdeDiasAnoConc = Funcoes.getQtdeDiasAno(dataConciliacao);
                int qtdeDiasAnoVenc = Funcoes.getQtdeDiasAno(titulo.getDataVencimento());
                int qtdeDiasPassadosConc = Funcoes.daysBetween(Funcoes.firstDayYear(dataConciliacao), dataConciliacao);
                int qtdeDiasPassadosVenc = Funcoes.daysBetween(titulo.getDataVencimento(), Funcoes.lastDayYear(titulo.getDataVencimento()));
                periodo = new BigDecimal(qtdeDiasPassadosVenc + 1).divide(new BigDecimal((double)qtdeDiasAnoVenc), RoundingMode.HALF_UP);
                periodo = periodo.add(new BigDecimal(anosEntreDatas - 1));
                periodo = periodo.add(new BigDecimal(qtdeDiasPassadosConc).divide(new BigDecimal((double)qtdeDiasAnoConc), RoundingMode.HALF_UP));
            }
        }
        periodo = periodo.setScale(2, RoundingMode.HALF_UP);
        return periodo.doubleValue();
    }

    public static AbstractThreadBean calculaAcrescimo(AbstractThreadBean titulo, Date dataConciliacao) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.calculaAcrescimo((ReceberPagarBean)titulo, dataConciliacao);
        }
        return FinanceiroUtil.calculaAcrescimo((LancamentoBean)titulo, dataConciliacao);
    }

    private static AbstractThreadBean calculaAcrescimo(ReceberPagarBean titulo, Date dataConciliacao) {
        if (titulo == null || titulo.getDataVencimento() == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0).setScale(2);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        valor = valor.subtract(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
        valor = valor.subtract(titulo.getIssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssValor()));
        valor = valor.subtract(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
        valor = valor.subtract(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
        valor = valor.subtract(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
        valor = valor.subtract(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
        BigDecimal percAcrescimo = new BigDecimal(0).setScale(2);
        percAcrescimo = percAcrescimo.add(titulo.getPercentualAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPercentualAcrescimo()));
        int dias = 0;
        if (dataConciliacao != null) {
            dias = Funcoes.daysBetween(dataConciliacao, titulo.getDataVencimento());
        }
        if (dias > 0 || dataConciliacao == null) {
            percAcrescimo = valor.multiply(percAcrescimo).divide(new BigDecimal(100).setScale(2), RoundingMode.HALF_UP);
        } else if (dias == 0) {
            percAcrescimo = new BigDecimal(0);
        }
        percAcrescimo = percAcrescimo.setScale(2, RoundingMode.HALF_UP);
        if (percAcrescimo.doubleValue() < 0.0) {
            titulo.setValorAcrescimo(0.0);
        } else {
            titulo.setValorAcrescimo(percAcrescimo.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    private static AbstractThreadBean calculaAcrescimo(LancamentoBean titulo, Date dataConciliacao) {
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0).setScale(2);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        BigDecimal percAcrescimo = new BigDecimal(0).setScale(2);
        percAcrescimo = percAcrescimo.add(titulo.getPercentualAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPercentualAcrescimo()));
        int dias = 0;
        dias = Funcoes.daysBetween(dataConciliacao, titulo.getDataVencimento());
        if (dias > 0) {
            percAcrescimo = valor.multiply(percAcrescimo).divide(new BigDecimal(100).setScale(2), RoundingMode.HALF_UP);
        } else if (dias == 0) {
            percAcrescimo = new BigDecimal(0);
        }
        percAcrescimo = percAcrescimo.setScale(2, RoundingMode.HALF_UP);
        if (percAcrescimo.doubleValue() < 0.0) {
            titulo.setValorAcrescimo(0.0);
        } else {
            titulo.setValorAcrescimo(percAcrescimo.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    public static AbstractThreadBean calculaDesconto(AbstractThreadBean titulo) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.calculaDesconto((ReceberPagarBean)titulo);
        }
        return FinanceiroUtil.calculaDesconto((LancamentoBean)titulo);
    }

    private static AbstractThreadBean calculaDesconto(ReceberPagarBean titulo) {
        if (titulo == null || titulo.getDataVencimento() == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0).setScale(2);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        valor = valor.subtract(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
        valor = valor.subtract(titulo.getIssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssValor()));
        valor = valor.subtract(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
        valor = valor.subtract(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
        valor = valor.subtract(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
        valor = valor.subtract(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
        BigDecimal percDesconto = new BigDecimal(0).setScale(2);
        percDesconto = percDesconto.add(titulo.getPercentualDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPercentualDesconto()));
        percDesconto = valor.multiply(percDesconto).divide(new BigDecimal(100).setScale(2), RoundingMode.HALF_UP);
        if ((percDesconto = percDesconto.setScale(2, RoundingMode.HALF_UP)).doubleValue() < 0.0) {
            titulo.setValorDesconto(0.0);
        } else {
            titulo.setValorDesconto(percDesconto.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    private static AbstractThreadBean calculaDesconto(LancamentoBean titulo) {
        if (titulo == null || titulo.getDataVencimento() == null) {
            return titulo;
        }
        BigDecimal valor = new BigDecimal(0).setScale(2);
        valor = valor.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        BigDecimal percDesconto = new BigDecimal(0).setScale(2);
        percDesconto = percDesconto.add(titulo.getPercentualDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPercentualDesconto()));
        percDesconto = valor.multiply(percDesconto).divide(new BigDecimal(100).setScale(2), RoundingMode.HALF_UP);
        if ((percDesconto = percDesconto.setScale(2, RoundingMode.HALF_UP)).doubleValue() < 0.0) {
            titulo.setValorDesconto(0.0);
        } else {
            titulo.setValorDesconto(percDesconto.doubleValue());
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    public static AbstractThreadBean calculaPercentuais(AbstractThreadBean titulo) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.calculaPercentuais((ReceberPagarBean)titulo);
        }
        return FinanceiroUtil.calculaPercentuais((LancamentoBean)titulo);
    }

    public static AbstractThreadBean calculaPercentuais(ReceberPagarBean titulo) {
        if (titulo == null) {
            return titulo;
        }
        BigDecimal total = new BigDecimal(0).setScale(4);
        total = total.add(titulo.getValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValor()));
        total = total.subtract(titulo.getIrrfValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfValor()));
        total = total.subtract(titulo.getIssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssValor()));
        total = total.subtract(titulo.getPisValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisValor()));
        total = total.subtract(titulo.getCofinsValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsValor()));
        total = total.subtract(titulo.getCsllValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllValor()));
        total = total.subtract(titulo.getInssValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssValor()));
        total = total.subtract(titulo.getIssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIssRetidoValor()));
        total = total.subtract(titulo.getInssRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getInssRetidoValor()));
        total = total.subtract(titulo.getCofinsRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCofinsRetidoValor()));
        total = total.subtract(titulo.getCsllRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getCsllRetidoValor()));
        total = total.subtract(titulo.getIrrfRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getIrrfRetidoValor()));
        total = total.subtract(titulo.getPisRetidoValor() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getPisRetidoValor()));
        BigDecimal valorMulta = new BigDecimal(0).setScale(4);
        valorMulta = valorMulta.add(titulo.getValorMulta() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorMulta()));
        BigDecimal valorAcrescimo = new BigDecimal(0).setScale(4);
        valorAcrescimo = valorAcrescimo.add(titulo.getValorAcrescimo() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorAcrescimo()));
        BigDecimal valorDesconto = new BigDecimal(0).setScale(4);
        valorDesconto = valorDesconto.add(titulo.getValorDesconto() == null ? new BigDecimal(0.0) : new BigDecimal(titulo.getValorDesconto()));
        BigDecimal totalMulta = new BigDecimal(0).setScale(4);
        BigDecimal totalAcrescimo = new BigDecimal(0).setScale(4);
        BigDecimal totalDesconto = new BigDecimal(0).setScale(4);
        if (total.doubleValue() > 0.0) {
            totalMulta = valorMulta.multiply(new BigDecimal(100).setScale(4, RoundingMode.HALF_UP)).divide(total, RoundingMode.HALF_UP);
            totalAcrescimo = valorAcrescimo.multiply(new BigDecimal(100).setScale(4, RoundingMode.HALF_UP)).divide(total, RoundingMode.HALF_UP);
            totalDesconto = valorDesconto.multiply(new BigDecimal(100).setScale(4, RoundingMode.HALF_UP)).divide(total, RoundingMode.HALF_UP);
        }
        totalMulta = totalMulta.setScale(4, RoundingMode.HALF_UP);
        totalAcrescimo = totalAcrescimo.setScale(4, RoundingMode.HALF_UP);
        totalDesconto = totalDesconto.setScale(4, RoundingMode.HALF_UP);
        titulo.setPercentualMulta(totalMulta.doubleValue());
        titulo.setPercentualAcrescimo(totalAcrescimo.doubleValue());
        titulo.setPercentualDesconto(totalDesconto.doubleValue());
        return titulo;
    }

    public static AbstractThreadBean calculaPercentuais(LancamentoBean titulo) {
        if (titulo == null) {
            return titulo;
        }
        double total = 0.0;
        total += titulo.getValorTotal() == null ? 0.0 : titulo.getValorTotal();
        double valorMulta = 0.0;
        valorMulta += titulo.getValorMulta() == null ? 0.0 : titulo.getValorMulta();
        double valorAcrescimo = 0.0;
        valorAcrescimo += titulo.getValorAcrescimo() == null ? 0.0 : titulo.getValorAcrescimo();
        double valorDesconto = 0.0;
        valorDesconto += titulo.getValorDesconto() == null ? 0.0 : titulo.getValorDesconto();
        double valorJuro = 0.0;
        valorJuro += titulo.getValorJuro() == null ? 0.0 : titulo.getValorJuro();
        double totalMulta = 0.0;
        double totalAcrescimo = 0.0;
        double totalDesconto = 0.0;
        double totalJuro = 0.0;
        if (total > 0.0) {
            totalMulta = valorMulta / total * 100.0;
            totalAcrescimo = valorAcrescimo / total * 100.0;
            totalDesconto = valorDesconto / total * 100.0;
            totalJuro = valorJuro / total * 100.0;
        }
        titulo.setPercentualMulta(totalMulta);
        titulo.setPercentualAcrescimo(totalAcrescimo);
        titulo.setPercentualDesconto(totalDesconto);
        titulo.setPercentualJuro(totalJuro);
        return titulo;
    }

    public static AbstractThreadBean calculaPercentualJuro(AbstractThreadBean titulo, Date dataConciliacao) {
        if (titulo instanceof ReceberPagarBean) {
            return FinanceiroUtil.calculaPercentualJuro((ReceberPagarBean)titulo, dataConciliacao);
        }
        return FinanceiroUtil.calculaPercentualJuro((LancamentoBean)titulo, dataConciliacao);
    }

    private static AbstractThreadBean calculaPercentualJuro(ReceberPagarBean titulo, Date dataConciliacao) {
        double percJuros = 0.0;
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        double valor = 0.0;
        valor += titulo.getValor() == null ? 0.0 : titulo.getValor();
        valor -= titulo.getIrrfValor() == null ? 0.0 : titulo.getIrrfValor();
        valor -= titulo.getIssValor() == null ? 0.0 : titulo.getIssValor();
        valor -= titulo.getPisValor() == null ? 0.0 : titulo.getPisValor();
        valor -= titulo.getCofinsValor() == null ? 0.0 : titulo.getCofinsValor();
        valor -= titulo.getCsllValor() == null ? 0.0 : titulo.getCsllValor();
        valor -= titulo.getInssValor() == null ? 0.0 : titulo.getInssValor();
        double valorMulta = 0.0;
        valorMulta += titulo.getValorMulta() == null ? 0.0 : titulo.getValorMulta();
        double valorJuros = 0.0;
        valorJuros += titulo.getValorJuro() == null ? 0.0 : titulo.getValorJuro();
        String tipoJuro = "";
        String string = tipoJuro = titulo.getTipoJuro() == null ? "" : titulo.getTipoJuro();
        if (tipoJuro.equalsIgnoreCase("V")) {
            titulo.setPercentualJuro(0.0);
        } else {
            if (dataConciliacao.before(titulo.getDataVencimento()) || dataConciliacao.equals(titulo.getDataVencimento())) {
                titulo.setValorJuro(0.0);
                return titulo;
            }
            if (titulo.getUsarValorMulta() != null && titulo.getUsarValorMulta().booleanValue()) {
                valor += titulo.getValorMulta() == null ? 0.0 : titulo.getValorMulta();
            }
            Double periodo = FinanceiroUtil.getPeriodoCalculoJuro(titulo, dataConciliacao);
            percJuros = 100.0 * (Math.pow(valorJuros / valor + 1.0, 1.0 / periodo) - 1.0);
            titulo.setPercentualJuro(Double.parseDouble(Funcoes.limpaDecimal(Funcoes.formataDecimal("0.00", percJuros))));
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    private static AbstractThreadBean calculaPercentualJuro(LancamentoBean titulo, Date dataConciliacao) {
        double percJuros = 0.0;
        if (titulo == null || titulo.getDataVencimento() == null || dataConciliacao == null) {
            return titulo;
        }
        double valor = 0.0;
        valor += titulo.getValor() == null ? 0.0 : titulo.getValor();
        double valorMulta = 0.0;
        valorMulta += titulo.getValorMulta() == null ? 0.0 : titulo.getValorMulta();
        double valorJuros = 0.0;
        valorJuros += titulo.getValorJuro() == null ? 0.0 : titulo.getValorJuro();
        String tipoJuro = "";
        String string = tipoJuro = titulo.getTipoJuro() == null ? "" : titulo.getTipoJuro();
        if (tipoJuro.equalsIgnoreCase("V")) {
            titulo.setPercentualJuro(0.0);
        } else {
            if (dataConciliacao.before(titulo.getDataVencimento())) {
                titulo.setValorJuro(0.0);
                return titulo;
            }
            if (titulo.getUsarValorMulta() != null && titulo.getUsarValorMulta().booleanValue()) {
                valor += titulo.getValorMulta() == null ? 0.0 : titulo.getValorMulta();
            }
            Double periodo = FinanceiroUtil.getPeriodoCalculoJuro(titulo, dataConciliacao);
            percJuros = 100.0 * (Math.pow(valorJuros / valor + 1.0, 1.0 / periodo) - 1.0);
            titulo.setPercentualJuro(Double.parseDouble(Funcoes.limpaDecimal(Funcoes.formataDecimal("0.00", percJuros))));
        }
        FinanceiroUtil.atualizaTotal(titulo);
        return titulo;
    }

    public static ReceberPagarBean calculaPercentualImpostoSemNota(ReceberPagarBean titulo) {
        try {
            if (!(titulo instanceof ReceberPagarBean)) {
                throw new IncompatibleClassException(titulo, ReceberPagarBean.class);
            }
        }
        catch (IncompatibleClassException ice) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ice.getMessage(), ice.getStackTrace(), "FinanceiroUtil:calculaPercentualImpostoSemNota");
            return null;
        }
        BigDecimal total = new BigDecimal(0).setScale(4);
        total = total.add(new BigDecimal(titulo.getValor() == null ? 0.0 : titulo.getValor()));
        BigDecimal valorIrrf = new BigDecimal(0).setScale(4);
        valorIrrf = valorIrrf.add(new BigDecimal(titulo.getIrrfValor() == null ? 0.0 : titulo.getIrrfValor()));
        BigDecimal valorIss = new BigDecimal(0).setScale(4);
        valorIss = valorIss.add(new BigDecimal(titulo.getIssValor() == null ? 0.0 : titulo.getIssValor()));
        BigDecimal valorIssRetido = new BigDecimal(0).setScale(4);
        valorIssRetido = valorIssRetido.add(new BigDecimal(titulo.getIssRetidoValor() == null ? 0.0 : titulo.getIssRetidoValor()));
        BigDecimal valorPis = new BigDecimal(0).setScale(4);
        valorPis = valorPis.add(new BigDecimal(titulo.getPisValor() == null ? 0.0 : titulo.getPisValor()));
        BigDecimal valorCsll = new BigDecimal(0).setScale(4);
        valorCsll = valorCsll.add(new BigDecimal(titulo.getCsllValor() == null ? 0.0 : titulo.getCsllValor()));
        BigDecimal valorCofins = new BigDecimal(0).setScale(4);
        valorCofins = valorCofins.add(new BigDecimal(titulo.getCofinsValor() == null ? 0.0 : titulo.getCofinsValor()));
        BigDecimal valorInss = new BigDecimal(0).setScale(4);
        valorInss = valorInss.add(new BigDecimal(titulo.getInssValor() == null ? 0.0 : titulo.getInssValor()));
        BigDecimal valorIpi = new BigDecimal(0).setScale(4);
        valorIpi = valorIpi.add(new BigDecimal(titulo.getValorIpi() == null ? 0.0 : titulo.getValorIpi()));
        BigDecimal valorIcms = new BigDecimal(0).setScale(4);
        valorIcms = valorIcms.add(new BigDecimal(titulo.getValorIcms() == null ? 0.0 : titulo.getValorIcms()));
        BigDecimal valorInssRetido = new BigDecimal(0).setScale(4);
        valorInssRetido = valorInssRetido.add(new BigDecimal(titulo.getInssRetidoValor() == null ? 0.0 : titulo.getInssRetidoValor()));
        BigDecimal valorCofinsRetido = new BigDecimal(0).setScale(4);
        valorCofinsRetido = valorCofinsRetido.add(new BigDecimal(titulo.getCofinsRetidoValor() == null ? 0.0 : titulo.getCofinsRetidoValor()));
        BigDecimal valorCsllRetido = new BigDecimal(0).setScale(4);
        valorCsllRetido = valorCsllRetido.add(new BigDecimal(titulo.getCsllRetidoValor() == null ? 0.0 : titulo.getCsllRetidoValor()));
        BigDecimal valorIrrfRetido = new BigDecimal(0).setScale(4);
        valorIrrfRetido = valorIrrfRetido.add(new BigDecimal(titulo.getIrrfRetidoValor() == null ? 0.0 : titulo.getIrrfRetidoValor()));
        BigDecimal valorPisRetido = new BigDecimal(0).setScale(4);
        valorPisRetido = valorPisRetido.add(new BigDecimal(titulo.getPisRetidoValor() == null ? 0.0 : titulo.getPisRetidoValor()));
        BigDecimal totalIrrf = new BigDecimal(0);
        BigDecimal totalIss = new BigDecimal(0);
        BigDecimal totalIssRetido = new BigDecimal(0);
        BigDecimal totalPis = new BigDecimal(0);
        BigDecimal totalCsll = new BigDecimal(0);
        BigDecimal totalCofins = new BigDecimal(0);
        BigDecimal totalInss = new BigDecimal(0);
        BigDecimal totalIpi = new BigDecimal(0);
        BigDecimal totalIcms = new BigDecimal(0);
        BigDecimal totalInssRetido = new BigDecimal(0);
        BigDecimal totalCofinsRetido = new BigDecimal(0);
        BigDecimal totalCsllRetido = new BigDecimal(0);
        BigDecimal totalIrrfRetido = new BigDecimal(0);
        BigDecimal totalPisRetido = new BigDecimal(0);
        if (total.doubleValue() > 0.0) {
            totalIrrf = valorIrrf.multiply(new BigDecimal(100).setScale(4)).divide(new BigDecimal(titulo.getValor() == null ? 0.0 : titulo.getValor()), RoundingMode.HALF_UP);
            totalIss = valorIss.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalIssRetido = valorIssRetido.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalPis = valorPis.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalCsll = valorCsll.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalCofins = valorCofins.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalInss = valorInss.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalIpi = valorIpi.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalIcms = valorIcms.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalInssRetido = valorInssRetido.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalCofinsRetido = valorCofinsRetido.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalCsllRetido = valorCsllRetido.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalIrrfRetido = valorIrrfRetido.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalPisRetido = valorPisRetido.multiply(new BigDecimal(100).setScale(4)).divide(total, RoundingMode.HALF_UP);
            totalIrrf = totalIrrf.setScale(4, RoundingMode.HALF_UP);
            totalIss = totalIss.setScale(4, RoundingMode.HALF_UP);
            totalIssRetido = totalIssRetido.setScale(4, RoundingMode.HALF_UP);
            totalPis = totalPis.setScale(4, RoundingMode.HALF_UP);
            totalCsll = totalCsll.setScale(4, RoundingMode.HALF_UP);
            totalCofins = totalCofins.setScale(4, RoundingMode.HALF_UP);
            totalInss = totalInss.setScale(4, RoundingMode.HALF_UP);
            totalIcms = totalIcms.setScale(4, RoundingMode.HALF_UP);
            totalIpi = totalIpi.setScale(4, RoundingMode.HALF_UP);
            totalInssRetido = totalInssRetido.setScale(4, RoundingMode.HALF_UP);
            totalCofinsRetido = totalCofinsRetido.setScale(4, RoundingMode.HALF_UP);
            totalCsllRetido = totalCsllRetido.setScale(4, RoundingMode.HALF_UP);
            totalIrrfRetido = totalIrrfRetido.setScale(4, RoundingMode.HALF_UP);
            totalPisRetido = totalPisRetido.setScale(4, RoundingMode.HALF_UP);
        }
        titulo.setIrrfPercentual(totalIrrf.doubleValue());
        titulo.setIssPercentual(totalIss.doubleValue());
        titulo.setIssRetidoPercentual(totalIssRetido.doubleValue());
        titulo.setPisPercentual(totalPis.doubleValue());
        titulo.setCsllPercentual(totalCsll.doubleValue());
        titulo.setCofinsPercentual(totalCofins.doubleValue());
        titulo.setInssPercentual(totalInss.doubleValue());
        titulo.setPercentualIpi(totalIpi.doubleValue());
        titulo.setPercentualIcms(totalIcms.doubleValue());
        titulo.setInssRetidoPercentual(totalInssRetido.doubleValue());
        titulo.setCofinsRetidoPercentual(totalCofinsRetido.doubleValue());
        titulo.setCsllRetidoPercentual(totalCsllRetido.doubleValue());
        titulo.setIrrfRetidoPercentual(totalIrrfRetido.doubleValue());
        titulo.setPisRetidoPercentual(totalPisRetido.doubleValue());
        return titulo;
    }

    public static ReceberPagarBean calculaPercentualImposto(ReceberPagarBean titulo) {
        int CASAS = ParametrosGerais.getCasasPrecoExame();
        int CASAS_MAIOR = 4;
        RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
        try {
            if (!(titulo instanceof ReceberPagarBean)) {
                throw new IncompatibleClassException(titulo, ReceberPagarBean.class);
            }
        }
        catch (IncompatibleClassException ice) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ice.getMessage(), ice.getStackTrace());
            return null;
        }
        BigDecimal total = new BigDecimal("0").setScale(CASAS_MAIOR);
        if (titulo.getNotaFiscal() != null) {
            NotaFiscalVO voNota = titulo.getNotaFiscal();
            total = total.add(new BigDecimal(voNota.getImpostoAcumulado().toString()));
        } else {
            total = total.add(new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString()));
        }
        BigDecimal valorIrrf = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorIrrf = valorIrrf.add(new BigDecimal(titulo.getIrrfValor() == null ? "0" : titulo.getIrrfValor().toString()));
        BigDecimal valorIss = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorIss = valorIss.add(new BigDecimal(titulo.getIssValor() == null ? "0" : titulo.getIssValor().toString()));
        BigDecimal valorPis = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorPis = valorPis.add(new BigDecimal(titulo.getPisValor() == null ? "0" : titulo.getPisValor().toString()));
        BigDecimal valorCsll = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorCsll = valorCsll.add(new BigDecimal(titulo.getCsllValor() == null ? "0" : titulo.getCsllValor().toString()));
        BigDecimal valorCofins = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorCofins = valorCofins.add(new BigDecimal(titulo.getCofinsValor() == null ? "0" : titulo.getCofinsValor().toString()));
        BigDecimal valorInss = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorInss = valorInss.add(new BigDecimal(titulo.getInssValor() == null ? "0" : titulo.getInssValor().toString()));
        BigDecimal valorIpi = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorIpi = valorIpi.add(new BigDecimal(titulo.getValorIpi() == null ? "0" : titulo.getValorIpi().toString()));
        BigDecimal valorIcms = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorIcms = valorIcms.add(new BigDecimal(titulo.getValorIcms() == null ? "0" : titulo.getValorIcms().toString()));
        BigDecimal valorIssRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorIssRetido = valorIssRetido.add(new BigDecimal(titulo.getIssRetidoValor() == null ? "0" : titulo.getIssRetidoValor().toString()));
        BigDecimal valorInssRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorInssRetido = valorInssRetido.add(new BigDecimal(titulo.getInssRetidoValor() == null ? "0" : titulo.getInssRetidoValor().toString()));
        BigDecimal valorCofinsRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorCofinsRetido = valorCofinsRetido.add(new BigDecimal(titulo.getCofinsRetidoValor() == null ? "0" : titulo.getCofinsRetidoValor().toString()));
        BigDecimal valorCsllRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorCsllRetido = valorCsllRetido.add(new BigDecimal(titulo.getCsllRetidoValor() == null ? "0" : titulo.getCsllRetidoValor().toString()));
        BigDecimal valorIrrfRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorIrrfRetido = valorIrrfRetido.add(new BigDecimal(titulo.getIrrfRetidoValor() == null ? "0" : titulo.getIrrfRetidoValor().toString()));
        BigDecimal valorPisRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        valorPisRetido = valorPisRetido.add(new BigDecimal(titulo.getPisRetidoValor() == null ? "0" : titulo.getPisRetidoValor().toString()));
        BigDecimal totalIrrf = new BigDecimal("0");
        BigDecimal totalIss = new BigDecimal("0");
        BigDecimal totalPis = new BigDecimal("0");
        BigDecimal totalCsll = new BigDecimal("0");
        BigDecimal totalCofins = new BigDecimal("0");
        BigDecimal totalInss = new BigDecimal("0");
        BigDecimal totalIpi = new BigDecimal("0");
        BigDecimal totalIcms = new BigDecimal("0");
        BigDecimal totalIssRetido = new BigDecimal("0");
        BigDecimal totalInssRetido = new BigDecimal("0");
        BigDecimal totalCofinsRetido = new BigDecimal("0");
        BigDecimal totalCsllRetido = new BigDecimal("0");
        BigDecimal totalIrrfRetido = new BigDecimal("0");
        BigDecimal totalPisRetido = new BigDecimal("0");
        BigDecimal totalOutrasRetencoes = new BigDecimal("0");
        if (total.doubleValue() > 0.0) {
            totalIrrf = valorIrrf.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString()), ROUND);
            totalIss = valorIss.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalPis = valorPis.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalCsll = valorCsll.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalCofins = valorCofins.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalInss = valorInss.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalIpi = valorIpi.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalIcms = valorIcms.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalIssRetido = valorIssRetido.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalInssRetido = valorInssRetido.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalCofinsRetido = valorCofinsRetido.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalCsllRetido = valorCsllRetido.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalIrrfRetido = valorIrrfRetido.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalPisRetido = valorPisRetido.multiply(new BigDecimal("100").setScale(CASAS_MAIOR)).divide(total, ROUND);
            totalIrrf = totalIrrf.setScale(CASAS_MAIOR, ROUND);
            totalIss = totalIss.setScale(CASAS_MAIOR, ROUND);
            totalPis = totalPis.setScale(CASAS_MAIOR, ROUND);
            totalCsll = totalCsll.setScale(CASAS_MAIOR, ROUND);
            totalCofins = totalCofins.setScale(CASAS_MAIOR, ROUND);
            totalInss = totalInss.setScale(CASAS_MAIOR, ROUND);
            totalIcms = totalIcms.setScale(CASAS_MAIOR, ROUND);
            totalIpi = totalIpi.setScale(CASAS_MAIOR, ROUND);
            totalIssRetido = totalIssRetido.setScale(CASAS_MAIOR, ROUND);
            totalInssRetido = totalIssRetido.setScale(CASAS_MAIOR, ROUND);
            totalCofinsRetido = totalCofinsRetido.setScale(CASAS_MAIOR, ROUND);
            totalCsllRetido = totalCsllRetido.setScale(CASAS_MAIOR, ROUND);
            totalIrrfRetido = totalIrrfRetido.setScale(CASAS_MAIOR, ROUND);
            totalPisRetido = totalPisRetido.setScale(CASAS_MAIOR, ROUND);
            totalOutrasRetencoes = totalOutrasRetencoes.setScale(CASAS_MAIOR, ROUND);
        }
        titulo.setIrrfPercentual(totalIrrf.doubleValue());
        titulo.setIssPercentual(totalIss.doubleValue());
        titulo.setPisPercentual(totalPis.doubleValue());
        titulo.setCsllPercentual(totalCsll.doubleValue());
        titulo.setCofinsPercentual(totalCofins.doubleValue());
        titulo.setInssPercentual(totalInss.doubleValue());
        titulo.setPercentualIpi(totalIpi.doubleValue());
        titulo.setPercentualIcms(totalIcms.doubleValue());
        titulo.setIssRetidoPercentual(totalIssRetido.doubleValue());
        titulo.setInssRetidoPercentual(totalInssRetido.doubleValue());
        titulo.setCofinsRetidoPercentual(totalCofinsRetido.doubleValue());
        titulo.setCsllRetidoPercentual(totalCsllRetido.doubleValue());
        titulo.setIrrfRetidoPercentual(totalIrrfRetido.doubleValue());
        titulo.setPisRetidoPercentual(totalPisRetido.doubleValue());
        return titulo;
    }

    public static ReceberPagarBean calculaValorImpostoSemNota(ReceberPagarBean titulo) {
        int casas = ParametrosGerais.getCasasPrecoExame();
        int casasMaior = 4;
        RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
        try {
            if (!(titulo instanceof ReceberPagarBean)) {
                throw new IncompatibleClassException(titulo, ReceberPagarBean.class);
            }
        }
        catch (IncompatibleClassException ice) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ice.getMessage(), ice.getStackTrace(), "FinanceiroUtil:calculaValorImpostoSemNota");
            return null;
        }
        BigDecimal valor = new BigDecimal("0").setScale(casasMaior);
        valor = valor.add(new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString()));
        BigDecimal percentualIrrf = new BigDecimal("0").setScale(casasMaior);
        percentualIrrf = percentualIrrf.add(new BigDecimal(titulo.getIrrfPercentual() == null ? "0" : titulo.getIrrfPercentual().toString()));
        BigDecimal percentualIss = new BigDecimal("0").setScale(casasMaior);
        percentualIss = percentualIss.add(new BigDecimal(titulo.getIssPercentual() == null ? "0" : titulo.getIssPercentual().toString()));
        BigDecimal percentualIssRetido = new BigDecimal("0").setScale(casasMaior);
        percentualIssRetido = percentualIssRetido.add(new BigDecimal(titulo.getIssRetidoPercentual() == null ? "0" : titulo.getIssRetidoPercentual().toString()));
        BigDecimal percentualPis = new BigDecimal("0").setScale(casasMaior);
        percentualPis = percentualPis.add(new BigDecimal(titulo.getPisPercentual() == null ? "0" : titulo.getPisPercentual().toString()));
        BigDecimal percentualCsll = new BigDecimal("0").setScale(casasMaior);
        percentualCsll = percentualCsll.add(new BigDecimal(titulo.getCsllPercentual() == null ? "0" : titulo.getCsllPercentual().toString()));
        BigDecimal percentualCofins = new BigDecimal("0").setScale(casasMaior);
        percentualCofins = percentualCofins.add(new BigDecimal(titulo.getCofinsPercentual() == null ? "0" : titulo.getCofinsPercentual().toString()));
        BigDecimal percentualInss = new BigDecimal("0").setScale(casasMaior);
        percentualInss = percentualInss.add(new BigDecimal(titulo.getInssPercentual() == null ? "0" : titulo.getInssPercentual().toString()));
        BigDecimal percentualIcms = new BigDecimal("0").setScale(casasMaior);
        percentualIcms = percentualIcms.add(new BigDecimal(titulo.getPercentualIcms() == null ? "0" : titulo.getPercentualIcms().toString()));
        BigDecimal percentualIpi = new BigDecimal("0").setScale(casasMaior);
        percentualIpi = percentualIpi.add(new BigDecimal(titulo.getPercentualIpi() == null ? "0" : titulo.getPercentualIpi().toString()));
        BigDecimal percentualInssRetido = new BigDecimal("0").setScale(casasMaior);
        percentualInssRetido = percentualInssRetido.add(new BigDecimal(titulo.getInssRetidoPercentual() == null ? "0" : titulo.getInssRetidoPercentual().toString()));
        BigDecimal percentualCofinsRetido = new BigDecimal("0").setScale(casasMaior);
        percentualCofinsRetido = percentualCofinsRetido.add(new BigDecimal(titulo.getCofinsRetidoPercentual() == null ? "0" : titulo.getCofinsRetidoPercentual().toString()));
        BigDecimal percentualCsllRetido = new BigDecimal("0").setScale(casasMaior);
        percentualCsllRetido = percentualCsllRetido.add(new BigDecimal(titulo.getCsllRetidoPercentual() == null ? "0" : titulo.getCsllRetidoPercentual().toString()));
        BigDecimal percentualIrrfRetido = new BigDecimal("0").setScale(casasMaior);
        percentualIrrfRetido = percentualIrrfRetido.add(new BigDecimal(titulo.getIrrfRetidoPercentual() == null ? "0" : titulo.getIrrfRetidoPercentual().toString()));
        BigDecimal percentualPisRetido = new BigDecimal("0").setScale(casasMaior);
        percentualPisRetido = percentualPisRetido.add(new BigDecimal(titulo.getPisRetidoPercentual() == null ? "0" : titulo.getPisRetidoPercentual().toString()));
        percentualIrrf = new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString()).setScale(casasMaior, round).multiply(percentualIrrf).divide(new BigDecimal("100"), round);
        percentualIss = valor.multiply(percentualIss).divide(new BigDecimal("100"), round);
        percentualIssRetido = valor.multiply(percentualIssRetido).divide(new BigDecimal("100"), round);
        percentualPis = valor.multiply(percentualPis).divide(new BigDecimal("100"), round);
        percentualCsll = valor.multiply(percentualCsll).divide(new BigDecimal("100"), round);
        percentualCofins = valor.multiply(percentualCofins).divide(new BigDecimal("100"), round);
        percentualInss = valor.multiply(percentualInss).divide(new BigDecimal("100"), round);
        percentualIpi = valor.multiply(percentualIpi).divide(new BigDecimal("100"), round);
        percentualIcms = valor.multiply(percentualIcms).divide(new BigDecimal("100"), round);
        percentualInssRetido = valor.multiply(percentualInssRetido).divide(new BigDecimal("100"), round);
        percentualCofinsRetido = valor.multiply(percentualCofinsRetido).divide(new BigDecimal("100"), round);
        percentualCsllRetido = valor.multiply(percentualCsllRetido).divide(new BigDecimal("100"), round);
        percentualIrrfRetido = valor.multiply(percentualIrrfRetido).divide(new BigDecimal("100"), round);
        percentualPisRetido = valor.multiply(percentualPisRetido).divide(new BigDecimal("100"), round);
        percentualIrrf = percentualIrrf.setScale(casasMaior, round);
        percentualIss = percentualIss.setScale(casasMaior, round);
        percentualIssRetido = percentualIssRetido.setScale(casasMaior, round);
        percentualPis = percentualPis.setScale(casasMaior, round);
        percentualCsll = percentualCsll.setScale(casasMaior, round);
        percentualCofins = percentualCofins.setScale(casasMaior, round);
        percentualInss = percentualInss.setScale(casasMaior, round);
        percentualIpi = percentualIpi.setScale(casasMaior, round);
        percentualIcms = percentualIcms.setScale(casasMaior, round);
        percentualIssRetido = percentualIssRetido.setScale(casasMaior, round);
        percentualInssRetido = percentualInssRetido.setScale(casasMaior, round);
        percentualCofinsRetido = percentualCofinsRetido.setScale(casasMaior, round);
        percentualCsllRetido = percentualCsllRetido.setScale(casasMaior, round);
        percentualIrrfRetido = percentualIrrfRetido.setScale(casasMaior, round);
        percentualPisRetido = percentualPisRetido.setScale(casasMaior, round);
        if (percentualIrrf.doubleValue() < 0.0) {
            titulo.setIrrfValor(0.0);
        } else {
            titulo.setIrrfValor(percentualIrrf.doubleValue());
        }
        if (percentualIss.doubleValue() < 0.0) {
            titulo.setIssValor(0.0);
        } else {
            titulo.setIssValor(percentualIss.doubleValue());
        }
        if (percentualIssRetido.doubleValue() < 0.0) {
            titulo.setIssRetidoValor(0.0);
        } else {
            titulo.setIssRetidoValor(percentualIssRetido.doubleValue());
        }
        if (percentualPis.doubleValue() < 0.0) {
            titulo.setPisValor(0.0);
        } else {
            titulo.setPisValor(percentualPis.doubleValue());
        }
        if (percentualCsll.doubleValue() < 0.0) {
            titulo.setCsllValor(0.0);
        } else {
            titulo.setCsllValor(percentualCsll.doubleValue());
        }
        if (percentualCofins.doubleValue() < 0.0) {
            titulo.setCofinsValor(0.0);
        } else {
            titulo.setCofinsValor(percentualCofins.doubleValue());
        }
        if (percentualInss.doubleValue() < 0.0) {
            titulo.setInssValor(0.0);
        } else {
            titulo.setInssValor(percentualInss.doubleValue());
        }
        if (percentualIpi.doubleValue() < 0.0) {
            titulo.setValorIpi(0.0);
        } else {
            titulo.setValorIpi(percentualIpi.doubleValue());
        }
        if (percentualIcms.doubleValue() < 0.0) {
            titulo.setValorIcms(0.0);
        } else {
            titulo.setValorIcms(percentualIcms.doubleValue());
        }
        if (percentualIssRetido.doubleValue() < 0.0) {
            titulo.setIssRetidoValor(0.0);
        } else {
            titulo.setIssRetidoValor(percentualIssRetido.doubleValue());
        }
        if (percentualInssRetido.doubleValue() < 0.0) {
            titulo.setInssRetidoValor(0.0);
        } else {
            titulo.setInssRetidoValor(percentualInssRetido.doubleValue());
        }
        if (percentualCofinsRetido.doubleValue() < 0.0) {
            titulo.setCofinsRetidoValor(0.0);
        } else {
            titulo.setCofinsRetidoValor(percentualCofinsRetido.doubleValue());
        }
        if (percentualCsllRetido.doubleValue() < 0.0) {
            titulo.setCsllRetidoValor(0.0);
        } else {
            titulo.setCsllRetidoValor(percentualCsllRetido.doubleValue());
        }
        if (percentualIrrfRetido.doubleValue() < 0.0) {
            titulo.setIrrfRetidoValor(0.0);
        } else {
            titulo.setIrrfRetidoValor(percentualIrrfRetido.doubleValue());
        }
        if (percentualPisRetido.doubleValue() < 0.0) {
            titulo.setPisRetidoValor(0.0);
        } else {
            titulo.setPisRetidoValor(percentualPisRetido.doubleValue());
        }
        return titulo;
    }

    public static ReceberPagarBean calculaValorImposto(ReceberPagarBean titulo) {
        NotaFiscalVO voNota;
        int CASAS = ParametrosGerais.getCasasPrecoExame();
        int CASAS_MAIOR = 4;
        RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
        try {
            if (!(titulo instanceof ReceberPagarBean)) {
                throw new IncompatibleClassException(titulo, ReceberPagarBean.class);
            }
        }
        catch (IncompatibleClassException ice) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ice.getMessage(), ice.getStackTrace());
            return null;
        }
        BigDecimal valor = new BigDecimal("0").setScale(CASAS_MAIOR);
        valor = titulo.getNotaFiscal() != null ? valor.add(new BigDecimal((voNota = titulo.getNotaFiscal()).getImpostoAcumulado() == null ? "0" : voNota.getImpostoAcumulado().toString())) : valor.add(new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString()));
        BigDecimal percentualIrrf = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualIrrf = percentualIrrf.add(new BigDecimal(titulo.getIrrfPercentual() == null ? "0" : titulo.getIrrfPercentual().toString()));
        BigDecimal percentualIss = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualIss = percentualIss.add(new BigDecimal(titulo.getIssPercentual() == null ? "0" : titulo.getIssPercentual().toString()));
        BigDecimal percentualPis = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualPis = percentualPis.add(new BigDecimal(titulo.getPisPercentual() == null ? "0" : titulo.getPisPercentual().toString()));
        BigDecimal percentualCsll = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualCsll = percentualCsll.add(new BigDecimal(titulo.getCsllPercentual() == null ? "0" : titulo.getCsllPercentual().toString()));
        BigDecimal percentualCofins = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualCofins = percentualCofins.add(new BigDecimal(titulo.getCofinsPercentual() == null ? "0" : titulo.getCofinsPercentual().toString()));
        BigDecimal percentualInss = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualInss = percentualInss.add(new BigDecimal(titulo.getInssPercentual() == null ? "0" : titulo.getInssPercentual().toString()));
        BigDecimal percentualIcms = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualIcms = percentualIcms.add(new BigDecimal(titulo.getPercentualIcms() == null ? "0" : titulo.getPercentualIcms().toString()));
        BigDecimal percentualIpi = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualIpi = percentualIpi.add(new BigDecimal(titulo.getPercentualIpi() == null ? "0" : titulo.getPercentualIpi().toString()));
        BigDecimal percentualIssRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualIssRetido = percentualIssRetido.add(new BigDecimal(titulo.getIssRetidoPercentual() == null ? "0" : titulo.getIssRetidoPercentual().toString()));
        BigDecimal percentualInssRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualInssRetido = percentualInssRetido.add(new BigDecimal(titulo.getInssRetidoPercentual() == null ? "0" : titulo.getInssRetidoPercentual().toString()));
        BigDecimal percentualCofinsRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualCofinsRetido = percentualCofinsRetido.add(new BigDecimal(titulo.getCofinsRetidoPercentual() == null ? "0" : titulo.getCofinsRetidoPercentual().toString()));
        BigDecimal percentualCsllRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualCsllRetido = percentualCsllRetido.add(new BigDecimal(titulo.getCsllRetidoPercentual() == null ? "0" : titulo.getCsllRetidoPercentual().toString()));
        BigDecimal percentualIrrfRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualIrrfRetido = percentualIrrfRetido.add(new BigDecimal(titulo.getIrrfRetidoPercentual() == null ? "0" : titulo.getIrrfRetidoPercentual().toString()));
        BigDecimal percentualPisRetido = new BigDecimal("0").setScale(CASAS_MAIOR);
        percentualPisRetido = percentualPisRetido.add(new BigDecimal(titulo.getPisRetidoPercentual() == null ? "0" : titulo.getPisRetidoPercentual().toString()));
        percentualIrrf = new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString()).setScale(CASAS_MAIOR, ROUND).multiply(percentualIrrf).divide(new BigDecimal("100"), ROUND);
        percentualIss = valor.multiply(percentualIss).divide(new BigDecimal("100"), ROUND);
        percentualPis = valor.multiply(percentualPis).divide(new BigDecimal("100"), ROUND);
        percentualCsll = valor.multiply(percentualCsll).divide(new BigDecimal("100"), ROUND);
        percentualCofins = valor.multiply(percentualCofins).divide(new BigDecimal("100"), ROUND);
        percentualInss = valor.multiply(percentualInss).divide(new BigDecimal("100"), ROUND);
        percentualIpi = valor.multiply(percentualIpi).divide(new BigDecimal("100"), ROUND);
        percentualIcms = valor.multiply(percentualIcms).divide(new BigDecimal("100"), ROUND);
        percentualIssRetido = valor.multiply(percentualIssRetido).divide(new BigDecimal("100"), ROUND);
        percentualInssRetido = valor.multiply(percentualInssRetido).divide(new BigDecimal("100"), ROUND);
        percentualCofinsRetido = valor.multiply(percentualCofinsRetido).divide(new BigDecimal("100"), ROUND);
        percentualCsllRetido = valor.multiply(percentualCsllRetido).divide(new BigDecimal("100"), ROUND);
        percentualIrrfRetido = valor.multiply(percentualIrrfRetido).divide(new BigDecimal("100"), ROUND);
        percentualPisRetido = valor.multiply(percentualPisRetido).divide(new BigDecimal("100"), ROUND);
        percentualIrrf = percentualIrrf.setScale(CASAS_MAIOR, ROUND);
        percentualIss = percentualIss.setScale(CASAS_MAIOR, ROUND);
        percentualPis = percentualPis.setScale(CASAS_MAIOR, ROUND);
        percentualCsll = percentualCsll.setScale(CASAS_MAIOR, ROUND);
        percentualCofins = percentualCofins.setScale(CASAS_MAIOR, ROUND);
        percentualInss = percentualInss.setScale(CASAS_MAIOR, ROUND);
        percentualIpi = percentualIpi.setScale(CASAS_MAIOR, ROUND);
        percentualIcms = percentualIcms.setScale(CASAS_MAIOR, ROUND);
        percentualIssRetido = percentualIssRetido.setScale(CASAS_MAIOR, ROUND);
        percentualInssRetido = percentualInssRetido.setScale(CASAS_MAIOR, ROUND);
        percentualCofinsRetido = percentualCofinsRetido.setScale(CASAS_MAIOR, ROUND);
        percentualCsllRetido = percentualCsllRetido.setScale(CASAS_MAIOR, ROUND);
        percentualIrrfRetido = percentualIrrfRetido.setScale(CASAS_MAIOR, ROUND);
        percentualPisRetido = percentualPisRetido.setScale(CASAS_MAIOR, ROUND);
        if (percentualIrrf.doubleValue() < 0.0) {
            titulo.setIrrfValor(0.0);
        } else {
            titulo.setIrrfValor(percentualIrrf.doubleValue());
        }
        if (percentualIss.doubleValue() < 0.0) {
            titulo.setIssValor(0.0);
        } else {
            titulo.setIssValor(percentualIss.doubleValue());
        }
        if (percentualPis.doubleValue() < 0.0) {
            titulo.setPisValor(0.0);
        } else {
            titulo.setPisValor(percentualPis.doubleValue());
        }
        if (percentualCsll.doubleValue() < 0.0) {
            titulo.setCsllValor(0.0);
        } else {
            titulo.setCsllValor(percentualCsll.doubleValue());
        }
        if (percentualCofins.doubleValue() < 0.0) {
            titulo.setCofinsValor(0.0);
        } else {
            titulo.setCofinsValor(percentualCofins.doubleValue());
        }
        if (percentualInss.doubleValue() < 0.0) {
            titulo.setInssValor(0.0);
        } else {
            titulo.setInssValor(percentualInss.doubleValue());
        }
        if (percentualIpi.doubleValue() < 0.0) {
            titulo.setValorIpi(0.0);
        } else {
            titulo.setValorIpi(percentualIpi.doubleValue());
        }
        if (percentualIcms.doubleValue() < 0.0) {
            titulo.setValorIcms(0.0);
        } else {
            titulo.setValorIcms(percentualIcms.doubleValue());
        }
        if (percentualIssRetido.doubleValue() < 0.0) {
            titulo.setIssRetidoValor(0.0);
        } else {
            titulo.setIssRetidoValor(percentualIssRetido.doubleValue());
        }
        if (percentualInssRetido.doubleValue() < 0.0) {
            titulo.setInssRetidoValor(0.0);
        } else {
            titulo.setInssRetidoValor(percentualInssRetido.doubleValue());
        }
        if (percentualCofinsRetido.doubleValue() < 0.0) {
            titulo.setCofinsRetidoValor(0.0);
        } else {
            titulo.setCofinsRetidoValor(percentualCofinsRetido.doubleValue());
        }
        if (percentualCsllRetido.doubleValue() < 0.0) {
            titulo.setCsllRetidoValor(0.0);
        } else {
            titulo.setCsllRetidoValor(percentualCsllRetido.doubleValue());
        }
        if (percentualIrrfRetido.doubleValue() < 0.0) {
            titulo.setIrrfRetidoValor(0.0);
        } else {
            titulo.setIrrfRetidoValor(percentualIrrfRetido.doubleValue());
        }
        if (percentualPisRetido.doubleValue() < 0.0) {
            titulo.setPisRetidoValor(0.0);
        } else {
            titulo.setPisRetidoValor(percentualPisRetido.doubleValue());
        }
        return titulo;
    }

    public static boolean validarPlanosContasCentrosCusto(AbstractThreadBean bean) {
        if (bean instanceof ReceberPagarBean) {
            return FinanceiroUtil.validarPlanosContasCentrosCusto((ReceberPagarBean)bean);
        }
        return FinanceiroUtil.validarPlanosContasCentrosCusto((LancamentoBean)bean);
    }

    private static boolean validarPlanosContasCentrosCusto(ReceberPagarBean bean) {
        BigDecimal valorAux;
        int aux;
        bean.setPlanoContaErrado(false);
        bean.setCentroCustoErrado(false);
        if (bean.getPlanosContas() == null || bean.getPlanosContas().size() == 0) {
            bean.setPlanoContaNaoConfigurado(true);
        } else {
            bean.setPlanoContaNaoConfigurado(false);
        }
        if (bean.getPlanosContas() != null && bean.getPlanosContas().size() > 0) {
            aux = 0;
            HashSet planos = (HashSet)bean.getPlanosContas();
            for (AbstractThreadBean recPag : planos) {
                if (((ReceberPagarPlanoContaBean)recPag).isRemover()) continue;
                ++aux;
            }
            if (aux == 0) {
                bean.setPlanoContaNaoConfigurado(true);
            } else {
                bean.setPlanoContaNaoConfigurado(false);
            }
        }
        if (bean.getCentrosCusto() == null || bean.getCentrosCusto().size() == 0) {
            bean.setCentroCustoNaoConfigurado(true);
        } else {
            bean.setCentroCustoNaoConfigurado(false);
        }
        if (bean.getCentrosCusto() != null && bean.getCentrosCusto().size() > 0) {
            aux = 0;
            HashSet centros = (HashSet)bean.getCentrosCusto();
            for (AbstractThreadBean recPag : centros) {
                if (((ReceberPagarCentroCustoBean)recPag).isRemover()) continue;
                ++aux;
            }
            if (aux == 0) {
                bean.setCentroCustoNaoConfigurado(true);
            } else {
                bean.setCentroCustoNaoConfigurado(false);
            }
        }
        if ((bean.getPlanosContas() == null || bean.isPlanoContaNaoConfigurado()) && (bean.getCentrosCusto() == null || bean.isCentroCustoNaoConfigurado())) {
            return false;
        }
        if (bean.getValorTotal() == null) {
            FinanceiroUtil.atualizaTotal(bean);
        }
        BigDecimal totalTitulo = new BigDecimal(bean.getValorTotal());
        totalTitulo = totalTitulo.setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalPlano = new BigDecimal(0.0);
        BigDecimal totalCentro = new BigDecimal(0.0);
        if (!bean.isPlanoContaNaoConfigurado()) {
            for (ReceberPagarPlanoContaBean rppc : bean.getPlanosContas()) {
                if (rppc.isRemover()) continue;
                valorAux = new BigDecimal(rppc.getValor() == null ? 0.0 : rppc.getValor());
                if (rppc.getPlanoConta() != null && rppc.getPlanoConta().getOperacao() != null && rppc.getPlanoConta().getOperacao().equalsIgnoreCase("S")) {
                    if (bean.getTipo().equalsIgnoreCase("R")) {
                        totalPlano = totalPlano.subtract(valorAux);
                        continue;
                    }
                    totalPlano = totalPlano.add(valorAux);
                    continue;
                }
                if (bean.getTipo().equalsIgnoreCase("R")) {
                    totalPlano = totalPlano.add(valorAux);
                    continue;
                }
                totalPlano = totalPlano.subtract(valorAux);
            }
            if ((totalPlano = totalPlano.setScale(2, RoundingMode.HALF_UP)).doubleValue() != totalTitulo.doubleValue()) {
                bean.setPlanoContaErrado(true);
            }
        }
        if (!bean.isCentroCustoNaoConfigurado()) {
            for (ReceberPagarCentroCustoBean rpcc : bean.getCentrosCusto()) {
                if (rpcc.isRemover()) continue;
                valorAux = new BigDecimal(rpcc.getValor() == null ? 0.0 : rpcc.getValor());
                if (rpcc.getCentroCusto() != null && rpcc.getCentroCusto().getOperacao() != null && rpcc.getCentroCusto().getOperacao().equalsIgnoreCase("S")) {
                    if (bean.getTipo().equalsIgnoreCase("R")) {
                        totalCentro = totalCentro.subtract(valorAux);
                        continue;
                    }
                    totalCentro = totalCentro.add(valorAux);
                    continue;
                }
                if (bean.getTipo().equalsIgnoreCase("R")) {
                    totalCentro = totalCentro.add(valorAux);
                    continue;
                }
                totalCentro = totalCentro.subtract(valorAux);
            }
            if ((totalCentro = totalCentro.setScale(2, RoundingMode.HALF_UP)).doubleValue() != totalTitulo.doubleValue()) {
                bean.setCentroCustoErrado(true);
            }
        }
        return bean.isCentroCustoErrado() || bean.isPlanoContaErrado();
    }

    private static boolean validarPlanosContasCentrosCusto(LancamentoBean bean) {
        int aux;
        bean.setPlanoContaErrado(false);
        bean.setCentroCustoErrado(false);
        if (bean.getPlanosContas() == null || bean.getPlanosContas().size() == 0) {
            bean.setPlanoContaNaoConfigurado(true);
        } else {
            bean.setPlanoContaNaoConfigurado(false);
        }
        if (bean.getPlanosContas() != null && bean.getPlanosContas().size() > 0) {
            aux = 0;
            HashSet planos = (HashSet)bean.getPlanosContas();
            for (AbstractThreadBean lancto : planos) {
                if (((LancamentoPlanoContaBean)lancto).isRemover()) continue;
                ++aux;
            }
            if (aux == 0) {
                bean.setPlanoContaNaoConfigurado(true);
            } else {
                bean.setPlanoContaNaoConfigurado(false);
            }
        }
        if (bean.getCentrosCusto() == null || bean.getCentrosCusto().size() == 0) {
            bean.setCentroCustoNaoConfigurado(true);
        } else {
            bean.setCentroCustoNaoConfigurado(false);
        }
        if (bean.getCentrosCusto() != null && bean.getCentrosCusto().size() > 0) {
            aux = 0;
            HashSet centros = (HashSet)bean.getCentrosCusto();
            for (AbstractThreadBean lancto : centros) {
                if (((LancamentoCentroCustoBean)lancto).isRemover()) continue;
                ++aux;
            }
            if (aux == 0) {
                bean.setCentroCustoNaoConfigurado(true);
            } else {
                bean.setCentroCustoNaoConfigurado(false);
            }
        }
        if ((bean.getPlanosContas() == null || bean.isPlanoContaNaoConfigurado()) && (bean.getCentrosCusto() == null || bean.isCentroCustoNaoConfigurado())) {
            return false;
        }
        double totalTitulo = Funcoes.arredondar(bean.getValorTotal(), 2);
        BigDecimal totalPlano = new BigDecimal(0);
        BigDecimal totalCentro = new BigDecimal(0);
        if (!bean.isPlanoContaNaoConfigurado()) {
            for (LancamentoPlanoContaBean rppc : bean.getPlanosContas()) {
                if (rppc.isRemover()) continue;
                if (rppc.getPlanoConta() != null && rppc.getPlanoConta().getOperacao() != null && rppc.getPlanoConta().getOperacao().equalsIgnoreCase("S")) {
                    if (bean.getTipo().equalsIgnoreCase("C")) {
                        totalPlano = totalPlano.subtract(new BigDecimal(rppc.getValor()));
                        continue;
                    }
                    totalPlano = totalPlano.add(new BigDecimal(rppc.getValor()));
                    continue;
                }
                if (bean.getTipo().equalsIgnoreCase("C")) {
                    totalPlano = totalPlano.add(new BigDecimal(rppc.getValor()));
                    continue;
                }
                totalPlano = totalPlano.subtract(new BigDecimal(rppc.getValor()));
            }
            if ((totalPlano = totalPlano.setScale(2, RoundingMode.HALF_UP)).doubleValue() != totalTitulo) {
                bean.setPlanoContaErrado(true);
            }
        }
        if (!bean.isCentroCustoNaoConfigurado()) {
            for (LancamentoCentroCustoBean rpcc : bean.getCentrosCusto()) {
                if (rpcc.isRemover()) continue;
                if (rpcc.getCentroCusto() != null && rpcc.getCentroCusto().getOperacao().equalsIgnoreCase("S")) {
                    if (bean.getTipo().equalsIgnoreCase("C")) {
                        totalCentro = totalCentro.subtract(new BigDecimal(rpcc.getValor()));
                        continue;
                    }
                    totalCentro = totalCentro.add(new BigDecimal(rpcc.getValor()));
                    continue;
                }
                if (bean.getTipo().equalsIgnoreCase("C")) {
                    totalCentro = totalCentro.add(new BigDecimal(rpcc.getValor()));
                    continue;
                }
                totalCentro = totalCentro.subtract(new BigDecimal(rpcc.getValor()));
            }
            if ((totalCentro = totalCentro.setScale(2, RoundingMode.HALF_UP)).doubleValue() != totalTitulo) {
                bean.setCentroCustoErrado(true);
            }
        }
        return bean.isCentroCustoErrado() || bean.isPlanoContaErrado();
    }

    public static void insertCentroCusto(AbstractThreadBean bean, String filial, String filiais) throws Exception {
        if (bean instanceof ReceberPagarBean) {
            FinanceiroUtil.insertCentroCusto((ReceberPagarBean)bean, filial, filiais);
        } else {
            FinanceiroUtil.insertCentroCusto((LancamentoBean)bean, filial, filiais);
        }
    }

    private static void insertCentroCusto(ReceberPagarBean bean, String filial, String filiais) throws Exception {
        Set centros = bean.getCentrosCusto();
        if (centros != null) {
            Iterator it = centros.iterator();
            ReceberPagarCentroCustoService centroService = new ReceberPagarCentroCustoService();
            int codigo = 0;
            while (it.hasNext()) {
                ReceberPagarCentroCustoBean recpag = (ReceberPagarCentroCustoBean)it.next();
                if (recpag.getCodigo() == null || !(recpag.getCodigo().doubleValue() > (double)codigo)) continue;
                codigo = recpag.getCodigo();
            }
            ++codigo;
            for (ReceberPagarCentroCustoBean recpag : centros) {
                recpag.setReceberPagar((ReceberPagarVO)bean.toVO());
                if (recpag.isRemover()) {
                    centroService.delete(recpag, 2, null, null);
                    continue;
                }
                if (recpag.isInserir() && recpag.getValor() > 0.0) {
                    recpag.setCodigo(new Integer(codigo));
                    centroService.insert(recpag, 0, null, null);
                    ++codigo;
                    continue;
                }
                if (!recpag.isAlterar()) continue;
                centroService.update(recpag, 1, null, null);
            }
        }
    }

    public static void insertCentroCusto(LancamentoBean bean, String filial, String filiais) throws Exception {
        Set centros = bean.getCentrosCusto();
        if (centros != null) {
            Iterator it = centros.iterator();
            LancamentoCentroCustoService centroService = new LancamentoCentroCustoService();
            int codigo = 0;
            ++codigo;
            for (LancamentoCentroCustoBean lanc : centros) {
                lanc.setLancamento((LancamentoVO)bean.toVO());
                if (lanc.isRemover()) {
                    centroService.delete(lanc, 2, filial, filiais);
                    continue;
                }
                if (lanc.isInserir() && lanc.getValor() > 0.0) {
                    lanc.setEstacao(bean.getEstacao());
                    centroService.insert(lanc, 0, filial, filiais);
                    ++codigo;
                    continue;
                }
                if (!lanc.isAlterar()) continue;
                centroService.update(lanc, 1, filial, filiais);
            }
        }
    }

    public static AbstractThreadBean removerApropriacoes(LancamentoBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro, Double valor) {
        if (bean == null || tipoApropriacao == null || panelPlanoCentro == null) {
            return bean;
        }
        bean = FinanceiroUtil.removerApropriacoesPlanoConta(bean, tipoApropriacao, panelPlanoCentro);
        bean = FinanceiroUtil.removerApropriacoesCentroCusto(bean, tipoApropriacao, panelPlanoCentro, valor);
        return bean;
    }

    private static LancamentoBean removerApropriacoesPlanoConta(LancamentoBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ApropriaPlanoContaService servicePlano = new ApropriaPlanoContaService();
        Set<ApropriaPlanoContaBean> listaPlanos = null;
        try {
            listaPlanos = servicePlano.getPlanosContasApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), bean.getTipo(), null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel remover a Apropriacao Autom\u00e1tica (Plano de Contas) do campo: " + tipoApropriacao.toString() + ".\n" + e.getMessage(), e.getStackTrace());
        }
        if (listaPlanos == null || listaPlanos.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.removerApropriacoesPlanoConta(bean, tipoApropriacao.getPai(), panelPlanoCentro);
            }
            return bean;
        }
        for (ApropriaPlanoContaBean aux : listaPlanos) {
            if (aux.getPlanoConta() == null) continue;
            panelPlanoCentro.removerPlanoConta(aux.getPlanoConta().getReduzido(), FinanceiroUtil.getOrigemPadrao(bean.getFilial()).getCodigo());
        }
        return bean;
    }

    private static LancamentoBean removerApropriacoesCentroCusto(LancamentoBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro, Double valor) {
        ApropriaCentroCustoService serviceCentro = new ApropriaCentroCustoService();
        Set listaCentros = null;
        try {
            listaCentros = serviceCentro.getCentrosCustoApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), bean.getTipo(), null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel remover a Apropriacao Autom\u00e1tica (Centro de Custo) do campo: " + tipoApropriacao.toString() + ".\n" + e.getMessage(), e.getStackTrace());
        }
        if (listaCentros == null || listaCentros.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.removerApropriacoesCentroCusto(bean, tipoApropriacao.getPai(), panelPlanoCentro, valor);
            }
            return bean;
        }
        for (ApropriaCentroCustoBean aux : listaCentros) {
            if (aux.getCentroCusto() == null) continue;
            panelPlanoCentro.removerCentroCusto(aux.getCentroCusto().getReduzido(), FinanceiroUtil.getOrigemPadrao(bean.getFilial()).getCodigo(), valor);
        }
        return bean;
    }

    public static AbstractThreadBean removerApropriacoes(ReceberPagarBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro, Double valor) {
        if (bean == null || tipoApropriacao == null || panelPlanoCentro == null) {
            return bean;
        }
        bean = FinanceiroUtil.removerApropriacoesPlanoConta(bean, tipoApropriacao, panelPlanoCentro);
        bean = FinanceiroUtil.removerApropriacoesCentroCusto(bean, tipoApropriacao, panelPlanoCentro, valor);
        return bean;
    }

    private static ReceberPagarBean removerApropriacoesPlanoConta(ReceberPagarBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ApropriaPlanoContaService servicePlano = new ApropriaPlanoContaService();
        Set<ApropriaPlanoContaBean> listaPlanos = null;
        try {
            String tipoAux = bean.getTipo().equals("R") ? "C" : "D";
            listaPlanos = servicePlano.getPlanosContasApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel remover a Apropriacao Autom\u00e1tica (Plano de Contas) do campo: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaPlanos == null || listaPlanos.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.removerApropriacoesPlanoConta(bean, tipoApropriacao.getPai(), panelPlanoCentro);
            }
            return bean;
        }
        for (ApropriaPlanoContaBean aux : listaPlanos) {
            if (aux.getPlanoConta() == null) continue;
            panelPlanoCentro.removerPlanoConta(aux.getPlanoConta().getReduzido(), FinanceiroUtil.getOrigemPadrao(bean.getFilial()).getCodigo());
        }
        return bean;
    }

    private static ReceberPagarBean removerApropriacoesCentroCusto(ReceberPagarBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro, Double valor) {
        ApropriaCentroCustoService serviceCentro = new ApropriaCentroCustoService();
        Set listaCentros = null;
        try {
            String tipoAux = bean.getTipo().equals("R") ? "C" : "D";
            listaCentros = serviceCentro.getCentrosCustoApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel remover a Apropriacao Autom\u00e1tica (Centro de Custo) do campo: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaCentros == null || listaCentros.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.removerApropriacoesCentroCusto(bean, tipoApropriacao.getPai(), panelPlanoCentro, valor);
            }
            return bean;
        }
        for (ApropriaCentroCustoBean aux : listaCentros) {
            if (aux.getCentroCusto() == null) continue;
            panelPlanoCentro.removerCentroCusto(aux.getCentroCusto().getReduzido(), FinanceiroUtil.getOrigemPadrao(bean.getFilial()).getCodigo(), valor);
        }
        return bean;
    }

    public static boolean haApropriacoes(AbstractThreadBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro) {
        boolean haApropriacoes = true;
        if (bean == null || tipoApropriacao == null || panelPlanoCentro == null) {
            return haApropriacoes;
        }
        haApropriacoes = FinanceiroUtil.haApropriacoesPlanoConta(bean, tipoApropriacao, panelPlanoCentro);
        haApropriacoes = FinanceiroUtil.haApropriacoesCentroCusto(bean, tipoApropriacao, panelPlanoCentro) && haApropriacoes;
        return haApropriacoes;
    }

    private static boolean haApropriacoesPlanoConta(AbstractThreadBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ApropriaPlanoContaService servicePlano = new ApropriaPlanoContaService();
        Set<ApropriaPlanoContaBean> listaPlanos = null;
        String tipoAux = "";
        FilialVO filialAux = null;
        try {
            AbstractThreadBean aux;
            if (bean instanceof ReceberPagarBean) {
                aux = (ReceberPagarBean)bean;
                filialAux = ((ReceberPagarBean)aux).getFilial();
                tipoAux = ((ReceberPagarBean)aux).getTipo().equals("R") ? "C" : "D";
                listaPlanos = servicePlano.getPlanosContasApropriacao(((ReceberPagarBean)aux).getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            } else {
                aux = (LancamentoBean)bean;
                filialAux = ((LancamentoBean)aux).getFilial();
                tipoAux = ((LancamentoBean)aux).getTipo();
                listaPlanos = servicePlano.getPlanosContasApropriacao(((LancamentoBean)aux).getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Plano de Contas) de: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaPlanos == null || listaPlanos.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.haApropriacoesPlanoConta(bean, tipoApropriacao.getPai(), panelPlanoCentro);
            }
            return true;
        }
        Iterator it = listaPlanos.iterator();
        boolean haApropriacao = true;
        while (it.hasNext()) {
            ApropriaPlanoContaBean aux = (ApropriaPlanoContaBean)it.next();
            if (aux.getPlanoConta() == null || (haApropriacao = panelPlanoCentro.haPlanoConta(aux.getPlanoConta().getReduzido(), FinanceiroUtil.getOrigemPadrao(filialAux).getCodigo()) && haApropriacao)) continue;
            return false;
        }
        return haApropriacao;
    }

    public static boolean isApropriacaoPlanoContasConfigurada(AbstractThreadBean bean, TiposApropriacao tipoApropriacao) {
        Set<ApropriaPlanoContaBean> listaPlanos = null;
        ApropriaPlanoContaService servicePlano = new ApropriaPlanoContaService();
        String tipoAux = "";
        try {
            if (bean instanceof ReceberPagarBean) {
                ReceberPagarBean aux = (ReceberPagarBean)bean;
                tipoAux = aux.getTipo().equals("R") ? "C" : "D";
                listaPlanos = servicePlano.getPlanosContasApropriacao(aux.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            } else {
                LancamentoBean aux = (LancamentoBean)bean;
                tipoAux = aux.getTipo();
                listaPlanos = servicePlano.getPlanosContasApropriacao(aux.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Plano de Contas) de: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaPlanos != null && listaPlanos.size() > 0) {
            return true;
        }
        if (tipoApropriacao.getPai() != null) {
            return FinanceiroUtil.isApropriacaoPlanoContasConfigurada(bean, tipoApropriacao.getPai());
        }
        return false;
    }

    private static boolean haApropriacoesCentroCusto(AbstractThreadBean bean, TiposApropriacao tipoApropriacao, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ApropriaCentroCustoService serviceCentro = new ApropriaCentroCustoService();
        Set listaCentros = null;
        String tipoAux = "";
        FilialVO filialAux = null;
        try {
            AbstractThreadBean aux;
            if (bean instanceof ReceberPagarBean) {
                aux = (ReceberPagarBean)bean;
                filialAux = ((ReceberPagarBean)aux).getFilial();
                tipoAux = ((ReceberPagarBean)aux).getTipo().equals("R") ? "C" : "D";
                listaCentros = serviceCentro.getCentrosCustoApropriacao(((ReceberPagarBean)aux).getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            } else {
                aux = (LancamentoBean)bean;
                filialAux = ((LancamentoBean)aux).getFilial();
                tipoAux = ((LancamentoBean)aux).getTipo();
                listaCentros = serviceCentro.getCentrosCustoApropriacao(((LancamentoBean)aux).getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Centro de Custo) de: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaCentros == null || listaCentros.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.haApropriacoesCentroCusto(bean, tipoApropriacao.getPai(), panelPlanoCentro);
            }
            return true;
        }
        Iterator it = listaCentros.iterator();
        boolean haApropriacoes = true;
        while (it.hasNext()) {
            ApropriaCentroCustoBean aux = (ApropriaCentroCustoBean)it.next();
            if (aux.getCentroCusto() == null || (haApropriacoes = panelPlanoCentro.haCentroCusto(aux.getCentroCusto().getReduzido(), FinanceiroUtil.getOrigemPadrao(filialAux).getCodigo()) && haApropriacoes)) continue;
            return false;
        }
        return haApropriacoes;
    }

    public static boolean isApropriacaoCentroCustoConfigurada(AbstractThreadBean bean, TiposApropriacao tipoApropriacao) {
        ApropriaCentroCustoService serviceCentro = new ApropriaCentroCustoService();
        Set listaCentros = null;
        String tipoAux = "";
        try {
            if (bean instanceof ReceberPagarBean) {
                ReceberPagarBean aux = (ReceberPagarBean)bean;
                tipoAux = aux.getTipo().equals("R") ? "C" : "D";
                listaCentros = serviceCentro.getCentrosCustoApropriacao(aux.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            } else {
                LancamentoBean aux = (LancamentoBean)bean;
                tipoAux = aux.getTipo();
                listaCentros = serviceCentro.getCentrosCustoApropriacao(aux.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Centro de Custo) de: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaCentros != null && listaCentros.size() > 0) {
            return true;
        }
        if (tipoApropriacao.getPai() != null) {
            return FinanceiroUtil.isApropriacaoCentroCustoConfigurada(bean, tipoApropriacao.getPai());
        }
        return false;
    }

    public static AbstractThreadBean gerarApropriacoes(LancamentoBean bean, int tipoApropriacao) {
        PanelPlanoContaCentroCusto panel = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, 0L, 0L, bean.getFilial().getCodigo().toString());
        return FinanceiroUtil.gerarApropriacoes(bean, panel, tipoApropriacao);
    }

    private static AbstractThreadBean gerarApropriacoes(LancamentoBean bean, PanelPlanoContaCentroCusto panelPlanoCentro, int tipoApropriacao) {
        ContaCorrenteBean beanCC;
        boolean haApropCaixaPlano = false;
        boolean haApropCaixaCentro = false;
        if (tipoApropriacao != 4) {
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Juros, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Desconto, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Acrescimos, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Multas, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoDinheiro, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoCheque, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoCartaoDebito, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoCartaoCredito, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoChequeCaucao, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoChequePreDatado, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoPagamentoOnline, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoOutros, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoPromissoria, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.EstornoBalcao, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoBoleto, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoDebitoAutomatico, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoDepositoBancario, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoDescontoFolha, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoTransferencia, panelPlanoCentro, (Double)Double.MAX_VALUE);
            bean = (LancamentoBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.RecebimentoBalcaoPix, panelPlanoCentro, (Double)Double.MAX_VALUE);
            panelPlanoCentro.removerTodosPlanosContas();
            panelPlanoCentro.removerTodosCentrosCusto();
        }
        if ((beanCC = FinanceiroUtil.getContaCaixaPadrao(bean.getFilial().getCodigo().toString())) != null) {
            if (bean.getTipo().equalsIgnoreCase("C")) {
                if (beanCC.getPlanoReceita() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesPlanoConta(bean, beanCC.getPlanoReceita(), bean.getValorTotal(), panelPlanoCentro);
                    haApropCaixaPlano = true;
                }
                if (beanCC.getCentroCredito() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesCentroCusto(bean, beanCC.getCentroCredito(), bean.getValorTotal(), panelPlanoCentro);
                    haApropCaixaCentro = true;
                }
            } else {
                if (beanCC.getPlanoDespesa() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesPlanoConta(bean, beanCC.getPlanoDespesa(), bean.getValorTotal(), panelPlanoCentro);
                    haApropCaixaPlano = true;
                }
                if (beanCC.getCentroDebito() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesCentroCusto(bean, beanCC.getCentroDebito(), bean.getValorTotal(), panelPlanoCentro);
                    haApropCaixaCentro = true;
                }
            }
        }
        if (!haApropCaixaPlano || !haApropCaixaCentro) {
            if (tipoApropriacao == 1) {
                bean = (LancamentoBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Juros, bean.getValorJuro(), panelPlanoCentro, !haApropCaixaPlano, !haApropCaixaCentro);
                bean = (LancamentoBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Desconto, bean.getValorDesconto(), panelPlanoCentro, !haApropCaixaPlano, !haApropCaixaCentro);
                bean = (LancamentoBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Acrescimos, bean.getValorAcrescimo(), panelPlanoCentro, !haApropCaixaPlano, !haApropCaixaCentro);
                bean = (LancamentoBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Multas, bean.getValorMulta(), panelPlanoCentro, !haApropCaixaPlano, !haApropCaixaCentro);
            } else if (tipoApropriacao == 4) {
                TiposApropriacao apropria = null;
                apropria = bean.getTipoPagamento().equalsIgnoreCase("H") ? TiposApropriacao.RecebimentoBalcaoCheque : (bean.getTipoPagamento().equalsIgnoreCase("I") ? TiposApropriacao.RecebimentoBalcaoCartaoDebito : (bean.getTipoPagamento().equalsIgnoreCase("O") ? TiposApropriacao.RecebimentoBalcaoCartaoCredito : (bean.getTipoPagamento().equalsIgnoreCase("P") ? TiposApropriacao.RecebimentoBalcaoChequePreDatado : (bean.getTipoPagamento().equalsIgnoreCase("A") ? TiposApropriacao.RecebimentoBalcaoChequeCaucao : (bean.getTipoPagamento().equalsIgnoreCase("S") ? TiposApropriacao.RecebimentoBalcaoPromissoria : (bean.getTipoPagamento().equalsIgnoreCase("B") ? TiposApropriacao.RecebimentoBalcaoBoleto : (bean.getTipoPagamento().equalsIgnoreCase("W") ? TiposApropriacao.RecebimentoBalcaoTransferencia : (bean.getTipoPagamento().equalsIgnoreCase("Y") ? TiposApropriacao.RecebimentoBalcaoPix : (bean.getTipoPagamento().equalsIgnoreCase("N") ? TiposApropriacao.RecebimentoBalcaoPagamentoOnline : (bean.getTipoPagamento().equalsIgnoreCase("E") ? TiposApropriacao.RecebimentoBalcaoDepositoBancario : (bean.getTipoPagamento().equalsIgnoreCase("U") ? TiposApropriacao.RecebimentoBalcaoDebitoAutomatico : (bean.getTipoPagamento().equalsIgnoreCase("F") ? TiposApropriacao.RecebimentoBalcaoDescontoFolha : TiposApropriacao.RecebimentoBalcaoDinheiro))))))))))));
                if (bean.getTipoOrigem().equalsIgnoreCase("R")) {
                    apropria = TiposApropriacao.EstornoBalcao;
                }
                bean = (LancamentoBean)FinanceiroUtil.gerarApropriacoes(bean, apropria, bean.getValor(), panelPlanoCentro, !haApropCaixaPlano, !haApropCaixaCentro);
            } else if (tipoApropriacao == 4) {
                bean = (LancamentoBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.EstornoBalcao, bean.getValor(), panelPlanoCentro, !haApropCaixaPlano, !haApropCaixaCentro);
            }
        }
        return bean;
    }

    private static AbstractThreadBean gerarApropriacoes(LancamentoBean bean, TiposApropriacao tipoApropriacao, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro, boolean geraPlano, boolean geraCentro) {
        if (bean == null || tipoApropriacao == null || valor == null || valor <= 0.0) {
            return bean;
        }
        if (geraPlano) {
            bean = FinanceiroUtil.gerarApropriacoesPlanoConta(bean, tipoApropriacao, valor, panelPlanoCentro);
        }
        if (geraCentro) {
            bean = FinanceiroUtil.gerarApropriacoesCentroCusto(bean, tipoApropriacao, valor, panelPlanoCentro);
        }
        return bean;
    }

    private static LancamentoBean gerarApropriacoesPlanoConta(LancamentoBean bean, TiposApropriacao tipoApropriacao, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ApropriaPlanoContaService servicePlano = new ApropriaPlanoContaService();
        Set<ApropriaPlanoContaBean> listaPlanos = null;
        try {
            listaPlanos = servicePlano.getPlanosContasApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), bean.getTipo(), null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Plano de Contas) do campo: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaPlanos == null || listaPlanos.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.gerarApropriacoesPlanoConta(bean, tipoApropriacao.getPai(), valor, panelPlanoCentro);
            }
            return bean;
        }
        for (ApropriaPlanoContaBean aux : listaPlanos) {
            PlanoContaVO auxPlanoVo = aux.getPlanoConta();
            LancamentoPlanoContaBean lanctoPlano = new LancamentoPlanoContaBean();
            lanctoPlano.setEstacao(bean.getEstacao());
            lanctoPlano.setFilial(bean.getFilial());
            lanctoPlano.setLancamento((LancamentoVO)bean.toVO());
            lanctoPlano.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
            lanctoPlano.setPlanoConta(auxPlanoVo);
            lanctoPlano.setInserir(true);
            BigDecimal perc = new BigDecimal(aux.getPercentualApropriacao()).multiply(new BigDecimal(valor)).divide(new BigDecimal(100.0), RoundingMode.HALF_UP);
            perc = perc.setScale(2, RoundingMode.HALF_UP);
            lanctoPlano.setValor(perc.doubleValue());
            if (panelPlanoCentro == null) {
                panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, 0L, 0L, bean.getFilial().getCodigo().toString());
                panelPlanoCentro.adicionarPlanoConta(lanctoPlano, false, true);
                continue;
            }
            panelPlanoCentro.adicionarPlanoConta(lanctoPlano, false, true);
            bean.setPlanosContas(new HashSet<AbstractThreadBean>(panelPlanoCentro.getPlanoContas()));
        }
        return bean;
    }

    private static LancamentoBean gerarApropriacoesCentroCusto(LancamentoBean bean, TiposApropriacao tipoApropriacao, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ApropriaCentroCustoService serviceCentro = new ApropriaCentroCustoService();
        Set listaCentros = null;
        try {
            listaCentros = serviceCentro.getCentrosCustoApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), bean.getTipo(), null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Centro de Custo) do campo: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaCentros == null || listaCentros.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.gerarApropriacoesCentroCusto(bean, tipoApropriacao.getPai(), valor, panelPlanoCentro);
            }
            return bean;
        }
        for (ApropriaCentroCustoBean aux : listaCentros) {
            CentroCustoVO auxCentroVo = aux.getCentroCusto();
            LancamentoCentroCustoBean lanctoCentro = new LancamentoCentroCustoBean();
            lanctoCentro.setEstacao(bean.getEstacao());
            lanctoCentro.setFilial(bean.getFilial());
            lanctoCentro.setLancamento((LancamentoVO)bean.toVO());
            lanctoCentro.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
            lanctoCentro.setCentroCusto(auxCentroVo);
            lanctoCentro.setInserir(true);
            BigDecimal perc = new BigDecimal(aux.getPercentualApropriacao()).multiply(new BigDecimal(valor)).divide(new BigDecimal(100.0), RoundingMode.HALF_UP);
            perc = perc.setScale(2, RoundingMode.HALF_UP);
            lanctoCentro.setValor(perc.doubleValue());
            if (panelPlanoCentro == null) {
                panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, 0L, 0L, bean.getFilial().getCodigo().toString());
                panelPlanoCentro.adicionarCentroCusto(lanctoCentro, true);
                continue;
            }
            panelPlanoCentro.adicionarCentroCusto(lanctoCentro, true);
            bean.setCentrosCusto(new HashSet<AbstractThreadBean>(panelPlanoCentro.getCentrosCusto()));
        }
        return bean;
    }

    public static AbstractThreadBean gerarApropriacoes(AbstractThreadBean bean, PanelPlanoContaCentroCusto panelPlanoContaCentroCusto, int tipoApropriacao, ConvenioVO convenio) {
        if (bean instanceof ReceberPagarBean) {
            return FinanceiroUtil.gerarApropriacoes((ReceberPagarBean)bean, panelPlanoContaCentroCusto, tipoApropriacao, convenio);
        }
        return FinanceiroUtil.gerarApropriacoes((LancamentoBean)bean, panelPlanoContaCentroCusto, tipoApropriacao);
    }

    private static AbstractThreadBean gerarApropriacoes(ReceberPagarBean bean, PanelPlanoContaCentroCusto panelPlanoContaCentroCusto, int tipoApropriacao, ConvenioVO convenio) {
        boolean haApropCaixaPlano = false;
        boolean haApropCaixaCentro = false;
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Taxa, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosIRRF, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosISS, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosPIS, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosCSLL, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosCOFINS, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosINSS, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.FaturamentoConvenio, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Juros, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Desconto, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Acrescimos, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Multas, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.Frete, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosISSRetido, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosINSSRetido, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosCOFINSRetido, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosCSLLRetido, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosIRRFRetido, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        bean = (ReceberPagarBean)FinanceiroUtil.removerApropriacoes(bean, TiposApropriacao.ImpostosPISRetido, panelPlanoContaCentroCusto, (Double)Double.MAX_VALUE);
        panelPlanoContaCentroCusto.removerTodosPlanosContas();
        panelPlanoContaCentroCusto.removerTodosCentrosCusto();
        ContaCorrenteBean beanCC = FinanceiroUtil.getContaCaixaPadrao(bean.getFilial().getCodigo().toString());
        if (beanCC != null) {
            if (bean.getTipo().equalsIgnoreCase("R")) {
                if (beanCC.getPlanoReceita() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesPlanoConta(bean, beanCC.getPlanoReceita(), bean.getValorTotal(), panelPlanoContaCentroCusto);
                    haApropCaixaPlano = true;
                }
                if (beanCC.getCentroCredito() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesCentroCusto(bean, beanCC.getCentroCredito(), bean.getValorTotal(), panelPlanoContaCentroCusto);
                    haApropCaixaCentro = true;
                }
            } else {
                if (beanCC.getPlanoDespesa() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesPlanoConta(bean, beanCC.getPlanoDespesa(), bean.getValorTotal(), panelPlanoContaCentroCusto);
                    haApropCaixaPlano = true;
                }
                if (beanCC.getCentroDebito() != null) {
                    bean = FinanceiroUtil.gerarApropriacoesCentroCusto(bean, beanCC.getCentroDebito(), bean.getValorTotal(), panelPlanoContaCentroCusto);
                    haApropCaixaCentro = true;
                }
            }
        }
        if (!haApropCaixaPlano || !haApropCaixaCentro) {
            if (tipoApropriacao == 0) {
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Taxa, bean.getTaxa(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosIRRF, bean.getIrrfValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosISS, bean.getIssValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosPIS, bean.getPisValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCSLL, bean.getCsllValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCOFINS, bean.getCofinsValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosINSS, bean.getInssValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosISSRetido, bean.getIssRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosINSSRetido, bean.getInssRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCOFINSRetido, bean.getCofinsRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCSLLRetido, bean.getCsllRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosIRRFRetido, bean.getIrrfRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosPISRetido, bean.getPisRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
            } else if (tipoApropriacao == 2) {
                if (convenio != null && convenio.getLabApoio().booleanValue()) {
                    bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.FaturamentoApoio, bean.getValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, convenio);
                } else if (convenio != null && !convenio.getLabApoio().booleanValue()) {
                    bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.FaturamentoConvenio, bean.getValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, convenio);
                }
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosIRRF, bean.getIrrfValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosISS, bean.getIssValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosPIS, bean.getPisValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCSLL, bean.getCsllValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCOFINS, bean.getCofinsValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosINSS, bean.getInssValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosIPI, bean.getValorIpi(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosICMS, bean.getValorIcms(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Frete, bean.getValorFrete(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosISSRetido, bean.getIssRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosINSSRetido, bean.getInssRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCOFINSRetido, bean.getCofinsRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCSLLRetido, bean.getCsllRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosIRRFRetido, bean.getIrrfRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosPISRetido, bean.getPisRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
            } else if (tipoApropriacao == 3) {
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Taxa, bean.getTaxa() == null ? 0.0 : bean.getTaxa(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Juros, bean.getValorJuro() == null ? 0.0 : bean.getValorJuro(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Desconto, bean.getValorDesconto() == null ? 0.0 : bean.getValorDesconto(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Acrescimos, bean.getValorAcrescimo() == null ? 0.0 : bean.getValorAcrescimo(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.Multas, bean.getValorMulta() == null ? 0.0 : bean.getValorMulta(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosIRRF, bean.getIrrfValor() == null ? 0.0 : bean.getIrrfValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosISS, bean.getIssValor() == null ? 0.0 : bean.getIssValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosPIS, bean.getPisValor() == null ? 0.0 : bean.getPisValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCSLL, bean.getCsllValor() == null ? 0.0 : bean.getCsllValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCOFINS, bean.getCofinsValor() == null ? 0.0 : bean.getCofinsValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosINSS, bean.getInssValor() == null ? 0.0 : bean.getInssValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosISSRetido, bean.getIssRetidoValor() == null ? 0.0 : bean.getIssRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosINSSRetido, bean.getInssRetidoValor() == null ? 0.0 : bean.getInssRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCOFINSRetido, bean.getCofinsRetidoValor() == null ? 0.0 : bean.getCofinsRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosCSLLRetido, bean.getCsllRetidoValor() == null ? 0.0 : bean.getCsllRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosIRRFRetido, bean.getIrrfRetidoValor() == null ? 0.0 : bean.getIrrfRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes(bean, TiposApropriacao.ImpostosPISRetido, bean.getPisRetidoValor() == null ? 0.0 : bean.getPisRetidoValor(), panelPlanoContaCentroCusto, !haApropCaixaPlano, !haApropCaixaCentro, null);
            }
        }
        return bean;
    }

    private static AbstractThreadBean gerarApropriacoes(ReceberPagarBean bean, TiposApropriacao tipoApropriacao, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro, boolean geraPlano, boolean geraCentro, ConvenioVO convenio) {
        if (bean == null || tipoApropriacao == null || valor == null || valor <= 0.0) {
            return bean;
        }
        if (geraPlano) {
            bean = FinanceiroUtil.gerarApropriacoesPlanoConta(bean, tipoApropriacao, valor, panelPlanoCentro, convenio);
        }
        if (geraCentro) {
            bean = FinanceiroUtil.gerarApropriacoesCentroCusto(bean, tipoApropriacao, valor, panelPlanoCentro, convenio);
        }
        return bean;
    }

    private static ReceberPagarBean gerarApropriacoesPlanoConta(ReceberPagarBean bean, TiposApropriacao tipoApropriacao, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro, ConvenioVO convenio) {
        ApropriaPlanoContaService servicePlano = new ApropriaPlanoContaService();
        Set<ApropriaPlanoContaBean> listaPlanos = null;
        try {
            String tipoAux;
            String string = tipoAux = bean.getTipo().equals("R") ? "C" : "D";
            if (tipoApropriacao.getTipo() == TiposApropriacao.FaturamentoConvenioApoio.getTipo() || tipoApropriacao.getTipo() == TiposApropriacao.FaturamentoConvenio.getTipo() || tipoApropriacao.getTipo() == TiposApropriacao.FaturamentoApoio.getTipo()) {
                listaPlanos = servicePlano.getPlanosContasApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, convenio.getCodigo().toString());
            }
            if (listaPlanos == null || listaPlanos.size() == 0) {
                listaPlanos = servicePlano.getPlanosContasApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Plano de Contas) do campo: " + tipoApropriacao.toString() + ".\n" + e.getMessage(), e.getStackTrace());
        }
        if (listaPlanos == null || listaPlanos.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.gerarApropriacoesPlanoConta(bean, tipoApropriacao.getPai(), valor, panelPlanoCentro, convenio);
            }
            return bean;
        }
        for (ApropriaPlanoContaBean aux : listaPlanos) {
            PlanoContaVO auxPlanoVo = aux.getPlanoConta();
            ReceberPagarPlanoContaBean recPagPlano = new ReceberPagarPlanoContaBean();
            recPagPlano.setFilial(bean.getFilial());
            recPagPlano.setReceberPagar((ReceberPagarVO)bean.toVO());
            recPagPlano.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
            recPagPlano.setPlanoConta(auxPlanoVo);
            recPagPlano.setInserir(true);
            BigDecimal perc = new BigDecimal(aux.getPercentualApropriacao()).multiply(new BigDecimal(valor)).divide(new BigDecimal(100.0), RoundingMode.HALF_UP);
            perc = perc.setScale(2, RoundingMode.HALF_UP);
            recPagPlano.setValor(perc.doubleValue());
            if (panelPlanoCentro == null) {
                panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, bean.getFilial().getCodigo().toString());
                recPagPlano.setInserir(true);
                panelPlanoCentro.adicionarPlanoConta(recPagPlano, false, true);
                ArrayList<AbstractThreadBean> auxPlanos = panelPlanoCentro.getPlanoContas();
                for (int i = 0; i < auxPlanos.size(); ++i) {
                    bean.addPlanoConta((ReceberPagarPlanoContaBean)auxPlanos.get(i));
                }
                continue;
            }
            panelPlanoCentro.adicionarPlanoConta(recPagPlano, false, true);
            bean.setPlanosContas(new HashSet<AbstractThreadBean>(panelPlanoCentro.getPlanoContas()));
        }
        return bean;
    }

    private static ReceberPagarBean gerarApropriacoesCentroCusto(ReceberPagarBean bean, TiposApropriacao tipoApropriacao, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro, ConvenioVO convenio) {
        ApropriaCentroCustoService serviceCentro = new ApropriaCentroCustoService();
        Set listaCentros = null;
        try {
            String tipoAux;
            String string = tipoAux = bean.getTipo().equals("R") ? "C" : "D";
            if (convenio != null) {
                listaCentros = serviceCentro.getCentrosCustoApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, convenio.getCodigo().toString());
            }
            if (listaCentros == null || listaCentros.size() == 0) {
                listaCentros = serviceCentro.getCentrosCustoApropriacao(bean.getFilial().getCodigo().toString(), String.valueOf(tipoApropriacao.getTipo()), tipoAux, null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a Apropriacao Autom\u00e1tica (Centro de Custo) do campo: " + tipoApropriacao.toString(), e.getStackTrace());
        }
        if (listaCentros == null || listaCentros.size() == 0) {
            if (tipoApropriacao.getPai() != null) {
                return FinanceiroUtil.gerarApropriacoesCentroCusto(bean, tipoApropriacao.getPai(), valor, panelPlanoCentro, convenio);
            }
            return bean;
        }
        for (ApropriaCentroCustoBean aux : listaCentros) {
            CentroCustoVO auxCentroVo = aux.getCentroCusto();
            ReceberPagarCentroCustoBean recPagCentro = new ReceberPagarCentroCustoBean();
            recPagCentro.setFilial(bean.getFilial());
            recPagCentro.setReceberPagar((ReceberPagarVO)bean.toVO());
            recPagCentro.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
            recPagCentro.setCentroCusto(auxCentroVo);
            recPagCentro.setInserir(true);
            BigDecimal perc = new BigDecimal(aux.getPercentualApropriacao()).multiply(new BigDecimal(valor)).divide(new BigDecimal(100.0), RoundingMode.HALF_UP);
            perc = perc.setScale(2, RoundingMode.HALF_UP);
            recPagCentro.setValor(perc.doubleValue());
            if (panelPlanoCentro == null) {
                panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, bean.getFilial().getCodigo().toString());
                panelPlanoCentro.adicionarCentroCusto(recPagCentro, true);
                ArrayList<AbstractThreadBean> auxCentros = panelPlanoCentro.getCentrosCusto();
                for (int i = 0; i < auxCentros.size(); ++i) {
                    bean.addCentroCusto((ReceberPagarCentroCustoBean)auxCentros.get(i));
                }
                continue;
            }
            panelPlanoCentro.adicionarCentroCusto(recPagCentro, true);
            bean.setCentrosCusto(new HashSet<AbstractThreadBean>(panelPlanoCentro.getCentrosCusto()));
        }
        return bean;
    }

    private static AbstractThreadBean gerarApropriacoesPlanoConta(AbstractThreadBean bean, PlanoContaVO planoConta, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        if (bean != null) {
            bean = FinanceiroUtil.gerarApropriacoesPlanoConta(bean, planoConta, valor, panelPlanoCentro);
        }
        return bean;
    }

    private static ReceberPagarBean gerarApropriacoesPlanoConta(ReceberPagarBean bean, PlanoContaVO planoConta, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ReceberPagarPlanoContaBean recPagPlano = new ReceberPagarPlanoContaBean();
        recPagPlano.setFilial(bean.getFilial());
        recPagPlano.setReceberPagar((ReceberPagarVO)bean.toVO());
        recPagPlano.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
        recPagPlano.setPlanoConta(planoConta);
        recPagPlano.setInserir(true);
        recPagPlano.setValor(valor);
        if (panelPlanoCentro == null) {
            panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, bean.getFilial().getCodigo().toString());
            panelPlanoCentro.adicionarPlanoConta(recPagPlano, false, true);
            ArrayList<AbstractThreadBean> auxPlanos = panelPlanoCentro.getPlanoContas();
            for (int i = 0; i < auxPlanos.size(); ++i) {
                bean.addPlanoConta((ReceberPagarPlanoContaBean)auxPlanos.get(i));
            }
        } else {
            panelPlanoCentro.adicionarPlanoConta(recPagPlano, false, true);
            bean.setPlanosContas(new HashSet<AbstractThreadBean>(panelPlanoCentro.getPlanoContas()));
        }
        return bean;
    }

    private static LancamentoBean gerarApropriacoesPlanoConta(LancamentoBean bean, PlanoContaVO planoConta, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        LancamentoPlanoContaBean lanctoPlano = new LancamentoPlanoContaBean();
        lanctoPlano.setFilial(bean.getFilial());
        lanctoPlano.setLancamento((LancamentoVO)bean.toVO());
        lanctoPlano.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
        lanctoPlano.setPlanoConta(planoConta);
        lanctoPlano.setInserir(true);
        lanctoPlano.setValor(valor);
        lanctoPlano.setEstacao(bean.getEstacao());
        if (panelPlanoCentro == null) {
            panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, 0L, 0L, bean.getFilial().getCodigo().toString());
            panelPlanoCentro.adicionarPlanoConta(lanctoPlano, false, true);
            ArrayList<AbstractThreadBean> auxPlanos = panelPlanoCentro.getPlanoContas();
            for (int i = 0; i < auxPlanos.size(); ++i) {
                bean.addPlanoConta((LancamentoPlanoContaBean)auxPlanos.get(i));
            }
        } else {
            panelPlanoCentro.adicionarPlanoConta(lanctoPlano, false, true);
            bean.setPlanosContas(new HashSet<AbstractThreadBean>(panelPlanoCentro.getPlanoContas()));
        }
        return bean;
    }

    private static AbstractThreadBean gerarApropriacoesCentroCusto(AbstractThreadBean bean, CentroCustoVO centroCusto, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        if (bean != null) {
            bean = FinanceiroUtil.gerarApropriacoesCentroCusto(bean, centroCusto, valor, panelPlanoCentro);
        }
        return bean;
    }

    private static ReceberPagarBean gerarApropriacoesCentroCusto(ReceberPagarBean bean, CentroCustoVO centroCusto, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        ReceberPagarCentroCustoBean recPagCentro = new ReceberPagarCentroCustoBean();
        recPagCentro.setFilial(bean.getFilial());
        recPagCentro.setReceberPagar((ReceberPagarVO)bean.toVO());
        recPagCentro.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
        recPagCentro.setCentroCusto(centroCusto);
        recPagCentro.setInserir(true);
        recPagCentro.setValor(valor);
        if (panelPlanoCentro == null) {
            panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, bean.getFilial().getCodigo().toString());
            panelPlanoCentro.adicionarCentroCusto(recPagCentro, true);
            ArrayList<AbstractThreadBean> auxCentros = panelPlanoCentro.getCentrosCusto();
            for (int i = 0; i < auxCentros.size(); ++i) {
                bean.addCentroCusto((ReceberPagarCentroCustoBean)auxCentros.get(i));
            }
        } else {
            panelPlanoCentro.adicionarCentroCusto(recPagCentro, true);
            bean.setCentrosCusto(new HashSet<AbstractThreadBean>(panelPlanoCentro.getCentrosCusto()));
        }
        return bean;
    }

    private static LancamentoBean gerarApropriacoesCentroCusto(LancamentoBean bean, CentroCustoVO centroCusto, Double valor, PanelPlanoContaCentroCusto panelPlanoCentro) {
        LancamentoCentroCustoBean lanctoCentro = new LancamentoCentroCustoBean();
        lanctoCentro.setFilial(bean.getFilial());
        lanctoCentro.setLancamento((LancamentoVO)bean.toVO());
        lanctoCentro.setOrigem(FinanceiroUtil.getOrigemPadrao(bean.getFilial()));
        lanctoCentro.setCentroCusto(centroCusto);
        lanctoCentro.setInserir(true);
        lanctoCentro.setValor(valor);
        lanctoCentro.setEstacao(bean.getEstacao());
        if (panelPlanoCentro == null) {
            panelPlanoCentro = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, 0L, 0L, bean.getFilial().getCodigo().toString());
            panelPlanoCentro.adicionarCentroCusto(lanctoCentro, true);
            ArrayList<AbstractThreadBean> auxCentros = panelPlanoCentro.getCentrosCusto();
            for (int i = 0; i < auxCentros.size(); ++i) {
                bean.addCentroCusto((LancamentoCentroCustoBean)auxCentros.get(i));
            }
        } else {
            panelPlanoCentro.adicionarCentroCusto(lanctoCentro, true);
            bean.setCentrosCusto(new HashSet<AbstractThreadBean>(panelPlanoCentro.getCentrosCusto()));
        }
        return bean;
    }

    public static OrigemVO getOrigemPadrao(FilialVO filial) {
        if (filial == null) {
            return null;
        }
        try {
            return new OrigemService().getOrigemPadraoEstacao(filial);
        }
        catch (ThreadDaoException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Double getValorApropriacao(ReceberPagarBean bean, TiposApropriacao tipo) {
        Double juro = new Double(0.0);
        Double multa = new Double(0.0);
        Double acrescimo = new Double(0.0);
        Double desconto = new Double(0.0);
        juro = bean.getValorJuro() == null ? new Double(0.0) : bean.getValorJuro();
        multa = bean.getValorMulta() == null ? new Double(0.0) : bean.getValorMulta();
        acrescimo = bean.getValorAcrescimo() == null ? new Double(0.0) : bean.getValorAcrescimo();
        Double d = desconto = bean.getValorDesconto() == null ? new Double(0.0) : bean.getValorDesconto();
        if (tipo.equals((Object)TiposApropriacao.Nenhuma)) {
            return 0.0;
        }
        if (tipo.equals((Object)TiposApropriacao.Juros)) {
            return juro;
        }
        if (tipo.equals((Object)TiposApropriacao.Multas)) {
            return multa;
        }
        if (tipo.equals((Object)TiposApropriacao.Acrescimos)) {
            return acrescimo;
        }
        if (tipo.equals((Object)TiposApropriacao.Desconto)) {
            return desconto;
        }
        return new Double(0.0);
    }

    private static Double getValorApropriacao(LancamentoBean bean, TiposApropriacao tipo) {
        Double juro = new Double(0.0);
        Double multa = new Double(0.0);
        Double acrescimo = new Double(0.0);
        Double desconto = new Double(0.0);
        juro = bean.getValorJuro() == null ? new Double(0.0) : bean.getValorJuro();
        multa = bean.getValorMulta() == null ? new Double(0.0) : bean.getValorMulta();
        acrescimo = bean.getValorAcrescimo() == null ? new Double(0.0) : bean.getValorAcrescimo();
        Double d = desconto = bean.getValorDesconto() == null ? new Double(0.0) : bean.getValorDesconto();
        if (tipo.equals((Object)TiposApropriacao.Nenhuma)) {
            return 0.0;
        }
        if (tipo.equals((Object)TiposApropriacao.Juros)) {
            return juro;
        }
        if (tipo.equals((Object)TiposApropriacao.Multas)) {
            return multa;
        }
        if (tipo.equals((Object)TiposApropriacao.Acrescimos)) {
            return acrescimo;
        }
        if (tipo.equals((Object)TiposApropriacao.Desconto)) {
            return desconto;
        }
        return new Double(0.0);
    }

    public static void copiaPlanoConta(ReceberPagarBean origem, AbstractThreadBean destino, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        if (destino instanceof ReceberPagarBean) {
            FinanceiroUtil.copiaPlanoConta(origem, (ReceberPagarBean)destino, pnlPlanoCustoPagamento);
        } else {
            FinanceiroUtil.copiaPlanoConta(origem, (LancamentoBean)destino, pnlPlanoCustoPagamento);
        }
    }

    private static void copiaPlanoConta(ReceberPagarBean origem, LancamentoBean destino, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        HashSet planosTitulo = (HashSet)origem.getPlanosContas();
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        for (ReceberPagarPlanoContaBean aux : planosTitulo) {
            if (aux.isRemover()) continue;
            LancamentoPlanoContaBean novoPgto = new LancamentoPlanoContaBean();
            novoPgto.setInserir(true);
            novoPgto.setEstacao(estacao);
            novoPgto.setFilial(aux.getFilial());
            novoPgto.setLancamento((LancamentoVO)destino.toVO());
            novoPgto.setOrigem(aux.getOrigem());
            novoPgto.setPlanoConta(aux.getPlanoConta());
            novoPgto.setValor(aux.getValor());
            if (origem.getTipo().equals(Tipos.tipoReceberPagar("R"))) {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("C");
            } else {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("D");
            }
            pnlPlanoCustoPagamento.adicionarPlanoConta(novoPgto, false, true);
        }
        ArrayList<AbstractThreadBean> listaPlanos = null;
        listaPlanos = pnlPlanoCustoPagamento.getPlanoContas();
        if (listaPlanos != null) {
            for (int i = 0; i < listaPlanos.size(); ++i) {
                destino.addPlanoConta((LancamentoPlanoContaBean)listaPlanos.get(i));
            }
        }
    }

    private static void copiaPlanoConta(ReceberPagarBean origem, ReceberPagarBean destino, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        HashSet planosTitulo = (HashSet)origem.getPlanosContas();
        for (ReceberPagarPlanoContaBean aux : planosTitulo) {
            if (aux.isRemover()) continue;
            ReceberPagarPlanoContaBean novoPgto = new ReceberPagarPlanoContaBean();
            novoPgto.setInserir(true);
            novoPgto.setFilial(aux.getFilial());
            novoPgto.setReceberPagar((ReceberPagarVO)destino.toVO());
            novoPgto.setOrigem(aux.getOrigem());
            novoPgto.setPlanoConta(aux.getPlanoConta());
            novoPgto.setValor(aux.getValor());
            if (origem.getTipo().equals(Tipos.tipoReceberPagar("R"))) {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("C");
            } else {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("D");
            }
            pnlPlanoCustoPagamento.adicionarPlanoConta(novoPgto, false, true);
        }
        ArrayList<AbstractThreadBean> listaPlanos = null;
        listaPlanos = pnlPlanoCustoPagamento.getPlanoContas();
        if (listaPlanos != null) {
            for (int i = 0; i < listaPlanos.size(); ++i) {
                destino.addPlanoConta((ReceberPagarPlanoContaBean)listaPlanos.get(i));
            }
        }
    }

    public static void copiaCentroCusto(ReceberPagarBean origem, AbstractThreadBean destino, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        if (destino instanceof ReceberPagarBean) {
            FinanceiroUtil.copiaCentroCusto(origem, (ReceberPagarBean)destino, pnlPlanoCustoPagamento);
        } else {
            FinanceiroUtil.copiaCentroCusto(origem, (LancamentoBean)destino, pnlPlanoCustoPagamento);
        }
    }

    private static void copiaCentroCusto(ReceberPagarBean origem, LancamentoBean destino, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        HashSet centrosTitulo = (HashSet)origem.getCentrosCusto();
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        for (ReceberPagarCentroCustoBean aux : centrosTitulo) {
            if (aux.isRemover()) continue;
            LancamentoCentroCustoBean novoPgto = new LancamentoCentroCustoBean();
            novoPgto.setInserir(true);
            novoPgto.setEstacao(estacao);
            novoPgto.setFilial(aux.getFilial());
            novoPgto.setLancamento((LancamentoVO)destino.toVO());
            novoPgto.setOrigem(aux.getOrigem());
            novoPgto.setCentroCusto(aux.getCentroCusto());
            novoPgto.setPlanoConta(aux.getPlanoConta());
            novoPgto.setValor(aux.getValor());
            if (origem.getTipo().equals(Tipos.tipoReceberPagar("R"))) {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("C");
            } else {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("D");
            }
            pnlPlanoCustoPagamento.adicionarCentroCusto(novoPgto, true);
        }
        ArrayList<AbstractThreadBean> listaCentros = null;
        listaCentros = pnlPlanoCustoPagamento.getCentrosCusto();
        if (listaCentros != null) {
            for (int i = 0; i < listaCentros.size(); ++i) {
                destino.addCentroCusto((LancamentoCentroCustoBean)listaCentros.get(i));
            }
        }
    }

    private static void copiaCentroCusto(ReceberPagarBean origem, ReceberPagarBean destino, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        HashSet centrosTitulo = (HashSet)origem.getCentrosCusto();
        for (ReceberPagarCentroCustoBean aux : centrosTitulo) {
            if (aux.isRemover()) continue;
            ReceberPagarCentroCustoBean novoPgto = new ReceberPagarCentroCustoBean();
            novoPgto.setInserir(true);
            novoPgto.setFilial(aux.getFilial());
            novoPgto.setReceberPagar((ReceberPagarVO)destino.toVO());
            novoPgto.setOrigem(aux.getOrigem());
            novoPgto.setCentroCusto(aux.getCentroCusto());
            novoPgto.setPlanoConta(aux.getPlanoConta());
            novoPgto.setValor(aux.getValor());
            if (origem.getTipo().equals(Tipos.tipoReceberPagar("R"))) {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("C");
            } else {
                pnlPlanoCustoPagamento.setTipoDebitoCredito("D");
            }
            pnlPlanoCustoPagamento.adicionarCentroCusto(novoPgto, true);
        }
        ArrayList<AbstractThreadBean> listaCentros = null;
        listaCentros = pnlPlanoCustoPagamento.getCentrosCusto();
        if (listaCentros != null) {
            for (int i = 0; i < listaCentros.size(); ++i) {
                destino.addCentroCusto((ReceberPagarCentroCustoBean)listaCentros.get(i));
            }
        }
    }
}

