/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.Sequencia;
import jalis.laboratorio.util.Tabela;
import jalis.util.Funcoes;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ExportaFilialEmNuvem {
    public static void main(String[] args) {
        Variaveis.caminhoBanco = "jdbc:postgresql://localhost/jalis";
        Variaveis.filialPadrao = "1";
        if (args == null || args.length < 2 || !Funcoes.isNumeric(args[0]) || !Funcoes.isNumeric(args[1])) {
            System.out.println("Filiais incorretas");
            System.exit(0);
        }
        int filialOrigem = Integer.parseInt(args[0]);
        int filialDestino = Integer.parseInt(args[1]);
        boolean testar = ExportaFilialEmNuvem.temParametroTestar(args);
        System.out.println(String.format("Filial de origem: %s", args[0]));
        System.out.println(String.format("Filial de destino: %s", args[1]));
        ExportaFilialEmNuvem exporta = new ExportaFilialEmNuvem(filialOrigem, filialDestino, testar);
    }

    private static boolean temParametroTestar(String[] args) {
        boolean retorno = false;
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (!arg.equalsIgnoreCase("teste")) continue;
                retorno = true;
                break;
            }
        }
        return retorno;
    }

    public ExportaFilialEmNuvem(int filialOrigem, int filialDestino, boolean teste) {
        boolean origemExiste = this.filialExiste(filialOrigem);
        boolean destinoExiste = this.filialExiste(filialDestino);
        if (!origemExiste || !destinoExiste) {
            if (!origemExiste) {
                System.out.println("Filial de origem n\u00e3o localizada");
            }
            if (!destinoExiste) {
                System.out.println("Filial de destino n\u00e3o localizada");
            }
            System.exit(0);
        }
        System.out.println("\n\n== Iniciando exporta\u00e7\u00e3o ==\n\n");
        try {
            this.exportar(filialOrigem, filialDestino, teste);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filialExiste(int filial) {
        boolean retorno = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = Conexao.getStatement();
            rs = st.executeQuery("select fil_codigo from filiais_postocoleta where fil_codigo = " + filial);
            retorno = rs.next();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharResultSet(rs);
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return retorno;
    }

    private boolean exportar(int origem, int destino, boolean teste) throws SQLException {
        boolean retorno = false;
        Tabela[] tabelas = new Tabela[]{new Tabela("cidades"), new Tabela("bairro"), new Tabela("pais"), new Tabela("raca"), new Tabela("alahospital"), new Tabela("feriados"), new Tabela("principios"), new Tabela("metodologia"), new Tabela("banco"), new Tabela("especialidades"), new Tabela("series"), new Tabela("rota"), new Tabela("historicos"), new Tabela("coletas"), new Tabela("destino"), new Tabela("grupo"), new Tabela("tipomaterial"), new Tabela("especie"), new Tabela("situacao"), new Tabela("taxa"), new Tabela("tabelaprecoexames"), new Tabela("medicamentos"), new Tabela("medico"), new Tabela("celulaestoque"), new Tabela("agencia"), new Tabela("recipientes"), new Tabela("motivoscancelamentos"), new Tabela("exames"), new Tabela("tipomaterialcoleta"), new Tabela("examelayout"), new Tabela("examesreacao"), new Tabela("examessolucao"), new Tabela("formapagto"), new Tabela("centrocusto"), new Tabela("historicopadrao"), new Tabela("motivoalteracao"), new Tabela("categoriaprodutoalimentos"), new Tabela("origemnaoconformidade"), new Tabela("labexterno"), new Tabela("examesdb"), new Tabela("examesalvaro"), new Tabela("examematgrupo"), new Tabela("examessaomarcos"), new Tabela("materialexame"), new Tabela("produtoalimentos"), new Tabela("material"), new Tabela("materialcoleta"), new Tabela("entidade"), new Tabela("servico"), new Tabela("layout"), new Tabela("planoconta"), new Tabela("banhomaria"), new Tabela("salaatendimento"), new Tabela("geladeiras"), new Tabela("motivocontato"), new Tabela("convenios"), new Tabela("prioridade"), new Tabela("termoconsentimento"), new Tabela("prazoentrega"), new Tabela("estantes"), new Tabela("setores"), new Tabela("interface"), new Tabela("unidadesaude"), new Tabela("examesatitude"), new Tabela("examehistorico"), new Tabela("medicoespecialidades"), new Tabela("adicionalfatura"), new Tabela("examematconvenioprazo"), new Tabela("exameagrupaexameconvenio"), new Tabela("motivorecoleta"), new Tabela("examesrede"), new Tabela("examesbalague"), new Tabela("contacorrente"), new Tabela("modelotermoconsentimento"), new Tabela("examesprincipios"), new Tabela("examematinterface"), new Tabela("tabelaprecoexamesporte"), new Tabela("exameagrupasituacao"), new Tabela("origemplanocusto"), new Tabela("recipcoleta"), new Tabela("agrupasituacao"), new Tabela("procedencianaoconformidade"), new Tabela("examematcoletalabexterno"), new Tabela("conveniodesconto"), new Tabela("fichatecnicamaterial"), new Tabela("examessyslab"), new Tabela("paciente"), new Tabela("pacientemedicamento"), new Tabela("apropriaplanoconta"), new Tabela("examesdelta"), new Tabela("filialfatura"), new Tabela("examesjalis"), new Tabela("unidademedida"), new Tabela("medicocontato"), new Tabela("examesmatrix"), new Tabela("tagsresultadoanterior"), new Tabela("examelayoutmetodo"), new Tabela("medicoconvenio"), new Tabela("conveniosvencimento"), new Tabela("medicoconveniotiss"), new Tabela("examesetor"), new Tabela("conveniocotaexame"), new Tabela("examespardini"), new Tabela("examessergiofranco"), new Tabela("geladeirasprateleiras"), new Tabela("recipmaterial"), new Tabela("embalagemproduto"), new Tabela("formapagtoparcelas"), new Tabela("examematcoleta"), new Tabela("conveniocotaexamesituacao"), new Tabela("reciptriagem"), new Tabela("identificadorlamina"), new Tabela("conversaounidade"), new Tabela("conveniospreco"), new Tabela("saldocontas"), new Tabela("agrupaexameconvenio"), new Tabela("examematintdesmembrar"), new Tabela("destinoconvlayout"), new Tabela("examematcoletajalis"), new Tabela("conveniounidadesaude"), new Tabela("despcobranca"), new Tabela("servicoimposto"), new Tabela("examesmatconvenio"), new Tabela("detalhetabelapreco"), new Tabela("acaonaoconformidade"), new Tabela("detalhetabelaprecometodologia"), new Tabela("medprincipios")};
        Sequencia[] sequencias = new Sequencia[]{new Sequencia("historicos", "his_codigo"), new Sequencia("prazoentrega", "prz_codigo"), new Sequencia("materialcoleta", "mco_codigo"), new Sequencia("cidades", "cid_codigo"), new Sequencia("recipientes", "rec_codigo"), new Sequencia("metodologia", "met_codigo"), new Sequencia("layout", "lay_codigo"), new Sequencia("medicamentos", "mto_codigo"), new Sequencia("principios", "prc_codigo"), new Sequencia("situacao", "sit_codigo"), new Sequencia("tipomaterial", "tpm_codigo"), new Sequencia("tabelaprecoexames", "tpe_codigo"), new Sequencia("especialidades", "esp_codigo"), new Sequencia("prioridade", "pri_codigo"), new Sequencia("historicopadrao", "hpa_codigo"), new Sequencia("contacorrente", "cco_reduzido"), new Sequencia("convenios", "con_codigo"), new Sequencia("material", "mat_codigo"), new Sequencia("setores", "set_codigo"), new Sequencia("interface", "int_codigo"), new Sequencia("paciente", "pac_codigo"), new Sequencia("planoconta", "plc_reduzido"), new Sequencia("labexterno", "lae_codigo"), new Sequencia("geladeiras", "gel_codigo"), new Sequencia("estantes", "ett_codigo"), new Sequencia("raca", "rac_codigo"), new Sequencia("especie", "epc_codigo"), new Sequencia("formapagto", "fpg_codigo"), new Sequencia("centrocusto", "ccu_reduzido"), new Sequencia("motivoscancelamentos", "mov_codigo"), new Sequencia("entidade", "ent_codigo"), new Sequencia("servico", "svc_codigo"), new Sequencia("embalagemproduto", "emb_codigo"), new Sequencia("celulaestoque", "cel_codigo"), new Sequencia("rota", "rot_codigo"), new Sequencia("salaatendimento", "sal_codigo"), new Sequencia("tipomaterialcoleta", "tmc_codigo"), new Sequencia("motivoalteracao", "mva_codigo"), new Sequencia("motivocontato", "mct_codigo"), new Sequencia("banhomaria", "ban_codigo"), new Sequencia("acaonaoconformidade", "anc_codigo"), new Sequencia("procedencianaoconformidade", "pnc_codigo"), new Sequencia("pais", "pai_codigo"), new Sequencia("origemnaoconformidade", "onc_codigo"), new Sequencia("taxa", "tax_codigo"), new Sequencia("categoriaprodutoalimentos", "cpl_codigo"), new Sequencia("produtoalimentos", "pal_codigo"), new Sequencia("motivorecoleta", "mrc_codigo"), new Sequencia("termoconsentimento", "mtc_codigo")};
        Statement st = Conexao.getStatement();
        st.executeUpdate("set session_replication_role = replica");
        for (Tabela tabela : tabelas) {
            System.out.print(String.format("Inserido registros em %-30s", tabela.nome));
            String[] colunas = this.buscaColunasTabela(tabela.nome);
            if (colunas.length > 0) {
                StringBuilder cols = new StringBuilder();
                for (int i = 0; i < colunas.length; ++i) {
                    if (i > 0) {
                        cols.append(",");
                    }
                    cols.append(colunas[i]);
                }
                StringBuilder copyCols = new StringBuilder();
                for (int i = 0; i < colunas.length; ++i) {
                    if (i > 0) {
                        copyCols.append(",");
                    }
                    if (colunas[i].equalsIgnoreCase("fil_codigo")) {
                        copyCols.append(destino);
                        continue;
                    }
                    copyCols.append(colunas[i]);
                }
                StringBuilder buf = new StringBuilder("insert into ").append(tabela.nome).append("(").append(cols.toString()).append(") (select ").append(copyCols.toString()).append(" from ").append(tabela.nome).append(" where fil_codigo = ").append(origem).append(")");
                st.execute(buf.toString());
                System.out.println("\tOK\t\t" + String.valueOf(this.contaLinhas(tabela.nome, destino)));
                continue;
            }
            System.out.println(String.format("Sem colunas para exportar na tabela %s", tabela));
        }
        System.out.println("\n\n== Verificando valores de sequ\u00eancia ==\n");
        for (Sequencia seq : sequencias) {
            System.out.print(String.format("Validando %-30s", seq.sequencia));
            BigInteger maior = this.maiorCodigo(seq.sequencia, seq.pk, destino);
            String value = maior.toString();
            if (maior.compareTo(BigInteger.valueOf(0L)) > 0) {
                String tmp = seq.sequencia + "_" + String.valueOf(destino) + "_sequence";
                if (seq.sequencia.equals("paciente")) {
                    value = this.limpaValorSequenciaPaciente(maior.toString());
                }
                st.execute("select setval('" + tmp + "', " + value + ")");
            }
            System.out.println(value);
        }
        System.out.println("\n\n==Processo finalizado" + (teste ? " - ANULADO" : "") + "==");
        System.out.println("VERIFIQUE A SEQU\u00caNCIA DA TABELA DE PACIENTES");
        if (teste) {
            Conexao.anulaSQL();
        } else {
            Conexao.arquivaSQL();
        }
        return retorno;
    }

    private String[] buscaColunasTabela(String tabela) throws SQLException {
        ArrayList<String> retorno = new ArrayList<String>();
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name = '" + tabela + "'");
        while (rs.next()) {
            retorno.add(rs.getString(1));
        }
        rs.close();
        st.close();
        return retorno.toArray(new String[retorno.size()]);
    }

    private BigInteger contaLinhas(String tabela, int filial) throws SQLException {
        BigInteger retorno = BigInteger.valueOf(0L);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery("SELECT count(fil_codigo) FROM " + tabela + " WHERE fil_codigo = " + filial);
        if (rs.next()) {
            retorno = new BigInteger(rs.getString(1));
        }
        rs.close();
        st.close();
        return retorno;
    }

    private BigInteger maiorCodigo(String tabela, String pk, int filial) throws SQLException {
        BigInteger retorno = BigInteger.valueOf(0L);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery("SELECT coalesce(max(" + pk + "), 0) FROM " + tabela + " WHERE fil_codigo = " + filial);
        if (rs.next()) {
            retorno = new BigInteger(rs.getString(1));
        }
        rs.close();
        st.close();
        return retorno;
    }

    private String limpaValorSequenciaPaciente(String valor) {
        if (valor.length() >= 8 && !this.charIgual(valor.charAt(0), "0") && this.charIgual(valor.charAt(1), "0") && this.charIgual(valor.charAt(2), "0")) {
            return valor.substring(1);
        }
        return valor;
    }

    private boolean charIgual(char c, String s) {
        return String.valueOf(c).equalsIgnoreCase(s);
    }
}

