/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util;

import jalis.comum.Conexao;
import jalis.comum.ConexaoEmail;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaEmail;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.mensagens.VerificaMensagens;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.MapaResolverExpressoesUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class EmailUtil {
    private static final String LOGEMAIL = "logemail";
    public static final String STATUS_ENVIO_EMAIL_PROPOSTA = "status";
    public static final String SUCESSO_ENVIO_EMAIL_PROPOSTA = "sucesso";
    private static final String MENSAGEM_SEM_CONFIGURACAO_ENVIO = "Os dados de envio n\u00e3o foram configurados.";
    private static final String NOME_IMAGENS = "imagem";
    private static final String TAG_TROCA_IMG_CID = "<img src=\"cid:imagem";
    private static final String TAG_IMG_BASE_64 = "data:image/png;base64,";
    private static final String TAG_BASE_64 = "<img src=\"data:image/png;base64,";
    public static final int TIPO_BLOQUEAR_ANIVERSARIO = 1;
    public static final int TIPO_BLOQUEAR_RECOLETA = 2;
    public static final int TIPO_BLOQUEAR_EXAME_PRONTO = 3;
    private static PreparedStatement prstDadosEmail = null;
    private static PreparedStatement prstDadosPaciente = null;
    private static PreparedStatement prstDadosCotacao = null;
    private static PreparedStatement prstInsereLog = null;
    private static PreparedStatement prstAtualizaSituacaoLog = null;
    private static PreparedStatement prstExamesProntosRequisicao = null;
    private static PreparedStatement prstFilialEnviaEmailSenhaWeb = null;
    private static PreparedStatement prstAtualizaRequisicao = null;
    private static PreparedStatement prstBloqueioConvenio = null;
    private static PreparedStatement prstDadosFilialConvenioProposta = null;
    private static PreparedStatement prstDadosFilial = null;
    private static PreparedStatement prstDadosMedico = null;
    private static PreparedStatement prstAtualizaExameRequisicao = null;
    private static String sqlDadosEmail = null;
    private static String sqlDadosPaciente = null;
    private static String sqlInsereLog = null;
    private static String sqlAtualizaSituacaoLog = null;
    private static String sqlRequisicaoEnviouEmail = null;
    private static String sqlExamesProntosRequisicao = null;
    private static String sqlFilialEnviaEmailSenhaWeb = null;
    private static String sqlAtualizaRequisicao = null;
    private static String sqlBloqueiosEnvioEmailConvenio = null;
    private static String sqlDadosFilialConvenioProposta = null;
    private static String sqlDadosFilial = null;
    private static String sqlDadosMedico = null;
    private static String sqlPermiteEnviarEmail = null;
    private static String sqlAtualizaExameReqLog = null;

    public static boolean criarLogParaReenvioDeCotacao(String filial, String destino, String email, String assunto, String extensao, String paciente, String requisicao, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, String convenio, String entidade) throws Exception {
        EmailUtil.preparaStatementParaCotacao(filial, st);
        ResultSet rs = prstDadosCotacao.executeQuery();
        boolean rsValido = EmailUtil.validarResultSet(rs);
        if (!rsValido) {
            return false;
        }
        EmailUtil.prepararStatementInsertLogCotacao(filial, email, assunto, requisicao, paciente, tipoEmail, st, convenio, entidade);
        EmailUtil.informarDadosDoPdf(pdf);
        return EmailUtil.validaInsercaoDoLog(filial, destino, email, assunto, extensao, pdf, commitAutomatico, st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validaInsercaoDoLog(String filial, String destino, String email, String assunto, String extensao, byte[] pdf, boolean commitAutomatico, Statement st) throws Exception {
        int qtde = prstInsereLog.executeUpdate();
        boolean inserido = true;
        String sequencia = DBUtil.getSequencia(st, LOGEMAIL, String.valueOf(filial));
        if (qtde == 0) {
            if (commitAutomatico) {
                st.getConnection().rollback();
            }
            inserido = false;
        } else {
            if (commitAutomatico) {
                st.getConnection().commit();
            }
            PreparedStatement prstLogs = EmailUtil.prepararStatementLogEmail(filial, sequencia);
            try (ResultSet rsLog = null;){
                rsLog = prstLogs.executeQuery();
                if (!rsLog.next()) {
                    inserido = false;
                }
                if (!EmailUtil.enviaEmail(EmailUtil.buscaXmlConfiguracao(filial), destino, email, assunto, pdf, Integer.valueOf(filial), rsLog.getInt("codigoLog"), extensao)) {
                    EmailUtil.atualizaLog(Integer.valueOf(filial), Integer.valueOf(sequencia), "I", ConexaoEmail.getStatement());
                    inserido = false;
                }
            }
        }
        return inserido;
    }

    private static PreparedStatement prepararStatementLogEmail(String filial, String sequencia) throws SQLException {
        PreparedStatement prstLogs = EmailUtil.preaparaStatementLogProposta(filial, sequencia);
        return prstLogs;
    }

    private static void prepararStatementInsertLogCotacao(String filial, String email, String assunto, String requisicao, String paciente, TipoEmail tipoEmail, Statement st, String convenio, String entidade) throws SQLException {
        String sequencia = DBUtil.getSequencia(st, LOGEMAIL, String.valueOf(filial));
        prstInsereLog.setInt(1, Integer.parseInt(String.valueOf(filial)));
        prstInsereLog.setInt(2, Integer.parseInt(sequencia));
        prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
        prstInsereLog.setString(4, "O");
        prstInsereLog.setString(5, email);
        prstInsereLog.setString(6, email);
        prstInsereLog.setString(7, assunto);
        prstInsereLog.setObject(10, requisicao);
        prstInsereLog.setObject(11, null);
        prstInsereLog.setObject(12, tipoEmail.getCodigo());
        prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
        prstInsereLog.setObject(14, null);
        prstInsereLog.setObject(15, Integer.parseInt(entidade));
    }

    private static String getEmailCotacao(ResultSet rs, String email) {
        HashMap<String, Object> dadosHash = EmailUtil.getHashCamposFilial(rs);
        dadosHash.put("emailCotacao", email);
        return EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), dadosHash);
    }

    private static void preparaStatementParaCotacao(String filial, Statement st) throws SQLException {
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        prstDadosCotacao = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosFilial);
        prstDadosCotacao.setInt(1, Integer.valueOf(filial));
    }

    public static boolean criarLogParaReenvioComMedico(String filial, String requisicao, String paciente, String destino, String email, String assunto, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta) throws Exception {
        ResultSet medico = EmailUtil.buscarMedico(filial, requisicao);
        EmailUtil.prepararStatementReenvioEmailMedico(filial, medico.getString("med_crm"), medico.getString("med_uf"));
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        ResultSet rs = prstDadosMedico.executeQuery();
        if (!rs.next()) {
            return false;
        }
        String sequencia = DBUtil.getSequencia(st, LOGEMAIL, filial.toString());
        EmailUtil.prepararStatementInserirLogMedico(filial, requisicao, paciente, email, assunto, tipoEmail, destino, sequencia);
        EmailUtil.informarDadosDoPdf(pdf);
        int qtde = prstInsereLog.executeUpdate();
        if (qtde == 0) {
            if (commitAutomatico) {
                st.getConnection().rollback();
            }
            return false;
        }
        if (commitAutomatico) {
            st.getConnection().commit();
        }
        return true;
    }

    private static ResultSet buscarMedico(String filial, String requisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select med_crm, med_uf from requisicao ");
        sql.append("where fil_codigo = ").append(filial);
        sql.append(" and req_codigo = ").append(requisicao);
        Statement st = Conexao.getStatement();
        return Conexao.executeQuery(st, sql);
    }

    private static void prepararStatementInserirLogMedico(String filial, String requisicao, String paciente, String email, String assunto, TipoEmail tipoEmail, String enderecoEmail, String sequencia) throws SQLException {
        prstInsereLog.setInt(1, Integer.parseInt(filial));
        prstInsereLog.setInt(2, Integer.parseInt(sequencia));
        prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
        prstInsereLog.setString(4, "E");
        prstInsereLog.setString(5, enderecoEmail);
        prstInsereLog.setString(6, email);
        prstInsereLog.setString(7, assunto);
        prstInsereLog.setObject(10, requisicao);
        prstInsereLog.setInt(11, Integer.parseInt(paciente));
        prstInsereLog.setObject(12, tipoEmail.getCodigo());
        prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
        prstInsereLog.setObject(14, null);
        prstInsereLog.setObject(15, null);
    }

    private static void prepararStatementReenvioEmailMedico(String filial, String crmMedicoSenhaWeb, String ufMedico) throws SQLException {
        if (!Funcoes.textoVazio(crmMedicoSenhaWeb)) {
            prstDadosMedico.setInt(1, Integer.parseInt(filial));
            prstDadosMedico.setString(2, crmMedicoSenhaWeb);
            prstDadosMedico.setString(3, ufMedico);
        }
    }

    public static boolean criarLogParaReenvioDeProposta(String filial, String paciente, String destino, String email, String assunto, String extensao, String requisicao, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta, String convenio, String entCodigo) throws Exception {
        String sequencia = DBUtil.getSequencia(st, LOGEMAIL, filial.toString());
        EmailUtil.prepararStatementParaReenvioLogProposta(filial, paciente, st, isConvenioProposta);
        EmailUtil.prepararInsereLogReenvioProposta(filial, paciente, destino, email, assunto, requisicao, pdf, tipoEmail, st, sequencia, convenio, entCodigo);
        boolean logCriado = EmailUtil.validarLogCriado(filial, pdf, commitAutomatico, st, sequencia, destino, email, assunto, extensao);
        return logCriado;
    }

    private static void prepararInsereLogReenvioProposta(String filial, String paciente, String destino, String email, String assunto, String requisicao, byte[] pdf, TipoEmail tipoEmail, Statement st, String sequencia, String convenio, String entCodigo) throws SQLException {
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        prstInsereLog.setInt(1, Integer.parseInt(filial));
        prstInsereLog.setInt(2, Integer.parseInt(sequencia));
        prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
        prstInsereLog.setString(4, "O");
        prstInsereLog.setString(5, destino);
        prstInsereLog.setString(6, email);
        prstInsereLog.setString(7, assunto);
        prstInsereLog.setObject(10, requisicao);
        prstInsereLog.setInt(11, Integer.parseInt(paciente));
        prstInsereLog.setObject(12, tipoEmail.getCodigo());
        prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
        if (!Funcoes.textoVazio(convenio)) {
            prstInsereLog.setInt(14, Integer.parseInt(convenio));
        } else {
            prstInsereLog.setObject(14, null);
        }
        prstInsereLog.setObject(15, null);
        EmailUtil.informarDadosDoPdf(pdf);
    }

    private static void prepararStatementParaReenvioLogProposta(String filial, String paciente, Statement st, boolean isConvenioProposta) throws SQLException {
        EmailUtil.escolherStatemente(paciente, st, isConvenioProposta);
        EmailUtil.montarParametrosDoStatement(filial, paciente, isConvenioProposta);
    }

    private static void montarParametrosDoStatement(String filial, String paciente, boolean isConvenioProposta) throws SQLException {
        if (!isConvenioProposta) {
            if (!Funcoes.textoVazio(paciente)) {
                prstDadosPaciente.setInt(1, Integer.parseInt(filial));
                prstDadosPaciente.setInt(2, Integer.parseInt(paciente));
            } else {
                prstDadosFilial.setInt(1, Integer.parseInt(filial));
            }
        } else {
            prstDadosFilialConvenioProposta.setInt(1, Integer.parseInt(filial));
            prstDadosFilialConvenioProposta.setInt(2, Integer.parseInt(paciente));
        }
    }

    private static void escolherStatemente(String paciente, Statement st, boolean isConvenioProposta) throws SQLException {
        if (!isConvenioProposta) {
            if (!Funcoes.textoVazio(paciente)) {
                prstDadosPaciente = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
            } else {
                prstDadosFilial = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosFilial);
            }
        } else {
            prstDadosFilialConvenioProposta = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosFilialConvenioProposta);
        }
    }

    private static boolean validarLogCriado(String filial, byte[] pdf, boolean commitAutomatico, Statement st, String sequencia, String destino, String email, String assunto, String extensao) throws Exception {
        PreparedStatement prstLogs;
        ResultSet rsLog;
        int qtde = prstInsereLog.executeUpdate();
        if (qtde == 0) {
            if (commitAutomatico) {
                st.getConnection().rollback();
            }
            return false;
        }
        if (commitAutomatico) {
            st.getConnection().commit();
        }
        if (!(rsLog = (prstLogs = EmailUtil.preaparaStatementLogProposta(filial, sequencia)).executeQuery()).next()) {
            return false;
        }
        if (!EmailUtil.enviaEmail(EmailUtil.buscaXmlConfiguracao(filial), destino, email, assunto, pdf, Integer.valueOf(filial), rsLog.getInt("codigoLog"), extensao)) {
            EmailUtil.atualizaLog(Integer.valueOf(filial), Integer.valueOf(sequencia), "I", ConexaoEmail.getStatement());
            return false;
        }
        return true;
    }

    private static String buscaXmlConfiguracao(String filial) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_configuracaoemail as xml from filiais_postocoleta ");
        sql.append("where fil_codigo = ").append(filial);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getString("xml");
        }
        return null;
    }

    private static PreparedStatement preaparaStatementLogProposta(String filial, String sequencia) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,ema_codigo as codigoLog ");
        buf.append("       ,ema_datahora as dataHora ");
        buf.append("       ,ema_situacao as situacao ");
        buf.append("       ,ema_email as enderecoEmail ");
        buf.append("       ,ema_mensagem as mensagemEmail ");
        buf.append("       ,ema_assunto as assuntoEmail ");
        buf.append("       ,ema_anexo as pdf ");
        buf.append("       ,ema_extensao as extensao ");
        buf.append("   from logemail ");
        buf.append("  where ema_codigo = ? and fil_codigo = ? ");
        buf.append("  order by ema_datahora ");
        buf.append("          ,fil_codigo ");
        buf.append("          ,ema_codigo ");
        PreparedStatement prstLogs = ConexaoEmail.getPreparedStatement(buf.toString());
        prstLogs.setInt(1, Integer.valueOf(sequencia));
        prstLogs.setInt(2, Integer.valueOf(filial));
        return prstLogs;
    }

    private static void prepararStatementParaReenvioDaProposta(String filial, String paciente, String email, String assunto, String requisicao, TipoEmail tipoEmail, String enderecoEmail, String sequencia) throws SQLException {
        prstInsereLog.setInt(1, Integer.parseInt(filial));
        prstInsereLog.setInt(2, Integer.parseInt(sequencia));
        prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
        prstInsereLog.setString(4, "O");
        prstInsereLog.setString(5, enderecoEmail);
        prstInsereLog.setString(6, email);
        prstInsereLog.setString(7, assunto);
        prstInsereLog.setObject(10, requisicao);
        prstInsereLog.setInt(11, Integer.parseInt(paciente));
        prstInsereLog.setObject(12, tipoEmail.getCodigo());
        prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
        prstInsereLog.setObject(14, null);
        prstInsereLog.setObject(15, null);
    }

    private static ResultSet executarStatementeReenvioProposta(String paciente, boolean isConvenioProposta) throws SQLException {
        ResultSet rs = !isConvenioProposta ? (!Funcoes.textoVazio(paciente) ? prstDadosPaciente.executeQuery() : prstDadosFilial.executeQuery()) : prstDadosFilialConvenioProposta.executeQuery();
        return rs;
    }

    public static boolean criarLogParaReenvioComRequisicao(String filial, String requisicao, String destino, String email, String assunto, TipoEmail tipoEmail, byte[] pdf, boolean commitAutomatico, Statement st) throws Exception {
        EmailUtil.validarParametros(filial, requisicao, tipoEmail);
        EmailUtil.prepararStatementeDadosEmail(filial, requisicao, st);
        EmailUtil.prepararStatementDadosExameRequisicao(filial, requisicao, st);
        ResultSet rs = prstDadosEmail.executeQuery();
        boolean osDadosSaoValidos = EmailUtil.validarDadosDoEmail(tipoEmail, st, rs);
        if (!osDadosSaoValidos) {
            return false;
        }
        String codigoPaciente = rs.getString("codigoPaciente");
        EmailUtil.prepararStatementDeInsercao(filial, requisicao, tipoEmail, st, email, assunto, codigoPaciente, destino);
        EmailUtil.informarDadosDoPdf(null);
        boolean foiInserido = EmailUtil.verificaInsercao(commitAutomatico, st);
        if (!foiInserido) {
            return false;
        }
        EmailUtil.comitarAlteracoes(commitAutomatico, st);
        return true;
    }

    private static boolean validarDadosDoEmail(TipoEmail tipoEmail, Statement st, ResultSet rs) throws SQLException, Exception {
        boolean resultSetEhValido = EmailUtil.validarResultSet(rs);
        boolean tipoEmailValido = EmailUtil.validarTipoDeEmail(rs, st, tipoEmail);
        return resultSetEhValido && tipoEmailValido;
    }

    private static void comitarAlteracoes(boolean commitAutomatico, Statement st) throws SQLException {
        if (commitAutomatico) {
            st.getConnection().commit();
        }
    }

    private static boolean verificaInsercao(boolean commitAutomatico, Statement st) throws SQLException {
        if (prstInsereLog.executeUpdate() == 0) {
            if (commitAutomatico) {
                st.getConnection().rollback();
            }
            return false;
        }
        if (prstAtualizaExameRequisicao.executeUpdate() == 0) {
            if (commitAutomatico) {
                st.getConnection().rollback();
            }
            return false;
        }
        return true;
    }

    private static void informarDadosDoPdf(byte[] pdf) throws SQLException {
        if (pdf != null) {
            LargeObjectManager lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
            long oid = lobj.createLO(393216);
            LargeObject obj = lobj.open(oid, 131072);
            obj.write(pdf);
            obj.close();
            prstInsereLog.setLong(8, oid);
            prstInsereLog.setString(9, "P");
        } else {
            prstInsereLog.setObject(8, null);
            prstInsereLog.setObject(9, null);
        }
    }

    private static void prepararStatementDeInsercao(String codigoFilial, String codigoRequisicao, TipoEmail tipoEmail, Statement st, String email, String assunto, String codigoPaciente, String emailEnviar) throws SQLException {
        String sequencia = DBUtil.getSequencia(st, LOGEMAIL, codigoFilial.toString());
        prstInsereLog.setInt(1, Integer.parseInt(codigoFilial));
        prstInsereLog.setInt(2, Integer.parseInt(sequencia));
        prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
        prstInsereLog.setString(4, "E");
        prstInsereLog.setString(5, emailEnviar);
        prstInsereLog.setString(6, email);
        prstInsereLog.setString(7, assunto);
        prstInsereLog.setInt(10, Integer.parseInt(codigoRequisicao));
        prstInsereLog.setInt(11, Integer.parseInt(codigoPaciente));
        prstInsereLog.setObject(12, tipoEmail.getCodigo());
        prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
        prstInsereLog.setObject(14, null);
        prstInsereLog.setObject(15, null);
    }

    private static String extraiAssuntoDoResultSet(ResultSet rs, Statement st, TipoEmail tipoEmail) throws Exception {
        String assunto;
        switch (tipoEmail) {
            case ANIVERSARIO: {
                assunto = rs.getString("assuntoAniversario");
                break;
            }
            case RESULTADO: {
                assunto = rs.getString("assuntoResultado");
                break;
            }
            case SENHA_WEB: {
                assunto = rs.getString("assuntoSenhaWeb");
                break;
            }
            case RECOLETA: {
                assunto = rs.getString("assuntoRecoleta");
                break;
            }
            case REQUISICAO: {
                assunto = rs.getString("assuntoRequisicao");
                break;
            }
            case PROPOSTA: {
                assunto = rs.getString("assuntoProposta");
                break;
            }
            case ATRASO_ENTREGA: {
                assunto = rs.getString("assuntoResultadoAtrasado");
                break;
            }
            default: {
                throw new Exception("TipoEmail n\u00e3o foi encontrado.");
            }
        }
        return assunto;
    }

    private static Set<String> extrairListaDeEmailsDoResultSet(ResultSet rs) throws SQLException {
        ArrayList<String> listaEmails;
        HashSet<String> emails = new HashSet<String>();
        if (!Funcoes.textoVazio(rs.getString("enderecoEmailPaciente")) && (listaEmails = StringUtil.explode(rs.getString("enderecoEmailPaciente"), ";, ")) != null) {
            emails.addAll(listaEmails);
        }
        return emails;
    }

    private static boolean validarTipoDeEmail(ResultSet rs, Statement st, TipoEmail tipoEmail) throws Exception {
        if (tipoEmail.equals((Object)TipoEmail.ANIVERSARIO)) {
            if (!EmailUtil.podeEnviarEmailAniversario(rs, st)) {
                return false;
            }
        } else if (tipoEmail.equals((Object)TipoEmail.RECOLETA)) {
            if (!EmailUtil.podeEnviarEmailRecoleta(rs, st)) {
                return false;
            }
        } else if (tipoEmail.equals((Object)TipoEmail.RESULTADO)) {
            if (!EmailUtil.podeReenviarEmailResultado(rs, st)) {
                return false;
            }
            if (rs.getBoolean("emailResultadoEnviado")) {
                return false;
            }
        } else if (tipoEmail.equals((Object)TipoEmail.SENHA_WEB) ? !EmailUtil.podeEnviarEmailSenhaWeb(rs) : (tipoEmail.equals((Object)TipoEmail.REQUISICAO) ? !EmailUtil.podeEnviarEmailRequisicao(rs) : (tipoEmail.equals((Object)TipoEmail.PROPOSTA) ? !EmailUtil.podeEnviarEmailRequisicao(rs) : tipoEmail.equals((Object)TipoEmail.ATRASO_ENTREGA) && !EmailUtil.podeEnviarEmailResultadoAtrasado(rs)))) {
            return false;
        }
        return true;
    }

    private static boolean podeReenviarEmailResultado(ResultSet rs, Statement st) throws Exception {
        boolean podeEnviarResultadoConvenio = EmailUtil.isBloquearEmailConvenio(rs, st, 3);
        if (!podeEnviarResultadoConvenio) {
            return false;
        }
        boolean emailPacienteEhValido = EmailUtil.validarEmailPaciente(rs);
        return emailPacienteEhValido;
    }

    private static boolean validarEmailPaciente(ResultSet rs) throws SQLException {
        boolean bloquearEmailPaciente = rs.getBoolean("bloquearEmailPaciente");
        boolean emailPacienteVazio = Funcoes.textoVazio(rs.getString("enderecoEmailPaciente"));
        boolean emailPacienteEhValido = !bloquearEmailPaciente && !emailPacienteVazio;
        return emailPacienteEhValido;
    }

    private static boolean validarResultSet(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return false;
        }
        return rs.getBoolean("enviarEmail");
    }

    private static void prepararStatementeDadosEmail(String filial, String requisicao, Statement st) throws SQLException {
        prstDadosEmail = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosEmail);
        prstDadosEmail.setInt(1, Integer.parseInt(filial));
        prstDadosEmail.setInt(2, Integer.parseInt(requisicao));
        prstAtualizaRequisicao = EmailUtil.getPreparedStatement(st.getConnection(), sqlAtualizaRequisicao);
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
    }

    private static void prepararStatementDadosExameRequisicao(String filial, String requisicao, Statement st) throws SQLException {
        prstAtualizaExameRequisicao = EmailUtil.getPreparedStatement(st.getConnection(), sqlAtualizaExameReqLog);
        prstAtualizaExameRequisicao.setString(1, Variaveis.login);
        prstAtualizaExameRequisicao.setTimestamp(2, new Timestamp(new Date().getTime()));
        prstAtualizaExameRequisicao.setInt(3, Integer.parseInt(filial));
        prstAtualizaExameRequisicao.setInt(4, Integer.parseInt(requisicao));
    }

    private static void prepararStatementDadosPaciente(String filial, String requisicao, Statement st) throws SQLException {
        prstDadosEmail = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
        prstDadosEmail.setInt(1, Integer.parseInt(filial));
        prstDadosEmail.setInt(2, Integer.parseInt(requisicao));
    }

    private static void validarParametros(String codigoFilial, String codigoRequisicao, TipoEmail tipoEmail) throws Exception {
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (tipoEmail == null) {
            throw new Exception("Tipo do e-mail n\u00e3o informado.");
        }
    }

    public static boolean criaLogEmail(String codigoFilial, String codigoRequisicao, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st) throws Exception {
        return EmailUtil.criaLogEmail(codigoFilial, codigoRequisicao, pdf, tipoEmail, commitAutomatico, st, ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), Variaveis.codigoBaseWeb);
    }

    public static boolean criaLogEmail(String codigoFilial, String codigoRequisicao, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, String tipoIntegracao, int digitosTuboFilial, int digitosTuboRequisicao, String codigoBaseWeb) throws Exception {
        ArrayList<String> listaEmails;
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoRequisicao)) {
            throw new Exception("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o informado.");
        }
        if (tipoEmail == null) {
            throw new Exception("Tipo do e-mail n\u00e3o informado.");
        }
        prstDadosEmail = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosEmail);
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        prstAtualizaRequisicao = EmailUtil.getPreparedStatement(st.getConnection(), sqlAtualizaRequisicao);
        prstAtualizaExameRequisicao = EmailUtil.getPreparedStatement(st.getConnection(), sqlAtualizaExameReqLog);
        prstDadosEmail.setInt(1, Integer.parseInt(codigoFilial));
        prstDadosEmail.setInt(2, Integer.parseInt(codigoRequisicao));
        ResultSet rs = prstDadosEmail.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarEmail")) {
            return false;
        }
        String email = null;
        String assunto = null;
        String codigoPaciente = rs.getString("codigoPaciente");
        if (tipoEmail.equals((Object)TipoEmail.ANIVERSARIO)) {
            if (!EmailUtil.podeEnviarEmailAniversario(rs, st)) {
                return false;
            }
            email = rs.getString("emailAniversario");
            assunto = rs.getString("assuntoAniversario");
        } else if (tipoEmail.equals((Object)TipoEmail.RECOLETA)) {
            if (!EmailUtil.podeEnviarEmailRecoleta(rs, st)) {
                return false;
            }
            email = rs.getString("emailRecoleta");
            assunto = rs.getString("assuntoRecoleta");
        } else if (tipoEmail.equals((Object)TipoEmail.RESULTADO)) {
            if (!EmailUtil.podeEnviarEmailResultado(rs, st)) {
                return false;
            }
            if (rs.getBoolean("emailResultadoEnviado")) {
                return false;
            }
            email = rs.getString("emailResultado");
            assunto = rs.getString("assuntoResultado");
        } else if (tipoEmail.equals((Object)TipoEmail.SENHA_WEB)) {
            if (!EmailUtil.podeEnviarEmailSenhaWeb(rs)) {
                return false;
            }
            email = rs.getString("emailSenhaWeb");
            assunto = rs.getString("assuntoSenhaWeb");
        } else if (tipoEmail.equals((Object)TipoEmail.REQUISICAO)) {
            if (!EmailUtil.podeEnviarEmailRequisicao(rs)) {
                return false;
            }
            email = rs.getString("emailRequisicao");
            assunto = rs.getString("assuntoRequisicao");
        } else if (tipoEmail.equals((Object)TipoEmail.PROPOSTA)) {
            if (!EmailUtil.podeEnviarEmailProposta(rs)) {
                return false;
            }
            email = rs.getString("emailProposta");
            assunto = rs.getString("assuntoProposta");
        } else if (tipoEmail.equals((Object)TipoEmail.ATRASO_ENTREGA)) {
            if (!EmailUtil.podeEnviarEmailResultadoAtrasado(rs)) {
                return false;
            }
            email = rs.getString("emailResultadoAtrasado");
            assunto = rs.getString("assuntoResultadoAtrasado");
        } else if (tipoEmail.equals((Object)TipoEmail.AGENDAMENTO)) {
            if (!EmailUtil.podeEnviarEmailAgendamento(rs)) {
                return false;
            }
            email = rs.getString("emailAgendamento");
            assunto = rs.getString("assuntoEmailAgendamento");
        }
        email = EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), EmailUtil.getHashCampos(rs, st, codigoBaseWeb, digitosTuboFilial, digitosTuboRequisicao));
        if (Funcoes.textoVazio(email)) {
            return false;
        }
        HashSet<? extends String> emails = new HashSet<String>();
        if (!Funcoes.textoVazio(rs.getString("enderecoEmailPaciente")) && (listaEmails = StringUtil.explode(rs.getString("enderecoEmailPaciente"), ";, ")) != null) {
            emails.addAll(listaEmails);
        }
        if (tipoEmail.equals((Object)TipoEmail.RESULTADO)) {
            emails.addAll(EmailUtil.getEmailContatos(rs.getBoolean("emailparacontatos"), codigoFilial, codigoRequisicao));
        }
        for (String string : emails) {
            String sequencia = DBUtil.getSequencia(st, LOGEMAIL, codigoFilial);
            prstInsereLog.setInt(1, Integer.parseInt(codigoFilial));
            prstInsereLog.setInt(2, Integer.parseInt(sequencia));
            prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
            prstInsereLog.setString(4, "E");
            prstInsereLog.setString(5, string);
            prstInsereLog.setString(6, email);
            prstInsereLog.setString(7, assunto);
            prstInsereLog.setInt(10, Integer.parseInt(codigoRequisicao));
            prstInsereLog.setInt(11, Integer.parseInt(codigoPaciente));
            prstInsereLog.setObject(12, tipoEmail.getCodigo());
            prstInsereLog.setString(13, tipoIntegracao);
            prstInsereLog.setObject(14, null);
            prstInsereLog.setObject(15, null);
            long oidbuff = 0L;
            if (pdf != null) {
                long oid;
                LargeObjectManager lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
                oidbuff = oid = lobj.createLO(393216);
                LargeObject obj = lobj.open(oid, 131072);
                obj.write(pdf);
                obj.close();
                prstInsereLog.setLong(8, oid);
                prstInsereLog.setString(9, "P");
            } else {
                prstInsereLog.setObject(8, null);
                prstInsereLog.setObject(9, null);
            }
            if (tipoIntegracao.contains("F") || tipoIntegracao.contains("W")) {
                IntegracaoUtil.insereComandoLog(st, codigoFilial, codigoFilial, prstInsereLog.toString());
            }
            if (prstInsereLog.executeUpdate() == 0) {
                if (commitAutomatico) {
                    st.getConnection().rollback();
                }
                return false;
            }
            if (tipoEmail.equals((Object)TipoEmail.REQUISICAO) || tipoEmail.equals((Object)TipoEmail.RESULTADO) || tipoEmail.equals((Object)TipoEmail.RECOLETA) || tipoEmail.equals((Object)TipoEmail.PROPOSTA) || tipoEmail.equals((Object)TipoEmail.RESULTADO_PDF)) {
                prstAtualizaExameRequisicao.setString(1, Variaveis.login);
                prstAtualizaExameRequisicao.setTimestamp(2, new Timestamp(new Date().getTime()));
                prstAtualizaExameRequisicao.setInt(3, Integer.parseInt(codigoFilial));
                prstAtualizaExameRequisicao.setInt(4, Integer.parseInt(codigoRequisicao));
                if (prstAtualizaExameRequisicao.executeUpdate() == 0) {
                    if (commitAutomatico) {
                        st.getConnection().rollback();
                    }
                    return false;
                }
            }
            if (tipoEmail.equals((Object)TipoEmail.RESULTADO)) {
                prstAtualizaRequisicao.setTimestamp(1, new Timestamp(new Date().getTime()));
                prstAtualizaRequisicao.setInt(2, Integer.parseInt(codigoFilial));
                prstAtualizaRequisicao.setInt(3, Integer.parseInt(codigoRequisicao));
                if (prstAtualizaRequisicao.executeUpdate() == 0) {
                    if (commitAutomatico) {
                        st.getConnection().rollback();
                    }
                    return false;
                }
            }
            if (!commitAutomatico) continue;
            st.getConnection().commit();
        }
        return true;
    }

    private static boolean filialPermiteEnviarSeparado(String filial, String requisicao, Statement st) throws SQLException {
        String sql = "select (case when fil_agruparmultiguiaemail is null then false else fil_agruparmultiguiaemail end) as fil_agruparmultiguiaemail from filiais_postocoleta where fil_codigo = ?";
        PreparedStatement psMultiguia = EmailUtil.getPreparedStatement(st.getConnection(), sql);
        psMultiguia.setInt(1, Integer.parseInt(filial));
        ResultSet rsFilialMultiguia = psMultiguia.executeQuery();
        boolean bFilialMultiguia = false;
        if (rsFilialMultiguia.next()) {
            bFilialMultiguia = rsFilialMultiguia.getBoolean("fil_agruparmultiguiaemail");
        }
        if (bFilialMultiguia) {
            StringBuilder listaRequisicoes = new StringBuilder();
            Integer[] integerArray = RecepcaoUtil.verificaMultiGuias(filial, requisicao, true);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int requisicaoAtual = integerArray[i];
                if (!listaRequisicoes.toString().isEmpty()) {
                    listaRequisicoes.append(", ");
                }
                listaRequisicoes.append(requisicaoAtual);
            }
            StringBuilder buf = new StringBuilder("select (count(*) = sum(case when exr_situacao in ( '");
            buf.append("E").append("', '").append("C").append("', '").append("A").append("', '").append("I").append("' )");
            buf.append(" then 1 end)) as prontos from examerequisicao where fil_codigo = ").append(filial);
            buf.append(" and req_codigo in ( ").append((CharSequence)listaRequisicoes).append(" ) and not exr_excluido");
            ResultSet rsExamesProntos = Conexao.executeQuery(st, buf.toString());
            if (rsExamesProntos.next()) {
                return rsExamesProntos.getBoolean("prontos");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<? extends String> getEmailContatos(boolean emailparacontatos, String codigoFilial, String codigoRequisicao) throws SQLException {
        ArrayList<String> retorno = new ArrayList<String>();
        try (Statement st = Conexao.getStatement();){
            if (emailparacontatos && Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(" select ent.ent_email as email from pacienteentidade pac_ent ");
                stringBuilder.append(" inner join entidade ent on pac_ent.ent_codigo = ent.ent_codigo and pac_ent.fil_codigo = ent.fil_codigo ");
                stringBuilder.append(" inner join requisicao req on pac_ent.pac_codigo = req.pac_codigo and pac_ent.fil_codigo = req.fil_codigo ");
                stringBuilder.append(" where req.fil_codigo = ").append(codigoFilial).append(" and req.req_codigo = ").append(codigoRequisicao);
                ResultSet rsRetorno = Conexao.executeQuery(st, stringBuilder);
                if (rsRetorno.next()) {
                    do {
                        String m;
                        if (Funcoes.textoVazio(m = rsRetorno.getString("email"))) continue;
                        retorno.add(m);
                    } while (rsRetorno.next());
                }
            }
        }
        return retorno;
    }

    public static PreparedStatement getPreparedStatement(Connection conexao, String sql) {
        try {
            return conexao.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public static Map<String, String> criaLogEmailCotacao(EntidadeVO entidade, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st) throws Exception {
        return EmailUtil.criaLogEmailCotacao(entidade, pdf, tipoEmail, commitAutomatico, st, null);
    }

    public static Map<String, String> criaLogEmailCotacao(EntidadeVO entidade, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, String codigoCotacao) throws Exception {
        HashMap<String, String> mapsStatusEnvio = new HashMap<String, String>();
        int codigoFilial = entidade.getFilial().getCodigo();
        if (Funcoes.textoVazio(String.valueOf(codigoFilial))) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "C\u00f3digo da filial n\u00e3o informado.");
            return mapsStatusEnvio;
        }
        if (Funcoes.textoVazio(entidade.getEmail())) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "E-mail n\u00e3o informado.");
            return mapsStatusEnvio;
        }
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        prstDadosCotacao = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosFilial);
        prstDadosCotacao.setInt(1, entidade.getFilial().getCodigo());
        ResultSet rs = prstDadosCotacao.executeQuery();
        if (!rs.next()) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "Configura\u00e7\u00f5es inv\u00e1lidas para envio.");
            return mapsStatusEnvio;
        }
        if (!EmailUtil.podeEnviarEmailCotacao(rs)) {
            if (!rs.getBoolean("enviarEmail")) {
                mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "Filial n\u00e3o permite o envio de e-mail.");
                return mapsStatusEnvio;
            }
            if (!rs.getBoolean("enviarEmailCotacao") || !Funcoes.textoVazio(rs.getString("emailCotacao"))) {
                mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "E-mail de proposta n\u00e3o configurado para a filial.");
                return mapsStatusEnvio;
            }
        }
        String email = null;
        String assunto = null;
        Object codigoRequisicao = null;
        Object codigoPaciente = null;
        if (tipoEmail.equals((Object)TipoEmail.COTACAO_FORNECEDOR)) {
            email = rs.getString("emailCotacao");
            assunto = rs.getString("assuntoCotacao");
        }
        HashMap<String, Object> dadosHash = EmailUtil.getHashCamposFilial(rs);
        dadosHash.put("emailCotacao", email);
        email = EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), dadosHash);
        if (Funcoes.textoVazio(email)) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "A configura\u00e7\u00e3o de e-mail de proposta da filial \u00e9 inv\u00e1lida.");
            return mapsStatusEnvio;
        }
        String sequencia = DBUtil.getSequencia(st, LOGEMAIL, String.valueOf(codigoFilial));
        prstInsereLog.setInt(1, Integer.parseInt(String.valueOf(codigoFilial)));
        prstInsereLog.setInt(2, Integer.parseInt(sequencia));
        prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
        prstInsereLog.setString(4, "O");
        prstInsereLog.setString(5, entidade.getEmail());
        prstInsereLog.setString(6, email);
        prstInsereLog.setString(7, assunto);
        prstInsereLog.setObject(10, codigoRequisicao);
        prstInsereLog.setObject(11, codigoPaciente);
        prstInsereLog.setObject(12, tipoEmail.getCodigo());
        prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
        prstInsereLog.setObject(14, null);
        prstInsereLog.setInt(15, entidade.getCodigo());
        if (pdf != null) {
            LargeObjectManager lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
            long oid = lobj.createLO(393216);
            LargeObject obj = lobj.open(oid, 131072);
            obj.write(pdf);
            obj.close();
            prstInsereLog.setLong(8, oid);
            prstInsereLog.setString(9, "P");
        } else {
            prstInsereLog.setObject(8, null);
            prstInsereLog.setObject(9, null);
        }
        int qtde = prstInsereLog.executeUpdate();
        if (qtde == 0) {
            if (commitAutomatico) {
                st.getConnection().rollback();
            }
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "N\u00e3o foi poss\u00edvel realizar o envio.");
            return mapsStatusEnvio;
        }
        if (commitAutomatico) {
            st.getConnection().commit();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,ema_codigo as codigoLog ");
        buf.append("       ,ema_datahora as dataHora ");
        buf.append("       ,ema_situacao as situacao ");
        buf.append("       ,ema_email as enderecoEmail ");
        buf.append("       ,ema_mensagem as mensagemEmail ");
        buf.append("       ,ema_assunto as assuntoEmail ");
        buf.append("       ,ema_anexo as pdf ");
        buf.append("       ,ema_extensao as extensao ");
        buf.append("   from logemail ");
        buf.append("  where ema_codigo = ? and fil_codigo = ? ");
        buf.append("  order by ema_datahora ");
        buf.append("          ,fil_codigo ");
        buf.append("          ,ema_codigo ");
        PreparedStatement prstLogs = ConexaoEmail.getPreparedStatement(buf.toString());
        prstLogs.setInt(1, Integer.valueOf(sequencia));
        prstLogs.setInt(2, codigoFilial);
        ResultSet rsLog = prstLogs.executeQuery();
        if (!rsLog.next()) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "N\u00e3o foi poss\u00edvel realizar o envio.");
            return mapsStatusEnvio;
        }
        if (!EmailUtil.enviaEmail(false, rs.getString("xml"), rsLog.getString("enderecoEmail"), rsLog.getString("mensagemEmail"), rsLog.getString("assuntoEmail"), pdf, null, rsLog.getInt("codigoFilial"), rsLog.getInt("codigoLog"), rsLog.getString("extensao"), true, codigoCotacao, true, st)) {
            EmailUtil.atualizaLog(codigoFilial, Integer.valueOf(sequencia), "I", ConexaoEmail.getStatement());
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "N\u00e3o foi poss\u00edvel realizar o envio.\nVerifique o e-mail de destino e as configura\u00e7\u00f5es de envio.");
            return mapsStatusEnvio;
        }
        mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, SUCESSO_ENVIO_EMAIL_PROPOSTA);
        return mapsStatusEnvio;
    }

    public static Map<String, String> criaLogEmailProposta(String codigoFilial, String codigoPaciente, String codigoConvenio, String emailPacienteConvenio, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta) throws Exception {
        return EmailUtil.criaLogEmailProposta(false, codigoFilial, codigoPaciente, codigoConvenio, emailPacienteConvenio, pdf, tipoEmail, commitAutomatico, st, isConvenioProposta, ParametrosGerais.getTipoIntegracao());
    }

    public static Map<String, String> criaLogEmailProposta(boolean isColetaWeb, String codigoFilial, String codigoPaciente, String codigoConvenio, String emailPacienteConvenio, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta, String tipoIntegracao) throws Exception {
        HashMap<String, String> mapsStatusEnvio = new HashMap<String, String>();
        if (Funcoes.textoVazio(codigoFilial)) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "C\u00f3digo da filial n\u00e3o informado.");
            return mapsStatusEnvio;
        }
        if (!isConvenioProposta) {
            if (!Funcoes.textoVazio(codigoPaciente)) {
                prstDadosPaciente = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
            } else {
                prstDadosFilial = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosFilial);
            }
        } else {
            prstDadosFilialConvenioProposta = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosFilialConvenioProposta);
        }
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        if (!isConvenioProposta) {
            if (!Funcoes.textoVazio(codigoPaciente)) {
                prstDadosPaciente.setInt(1, Integer.parseInt(codigoFilial));
                prstDadosPaciente.setInt(2, Integer.parseInt(codigoPaciente));
            } else {
                prstDadosFilial.setInt(1, Integer.parseInt(codigoFilial));
            }
        } else {
            prstDadosFilialConvenioProposta.setInt(1, Integer.parseInt(codigoFilial));
            prstDadosFilialConvenioProposta.setInt(2, Integer.parseInt(codigoConvenio));
        }
        ResultSet rs = null;
        rs = !isConvenioProposta ? (!Funcoes.textoVazio(codigoPaciente) ? prstDadosPaciente.executeQuery() : prstDadosFilial.executeQuery()) : prstDadosFilialConvenioProposta.executeQuery();
        if (!rs.next()) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "Configura\u00e7\u00f5es inv\u00e1lidas para envio.");
            return mapsStatusEnvio;
        }
        if (!EmailUtil.podeEnviarEmailProposta(rs)) {
            if (!rs.getBoolean("enviarEmail")) {
                mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "Filial n\u00e3o permite o envio de e-mail.");
                return mapsStatusEnvio;
            }
            if (!rs.getBoolean("enviarEmailProposta") || !Funcoes.textoVazio(rs.getString("emailProposta"))) {
                mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "E-mail de proposta n\u00e3o configurado para a filial.");
                return mapsStatusEnvio;
            }
        }
        String email = null;
        String assunto = null;
        Object codigoRequisicao = null;
        if (tipoEmail.equals((Object)TipoEmail.PROPOSTA)) {
            email = rs.getString("emailProposta");
            assunto = rs.getString("assuntoProposta");
        }
        if (Funcoes.textoVazio(emailPacienteConvenio)) {
            if (isConvenioProposta) {
                emailPacienteConvenio = rs.getString("email1");
                if (Funcoes.textoVazio(emailPacienteConvenio)) {
                    emailPacienteConvenio = rs.getString("email2");
                }
            } else if (!Funcoes.textoVazio(codigoPaciente)) {
                emailPacienteConvenio = rs.getString("enderecoEmailPaciente");
            }
        }
        if (Funcoes.textoVazio(emailPacienteConvenio)) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "E-mail para envio n\u00e3o foi encontrado.");
            return mapsStatusEnvio;
        }
        HashMap<String, Object> dadosHash = null;
        if (!isConvenioProposta) {
            dadosHash = !Funcoes.textoVazio(codigoPaciente) ? EmailUtil.getHashCamposPessoa(rs) : EmailUtil.getHashCamposFilial(rs);
            dadosHash.put("emailPaciente", emailPacienteConvenio);
            email = EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), dadosHash);
        } else {
            email = EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), EmailUtil.getHashCamposConvenio(rs));
        }
        if (Funcoes.textoVazio(email)) {
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "A configura\u00e7\u00e3o de e-mail de proposta da filial \u00e9 inv\u00e1lida.");
            return mapsStatusEnvio;
        }
        ArrayList<String> listaEmails = StringUtil.explode(emailPacienteConvenio, ";, ");
        if (listaEmails != null) {
            for (String enderecoEmail : listaEmails) {
                String sequencia = DBUtil.getSequencia(st, LOGEMAIL, codigoFilial);
                prstInsereLog.setInt(1, Integer.parseInt(codigoFilial));
                prstInsereLog.setInt(2, Integer.parseInt(sequencia));
                prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
                prstInsereLog.setString(4, "O");
                prstInsereLog.setString(5, enderecoEmail);
                prstInsereLog.setString(6, email);
                prstInsereLog.setString(7, assunto);
                prstInsereLog.setObject(10, codigoRequisicao);
                prstInsereLog.setObject(12, tipoEmail.getCodigo());
                prstInsereLog.setString(13, tipoIntegracao);
                prstInsereLog.setInt(14, Integer.parseInt(codigoConvenio));
                prstInsereLog.setObject(15, null);
                if (!Funcoes.textoVazio(codigoPaciente)) {
                    prstInsereLog.setInt(11, Integer.parseInt(codigoPaciente));
                } else {
                    prstInsereLog.setObject(11, null);
                }
                if (pdf != null) {
                    LargeObjectManager lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
                    long oid = lobj.createLO(393216);
                    LargeObject obj = lobj.open(oid, 131072);
                    obj.write(pdf);
                    obj.close();
                    prstInsereLog.setLong(8, oid);
                    prstInsereLog.setString(9, "P");
                } else {
                    prstInsereLog.setObject(8, null);
                    prstInsereLog.setObject(9, null);
                }
                int qtde = prstInsereLog.executeUpdate();
                if (qtde == 0) {
                    if (commitAutomatico) {
                        st.getConnection().rollback();
                    }
                    mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "N\u00e3o foi poss\u00edvel realizar o envio.");
                    return mapsStatusEnvio;
                }
                if (commitAutomatico) {
                    st.getConnection().commit();
                }
                StringBuilder buf = new StringBuilder();
                buf.append(" select fil_codigo as codigoFilial ");
                buf.append("       ,ema_codigo as codigoLog ");
                buf.append("       ,ema_datahora as dataHora ");
                buf.append("       ,ema_situacao as situacao ");
                buf.append("       ,ema_email as enderecoEmail ");
                buf.append("       ,ema_mensagem as mensagemEmail ");
                buf.append("       ,ema_assunto as assuntoEmail ");
                buf.append("       ,ema_anexo as pdf ");
                buf.append("       ,ema_extensao as extensao ");
                buf.append("   from logemail ");
                buf.append("  where ema_codigo = ? and fil_codigo = ? ");
                buf.append("  order by ema_datahora ");
                buf.append("          ,fil_codigo ");
                buf.append("          ,ema_codigo ");
                PreparedStatement prstLogs = st.getConnection().prepareStatement(buf.toString());
                prstLogs.setInt(1, Integer.valueOf(sequencia));
                prstLogs.setInt(2, Integer.valueOf(codigoFilial));
                ResultSet rsLog = prstLogs.executeQuery();
                if (!rsLog.next()) {
                    mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "N\u00e3o foi poss\u00edvel realizar o envio.");
                    return mapsStatusEnvio;
                }
                if (EmailUtil.enviaEmail(isColetaWeb, rs.getString("xml"), rsLog.getString("enderecoEmail"), rsLog.getString("mensagemEmail"), rsLog.getString("assuntoEmail"), pdf, null, rsLog.getInt("codigoFilial"), rsLog.getInt("codigoLog"), rsLog.getString("extensao"), false, null, true, st)) continue;
                EmailUtil.atualizaLog(Integer.valueOf(codigoFilial), Integer.valueOf(sequencia), "I", st);
                mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "N\u00e3o foi poss\u00edvel realizar o envio.\nVerifique o e-mail de destino e as configura\u00e7\u00f5es de envio.");
                return mapsStatusEnvio;
            }
            mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, SUCESSO_ENVIO_EMAIL_PROPOSTA);
            return mapsStatusEnvio;
        }
        mapsStatusEnvio.put(STATUS_ENVIO_EMAIL_PROPOSTA, "N\u00e3o foi poss\u00edvel desmembrar a lista de e-mails.");
        return mapsStatusEnvio;
    }

    public static boolean criaLogEmailResultadoPDF(String codigoFilial, String codigoRequisicao, String descricaoMaterial, ArrayList<String> listaEmails, ArrayList<String> listaEmailsCopia, byte[] zip, TipoEmail tipoEmail, Statement st) throws Exception {
        LargeObject obj;
        long oid;
        LargeObjectManager lobj;
        String sequencia;
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoRequisicao)) {
            throw new Exception("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o informado.");
        }
        prstDadosEmail = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosEmail);
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        prstAtualizaExameRequisicao = EmailUtil.getPreparedStatement(st.getConnection(), sqlAtualizaExameReqLog);
        prstDadosEmail.setInt(1, Integer.parseInt(codigoFilial));
        prstDadosEmail.setInt(2, Integer.parseInt(codigoRequisicao));
        ResultSet rs = prstDadosEmail.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarEmail")) {
            return false;
        }
        String email = null;
        String assunto = null;
        String codigoPaciente = rs.getString("codigoPaciente");
        if (tipoEmail.equals((Object)TipoEmail.RESULTADO_PDF)) {
            email = rs.getString("emailResultadoPDF");
            assunto = rs.getString("assuntoEmailResultadoPDF");
        } else if (tipoEmail.equals((Object)TipoEmail.RESULTADO_CERTIFICADO_ANALISE)) {
            email = rs.getString("emailCertificadoAnalise");
            assunto = descricaoMaterial.toUpperCase() + " - SIF " + (Funcoes.textoVazio(rs.getString("sifCliente")) ? "n\u00e3o informado" : rs.getString("sifCliente"));
        }
        if (Funcoes.textoVazio(email)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma configura\u00e7\u00e3o de e-mail para certificado de an\u00e1lise foi encontrada", 2);
            return false;
        }
        if (Funcoes.textoVazio(email = EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), EmailUtil.getHashCampos(rs)))) {
            return false;
        }
        for (String endEmail : listaEmails) {
            sequencia = DBUtil.getSequencia(st, LOGEMAIL, codigoFilial.toString());
            prstInsereLog.setInt(1, Integer.parseInt(codigoFilial));
            prstInsereLog.setInt(2, Integer.parseInt(sequencia));
            prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
            prstInsereLog.setString(4, "E");
            prstInsereLog.setString(5, endEmail);
            prstInsereLog.setString(6, email);
            prstInsereLog.setString(7, assunto);
            prstInsereLog.setInt(10, Integer.parseInt(codigoRequisicao));
            prstInsereLog.setInt(11, Integer.parseInt(codigoPaciente));
            prstInsereLog.setObject(12, tipoEmail.getCodigo());
            prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
            prstInsereLog.setObject(14, null);
            prstInsereLog.setObject(15, null);
            if (zip != null) {
                lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
                oid = lobj.createLO(393216);
                obj = lobj.open(oid, 131072);
                obj.write(zip);
                obj.close();
                prstInsereLog.setLong(8, oid);
                prstInsereLog.setString(9, "Z");
            } else {
                prstInsereLog.setObject(8, null);
                prstInsereLog.setObject(9, null);
            }
            if (prstInsereLog.executeUpdate() == 0) {
                return false;
            }
            if (!tipoEmail.equals((Object)TipoEmail.REQUISICAO) && !tipoEmail.equals((Object)TipoEmail.RESULTADO) && !tipoEmail.equals((Object)TipoEmail.RECOLETA) && !tipoEmail.equals((Object)TipoEmail.PROPOSTA) && !tipoEmail.equals((Object)TipoEmail.RESULTADO_PDF) && !tipoEmail.equals((Object)TipoEmail.RESULTADO_CERTIFICADO_ANALISE)) continue;
            prstAtualizaExameRequisicao.setString(1, Variaveis.login);
            prstAtualizaExameRequisicao.setTimestamp(2, new Timestamp(new Date().getTime()));
            prstAtualizaExameRequisicao.setInt(3, Integer.parseInt(codigoFilial));
            prstAtualizaExameRequisicao.setInt(4, Integer.parseInt(codigoRequisicao));
            if (prstAtualizaExameRequisicao.executeUpdate() != 0) continue;
            return false;
        }
        for (String endEmail : listaEmailsCopia) {
            sequencia = DBUtil.getSequencia(st, LOGEMAIL, codigoFilial.toString());
            prstInsereLog.setInt(1, Integer.parseInt(codigoFilial));
            prstInsereLog.setInt(2, Integer.parseInt(sequencia));
            prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
            prstInsereLog.setString(4, "E");
            prstInsereLog.setString(5, endEmail);
            prstInsereLog.setString(6, email);
            prstInsereLog.setString(7, "[C\u00f3pia] " + assunto);
            prstInsereLog.setInt(10, Integer.parseInt(codigoRequisicao));
            prstInsereLog.setInt(11, Integer.parseInt(codigoPaciente));
            prstInsereLog.setObject(12, tipoEmail.getCodigo());
            prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
            prstInsereLog.setObject(14, null);
            prstInsereLog.setObject(15, null);
            if (zip != null) {
                lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
                oid = lobj.createLO(393216);
                obj = lobj.open(oid, 131072);
                obj.write(zip);
                obj.close();
                prstInsereLog.setLong(8, oid);
                prstInsereLog.setString(9, "Z");
            } else {
                prstInsereLog.setObject(8, null);
                prstInsereLog.setObject(9, null);
            }
            if (prstInsereLog.executeUpdate() == 0) {
                return false;
            }
            if (!tipoEmail.equals((Object)TipoEmail.REQUISICAO) && !tipoEmail.equals((Object)TipoEmail.RESULTADO) && !tipoEmail.equals((Object)TipoEmail.RECOLETA) && !tipoEmail.equals((Object)TipoEmail.PROPOSTA) && !tipoEmail.equals((Object)TipoEmail.RESULTADO_PDF) && !tipoEmail.equals((Object)TipoEmail.RESULTADO_CERTIFICADO_ANALISE)) continue;
            prstAtualizaExameRequisicao.setString(1, Variaveis.login);
            prstAtualizaExameRequisicao.setTimestamp(2, new Timestamp(new Date().getTime()));
            prstAtualizaExameRequisicao.setInt(3, Integer.parseInt(codigoFilial));
            prstAtualizaExameRequisicao.setInt(4, Integer.parseInt(codigoRequisicao));
            if (prstAtualizaExameRequisicao.executeUpdate() != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean criaLogEmailSemDadosRequisicao(String codigoFilial, String codigoPacienteConvenio, String emailPacienteConvenio, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta) throws Exception {
        return EmailUtil.criaLogEmailSemDadosRequisicao(codigoFilial, codigoPacienteConvenio, emailPacienteConvenio, pdf, tipoEmail, commitAutomatico, st, isConvenioProposta, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getTipoIntegracao(), Variaveis.codigoBaseWeb);
    }

    public static boolean criaLogEmailSemDadosRequisicao(String codigoFilial, String codigoPacienteConvenio, String emailPacienteConvenio, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta, int digitosTuboFilial, int digitosTuboRequisicao, String tipoIntegracao, String codigoBaseWeb) throws Exception {
        Iterator<String> iterator;
        ArrayList<String> listaEmails;
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(codigoPacienteConvenio) && !isConvenioProposta) {
            throw new Exception("C\u00f3digo do paciente n\u00e3o informado.");
        }
        if (!isConvenioProposta) {
            prstDadosPaciente = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
        } else {
            prstDadosFilialConvenioProposta = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosFilialConvenioProposta);
        }
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        if (!isConvenioProposta) {
            prstDadosPaciente.setInt(1, Integer.parseInt(codigoFilial));
            prstDadosPaciente.setInt(2, Integer.parseInt(codigoPacienteConvenio));
        } else {
            prstDadosFilialConvenioProposta.setInt(1, Integer.parseInt(codigoFilial));
            prstDadosFilialConvenioProposta.setInt(2, Integer.parseInt(codigoPacienteConvenio));
        }
        ResultSet rs = null;
        rs = !isConvenioProposta ? prstDadosPaciente.executeQuery() : prstDadosFilialConvenioProposta.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarEmail")) {
            return false;
        }
        String email = null;
        String assunto = null;
        Object codigoRequisicao = null;
        if (tipoEmail.equals((Object)TipoEmail.ANIVERSARIO)) {
            if (!EmailUtil.podeEnviarEmailAniversario(rs, st)) {
                return false;
            }
            email = rs.getString("emailAniversario");
            assunto = rs.getString("assuntoAniversario");
        } else if (tipoEmail.equals((Object)TipoEmail.RECOLETA)) {
            if (!EmailUtil.podeEnviarEmailRecoleta(rs, st)) {
                return false;
            }
            email = rs.getString("emailRecoleta");
            assunto = rs.getString("assuntoRecoleta");
        } else if (tipoEmail.equals((Object)TipoEmail.RESULTADO)) {
            if (!EmailUtil.podeEnviarEmailResultado(rs, st)) {
                return false;
            }
            email = rs.getString("emailResultado");
            assunto = rs.getString("assuntoResultado");
        } else if (tipoEmail.equals((Object)TipoEmail.SENHA_WEB)) {
            if (!EmailUtil.podeEnviarEmailSenhaWeb(rs)) {
                return false;
            }
            email = rs.getString("emailSenhaWeb");
            assunto = rs.getString("assuntoSenhaWeb");
        } else if (tipoEmail.equals((Object)TipoEmail.REQUISICAO)) {
            if (!EmailUtil.podeEnviarEmailRequisicao(rs)) {
                return false;
            }
            email = rs.getString("emailRequisicao");
            assunto = rs.getString("assuntoRequisicao");
        } else if (tipoEmail.equals((Object)TipoEmail.ATRASO_ENTREGA)) {
            if (!EmailUtil.podeEnviarEmailResultadoAtrasado(rs)) {
                return false;
            }
            email = rs.getString("emailResultadoAtrasado");
            assunto = rs.getString("assuntoResultadoAtrasado");
        } else if (tipoEmail.equals((Object)TipoEmail.PROPOSTA)) {
            if (!EmailUtil.podeEnviarEmailProposta(rs)) {
                return false;
            }
            email = rs.getString("emailProposta");
            assunto = rs.getString("assuntoProposta");
            if (Funcoes.textoVazio(emailPacienteConvenio)) {
                throw new Exception("Conv\u00eanio n\u00e3o possui e-mail para envio.");
            }
        }
        if (Funcoes.textoVazio(emailPacienteConvenio)) {
            if (isConvenioProposta) {
                emailPacienteConvenio = rs.getString("email1");
                if (Funcoes.textoVazio(emailPacienteConvenio)) {
                    emailPacienteConvenio = rs.getString("email2");
                }
            } else {
                emailPacienteConvenio = rs.getString("enderecoEmailPaciente");
            }
        }
        if (!Funcoes.textoVazio(emailPacienteConvenio) && (listaEmails = StringUtil.explode(emailPacienteConvenio, ";, ")) != null && (iterator = listaEmails.iterator()).hasNext()) {
            String enderecoEmail = iterator.next();
            email = !isConvenioProposta ? EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), EmailUtil.getHashCampos(rs, st, codigoBaseWeb, digitosTuboFilial, digitosTuboRequisicao)) : EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), EmailUtil.getHashCamposConvenio(rs));
            if (Funcoes.textoVazio(email)) {
                return false;
            }
            String sequencia = DBUtil.getSequencia(st, LOGEMAIL, codigoFilial.toString());
            prstInsereLog.setInt(1, Integer.parseInt(codigoFilial));
            prstInsereLog.setInt(2, Integer.parseInt(sequencia));
            prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
            prstInsereLog.setString(4, "E");
            prstInsereLog.setString(5, enderecoEmail);
            prstInsereLog.setString(6, email);
            prstInsereLog.setString(7, assunto);
            prstInsereLog.setObject(10, codigoRequisicao);
            prstInsereLog.setInt(11, Integer.parseInt(codigoPacienteConvenio));
            prstInsereLog.setObject(12, tipoEmail.getCodigo());
            prstInsereLog.setString(13, tipoIntegracao);
            prstInsereLog.setObject(14, null);
            prstInsereLog.setObject(15, null);
            if (pdf != null) {
                LargeObjectManager lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
                long oid = lobj.createLO(393216);
                LargeObject obj = lobj.open(oid, 131072);
                obj.write(pdf);
                obj.close();
                prstInsereLog.setLong(8, oid);
                prstInsereLog.setString(9, "P");
            } else {
                prstInsereLog.setObject(8, null);
                prstInsereLog.setObject(9, null);
            }
            int qtde = prstInsereLog.executeUpdate();
            if (qtde == 0) {
                if (commitAutomatico) {
                    st.getConnection().rollback();
                }
                return false;
            }
            if (commitAutomatico) {
                st.getConnection().commit();
            }
            return true;
        }
        return true;
    }

    public static boolean criaLogEmailSenhaWebMedico(String codigoFilial, ArrayList<String> emailContatoMedico, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta, String crmMedicoSenhaWeb, String ufMedico, String conselho) throws Exception {
        return EmailUtil.criaLogEmailSenhaWebMedico(codigoFilial, emailContatoMedico, pdf, tipoEmail, commitAutomatico, st, isConvenioProposta, crmMedicoSenhaWeb, ufMedico, conselho, Variaveis.codigoBaseWeb, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getTipoIntegracao());
    }

    public static boolean criaLogEmailSenhaWebMedico(String codigoFilial, ArrayList<String> emailContatoMedico, byte[] pdf, TipoEmail tipoEmail, boolean commitAutomatico, Statement st, boolean isConvenioProposta, String crmMedicoSenhaWeb, String ufMedico, String conselho, String codigoBaseWeb, int digitosTuboFilial, int digitosTuboRequisicao, String tipoIntegracao) throws Exception {
        ArrayList<String> listaEmails;
        if (Funcoes.textoVazio(codigoFilial)) {
            throw new Exception("C\u00f3digo da filial n\u00e3o informado.");
        }
        if (Funcoes.textoVazio(crmMedicoSenhaWeb)) {
            throw new Exception("CRM do m\u00e9dico n\u00e3o informado.");
        }
        prstDadosMedico = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosMedico);
        if (!Funcoes.textoVazio(crmMedicoSenhaWeb)) {
            prstDadosMedico.setInt(1, Integer.parseInt(codigoFilial));
            prstDadosMedico.setString(2, crmMedicoSenhaWeb);
            prstDadosMedico.setString(3, ufMedico);
            prstDadosMedico.setString(4, conselho);
        }
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        ResultSet rs = null;
        String emailDoMedico = "";
        rs = prstDadosMedico.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (!rs.getBoolean("enviarEmail")) {
            return false;
        }
        String email = null;
        String assunto = null;
        Object codigoRequisicao = null;
        Object codigoPaciente = null;
        if (tipoEmail.equals((Object)TipoEmail.SENHA_WEB_MEDICO)) {
            if (!EmailUtil.podeEnviarEmailSenhaWebMedico(rs)) {
                return false;
            }
            email = rs.getString("emailSenhaWebMedico");
            assunto = rs.getString("assuntoSenhaWebMedico");
            emailDoMedico = rs.getString("enderecoEmailMedico");
        }
        if (!Funcoes.textoVazio(emailDoMedico) && (listaEmails = StringUtil.explode(emailDoMedico, ";, ")) != null) {
            if (EmailUtil.contemEmailContatos(emailContatoMedico)) {
                listaEmails.addAll(emailContatoMedico);
            }
            for (String enderecoEmail : listaEmails) {
                email = rs.getString("emailSenhaWebMedico");
                email = !isConvenioProposta ? EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), EmailUtil.getHashCampos(rs, st, codigoBaseWeb, digitosTuboFilial, digitosTuboRequisicao)) : EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), EmailUtil.getHashCamposConvenio(rs));
                if (Funcoes.textoVazio(email)) {
                    return false;
                }
                String sequencia = DBUtil.getSequencia(st, LOGEMAIL, codigoFilial.toString());
                prstInsereLog.setInt(1, Integer.parseInt(codigoFilial));
                prstInsereLog.setInt(2, Integer.parseInt(sequencia));
                prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
                prstInsereLog.setString(4, "E");
                prstInsereLog.setString(5, enderecoEmail);
                prstInsereLog.setString(6, email);
                prstInsereLog.setString(7, assunto);
                prstInsereLog.setObject(10, codigoRequisicao);
                prstInsereLog.setObject(11, codigoPaciente);
                prstInsereLog.setObject(12, tipoEmail.getCodigo());
                prstInsereLog.setString(13, tipoIntegracao);
                prstInsereLog.setObject(14, null);
                prstInsereLog.setObject(15, null);
                if (pdf != null) {
                    LargeObjectManager lobj = ((PGConnection)prstInsereLog.getConnection()).getLargeObjectAPI();
                    long oid = lobj.createLO(393216);
                    LargeObject obj = lobj.open(oid, 131072);
                    obj.write(pdf);
                    obj.close();
                    prstInsereLog.setLong(8, oid);
                    prstInsereLog.setString(9, "P");
                } else {
                    prstInsereLog.setObject(8, null);
                    prstInsereLog.setObject(9, null);
                }
                int qtde = prstInsereLog.executeUpdate();
                if (qtde == 0) {
                    if (commitAutomatico) {
                        st.getConnection().rollback();
                    }
                    return false;
                }
                if (!commitAutomatico) continue;
                st.getConnection().commit();
            }
        }
        return true;
    }

    private static boolean contemEmailContatos(ArrayList<String> emailContatoMedico) {
        return emailContatoMedico != null && emailContatoMedico.size() > 0;
    }

    public static boolean enviaEmailTeste(String xmlConfiguracaoEnvio, String codigoFilial, String assunto, String email) throws Exception {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        mapa.put("codigopaciente", "123456");
        mapa.put("cpfpaciente", "123.456.789-00");
        mapa.put("senhawebpaciente", "senhapac");
        mapa.put("nomepaciente", "PACIENTE TESTE DE ENVIO");
        mapa.put("codigorequisicao", "987654321");
        mapa.put("senhawebrequisicao", "senhareq");
        mapa.put("datarequisicao", Funcoes.formataData("dd/MM/yyyy", new Date()));
        email = EmailUtil.parseEmail(EmailUtil.getCorpoEmail(email), mapa);
        if (Funcoes.textoVazio(email)) {
            return false;
        }
        return EmailUtil.testarEmail(assunto, email, xmlConfiguracaoEnvio);
    }

    private static String getCorpoEmail(String email) {
        if (Funcoes.textoVazio(email)) {
            return " ";
        }
        return StringUtil.getValor(email, "body");
    }

    private static HashMap<String, Object> getHashCamposPessoa(ResultSet rs) {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        try {
            if (!Funcoes.textoVazio(rs.getString("codigoPaciente"))) {
                mapa.put("codigoPaciente", rs.getString("codigoPaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("cpfPaciente"))) {
                mapa.put("cpfPaciente", rs.getString("cpfPaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("senhaWebPaciente"))) {
                mapa.put("senhaWebPaciente", rs.getString("senhaWebPaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
                mapa.put("nomePaciente", rs.getString("nomePaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("codigoConvenio"))) {
                mapa.put("codigoConvenio", rs.getString("codigoConvenio"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mapa;
    }

    private static HashMap<String, Object> getHashCamposFilial(ResultSet rs) {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        try {
            if (!Funcoes.textoVazio(rs.getString("filialDescricao"))) {
                mapa.put("filialDescricao", rs.getString("filialDescricao"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("filialCnpj"))) {
                mapa.put("filialCnpj", rs.getString("filialCnpj"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("filialEndereco"))) {
                mapa.put("filialEndereco", rs.getString("filialEndereco"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("filialResponsavel"))) {
                mapa.put("filialResponsavel", rs.getString("filialResponsavel"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("filialEmail"))) {
                mapa.put("filialEmail", rs.getString("filialEmail"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mapa;
    }

    private static HashMap<String, Object> getHashCampos(ResultSet rs) {
        Statement st = Conexao.getStatement();
        return EmailUtil.getHashCampos(rs, st, Variaveis.codigoBaseWeb, ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao());
    }

    private static HashMap<String, Object> getHashCampos(ResultSet rs, Statement st, String codigoBaseWeb, int digitosTuboFilial, int digitosTuboRequisicao) {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        try {
            if (!Funcoes.textoVazio(rs.getString("codigoPaciente"))) {
                mapa.put("codigopaciente", rs.getString("codigoPaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(Funcoes.preencheZero(rs.getString("codigoFilial"), digitosTuboFilial));
            buf.append(Funcoes.preencheZero(rs.getString("codigoRequisicao"), digitosTuboRequisicao));
            mapa.put("codigoPacienteWeb", buf.toString());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("cpfPaciente"))) {
                mapa.put("cpfpaciente", rs.getString("cpfPaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("senhaWebPaciente"))) {
                mapa.put("senhawebpaciente", rs.getString("senhaWebPaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
                mapa.put("nomepaciente", rs.getString("nomePaciente"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            mapa.put("nomeSocialPaciente", EmailUtil.getNomeSocial(rs));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("codigoRequisicao"))) {
                mapa.put("codigorequisicao", rs.getString("codigoRequisicao"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("senhaWebRequisicao"))) {
                mapa.put("senhawebrequisicao", rs.getString("senhaWebRequisicao"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("dataRequisicao"))) {
                mapa.put("datarequisicao", Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataRequisicao")));
            }
            if (!Funcoes.textoVazio(rs.getString("dataEntregaPrevistaRequisicao"))) {
                mapa.put("dataentregaprevistarequisicao", Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataEntregaPrevistaRequisicao")));
            }
            if (!Funcoes.textoVazio(rs.getString("horaEntregaPrevistaRequisicao"))) {
                mapa.put("horaentregaprevistarequisicao", Funcoes.formataHora(rs.getTime("horaEntregaPrevistaRequisicao"), true));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("nomeMedico"))) {
                mapa.put("nomeMedico", rs.getString("nomeMedico"));
            }
            if (!Funcoes.textoVazio(rs.getString("crmMedico"))) {
                mapa.put("crmMedico", rs.getString("crmMedico"));
            }
            if (!Funcoes.textoVazio(rs.getString("enderecoEmailMedico"))) {
                mapa.put("enderecoEmailMedico", rs.getString("enderecoEmailMedico"));
            }
            if (!Funcoes.textoVazio(rs.getString("senhaWebMedico"))) {
                mapa.put("senhaWebMedico", rs.getString("senhaWebMedico"));
            }
            if (!Funcoes.textoVazio(rs.getString("tratamentoMedico"))) {
                mapa.put("tratamentoMedico", rs.getString("tratamentoMedico"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("dataHoraAgenda"))) {
                mapa.put("datahoraagenda", Funcoes.formataDataEHora(rs.getString("dataHoraAgenda")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (Funcoes.textoVazio(rs.getString("chaveAcessoRequisicao"))) {
                mapa.put("chaveAcessoRequisicao", EmailUtil.preencherChaveAcessoRequisicao(rs, st, codigoBaseWeb, digitosTuboFilial, digitosTuboRequisicao));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mapa;
    }

    private static String getNomeSocial(ResultSet rs) throws SQLException {
        if (!Funcoes.textoVazio(rs.getString("nomeSocialPaciente"))) {
            return rs.getString("nomeSocialPaciente");
        }
        if (!Funcoes.textoVazio(rs.getString("nomePaciente"))) {
            return rs.getString("nomePaciente");
        }
        return "";
    }

    private static HashMap<String, String> getHashCamposCotacao(ResultSet rs) {
        HashMap<String, String> mapa = new HashMap<String, String>();
        try {
            if (!Funcoes.textoVazio(rs.getString("convenioCodigo"))) {
                mapa.put("convenioCodigo", rs.getString("convenioCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("coletaCodigo"))) {
                mapa.put("coletaCodigo", rs.getString("coletaCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("destinoCodigo"))) {
                mapa.put("destinoCodigo", rs.getString("destinoCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("coletaCodigo"))) {
                mapa.put("coletaCodigo", rs.getString("coletaCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("razaoSocial"))) {
                mapa.put("razaoSocial", rs.getString("razaoSocial"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("nomeFantasia"))) {
                mapa.put("nomeFantasia", rs.getString("nomeFantasia"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("con_email2"))) {
                mapa.put("con_email2", rs.getString("con_email2"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mapa;
    }

    private static HashMap<String, Object> getHashCamposConvenio(ResultSet rs) {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        try {
            if (!Funcoes.textoVazio(rs.getString("convenioCodigo"))) {
                mapa.put("convenioCodigo", rs.getString("convenioCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("coletaCodigo"))) {
                mapa.put("coletaCodigo", rs.getString("coletaCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("destinoCodigo"))) {
                mapa.put("destinoCodigo", rs.getString("destinoCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("coletaCodigo"))) {
                mapa.put("coletaCodigo", rs.getString("coletaCodigo"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("razaoSocial"))) {
                mapa.put("razaoSocial", rs.getString("razaoSocial"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("nomeFantasia"))) {
                mapa.put("nomeFantasia", rs.getString("nomeFantasia"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (!Funcoes.textoVazio(rs.getString("con_email2"))) {
                mapa.put("con_email2", rs.getString("con_email2"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mapa;
    }

    private static boolean podeEnviarEmailPaciente(ResultSet rs) throws Exception {
        return !rs.getBoolean("bloquearEmailPaciente") && !Funcoes.textoVazio(rs.getString("enderecoEmailPaciente"));
    }

    private static boolean podeEnviarEmailAniversario(ResultSet rs, Statement st) throws Exception {
        return EmailUtil.podeEnviarEmailPaciente(rs) && rs.getBoolean("enviarEmailAniversario") && !Funcoes.textoVazio(rs.getString("emailAniversario")) && EmailUtil.isBloquearEmailConvenio(rs, st, 1);
    }

    private static boolean podeEnviarEmailRecoleta(ResultSet rs, Statement st) throws Exception {
        return EmailUtil.podeEnviarEmailPaciente(rs) && rs.getBoolean("enviarEmailRecoleta") && !Funcoes.textoVazio(rs.getString("emailRecoleta")) && EmailUtil.isBloquearEmailConvenio(rs, st, 2);
    }

    private static boolean isBloquearEmailConvenio(ResultSet rs, Statement st, int tipo) throws Exception {
        if (rs.getString("codigoConvenio") == null) {
            return true;
        }
        prstBloqueioConvenio = EmailUtil.getPreparedStatement(st.getConnection(), sqlBloqueiosEnvioEmailConvenio);
        prstBloqueioConvenio.setInt(1, rs.getInt("codigofilial"));
        prstBloqueioConvenio.setInt(2, rs.getInt("codigoConvenio"));
        ResultSet rsConvenio = prstBloqueioConvenio.executeQuery();
        if (rsConvenio.next()) {
            if (tipo == 1) {
                return !rsConvenio.getBoolean("bloquearAniversario");
            }
            if (tipo == 2) {
                return !rsConvenio.getBoolean("bloquearRecoleta");
            }
            if (tipo == 3) {
                return !rsConvenio.getBoolean("bloquearResultado");
            }
        }
        return true;
    }

    private static boolean podeEnviarEmailResultado(ResultSet rs, Statement st) throws Exception {
        PreparedStatement prstRequisicaoEnviouEmail = null;
        boolean podeEnviarResultadoConvenio = EmailUtil.isBloquearEmailConvenio(rs, st, 3);
        boolean podeEnviarResultadoFilial = EmailUtil.filialPermiteEnviarSeparado(rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), st);
        if (!podeEnviarResultadoConvenio) {
            return false;
        }
        if (!podeEnviarResultadoFilial || ResultadosUtil.notificacaoJaEnviada(rs.getInt("codigofilial"), rs.getInt("codigorequisicao"), st, "fil_agruparmultiguiaemail", "req_emailresultadoenviado")) {
            return false;
        }
        prstRequisicaoEnviouEmail = EmailUtil.getPreparedStatement(st.getConnection(), sqlRequisicaoEnviouEmail);
        prstExamesProntosRequisicao = EmailUtil.getPreparedStatement(st.getConnection(), sqlExamesProntosRequisicao);
        prstRequisicaoEnviouEmail.setInt(1, rs.getInt("codigoFilial"));
        prstRequisicaoEnviouEmail.setInt(2, rs.getInt("codigoRequisicao"));
        ResultSet rsRequisicaoEnviouEmail = prstRequisicaoEnviouEmail.executeQuery();
        if (rsRequisicaoEnviouEmail.next() && rsRequisicaoEnviouEmail.getBoolean("emailEnviado")) {
            return false;
        }
        prstExamesProntosRequisicao.setString(1, "E");
        prstExamesProntosRequisicao.setString(2, "I");
        prstExamesProntosRequisicao.setString(3, "C");
        prstExamesProntosRequisicao.setString(4, "A");
        prstExamesProntosRequisicao.setInt(5, rs.getInt("codigoFilial"));
        prstExamesProntosRequisicao.setInt(6, rs.getInt("codigoRequisicao"));
        ResultSet rsExamesProntosRequisicao = prstExamesProntosRequisicao.executeQuery();
        if (rsExamesProntosRequisicao.next() && !rsExamesProntosRequisicao.getBoolean("prontos")) {
            return false;
        }
        return !rs.getBoolean("bloquearEmailPaciente") && (!Funcoes.textoVazio(rs.getString("enderecoEmailPaciente")) || rs.getBoolean("emailparacontatos")) && rs.getBoolean("enviarEmailResultado") && !Funcoes.textoVazio(rs.getString("emailResultado"));
    }

    private static boolean podeEnviarEmailSenhaWeb(ResultSet rs) throws Exception {
        return EmailUtil.podeEnviarEmailPaciente(rs) && rs.getBoolean("enviarEmailSenhaWeb") && !Funcoes.textoVazio(rs.getString("emailSenhaWeb"));
    }

    private static boolean podeEnviarEmailSenhaWebMedico(ResultSet rs) throws Exception {
        return !Funcoes.textoVazio(rs.getString("enderecoEmailMedico")) && rs.getBoolean("enviarEmailSenhaWebMedico") && !Funcoes.textoVazio(rs.getString("emailSenhaWebMedico"));
    }

    private static boolean podeEnviarEmailRequisicao(ResultSet rs) throws Exception {
        return EmailUtil.podeEnviarEmailPaciente(rs) && rs.getBoolean("enviarEmailRequisicao") && !Funcoes.textoVazio(rs.getString("emailRequisicao"));
    }

    private static boolean podeEnviarEmailAgendamento(ResultSet rs) throws Exception {
        return EmailUtil.podeEnviarEmailPaciente(rs) && rs.getBoolean("enviarEmailAgendamento") && !Funcoes.textoVazio(rs.getString("emailAgendamento"));
    }

    private static boolean podeEnviarEmailResultadoAtrasado(ResultSet rs) throws Exception {
        return EmailUtil.podeEnviarEmailPaciente(rs) && rs.getBoolean("enviarEmailResultadoAtrasado") && !Funcoes.textoVazio(rs.getString("emailResultadoAtrasado"));
    }

    private static boolean podeEnviarEmailProposta(ResultSet rs) throws Exception {
        return rs.getBoolean("enviarEmailProposta") && !Funcoes.textoVazio(rs.getString("emailProposta")) && rs.getBoolean("enviarEmail");
    }

    private static boolean podeEnviarEmailCotacao(ResultSet rs) throws Exception {
        return rs.getBoolean("enviarEmailCotacao") && !Funcoes.textoVazio(rs.getString("emailCotacao")) && rs.getBoolean("enviarEmail");
    }

    private static boolean podeEnviarEmailDataEntrega(ResultSet rs, Date dataAtual, Date dataAnterior) throws Exception {
        return dataAtual != null && dataAnterior != null && dataAtual.compareTo(dataAnterior) != 0 && rs.getBoolean("enviarEmailDataEntrega") && !Funcoes.textoVazio(rs.getString("emailDataEntrega")) && rs.getBoolean("enviarEmail");
    }

    public boolean podeEnviarEmailNotaFiscal(String codigoFilial) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COALESCE(fil_enviaremail, false) AND COALESCE(fil_emailnfse, false) as podeEnviar ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        Statement st = null;
        try {
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getBoolean("podeEnviar");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel verificar se o envio de e-mails est\u00e1 ativado para a filial.\n" + e.getMessage(), e.getStackTrace());
        }
        return false;
    }

    public static boolean getFilialPodeEnviarEmailSenhaWeb(String filial, Statement st, boolean fecharStatement) throws Exception {
        boolean retorno = false;
        prstFilialEnviaEmailSenhaWeb = EmailUtil.getPreparedStatement(st.getConnection(), sqlFilialEnviaEmailSenhaWeb);
        prstFilialEnviaEmailSenhaWeb.setInt(1, Integer.parseInt(filial));
        ResultSet rs = prstFilialEnviaEmailSenhaWeb.executeQuery();
        if (rs.next()) {
            retorno = rs.getBoolean("enviarEmail");
        }
        if (fecharStatement) {
            Conexao.fecharStatement(st);
        }
        return retorno;
    }

    public static boolean getFilialPodeEnviarEmailSenhaWebMedico(String filial, String crmMedico, String ufMedico, String emailMedico, Statement st) throws Exception {
        if (st == null) {
            st = Conexao.getStatement();
        }
        boolean retorno = false;
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        buf.append(" select fil_enviaremail as enviarEmail ");
        buf.append("  ,fil_emailsenhawebmedico as enviarEmailSenhaWebMedico");
        buf.append("  from filiais_postocoleta fil ");
        buf.append("  where fil.fil_codigo = ? ");
        sqlPermiteEnviarEmail = buf.toString();
        prstDadosMedico = EmailUtil.getPreparedStatement(st.getConnection(), sqlPermiteEnviarEmail);
        prstDadosMedico.setInt(1, Integer.parseInt(filial));
        ResultSet rs = prstDadosMedico.executeQuery();
        if (rs.next()) {
            retorno = rs.getBoolean("enviarEmail") && rs.getBoolean("enviarEmailSenhaWebMedico") && !Funcoes.textoVazio(emailMedico);
            Conexao.fecharStatement(st);
        }
        return retorno;
    }

    public static void atualizaLog(Integer codigoFilial, Integer codigoLog, String situacao, Statement st) throws Exception {
        prstAtualizaSituacaoLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlAtualizaSituacaoLog);
        prstAtualizaSituacaoLog.setString(1, situacao);
        prstAtualizaSituacaoLog.setInt(2, codigoFilial);
        prstAtualizaSituacaoLog.setInt(3, codigoLog);
        int qtde = prstAtualizaSituacaoLog.executeUpdate();
        if (qtde == 0) {
            throw new Exception("N\u00e3o foi poss\u00edvel atualizar o log. Filial = " + codigoFilial + ", Log = " + codigoLog + ".");
        }
        st.getConnection().commit();
    }

    public static boolean enviaEmail(String xmlConfiguracaoEnvio, String emailDestino, String mensagem, String assunto, byte[] pdf, String extensaoAnexo) {
        return EmailUtil.enviaEmail(xmlConfiguracaoEnvio, emailDestino, mensagem, assunto, pdf, null, -1, -1, extensaoAnexo, false);
    }

    public static boolean enviaEmail(String xmlConfiguracaoEnvio, String emailDestino, String mensagem, String assunto, byte[] pdf, int codigoFilial, int codigoLog, String extensaoAnexo) {
        return EmailUtil.enviaEmail(xmlConfiguracaoEnvio, emailDestino, mensagem, assunto, pdf, null, codigoFilial, codigoLog, extensaoAnexo, false);
    }

    public static boolean enviaEmail(String xmlConfiguracaoEnvio, String emailDestino, String mensagem, String assunto, byte[] pdf, byte[] xml, String extensaoAnexo, boolean isPdf) {
        return EmailUtil.enviaEmail(xmlConfiguracaoEnvio, emailDestino, mensagem, assunto, pdf, xml, -1, -1, extensaoAnexo, isPdf);
    }

    public static boolean enviaEmail(String xmlConfiguracaoEnvio, String emailDestino, String mensagem, String assunto, byte[] pdf, byte[] xml, int codigoFilial, int codigoLog, String extensaoAnexo, boolean isPdf) {
        return EmailUtil.enviaEmail(false, xmlConfiguracaoEnvio, emailDestino, mensagem, assunto, pdf, xml, codigoFilial, codigoLog, extensaoAnexo, isPdf, null, false, Conexao.getStatement());
    }

    public static boolean enviaEmail(boolean isColetaWeb, String xmlConfiguracaoEnvio, String emailDestino, String mensagem, String assunto, byte[] pdf, byte[] xml, int codigoFilial, int codigoLog, String extensaoAnexo, boolean isPdf, String codigoCotacao, boolean enviarErroConsole, Statement statement) {
        if (Funcoes.textoVazio(xmlConfiguracaoEnvio)) {
            if (!isColetaWeb) {
                Laboratorio.setIconeEnvioEmail(ExportaEmail.ICONE_ENVIANDO_E_MAIL_ERRO);
                Laboratorio.setHintEnvioEmail(MENSAGEM_SEM_CONFIGURACAO_ENVIO);
            }
            return false;
        }
        String endereco = StringUtil.getValor(xmlConfiguracaoEnvio, "endereco");
        String porta = StringUtil.getValor(xmlConfiguracaoEnvio, "porta");
        String requer_autenticacao = StringUtil.getValor(xmlConfiguracaoEnvio, "requeraut");
        String seguranca = StringUtil.getValor(xmlConfiguracaoEnvio, "seguranca");
        String autenticacao = StringUtil.getValor(xmlConfiguracaoEnvio, "autenticacao");
        final String nomeUsuario = StringUtil.getValor(xmlConfiguracaoEnvio, "nomeusuario");
        final String senha = StringUtil.getValor(xmlConfiguracaoEnvio, "senha");
        try {
            ByteArrayDataSource dataSource;
            Properties prop = new Properties();
            prop.put("mail.tranport.protocol", "smtp");
            if (seguranca.equals("SEM")) {
                prop.put("mail.smtp.starttls.enable", "false");
            } else if (seguranca.equals("TLS")) {
                prop.put("mail.smtp.starttls.enable", "true");
            } else if (seguranca.equals("SSL")) {
                prop.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                prop.put("mail.smtp.starttls.enable", "false");
            }
            prop.put("mail.host", endereco);
            prop.put("mail.smtp.auth", requer_autenticacao);
            prop.put("mail.smtp.host", endereco);
            prop.put("mail.smtp.port", porta);
            prop.put("mail.imap.partialfetch", "false");
            prop.put("mail.smtp.debug", "true");
            Session session = Session.getInstance((Properties)prop, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(nomeUsuario, senha);
                }
            });
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(nomeUsuario));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(emailDestino));
            message.setSubject(assunto);
            message.setSentDate(new Date());
            MimeMultipart root = new MimeMultipart();
            root.setSubType("related");
            ArrayList<BodyPart> listaAnexos = new ArrayList<BodyPart>();
            String mensagemTratada = EmailUtil.trataImagensEmail(listaAnexos, mensagem);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)mensagemTratada, "text/html");
            root.addBodyPart((BodyPart)htmlPart);
            for (BodyPart aux : listaAnexos) {
                root.addBodyPart(aux);
            }
            if (pdf != null) {
                if (!Funcoes.textoVazio(extensaoAnexo) && extensaoAnexo.equalsIgnoreCase("Z")) {
                    String[] anexos;
                    String xmlDecodificado = new String(pdf);
                    for (String anexo : anexos = StringUtil.getValores(xmlDecodificado, "pdf")) {
                        String nomePdf = StringUtil.getValor(anexo, "nome");
                        String conteudo = StringUtil.getValor(anexo, "conteudo");
                        byte[] pdfAdd = new Base64().decode(conteudo);
                        MimeBodyPart pdfPart = new MimeBodyPart();
                        ByteArrayDataSource dataSource2 = new ByteArrayDataSource(pdfAdd, "application/pdf");
                        pdfPart.setDisposition("attachment");
                        pdfPart.setDataHandler(new DataHandler((DataSource)dataSource2));
                        pdfPart.setFileName(nomePdf);
                        root.addBodyPart((BodyPart)pdfPart);
                    }
                } else {
                    MimeBodyPart pdfPart = new MimeBodyPart();
                    dataSource = new ByteArrayDataSource(pdf, "application/pdf");
                    pdfPart.setDisposition("attachment");
                    pdfPart.setDataHandler(new DataHandler((DataSource)dataSource));
                    pdfPart.setFileName("pdf_anexo.pdf");
                    if (!Funcoes.textoVazio(codigoCotacao)) {
                        pdfPart.setFileName("Cotacao_" + codigoCotacao + ".pdf");
                    }
                    root.addBodyPart((BodyPart)pdfPart);
                }
            }
            if (xml != null) {
                MimeBodyPart xmlPart = new MimeBodyPart();
                dataSource = new ByteArrayDataSource(xml, "application/xml");
                xmlPart.setDisposition("attachment");
                xmlPart.setDataHandler(new DataHandler((DataSource)dataSource));
                if (isPdf) {
                    xmlPart.setFileName("xml_anexo.zip");
                } else {
                    xmlPart.setFileName("xml_anexo.xml");
                }
                root.addBodyPart((BodyPart)xmlPart);
            }
            message.setContent((Multipart)root);
            Transport transport = session.getTransport("smtp");
            transport.connect();
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (Exception ex) {
            if (ex instanceof AddressException || ex instanceof SendFailedException) {
                if (codigoFilial > -1 && codigoLog > -1) {
                    try {
                        EmailUtil.atualizaLog(codigoFilial, codigoLog, "I", statement);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                ex.printStackTrace();
                if (!enviarErroConsole) {
                    Laboratorio.setIconeEnvioEmail(ExportaEmail.ICONE_ENVIANDO_E_MAIL_ERRO);
                    Laboratorio.setHintEnvioEmail("Ocorreu uma situa\u00e7\u00e3o inesperada ao enviar. Verifique as configura\u00e7\u00f5es de envio de email, verifique caso o servidor aceite conex\u00f5es seguras (Tls)." + ex.getMessage());
                    VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Situa\u00e7\u00e3o de e-mail:" + ex.getMessage() + "Verifique as configura\u00e7\u00f5es de envio de email, verifique caso o servidor aceite conex\u00f5es seguras (Tls).");
                }
            }
            return false;
        }
        return true;
    }

    public static boolean testarEmail(String assunto, String msg, String xmlConfiguracaoEnvio) {
        String endereco = StringUtil.getValor(xmlConfiguracaoEnvio, "endereco");
        String porta = StringUtil.getValor(xmlConfiguracaoEnvio, "porta");
        String requer_autenticacao = StringUtil.getValor(xmlConfiguracaoEnvio, "requeraut");
        String seguranca = StringUtil.getValor(xmlConfiguracaoEnvio, "seguranca");
        String autenticacao = StringUtil.getValor(xmlConfiguracaoEnvio, "autenticacao");
        final String nomeUsuario = StringUtil.getValor(xmlConfiguracaoEnvio, "nomeusuario");
        final String senha = StringUtil.getValor(xmlConfiguracaoEnvio, "senha");
        try {
            Properties prop = new Properties();
            prop.put("mail.tranport.protocol", "smtp");
            if (seguranca.equals("SEM")) {
                prop.put("mail.smtp.starttls.enable", (Object)false);
            } else if (seguranca.equals("TLS")) {
                prop.put("mail.smtp.starttls.enable", (Object)true);
            } else if (seguranca.equals("SSL")) {
                prop.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                prop.put("mail.smtp.starttls.enable", (Object)false);
            }
            prop.put("mail.host", endereco);
            prop.put("mail.smtp.auth", requer_autenticacao);
            prop.put("mail.smtp.host", endereco);
            prop.put("mail.smtp.port", porta);
            prop.put("mail.imap.partialfetch", (Object)false);
            prop.put("mail.smtp.debug", "true");
            Session session = Session.getInstance((Properties)prop, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(nomeUsuario, senha);
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(nomeUsuario));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(nomeUsuario));
            if (!Funcoes.textoVazio(msg) && !Funcoes.textoVazio(assunto)) {
                message.setSubject(assunto);
            }
            message.setSentDate(new Date());
            MimeMultipart root = new MimeMultipart();
            root.setSubType("related");
            if (!Funcoes.textoVazio(msg) && !Funcoes.textoVazio(assunto)) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)msg, "text/html");
                root.addBodyPart((BodyPart)htmlPart);
            }
            message.setContent((Multipart)root);
            Transport transport = session.getTransport("smtp");
            transport.connect();
            if (!Funcoes.textoVazio(msg) && !Funcoes.textoVazio(assunto)) {
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
            transport.close();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String trataImagensEmail(ArrayList<BodyPart> listaAnexos, String mensagem) throws Exception {
        if (listaAnexos == null || Funcoes.textoVazio(mensagem)) {
            return "";
        }
        int id = 0;
        while (EmailUtil.haMaisTagsImagem(mensagem)) {
            listaAnexos.add(EmailUtil.createInlineImagePart(EmailUtil.getStringBase64ProximaTag(mensagem), id));
            mensagem = EmailUtil.trocaProximaTagImagem(mensagem, id);
            ++id;
        }
        return mensagem;
    }

    private static boolean haMaisTagsImagem(String mensagem) {
        if (Funcoes.textoVazio(mensagem)) {
            return false;
        }
        return mensagem.indexOf(TAG_IMG_BASE_64) > -1;
    }

    private static String getStringBase64ProximaTag(String mensagem) {
        if (Funcoes.textoVazio(mensagem)) {
            return null;
        }
        int posIni = mensagem.indexOf(TAG_BASE_64);
        int posFim = mensagem.indexOf(">", posIni);
        return mensagem.substring(posIni + TAG_BASE_64.length(), posFim - 1);
    }

    private static String trocaProximaTagImagem(String mensagem, int id) {
        if (Funcoes.textoVazio(mensagem)) {
            return null;
        }
        int posIni = mensagem.indexOf(TAG_BASE_64);
        int posFim = mensagem.indexOf(">", posIni);
        String mensagemTratada = mensagem.substring(0, posIni);
        mensagemTratada = mensagemTratada + TAG_TROCA_IMG_CID + id + "\">";
        mensagemTratada = mensagemTratada + mensagem.substring(posFim + 1, mensagem.length());
        return mensagemTratada;
    }

    private static BodyPart createInlineImagePart(String base64String, int id) throws Exception {
        InternetHeaders headers = new InternetHeaders();
        headers.addHeader("Content-Type", "image/jpeg");
        headers.addHeader("Content-Transfer-Encoding", "base64");
        MimeBodyPart imagePart = new MimeBodyPart(headers, base64String.getBytes());
        imagePart.setDisposition("inline");
        imagePart.setContentID("<imagem" + id + ">");
        imagePart.setFileName(NOME_IMAGENS + id + ".jpg");
        return imagePart;
    }

    public static String parseEmail(String emailOriginal, Map<String, Object> valores) {
        StringBuilder novoEmail = new StringBuilder(emailOriginal);
        if (emailOriginal.contains("2!")) {
            StringBuilder bui = new StringBuilder();
            String[] expressoes = MapaResolverExpressoesUtil.resolverExpressoes(emailOriginal, MapaResolverExpressoesUtil.getCampos(SMSUtil.getInformacoesSMS(valores)), null, valores, false);
            for (int i = 0; i < expressoes.length; ++i) {
                expressoes[i] = StringUtil.removerAcentos(expressoes[i]);
            }
            MapaResolverExpressoesUtil.adicionarStrings(bui, expressoes, "", false);
            novoEmail = bui;
        } else {
            int pos = -1;
            while ((pos = novoEmail.indexOf("[")) > -1) {
                int posFim = novoEmail.indexOf("]", pos);
                String chave = novoEmail.substring(pos + 1, posFim);
                String valor = (String)valores.get(chave.trim().toLowerCase());
                if (Funcoes.textoVazio(valor)) {
                    valor = (String)valores.get(chave.trim());
                }
                valor = chave != null && !Funcoes.textoVazio(valor) ? valor : "";
                novoEmail.delete(pos, posFim + 1);
                novoEmail.insert(pos, valor);
            }
        }
        return novoEmail.toString();
    }

    public static boolean criarLogParaReenvioSemRequisicao(String filial, String paciente, String destino, String email, String assunto, TipoEmail tipo, byte[] pdf, boolean commitAutomatico, Statement st) throws Exception {
        boolean dadosValidos = EmailUtil.validarDadosAniversario(filial, paciente, destino, email, assunto, tipo);
        if (!dadosValidos) {
            return false;
        }
        EmailUtil.prepararStatementDeAniversario(filial, paciente, st);
        ResultSet rs = EmailUtil.getResultSetDeAniversario();
        boolean resultSetValido = EmailUtil.validarResultSetAniversario(st, rs);
        if (!resultSetValido) {
            return false;
        }
        EmailUtil.prepararStatementInsercaoLogAniversario(filial, paciente, destino, email, assunto, tipo, st);
        EmailUtil.informarDadosDoPdf(pdf);
        boolean emailEnviado = EmailUtil.enviarLogEmailAniversario(commitAutomatico, st);
        return emailEnviado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearEmailRecoleta(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select d.des_bloquearemailrecoleta as des_bloquearemailrecoleta, m.med_bloquearemailrecoleta as med_bloquearemailrecoleta");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo ");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo ");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = EmailUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                while (rs.next()) {
                    retorno = rs.getBoolean("des_bloquearemailrecoleta") || rs.getBoolean("med_bloquearemailrecoleta");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBloquearEmailExamePronto(String codigoFilial, String codigRequisicao, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select d.des_bloquearemailexamepronto as des_bloquearemailexamepronto, m.med_bloquearemailexamepronto as med_bloquearemailexamepronto");
            buf.append(" from requisicao r ");
            buf.append(" inner join destino d on d.des_codigo = r.des_codigo and r.fil_codigo = d.fil_codigo");
            buf.append(" inner join medico m on m.med_crm = r.med_crm and r.fil_codigo = m.fil_codigo");
            buf.append("    and r.med_conselho= m.med_conselho and r.med_uf= m.med_uf ");
            buf.append(" where r.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and r.req_codigo = ");
            buf.append(codigRequisicao);
            PreparedStatement prstEnviar = EmailUtil.getPreparedStatement(st.getConnection(), buf.toString());
            try (ResultSet rs = null;){
                rs = prstEnviar.executeQuery();
                while (rs.next()) {
                    retorno = rs.getBoolean("des_bloquearemailexamepronto") || rs.getBoolean("med_bloquearemailexamepronto");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    private static boolean enviarLogEmailAniversario(boolean commitAutomatico, Statement st) throws SQLException {
        int qtde = prstInsereLog.executeUpdate();
        if (qtde == 0) {
            if (commitAutomatico) {
                st.getConnection().rollback();
            }
            return false;
        }
        if (commitAutomatico) {
            st.getConnection().commit();
        }
        return true;
    }

    private static void prepararStatementInsercaoLogAniversario(String filial, String paciente, String destino, String email, String assunto, TipoEmail tipo, Statement st) throws SQLException {
        Object requisicao = null;
        String sequencia = DBUtil.getSequencia(st, LOGEMAIL, filial.toString());
        prstInsereLog.setInt(1, Integer.parseInt(filial));
        prstInsereLog.setInt(2, Integer.parseInt(sequencia));
        prstInsereLog.setTimestamp(3, new Timestamp(new Date().getTime()));
        prstInsereLog.setString(4, "E");
        prstInsereLog.setString(5, destino);
        prstInsereLog.setString(6, email);
        prstInsereLog.setString(7, assunto);
        prstInsereLog.setObject(10, requisicao);
        prstInsereLog.setInt(11, Integer.parseInt(paciente));
        prstInsereLog.setObject(12, tipo.getCodigo());
        prstInsereLog.setString(13, ParametrosGerais.getTipoIntegracao());
        prstInsereLog.setObject(14, null);
        prstInsereLog.setObject(15, null);
    }

    private static boolean validarResultSetAniversario(Statement st, ResultSet rs) throws SQLException, Exception {
        boolean resultSetValido = rs.next();
        if (!resultSetValido) {
            return false;
        }
        boolean podeEnviarEmail = rs.getBoolean("enviarEmail");
        boolean podeEnviarEmailAniversario = EmailUtil.podeEnviarEmailAniversario(rs, st);
        return podeEnviarEmail && podeEnviarEmailAniversario;
    }

    private static boolean validarDadosAniversario(String filial, String paciente, String destino, String email, String assunto, TipoEmail tipo) {
        boolean filialVazia = Funcoes.textoVazio(filial);
        boolean pacienteVazio = Funcoes.textoVazio(paciente);
        boolean destinoVazio = Funcoes.textoVazio(destino);
        boolean emailVazio = Funcoes.textoVazio(email);
        boolean assuntoVazio = Funcoes.textoVazio(assunto);
        boolean tipoVazio = tipo == null;
        return !filialVazia && !pacienteVazio && !destinoVazio && !emailVazio && !assuntoVazio && !tipoVazio;
    }

    private static ResultSet getResultSetDeAniversario() throws SQLException {
        ResultSet rs = null;
        rs = prstDadosPaciente.executeQuery();
        return rs;
    }

    private static void prepararStatementDeAniversario(String filial, String paciente, Statement st) throws SQLException {
        prstDadosPaciente = EmailUtil.getPreparedStatement(st.getConnection(), sqlDadosPaciente);
        prstInsereLog = EmailUtil.getPreparedStatement(st.getConnection(), sqlInsereLog);
        prstDadosPaciente.setInt(1, Integer.parseInt(filial));
        prstDadosPaciente.setInt(2, Integer.parseInt(paciente));
    }

    private static String preencherChaveAcessoRequisicao(ResultSet rs, Statement st, String codigoBaseWeb, int digitosTuboFilial, int digitosTuboRequisicao) throws SQLException {
        String baseWeb = codigoBaseWeb;
        boolean agrupada = false;
        agrupada = ExportaWeb.isBaseWebAgrupada(st, rs.getString("codigoFilial"));
        if (agrupada) {
            try {
                Map<String, Object> o = ExportaWeb.getBaseWebAgrupada(st, rs.getString("codigoFilial"));
                baseWeb = o.get("baseWeb") != null ? o.get("baseWeb").toString() : "";
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        String chaveAcesso = "";
        JSONObject jsonObject = new JSONObject();
        try {
            String tmp = Funcoes.preencheZero(rs.getString("codigoFilial"), digitosTuboFilial) + Funcoes.preencheZero(rs.getString("codigoRequisicao"), digitosTuboRequisicao);
            jsonObject.put("c", (Object)(agrupada ? tmp : rs.getString("codigoRequisicao")));
            jsonObject.put("b", (Object)baseWeb);
            jsonObject.put("p", (Object)rs.getString("senhaWebRequisicao"));
            chaveAcesso = new IntegracaoAplicativoService().encript(jsonObject.toString());
            chaveAcesso = Base64.encodeBase64String((byte[])chaveAcesso.getBytes());
        }
        catch (JSONException e) {
            throw new SQLException(e.getCause());
        }
        return chaveAcesso;
    }

    static {
        StringBuilder buf = new StringBuilder();
        buf.append(" select pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_email as enderecoEmailPaciente ");
        buf.append("       ,pac.pac_sif as sifCliente ");
        buf.append("       ,COALESCE(pac.pac_bloquearemail, false) as bloquearEmailPaciente ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.req_senhaweb as senhaWebRequisicao ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.req_dataentregaprev as dataEntregaPrevistaRequisicao ");
        buf.append("       ,req.req_horaentregaprev as horaEntregaPrevistaRequisicao ");
        buf.append("       ,req.fil_codigo as codigoFilial ");
        buf.append("       ,req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.req_emailresultadoenviado IS NOT NULL as emailResultadoEnviado ");
        buf.append("       ,cast(req.fil_codigo as varchar) || req.req_codigo as codigoPacienteWeb ");
        buf.append("       ,COALESCE(fil.fil_enviaremail, false) as enviarEmail ");
        buf.append("       ,fil.fil_emailaniversario as enviarEmailAniversario ");
        buf.append("       ,fil.fil_emailresultados as enviarEmailResultado ");
        buf.append("       ,fil.fil_emailsenhaweb as enviarEmailSenhaWeb ");
        buf.append("       ,fil.fil_emailrecoleta as enviarEmailRecoleta ");
        buf.append("       ,fil.fil_emailrequisicao as enviarEmailRequisicao ");
        buf.append("       ,fil.fil_emailproposta as enviarEmailProposta ");
        buf.append("       ,fil.fil_fraseemailaniversario as emailAniversario ");
        buf.append("       ,fil.fil_fraseemailresultados as emailResultado ");
        buf.append("       ,fil.fil_fraseemailsenhaweb as emailSenhaWeb ");
        buf.append("       ,fil.fil_fraseemailrecoleta as emailRecoleta ");
        buf.append("       ,fil.fil_fraseemailrequisicao as emailRequisicao ");
        buf.append("       ,fil.fil_fraseemailproposta as emailProposta ");
        buf.append("       ,fil.fil_emailassuntoaniversario as assuntoAniversario ");
        buf.append("       ,fil.fil_emailassuntosenhaweb as assuntoSenhaWeb ");
        buf.append("       ,fil.fil_emailassuntoresultados as assuntoResultado ");
        buf.append("       ,fil.fil_emailassuntorecoleta as assuntoRecoleta ");
        buf.append("       ,fil.fil_assuntoemailrequisicao as assuntoRequisicao ");
        buf.append("       ,fil.fil_assuntoemailproposta as assuntoProposta ");
        buf.append("       ,fil.fil_configuracaoemail as xml ");
        buf.append("       ,fil.fil_emailparacontatos as emailparacontatos ");
        buf.append("       ,fil_emailresultadopdf as enviarEmailResultadoPDF ");
        buf.append("       ,fil_fraseemailresultadopdf as emailResultadoPDF ");
        buf.append("       ,fil_assuntoemailresultadopdf as assuntoEmailResultadoPDF ");
        buf.append("       ,fil_emailcertificadoanalise as enviarEmailCertificadoAnalise ");
        buf.append("       ,fil_fraseemailcertificadoanalise as emailCertificadoAnalise ");
        buf.append("       ,fil_assuntoemailcertificadoanalise assuntoCertificadoAnalise ");
        buf.append("       ,fil.fil_emailentrega as enviarEmailResultadoAtrasado ");
        buf.append("       ,fil.fil_fraseemailentrega as emailResultadoAtrasado ");
        buf.append("       ,fil.fil_assuntoemailentrega as assuntoResultadoAtrasado ");
        buf.append("       ,fil.fil_fraseemailagendamento as emailAgendamento ");
        buf.append("       ,fil.fil_emailagendamento as enviarEmailAgendamento ");
        buf.append("       ,fil.fil_assuntoemailagendamento as assuntoEmailAgendamento ");
        buf.append("       ,agd.agd_datahoraagenda as dataHoraAgenda");
        buf.append("\t\t\t ,'' as chaveAcessoRequisicao ");
        buf.append("   from requisicao req ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join filiais_postocoleta fil on req.fil_codigo = fil.fil_codigo ");
        buf.append("   left join agendamento agd on req.fil_codigo = agd.fil_codigo and req.req_codigo = agd.req_codigo and agd.agd_situacao = '").append("A").append("'");
        buf.append("  where req.fil_codigo = ? ");
        buf.append("    and req.req_codigo = ? ");
        buf.append(" order by agd.agd_codigo desc limit 1");
        sqlDadosEmail = buf.toString();
        buf.setLength(0);
        buf.append(" select pac.fil_codigo as codigoFilial, pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_senhaweb as senhaWebPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.con_codigo as codigoConvenio ");
        buf.append("       ,pac.pac_email as enderecoEmailPaciente ");
        buf.append("       ,COALESCE(pac.pac_bloquearemail, false) as bloquearEmailPaciente ");
        buf.append("       ,COALESCE(fil.fil_enviaremail, false) as enviarEmail ");
        buf.append("       ,fil.fil_emailaniversario as enviarEmailAniversario ");
        buf.append("       ,fil.fil_emailresultados as enviarEmailResultado ");
        buf.append("       ,fil.fil_emailsenhaweb as enviarEmailSenhaWeb ");
        buf.append("       ,fil.fil_emailrecoleta as enviarEmailRecoleta ");
        buf.append("       ,fil.fil_emailrequisicao as enviarEmailRequisicao ");
        buf.append("       ,fil.fil_emailproposta as enviarEmailProposta ");
        buf.append("       ,fil.fil_fraseemailaniversario as emailAniversario ");
        buf.append("       ,fil.fil_fraseemailresultados as emailResultado ");
        buf.append("       ,fil.fil_fraseemailsenhaweb as emailSenhaWeb ");
        buf.append("       ,fil.fil_fraseemailrecoleta as emailRecoleta ");
        buf.append("       ,fil.fil_fraseemailrequisicao as emailRequisicao ");
        buf.append("       ,fil.fil_fraseemailproposta as emailProposta ");
        buf.append("       ,fil.fil_emailassuntoaniversario as assuntoAniversario ");
        buf.append("       ,fil.fil_emailassuntosenhaweb as assuntoSenhaWeb ");
        buf.append("       ,fil.fil_emailassuntoresultados as assuntoResultado ");
        buf.append("       ,fil.fil_emailassuntorecoleta as assuntoRecoleta ");
        buf.append("       ,fil.fil_assuntoemailrequisicao as assuntoRequisicao ");
        buf.append("       ,fil.fil_assuntoemailproposta as assuntoProposta ");
        buf.append("       ,fil.fil_configuracaoemail as xml ");
        buf.append("       ,fil.fil_emailparacontatos as emailparacontatos ");
        buf.append("       ,fil.fil_emailentrega as enviarEmailResultadoAtrasado ");
        buf.append("       ,fil.fil_fraseemailentrega as emailResultadoAtrasado ");
        buf.append("       ,fil.fil_assuntoemailentrega assuntoResultadoAtrasado ");
        buf.append("   from paciente pac ");
        buf.append("   join filiais_postocoleta fil on pac.fil_codigo = fil.fil_codigo ");
        buf.append("  where pac.fil_codigo = ? ");
        buf.append("    and pac.pac_codigo = ? ");
        sqlDadosPaciente = buf.toString();
        buf.setLength(0);
        buf.append(" select COALESCE(fil_enviaremail, false) as enviarEmail ");
        buf.append("       ,fil_emailaniversario as enviarEmailAniversario ");
        buf.append("       ,fil_emailresultados as enviarEmailResultado ");
        buf.append("       ,fil_emailentrega as enviarEmailResultadoAtrasado ");
        buf.append("       ,fil_emailsenhaweb as enviarEmailSenhaWeb ");
        buf.append("       ,fil_emailrecoleta as enviarEmailRecoleta ");
        buf.append("       ,fil_emailrequisicao as enviarEmailRequisicao ");
        buf.append("       ,fil_emailproposta as enviarEmailProposta ");
        buf.append("       ,fil_emailcotacao as enviarEmailCotacao ");
        buf.append("       ,fil_emailnfse as enviarEmailNfse ");
        buf.append("       ,fil_fraseemailaniversario as emailAniversario ");
        buf.append("       ,fil_fraseemailresultados as emailResultado ");
        buf.append("       ,fil_fraseemailsenhaweb as emailSenhaWeb ");
        buf.append("       ,fil_fraseemailrecoleta as emailRecoleta ");
        buf.append("       ,fil_fraseemailrequisicao as emailRequisicao ");
        buf.append("       ,fil_fraseemailproposta as emailProposta ");
        buf.append("       ,fil_fraseemailcotacao as emailCotacao ");
        buf.append("       ,fil_fraseemailnfse as emailNfse ");
        buf.append("       ,fil_emailassuntoaniversario as assuntoAniversario ");
        buf.append("       ,fil_emailassuntosenhaweb as assuntoSenhaWeb ");
        buf.append("       ,fil_emailassuntoresultados as assuntoResultado ");
        buf.append("       ,fil_emailassuntorecoleta as assuntoRecoleta ");
        buf.append("       ,fil_assuntoemailrequisicao as assuntoRequisicao ");
        buf.append("       ,fil_assuntoemailproposta as assuntoProposta ");
        buf.append("       ,fil_assuntoemailcotacao as assuntoCotacao ");
        buf.append("       ,fil_assuntoemailnfse as assuntoNfse ");
        buf.append("       ,fil_configuracaoemail as xml ");
        buf.append("       ,fil_descricao as filialDescricao");
        buf.append("       ,fil_cnpj as filialCnpj");
        buf.append("       ,fil_endereco as filialEndereco");
        buf.append("       ,fil_responsavel as filialResponsavel");
        buf.append("       ,fil_email as filialEmail");
        buf.append("       ,fil_emailparacontatos as emailparacontatos ");
        buf.append("       ,fil_fraseemailentrega as emailResultadoAtrasado ");
        buf.append("       ,fil_assuntoemailentrega assuntoResultadoAtrasado ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  where fil_codigo = ? ");
        sqlDadosFilial = buf.toString();
        buf.setLength(0);
        buf.append(" select con.con_codigo as convenioCodigo ");
        buf.append(" \t\t\t ,con.des_codigo as destinoCodigo ");
        buf.append(" \t\t\t ,con.col_codigo as coletaCodigo ");
        buf.append(" \t\t\t ,con.con_razao as razaoSocial ");
        buf.append(" \t\t\t ,con.con_fantasia as nomeFantasia ");
        buf.append(" \t\t\t ,con.con_email1 as email1 ");
        buf.append(" \t\t\t ,con.con_email2 as email2 ");
        buf.append("       ,COALESCE(fil.fil_enviaremail, false) as enviarEmail ");
        buf.append("       ,fil.fil_emailaniversario as enviarEmailAniversario ");
        buf.append("       ,fil.fil_emailresultados as enviarEmailResultado ");
        buf.append("       ,fil.fil_emailsenhaweb as enviarEmailSenhaWeb ");
        buf.append("       ,fil.fil_emailrecoleta as enviarEmailRecoleta ");
        buf.append("       ,fil.fil_emailrequisicao as enviarEmailRequisicao ");
        buf.append("       ,fil.fil_emailproposta as enviarEmailProposta ");
        buf.append("       ,fil.fil_emailentrega as enviarEmailResultadoAtrasado ");
        buf.append("       ,fil.fil_emailnfse as enviarEmailNfse ");
        buf.append("       ,fil.fil_fraseemailaniversario as emailAniversario ");
        buf.append("       ,fil.fil_fraseemailresultados as emailResultado ");
        buf.append("       ,fil.fil_fraseemailsenhaweb as emailSenhaWeb ");
        buf.append("       ,fil.fil_fraseemailrecoleta as emailRecoleta ");
        buf.append("       ,fil.fil_fraseemailrequisicao as emailRequisicao ");
        buf.append("       ,fil.fil_fraseemailproposta as emailProposta ");
        buf.append("       ,fil.fil_fraseemailnfse as emailNfse ");
        buf.append("       ,fil.fil_emailassuntoaniversario as assuntoAniversario ");
        buf.append("       ,fil.fil_emailassuntosenhaweb as assuntoSenhaWeb ");
        buf.append("       ,fil.fil_emailassuntoresultados as assuntoResultado ");
        buf.append("       ,fil.fil_emailassuntorecoleta as assuntoRecoleta ");
        buf.append("       ,fil.fil_assuntoemailrequisicao as assuntoRequisicao ");
        buf.append("       ,fil.fil_assuntoemailproposta as assuntoProposta ");
        buf.append("       ,fil.fil_assuntoemailnfse as assuntoNfse ");
        buf.append("       ,fil.fil_configuracaoemail as xml ");
        buf.append("       ,fil.fil_emailparacontatos as emailparacontatos ");
        buf.append("       ,fil.fil_fraseemailentrega as emailResultadoAtrasado ");
        buf.append("       ,fil.fil_assuntoemailentrega assuntoResultadoAtrasado ");
        buf.append("   from filiais_postocoleta fil ");
        buf.append("   inner join convenios con on con.fil_codigo = fil.fil_codigo ");
        buf.append("  where fil.fil_codigo = ?  and con.con_codigo = ? ");
        sqlDadosFilialConvenioProposta = buf.toString();
        buf.setLength(0);
        buf.append(" insert into logemail ");
        buf.append(" values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        sqlInsereLog = buf.toString();
        buf.setLength(0);
        buf.append(" update logemail ");
        buf.append("    set ema_situacao = ? ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and ema_codigo = ? ");
        sqlAtualizaSituacaoLog = buf.toString();
        buf.setLength(0);
        buf.append(" select bool_or(CASE WHEN req_emailresultadoenviado is null then false else true end) as emailEnviado ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ?");
        sqlRequisicaoEnviouEmail = buf.toString();
        buf.setLength(0);
        buf.append("select (count(*) = sum( case when exr_situacao in  ( ?, ?, ?, ?) then 1 end )) ");
        buf.append("as prontos from examerequisicao where fil_codigo = ? and req_codigo = ? and not exr_excluido");
        sqlExamesProntosRequisicao = buf.toString();
        buf.setLength(0);
        buf.append(" update examerequisicao ");
        buf.append("    set usr_codenvioemail = ? ");
        buf.append("    \t ,exr_dataenvioemail = ? ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        sqlAtualizaExameReqLog = buf.toString();
        buf.setLength(0);
        buf.append(" select COALESCE(fil.fil_enviaremail, false) as enviarEmail, COALESCE(fil.fil_emailsenhawebmedico, false) as enviarEmailMedico ");
        buf.append(" from filiais_postocoleta fil");
        buf.append("  where fil.fil_codigo = ? ");
        sqlFilialEnviaEmailSenhaWeb = buf.toString();
        buf.setLength(0);
        buf.append(" update requisicao ");
        buf.append("    set req_emailresultadoenviado = ? ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and req_codigo = ? ");
        sqlAtualizaRequisicao = buf.toString();
        buf.setLength(0);
        buf.append(" select con_bloquearemailexampronto as bloquearResultado");
        buf.append("       ,con_bloquearemailrecoleta as bloquearRecoleta ");
        buf.append("       ,con_bloquearemailaniversario as bloquearAniversario ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ? ");
        buf.append("    and con_codigo = ? ");
        sqlBloqueiosEnvioEmailConvenio = buf.toString();
        buf.setLength(0);
        buf.append(" select fil_enviaremail as enviarEmail , fil_fraseemailsenhawebmedico as emailSenhaWebMedico ");
        buf.append("  ,fil_emailsenhawebmedico as enviarEmailSenhaWebMedico ,fil_assuntoemailsenhawebmedico as assuntoSenhaWebMedico ");
        buf.append(" ,med_nome as nomeMedico ");
        buf.append(" ,med_crm as crmMedico ");
        buf.append(" ,med_email as enderecoEmailMedico ");
        buf.append(" ,med_senhaweb as senhaWebMedico ");
        buf.append(" ,med_abrev as tratamentoMedico");
        buf.append(" ,'' as chaveAcessoRequisicao ");
        buf.append("  from medico ");
        buf.append("  left join filiais_postocoleta fil on medico.fil_codigo = fil.fil_codigo ");
        buf.append("  where medico.fil_codigo = ? ");
        buf.append("  and med_crm = ? ");
        buf.append("  and med_uf = ? ");
        buf.append("  and med_conselho = ? ");
        sqlDadosMedico = buf.toString();
    }

    public static enum TipoEmail {
        ANIVERSARIO(0, "Anivers\u00e1rio"),
        RESULTADO(1, "Resultado"),
        SENHA_WEB(2, "senha web do paciente"),
        RECOLETA(3, "Recoleta"),
        REQUISICAO(4, "Requisi\u00e7\u00e3o"),
        PROPOSTA(5, "Proposta/or\u00e7amento"),
        NOTA_FISCAL(6, "Nota Fiscal Eletr\u00f4nica"),
        RESULTADO_PDF(7, "Resultado em pdf"),
        RESULTADO_CERTIFICADO_ANALISE(8, "Resultado certificado an\u00e1lise"),
        ATRASO_ENTREGA(9, "Atraso de entrega"),
        AGENDAMENTO("E", "Agendamento"),
        COTACAO_FORNECEDOR("A", "cota\u00e7\u00e3o para fornededores"),
        SENHA_WEB_MEDICO("B", "senha web para o m\u00e9dico"),
        SENHA_WEB_COLETADOR("C", "senha web para o coletador"),
        SENHA_WEB_CLIENTE("D", "senha web do cliente");

        Object codigo = null;
        String descricao = null;

        private TipoEmail(Object codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public Object getCodigo() {
            return this.codigo;
        }
    }
}

