/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.soroteca.util.Exame;
import jalis.laboratorio.triagem.soroteca.util.ExameRecipiente;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.bean.configuracao.UsuarioBean;
import jalis.model.bean.triagem.RecipienteBean;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.cadastro.triagem.EstanteService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.triagem.RecipienteService;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.logger.ErrorLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TuboDao {
    public static Tubo carregaTubo(String etiqueta, boolean ignorarEstante) throws Exception {
        int digRecipiente;
        int digRequisicao;
        int digFilial = ParametrosGerais.getDigitosTuboFilial();
        int digTotal = digFilial + (digRequisicao = ParametrosGerais.getDigitosTuboRequisicao()) + (digRecipiente = ParametrosGerais.getDigitosTuboTubo());
        if (digTotal == etiqueta.length()) {
            int codigoFilialTubo = Integer.valueOf(etiqueta.substring(0, digFilial));
            int codigoRequisicao = Integer.valueOf(etiqueta.substring(digFilial, digRequisicao + digFilial));
            int codigoRecipienteFilho = Integer.valueOf(etiqueta.substring(digFilial + digRequisicao));
            return TuboDao.carregaTubo(Integer.parseInt(Variaveis.filialPadrao), codigoFilialTubo, codigoRequisicao, codigoRecipienteFilho, null, null, ignorarEstante, false);
        }
        return null;
    }

    public static ArrayList<Tubo> carregaTubosConsulta(String etiqueta, boolean ignorarEstante, boolean buscarRemovidos) throws Exception {
        int digRecipiente;
        int digRequisicao;
        int digFilial = ParametrosGerais.getDigitosTuboFilial();
        int digTotal = digFilial + (digRequisicao = ParametrosGerais.getDigitosTuboRequisicao()) + (digRecipiente = ParametrosGerais.getDigitosTuboTubo());
        if (digTotal == etiqueta.length()) {
            int codigoFilialTubo = Integer.valueOf(etiqueta.substring(0, digFilial));
            int codigoRequisicao = Integer.valueOf(etiqueta.substring(digFilial, digRequisicao + digFilial));
            int codigoRecipienteFilho = Integer.valueOf(etiqueta.substring(digFilial + digRequisicao));
            return TuboDao.carregaTubosConsulta(Integer.parseInt(Variaveis.filialPadrao), codigoFilialTubo, codigoRequisicao, codigoRecipienteFilho, null, null, ignorarEstante, false, buscarRemovidos);
        }
        return null;
    }

    public static ArrayList<Tubo> carregaTubos(String etiqueta) throws Exception {
        int digRecipiente;
        int digRequisicao;
        int digFilial = ParametrosGerais.getDigitosTuboFilial();
        int digTotal = digFilial + (digRequisicao = ParametrosGerais.getDigitosTuboRequisicao()) + (digRecipiente = ParametrosGerais.getDigitosTuboTubo());
        if (digTotal == etiqueta.length()) {
            int codigoFilialTubo = Integer.valueOf(etiqueta.substring(0, digFilial));
            int codigoRequisicao = Integer.valueOf(etiqueta.substring(digFilial, digRequisicao + digFilial));
            int codigoRecipienteFilho = Integer.valueOf(etiqueta.substring(digFilial + digRequisicao));
            return TuboDao.carregaTubos(Integer.parseInt(Variaveis.filialPadrao), codigoFilialTubo, codigoRequisicao, codigoRecipienteFilho);
        }
        return null;
    }

    public static Tubo carregaTubo(int codigoFilial, int codigoFilialTubo, int codigoRequisicao, int codigoRecipienteFilho, Integer codigoSoroteca, Integer codigoEstante, boolean ignorarEstante, boolean isCarregandoEstante) throws Exception {
        ResultSet rs;
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ArrayList<ExameRecipiente> examesRecipiente = new ArrayList<ExameRecipiente>();
        String codigosMultiguia = "";
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            Integer[] aux = RecepcaoUtil.verificaMultiGuias(String.valueOf(codigoFilialTubo), String.valueOf(codigoRequisicao), true);
            for (int i = 0; i < aux.length; ++i) {
                codigosMultiguia = codigosMultiguia + aux[i];
                if (i >= aux.length - 1) continue;
                codigosMultiguia = codigosMultiguia + ", ";
            }
        } else {
            codigosMultiguia = codigosMultiguia + codigoRequisicao;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct a.fil_codigo ");
        if (codigoEstante != null && !ignorarEstante) {
            sql.append("       ,COALESCE(eso.eso_linhasoroteca, -1) as eso_linhasoroteca");
            sql.append("       ,COALESCE(eso.eso_colunasoroteca, -1) as eso_colunasoroteca");
            sql.append("       ,eso.eso_datahorasoroteca ");
            sql.append("       ,ett.ett_codigo ");
            sql.append("       ,eso.eso_datahoradescarte ");
            sql.append("       ,eso.usr_coddescarte ");
            sql.append("       ,eso.usr_codsoroteca ");
        } else {
            sql.append("       ,null as eso_linhasoroteca");
            sql.append("       ,null as eso_colunasoroteca");
            sql.append("       ,null as eso_datahorasoroteca ");
            sql.append("       ,null as ett_codigo ");
            sql.append("       ,null as eso_datahoradescarte ");
            sql.append("       ,null as usr_coddescarte ");
            sql.append("       ,null as usr_codsoroteca ");
        }
        sql.append("       ,a.req_codigo ");
        sql.append("       ,a.rec_codigo ");
        sql.append("       ,a.rec_kodigo ");
        sql.append("       ,b.exa_codigo ");
        sql.append("       ,b.exa_descricao ");
        sql.append("       ,c.exr_situacao ");
        sql.append("       ,d.pac_codigo ");
        sql.append("       ,d.req_data ");
        sql.append("       ,emc.emc_conservarsoroteca ");
        sql.append("       ,COALESCE(emc.emc_temposoroteca, 0) as emc_temposoroteca ");
        sql.append("       ,COALESCE(emc.emc_tipotemposoroteca, '").append("D").append("') as emc_tipotemposoroteca ");
        sql.append("       ,mco.mco_codigo ");
        sql.append("       ,mco.mco_abreviatura ");
        sql.append("       ,COALESCE(a.ere_tipo, 'C') as ere_tipo ");
        sql.append("       ,set.set_codigo ");
        sql.append("       ,set.set_descricao ");
        sql.append("       ,set.set_sigla ");
        sql.append("   from examerequisicaorecipiente a ");
        if (codigoEstante != null && !ignorarEstante) {
            sql.append(" LEFT JOIN examerequisicaosoroteca eso ");
            sql.append(" ON a.fil_codigo = eso.fil_kodigo ");
            sql.append(" AND a.exa_codigo = eso.exa_codigo ");
            sql.append(" AND a.mco_codigo = eso.mco_codigo ");
            sql.append(" AND a.req_codigo = eso.req_codigo ");
            sql.append(" AND a.rec_codigo = eso.rec_codigo");
            sql.append(" AND a.rec_kodigo = eso.rec_kodigo");
            sql.append("   left join estantes ett on eso.fil_codigo = ett.fil_codigo and eso.ett_codigo = ett.ett_codigo ");
        }
        sql.append("   join exames          b   on a.fil_codigo = b.fil_codigo     and a.exa_codigo = b.exa_codigo ");
        sql.append("   join examerequisicao c   on a.fil_codigo = c.fil_codigo     and a.req_codigo = c.req_codigo    and a.exa_codigo = c.exa_codigo   and a.mco_codigo = c.mco_codigo and c.exr_excluido = false ");
        sql.append("   join requisicao      d   on c.fil_codigo = d.fil_codigo     and c.req_codigo = d.req_codigo    and d.req_excluida = false ");
        sql.append("   join examematcoleta  emc on c.fil_codigo = emc.fil_codigo   and c.exa_codigo = emc.exa_codigo  and c.mco_codigo = emc.mco_codigo ");
        sql.append("   join materialcoleta  mco on c.fil_codigo = mco.fil_codigo   and c.mco_codigo = mco.mco_codigo ");
        sql.append("   join examesetor      ese on b.fil_codigo = ese.fil_codigo   and b.exa_codigo = ese.exa_codigo ");
        sql.append("   join setores \t\t\t  set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        sql.append("  where a.fil_codigo = ").append(codigoFilialTubo);
        sql.append("    and a.req_codigo IN (").append(codigosMultiguia).append(") ");
        if (codigoEstante != null && !ignorarEstante) {
            sql.append("    and eso.rec_kodigo = ").append(codigoRecipienteFilho);
        } else {
            sql.append("    and a.rec_kodigo = ").append(codigoRecipienteFilho);
        }
        if (codigoSoroteca != null) {
            sql.append("    and eso.eso_codigo = ").append(codigoSoroteca);
            sql.append("    and eso.fil_kodigo = ").append(codigoFilialTubo);
            sql.append("    and eso.fil_codigo = ").append(codigoFilial);
        }
        if (codigoEstante != null) {
            sql.append("    and eso.ett_codigo = ").append(codigoEstante);
        }
        if (codigoEstante != null && !ignorarEstante && !isCarregandoEstante) {
            sql.append(" and ((eso.set_codigo, eso.eso_codigo) IN (select set_codigo, MAX(eso_codigo) ");
            sql.append("                                             from examerequisicaosoroteca ");
            sql.append("                                            where fil_codigo = ").append(codigoFilial);
            sql.append("                                              and fil_kodigo = ").append(codigoFilialTubo);
            sql.append("                                              and req_codigo = ").append(codigoRequisicao);
            sql.append("                                              and rec_kodigo = ").append(codigoRecipienteFilho);
            sql.append("                                              and ett_codigo = ").append(codigoEstante);
            sql.append("                                              and eso_datahoradescarte IS NULL ");
            sql.append("                                            group by set_codigo ").append(") OR eso.eso_codigo IS NULL) ");
        }
        if ((rs = Conexao.executeQuery(st, sql)).next()) {
            Integer auxMenorRequisicao = null;
            do {
                Exame exame = new Exame(codigoFilial, rs.getInt("req_codigo"), rs.getString("exa_codigo"), rs.getString("exa_descricao"), rs.getString("exr_situacao"), rs.getInt("mco_codigo"), rs.getString("mco_abreviatura"), rs.getInt("set_codigo"), rs.getString("set_descricao"), rs.getInt("emc_temposoroteca"), rs.getString("emc_conservarSoroteca"), rs.getString("emc_tipotemposoroteca"));
                RecipienteBean recipientePai = (RecipienteBean)new RecipienteService().get(rs.getString("fil_codigo"), rs.getString("rec_codigo"));
                RecipienteBean recipienteFilho = (RecipienteBean)new RecipienteService().get(rs.getString("fil_codigo"), rs.getString("rec_kodigo"));
                examesRecipiente.add(new ExameRecipiente(exame, recipientePai, recipienteFilho));
                if (auxMenorRequisicao != null && auxMenorRequisicao <= rs.getInt("req_codigo")) continue;
                auxMenorRequisicao = rs.getInt("req_codigo");
            } while (rs.next());
            rs.first();
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            PacienteVO paciente = (PacienteVO)new PacienteService().getVO(rs.getString("fil_codigo"), rs.getString("pac_codigo"));
            EstanteBean estante = (EstanteBean)new EstanteService().get(rs.getString("fil_codigo"), rs.getString("ett_codigo"));
            UsuarioBean usuario = null;
            if (rs.getString("usr_coddescarte") != null) {
                usuario = (UsuarioBean)new UsuarioService().get(rs.getString("usr_coddescarte"));
            }
            if (examesRecipiente.size() > 0) {
                Integer codigoAux = 0;
                if (codigoSoroteca == null) {
                    StringBuilder bufCodigo = new StringBuilder();
                    bufCodigo.append(" select MAX(eso_codigo) as codigo ");
                    bufCodigo.append("   from examerequisicaosoroteca ");
                    bufCodigo.append("  where fil_codigo = ").append(codigoFilial);
                    bufCodigo.append("    and fil_kodigo = ").append(codigoFilialTubo);
                    bufCodigo.append(" and req_codigo in( ").append(codigosMultiguia).append(")");
                    bufCodigo.append("    and rec_codigo = ").append(rs.getInt("rec_codigo"));
                    ResultSet rsCodigo = Conexao.executeQuery(st2, bufCodigo.toString());
                    if (rsCodigo != null) {
                        if (rsCodigo.next() && rsCodigo.getString("codigo") != null) {
                            codigoAux = rsCodigo.getInt("codigo");
                            codigoSoroteca = codigoAux = Integer.valueOf(codigoAux + 1);
                        } else {
                            codigoSoroteca = 0;
                        }
                    }
                }
                SetorVO setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao.toString(), rs.getString("set_codigo"));
                Timestamp data = rs.getTimestamp("eso_datahorasoroteca");
                UsuarioBean usuarioSoroteca = null;
                if (rs.getString("usr_codsoroteca") != null) {
                    usuarioSoroteca = (UsuarioBean)new UsuarioService().get(rs.getString("usr_codsoroteca"));
                }
                Tubo tubo = new Tubo(filial, examesRecipiente, paciente, rs.getInt("eso_linhasoroteca"), rs.getInt("eso_colunasoroteca"), data, estante, rs.getDate("req_data"), rs.getString("ere_tipo"), rs.getTimestamp("eso_datahoradescarte"), usuario, codigoSoroteca == null ? 0 : codigoSoroteca, usuarioSoroteca, auxMenorRequisicao);
                tubo.setSetor(setor);
                return tubo;
            }
        }
        return new Tubo("", new ArrayList<Exame>());
    }

    public static ArrayList<Tubo> carregaTubosConsulta(int codigoFilial, int codigoFilialTubo, int codigoRequisicao, int codigoRecipienteFilho, Integer codigoSoroteca, Integer codigoEstante, boolean ignorarEstante, boolean isCarregandoEstante, boolean buscarRemovidos) throws Exception {
        Statement st = Conexao.getStatement();
        ArrayList<Exame> exames = null;
        String codigosMultiguia = "";
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            Integer[] aux = RecepcaoUtil.verificaMultiGuias(String.valueOf(codigoFilialTubo), String.valueOf(codigoRequisicao), true);
            for (int i = 0; i < aux.length; ++i) {
                codigosMultiguia = codigosMultiguia + aux[i];
                if (i >= aux.length - 1) continue;
                codigosMultiguia = codigosMultiguia + ", ";
            }
        } else {
            codigosMultiguia = codigosMultiguia + codigoRequisicao;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct a.fil_codigo ");
        sql.append("       ,COALESCE(eso.eso_linhasoroteca, -1) as eso_linhasoroteca");
        sql.append("       ,COALESCE(eso.eso_colunasoroteca, -1) as eso_colunasoroteca");
        sql.append("       ,eso.eso_datahorasoroteca ");
        sql.append("       ,ett.ett_codigo ");
        sql.append("       ,eso.eso_datahoradescarte ");
        sql.append("       ,eso.usr_coddescarte ");
        sql.append("       ,eso.usr_codsoroteca ");
        sql.append("       ,eso.eso_codigo ");
        sql.append("       ,a.req_codigo ");
        sql.append("       ,a.rec_codigo ");
        sql.append("       ,a.rec_kodigo ");
        sql.append("       ,b.exa_codigo ");
        sql.append("       ,b.exa_descricao ");
        sql.append("       ,c.exr_situacao ");
        sql.append("       ,d.pac_codigo ");
        sql.append("       ,d.req_data ");
        sql.append("       ,emc.emc_conservarsoroteca ");
        sql.append("       ,COALESCE(emc.emc_temposoroteca, 0) as emc_temposoroteca ");
        sql.append("       ,COALESCE(emc.emc_tipotemposoroteca, '").append("D").append("') as emc_tipotemposoroteca ");
        sql.append("       ,mco.mco_codigo ");
        sql.append("       ,mco.mco_abreviatura ");
        sql.append("       ,COALESCE(a.ere_tipo, 'C') as ere_tipo ");
        sql.append("       ,set.set_codigo ");
        sql.append("       ,set.set_descricao ");
        sql.append("       ,eso.eso_codigo ");
        sql.append("   from examerequisicaorecipiente a ");
        sql.append("   join examerequisicaosoroteca eso on a.fil_codigo = eso.fil_kodigo and a.exa_codigo = eso.exa_codigo and a.req_codigo = eso.req_codigo and a.rec_codigo = eso.rec_codigo and a.rec_kodigo = eso.rec_kodigo ");
        sql.append("   join estantes ett on eso.fil_codigo = ett.fil_codigo and eso.ett_codigo = ett.ett_codigo ");
        sql.append("   join exames          b   on a.fil_codigo = b.fil_codigo     and a.exa_codigo = b.exa_codigo ");
        sql.append("   join examerequisicao c   on a.fil_codigo = c.fil_codigo     and a.req_codigo = c.req_codigo    and a.exa_codigo = c.exa_codigo   and a.mco_codigo = c.mco_codigo and c.exr_excluido = false ");
        sql.append("   join requisicao      d   on c.fil_codigo = d.fil_codigo     and c.req_codigo = d.req_codigo    and d.req_excluida = false ");
        sql.append("   join examematcoleta  emc on c.fil_codigo = emc.fil_codigo   and c.exa_codigo = emc.exa_codigo  and c.mco_codigo = emc.mco_codigo ");
        sql.append("   join materialcoleta  mco on c.fil_codigo = mco.fil_codigo   and c.mco_codigo = mco.mco_codigo ");
        sql.append("   join examesetor      ese on b.fil_codigo = ese.fil_codigo   and b.exa_codigo = ese.exa_codigo ");
        sql.append("   join setores \t\t\t  set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        sql.append("  where a.fil_codigo = ").append(codigoFilialTubo);
        sql.append("    and a.req_codigo IN (").append(codigosMultiguia).append(") ");
        sql.append("    and eso.rec_kodigo = ").append(codigoRecipienteFilho);
        if (codigoSoroteca != null) {
            sql.append("    and eso.eso_codigo = ").append(codigoSoroteca);
            sql.append("    and eso.fil_codigo = ").append(codigoFilial);
        }
        if (codigoEstante != null) {
            sql.append("    and eso.ett_codigo = ").append(codigoEstante);
        }
        if (codigoEstante != null && !ignorarEstante && !isCarregandoEstante) {
            sql.append(" and ((eso.set_codigo, eso.eso_codigo) IN (select set_codigo, MAX(eso_codigo) ");
            sql.append("                                             from examerequisicaosoroteca ");
            sql.append("                                            where fil_codigo = ").append(codigoFilial);
            sql.append("                                              and fil_kodigo = ").append(codigoFilialTubo);
            sql.append("                                              and req_codigo = ").append(codigoRequisicao);
            sql.append("                                              and rec_kodigo = ").append(codigoRecipienteFilho);
            sql.append("                                              and ett_codigo = ").append(codigoEstante);
            sql.append("                                              and eso_datahoradescarte IS NULL ");
            sql.append("                                            group by set_codigo ").append(") OR eso.eso_codigo IS NULL) ");
        }
        if (!buscarRemovidos) {
            sql.append(" and eso.usr_coddescarte IS NULL ");
            sql.append(" and eso.eso_datahoradescarte IS NULL ");
            sql.append(" and ett.ett_codigo IS NOT NULL ");
        }
        sql.append("  order by ett.ett_codigo, eso.eso_codigo ");
        ArrayList<Tubo> tubos = new ArrayList<Tubo>();
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            Integer auxMenorRequisicao = null;
            exames = new ArrayList<Exame>();
            int auxCodigoEstante = rs.getInt("ett_codigo");
            int auxCodigoSoroteca = rs.getInt("eso_codigo");
            do {
                if (auxCodigoEstante != rs.getInt("ett_codigo") || auxCodigoSoroteca != rs.getInt("eso_codigo")) {
                    rs.previous();
                    break;
                }
                boolean jaExiste = false;
                for (int i = 0; i < exames.size(); ++i) {
                    if (!((Exame)exames.get(i)).getCodigo().equalsIgnoreCase(rs.getString("exa_codigo")) || ((Exame)exames.get(i)).getCodigoMaterial() != rs.getInt("mco_codigo")) continue;
                    jaExiste = true;
                    break;
                }
                if (jaExiste) continue;
                exames.add(new Exame(codigoFilial, rs.getInt("req_codigo"), rs.getString("exa_codigo"), rs.getString("exa_descricao"), rs.getString("exr_situacao"), rs.getInt("mco_codigo"), rs.getString("mco_abreviatura"), rs.getInt("set_codigo"), rs.getString("set_descricao"), rs.getInt("emc_temposoroteca"), rs.getString("emc_conservarSoroteca"), rs.getString("emc_tipotemposoroteca")));
                if (auxMenorRequisicao != null && auxMenorRequisicao <= rs.getInt("req_codigo")) continue;
                auxMenorRequisicao = rs.getInt("req_codigo");
            } while (rs.next());
            if (rs.isAfterLast()) {
                rs.previous();
            }
            FilialVO filial = new FilialVO();
            filial.setCodigo(codigoFilialTubo);
            RecipienteBean recipientePai = (RecipienteBean)new RecipienteService().get(String.valueOf(codigoFilial), rs.getString("rec_codigo"));
            RecipienteBean recipienteFilho = (RecipienteBean)new RecipienteService().get(String.valueOf(codigoFilial), rs.getString("rec_kodigo"));
            PacienteVO paciente = (PacienteVO)new PacienteService().getVO(rs.getString("fil_codigo"), rs.getString("pac_codigo"));
            EstanteBean estante = null;
            estante = !buscarRemovidos ? (EstanteBean)new EstanteService().get(String.valueOf(codigoFilial), rs.getString("ett_codigo")) : (EstanteBean)new EstanteService().getIncluirDescartadas(String.valueOf(codigoFilial), rs.getString("ett_codigo"));
            UsuarioBean usuarioDescarte = null;
            if (rs.getString("usr_coddescarte") != null) {
                usuarioDescarte = (UsuarioBean)new UsuarioService().get(rs.getString("usr_coddescarte"));
            }
            UsuarioBean usuarioSoroteca = null;
            if (rs.getString("usr_codsoroteca") != null) {
                usuarioSoroteca = (UsuarioBean)new UsuarioService().get(rs.getString("usr_codsoroteca"));
            }
            if (exames.size() <= 0) continue;
            SetorVO setor = new SetorVO();
            setor.setCodigo(rs.getInt("set_codigo"));
            setor.setDescricao(rs.getString("set_descricao"));
            Tubo tubo = new Tubo(filial, recipientePai, recipienteFilho, exames, paciente, rs.getInt("eso_linhasoroteca"), rs.getInt("eso_colunasoroteca"), rs.getTimestamp("eso_datahorasoroteca"), estante, rs.getDate("req_data"), rs.getString("ere_tipo"), rs.getTimestamp("eso_datahoradescarte"), usuarioDescarte, codigoSoroteca == null ? rs.getInt("eso_codigo") : codigoSoroteca.intValue(), usuarioSoroteca, auxMenorRequisicao);
            tubo.setSetor(setor);
            tubos.add(tubo);
        }
        return tubos;
    }

    public static String verificaTuboOutraEstante(int filial, int filialTubo, int requisicao, int recipienteFilho, Integer estanteAtual, Integer setor) throws Exception {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct a.fil_codigo ");
        sql.append("       ,COALESCE(eso.eso_linhasoroteca, -1) as eso_linhasoroteca");
        sql.append("       ,COALESCE(eso.eso_colunasoroteca, -1) as eso_colunasoroteca");
        sql.append("       ,eso.eso_datahorasoroteca ");
        sql.append("       ,ett.ett_codigo ");
        sql.append("       ,eso.eso_datahoradescarte ");
        sql.append("       ,eso.usr_coddescarte ");
        sql.append("       ,eso.usr_codsoroteca ");
        sql.append("       ,a.rec_codigo ");
        sql.append("       ,a.rec_kodigo ");
        sql.append("       ,req.req_data ");
        sql.append("       ,COALESCE(a.ere_tipo, 'C') as ere_tipo ");
        sql.append("   from examerequisicaorecipiente a ");
        sql.append("   left join examerequisicaosoroteca eso on a.fil_codigo = eso.fil_kodigo and a.exa_codigo = eso.exa_codigo and a.req_codigo = eso.req_codigo and a.rec_codigo = eso.rec_codigo ");
        sql.append("   left join estantes ett on eso.fil_codigo = ett.fil_codigo and eso.ett_codigo = ett.ett_codigo ");
        sql.append("   join requisicao req on eso.fil_kodigo = req.fil_codigo and eso.req_codigo = req.req_codigo and req.req_excluida = false ");
        sql.append("  where a.fil_codigo = ").append(filialTubo);
        sql.append("    and eso.fil_codigo = ").append(filial);
        sql.append("    and a.req_codigo = ").append(requisicao);
        sql.append("    and a.rec_kodigo = ").append(recipienteFilho);
        sql.append("    and eso.ett_codigo != ").append(estanteAtual);
        sql.append("    and eso.eso_datahoradescarte IS NULL ");
        sql.append("    and ett.ett_datadescarte IS NULL ");
        sql.append("    and eso.set_codigo = ").append(setor);
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            StringBuilder msg = new StringBuilder();
            do {
                FilialVO filialVO = new FilialVO();
                filialVO.setCodigo(filial);
                RecipienteBean recipientePaiBean = (RecipienteBean)new RecipienteService().get(rs.getString("fil_codigo"), rs.getString("rec_codigo"));
                RecipienteBean recipienteFilhoBean = (RecipienteBean)new RecipienteService().get(rs.getString("fil_codigo"), rs.getString("rec_kodigo"));
                EstanteBean estanteVO = (EstanteBean)new EstanteService().get(String.valueOf(filial), rs.getString("ett_codigo"));
                UsuarioBean usuarioSoroteca = null;
                if (rs.getString("usr_codsoroteca") != null) {
                    usuarioSoroteca = (UsuarioBean)new UsuarioService().get(rs.getString("usr_codsoroteca"));
                }
                Tubo tubo = new Tubo(filialVO, recipientePaiBean, recipienteFilhoBean, new ArrayList<Exame>(), null, rs.getInt("eso_linhasoroteca"), rs.getInt("eso_colunasoroteca"), rs.getDate("eso_datahorasoroteca"), estanteVO, rs.getDate("req_data"), rs.getString("ere_tipo"), rs.getTimestamp("eso_datahoradescarte"), null, 0, usuarioSoroteca, requisicao);
                msg.append("\nGeladeira: \"" + tubo.getEstante().getPrateleira().getGeladeira().getDescricao() + "\", Estante: \"" + tubo.getEstante().getIdentificador() + "\", Posi\u00e7\u00e3o: \"" + (char)(65 + tubo.getLinhaSoroteca()) + " " + (tubo.getColunaSoroteca() + 1) + "\".");
            } while (rs.next());
            return "O tubo j\u00e1 foi adicionado \u00e0 soroteca." + msg.toString() + "\n";
        }
        return null;
    }

    public static ArrayList<Tubo> carregaTubos(int codigoFilial, int codigoFilialTubo, int codigoRequisicao, int codigoRecipienteFilho) throws Exception {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ArrayList<Tubo> listaTubos = new ArrayList<Tubo>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct eso.ett_codigo ");
        sql.append("        ,eso.eso_codigo ");
        sql.append("   from examerequisicaorecipiente a ");
        sql.append("   left join examerequisicaosoroteca eso on a.fil_codigo = eso.fil_kodigo and a.exa_codigo = eso.exa_codigo and a.req_codigo = eso.req_codigo and a.rec_codigo = eso.rec_codigo ");
        sql.append("   left join estantes ett on eso.fil_codigo = ett.fil_codigo and eso.ett_codigo = ett.ett_codigo ");
        sql.append("   join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        sql.append("   join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.exr_excluido = false ");
        sql.append("   join requisicao d on c.fil_codigo = d.fil_codigo and c.req_codigo = d.req_codigo and d.req_excluida = false ");
        sql.append("   join examematcoleta emc on c.fil_codigo = emc.fil_codigo and c.exa_codigo = emc.exa_codigo and c.mco_codigo = emc.mco_codigo ");
        sql.append("   join materialcoleta mco on c.fil_codigo = mco.fil_codigo and c.mco_codigo = mco.mco_codigo ");
        sql.append("  where a.fil_codigo = ").append(codigoFilialTubo);
        sql.append("    and eso.fil_codigo = ").append(codigoFilial);
        sql.append("    and a.req_codigo = ").append(codigoRequisicao);
        sql.append("    and a.rec_kodigo = ").append(codigoRecipienteFilho);
        sql.append("    and eso.usr_coddescarte IS NULL ");
        sql.append("    and eso.eso_datahoradescarte IS NULL ");
        sql.append("  order by eso.ett_codigo ");
        sql.append("          ,eso.eso_codigo ");
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            sql.delete(0, sql.length());
            sql.append(" select distinct a.fil_codigo ");
            sql.append("       ,COALESCE(eso.eso_linhasoroteca, -1) as eso_linhasoroteca");
            sql.append("       ,COALESCE(eso.eso_colunasoroteca, -1) as eso_colunasoroteca");
            sql.append("       ,eso.eso_datahorasoroteca ");
            sql.append("       ,ett.ett_codigo ");
            sql.append("       ,eso.eso_datahoradescarte ");
            sql.append("       ,eso.usr_coddescarte ");
            sql.append("       ,eso.usr_codsoroteca ");
            sql.append("       ,d.req_codigo ");
            sql.append("       ,a.rec_codigo ");
            sql.append("       ,a.rec_kodigo ");
            sql.append("       ,b.exa_codigo ");
            sql.append("       ,b.exa_descricao ");
            sql.append("       ,c.exr_situacao ");
            sql.append("       ,d.pac_codigo ");
            sql.append("       ,d.req_data ");
            sql.append("       ,emc.emc_conservarsoroteca ");
            sql.append("       ,COALESCE(emc.emc_temposoroteca, 0) as emc_temposoroteca ");
            sql.append("       ,COALESCE(emc.emc_tipotemposoroteca, '").append("D").append("') as emc_tipotemposoroteca ");
            sql.append("       ,mco.mco_codigo ");
            sql.append("       ,mco.mco_abreviatura ");
            sql.append("       ,COALESCE(a.ere_tipo, 'C') as ere_tipo");
            sql.append("       ,set.set_codigo ");
            sql.append("       ,set.set_descricao ");
            sql.append("   from examerequisicaorecipiente    a ");
            sql.append("   left join examerequisicaosoroteca eso on a.fil_codigo = eso.fil_kodigo and a.exa_codigo = eso.exa_codigo and a.req_codigo = eso.req_codigo and a.rec_codigo = eso.rec_codigo ");
            sql.append("   left join estantes     ett on eso.fil_codigo = ett.fil_codigo and eso.ett_codigo = ett.ett_codigo ");
            sql.append("   join exames            b   on a.fil_codigo = b.fil_codigo     and a.exa_codigo = b.exa_codigo ");
            sql.append("   join examerequisicao   c   on a.fil_codigo = c.fil_codigo     and a.req_codigo = c.req_codigo     and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.exr_excluido = false ");
            sql.append("   join requisicao        d   on c.fil_codigo = d.fil_codigo     and c.req_codigo = d.req_codigo     and d.req_excluida = false ");
            sql.append("   join examematcoleta    emc on c.fil_codigo = emc.fil_codigo   and c.exa_codigo = emc.exa_codigo   and c.mco_codigo = emc.mco_codigo ");
            sql.append("   join materialcoleta    mco on c.fil_codigo = mco.fil_codigo   and c.mco_codigo = mco.mco_codigo ");
            sql.append("   left join examesetor   ese on a.fil_codigo = ese.fil_codigo   and a.exa_codigo = ese.exa_codigo   and eso.set_codigo = ese.set_codigo ");
            sql.append("   left join setores      set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
            sql.append("  where a.fil_codigo = ").append(codigoFilialTubo);
            sql.append("    and eso.fil_codigo = ").append(codigoFilial);
            sql.append("    and a.req_codigo = ").append(codigoRequisicao);
            sql.append("    and a.rec_kodigo = ").append(codigoRecipienteFilho);
            sql.append("    and eso.ett_codigo = ").append(rs.getInt("ett_codigo"));
            sql.append("    and eso.eso_codigo = ").append(rs.getInt("eso_codigo"));
            ResultSet rsTubo = Conexao.executeQuery(st2, sql);
            if (!rsTubo.next()) continue;
            Integer auxMenor = null;
            StringBuilder conservarSoroteca = new StringBuilder();
            ArrayList<Exame> exames = new ArrayList<Exame>();
            do {
                exames.add(new Exame(codigoFilial, rsTubo.getInt("req_codigo"), rsTubo.getString("exa_codigo"), rsTubo.getString("exa_descricao"), rsTubo.getString("exr_situacao"), rsTubo.getInt("mco_codigo"), rsTubo.getString("mco_abreviatura"), rsTubo.getInt("set_codigo"), rsTubo.getString("set_descricao"), rs.getInt("emc_temposoroteca"), rs.getString("emc_conservarSoroteca"), rs.getString("emc_tipotemposoroteca")));
                Integer mult = 1;
                if (rsTubo.getString("emc_tipotemposoroteca").equalsIgnoreCase("M")) {
                    mult = 30;
                } else if (rsTubo.getString("emc_tipotemposoroteca").equalsIgnoreCase("A")) {
                    mult = 365;
                }
                Integer aux = rsTubo.getInt("emc_temposoroteca") * mult;
                if (auxMenor == null || aux < auxMenor && aux > 0 || auxMenor == 0 && aux > 0) {
                    auxMenor = aux;
                }
                if (rsTubo.getString("emc_conservarSoroteca") == null) continue;
                if (conservarSoroteca.length() > 0) {
                    conservarSoroteca.append("\n");
                }
                conservarSoroteca.append(rsTubo.getString("emc_conservarSoroteca"));
            } while (rsTubo.next());
            rsTubo.first();
            FilialVO filial = new FilialVO();
            filial.setCodigo(codigoFilialTubo);
            RecipienteBean recipientePaiBean = (RecipienteBean)new RecipienteService().get(String.valueOf(codigoFilial), rsTubo.getString("rec_codigo"));
            RecipienteBean recipienteFilhoBean = (RecipienteBean)new RecipienteService().get(String.valueOf(codigoFilial), rsTubo.getString("rec_kodigo"));
            PacienteVO paciente = (PacienteVO)new PacienteService().getVO(rsTubo.getString("fil_codigo"), rsTubo.getString("pac_codigo"));
            EstanteBean estante = (EstanteBean)new EstanteService().get(String.valueOf(codigoFilial), rsTubo.getString("ett_codigo"));
            UsuarioBean usuarioDescarte = null;
            if (rsTubo.getString("usr_coddescarte") != null) {
                usuarioDescarte = (UsuarioBean)new UsuarioService().get(rsTubo.getString("usr_coddescarte"));
            }
            UsuarioBean usuarioSoroteca = null;
            if (rs.getString("usr_codsoroteca") != null) {
                usuarioSoroteca = (UsuarioBean)new UsuarioService().get(rs.getString("usr_codsoroteca"));
            }
            if (exames.size() <= 0) continue;
            listaTubos.add(new Tubo(filial, recipientePaiBean, recipienteFilhoBean, exames, paciente, rsTubo.getInt("eso_linhasoroteca"), rsTubo.getInt("eso_colunasoroteca"), rsTubo.getDate("eso_datahorasoroteca"), estante, rsTubo.getDate("req_data"), rsTubo.getString("ere_tipo"), rsTubo.getTimestamp("eso_datahoradescarte"), usuarioDescarte, rs.getInt("eso_codigo"), usuarioSoroteca, codigoRequisicao));
        }
        if (listaTubos.size() == 0) {
            return null;
        }
        return listaTubos;
    }

    public static List<Tubo> carregaTubos(int codigoFilial, int codigoFilialTubo, int codigoRequisicao) throws Exception {
        ArrayList<Tubo> tubos = new ArrayList<Tubo>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.rec_kodigo ");
        sql.append("       ,a.eso_codigo ");
        sql.append("       ,a.ett_codigo ");
        sql.append("   from examerequisicaosoroteca a ");
        sql.append("   join examerequisicao c on a.fil_kodigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        sql.append("   join requisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo ");
        sql.append("  where a.fil_kodigo = ").append(codigoFilialTubo);
        sql.append("    and a.fil_codigo = ").append(codigoFilial);
        sql.append("    and a.req_codigo = ").append(codigoRequisicao);
        sql.append("    and c.exr_excluido = false ");
        sql.append("    and d.req_excluida = false ");
        sql.append("    and a.eso_datahoradescarte is null ");
        sql.append("  group by a.rec_kodigo ");
        sql.append("       ,a.eso_codigo ");
        sql.append("       ,a.ett_codigo ");
        sql.append("  order by a.ett_codigo ");
        sql.append("          ,a.rec_kodigo ");
        sql.append("          ,a.eso_codigo ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            tubos.add(TuboDao.carregaTubo(codigoFilial, codigoFilialTubo, codigoRequisicao, rs.getInt("rec_kodigo"), rs.getInt("eso_codigo"), rs.getString("ett_codigo") == null ? null : Integer.valueOf(rs.getInt("ett_codigo")), true, false));
        }
        st.close();
        return tubos;
    }

    public static List<Tubo> carregaTubosConsulta(int codigoFilial, int codigoFilialTubo, int codigoRequisicao) throws Exception {
        return TuboDao.carregaTubosConsulta(codigoFilial, codigoFilialTubo, codigoRequisicao, false);
    }

    public static List<Tubo> carregaTubosConsulta(int codigoFilial, int codigoFilialTubo, int codigoRequisicao, boolean consultarDescartado) throws Exception {
        ArrayList<Tubo> tubos = new ArrayList<Tubo>();
        String codigosMultiguia = "";
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            Integer[] aux = RecepcaoUtil.verificaMultiGuias(String.valueOf(codigoFilialTubo), String.valueOf(codigoRequisicao), true);
            for (int i = 0; i < aux.length; ++i) {
                codigosMultiguia = codigosMultiguia + aux[i];
                if (i >= aux.length - 1) continue;
                codigosMultiguia = codigosMultiguia + ", ";
            }
        } else {
            codigosMultiguia = codigosMultiguia + codigoRequisicao;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.rec_kodigo ");
        sql.append("       ,a.eso_codigo ");
        sql.append("       ,a.ett_codigo ");
        sql.append("   from examerequisicaosoroteca a ");
        sql.append("   join examerequisicao c on a.fil_kodigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        sql.append("   join requisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo ");
        sql.append("  where a.fil_kodigo = ").append(codigoFilialTubo);
        sql.append("    and a.fil_codigo = ").append(codigoFilial);
        sql.append("    and a.req_codigo IN (").append(codigosMultiguia).append(") ");
        sql.append("    and c.exr_excluido = false ");
        sql.append("    and d.req_excluida = false ");
        if (!consultarDescartado) {
            sql.append("    and a.eso_datahoradescarte is null ");
        }
        sql.append("  group by a.rec_kodigo ");
        sql.append("       ,a.eso_codigo ");
        sql.append("       ,a.ett_codigo ");
        sql.append("  order by a.ett_codigo ");
        sql.append("          ,a.rec_kodigo ");
        sql.append("          ,a.eso_codigo ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ArrayList<Tubo> aux = TuboDao.carregaTubosConsulta(codigoFilial, codigoFilialTubo, codigoRequisicao, rs.getInt("rec_kodigo"), rs.getInt("eso_codigo"), rs.getString("ett_codigo") == null ? null : Integer.valueOf(rs.getInt("ett_codigo")), true, false, consultarDescartado);
            for (int i = 0; i < aux.size(); ++i) {
                tubos.add(aux.get(i));
            }
        }
        st.close();
        return tubos;
    }

    public static List<Tubo> carregaTubosPaciente(int codigoFilial, int codigoFilialTubo, int codigoPaciente) throws Exception {
        ArrayList<Tubo> tubos = new ArrayList<Tubo>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select b.rec_kodigo ");
        sql.append("       ,a.req_codigo ");
        sql.append("       ,b.eso_codigo ");
        sql.append("       ,b.ett_codigo ");
        sql.append("   from requisicao a ");
        sql.append("   join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
        sql.append("   join examerequisicaosoroteca b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo and c.exa_codigo = b.exa_codigo and c.mco_codigo = b.mco_codigo ");
        sql.append("  where a.fil_codigo = ").append(codigoFilialTubo);
        sql.append("    and b.fil_codigo = ").append(codigoFilial);
        sql.append("    and a.pac_codigo = ").append(codigoPaciente);
        sql.append("    and a.req_excluida = false ");
        sql.append("    and c.exr_excluido = false ");
        sql.append("    and b.eso_datahoradescarte is null ");
        sql.append("  group by b.rec_kodigo ");
        sql.append("          ,a.req_codigo ");
        sql.append("          ,b.eso_codigo ");
        sql.append("          ,b.ett_codigo ");
        sql.append("  order by b.ett_codigo ");
        sql.append("          ,b.rec_kodigo ");
        sql.append("          ,b.eso_codigo ");
        PreparedStatement prst = Conexao.getPreparedStatement(sql.toString());
        ResultSet rs = prst.executeQuery();
        while (rs.next()) {
            tubos.add(TuboDao.carregaTubo(codigoFilial, codigoFilialTubo, rs.getInt("req_codigo"), rs.getInt("rec_kodigo"), rs.getInt("eso_codigo"), rs.getString("ett_codigo") == null ? null : Integer.valueOf(rs.getInt("ett_codigo")), false, true));
        }
        prst.close();
        return tubos;
    }

    public static List<Tubo> carregaTubosEstante(int codigoFilial, int codigoEstante, SplashMensagem threadMensagem, boolean isCarregandoEstante) throws Exception {
        ArrayList<Tubo> tubos = new ArrayList<Tubo>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.fil_kodigo ");
        sql.append("       ,a.req_codigo ");
        sql.append("       ,a.rec_kodigo ");
        sql.append("       ,a.eso_codigo ");
        sql.append("       ,a.ett_codigo ");
        sql.append("   from examerequisicaosoroteca a ");
        sql.append("   join examerequisicao c on a.fil_kodigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        sql.append("   join requisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo ");
        sql.append("  where a.fil_codigo = ").append(codigoFilial);
        sql.append("    and a.ett_codigo = ").append(codigoEstante);
        sql.append("    and c.exr_excluido = false ");
        sql.append("    and d.req_excluida = false ");
        sql.append("    and a.eso_datahoradescarte is null ");
        sql.append("  order by a.rec_kodigo ");
        PreparedStatement prst = Conexao.getPreparedStatement(sql.toString());
        int i = 0;
        int qtde = 0;
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        while (rs.next()) {
            ++qtde;
        }
        rs.beforeFirst();
        while (rs.next()) {
            tubos.add(TuboDao.carregaTubo(codigoFilial, rs.getInt("fil_kodigo"), rs.getInt("req_codigo"), rs.getInt("rec_kodigo"), rs.getInt("eso_codigo"), rs.getInt("ett_codigo"), false, isCarregandoEstante));
            if (threadMensagem == null) continue;
            threadMensagem.setText("Carregando tubos - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
        }
        prst.close();
        return tubos;
    }

    public static void gravarTubo(Tubo tubo, EstanteBean estante) throws Exception {
        if (tubo == null) {
            return;
        }
        if (!tubo.inserido && !tubo.removido) {
            return;
        }
        List<Exame> exames = TuboDao.filtrarExamesRepetidos(tubo.getExames());
        for (Exame exame : exames) {
            StringBuilder buf = new StringBuilder();
            boolean tuboExistente = TuboDao.tuboExistente(exame, tubo, estante);
            if (tubo.inserido && tuboExistente) {
                buf.delete(0, buf.length());
                buf.append(" insert into examerequisicaosoroteca (fil_codigo, exa_codigo, mco_codigo, req_codigo, rec_codigo, ett_codigo, eso_codigo, eso_datahorasoroteca, eso_linhasoroteca, eso_colunasoroteca, eso_datahoradescarte, usr_codsoroteca, usr_coddescarte, set_codigo, fil_kodigo, rec_kodigo) ");
                buf.append("      values(").append(Variaveis.filialPadrao);
                buf.append("            ,'").append(exame.getCodigo()).append("' ");
                buf.append("            ,").append(exame.getCodigoMaterial());
                buf.append("            ,").append(exame.getCodigoRequisicao());
                buf.append("            ,").append(tubo.getRecipientePai(exame.getCodigo()).getCodigo());
                buf.append("            ,").append(estante.getCodigo()).append(" ");
                buf.append("            ,").append(tubo.getCodigoSoroteca());
                buf.append("            ,'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
                buf.append("            ,").append(tubo.getLinhaSoroteca());
                buf.append("            ,").append(tubo.getColunaSoroteca());
                buf.append("            ,null ");
                buf.append("            ,'").append(Variaveis.login).append("' ");
                buf.append("            ,null ");
                buf.append("            ,").append(tubo.getSetor().getCodigo());
                buf.append("            ,").append(tubo.getFilial().getCodigo());
                buf.append("            ,").append(tubo.getRecipienteFilho().getCodigo()).append(") ");
                Conexao.execute(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString(), true);
                Conexao.arquivaSQL();
            } else if (tubo.removido) {
                buf.append(" update examerequisicaosoroteca ");
                buf.append("    set eso_datahoradescarte = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
                buf.append("       ,usr_coddescarte = '").append(Variaveis.login).append("' ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fil_kodigo = ").append(tubo.getFilial());
                buf.append("    and req_codigo = ").append(exame.getCodigoRequisicao());
                buf.append("    and rec_codigo = ").append(tubo.getRecipientePai(exame.getCodigo()).getCodigo());
                buf.append("    and exa_codigo = '").append(exame.getCodigo()).append("' ");
                buf.append("    and mco_codigo = '").append(exame.getCodigoMaterial()).append("' ");
                buf.append("    and eso_codigo = ").append(tubo.getCodigoSoroteca());
                buf.append("    and ett_codigo = ").append(estante.getCodigo());
                buf.append("    and rec_kodigo = ").append(tubo.getRecipienteFilho().getCodigo());
                Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString(), true);
            }
            new EstanteService().gravaAutoCopiaSemCommit(estante, 1, Variaveis.filialPadrao, null);
        }
    }

    private static boolean tuboExistente(Exame exame, Tubo tubo, EstanteBean estante) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select exa_codigo from examerequisicaosoroteca");
        buf.append(" where fil_codigo =").append(Variaveis.filialPadrao);
        buf.append(" and exa_codigo = '").append(exame.getCodigo()).append("'");
        buf.append(" and mco_codigo = '").append(exame.getCodigoMaterial()).append("'");
        buf.append(" and req_codigo = ").append(exame.getCodigoRequisicao());
        buf.append(" and rec_codigo = ").append(tubo.getRecipientePai(exame.getCodigo()).getCodigo());
        buf.append(" and fil_kodigo = ").append(tubo.getFilial());
        buf.append(" and rec_kodigo = ").append(tubo.getRecipienteFilho().getCodigo());
        buf.append(" and usr_coddescarte is null");
        buf.append("    and ett_codigo = ").append(estante.getCodigo());
        buf.append(" and eso_linhasoroteca = ").append(tubo.getLinhaSoroteca());
        buf.append(" and eso_colunasoroteca = ").append(tubo.getColunaSoroteca());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return Funcoes.textoVazio(rs.getString("exa_codigo"));
        }
        return true;
    }

    private static List<Exame> filtrarExamesRepetidos(List<Exame> exames) {
        ArrayList<Exame> filtrado = new ArrayList<Exame>();
        for (Exame exame : exames) {
            if (filtrado.contains(exame)) continue;
            filtrado.add(exame);
        }
        return filtrado;
    }

    public static boolean contemCadastro(DescritorCodigoEtiqueta dce) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                Integer[] is = RecepcaoUtil.verificaMultiGuias(st, dce == null ? Variaveis.filialPadrao : dce.getFilial(), dce != null ? dce.getRequisicao() : null, true);
                StringBuilder bui = new StringBuilder("select a.fil_codigo from examerequisicaorecipiente a ");
                bui.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where a.fil_codigo = ");
                if (dce != null) {
                    bui.append(dce.getFilial());
                }
                if (is != null && is.length > 1 && ParametrosGerais.isAgruparGuiasInterface()) {
                    bui.append(" and a.req_codigo in (");
                    for (int i = 0; i < is.length; ++i) {
                        if (i > 0) {
                            bui.append(", ");
                        }
                        bui.append(is[i]);
                    }
                    bui.append(") ");
                } else {
                    bui.append(" and a.req_codigo = ");
                    bui.append(dce.getRequisicao());
                }
                bui.append(" and a.rec_kodigo = ");
                bui.append(dce.getTubo());
                bui.append(" and c.exr_excluido = false ");
                return Conexao.executeQuery(st, bui.toString()).first();
            }
            catch (Exception e) {
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "Triagem");
            }
        }
        return false;
    }
}

