/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca.util;

import jalis.laboratorio.triagem.soroteca.jtabuleiro.JTabuleiro;
import jalis.laboratorio.triagem.soroteca.util.Informacoes;
import jalis.laboratorio.triagem.soroteca.util.Posicao;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboContainer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;

public class TuboContainerJTabuleiro
implements TuboContainer {
    private JTabuleiro<Tubo> tabuleiro;
    protected Informacoes panelInformacoes;
    private Timer timer = new Timer("TIMER_VALIDADE_TUBOS", true);

    public List<Posicao> getPosicoesSelecionadas() {
        return this.tabuleiro.getPosicoesSelecionadas();
    }

    public void atualizaDiametroTubos(JComponent pai) {
        this.tabuleiro.atualizaDiametroTubos(pai);
    }

    public TuboContainerJTabuleiro(int linhas, int colunas, JComponent container, boolean podeSelecionar, boolean podeMarcar) {
        this.tabuleiro = new JTabuleiro(linhas, colunas, this, container, podeSelecionar, podeMarcar);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (int i = 0; i < TuboContainer.listaTodosTubos.size(); ++i) {
                    TuboContainer.listaTodosTubos.get(i).calculaSeVencido(TuboContainer.listaTodosTubos.get(i).getSetor().getCodigo());
                }
                TuboContainerJTabuleiro.this.tabuleiro.repaint();
            }
        }, 3600000L, 3600000L);
    }

    @Override
    public int getNumeroPosicoesOcupadas() {
        return this.tabuleiro.getNumeroPosicoesOcupadas();
    }

    @Override
    public int getNumeroPosicoesVazias() {
        return this.tabuleiro.getNumeroPosicoesVazias();
    }

    @Override
    public List<Tubo> getTubos() {
        return this.tabuleiro.getValores();
    }

    @Override
    public List<Tubo> getTubosSelecionados() {
        return this.tabuleiro.getValoresSelecionados();
    }

    @Override
    public boolean isTuboAdicionado(Tubo tubo) {
        return this.tabuleiro.contem(tubo);
    }

    @Override
    public boolean isNumeroPosicoesLimitado() {
        return true;
    }

    @Override
    public void removerTubo(Tubo tubo) {
        if (tubo.inserido) {
            for (int i = 0; i < listaTodosTubos.size(); ++i) {
                Tubo aux = (Tubo)listaTodosTubos.get(i);
                if (!aux.compararComSetor(tubo) || aux.getCodigoSoroteca().intValue() != tubo.getCodigoSoroteca().intValue()) continue;
                listaTodosTubos.remove(i);
                tubo.removido = true;
                break;
            }
        } else {
            tubo.removido = true;
        }
        this.tabuleiro.removeValor(tubo);
        this.tabuleiro.repaint();
    }

    @Override
    public JComponent getUI() {
        return this.tabuleiro;
    }

    @Override
    public void addPanelInformacoes(Informacoes panelInformacoes) {
        this.panelInformacoes = panelInformacoes;
        panelInformacoes.setTuboContainer(this);
    }

    @Override
    public void mostrarInformacoesTubo(Tubo tubo) {
        if (this.panelInformacoes != null) {
            this.panelInformacoes.preencheInformacoes(tubo, false);
        }
    }

    @Override
    public void limparSelecao() {
        this.tabuleiro.limparSelecao();
    }

    @Override
    public void selecionarTubo(Tubo tubo, boolean limpar) {
        this.tabuleiro.selecionarTubo(tubo, limpar);
    }

    @Override
    public Tubo localizarTubo(String etiquetaParcial) {
        return this.tabuleiro.localizarTubo(etiquetaParcial);
    }

    @Override
    public ArrayList<Tubo> localizarTubos(String etiquetaParcial) {
        return this.tabuleiro.localizarTubos(etiquetaParcial);
    }

    public Posicao selecionarProximaPosicaoVazia() {
        return this.tabuleiro.selecionarProximaPosicaoVazia();
    }

    @Override
    public void addTubo(Tubo tubo, boolean isAdicionando) {
        if (tubo == null) {
            return;
        }
        Integer codigoSoroteca = tubo.getCodigoSoroteca() == null ? 0 : tubo.getCodigoSoroteca();
        if (isAdicionando) {
            for (int i = 0; i < listaTodosTubos.size(); ++i) {
                Tubo aux = (Tubo)listaTodosTubos.get(i);
                if (!aux.equals(tubo)) continue;
                if (aux.getCodigoSoroteca() == codigoSoroteca) {
                    Integer n = codigoSoroteca;
                    Integer n2 = codigoSoroteca = Integer.valueOf(codigoSoroteca + 1);
                    continue;
                }
                if (aux.getCodigoSoroteca() <= codigoSoroteca) continue;
                codigoSoroteca = aux.getCodigoSoroteca() + 1;
            }
            tubo.setCodigoSoroteca(codigoSoroteca);
            if (tubo.getDataHoraSoroteca() == null) {
                tubo.setDataHoraSoroteca(new Date());
            } else {
                tubo.calculaSeVencido(tubo.getSetor().getCodigo());
            }
        }
        this.tabuleiro.setValor(tubo, tubo.getPosicaoSoroteca());
        listaTodosTubos.add(tubo);
        this.tabuleiro.repaint();
    }

    public void setBarraDetalhesVisivel(boolean isVisivel) {
        this.tabuleiro.setBarraDetalhesVisivel(isVisivel);
    }

    public boolean isBarraDetalhesVisivel() {
        return this.tabuleiro.isBarraDetalhesVisivel();
    }

    @Override
    public void removerTodosTubos() {
        if (listaTodosTubos != null) {
            for (int i = 0; i < listaTodosTubos.size(); ++i) {
                Tubo tubo = (Tubo)listaTodosTubos.get(i);
                if (!tubo.inserido) {
                    tubo.removido = true;
                    continue;
                }
                listaTodosTubos.remove(i--);
            }
        }
        this.tabuleiro.removeTodosValores();
        this.tabuleiro.repaint();
    }

    @Override
    public void cancelarTimer() {
        this.timer.cancel();
    }

    @Override
    public void atualizarValidadeTubos() {
        for (int i = 0; i < listaTodosTubos.size(); ++i) {
            ((Tubo)listaTodosTubos.get(i)).calculaSeVencido(((Tubo)listaTodosTubos.get(i)).getSetor().getCodigo());
        }
        this.tabuleiro.repaint();
    }

    @Override
    public void selecionarTuboEtiquetaRepetida(Tubo tubo) {
        this.tabuleiro.selecionarTuboEtiquetaRepetida(tubo);
    }
}

