/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca.util;

import jalis.laboratorio.triagem.soroteca.jtabuleiro.JTabuleiro;
import jalis.laboratorio.triagem.soroteca.util.Informacoes;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboContainer;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TuboContainerJList
implements TuboContainer,
ListSelectionListener {
    private final JList list;
    private final DefaultListModel model;
    private Informacoes panelInformacoes = null;
    private final Timer timer = new Timer("TIMER_VALIDADE_TUBOS", true);

    public TuboContainerJList(boolean podeSelecionar, final boolean podeMarcar) {
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setBackground(JTabuleiro.COR_VAZIA);
        this.list.setCellRenderer(new ListaTuboRenderer());
        this.list.setSelectionMode(2);
        if (podeSelecionar || podeMarcar) {
            this.list.addListSelectionListener(this);
            this.list.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int index = TuboContainerJList.this.list.locationToIndex(e.getPoint());
                    if (TuboContainerJList.this.list.getCellBounds(index, index) != null && TuboContainerJList.this.list.getCellBounds(index, index).contains(e.getPoint())) {
                        TuboContainerJList.this.list.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        TuboContainerJList.this.list.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                @Deprecated
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    TuboContainerJList.this.list.setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    int pos;
                    if (podeMarcar && (pos = TuboContainerJList.this.list.locationToIndex(e.getPoint())) >= 0 && TuboContainerJList.this.list.getCellBounds(pos, pos).contains(e.getPoint()) && TuboContainerJList.this.model.get(pos) instanceof Tubo) {
                        Tubo aux;
                        aux.setMarcado(!(aux = (Tubo)TuboContainerJList.this.model.get(pos)).isMarcado());
                        TuboContainerJList.this.list.repaint();
                    }
                }
            });
        } else {
            this.list.setFocusable(false);
            this.list.setEnabled(false);
        }
        this.list.setFixedCellWidth(110);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (int i = 0; i < TuboContainer.listaTodosTubos.size(); ++i) {
                    TuboContainer.listaTodosTubos.get(i).calculaSeVencido(TuboContainer.listaTodosTubos.get(i).getSetor().getCodigo());
                }
                TuboContainerJList.this.list.repaint();
            }
        }, 3600000L, 3600000L);
    }

    @Override
    public void addTubo(Tubo tubo, boolean isAdicionando) {
        if (tubo == null) {
            return;
        }
        if (isAdicionando) {
            Integer codigoSoroteca = tubo.getCodigoSoroteca() == null ? 0 : tubo.getCodigoSoroteca();
            for (int i = 0; i < listaTodosTubos.size(); ++i) {
                Tubo aux = (Tubo)listaTodosTubos.get(i);
                if (!aux.equals(tubo) || aux.getCodigoSoroteca() < codigoSoroteca) continue;
                codigoSoroteca = aux.getCodigoSoroteca() + 1;
            }
            tubo.setCodigoSoroteca(codigoSoroteca);
            if (tubo.getDataHoraSoroteca() == null) {
                tubo.setDataHoraSoroteca(new Date());
            } else {
                tubo.calculaSeVencido(tubo.getSetor().getCodigo());
            }
        }
        this.model.addElement(tubo);
        listaTodosTubos.add(tubo);
        this.list.repaint();
    }

    @Override
    public int getNumeroPosicoesOcupadas() {
        return this.model.size();
    }

    @Override
    public int getNumeroPosicoesVazias() {
        return 0;
    }

    @Override
    public List<Tubo> getTubos() {
        ArrayList<Tubo> tubos = new ArrayList<Tubo>();
        Enumeration elementos = this.model.elements();
        while (elementos.hasMoreElements()) {
            Object obj = elementos.nextElement();
            if (!(obj instanceof Tubo)) continue;
            tubos.add((Tubo)obj);
        }
        return tubos;
    }

    @Override
    public List<Tubo> getTubosSelecionados() {
        ArrayList<Tubo> tubos = new ArrayList<Tubo>();
        for (Object obj : this.list.getSelectedValues()) {
            if (!(obj instanceof Tubo)) continue;
            tubos.add((Tubo)obj);
        }
        return tubos;
    }

    @Override
    public boolean isTuboAdicionado(Tubo tubo) {
        for (int i = 0; i < this.model.size(); ++i) {
            Tubo aux = (Tubo)this.model.get(i);
            if (!aux.toString().equals(tubo.toString()) || aux.getSetor().getCodigo().intValue() != tubo.getSetor().getCodigo().intValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNumeroPosicoesLimitado() {
        return false;
    }

    @Override
    public void removerTubo(Tubo tubo) {
        if (tubo.inserido) {
            for (int i = 0; i < listaTodosTubos.size(); ++i) {
                Tubo aux = (Tubo)listaTodosTubos.get(i);
                if (!aux.equals(tubo) || aux.getCodigoSoroteca().intValue() != tubo.getCodigoSoroteca().intValue()) continue;
                listaTodosTubos.remove(aux);
                break;
            }
        } else {
            tubo.removido = true;
        }
        this.model.removeElement(tubo);
    }

    @Override
    public JComponent getUI() {
        return this.list;
    }

    @Override
    public void addPanelInformacoes(Informacoes panelInformacoes) {
        this.panelInformacoes = panelInformacoes;
        panelInformacoes.setTuboContainer(this);
    }

    @Override
    public void mostrarInformacoesTubo(Tubo tubo) {
        if (this.panelInformacoes != null) {
            this.panelInformacoes.preencheInformacoes(tubo, false);
        }
    }

    @Override
    public void limparSelecao() {
        this.list.getSelectionModel().clearSelection();
    }

    @Override
    public void selecionarTubo(Tubo tubo, boolean limpar) {
        if (limpar) {
            this.list.getSelectionModel().clearSelection();
        }
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            Tubo aux = (Tubo)this.list.getModel().getElementAt(i);
            if (!aux.equals(tubo)) continue;
            this.list.getSelectionModel().addSelectionInterval(i, i);
        }
        this.list.setSelectedValue(tubo, true);
    }

    @Override
    public Tubo localizarTubo(String etiquetaParcial) {
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            Tubo aux = (Tubo)this.list.getModel().getElementAt(i);
            if (aux == null || !aux.getEtiqueta().startsWith(etiquetaParcial)) continue;
            return aux;
        }
        return null;
    }

    @Override
    public ArrayList<Tubo> localizarTubos(String etiquetaParcial) {
        ArrayList<Tubo> lista = new ArrayList<Tubo>();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            Tubo aux = (Tubo)this.list.getModel().getElementAt(i);
            if (aux == null || !aux.getEtiqueta().startsWith(etiquetaParcial)) continue;
            lista.add(aux);
        }
        return lista;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() instanceof JList) {
            JList aux = (JList)e.getSource();
            this.mostrarInformacoesTubo((Tubo)aux.getSelectedValue());
        }
    }

    @Override
    public void removerTodosTubos() {
        if (listaTodosTubos != null) {
            for (int i = 0; i < listaTodosTubos.size(); ++i) {
                ((Tubo)TuboContainerJList.listaTodosTubos.get((int)i)).removido = true;
                this.removerTubo((Tubo)listaTodosTubos.get(i));
            }
        }
    }

    @Override
    public void cancelarTimer() {
        this.timer.cancel();
    }

    @Override
    public void atualizarValidadeTubos() {
        for (int i = 0; i < listaTodosTubos.size(); ++i) {
            ((Tubo)listaTodosTubos.get(i)).calculaSeVencido(((Tubo)listaTodosTubos.get(i)).getSetor().getCodigo());
        }
        this.list.repaint();
    }

    @Override
    public void selecionarTuboEtiquetaRepetida(Tubo tubo) {
        this.list.getSelectionModel().clearSelection();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            Tubo aux = (Tubo)this.list.getModel().getElementAt(i);
            if (!aux.equals(tubo) || aux.getCodigoSoroteca().intValue() != tubo.getCodigoSoroteca().intValue()) continue;
            this.list.getSelectionModel().addSelectionInterval(i, i);
        }
        this.list.setSelectedValue(tubo, true);
    }

    class ListaTuboRenderer
    extends JLabel
    implements ListCellRenderer {
        ListaTuboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setOpaque(true);
            if (value instanceof Tubo) {
                Tubo aux = (Tubo)value;
                if (aux.isVencido()) {
                    this.setForeground(JTabuleiro.COR_PREENCHIDA_VENCIDO);
                } else {
                    this.setForeground(JTabuleiro.COR_PREENCHIDA);
                }
                if (isSelected) {
                    this.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
                } else {
                    this.setBorder(null);
                }
                if (!aux.isMarcado()) {
                    this.setBackground(Color.WHITE);
                } else {
                    this.setBackground(JTabuleiro.COR_MARCADO);
                }
                this.setHorizontalAlignment(0);
                this.setToolTipText(aux.getCodigoRequisicaoEtiqueta().toString());
                int orientacao = 1;
                String etiqueta = StringUtil.preencheString(String.valueOf(aux.getFilial().getCodigo()), Tubo.digFilial, '0', orientacao) + StringUtil.preencheString(String.valueOf(aux.getCodigoRequisicaoEtiqueta()), Tubo.digRequisicao, '0', orientacao) + StringUtil.preencheString(String.valueOf(aux.getRecipienteFilho().getCodigo()), Tubo.digRecipiente, '0', orientacao);
                this.setText(etiqueta);
                return this;
            }
            return null;
        }
    }
}

