/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca.util;

import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.laboratorio.triagem.soroteca.util.Exame;
import jalis.laboratorio.triagem.soroteca.util.ExameRecipiente;
import jalis.laboratorio.triagem.soroteca.util.Posicao;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.bean.configuracao.UsuarioBean;
import jalis.model.bean.triagem.RecipienteBean;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class Tubo {
    private FilialVO filial;
    private String etiqueta;
    private Date dataRequisicao;
    private PacienteVO paciente;
    private EstanteBean estante;
    private Date dataHoraSoroteca;
    private boolean isVencido = false;
    private String tipoEtiqueta = null;
    private Date dataHoraDescarte;
    private UsuarioBean usuarioDescarte;
    private UsuarioBean usuarioSoroteca;
    private Integer codigoSoroteca;
    private SetorVO setor;
    private Integer codigoRequisicaoEtiqueta;
    private List<ExameRecipiente> examesRecipiente = new ArrayList<ExameRecipiente>();
    private Integer linhaSoroteca = null;
    private Integer colunaSoroteca = null;
    private Date dataRetiradaSoroteca = null;
    public static int digFilial = ParametrosGerais.getDigitosTuboFilial();
    public static int digRequisicao = ParametrosGerais.getDigitosTuboRequisicao();
    public static int digRecipiente = ParametrosGerais.getDigitosTuboTubo();
    private static int digTotal = digFilial + digRequisicao + digRecipiente;
    public boolean inserido = false;
    public boolean removido = false;
    public boolean marcado = false;

    public Integer getCodigoRequisicaoEtiqueta() {
        return this.codigoRequisicaoEtiqueta;
    }

    public void setPosicaoSoroteca(Posicao posicao) {
        if (posicao == null) {
            return;
        }
        this.linhaSoroteca = posicao.getLinha();
        this.colunaSoroteca = posicao.getColuna();
    }

    public Integer getCodigoSoroteca() {
        return this.codigoSoroteca;
    }

    public void setCodigoSoroteca(int codigoSoroteca) {
        this.codigoSoroteca = codigoSoroteca;
    }

    public Posicao getPosicaoSoroteca() {
        if (this.linhaSoroteca == null || this.colunaSoroteca == null) {
            return null;
        }
        return new Posicao(this.linhaSoroteca, this.colunaSoroteca);
    }

    public void setLinhaSoroteca(Integer linha) {
        this.linhaSoroteca = linha;
    }

    public void setColunaSoroteca(Integer coluna) {
        this.colunaSoroteca = coluna;
    }

    public int getLinhaSoroteca() {
        return this.linhaSoroteca;
    }

    public int getColunaSoroteca() {
        return this.colunaSoroteca;
    }

    public boolean podeAdicionarTubo() {
        for (int i = 0; i < this.examesRecipiente.size(); ++i) {
            String situacao = this.examesRecipiente.get(i).getExame().getSituacao();
            if (situacao == null || !situacao.equalsIgnoreCase("F")) continue;
            return false;
        }
        return this.tipoEtiqueta.equalsIgnoreCase(ParametrosGerais.getTipoEtiquetaSoroteca());
    }

    public String getErrosTubo() {
        StringBuilder erros = new StringBuilder();
        if (!this.tipoEtiqueta.equalsIgnoreCase(ParametrosGerais.getTipoEtiquetaSoroteca())) {
            return "O tipo do tubo \u00e9 inv\u00e1lido.";
        }
        for (int i = 0; i < this.examesRecipiente.size(); ++i) {
            String situacao = this.examesRecipiente.get(i).getExame().getSituacao();
            if (situacao != null && !situacao.equals("") && !situacao.equals(" ") && !situacao.equalsIgnoreCase("T") && !situacao.equalsIgnoreCase("F") && !situacao.equalsIgnoreCase("R") && !situacao.equalsIgnoreCase("A") && !situacao.equalsIgnoreCase("P") && !situacao.equalsIgnoreCase("O") && !situacao.equalsIgnoreCase("N")) continue;
            if (erros.length() > 0) {
                erros.append("\n");
            }
            erros.append("O Exame \"").append(this.examesRecipiente.get(i).getExame().getDescricao()).append("\" est\u00e1 com a situa\u00e7\u00e3o \"").append(Tipos.tipoSituacaoExame(situacao)).append("\".");
        }
        return erros.toString();
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
    }

    public RecipienteBean getRecipienteFilho() {
        return this.examesRecipiente.get(0).getRecipienteFilho();
    }

    public RecipienteBean getRecipientePai(String codigoExame) {
        for (ExameRecipiente exameRecipiente : this.examesRecipiente) {
            if (!exameRecipiente.getExame().getCodigo().equalsIgnoreCase(codigoExame)) continue;
            return exameRecipiente.getRecipientePai();
        }
        return new RecipienteBean();
    }

    public String getEtiqueta() {
        return this.etiqueta;
    }

    public void setEtiqueta(String etiqueta) {
        this.etiqueta = etiqueta;
    }

    public PacienteVO getPaciente() {
        return this.paciente;
    }

    public void setPaciente(PacienteVO paciente) {
        this.paciente = paciente;
    }

    public String getConservacao(int codigoSetor) {
        String conservacao = "";
        if (!this.examesRecipiente.isEmpty()) {
            for (int i = 0; i < this.examesRecipiente.size(); ++i) {
                Exame exame = this.examesRecipiente.get(i).getExame();
                if (exame == null || exame.getSetor() == null || exame.getSetor().getCodigo() != codigoSetor) continue;
                conservacao = Funcoes.textoVazio(conservacao) ? conservacao + (exame.getConservarSoroteca() == null ? "" : exame.getConservarSoroteca()) : conservacao + ("\n" + exame.getConservarSoroteca() == null ? "" : exame.getConservarSoroteca());
            }
        }
        return conservacao;
    }

    public Integer getTempoSoroteca(int codigoSetor) {
        if (!this.examesRecipiente.isEmpty()) {
            Integer auxMenor = null;
            for (int i = 0; i < this.examesRecipiente.size(); ++i) {
                Exame exame = this.examesRecipiente.get(i).getExame();
                if (exame == null || exame.getSetor() == null || exame.getSetor().getCodigo() != codigoSetor) continue;
                int mult = 1;
                if (exame.getTipoTempoSoroteca().equalsIgnoreCase("M")) {
                    mult = 30;
                } else if (exame.getTipoTempoSoroteca().equalsIgnoreCase("A")) {
                    mult = 365;
                }
                Integer aux = exame.getTempoSoroteca() * mult;
                if (auxMenor != null && (aux >= auxMenor || aux <= 0) && (auxMenor != 0 || aux <= 0)) continue;
                auxMenor = aux;
            }
            return auxMenor;
        }
        return null;
    }

    public String getTipoTempoSoroteca(int codigoSetor) {
        if (!this.examesRecipiente.isEmpty()) {
            Integer auxMenor = null;
            String tipoTempoSoroteca = null;
            for (int i = 0; i < this.examesRecipiente.size(); ++i) {
                Exame exame = this.examesRecipiente.get(i).getExame();
                if (exame == null || exame.getSetor() == null || exame.getSetor().getCodigo() != codigoSetor) continue;
                int mult = 1;
                if (exame.getTipoTempoSoroteca().equalsIgnoreCase("M")) {
                    mult = 30;
                } else if (exame.getTipoTempoSoroteca().equalsIgnoreCase("A")) {
                    mult = 365;
                }
                Integer aux = exame.getTempoSoroteca() * mult;
                if (auxMenor != null && (aux >= auxMenor || aux <= 0) && (auxMenor != 0 || aux <= 0)) continue;
                auxMenor = aux;
                tipoTempoSoroteca = exame.getTipoTempoSoroteca();
            }
            return tipoTempoSoroteca;
        }
        return null;
    }

    public boolean temExameSemResultado() {
        for (ExameRecipiente exameRecipiente : this.examesRecipiente) {
            Exame e = exameRecipiente.getExame();
            if (e.getSituacao() != null && !Funcoes.textoVazio(e.getSituacao()) && !e.getSituacao().equals("T") && !e.getSituacao().equals("F") && !e.getSituacao().equals("P") && !e.getSituacao().equals("R") && !e.getSituacao().equals("O") && !e.getSituacao().equals("N") && !e.getSituacao().equals("A") && (!ParametrosGerais.getConferencia() || !e.getSituacao().equals("L"))) continue;
            return true;
        }
        return false;
    }

    public List<Exame> getExames() {
        ArrayList<Exame> exames = new ArrayList<Exame>();
        for (ExameRecipiente exameRecipiente : this.examesRecipiente) {
            exames.add(exameRecipiente.getExame());
        }
        return exames;
    }

    public void setExamesRecipiente(List<ExameRecipiente> listaExamesRecipiente) {
        this.examesRecipiente = listaExamesRecipiente;
    }

    public EstanteBean getEstante() {
        return this.estante;
    }

    public void setEstante(EstanteBean estante) {
        this.estante = estante;
    }

    public Date getDataHoraSoroteca() {
        return this.dataHoraSoroteca;
    }

    public void setDataHoraSoroteca(Date dataHoraSoroteca) {
        this.dataHoraSoroteca = dataHoraSoroteca;
    }

    public Date getDataRequisicao() {
        return this.dataRequisicao;
    }

    public void setDataRequisicao(Date dataRequisicao) {
        this.dataRequisicao = dataRequisicao;
    }

    public Tubo(String codigo, List<Exame> exames) {
        this.etiqueta = StringUtil.preencheString(codigo, digTotal, '0', 1);
        this.carregarRecipientes(codigo, codigo, exames);
    }

    private void carregarRecipientes(String pai, String filho, List<Exame> exames) {
        for (Exame exame : exames) {
            RecipienteBean recPai = this.createRecipiente(pai);
            RecipienteBean recFilho = this.createRecipiente(filho);
            this.examesRecipiente.add(new ExameRecipiente(exame, recPai, recFilho));
        }
    }

    private void carregarRecipientes(RecipienteBean recPai, RecipienteBean recFilho, List<Exame> exames) {
        for (Exame exame : exames) {
            this.examesRecipiente.add(new ExameRecipiente(exame, recPai, recFilho));
        }
    }

    private RecipienteBean createRecipiente(String pai) {
        RecipienteBean recPai = new RecipienteBean();
        recPai.setCodigo(Integer.valueOf(pai));
        return recPai;
    }

    public String getTipoEtiqueta() {
        return this.tipoEtiqueta;
    }

    public void setTipoEtiqueta(String tipoEtiqueta) {
        this.tipoEtiqueta = tipoEtiqueta;
    }

    public List<ExameRecipiente> getExamesNoRecipiente() {
        return this.examesRecipiente;
    }

    public void addExameRecipiente(ExameRecipiente exameRecipiente) {
        this.examesRecipiente.add(exameRecipiente);
    }

    public Tubo(FilialVO filial, RecipienteBean recipientePai, RecipienteBean recipienteFilho, List<Exame> exames, PacienteVO paciente, Integer linhaSoroteca, Integer colunaSoroteca, Date dataHoraSoroteca, EstanteBean estante, Date dataRequisicao, String tipoEtiqueta, Date dataHoraDescarte, UsuarioBean usuarioDescarte, int codigoSoroteca, UsuarioBean usuarioSoroteca, Integer codigoRequisicaoEtiqueta) {
        this.setEtiqueta(filial.getCodigo(), codigoRequisicaoEtiqueta, recipienteFilho.getCodigo());
        this.filial = filial;
        this.carregarRecipientes(recipientePai, recipienteFilho, exames);
        this.paciente = paciente;
        this.linhaSoroteca = linhaSoroteca;
        this.colunaSoroteca = colunaSoroteca;
        this.dataHoraSoroteca = dataHoraSoroteca;
        this.estante = estante;
        this.dataRequisicao = dataRequisicao;
        this.tipoEtiqueta = tipoEtiqueta;
        this.dataHoraDescarte = dataHoraDescarte;
        this.usuarioDescarte = usuarioDescarte;
        this.codigoSoroteca = codigoSoroteca;
        this.usuarioSoroteca = usuarioSoroteca;
        this.codigoRequisicaoEtiqueta = codigoRequisicaoEtiqueta;
    }

    public Tubo(FilialVO filial, List<ExameRecipiente> examesRecipiente, PacienteVO paciente, Integer linhaSoroteca, Integer colunaSoroteca, Date dataHoraSoroteca, EstanteBean estante, Date dataRequisicao, String tipoEtiqueta, Date dataHoraDescarte, UsuarioBean usuarioDescarte, int codigoSoroteca, UsuarioBean usuarioSoroteca, Integer codigoRequisicaoEtiqueta) {
        this.setEtiqueta(filial.getCodigo(), codigoRequisicaoEtiqueta, examesRecipiente.get(0).getRecipienteFilho().getCodigo());
        this.examesRecipiente = examesRecipiente;
        this.filial = filial;
        this.paciente = paciente;
        this.linhaSoroteca = linhaSoroteca;
        this.colunaSoroteca = colunaSoroteca;
        this.dataHoraSoroteca = dataHoraSoroteca;
        this.estante = estante;
        this.dataRequisicao = dataRequisicao;
        this.tipoEtiqueta = tipoEtiqueta;
        this.dataHoraDescarte = dataHoraDescarte;
        this.usuarioDescarte = usuarioDescarte;
        this.codigoSoroteca = codigoSoroteca;
        this.usuarioSoroteca = usuarioSoroteca;
        this.codigoRequisicaoEtiqueta = codigoRequisicaoEtiqueta;
    }

    public void calculaSeVencido(int codigoSetor) {
        String tipoTempoSoroteca = "D";
        Integer tempoSoroteca = this.getTempoSoroteca(codigoSetor);
        if (tipoTempoSoroteca == null || tempoSoroteca == null) {
            this.isVencido = false;
            return;
        }
        if (tempoSoroteca > 0) {
            Date dataAux;
            this.dataRetiradaSoroteca = dataAux = Funcoes.somaDias(this.getDataHoraSoroteca() == null ? new Date() : this.getDataHoraSoroteca(), tempoSoroteca);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dataAux);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            this.isVencido = new Date(calendar.getTimeInMillis()).compareTo(new Date()) <= 0;
        } else {
            this.dataRetiradaSoroteca = new Date();
            this.isVencido = false;
        }
    }

    public Date getDataRetiradaSoroteca() {
        return this.dataRetiradaSoroteca;
    }

    public boolean isVencido() {
        return this.isVencido;
    }

    public boolean equals(Object obj) {
        Tubo outroTubo;
        return obj instanceof Tubo && (outroTubo = (Tubo)obj).getEtiqueta().equals(this.etiqueta);
    }

    public boolean compararComSetor(Object obj) {
        Tubo outroTubo;
        return obj instanceof Tubo && (outroTubo = (Tubo)obj).getEtiqueta().equals(this.etiqueta) && outroTubo.getSetor().getCodigo() == this.getSetor().getCodigo();
    }

    public String toString() {
        return this.etiqueta + (this.setor == null ? "" : this.setor.getCodigo());
    }

    public void setEtiqueta(int codigoFilial, int codigoRequisicao, int codigoRecipiente) {
        int orientacao = 1;
        this.etiqueta = StringUtil.preencheString(String.valueOf(codigoFilial), digFilial, '0', orientacao) + StringUtil.preencheString(String.valueOf(codigoRequisicao), digRequisicao, '0', orientacao) + StringUtil.preencheString(String.valueOf(codigoRecipiente), digRecipiente, '0', orientacao);
    }

    public Date getDataHoraDescarte() {
        return this.dataHoraDescarte;
    }

    public void setDataHoraDescarte(Date dataHoraDescarte) {
        this.dataHoraDescarte = dataHoraDescarte;
    }

    public UsuarioBean getUsuarioDescarte() {
        return this.usuarioDescarte;
    }

    public void setUsuarioDescarte(UsuarioBean usuarioDescarte) {
        this.usuarioDescarte = usuarioDescarte;
    }

    public UsuarioBean getUsuarioSoroteca() {
        return this.usuarioSoroteca;
    }

    public void setUsuarioSoroteca(UsuarioBean usuarioSoroteca) {
        this.usuarioSoroteca = usuarioSoroteca;
    }

    public SetorVO getSetor() {
        return this.setor;
    }

    public void setSetor(SetorVO setor) {
        this.setor = setor;
    }

    public void setMarcado(boolean marcado) {
        this.marcado = marcado;
    }

    public boolean isMarcado() {
        return this.marcado;
    }

    public boolean isValido() {
        return !this.examesRecipiente.isEmpty() && !this.etiqueta.equalsIgnoreCase("000000000000");
    }
}

