/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca.util;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.soroteca.Soroteca;
import jalis.laboratorio.triagem.soroteca.util.Exame;
import jalis.laboratorio.triagem.soroteca.util.Posicao;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboContainer;
import jalis.laboratorio.triagem.soroteca.util.TuboContainerJTabuleiro;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class Informacoes
implements ActionListener {
    private Tubo tubo;
    private final JLabel labelVlrEtiqueta = new JLabel();
    private final JLabel labelVlrRequisicao = new JLabel();
    private final JLabel labelVlrPaciente = new JLabel();
    private final JLabel labelVlrDataRetiradaSoroteca = new JLabel();
    private final JLabel labelVlrDataSoroteca = new JLabel();
    private final JLabel labelVlrFilial = new JLabel();
    private final JLabel labelVlrDescricaoRecipiente = new JLabel();
    private final JLabel labelTuboVencido = new JLabel("Tubo Vencido!");
    private final JTextArea areaVlrConservarSoroteca = new JTextArea(3, 1);
    private ModeloGridTable modeloExames = null;
    private JTable tableExames = null;
    private JScrollPane scrollExames = null;
    private JScrollPane scrollConservarSoroteca = null;
    private JPanel containerDadosGerais = null;
    private JPanel containerConservacao = null;
    private final JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private final JButton buttonAdicionar = new JButton("Adicionar");
    private final JButton buttonRemover = new JButton("Remover");
    private TuboContainer containerTubos = null;
    private TTextField componenteSelecionar = null;
    private Soroteca soroteca = null;
    private final Timer timerAvisoTuboVencido = new Timer(300, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Informacoes.this.labelTuboVencido.setForeground(Informacoes.this.labelTuboVencido.getForeground() == Color.RED ? Color.BLACK : Color.RED);
        }
    });

    public void setTuboContainer(TuboContainer container) {
        this.containerTubos = container;
    }

    public Informacoes(JPanel containerDadosGerais, JPanel containerConservacao, TTextField componenteSelecionar, Soroteca soroteca) {
        this.containerDadosGerais = containerDadosGerais;
        this.containerConservacao = containerConservacao;
        this.componenteSelecionar = componenteSelecionar;
        this.soroteca = soroteca;
        this.buttonAdicionar.setMnemonic('a');
        this.buttonAdicionar.addActionListener(this);
        this.buttonRemover.setMnemonic('r');
        this.buttonRemover.addActionListener(this);
        this.labelTuboVencido.setVisible(false);
        this.desenha();
    }

    public Tubo getTubo() {
        return this.tubo;
    }

    public void preencheInformacoes(Tubo tubo, boolean isAdicionando) {
        this.tubo = tubo;
        this.limpaInformacoes();
        this.controlaCampos(true, isAdicionando);
        if (tubo == null) {
            return;
        }
        this.labelVlrFilial.setText(tubo.getFilial().getCodigo().toString());
        this.labelVlrPaciente.setText(tubo.getPaciente().getNome());
        this.labelVlrEtiqueta.setText(tubo.getEtiqueta());
        this.labelVlrDescricaoRecipiente.setText(tubo.getRecipienteFilho().getDescricao());
        List<Exame> listaExames = tubo.getExames();
        for (int i = 0; i < listaExames.size(); ++i) {
            Exame exame = listaExames.get(i);
            boolean podeAdicionarExame = true;
            for (int j = 0; j < this.modeloExames.getRowCount(); ++j) {
                String codigoExame = this.modeloExames.getValueAt(j, 0).toString();
                String codigoMaterial = this.modeloExames.getValueAt(j, 1).toString();
                if (!codigoExame.equalsIgnoreCase(exame.getCodigo()) || !codigoMaterial.equalsIgnoreCase(exame.getMaterial())) continue;
                podeAdicionarExame = false;
                break;
            }
            if (!podeAdicionarExame) continue;
            this.modeloExames.addLine(new Object[]{exame.getCodigo(), exame.getMaterial(), exame.getDescricao(), exame.getSituacao(), exame});
        }
        if (this.modeloExames.getColunaOrdenacao() == -1) {
            this.modeloExames.ordenarColunaSemTrocarSentido(this.modeloExames.findColumn("C\u00f3d."));
        } else {
            this.modeloExames.ordenarColunaSemTrocarSentido(this.modeloExames.getColunaOrdenacao());
        }
        this.areaVlrConservarSoroteca.setText(tubo.getConservacao(tubo.getSetor().getCodigo()));
        if (tubo.getDataHoraSoroteca() != null) {
            this.labelVlrDataSoroteca.setText(Funcoes.formataData("dd/MM/yyyy HH:mm", tubo.getDataHoraSoroteca()));
        } else {
            this.labelVlrDataSoroteca.setText("");
        }
        if (tubo.getDataRetiradaSoroteca() != null) {
            this.labelVlrDataRetiradaSoroteca.setText(Funcoes.formataData("dd/MM/yyyy", tubo.getDataRetiradaSoroteca()));
        } else {
            this.labelVlrDataRetiradaSoroteca.setText("");
        }
        if (tubo.isVencido()) {
            this.labelTuboVencido.setVisible(true);
            this.timerAvisoTuboVencido.setInitialDelay(0);
            this.timerAvisoTuboVencido.start();
        } else {
            this.labelTuboVencido.setVisible(false);
            this.timerAvisoTuboVencido.stop();
        }
        if (isAdicionando) {
            ScreenUtil.requisitarFoco(this.buttonAdicionar);
        }
    }

    public void limpaInformacoes() {
        this.labelVlrFilial.setText("");
        this.labelVlrRequisicao.setText("");
        this.labelVlrPaciente.setText("");
        this.labelVlrEtiqueta.setText("");
        this.labelVlrDescricaoRecipiente.setText("");
        this.areaVlrConservarSoroteca.setText("");
        this.labelVlrDataRetiradaSoroteca.setText("");
        this.labelVlrDataSoroteca.setText("");
        this.labelTuboVencido.setVisible(false);
        this.modeloExames.clear();
        this.controlaCampos(false, false);
    }

    private void desenha() {
        Component[] componentes = new Component[]{this.labelVlrEtiqueta, this.labelVlrRequisicao, this.labelVlrPaciente, this.labelVlrFilial, this.labelVlrDataRetiradaSoroteca, this.labelVlrDataSoroteca, this.labelVlrDescricaoRecipiente};
        ScreenUtil.setBorda(componentes, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        Dimension d = new Dimension(50, 20);
        this.labelVlrFilial.setMinimumSize(d);
        this.labelVlrFilial.setPreferredSize(d);
        this.labelVlrPaciente.setMinimumSize(d);
        this.labelVlrPaciente.setPreferredSize(d);
        this.labelVlrDescricaoRecipiente.setMinimumSize(d);
        this.labelVlrDescricaoRecipiente.setPreferredSize(d);
        d = new Dimension(120, 20);
        this.labelVlrEtiqueta.setMinimumSize(d);
        this.labelVlrEtiqueta.setPreferredSize(d);
        d = new Dimension(116, 20);
        this.labelVlrRequisicao.setMinimumSize(d);
        this.labelVlrRequisicao.setPreferredSize(d);
        this.modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{String.class, String.class, String.class, String.class, Tubo.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tableExames = new JTable(this.modeloExames);
        this.modeloExames.setColumnSize(new int[]{70, 50, 0, 50}, this.tableExames);
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Exame aux;
                int row = -1;
                row = Informacoes.this.tableExames.getSelectedRow();
                if (row > -1 && (aux = (Exame)Informacoes.this.modeloExames.getValueAt(row, 4)) != null) {
                    Informacoes.this.labelVlrRequisicao.setText(aux.getCodigoRequisicao() + " / " + Informacoes.this.tubo.getSetor().getSigla());
                }
            }
        });
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.scrollExames = new JScrollPane(this.tableExames);
        this.scrollExames.setMinimumSize(new Dimension(315, 70));
        this.tableExames.setDefaultRenderer(Object.class, new ExamesRenderer());
        this.scrollConservarSoroteca = new JScrollPane(this.areaVlrConservarSoroteca);
        this.scrollConservarSoroteca.setBorder(null);
        this.labelTuboVencido.setForeground(Color.RED);
        this.labelTuboVencido.setFont(this.labelTuboVencido.getFont().deriveFont(new Float(this.labelTuboVencido.getFont().getSize() + 2).floatValue()));
        this.panelBotoes.add(this.labelTuboVencido);
        this.panelBotoes.add(this.buttonRemover);
        this.panelBotoes.add(this.buttonAdicionar);
        this.labelVlrEtiqueta.setMinimumSize(new Dimension(110, 20));
        this.labelVlrEtiqueta.setPreferredSize(new Dimension(110, 20));
        this.labelVlrEtiqueta.setMaximumSize(new Dimension(110, 20));
        JPanel panelInfoTuboEsq = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 1, 0);
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.gridwidth = 1;
        panelInfoTuboEsq.add((Component)new JLabel("Filial:"), c);
        ++c.gridx;
        panelInfoTuboEsq.add((Component)this.labelVlrFilial, c);
        ++c.gridx;
        c.insets = new Insets(0, 20, 1, 0);
        c.gridwidth = 2;
        panelInfoTuboEsq.add((Component)new JLabel("Req./Setor:"), c);
        c.gridx += 2;
        c.insets = new Insets(0, 0, 1, 0);
        c.gridwidth = 2;
        c.fill = 2;
        panelInfoTuboEsq.add((Component)this.labelVlrRequisicao, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        panelInfoTuboEsq.add((Component)new JLabel("Paciente:"), c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        panelInfoTuboEsq.add((Component)this.labelVlrPaciente, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        panelInfoTuboEsq.add((Component)new JLabel("Etiqueta:"), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 2;
        panelInfoTuboEsq.add((Component)this.labelVlrEtiqueta, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        panelInfoTuboEsq.add((Component)this.labelVlrDescricaoRecipiente, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.fill = 2;
        panelInfoTuboEsq.add((Component)this.panelBotoes, c);
        this.containerDadosGerais.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 1, 0);
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.containerDadosGerais.add((Component)panelInfoTuboEsq, c);
        ++c.gridx;
        c.weightx = 0.9;
        this.containerDadosGerais.add((Component)this.scrollExames, c);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 0, 1, 0);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.areaVlrConservarSoroteca.setFocusable(false);
        this.areaVlrConservarSoroteca.setBackground(this.labelVlrDataRetiradaSoroteca.getBackground());
        this.areaVlrConservarSoroteca.setMinimumSize(new Dimension(150, 20));
        this.areaVlrConservarSoroteca.setPreferredSize(new Dimension(150, 20));
        this.areaVlrConservarSoroteca.setLineWrap(true);
        this.areaVlrConservarSoroteca.setWrapStyleWord(true);
        this.containerConservacao.add((Component)this.scrollConservarSoroteca, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.containerConservacao.add((Component)new JLabel("Data Armazenamento:"), c);
        ++c.gridy;
        this.labelVlrDataSoroteca.setMinimumSize(new Dimension(150, 20));
        this.labelVlrDataSoroteca.setPreferredSize(new Dimension(150, 20));
        this.containerConservacao.add((Component)this.labelVlrDataSoroteca, c);
        ++c.gridy;
        this.containerConservacao.add((Component)new JLabel("Previs\u00e3o de Retirada:"), c);
        ++c.gridy;
        this.labelVlrDataRetiradaSoroteca.setMinimumSize(new Dimension(150, 20));
        this.labelVlrDataRetiradaSoroteca.setPreferredSize(new Dimension(150, 20));
        this.containerConservacao.add((Component)this.labelVlrDataRetiradaSoroteca, c);
    }

    public JPanel getPanel() {
        return new JPanel(new GridBagLayout());
    }

    public void controlaCampos(boolean habilita, boolean adicionar) {
        this.buttonAdicionar.setEnabled(habilita && adicionar && this.tubo != null && this.tubo.podeAdicionarTubo());
        this.buttonRemover.setEnabled(habilita && this.tubo != null && !adicionar && this.containerTubos.isTuboAdicionado(this.tubo));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAdicionar) {
            if (this.containerTubos == null) {
                return;
            }
            if (this.containerTubos.isNumeroPosicoesLimitado() && this.containerTubos.getNumeroPosicoesVazias() > 0) {
                EstanteBean estante;
                Tubo aux;
                List<Tubo> listaTubos = this.containerTubos.getTubosSelecionados();
                List<Posicao> listaPosicoes = ((TuboContainerJTabuleiro)this.containerTubos).getPosicoesSelecionadas();
                if (listaTubos != null && listaTubos.size() > 0 && (aux = listaTubos.get(0)) != null) {
                    int resp = Funcoes.mensagem(Laboratorio.getInstancia(), "A posi\u00e7\u00e3o j\u00e1 est\u00e1 ocupada pelo tubo de etiqueta: \"" + aux.getEtiqueta() + "\".\nDeseja adicionar o tubo na pr\u00f3xima posi\u00e7\u00e3o vazia?", 4);
                    if (resp == 1) {
                        return;
                    }
                    listaPosicoes = null;
                }
                Tubo auxTubo = this.tubo;
                Posicao posicao = null;
                posicao = listaPosicoes != null && listaPosicoes.size() > 0 ? listaPosicoes.get(0) : ((TuboContainerJTabuleiro)this.containerTubos).selecionarProximaPosicaoVazia();
                if (posicao == null) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 pr\u00f3ximas posi\u00e7\u00f5es, por\u00e9m h\u00e1 posi\u00e7\u00f5es vazias.\nPor favor, selecione a posi\u00e7\u00e3o desejada e adicione o tubo manualmente.", 2);
                    return;
                }
                auxTubo.setPosicaoSoroteca(posicao);
                this.containerTubos.addTubo(auxTubo, true);
                this.containerTubos.selecionarTubo(auxTubo, true);
                this.containerTubos.mostrarInformacoesTubo(auxTubo);
                if (Soroteca.isImprimirIdentificacaoTubos() && (estante = Soroteca.getEstante()) != null) {
                    try {
                        Impressao.imprimirIdentificacaoTubo(Integer.parseInt(Variaveis.filialPadrao), auxTubo.getFilial().getCodigo(), estante.getCodigo(), auxTubo.getCodigoRequisicaoEtiqueta(), auxTubo.getRecipienteFilho().getCodigo(), auxTubo.getSetor().getCodigo(), estante.getGeladeira().getCodigo(), estante.getPrateleira().getCodigo(), auxTubo.getDataHoraSoroteca(), auxTubo.getDataRetiradaSoroteca());
                    }
                    catch (SQLException e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir a identifica\u00e7\u00e3o dos tubos.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            } else {
                EstanteBean estante;
                if (this.containerTubos.isNumeroPosicoesLimitado() && this.containerTubos.getNumeroPosicoesVazias() <= 0) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "A estante est\u00e1 cheia", 2);
                    return;
                }
                this.containerTubos.addTubo(this.tubo, true);
                this.containerTubos.selecionarTubo(this.tubo, true);
                this.containerTubos.mostrarInformacoesTubo(this.tubo);
                if (Soroteca.isImprimirIdentificacaoTubos() && (estante = Soroteca.getEstante()) != null) {
                    try {
                        Impressao.imprimirIdentificacaoTubo(Integer.parseInt(Variaveis.filialPadrao), this.tubo.getFilial().getCodigo(), estante.getCodigo(), this.tubo.getCodigoRequisicaoEtiqueta(), this.tubo.getRecipienteFilho().getCodigo(), this.tubo.getSetor().getCodigo(), estante.getGeladeira().getCodigo(), estante.getPrateleira().getCodigo(), this.tubo.getDataHoraSoroteca(), this.tubo.getDataRetiradaSoroteca());
                    }
                    catch (SQLException e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir a identifica\u00e7\u00e3o dos tubos.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            }
            if (this.componenteSelecionar != null) {
                Posicao aux;
                this.componenteSelecionar.clear();
                ScreenUtil.requisitarFoco(this.componenteSelecionar);
                if (this.containerTubos instanceof TuboContainerJTabuleiro && (aux = ((TuboContainerJTabuleiro)this.containerTubos).selecionarProximaPosicaoVazia()) == null) {
                    this.limpaInformacoes();
                }
            }
            this.soroteca.controlaCampos(false);
        }
        if (e.getSource() == this.buttonRemover && this.containerTubos != null) {
            int resp;
            Iterator<Exame> it = this.tubo.getExames().iterator();
            ArrayList<Exame> descricaoExamesSemResultado = new ArrayList<Exame>();
            while (it.hasNext()) {
                Exame exame = it.next();
                if (!Funcoes.textoVazio(exame.getSituacao())) continue;
                boolean podeAdicionarExame = true;
                for (Exame ex : descricaoExamesSemResultado) {
                    if (!ex.getCodigo().equals(exame.getCodigo()) || ex.getCodigoMaterial() != exame.getCodigoMaterial()) continue;
                    podeAdicionarExame = false;
                    break;
                }
                if (!podeAdicionarExame) continue;
                descricaoExamesSemResultado.add(exame);
            }
            StringBuilder buf = new StringBuilder();
            if (descricaoExamesSemResultado.size() > 0) {
                if (descricaoExamesSemResultado.size() > 1) {
                    buf.append("Os seguintes exames n\u00e3o possuem resultado: ");
                } else {
                    buf.append("O seguinte exame n\u00e3o possui resultado: ");
                }
                for (int i = 0; i < descricaoExamesSemResultado.size(); ++i) {
                    if (i > 0) {
                        buf.append(",\n");
                    }
                    buf.append("<font color=red>\"").append(((Exame)descricaoExamesSemResultado.get(i)).getDescricao()).append("\"</font>");
                }
                buf.append(".\n");
            }
            if ((resp = Funcoes.mensagem(Laboratorio.getInstancia(), buf.toString() + "Confirma a remo\u00e7\u00e3o do tubo?", 4)) == 1) {
                return;
            }
            this.containerTubos.removerTubo(this.tubo);
            this.preencheInformacoes(null, false);
            this.soroteca.controlaCampos(false);
            ScreenUtil.requisitarFoco(this.componenteSelecionar);
        }
    }

    class ExamesRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (row < Informacoes.this.modeloExames.getRowCount() && Informacoes.this.modeloExames.getValueAt(row, Informacoes.this.modeloExames.findColumn("Sit.")) != null && !Informacoes.this.modeloExames.getValueAt(row, Informacoes.this.modeloExames.findColumn("Sit.")).equals("") && !Informacoes.this.modeloExames.getValueAt(row, Informacoes.this.modeloExames.findColumn("Sit.")).equals(" ")) {
                String b = (String)Informacoes.this.modeloExames.getValueAt(row, Informacoes.this.modeloExames.findColumn("Sit."));
                c.setBackground(Tipos.getCorSituacaoExame(b)[0]);
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

