/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca.util;

import jalis.laboratorio.triagem.soroteca.util.Posicao;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Estante {
    private int codigo;
    private String identificador;
    private int linhas;
    private int colunas;
    private Map<Posicao, Tubo> tubos;

    public Estante(int codigo, int linhas, int colunas) {
        this.codigo = codigo;
        this.linhas = linhas;
        this.colunas = colunas;
        this.tubos = new TreeMap<Posicao, Tubo>();
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public int getLinhas() {
        return this.linhas;
    }

    public int getColunas() {
        return this.colunas;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public Tubo getTubo(int linha, int coluna) {
        return this.tubos.get(new Posicao(linha, coluna));
    }

    public Map<Posicao, Tubo> getTubos() {
        return Collections.unmodifiableMap(this.tubos);
    }

    public int getQtPosicoesVazias() {
        return this.linhas * this.colunas - this.tubos.size();
    }

    private Posicao getProximaPosicaoVazia() {
        for (int linha = 0; linha < this.linhas; ++linha) {
            for (int coluna = 0; coluna < this.colunas; ++coluna) {
                Posicao posicao = new Posicao(linha, coluna);
                if (this.tubos.get(posicao) != null) continue;
                return posicao;
            }
        }
        return null;
    }

    public boolean isPosicaoVazia(int linha, int coluna) {
        return this.tubos.get(new Posicao(linha, coluna)) == null;
    }

    public void adicionaTubo(Tubo tubo) {
        if (this.getQtPosicoesVazias() > 0) {
            this.tubos.put(this.getProximaPosicaoVazia(), tubo);
        }
    }

    public void adicionaTubos(List<Tubo> tubos) {
        if (this.getQtPosicoesVazias() >= tubos.size()) {
            for (Tubo tubo : tubos) {
                this.tubos.put(this.getProximaPosicaoVazia(), tubo);
            }
        }
    }
}

