/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca.jtabuleiro;

import jalis.laboratorio.triagem.soroteca.util.Posicao;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboContainer;
import jalis.util.ScreenUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JTabuleiro<K>
extends JPanel
implements MouseListener {
    public static final Color COR_VAZIA = new Color(220, 220, 220);
    public static final Color COR_PREENCHIDA = new Color(60, 125, 175);
    public static final Color COR_PREENCHIDA_VENCIDO = new Color(100, 120, 80);
    public static final Color COR_MARCADO = ScreenUtil.clarearCor(Color.RED, 100);
    public static final Color COR_PREENCHIDA_SEM_RESULTADO = Color.ORANGE;
    private static final long serialVersionUID = 1L;
    private final int linhas;
    private final int colunas;
    private final Map<Posicao, JTabuleiroPeca<K>> pecas;
    private boolean multiplaSelecao = false;
    private boolean podeSelecionar = false;
    private boolean podeMarcar = false;
    private TuboContainer pai = null;
    private DetalhesTabuleiro detalhesTabuleiro = null;
    private static final int ERRO_BORDAS = 35;
    private static final int TAMANHO_DETALHES = 20;

    public void limpar() {
        this.pecas.clear();
    }

    public void setBarraDetalhesVisivel(boolean isVisivel) {
        this.detalhesTabuleiro.setVisible(isVisivel);
    }

    public boolean isBarraDetalhesVisivel() {
        return this.detalhesTabuleiro.isVisible();
    }

    public ArrayList<Tubo> localizarTubos(String etiquetaParcial) {
        ArrayList<Tubo> lista = new ArrayList<Tubo>();
        for (int linha = 0; linha <= this.linhas; ++linha) {
            for (int coluna = 0; coluna < this.colunas; ++coluna) {
                Tubo tubo;
                JTabuleiroPeca<K> peca = this.pecas.get(new Posicao(linha, coluna));
                if (peca == null || peca.getValor() == null || !(tubo = (Tubo)peca.getValor()).getEtiqueta().startsWith(etiquetaParcial)) continue;
                lista.add(tubo);
            }
        }
        return lista;
    }

    public Tubo localizarTubo(String etiquetaParcial) {
        for (int linha = 0; linha <= this.linhas; ++linha) {
            for (int coluna = 0; coluna < this.colunas; ++coluna) {
                Tubo tubo;
                JTabuleiroPeca<K> peca = this.pecas.get(new Posicao(linha, coluna));
                if (peca == null || peca.getValor() == null || !(tubo = (Tubo)peca.getValor()).getEtiqueta().startsWith(etiquetaParcial)) continue;
                return tubo;
            }
        }
        return null;
    }

    public void limparSelecao() {
        for (JTabuleiroPeca<K> peca : this.pecas.values()) {
            peca.setSelecionado(false);
        }
    }

    public void selecionarTubo(Tubo tubo, boolean limpar) {
        for (JTabuleiroPeca<K> peca : this.pecas.values()) {
            if (peca.getValor() != null && tubo != null && peca.getValor().equals(tubo)) {
                peca.setSelecionado(true);
                continue;
            }
            if (!limpar) continue;
            peca.setSelecionado(false);
        }
    }

    public void selecionarTuboEtiquetaRepetida(Tubo tubo) {
        for (JTabuleiroPeca<K> peca : this.pecas.values()) {
            if (peca.getValor() != null && tubo != null && peca.getValor().equals(tubo) && ((Tubo)peca.getValor()).getCodigoSoroteca().intValue() == tubo.getCodigoSoroteca().intValue()) {
                peca.setSelecionado(true);
                continue;
            }
            peca.setSelecionado(false);
        }
    }

    public void atualizaDiametroTubos(JComponent pai) {
        int diametroPecas = 0;
        int margem = 2;
        if (pai == null) {
            return;
        }
        pai.revalidate();
        int auxWidth = pai.getWidth() - 105 - (pai.getInsets().left + pai.getInsets().right);
        int auxHeight = pai.getHeight() - 70 - 20 - (pai.getInsets().top + pai.getInsets().bottom);
        if (auxWidth / this.colunas <= auxHeight / this.linhas) {
            diametroPecas = auxWidth;
            diametroPecas -= 2 * margem;
            diametroPecas /= this.colunas;
        } else {
            diametroPecas = auxHeight;
            diametroPecas -= 2 * margem;
            diametroPecas /= this.linhas;
        }
        for (int linha = 0; linha < this.linhas; ++linha) {
            for (int coluna = 0; coluna < this.colunas; ++coluna) {
                Posicao posicao = new Posicao(linha, coluna);
                this.pecas.get(posicao).setDiametro(diametroPecas);
            }
        }
        boolean diminuirTamanho = false;
        if (diametroPecas < 10) {
            diminuirTamanho = true;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof JLabel)) continue;
            JLabel label = (JLabel)this.getComponent(i);
            label.setFont(new JLabel().getFont().deriveFont(new Float(new JLabel().getFont().getSize() - (diminuirTamanho ? 2 : 0)).floatValue()));
        }
        this.revalidate();
        this.repaint();
    }

    public JTabuleiro(int linhas, int colunas, TuboContainer parent, JComponent container, boolean podeSelecionar, boolean podeMarcar) {
        super(new GridBagLayout());
        int i;
        this.podeSelecionar = podeSelecionar;
        this.podeMarcar = podeMarcar;
        this.pai = parent;
        this.linhas = linhas;
        this.colunas = colunas;
        this.pecas = new TreeMap<Posicao, JTabuleiroPeca<K>>();
        int diametroPecas = 0;
        int margem = 2;
        this.setBackground(Color.WHITE);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel(), c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        int linha = linhas - 1;
        int linhaAux = 0;
        while (linha >= 0) {
            for (int coluna = 0; coluna < colunas; ++coluna) {
                JTabuleiroPeca peca = new JTabuleiroPeca(diametroPecas, margem);
                Posicao posicao = new Posicao(linhaAux, coluna);
                if (podeSelecionar || podeMarcar) {
                    this.instalaListenersPeca(posicao, peca);
                }
                this.pecas.put(posicao, peca);
                c.gridy = linha + 1;
                c.gridx = coluna + 1;
                this.add(peca, c);
            }
            --linha;
            ++linhaAux;
        }
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = colunas + 1;
        c.gridy = linhas + 1;
        this.add((Component)new JLabel(), c);
        for (i = 0; i < linhas; ++i) {
            int auxChar = 65;
            c.anchor = 13;
            c.fill = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = linhas - i;
            this.add((Component)new JLabel("" + (char)(auxChar + i)), c);
            c.anchor = 17;
            c.gridx = colunas + 1;
            this.add((Component)new JLabel("" + (char)(auxChar + i)), c);
        }
        for (i = 0; i < colunas; ++i) {
            c.anchor = 15;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 1.0;
            c.gridx = i + 1;
            c.gridy = 0;
            this.add((Component)new JLabel("" + (i + 1)), c);
            c.anchor = 11;
            c.gridy = linhas + 1;
            this.add((Component)new JLabel("" + (i + 1)), c);
        }
        int qtdeVazias = this.getPosicoesVazias().size();
        this.detalhesTabuleiro = new DetalhesTabuleiro(linhas * colunas, linhas * colunas - qtdeVazias);
        c.anchor = 15;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = linhas + 2;
        c.gridwidth = colunas + 2;
        this.add((Component)this.detalhesTabuleiro, c);
        this.atualizaDiametroTubos(container);
    }

    private void instalaListenersPeca(Posicao posicao, JTabuleiroPeca<K> peca) {
        peca.addMouseListener(this);
    }

    public boolean isPosicaoValida(int linha, int coluna) {
        return linha < this.linhas && coluna < this.colunas;
    }

    public boolean isPosicaoValida(Posicao posicao) {
        return posicao.getLinha() < this.linhas && posicao.getColuna() < this.colunas;
    }

    public List<Posicao> getPosicoesSelecionadas() {
        ArrayList<Posicao> selecionadas = new ArrayList<Posicao>();
        for (Posicao posicao : this.pecas.keySet()) {
            if (!this.pecas.get(posicao).isSelecionado()) continue;
            selecionadas.add(posicao);
        }
        return selecionadas;
    }

    public List<Posicao> getPosicoesVazias() {
        ArrayList<Posicao> vazias = new ArrayList<Posicao>();
        for (Posicao posicao : this.pecas.keySet()) {
            if (!this.pecas.get(posicao).isVazio()) continue;
            vazias.add(posicao);
        }
        return vazias;
    }

    public void setValor(int linha, int coluna, K valor) {
        if (this.isPosicaoValida(linha, coluna)) {
            this.pecas.get(new Posicao(linha, coluna)).setValor(valor);
        }
        this.detalhesTabuleiro.setDados(this.pecas.size(), this.getNumeroPosicoesOcupadas());
        this.repaint();
    }

    public void setValor(Posicao posicao, K valor) {
        if (this.isPosicaoValida(posicao)) {
            this.pecas.get(posicao).setValor(valor);
        }
        this.detalhesTabuleiro.setDados(this.pecas.size(), this.getNumeroPosicoesOcupadas());
        this.repaint();
    }

    public Posicao setValor(K valor, Posicao posicao) {
        if (this.getNumeroPosicoesVazias() > 0) {
            Posicao posicaoAux = null;
            posicaoAux = posicao == null || posicao.getLinha() == -1 || posicao.getColuna() == -1 ? this.getProximaPosicaoVazia() : posicao;
            if (posicaoAux != null) {
                this.pecas.get(posicaoAux).setValor(valor);
                if (valor instanceof Tubo) {
                    ((Tubo)valor).setLinhaSoroteca(posicaoAux.getLinha());
                    ((Tubo)valor).setColunaSoroteca(posicaoAux.getColuna());
                }
                this.detalhesTabuleiro.setDados(this.pecas.size(), this.getNumeroPosicoesOcupadas());
            }
            this.repaint();
            return posicaoAux;
        }
        this.repaint();
        return null;
    }

    public Posicao getProximaPosicaoVazia() {
        for (int linha = this.linhas - 1; linha >= 0; --linha) {
            for (int coluna = this.colunas - 1; coluna >= 0; --coluna) {
                Posicao posicao = new Posicao(linha, coluna);
                if (this.pecas.get(posicao).getValor() == null) continue;
                if (coluna + 1 >= this.colunas) {
                    coluna = 0;
                    ++linha;
                } else {
                    ++coluna;
                }
                if (linha >= this.linhas) {
                    return null;
                }
                if (coluna >= this.colunas) {
                    return null;
                }
                return new Posicao(linha, coluna);
            }
        }
        return new Posicao(0, 0);
    }

    public Posicao selecionarProximaPosicaoVazia() {
        Posicao posicaoVazia = this.getProximaPosicaoVazia();
        this.selecionarTubo(null, true);
        if (posicaoVazia != null && posicaoVazia.getLinha() != -1 && posicaoVazia.getColuna() != -1) {
            this.pecas.get(posicaoVazia).setSelecionado(true);
            this.mostrarInformacoesTubo(null);
            return posicaoVazia;
        }
        return null;
    }

    public Object getValor(int linha, int coluna) {
        if (this.isPosicaoValida(linha, coluna)) {
            return this.pecas.get(new Posicao(linha, coluna)).getValor();
        }
        return null;
    }

    public Object getValor(Posicao posicao) {
        if (this.isPosicaoValida(posicao)) {
            return this.pecas.get(posicao).getValor();
        }
        return null;
    }

    public List<K> getValores() {
        ArrayList<K> valores = new ArrayList<K>();
        for (JTabuleiroPeca<K> peca : this.pecas.values()) {
            if (peca.isVazio()) continue;
            valores.add(peca.getValor());
        }
        return valores;
    }

    public List<K> getValoresSelecionados() {
        ArrayList<K> valores = new ArrayList<K>();
        for (JTabuleiroPeca<K> peca : this.pecas.values()) {
            if (!peca.isSelecionado() || peca.isVazio()) continue;
            valores.add(peca.getValor());
        }
        return valores;
    }

    public void removeValor(int linha, int coluna) {
        if (this.isPosicaoValida(linha, coluna)) {
            this.pecas.get(new Posicao(linha, coluna)).removeValor();
        }
    }

    public void removeTodosValores() {
        Iterator<JTabuleiroPeca<K>> itens = this.pecas.values().iterator();
        while (itens.hasNext()) {
            itens.next().removeValor();
        }
    }

    public void removeValor(K valor) {
        for (JTabuleiroPeca<K> peca : this.pecas.values()) {
            if (peca.isVazio() || !peca.getValor().equals(valor) || ((Tubo)peca.getValor()).getCodigoSoroteca().intValue() != ((Tubo)valor).getCodigoSoroteca().intValue()) continue;
            peca.removeValor();
            break;
        }
    }

    public boolean isVazio(int linha, int coluna) {
        if (this.isPosicaoValida(linha, coluna)) {
            return this.pecas.get(new Posicao(linha, coluna)).isVazio();
        }
        return true;
    }

    public boolean isVazio(Posicao posicao) {
        if (this.isPosicaoValida(posicao)) {
            return this.pecas.get(posicao).isVazio();
        }
        return true;
    }

    public int getNumeroPosicoesVazias() {
        return this.getPosicoesVazias().size();
    }

    public int getNumeroPosicoesOcupadas() {
        return this.pecas.size() - this.getPosicoesVazias().size();
    }

    public boolean contem(K valor) {
        Iterator<JTabuleiroPeca<K>> itens = this.pecas.values().iterator();
        while (itens.hasNext()) {
            K valorTemp = itens.next().getValor();
            if (valorTemp == null || !valorTemp.toString().equals(valor.toString())) continue;
            return true;
        }
        return false;
    }

    public void setFormaPecas(formas forma) {
        Iterator<JTabuleiroPeca<K>> itens = this.pecas.values().iterator();
        while (itens.hasNext()) {
            itens.next().setForma(forma);
        }
    }

    public void setCorPanel(Color cor) {
        this.setBackground(cor);
    }

    public int getLinhas() {
        return this.linhas;
    }

    public int getColunas() {
        return this.colunas;
    }

    public boolean isMultiplaSelecao() {
        return this.multiplaSelecao;
    }

    public void setMultiplaSelecao(boolean multiplaSelecao) {
        this.multiplaSelecao = multiplaSelecao;
        if (!multiplaSelecao) {
            Iterator<JTabuleiroPeca<K>> itens = this.pecas.values().iterator();
            while (itens.hasNext()) {
                itens.next().setSelecionado(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTabuleiroPeca peca = null;
        if (!(e.getSource() instanceof JTabuleiroPeca)) {
            return;
        }
        peca = (JTabuleiroPeca)e.getSource();
        if (this.podeSelecionar) {
            if (!this.multiplaSelecao || !e.isControlDown()) {
                Iterator<JTabuleiroPeca<K>> itens = this.pecas.values().iterator();
                while (itens.hasNext()) {
                    itens.next().setSelecionado(false);
                }
            }
            peca.setSelecionado(!peca.isSelecionado() && !e.isControlDown());
            this.mostrarInformacoesTubo((Tubo)peca.getValor());
        } else if (this.podeMarcar && peca.getValor() != null) {
            peca.setMarcado(!peca.isMarcado());
        }
    }

    private void mostrarInformacoesTubo(Tubo tubo) {
        this.pai.mostrarInformacoesTubo(tubo);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    @Deprecated
    public void mousePressed(MouseEvent e) {
    }

    @Override
    @Deprecated
    public void mouseReleased(MouseEvent e) {
    }

    class DetalhesTabuleiro
    extends JPanel {
        int totalPosicoes = 0;
        int usadasPosicoes = 0;
        private final JLabel labelDetalhes = new JLabel();

        public DetalhesTabuleiro(int totalPosicoes, int usadasPosicoes) {
            this.setPreferredSize(new Dimension(10, 20));
            this.totalPosicoes = totalPosicoes;
            this.usadasPosicoes = usadasPosicoes;
            this.montar();
            this.atualizarDados();
        }

        public void setDados(int totalPosicoes, int usadasPosicoes) {
            this.totalPosicoes = totalPosicoes;
            this.usadasPosicoes = usadasPosicoes;
            this.atualizarDados();
        }

        private void atualizarDados() {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("<table>");
            html.append("<tr>");
            html.append("<td width='200'><b>Total de posi\u00e7\u00f5es: </b>");
            html.append("<font color=red>").append(this.totalPosicoes).append("</font></td>");
            html.append("<td width='200' align='center'><b>Posi\u00e7\u00f5es ocupadas: </b>");
            html.append("<font color=red>").append(this.usadasPosicoes).append("</font></td>");
            html.append("<td width='200' align='right'><b>Posi\u00e7\u00f5es livres: </b>");
            html.append("<font color=red>").append(this.totalPosicoes - this.usadasPosicoes).append("</font></td>");
            html.append("</tr>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
        }

        private void setDetalhes(String detalhes) {
            this.labelDetalhes.setText(detalhes);
        }

        private void montar() {
            this.labelDetalhes.setFont(new Font(this.labelDetalhes.getFont().getName(), 1, 12));
            this.labelDetalhes.setHorizontalAlignment(4);
            this.labelDetalhes.setVerticalAlignment(1);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weighty = 0.0;
            c.weightx = 1.0;
            this.add((Component)this.labelDetalhes, c);
        }
    }

    protected class JTabuleiroPeca<J>
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private boolean selecionado = false;
        private J valor;
        private int diametro;
        private final int margem;
        private formas forma = formas.CIRCULO;

        public int getDiametro() {
            return this.diametro;
        }

        public int getMargem() {
            return this.margem;
        }

        public formas getFormato() {
            return this.forma;
        }

        public void setForma(formas forma) {
            this.forma = forma;
            this.repaint();
        }

        public boolean isMarcado() {
            if (this.getValor() != null) {
                return ((Tubo)this.getValor()).isMarcado();
            }
            return false;
        }

        public boolean isSelecionado() {
            return this.selecionado;
        }

        public void setSelecionado(boolean selecionado) {
            this.selecionado = selecionado;
            this.repaint();
        }

        public void setMarcado(boolean marcado) {
            if (this.getValor() != null) {
                ((Tubo)this.getValor()).setMarcado(marcado);
            }
            this.repaint();
        }

        private JTabuleiroPeca(int diametro, int margem) {
            this.diametro = diametro;
            this.margem = margem;
            int diametroTotal = diametro + margem * 2;
            this.setFocusable(true);
            this.setMinimumSize(new Dimension(diametroTotal, diametroTotal));
            this.setPreferredSize(new Dimension(diametroTotal, diametroTotal));
        }

        @Override
        public void paint(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.isVazio()) {
                g2.setColor(COR_VAZIA);
            } else if (this.getValor() != null && ((Tubo)this.getValor()).isMarcado()) {
                g2.setColor(COR_MARCADO);
            } else if (JTabuleiro.this.podeSelecionar) {
                g2.setColor(((Tubo)this.valor).isVencido() ? COR_PREENCHIDA_VENCIDO : (((Tubo)this.valor).temExameSemResultado() ? COR_PREENCHIDA_SEM_RESULTADO : COR_PREENCHIDA));
            } else {
                g2.setColor(((Tubo)this.valor).temExameSemResultado() ? COR_PREENCHIDA_SEM_RESULTADO : COR_PREENCHIDA);
            }
            if (this.forma == formas.CIRCULO) {
                g2.fillOval(this.margem, this.margem, this.diametro, this.diametro);
                if (this.selecionado) {
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.setColor(Color.RED);
                    g2.drawOval(this.margem - 1, this.margem - 1, this.diametro + 1, this.diametro + 1);
                }
            } else if (this.forma == formas.QUADRADO) {
                g2.fillRect(this.margem, this.margem, this.diametro, this.diametro);
                if (this.selecionado) {
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.setColor(Color.RED);
                    g2.drawRect(this.margem + 1, this.margem + 1, this.diametro - 2, this.diametro - 2);
                }
            }
        }

        public boolean isVazio() {
            return this.valor == null;
        }

        public J getValor() {
            return this.valor;
        }

        public void setValor(J valor) {
            this.valor = valor;
            if (valor instanceof Tubo) {
                String msg = "<html><center>Req.: " + ((Tubo)valor).getCodigoRequisicaoEtiqueta();
                msg = msg + (JTabuleiro.this.podeMarcar ? "<br>Clique para marcar o tubo" : "");
                this.setToolTipText(msg);
            }
            this.repaint();
        }

        public void removeValor() {
            this.valor = null;
            this.repaint();
        }

        public void setDiametro(int diametro) {
            this.diametro = diametro;
            this.atualizaDimensaoComponente();
        }

        private void atualizaDimensaoComponente() {
            int diametroTotal = this.diametro + this.margem * 2;
            this.setFocusable(true);
            this.setMinimumSize(new Dimension(diametroTotal, diametroTotal));
            this.setPreferredSize(new Dimension(diametroTotal, diametroTotal));
        }
    }

    public static enum formas {
        CIRCULO,
        QUADRADO;

    }
}

