/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.impressao.ImprimirIdentificacaoEstante;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.bean.cadastro.triagem.GeladeiraBean;
import jalis.model.bean.cadastro.triagem.GeladeiraPrateleiraBean;
import jalis.model.vo.cadastro.triagem.EstanteVO;
import jalis.model.vo.cadastro.triagem.GeladeiraPrateleiraVO;
import jalis.model.vo.cadastro.triagem.GeladeiraVO;
import jalis.service.cadastro.triagem.EstanteService;
import jalis.service.cadastro.triagem.GeladeiraService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransferenciaEstantes
extends FrmCadPadraoBean {
    private JButton buttonEstante = new JButton();
    private JButton buttonNovaGeladeira = new JButton();
    private JComboBox comboNovaPrateleira = new JComboBox();
    private JLabel labelAux = new JLabel();
    private JLabel labelAux2 = new JLabel();
    private JLabel labelAux3 = new JLabel();
    private JLabel labelCodGeladeira = new JLabel();
    private JLabel labelDescEstante = new JLabel();
    private JLabel labelDescGeladeira = new JLabel();
    private JLabel labelDescNovaGeladeira = new JLabel();
    private JLabel labelDescPrateleira = new JLabel();
    private JLabel labelEstante = new JLabel();
    private JLabel labelGeladeira = new JLabel();
    private JLabel labelNovaGeladeira = new JLabel();
    private JLabel labelNovaPrateleira = new JLabel();
    private JLabel labelPrateleira = new JLabel();
    private JLabel labelIdentificacaoEstante = new JLabel();
    private JPanel panelNovaPosicao = new JPanel(new GridBagLayout());
    private JPanel panelIdentificacaoEstante = new JPanel(new GridBagLayout());
    private TTextField textIdentificacaoEstante = new TTextField(ImprimirIdentificacaoEstante.getDigitosEstanteFilial() + ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira() + ImprimirIdentificacaoEstante.getDigitosEstanteCodigo(), 1);
    private TTextField textEstante = new TTextField(5, 1);
    private TTextField textNovaGeladeira = new TTextField(5, 1);
    private EstanteBean estante = null;
    private GeladeiraBean geladeira = null;

    public TransferenciaEstantes() {
        this.setLabelFormulario("Transfer\u00eancia de Estantes");
        this.setLabelDescricao("Transfer\u00eancia de estantes entre geladeiras e prateleiras");
        this.setIcone(ImagemUtils.carregaImagemJalis("triagem/transferencia_estantes.jpg"));
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.buttonEstante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstanteBean estanteAux = TransferenciaEstantes.this.pesquisaEstantes(null);
                if (estanteAux != null) {
                    TransferenciaEstantes.this.estante = estanteAux;
                    TransferenciaEstantes.this.preencherCampos(TransferenciaEstantes.this.estante);
                    TransferenciaEstantes.this.controlaCampos();
                    if (TransferenciaEstantes.this.textNovaGeladeira.isFocusable() && TransferenciaEstantes.this.textNovaGeladeira.isEnabled()) {
                        ScreenUtil.requisitarFoco(TransferenciaEstantes.this.textNovaGeladeira);
                    }
                }
            }
        });
        this.textIdentificacaoEstante.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEstantes.this.textIdentificacaoEstante)) {
                    int digCodigo;
                    int digGeladeira;
                    int digFilial = ImprimirIdentificacaoEstante.getDigitosEstanteFilial();
                    int digTotal = digFilial + (digGeladeira = ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira()) + (digCodigo = ImprimirIdentificacaoEstante.getDigitosEstanteCodigo());
                    if (digTotal == TransferenciaEstantes.this.textIdentificacaoEstante.getText().length()) {
                        int filial = Integer.valueOf(TransferenciaEstantes.this.textIdentificacaoEstante.getText().substring(0, digFilial));
                        String codEstante = TransferenciaEstantes.this.textIdentificacaoEstante.getText().substring(digFilial + digGeladeira);
                        if (filial != Integer.parseInt(Variaveis.filialPadrao)) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel carregar os dados de uma estante de outra filial.", 2);
                            return;
                        }
                        EstanteBean estanteAux = TransferenciaEstantes.this.pesquisaEstantes(codEstante);
                        if (estanteAux != null) {
                            TransferenciaEstantes.this.estante = estanteAux;
                            TransferenciaEstantes.this.preencherCampos(TransferenciaEstantes.this.estante);
                            TransferenciaEstantes.this.controlaCampos();
                            if (TransferenciaEstantes.this.textNovaGeladeira.isFocusable() && TransferenciaEstantes.this.textNovaGeladeira.isEnabled()) {
                                ScreenUtil.requisitarFoco(TransferenciaEstantes.this.textNovaGeladeira);
                            }
                        } else {
                            TransferenciaEstantes.this.labelDescEstante.setText("N\u00e3o cadastrado");
                        }
                    } else {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "A identifica\u00e7\u00e3o da estante \u00e9 inv\u00e1lida.", 2);
                        return;
                    }
                }
            }
        });
        this.textEstante.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEstantes.this.textEstante.getText())) {
                    EstanteBean estanteAux = TransferenciaEstantes.this.pesquisaEstantes(TransferenciaEstantes.this.textEstante.getText());
                    if (estanteAux != null) {
                        TransferenciaEstantes.this.estante = estanteAux;
                        TransferenciaEstantes.this.preencherCampos(TransferenciaEstantes.this.estante);
                        TransferenciaEstantes.this.controlaCampos();
                        if (TransferenciaEstantes.this.textNovaGeladeira.isFocusable() && TransferenciaEstantes.this.textNovaGeladeira.isEnabled()) {
                            ScreenUtil.requisitarFoco(TransferenciaEstantes.this.textNovaGeladeira);
                        }
                    } else {
                        TransferenciaEstantes.this.labelDescEstante.setText("N\u00e3o cadastrado");
                    }
                }
            }
        });
        this.textEstante.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEstantes.this.buttonEstante.doClick();
                }
            }
        });
        this.textNovaGeladeira.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEstantes.this.textNovaGeladeira.getText())) {
                    GeladeiraBean geladeiraAux = TransferenciaEstantes.this.pesquisaGeladeiras(TransferenciaEstantes.this.textNovaGeladeira.getText());
                    if (geladeiraAux != null) {
                        TransferenciaEstantes.this.geladeira = geladeiraAux;
                        TransferenciaEstantes.this.preencherDadosGeladeira(TransferenciaEstantes.this.geladeira);
                        TransferenciaEstantes.this.controlaCampos();
                        if (TransferenciaEstantes.this.comboNovaPrateleira.isFocusable() && TransferenciaEstantes.this.comboNovaPrateleira.isEnabled()) {
                            ScreenUtil.requisitarFoco(TransferenciaEstantes.this.comboNovaPrateleira);
                        }
                    } else {
                        TransferenciaEstantes.this.labelDescNovaGeladeira.setText("N\u00e3o cadastrado");
                    }
                }
            }
        });
        this.textNovaGeladeira.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEstantes.this.buttonNovaGeladeira.doClick();
                }
            }
        });
        this.buttonNovaGeladeira.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeladeiraBean geladeiraAux = TransferenciaEstantes.this.pesquisaGeladeiras(null);
                if (geladeiraAux != null) {
                    TransferenciaEstantes.this.geladeira = geladeiraAux;
                    TransferenciaEstantes.this.preencherDadosGeladeira(TransferenciaEstantes.this.geladeira);
                    TransferenciaEstantes.this.controlaCampos();
                    if (TransferenciaEstantes.this.comboNovaPrateleira.isFocusable() && TransferenciaEstantes.this.comboNovaPrateleira.isEnabled()) {
                        ScreenUtil.requisitarFoco(TransferenciaEstantes.this.comboNovaPrateleira);
                    }
                }
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.labelIdentificacaoEstante.setText("Identifica\u00e7\u00e3o Estante:");
        this.panelIdentificacaoEstante.add((Component)this.labelIdentificacaoEstante, c);
        ++c.gridx;
        this.textIdentificacaoEstante.setPreferredSize(new Dimension(90, 20));
        this.textIdentificacaoEstante.setMinimumSize(new Dimension(90, 20));
        this.panelIdentificacaoEstante.add((Component)this.textIdentificacaoEstante, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelIdentificacaoEstante.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 6;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.panelIdentificacaoEstante, c);
        this.labelEstante.setText("Estante:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.labelEstante, c);
        this.textEstante.setMinimumSize(new Dimension(60, 20));
        this.textEstante.setPreferredSize(new Dimension(60, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.textEstante, c);
        this.buttonEstante.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstante);
        this.buttonEstante.setMinimumSize(new Dimension(20, 20));
        this.buttonEstante.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.buttonEstante, c);
        this.labelDescEstante.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescEstante.setMinimumSize(new Dimension(20, 20));
        this.labelDescEstante.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 3;
        c.gridwidth = 4;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.labelDescEstante, c);
        this.labelGeladeira.setText("Geladeira:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        this.painelCentral.add((Component)this.labelGeladeira, c);
        this.labelCodGeladeira.setBorder(BorderFactory.createTitledBorder(""));
        this.labelCodGeladeira.setMinimumSize(new Dimension(20, 20));
        this.labelCodGeladeira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 17;
        this.painelCentral.add((Component)this.labelCodGeladeira, c);
        this.labelDescGeladeira.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescGeladeira.setMinimumSize(new Dimension(20, 20));
        this.labelDescGeladeira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.labelDescGeladeira, c);
        this.labelPrateleira.setText("Prateleira:");
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 2;
        c.anchor = 17;
        this.painelCentral.add((Component)this.labelPrateleira, c);
        this.labelDescPrateleira.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescPrateleira.setMinimumSize(new Dimension(20, 20));
        this.labelDescPrateleira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.labelDescPrateleira, c);
        this.labelAux.setMinimumSize(new Dimension(20, 20));
        this.labelAux.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 2;
        this.painelCentral.add((Component)this.labelAux, c);
        this.panelNovaPosicao.setBorder(BorderFactory.createTitledBorder("Nova Posi\u00e7\u00e3o"));
        this.panelNovaPosicao.setLayout(new GridBagLayout());
        this.labelNovaGeladeira.setText("Geladeira:");
        c = new GridBagConstraints();
        c.anchor = 17;
        this.panelNovaPosicao.add((Component)this.labelNovaGeladeira, c);
        this.textNovaGeladeira.setMinimumSize(new Dimension(70, 20));
        this.textNovaGeladeira.setPreferredSize(new Dimension(70, 20));
        c = new GridBagConstraints();
        c.anchor = 17;
        this.panelNovaPosicao.add((Component)this.textNovaGeladeira, c);
        this.buttonNovaGeladeira.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonNovaGeladeira);
        this.buttonNovaGeladeira.setMinimumSize(new Dimension(20, 20));
        this.buttonNovaGeladeira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.anchor = 17;
        this.panelNovaPosicao.add((Component)this.buttonNovaGeladeira, c);
        this.labelDescNovaGeladeira.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescNovaGeladeira.setMinimumSize(new Dimension(20, 20));
        this.labelDescNovaGeladeira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.panelNovaPosicao.add((Component)this.labelDescNovaGeladeira, c);
        this.labelAux2.setMinimumSize(new Dimension(20, 20));
        this.labelAux2.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.anchor = 17;
        this.panelNovaPosicao.add((Component)this.labelAux2, c);
        this.labelNovaPrateleira.setText("Prateleira:");
        c = new GridBagConstraints();
        c.anchor = 17;
        this.panelNovaPosicao.add((Component)this.labelNovaPrateleira, c);
        this.comboNovaPrateleira.setMinimumSize(new Dimension(80, 20));
        this.comboNovaPrateleira.setPreferredSize(new Dimension(80, 20));
        c = new GridBagConstraints();
        c.anchor = 17;
        this.panelNovaPosicao.add((Component)this.comboNovaPrateleira, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 7;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 0, 0, 0);
        this.painelCentral.add((Component)this.panelNovaPosicao, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 7;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.painelCentral.add((Component)this.labelAux3, c);
        this.controlaCampos();
    }

    private EstanteBean pesquisaEstantes(String codigoEstante) {
        EstanteVO estanteAux = new EstanteVO();
        try {
            if (codigoEstante == null) {
                ArrayList<String> filtros = new ArrayList<String>();
                filtros.add(" gel_codigo is not null ");
                filtros.add(" gpa_codigo is not null ");
                estanteAux = (EstanteVO)new EstanteService().pesquisaVO(Laboratorio.getInstancia(), estanteAux, "Pesquisando Estantes", false, filtros);
                if (estanteAux != null) {
                    return (EstanteBean)new EstanteService().get(Variaveis.filialPadrao, estanteAux.getCodigo().toString());
                }
                return null;
            }
            EstanteBean bean = (EstanteBean)new EstanteService().get(Variaveis.filialPadrao, codigoEstante);
            if (bean == null || bean.getGeladeira() == null || bean.getPrateleira() == null) {
                return null;
            }
            return (EstanteBean)new EstanteService().get(Variaveis.filialPadrao, codigoEstante);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da estante.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private GeladeiraBean pesquisaGeladeiras(String codigoGeladeira) {
        GeladeiraVO geladeiraAux = new GeladeiraVO();
        try {
            if (codigoGeladeira == null) {
                geladeiraAux = (GeladeiraVO)new GeladeiraService().pesquisaAtivasVO(Laboratorio.getInstancia(), geladeiraAux, "Pesquisando Geladeiras", false);
                if (geladeiraAux != null) {
                    return (GeladeiraBean)new GeladeiraService().get(Variaveis.filialPadrao, geladeiraAux.getCodigo().toString(), false);
                }
                return null;
            }
            return (GeladeiraBean)new GeladeiraService().get(Variaveis.filialPadrao, codigoGeladeira, false);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da geladeira.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    @Override
    protected void controlaCampos() {
        boolean habilita = this.getStatus() == 2;
        this.textEstante.setEnabled(habilita && this.estante == null);
        this.buttonEstante.setEnabled(habilita && this.estante == null);
        this.textNovaGeladeira.setEnabled(habilita && this.estante != null);
        this.buttonNovaGeladeira.setEnabled(habilita && this.estante != null);
        this.textNovaGeladeira.setEnabled(habilita && this.estante != null);
        this.comboNovaPrateleira.setEnabled(habilita && this.estante != null && this.geladeira != null);
        this.textIdentificacaoEstante.setEnabled(habilita && this.estante == null);
    }

    @Override
    protected void limparCampos() {
        this.textEstante.clear();
        this.labelDescEstante.setText("");
        this.labelCodGeladeira.setText("");
        this.labelDescGeladeira.setText("");
        this.labelDescPrateleira.setText("");
        this.textNovaGeladeira.clear();
        this.labelDescNovaGeladeira.setText("");
        this.comboNovaPrateleira.removeAllItems();
        this.textIdentificacaoEstante.clear();
        this.estante = null;
        this.geladeira = null;
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textIdentificacaoEstante);
        this.setStatus(2);
    }

    @Override
    public void salvar() {
        EstanteBean bean;
        EstanteService service = new EstanteService();
        if (this.validaCampos() && (bean = (EstanteBean)this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                int resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja imprimir a nova identifica\u00e7\u00e3o da estante?", 4, true);
                if (resp == 0 && this.estante != null) {
                    try {
                        ImprimirIdentificacaoEstante.imprimir(Variaveis.filialPadrao, bean.getCodigo().toString());
                    }
                    catch (SQLException e1) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir a identifica\u00e7\u00e3o da estante.\n" + e1.getMessage(), 2);
                    }
                }
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel transferir a estante.\n" + e.getMessage(), 2);
            }
        }
    }

    @Override
    public void cancelar() {
        super.cancelar();
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (this.estante == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A estante n\u00e3o foi selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textEstante);
            return false;
        }
        if (this.geladeira == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A nova geladeira n\u00e3o foi selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textNovaGeladeira);
            return false;
        }
        if (this.comboNovaPrateleira.getSelectedIndex() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A nova prateleira n\u00e3o foi selecionada.", 2);
            ScreenUtil.requisitarFoco(this.comboNovaPrateleira);
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0300900300");
    }

    @Override
    @Deprecated
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        if (this.estante != null) {
            this.estante.setGeladeira((GeladeiraVO)this.geladeira.toVO());
            this.estante.setPrateleira((GeladeiraPrateleiraVO)((GeladeiraPrateleiraBean)this.comboNovaPrateleira.getSelectedItem()).toVO());
            return this.estante;
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean == null || !(bean instanceof EstanteBean)) {
            return;
        }
        EstanteBean estBean = (EstanteBean)bean;
        this.textEstante.setText(estBean.getCodigo().toString());
        this.labelDescEstante.setText(estBean.getIdentificador());
        this.labelCodGeladeira.setText(estBean.getGeladeira().getCodigo().toString());
        this.labelDescGeladeira.setText(estBean.getGeladeira().getDescricao());
        this.labelDescPrateleira.setText(estBean.getPrateleira().getCodigo().toString());
        int digFilial = ImprimirIdentificacaoEstante.getDigitosEstanteFilial();
        int digGeladeira = ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira();
        int digCodigo = ImprimirIdentificacaoEstante.getDigitosEstanteCodigo();
        String filial = Variaveis.filialPadrao;
        String geladeira = String.valueOf(estBean.getGeladeira().getCodigo());
        String estante = String.valueOf(estBean.getCodigo());
        filial = StringUtil.preencheString(filial, digFilial, '0', 1);
        geladeira = StringUtil.preencheString(geladeira, digGeladeira, '0', 1);
        estante = StringUtil.preencheString(estante, digCodigo, '0', 1);
        this.textIdentificacaoEstante.setText(filial + geladeira + estante);
    }

    private void preencherDadosGeladeira(GeladeiraBean bean) {
        if (bean == null || !(bean instanceof GeladeiraBean)) {
            return;
        }
        this.textNovaGeladeira.setText(bean.getCodigo().toString());
        this.labelDescNovaGeladeira.setText(bean.getDescricao());
        this.comboNovaPrateleira.removeAllItems();
        if (bean.getPrateleiras() != null && bean.getPrateleiras().size() > 0) {
            ArrayList<GeladeiraPrateleiraBean> prateleiras = bean.getPrateleiras();
            for (int i = 0; i < prateleiras.size(); ++i) {
                this.comboNovaPrateleira.addItem(prateleiras.get(i));
            }
        }
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

