/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca;

import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboContainer;
import jalis.laboratorio.triagem.soroteca.util.TuboContainerJList;
import jalis.laboratorio.triagem.soroteca.util.TuboContainerJTabuleiro;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.vo.cadastro.triagem.GeladeiraVO;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

class SorotecaBasica
extends JPanel {
    private final JLabel labelFilial = new JLabel("Filial:");
    private final JLabel labelCodigoFilial = new JLabel();
    private final JLabel labelGeladeira = new JLabel("Geladeira:");
    private final JLabel labelCodigoGeladeira = new JLabel();
    private final JLabel labelDescricaoGeladeira = new JLabel();
    private final JLabel labelPrateleira = new JLabel("Prateleira:");
    private final JLabel labelCodigoPrateleira = new JLabel();
    private final JLabel labelEstante = new JLabel("Estante:");
    private final JLabel labelCodigoEstante = new JLabel();
    private final JLabel labelDescricaoEstante = new JLabel();
    private final JLabel labelSetor = new JLabel("Setor:");
    private final JLabel labelCodigoSetor = new JLabel();
    private final JLabel labelDescricaoSetor = new JLabel();
    private JScrollPane scrollEstante = null;
    private JPanel panelEstante = null;
    TuboContainer tuboContainer = null;

    public SorotecaBasica() {
        this.desenha();
    }

    public void limpar() {
        this.labelCodigoGeladeira.setText("");
        this.labelDescricaoGeladeira.setText("");
        this.labelCodigoPrateleira.setText("");
        this.labelCodigoEstante.setText("");
        this.labelDescricaoEstante.setText("");
        this.labelCodigoFilial.setText("");
        this.labelCodigoSetor.setText("");
        this.labelDescricaoSetor.setText("");
        this.panelEstante.removeAll();
        this.panelEstante.repaint();
    }

    private void desenha() {
        this.setLayout(new GridBagLayout());
        ScreenUtil.setBorda(new JLabel[]{this.labelCodigoFilial, this.labelCodigoGeladeira, this.labelDescricaoGeladeira, this.labelCodigoPrateleira, this.labelCodigoEstante, this.labelDescricaoEstante, this.labelCodigoSetor, this.labelDescricaoSetor}, new TitledBorder(""));
        Dimension d = new Dimension(50, 20);
        this.labelCodigoGeladeira.setMinimumSize(d);
        this.labelCodigoGeladeira.setPreferredSize(d);
        this.labelCodigoGeladeira.setHorizontalAlignment(4);
        this.labelCodigoEstante.setMinimumSize(d);
        this.labelCodigoEstante.setPreferredSize(d);
        this.labelCodigoEstante.setHorizontalAlignment(4);
        d = new Dimension(70, 20);
        this.labelCodigoPrateleira.setMinimumSize(d);
        this.labelCodigoPrateleira.setPreferredSize(d);
        this.labelCodigoFilial.setMaximumSize(d);
        this.labelCodigoFilial.setPreferredSize(d);
        this.labelCodigoSetor.setMinimumSize(d);
        this.labelCodigoSetor.setPreferredSize(d);
        this.labelCodigoSetor.setHorizontalAlignment(4);
        d = new Dimension(20, 20);
        this.labelDescricaoGeladeira.setMinimumSize(d);
        this.labelDescricaoGeladeira.setPreferredSize(d);
        this.labelDescricaoEstante.setMinimumSize(d);
        this.labelDescricaoEstante.setPreferredSize(d);
        this.labelDescricaoSetor.setMinimumSize(d);
        this.labelDescricaoSetor.setPreferredSize(d);
        this.panelEstante = new JPanel(new BorderLayout());
        this.scrollEstante = new JScrollPane(this.panelEstante);
        this.scrollEstante.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 0);
        this.add((Component)this.labelFilial, c);
        c.gridwidth = 2;
        ++c.gridx;
        this.add((Component)this.labelCodigoFilial, c);
        c.gridwidth = 1;
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 0);
        this.add((Component)this.labelGeladeira, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.add((Component)this.labelCodigoGeladeira, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 0, 1, 1);
        ++c.gridx;
        this.add((Component)this.labelDescricaoGeladeira, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 0);
        this.add((Component)this.labelPrateleira, c);
        c.gridwidth = 2;
        ++c.gridx;
        this.add((Component)this.labelCodigoPrateleira, c);
        c.gridwidth = 1;
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 0);
        this.add((Component)this.labelEstante, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.add((Component)this.labelCodigoEstante, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 0, 1, 1);
        ++c.gridx;
        this.add((Component)this.labelDescricaoEstante, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 0);
        this.add((Component)this.labelSetor, c);
        c.gridwidth = 2;
        ++c.gridx;
        this.add((Component)this.labelCodigoSetor, c);
        c.gridx += 2;
        c.gridwidth = 3;
        c.fill = 2;
        this.add((Component)this.labelDescricaoSetor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 10;
        this.add((Component)this.scrollEstante, c);
    }

    public void setTubo(Tubo tuboSelecionado, List<Tubo> listaTubos) {
        this.limpar();
        if (tuboSelecionado != null && listaTubos != null && listaTubos.size() > 0) {
            GeladeiraVO geladeira = tuboSelecionado.getEstante().getPrateleira().getGeladeira();
            this.labelCodigoGeladeira.setText(geladeira.getCodigo().toString());
            this.labelDescricaoGeladeira.setText(geladeira.getDescricao());
            String prateleira = tuboSelecionado.getEstante().getPrateleira().getCodigo();
            this.labelCodigoPrateleira.setText(prateleira);
            EstanteBean estante = tuboSelecionado.getEstante();
            this.labelCodigoEstante.setText(estante.getCodigo().toString());
            this.labelDescricaoEstante.setText(estante.getIdentificador());
            this.labelCodigoFilial.setText(String.valueOf(tuboSelecionado.getFilial().getCodigo()));
            this.labelCodigoSetor.setText(tuboSelecionado.getSetor().getCodigo().toString());
            this.labelDescricaoSetor.setText(tuboSelecionado.getSetor().getDescricao());
            if (estante.isPacote().booleanValue()) {
                this.tuboContainer = new TuboContainerJList(false, true);
            } else {
                this.tuboContainer = new TuboContainerJTabuleiro(estante.getLinhas(), estante.getColunas(), this.panelEstante, false, true);
                ((TuboContainerJTabuleiro)this.tuboContainer).setBarraDetalhesVisivel(false);
            }
            if (this.panelEstante != null) {
                this.panelEstante.add(this.tuboContainer.getUI());
                this.panelEstante.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        if (SorotecaBasica.this.tuboContainer instanceof TuboContainerJTabuleiro) {
                            ((TuboContainerJTabuleiro)SorotecaBasica.this.tuboContainer).atualizaDiametroTubos(SorotecaBasica.this.panelEstante);
                        }
                    }

                    @Override
                    @Deprecated
                    public void componentShown(ComponentEvent e) {
                    }

                    @Override
                    @Deprecated
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    @Deprecated
                    public void componentHidden(ComponentEvent e) {
                    }
                });
            }
            for (int i = 0; i < listaTubos.size(); ++i) {
                Tubo tuboAux = listaTubos.get(i);
                if (tuboAux == null || tuboAux.getEstante().getCodigo().intValue() != estante.getCodigo().intValue() || !tuboAux.getEstante().getPrateleira().getCodigo().equalsIgnoreCase(prateleira) || tuboAux.getEstante().getPrateleira().getGeladeira().getCodigo().intValue() != geladeira.getCodigo().intValue()) continue;
                this.tuboContainer.addTubo(tuboAux, false);
            }
            this.tuboContainer.selecionarTuboEtiquetaRepetida(tuboSelecionado);
        }
    }
}

