/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.soroteca.jtabuleiro.JTabuleiro;
import jalis.laboratorio.triagem.soroteca.util.Exame;
import jalis.laboratorio.triagem.soroteca.util.ExameRecipiente;
import jalis.laboratorio.triagem.soroteca.util.Informacoes;
import jalis.laboratorio.triagem.soroteca.util.Posicao;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboContainer;
import jalis.laboratorio.triagem.soroteca.util.TuboContainerJList;
import jalis.laboratorio.triagem.soroteca.util.TuboContainerJTabuleiro;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirIdentificacaoEstante;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.bean.cadastro.triagem.GeladeiraBean;
import jalis.model.bean.cadastro.triagem.GeladeiraPrateleiraBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.cadastro.triagem.EstanteVO;
import jalis.model.vo.cadastro.triagem.GeladeiraPrateleiraVO;
import jalis.model.vo.cadastro.triagem.GeladeiraVO;
import jalis.service.cadastro.triagem.EstanteService;
import jalis.service.cadastro.triagem.GeladeiraService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class Soroteca
extends FrmCadPadraoBean {
    private final JLabel labelGeladeira = new JLabel("Geladeira:");
    private final JLabel labelPrateleira = new JLabel("Prateleira:");
    private final JLabel labelEstante = new JLabel("Estante:");
    private final JLabel labelEstanteId = new JLabel();
    private final JLabel labelVlrEtiqueta = new JLabel();
    private final JLabel labelVlrTubo = new JLabel();
    private final JLabel labelVlrRequisicao = new JLabel();
    private final JLabel labelVlrPaciente = new JLabel();
    private final JLabel labelErroLocalizar = new JLabel();
    private final JLabel labelDescricaoGeladeira = new JLabel();
    private final JLabel labelIdentificacaoEstante = new JLabel("Identifica\u00e7\u00e3o da Estante:");
    private final TTextField textCodigoGeladeira = new TTextField(5, 1);
    private final TTextField textCodigoEstante = new TTextField(5, 1);
    private final TTextField textEtiqueta = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private final TTextField textLocalizarTubo = new TTextField(12, 1);
    private final TTextField textIdentificacaoEstante = new TTextField(ImprimirIdentificacaoEstante.getDigitosEstanteFilial() + ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira() + ImprimirIdentificacaoEstante.getDigitosEstanteCodigo(), 1);
    private final JButton buttonBuscaGeladeira = new JButton();
    private final JButton buttonBuscaEstante = new JButton();
    private final JButton buttonRemoverTodos = new JButton("Remover Todos os Tubos");
    private final JButton buttonImprimir = new JButton("Imprimir \u25bc");
    private final JPopupMenu menuImprimir = new JPopupMenu();
    private final JMenuItem itemImprimirIdentificacaoEstante = new JMenuItem("Identifica\u00e7\u00e3o da estante", 101);
    private final JMenuItem itemImprimirIdentificacaoTubo = new JMenuItem("Identifica\u00e7\u00e3o dos tubos selecionados", 116);
    private final JComboBox comboBoxPrateleira = new JComboBox();
    private final JPanel panelIdentificacaoEstante = new JPanel(new GridBagLayout());
    private final JPanel panelTopo = new JPanel(new GridBagLayout());
    private final JPanel panelAdicionar = new JPanel(new GridBagLayout());
    private final JPanel panelInfoTubo = new JPanel(new BorderLayout());
    private final JPanel panelInfoConservacao = new JPanel(new GridBagLayout());
    private final JPanel panelEstante = new JPanel(new BorderLayout());
    private final JPanel panelLocalizarTubo = new JPanel(new GridBagLayout());
    private final JPanel panelLegenda = new JPanel();
    private final JCheckBox checkAuto = new JCheckBox("Adicionar automaticamente", true);
    private static JCheckBox checkImprimirIdentificacao = new JCheckBox("Imprimir identifica\u00e7\u00e3o", true);
    private static JCheckBox checkIgnorarMensagemResultado = new JCheckBox("Ignorar mensagens de situa\u00e7\u00e3o do exame", true);
    private JSplitPane splitPanel = null;
    private TuboContainer tuboContainer = null;
    private Informacoes info = null;
    private final GeladeiraService geladeiraService = new GeladeiraService();
    private final EstanteService estanteService = new EstanteService();
    private GeladeiraBean geladeiraSelecionada;
    private GeladeiraPrateleiraBean prateleiraSelecionada;
    private static EstanteBean estanteSelecionada;
    public static final String PARAMETROS_SOROTECA = "Soroteca.ultimoFiltro";
    private static final String PARAMETRO_AUTOMATICO = "automatico";
    private static final String PARAMETRO_IMPRIMIR_IDENT_TUBOS = "imprimir_ident_tubos";
    private static final String PARAMETRO_IGNORAR_MENSAGEM = "ignorarMensagens";
    private boolean isVazia = true;

    public Soroteca() {
        this.desenha();
        this.menuImprimir.add(this.itemImprimirIdentificacaoEstante);
        this.menuImprimir.add(this.itemImprimirIdentificacaoTubo);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.buttonImprimir.setMnemonic('I');
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        panelEsquerda.add(this.buttonImprimir);
        panelEsquerda.add(this.buttonRemoverTodos);
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        panelDireita.add(this.botaoNovo);
        panelDireita.add(this.botaoSalvar);
        panelDireita.add(this.botaoCancelar);
        panelDireita.add(this.botaoFechar);
        this.painelBotoes.add((Component)panelEsquerda, "West");
        this.painelBotoes.add((Component)panelDireita, "East");
        this.definirTeclaAtalho();
        this.instalaListeners();
        this.controlaCampos(false);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_SOROTECA);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, PARAMETRO_AUTOMATICO);
            if (!Funcoes.textoVazio(tmp)) {
                this.checkAuto.setSelected(tmp.equalsIgnoreCase("true"));
            } else {
                this.checkAuto.setSelected(false);
            }
            tmp = StringUtil.getValor(parametros, PARAMETRO_IMPRIMIR_IDENT_TUBOS);
            if (!Funcoes.textoVazio(tmp)) {
                checkImprimirIdentificacao.setSelected(tmp.equalsIgnoreCase("true"));
            } else {
                checkImprimirIdentificacao.setSelected(false);
            }
            tmp = StringUtil.getValor(parametros, PARAMETRO_IGNORAR_MENSAGEM);
            if (!Funcoes.textoVazio(tmp)) {
                checkIgnorarMensagemResultado.setSelected(tmp.equalsIgnoreCase("true"));
            } else {
                checkIgnorarMensagemResultado.setSelected(false);
            }
        }
        this.textEtiqueta.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.textLocalizarTubo.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void definirTeclaAtalho() {
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao infReq = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                if (null != Soroteca.this.tuboContainer.getTubosSelecionados() && Soroteca.this.tuboContainer.getTubosSelecionados().size() > 0) {
                    Tubo tuboSelecionado = Soroteca.this.tuboContainer.getTubosSelecionados().get(0);
                    String filial = tuboSelecionado.getFilial().getCodigo().toString();
                    String codigo = tuboSelecionado.getCodigoRequisicaoEtiqueta().toString();
                    infReq.setRequisicao(filial, Integer.parseInt(codigo));
                }
                infReq.setVisible(true);
                Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
    }

    public static void montaPanelLegenda(JPanel pnlLegenda) {
        if (pnlLegenda == null) {
            pnlLegenda = new JPanel(new GridBagLayout());
        } else if (!(pnlLegenda.getLayout() instanceof GridBagLayout)) {
            pnlLegenda.setLayout(new GridBagLayout());
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_VAZIA);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Vazio");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_PREENCHIDA);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Tubo OK");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_PREENCHIDA_SEM_RESULTADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Tubo OK sem resultado");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_PREENCHIDA_VENCIDO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Tubo Vencido");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        pnlLegenda.add((Component)new JLabel(""), c);
    }

    private void instalaListeners() {
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Soroteca.this.controlaMenu();
                Soroteca.this.menuImprimir.show(Soroteca.this.buttonImprimir.getParent(), Soroteca.this.buttonImprimir.getX(), Soroteca.this.buttonImprimir.getY() + Soroteca.this.buttonImprimir.getHeight());
            }
        });
        this.itemImprimirIdentificacaoEstante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (estanteSelecionada != null) {
                    try {
                        ImprimirIdentificacaoEstante.imprimir(Variaveis.filialPadrao, estanteSelecionada.getCodigo().toString());
                    }
                    catch (SQLException e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir a identifica\u00e7\u00e3o da estante.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            }
        });
        this.itemImprimirIdentificacaoTubo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Tubo> listaTubos = null;
                if (Soroteca.this.tuboContainer != null && (listaTubos = Soroteca.this.tuboContainer.getTubosSelecionados()).size() > 0) {
                    try {
                        for (int i = 0; i < listaTubos.size(); ++i) {
                            Tubo aux = listaTubos.get(i);
                            Impressao.imprimirIdentificacaoTubo(Integer.parseInt(Variaveis.filialPadrao), aux.getFilial().getCodigo(), estanteSelecionada.getCodigo(), aux.getCodigoRequisicaoEtiqueta(), aux.getRecipienteFilho().getCodigo(), aux.getSetor().getCodigo(), estanteSelecionada.getGeladeira().getCodigo(), estanteSelecionada.getPrateleira().getCodigo(), aux.getDataHoraSoroteca(), aux.getDataRetiradaSoroteca());
                        }
                    }
                    catch (SQLException e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir a identifica\u00e7\u00e3o dos tubos.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            }
        });
        this.textCodigoGeladeira.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    Soroteca.this.buscaGeladeira(Soroteca.this.textCodigoGeladeira.getText());
                }
            }
        });
        this.buttonBuscaGeladeira.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Soroteca.this.buscaGeladeira();
            }
        });
        this.comboBoxPrateleira.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Soroteca.this.selecionaPrateleira();
            }
        });
        this.textCodigoEstante.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Soroteca.this.buscaEstante(Soroteca.this.textCodigoEstante.getText());
            }
        });
        this.buttonBuscaEstante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Soroteca.this.buscaEstante();
            }
        });
        this.textEtiqueta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.isConsumed() || e.getKeyChar() != '\n') {
                    return;
                }
                if (!Soroteca.this.textEtiqueta.getText().isEmpty()) {
                    Soroteca.this.buscaTubo(Soroteca.this.textEtiqueta.getText());
                    e.consume();
                }
            }
        });
        this.textIdentificacaoEstante.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.isConsumed() || e.getKeyChar() != '\n') {
                    return;
                }
                if (!Soroteca.this.textIdentificacaoEstante.getText().isEmpty()) {
                    Soroteca.this.buscaIdentificaoEstante(Soroteca.this.textIdentificacaoEstante.getText());
                }
            }
        });
    }

    private void imprimirIdentificacaoTubos(List<Tubo> listaTubos) {
        if (listaTubos == null || listaTubos.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < listaTubos.size(); ++i) {
                Tubo aux = listaTubos.get(i);
                Impressao.imprimirIdentificacaoTubo(Integer.parseInt(Variaveis.filialPadrao), aux.getFilial().getCodigo(), estanteSelecionada.getCodigo(), aux.getCodigoRequisicaoEtiqueta(), aux.getRecipienteFilho().getCodigo(), aux.getSetor().getCodigo(), estanteSelecionada.getGeladeira().getCodigo(), estanteSelecionada.getPrateleira().getCodigo(), aux.getDataHoraSoroteca(), aux.getDataRetiradaSoroteca());
            }
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel imprimir a identifica\u00e7\u00e3o dos tubos.\n" + e1.getMessage(), e1.getStackTrace());
        }
    }

    public static boolean isImprimirIdentificacaoTubos() {
        return checkImprimirIdentificacao.isSelected();
    }

    public static EstanteBean getEstante() {
        return estanteSelecionada;
    }

    private void desenha() {
        this.setLabelFormulario("Soroteca");
        this.setLabelDescricao("Cadastro de tubos nas estantes das geladeiras");
        this.setIcone(ImagemUtils.carregaImagemJalis("triagem/soroteca.jpg"));
        ScreenUtil.setBorda(new JLabel[]{this.labelVlrEtiqueta, this.labelVlrPaciente, this.labelVlrRequisicao, this.labelVlrTubo, this.labelEstanteId, this.labelDescricaoGeladeira}, new TitledBorder(""));
        this.painelCentral.setLayout(new GridBagLayout());
        Dimension d = new Dimension(100, 20);
        this.labelVlrEtiqueta.setMinimumSize(d);
        this.labelVlrEtiqueta.setPreferredSize(d);
        this.labelVlrPaciente.setMinimumSize(d);
        this.labelVlrPaciente.setPreferredSize(d);
        this.labelVlrRequisicao.setMinimumSize(d);
        this.labelVlrRequisicao.setPreferredSize(d);
        this.labelVlrTubo.setMinimumSize(d);
        this.labelVlrTubo.setPreferredSize(d);
        this.labelDescricaoGeladeira.setMinimumSize(d);
        this.labelDescricaoGeladeira.setPreferredSize(d);
        d = new Dimension(60, 20);
        this.textCodigoGeladeira.setPreferredSize(d);
        this.textCodigoGeladeira.setMinimumSize(d);
        this.buttonBuscaGeladeira.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonBuscaGeladeira.setPreferredSize(d);
        this.buttonBuscaGeladeira.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaGeladeira);
        d = new Dimension(80, 20);
        this.comboBoxPrateleira.setPreferredSize(d);
        this.comboBoxPrateleira.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.textCodigoEstante.setPreferredSize(d);
        this.textCodigoEstante.setMinimumSize(d);
        this.buttonBuscaEstante.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonBuscaEstante.setPreferredSize(d);
        this.buttonBuscaEstante.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaEstante);
        this.buttonRemoverTodos.setMnemonic('T');
        this.buttonRemoverTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Iterator<Tubo> itTubos = Soroteca.this.tuboContainer.getTubos().iterator();
                StringBuilder buf = new StringBuilder();
                while (itTubos.hasNext()) {
                    Tubo tubo = itTubos.next();
                    Iterator<Exame> it = tubo.getExames().iterator();
                    ArrayList<Exame> descricaoExamesSemResultado = new ArrayList<Exame>();
                    while (it.hasNext()) {
                        Exame exame = it.next();
                        if (!Funcoes.textoVazio(exame.getSituacao())) continue;
                        boolean podeAdicionarExame = true;
                        for (Exame ex : descricaoExamesSemResultado) {
                            if (!ex.getCodigo().equals(exame.getCodigo()) || ex.getCodigoMaterial() != exame.getCodigoMaterial()) continue;
                            podeAdicionarExame = false;
                            break;
                        }
                        if (!podeAdicionarExame) continue;
                        descricaoExamesSemResultado.add(exame);
                    }
                    if (descricaoExamesSemResultado.size() <= 0) continue;
                    if (buf.length() == 0) {
                        buf.append("H\u00e1 exames sem resultado:\n ");
                    }
                    for (int i = 0; i < descricaoExamesSemResultado.size(); ++i) {
                        buf.append("Etiqueta: <font color = red>\"").append(tubo.getEtiqueta());
                        if (Soroteca.this.tuboContainer.isNumeroPosicoesLimitado()) {
                            buf.append(" (").append((char)(65 + tubo.getLinhaSoroteca())).append(tubo.getColunaSoroteca() + 1).append(")");
                        }
                        buf.append(" - ");
                        buf.append(((Exame)descricaoExamesSemResultado.get(i)).getDescricao()).append("\"</font>\n");
                    }
                }
                int resp = Funcoes.mensagem(Laboratorio.getInstancia(), buf.toString() + "Deseja remover TODOS os tubos da estante?", 4);
                if (resp == 0) {
                    SplashMensagem janelaEspera = SplashMensagem.getInstancia(Soroteca.this);
                    janelaEspera.mostrar("Removendo tubos. Aguarde.");
                    Soroteca.this.tuboContainer.limparSelecao();
                    Soroteca.this.info.limpaInformacoes();
                    Soroteca.this.tuboContainer.removerTodosTubos();
                    Soroteca.this.controlaCampos(false);
                    janelaEspera.apagar();
                    Soroteca.this.textEtiqueta.grabFocus();
                }
            }
        });
        d = new Dimension(120, 20);
        this.labelEstanteId.setPreferredSize(d);
        this.labelEstanteId.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.textIdentificacaoEstante.setPreferredSize(d);
        this.textIdentificacaoEstante.setMinimumSize(d);
        d = new Dimension(150, 20);
        this.textEtiqueta.setPreferredSize(d);
        this.textEtiqueta.setMinimumSize(d);
        d = new Dimension(200, 20);
        this.textLocalizarTubo.setPreferredSize(d);
        this.textLocalizarTubo.setMinimumSize(d);
        this.textLocalizarTubo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Soroteca.this.textLocalizarTubo.getText().isEmpty()) {
                    Soroteca.this.labelErroLocalizar.setVisible(false);
                    Soroteca.this.textLocalizarTubo.setForeground(null);
                    Soroteca.this.tuboContainer.mostrarInformacoesTubo(null);
                    Soroteca.this.tuboContainer.limparSelecao();
                } else if (Soroteca.this.tuboContainer != null) {
                    ArrayList<Tubo> tubos = Soroteca.this.tuboContainer.localizarTubos(Soroteca.this.textLocalizarTubo.getText());
                    Soroteca.this.tuboContainer.mostrarInformacoesTubo(null);
                    Soroteca.this.tuboContainer.limparSelecao();
                    if (tubos != null) {
                        for (int i = 0; i < tubos.size(); ++i) {
                            Soroteca.this.tuboContainer.selecionarTubo(tubos.get(i), false);
                        }
                    }
                    if (tubos != null && tubos.size() == 1) {
                        Soroteca.this.tuboContainer.mostrarInformacoesTubo(tubos.get(0));
                    }
                    if (tubos == null || tubos.size() == 0) {
                        Soroteca.this.labelErroLocalizar.setVisible(true);
                        Soroteca.this.textLocalizarTubo.setForeground(Color.RED);
                    } else {
                        Soroteca.this.labelErroLocalizar.setVisible(false);
                        Soroteca.this.textLocalizarTubo.setForeground(null);
                    }
                }
            }
        });
        this.labelErroLocalizar.setForeground(Color.RED);
        this.labelErroLocalizar.setText("Etiqueta n\u00e3o localizada!");
        this.labelErroLocalizar.setFont(this.labelErroLocalizar.getFont().deriveFont(new Float(this.labelErroLocalizar.getFont().getSize() - 1).floatValue()));
        this.labelErroLocalizar.setVisible(false);
        this.panelInfoConservacao.setMinimumSize(new Dimension(150, 20));
        this.panelInfoConservacao.setPreferredSize(new Dimension(150, 20));
        this.panelEstante.setMinimumSize(new Dimension(100, 20));
        this.panelEstante.setPreferredSize(new Dimension(100, 20));
        this.splitPanel = new JSplitPane(1, this.panelEstante, this.panelInfoConservacao);
        this.splitPanel.setResizeWeight(1.0);
        this.checkAuto.setMnemonic('u');
        checkImprimirIdentificacao.setMnemonic('d');
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        JLabel labelLocalizar = new JLabel("Localizar (etiqueta):");
        labelLocalizar.setDisplayedMnemonic('L');
        labelLocalizar.setLabelFor(this.textLocalizarTubo);
        this.panelLocalizarTubo.add((Component)labelLocalizar, c);
        ++c.gridx;
        this.panelLocalizarTubo.add((Component)this.textLocalizarTubo, c);
        ++c.gridx;
        this.panelLocalizarTubo.add((Component)this.labelErroLocalizar, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelLocalizarTubo.add((Component)new JLabel(), c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        Soroteca.montaPanelLegenda(this.panelLegenda);
        this.panelLocalizarTubo.add((Component)this.panelLegenda, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 0, 0);
        this.panelIdentificacaoEstante.add((Component)this.labelIdentificacaoEstante, c);
        ++c.gridx;
        this.panelIdentificacaoEstante.add((Component)this.textIdentificacaoEstante, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        this.panelIdentificacaoEstante.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 5, 0);
        this.labelGeladeira.setLabelFor(this.textCodigoGeladeira);
        this.labelGeladeira.setDisplayedMnemonic('G');
        this.panelTopo.add((Component)this.labelGeladeira, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.textCodigoGeladeira, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.buttonBuscaGeladeira, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelTopo.add((Component)this.labelDescricaoGeladeira, c);
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridx;
        this.panelTopo.add((Component)this.getPanelVazio(), c);
        ++c.gridx;
        this.panelTopo.add((Component)this.labelPrateleira, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.comboBoxPrateleira, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.getPanelVazio(), c);
        ++c.gridx;
        this.panelTopo.add((Component)this.labelEstante, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.textCodigoEstante, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.buttonBuscaEstante, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 0, 5, 1);
        this.panelTopo.add((Component)this.labelEstanteId, c);
        this.panelInfoTubo.setBorder(BorderFactory.createTitledBorder("Informa\u00e7\u00f5es do Tubo"));
        this.panelInfoConservacao.setBorder(BorderFactory.createTitledBorder("Conserva\u00e7\u00e3o"));
        this.panelAdicionar.setBorder(BorderFactory.createTitledBorder("Adicionar Tubo"));
        this.panelEstante.setBorder(BorderFactory.createTitledBorder("Estante"));
        d = new Dimension(470, 200);
        this.panelEstante.setMinimumSize(d);
        d = new Dimension(470, 200);
        this.panelEstante.setPreferredSize(d);
        this.info = new Informacoes(this.panelInfoTubo, this.panelInfoConservacao, this.textEtiqueta, this);
        c = new GridBagConstraints();
        c.anchor = 1280;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel labelEtiqueta = new JLabel("Etiqueta:");
        labelEtiqueta.setDisplayedMnemonic('E');
        labelEtiqueta.setLabelFor(this.textEtiqueta);
        d = new Dimension(60, 20);
        labelEtiqueta.setPreferredSize(d);
        d = new Dimension(60, 20);
        labelEtiqueta.setMinimumSize(d);
        c.gridheight = 2;
        this.panelAdicionar.add((Component)labelEtiqueta, c);
        ++c.gridx;
        this.panelAdicionar.add((Component)this.textEtiqueta, c);
        ++c.gridx;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 5);
        this.checkAuto.setPreferredSize(new Dimension(200, 14));
        checkImprimirIdentificacao.setPreferredSize(new Dimension(200, 14));
        checkIgnorarMensagemResultado.setPreferredSize(new Dimension(320, 14));
        this.checkAuto.setMinimumSize(new Dimension(10, 14));
        checkImprimirIdentificacao.setMinimumSize(new Dimension(10, 14));
        checkIgnorarMensagemResultado.setMinimumSize(new Dimension(10, 14));
        this.panelAdicionar.add((Component)this.checkAuto, c);
        ++c.gridx;
        this.panelAdicionar.add((Component)checkImprimirIdentificacao, c);
        ++c.gridy;
        c.gridx = 2;
        c.gridwidth = 2;
        this.panelAdicionar.add((Component)checkIgnorarMensagemResultado, c);
        c.gridy = 0;
        c.gridx = 4;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelAdicionar.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.painelCentral.add((Component)this.panelIdentificacaoEstante, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelTopo, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelAdicionar, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelInfoTubo, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)this.splitPanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelLocalizarTubo, c);
    }

    private JPanel getPanelVazio() {
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(20, 20));
        panel.setPreferredSize(new Dimension(20, 20));
        return panel;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Soroteca.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0300900201"));
        this.setModuloEdita(Long.parseLong("0300900202"));
        this.setModuloApaga(Long.parseLong("0300900203"));
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoGeladeira.hasFocus()) {
            this.buscaGeladeira();
        } else if (this.textCodigoEstante.hasFocus()) {
            this.buscaEstante();
        }
    }

    private void buscaIdentificaoEstante(String identificacao) {
        String estante;
        int digCodigo;
        int digGeladeira;
        int digFilial = ImprimirIdentificacaoEstante.getDigitosEstanteFilial();
        int digTotal = digFilial + (digGeladeira = ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira()) + (digCodigo = ImprimirIdentificacaoEstante.getDigitosEstanteCodigo());
        if (digTotal == identificacao.length()) {
            int filial = Integer.valueOf(identificacao.substring(0, digFilial));
            String geladeira = identificacao.substring(digFilial, digFilial + digGeladeira);
            estante = identificacao.substring(digFilial + digGeladeira);
            if (filial != Integer.parseInt(Variaveis.filialPadrao)) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel carregar os dados de uma estante de outra filial.", 2);
                return;
            }
            EstanteBean aux = null;
            try {
                aux = (EstanteBean)this.estanteService.get(Variaveis.filialPadrao, estante);
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados da estante.\n" + e1.getMessage(), e1.getStackTrace());
                this.limparCampos();
                this.controlaCampos();
                ScreenUtil.requisitarFoco(this.textIdentificacaoEstante);
                return;
            }
            if (aux == null) {
                Funcoes.mensagem(this, "Estante n\u00e3o encontrada.", 2);
                this.limparCampos();
                this.controlaCampos();
                ScreenUtil.requisitarFoco(this.textIdentificacaoEstante);
                return;
            }
            if (aux != null && aux.getGeladeira() == null) {
                Funcoes.mensagem(this, "A estante n\u00e3o foi inserida em nenhuma geladeira.\nDescarte a etiqueta da estante e insira manualmente.", 2);
                this.limparCampos();
                this.controlaCampos();
                ScreenUtil.requisitarFoco(this.textCodigoGeladeira);
                return;
            }
            if (aux != null && aux.getGeladeira() != null && aux.getGeladeira().getCodigo() != Integer.parseInt(geladeira)) {
                Funcoes.mensagem(this, "A etiqueta informada est\u00e1 desatualizada.\nImprima a nova etiqueta da estante.", 2);
                this.limparCampos();
                this.controlaCampos();
                ScreenUtil.requisitarFoco(this.textIdentificacaoEstante);
                return;
            }
            this.textCodigoGeladeira.setText(geladeira);
            this.buscaGeladeira(geladeira);
            if (this.geladeiraSelecionada == null) {
                return;
            }
        } else {
            Funcoes.mensagem(this, "A identifica\u00e7\u00e3o da estante \u00e9 inv\u00e1lida.", 2);
            return;
        }
        this.textCodigoEstante.setText(estante);
        this.buscaEstante(estante);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < Soroteca.this.comboBoxPrateleira.getItemCount(); ++i) {
                    GeladeiraPrateleiraBean gelAux;
                    Object aux = Soroteca.this.comboBoxPrateleira.getItemAt(i);
                    if (aux == null || estanteSelecionada == null || estanteSelecionada.getPrateleira() == null || !(aux instanceof GeladeiraPrateleiraBean) || !(gelAux = (GeladeiraPrateleiraBean)aux).getCodigo().equalsIgnoreCase(estanteSelecionada.getPrateleira().getCodigo())) continue;
                    Soroteca.this.comboBoxPrateleira.setSelectedIndex(i);
                    Soroteca.this.prateleiraSelecionada = (GeladeiraPrateleiraBean)Soroteca.this.comboBoxPrateleira.getItemAt(i);
                    break;
                }
                Soroteca.this.textEtiqueta.grabFocus();
                Soroteca.this.controlaCampos(false);
            }
        });
    }

    @Override
    @Deprecated
    public void controlaCampos() {
        this.controlaCampos(false);
    }

    public void controlaCampos(boolean isAdicionando) {
        boolean habilita = this.getStatus() == 3 || this.getStatus() == 2;
        this.textIdentificacaoEstante.setEnabled(habilita && estanteSelecionada == null && this.geladeiraSelecionada == null && this.prateleiraSelecionada == null);
        this.textCodigoGeladeira.setEnabled(habilita && estanteSelecionada == null);
        this.buttonBuscaGeladeira.setEnabled(habilita && estanteSelecionada == null);
        this.comboBoxPrateleira.setEnabled(habilita && this.geladeiraSelecionada != null && estanteSelecionada == null);
        this.textCodigoEstante.setEnabled(habilita && this.geladeiraSelecionada != null && this.prateleiraSelecionada != null && estanteSelecionada == null);
        this.buttonBuscaEstante.setEnabled(habilita && this.geladeiraSelecionada != null && this.prateleiraSelecionada != null && estanteSelecionada == null);
        this.textEtiqueta.setEnabled(habilita && estanteSelecionada != null);
        this.checkAuto.setEnabled(habilita && estanteSelecionada != null);
        checkImprimirIdentificacao.setEnabled(habilita && estanteSelecionada != null);
        checkIgnorarMensagemResultado.setEnabled(habilita && estanteSelecionada != null);
        this.textLocalizarTubo.setEnabled(habilita && estanteSelecionada != null);
        this.buttonRemoverTodos.setEnabled(habilita && estanteSelecionada != null && (this.tuboContainer != null ? this.tuboContainer.getNumeroPosicoesOcupadas() > 0 : !this.isVazia));
        this.buttonImprimir.setEnabled(habilita && estanteSelecionada != null && (this.tuboContainer != null ? this.tuboContainer.getNumeroPosicoesOcupadas() > 0 : !this.isVazia));
        this.info.controlaCampos(habilita, false);
        this.controlaMenu();
    }

    protected void controlaMenu() {
        boolean habilita;
        boolean bl = habilita = this.getStatus() == 3 || this.getStatus() == 2;
        this.itemImprimirIdentificacaoEstante.setEnabled(habilita && estanteSelecionada != null && (this.tuboContainer != null ? this.tuboContainer.getNumeroPosicoesOcupadas() > 0 : !this.isVazia));
        this.itemImprimirIdentificacaoTubo.setEnabled(habilita && this.tuboContainer != null && this.tuboContainer.getTubosSelecionados().size() > 0);
        if (!this.itemImprimirIdentificacaoEstante.isEnabled() && !this.itemImprimirIdentificacaoTubo.isEnabled()) {
            this.buttonImprimir.setEnabled(false);
        }
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        GeladeiraVO vo = new GeladeiraVO();
        vo.setCodigo(Integer.parseInt(this.textCodigoGeladeira.getText()));
        vo.setFilial(filial);
        GeladeiraBean bean = null;
        try {
            bean = (GeladeiraBean)this.service.voToBean(vo, GeladeiraBean.class);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Soroteca:270");
            return null;
        }
        bean.setCodigo(Integer.parseInt(this.textCodigoGeladeira.getText()));
        return bean;
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            if (this.tuboContainer != null) {
                this.tuboContainer.cancelarTimer();
            }
            this.setVisible(false);
        }
    }

    @Override
    protected void limparCampos() {
        this.textIdentificacaoEstante.clear();
        this.textCodigoGeladeira.clear();
        this.labelDescricaoGeladeira.setText("");
        this.comboBoxPrateleira.removeAllItems();
        this.textCodigoEstante.clear();
        this.textEtiqueta.clear();
        this.labelEstanteId.setText("");
        this.info.limpaInformacoes();
        this.panelEstante.removeAll();
        this.panelEstante.repaint();
        this.geladeiraSelecionada = null;
        this.prateleiraSelecionada = null;
        estanteSelecionada = null;
        this.textLocalizarTubo.clear();
        this.textLocalizarTubo.setBackground(null);
        this.labelErroLocalizar.setVisible(false);
        this.textLocalizarTubo.setForeground(Color.BLACK);
        TuboContainer.listaTodosTubos.clear();
        if (this.tuboContainer != null) {
            this.tuboContainer.cancelarTimer();
        }
        this.tuboContainer = null;
        this.isVazia = true;
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_SOROTECA);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, PARAMETRO_AUTOMATICO);
            if (!Funcoes.textoVazio(tmp)) {
                this.checkAuto.setSelected(tmp.equalsIgnoreCase("true"));
            } else {
                this.checkAuto.setSelected(false);
            }
            tmp = StringUtil.getValor(parametros, PARAMETRO_IMPRIMIR_IDENT_TUBOS);
            if (!Funcoes.textoVazio(tmp)) {
                checkImprimirIdentificacao.setSelected(tmp.equalsIgnoreCase("true"));
            } else {
                checkImprimirIdentificacao.setSelected(false);
            }
            tmp = StringUtil.getValor(parametros, PARAMETRO_IGNORAR_MENSAGEM);
            if (!Funcoes.textoVazio(tmp)) {
                checkIgnorarMensagemResultado.setSelected(tmp.equalsIgnoreCase("true"));
            } else {
                checkIgnorarMensagemResultado.setSelected(false);
            }
        }
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        GeladeiraBean gelBean = (GeladeiraBean)bean;
        this.textCodigoGeladeira.setText(Integer.toString(gelBean.getCodigo()));
        this.textCodigoGeladeira.setEnabled(false);
        this.buttonBuscaGeladeira.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodigoGeladeira.getText())) {
            Funcoes.mensagem(this, "Campo geladeira n\u00e3o est\u00e1 preenchido!", 2);
            return false;
        }
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0300900200");
    }

    private void buscaGeladeira(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoGeladeira.setText("");
            return;
        }
        try {
            AbstractThreadVO gelVO = (AbstractThreadVO)this.geladeiraService.getVO(Variaveis.filialPadrao, codigo);
            if (gelVO != null) {
                this.concluiBuscaGeladeira(gelVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Soroteca:122");
        }
    }

    private void buscaGeladeira() {
        try {
            this.textCodigoGeladeira.setText("");
            AbstractThreadVO gelVO = this.geladeiraService.pesquisaAtivasVO(this.getTopLevelAncestor(), new GeladeiraVO(), "Pesquisando geladeiras", true);
            if (gelVO != null) {
                this.concluiBuscaGeladeira(gelVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Soroteca:140");
        }
    }

    private synchronized void concluiBuscaGeladeira(AbstractThreadVO gelVO) throws Exception {
        if (gelVO != null) {
            GeladeiraBean gelBean = (GeladeiraBean)this.geladeiraService.voToBean(gelVO, GeladeiraBean.class);
            if (gelBean.getInativa().booleanValue()) {
                Funcoes.mensagem(this, "A geladeira est\u00e1 inativa.", 2);
                if (this.textCodigoGeladeira.isEnabled() && this.textCodigoGeladeira.isFocusable()) {
                    this.textCodigoGeladeira.selectAll();
                    ScreenUtil.requisitarFoco(this.textCodigoGeladeira);
                    return;
                }
            }
            this.geladeiraSelecionada = gelBean;
            this.geladeiraService.loadPrateleiras(gelBean);
            Iterator<GeladeiraPrateleiraBean> prateleiraItens = gelBean.getPrateleiras().iterator();
            this.comboBoxPrateleira.addItem(" ");
            while (prateleiraItens.hasNext()) {
                this.comboBoxPrateleira.addItem(prateleiraItens.next());
            }
            this.textCodigoGeladeira.setText(String.valueOf(gelBean.getCodigo()));
            this.labelDescricaoGeladeira.setText(gelBean.getDescricao());
            ScreenUtil.requisitarFoco(this.comboBoxPrateleira);
            this.textCodigoGeladeira.setEnabled(false);
            this.buttonBuscaGeladeira.setEnabled(false);
            this.comboBoxPrateleira.setEnabled(true);
        } else {
            Funcoes.mensagem(this, "Geladeira n\u00e3o localizada", 2);
            this.textCodigoGeladeira.selectAll();
            ScreenUtil.requisitarFoco(this.textCodigoGeladeira);
        }
    }

    private void selecionaPrateleira() {
        if (!this.comboBoxPrateleira.isEnabled() || !this.comboBoxPrateleira.isFocusable() || this.geladeiraSelecionada == null) {
            return;
        }
        if (this.comboBoxPrateleira.getSelectedItem() instanceof GeladeiraPrateleiraBean) {
            GeladeiraPrateleiraBean prateleira;
            this.prateleiraSelecionada = prateleira = (GeladeiraPrateleiraBean)this.comboBoxPrateleira.getSelectedItem();
            if (estanteSelecionada == null) {
                ScreenUtil.requisitarFoco(this.textCodigoEstante);
            }
            this.comboBoxPrateleira.setEnabled(false);
            this.textCodigoEstante.setEnabled(true);
            this.buttonBuscaEstante.setEnabled(true);
        } else {
            ScreenUtil.requisitarFoco(this.comboBoxPrateleira);
        }
    }

    private void buscaEstante(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoEstante.setText("");
            return;
        }
        try {
            EstanteBean estante = (EstanteBean)this.estanteService.get(Variaveis.filialPadrao, codigo);
            if (estante != null) {
                if (estante.getGeladeira() != null && estante.getGeladeira().getCodigo().intValue() != this.geladeiraSelecionada.getCodigo().intValue()) {
                    Funcoes.mensagem(this, "A estante j\u00e1 foi inserida na geladeira: \"" + estante.getGeladeira().getDescricao() + "\".", 2);
                    if (this.textCodigoEstante.isEnabled() && this.textCodigoEstante.isFocusable()) {
                        this.textCodigoEstante.clear();
                        ScreenUtil.requisitarFoco(this.textCodigoEstante);
                    }
                    return;
                }
                if (estante.getPrateleira() != null && this.prateleiraSelecionada != null && !estante.getPrateleira().getCodigo().equalsIgnoreCase(this.prateleiraSelecionada.getCodigo())) {
                    Funcoes.mensagem(this, "A estante j\u00e1 foi inserida na prateleira: \"" + estante.getPrateleira().getCodigo() + "\".", 2);
                    if (this.textCodigoEstante.isEnabled() && this.textCodigoEstante.isFocusable()) {
                        this.textCodigoEstante.clear();
                        ScreenUtil.requisitarFoco(this.textCodigoEstante);
                    }
                    return;
                }
                this.concluiBuscaEstante((EstanteVO)estante.toVO());
            } else {
                Funcoes.mensagem(this, "Estante n\u00e3o localizada.", 2);
                this.labelEstanteId.setText("N\u00e3o cadastrado");
                this.textCodigoEstante.clear();
                ScreenUtil.requisitarFoco(this.textCodigoEstante);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Soroteca:122");
        }
    }

    private void buscaEstante() {
        try {
            this.textCodigoEstante.setText("");
            EstanteService estanteService = new EstanteService();
            ArrayList<String> filtros = new ArrayList<String>();
            StringBuilder aux = new StringBuilder();
            aux.append(" (((gel_codigo is null) and ");
            aux.append("   (gpa_codigo is null)) or ");
            aux.append("  ((gel_codigo = " + this.geladeiraSelecionada.getCodigo() + ") and ");
            aux.append("  (gpa_codigo = '" + this.prateleiraSelecionada.getCodigo() + "'))) ");
            filtros.add(aux.toString());
            EstanteVO estanteVO = (EstanteVO)estanteService.pesquisaVO(this.getTopLevelAncestor(), new EstanteVO(), "Pesquisando estantes", true, filtros);
            if (estanteVO != null) {
                this.concluiBuscaEstante(estanteVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void concluiBuscaEstante(EstanteVO estanteVO) throws Exception {
        if (estanteVO != null) {
            EstanteBean estanteBean;
            this.setEnabled(false);
            final SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
            janelaEspera.mostrar("Carregando tubos - 0%");
            estanteSelecionada = estanteBean = (EstanteBean)this.estanteService.voToBean(estanteVO, EstanteBean.class);
            estanteSelecionada.setGeladeira((GeladeiraVO)this.geladeiraSelecionada.toVO());
            if (this.prateleiraSelecionada != null) {
                estanteSelecionada.setPrateleira((GeladeiraPrateleiraVO)this.prateleiraSelecionada.toVO());
            }
            this.labelEstanteId.setText(estanteSelecionada.getIdentificador());
            this.textCodigoEstante.setText(String.valueOf(estanteBean.getCodigo()));
            this.textCodigoEstante.setEnabled(false);
            this.buttonBuscaEstante.setEnabled(false);
            this.checkAuto.setEnabled(true);
            this.textEtiqueta.setEnabled(true);
            this.tuboContainer = estanteBean.isPacote() != false ? new TuboContainerJList(true, false) : new TuboContainerJTabuleiro(estanteBean.getLinhas(), estanteBean.getColunas(), this.panelEstante, true, false);
            this.tuboContainer.addPanelInformacoes(this.info);
            this.panelEstante.removeAll();
            this.panelEstante.add((Component)new JScrollPane(this.tuboContainer.getUI()), "Center");
            EventListener[] auxObjetos = this.panelEstante.getListeners(ComponentListener.class);
            for (int i = 0; i < auxObjetos.length; ++i) {
                this.panelEstante.removeComponentListener((ComponentListener)auxObjetos[i]);
            }
            this.panelEstante.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (Soroteca.this.tuboContainer instanceof TuboContainerJTabuleiro) {
                        ((TuboContainerJTabuleiro)Soroteca.this.tuboContainer).atualizaDiametroTubos(Soroteca.this.panelEstante);
                    }
                }

                @Override
                @Deprecated
                public void componentShown(ComponentEvent e) {
                }

                @Override
                @Deprecated
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                @Deprecated
                public void componentHidden(ComponentEvent e) {
                }
            });
            List<Tubo> tubos = TuboDao.carregaTubosEstante(Integer.parseInt(Variaveis.filialPadrao), estanteBean.getCodigo(), janelaEspera, true);
            for (int i = 0; i < tubos.size(); ++i) {
                this.tuboContainer.addTubo(tubos.get(i), false);
            }
            this.tuboContainer.atualizarValidadeTubos();
            if (this.tuboContainer.getNumeroPosicoesOcupadas() > 0) {
                this.isVazia = false;
            }
            if (this.tuboContainer instanceof TuboContainerJTabuleiro) {
                ((TuboContainerJTabuleiro)this.tuboContainer).selecionarProximaPosicaoVazia();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    janelaEspera.apagar();
                }
            });
            this.controlaCampos(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Soroteca.this.setEnabled(true);
                    ScreenUtil.requisitarFoco(Soroteca.this.textEtiqueta);
                    int digFilial = ImprimirIdentificacaoEstante.getDigitosEstanteFilial();
                    int digGeladeira = ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira();
                    int digCodigo = ImprimirIdentificacaoEstante.getDigitosEstanteCodigo();
                    String filial = Variaveis.filialPadrao;
                    String geladeira = Soroteca.this.textCodigoGeladeira.getText();
                    String estante = Soroteca.this.textCodigoEstante.getText();
                    filial = StringUtil.preencheString(filial, digFilial, '0', 1);
                    geladeira = StringUtil.preencheString(geladeira, digGeladeira, '0', 1);
                    estante = StringUtil.preencheString(estante, digCodigo, '0', 1);
                    Soroteca.this.textIdentificacaoEstante.setText(filial + geladeira + estante);
                }
            });
        } else {
            Funcoes.mensagem(this, "Estante n\u00e3o localizada", 2);
            ScreenUtil.requisitarFoco(this.textCodigoEstante);
        }
    }

    private void buscaTubo(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textEtiqueta.setText("");
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DescritorCodigoEtiqueta de = DescritorCodigoEtiqueta.getDescritor(Soroteca.this.textEtiqueta.getText());
                    String requisicao = Soroteca.this.textEtiqueta.getText();
                    if (de != null) {
                        requisicao = Funcoes.preencheZero(de.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(de.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(de.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    Soroteca.this.buscaTubo(TuboDao.carregaTubo(requisicao, false));
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar tubo.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        });
    }

    private void buscaTubo(Tubo tubo) {
        boolean perguntaRealizada = false;
        try {
            if (tubo != null && tubo.isValido()) {
                int resp;
                String msg;
                List<ExameRecipiente> listaExames = tubo.getExamesNoRecipiente();
                ArrayList<SetorVO> listaSetores = new ArrayList<SetorVO>();
                for (int i = 0; i < listaExames.size(); ++i) {
                    SetorVO setor = listaExames.get(i).getExame().getSetor();
                    boolean podeInserir = true;
                    for (int j = 0; j < listaSetores.size(); ++j) {
                        if (setor.getCodigo().intValue() != ((SetorVO)listaSetores.get(j)).getCodigo().intValue()) continue;
                        podeInserir = false;
                        break;
                    }
                    if (!podeInserir) continue;
                    listaSetores.add(setor);
                }
                if (listaSetores.size() > 1) {
                    Object[] setores = new SetorVO[listaSetores.size()];
                    for (int i = 0; i < listaSetores.size(); ++i) {
                        setores[i] = (SetorVO)listaSetores.get(i);
                    }
                    SetorVO setorSelecionado = (SetorVO)JOptionPane.showInputDialog(this, "A etiqueta foi gerada para mais de um setor.\nPor favor, selecione o setor correto: ", "Adicionando tubo...", 3, null, setores, setores[0]);
                    if (setorSelecionado == null) {
                        return;
                    }
                    for (int i = 0; i < listaExames.size(); ++i) {
                        if (listaExames.get(i).getExame().getSetor().getCodigo().intValue() == setorSelecionado.getCodigo().intValue()) continue;
                        listaExames.remove(i);
                        --i;
                    }
                    tubo.setExamesRecipiente(listaExames);
                    tubo.setSetor(setorSelecionado);
                }
                tubo.calculaSeVencido(tubo.getSetor().getCodigo());
                if (this.tuboContainer.isTuboAdicionado(tubo)) {
                    int resp2 = Funcoes.mensagem(this, "O tubo j\u00e1 foi adicionado. Deseja adicionar novamente?", 4);
                    if (resp2 == 1) {
                        this.textEtiqueta.selectAll();
                        this.textEtiqueta.grabFocus();
                        return;
                    }
                    perguntaRealizada = true;
                }
                if ((msg = TuboDao.verificaTuboOutraEstante(Integer.parseInt(Variaveis.filialPadrao), tubo.getFilial().getCodigo(), tubo.getCodigoRequisicaoEtiqueta(), tubo.getExamesNoRecipiente().get(0).getRecipienteFilho().getCodigo(), estanteSelecionada.getCodigo(), tubo.getSetor().getCodigo())) != null && (resp = Funcoes.mensagem(this, msg + "Deseja inser\u00ed-lo novamente?", 4, false)) == 1) {
                    return;
                }
                tubo.inserido = true;
                String mensagemExames = tubo.getErrosTubo();
                if (mensagemExames.length() > 0 && !checkIgnorarMensagemResultado.isSelected()) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), mensagemExames, 2);
                    this.getToolkit().beep();
                }
                if (this.checkAuto.isSelected()) {
                    if (tubo.podeAdicionarTubo()) {
                        boolean adicionado = this.adicionaTuboNaEstante(tubo, !perguntaRealizada);
                        if (checkImprimirIdentificacao.isSelected() && adicionado) {
                            ArrayList<Tubo> lista = new ArrayList<Tubo>();
                            lista.add(tubo);
                            this.imprimirIdentificacaoTubos(lista);
                        }
                        this.textEtiqueta.clear();
                    } else {
                        this.info.preencheInformacoes(tubo, true);
                        this.textEtiqueta.selectAll();
                    }
                    ScreenUtil.requisitarFoco(this.textEtiqueta);
                    this.controlaCampos(false);
                } else if (tubo.podeAdicionarTubo()) {
                    this.info.preencheInformacoes(tubo, true);
                } else {
                    this.info.preencheInformacoes(tubo, false);
                    this.textEtiqueta.selectAll();
                    ScreenUtil.requisitarFoco(this.textEtiqueta);
                }
                this.controlaMenu();
            } else {
                Funcoes.mensagem(null, "Tubo n\u00e3o localizado", 2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Soroteca.this.textEtiqueta.selectAll();
                        Soroteca.this.textEtiqueta.grabFocus();
                    }
                });
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private boolean adicionaTuboNaEstante(Tubo tubo, boolean avisaJaAdicionado) {
        if (this.tuboContainer != null) {
            Tubo tuboAux = this.tuboContainer.localizarTubo(tubo.getEtiqueta());
            if (this.tuboContainer.isNumeroPosicoesLimitado() && this.tuboContainer.getNumeroPosicoesVazias() > 0) {
                int resp;
                if (this.tuboContainer.isTuboAdicionado(tubo) && avisaJaAdicionado && (resp = JOptionPane.showOptionDialog(this, "O tubo j\u00e1 foi adicionado.\nDeseja adicion\u00e1-lo novamente?", "Adicionando tubos", 0, 3, null, new Object[]{"Sim", "N\u00e3o"}, "N\u00e3o")) == 1) {
                    this.tuboContainer.selecionarTubo(tuboAux, true);
                    this.info.preencheInformacoes(tuboAux, false);
                    return false;
                }
                if (this.checkAuto.isSelected()) {
                    Posicao posicao = ((TuboContainerJTabuleiro)this.tuboContainer).selecionarProximaPosicaoVazia();
                    tubo.setPosicaoSoroteca(posicao);
                    if (posicao == null) {
                        this.checkAuto.setSelected(false);
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 pr\u00f3ximas posi\u00e7\u00f5es, por\u00e9m h\u00e1 posi\u00e7\u00f5es vazias.\nPor favor, selecione a posi\u00e7\u00e3o desejada e adicione o tubo manualmente.", 2);
                        return false;
                    }
                } else if (((TuboContainerJTabuleiro)this.tuboContainer).getTubosSelecionados().size() > 0) {
                    resp = Funcoes.mensagem(this, "J\u00e1 h\u00e1 um tubo na posi\u00e7\u00e3o selecionada.\nAdicionar na \u00faltima posi\u00e7\u00e3o vazia?", 2);
                    if (resp == 0) {
                        ((TuboContainerJTabuleiro)this.tuboContainer).selecionarProximaPosicaoVazia();
                    } else {
                        if (this.textEtiqueta.isEnabled() && this.textEtiqueta.isFocusable()) {
                            ScreenUtil.requisitarFoco(this.textEtiqueta);
                        }
                        return false;
                    }
                }
                this.tuboContainer.addTubo(tubo, true);
                this.tuboContainer.selecionarTubo(tubo, true);
                this.tuboContainer.mostrarInformacoesTubo(tubo);
            } else {
                int resp;
                if (this.tuboContainer.isNumeroPosicoesLimitado() && this.tuboContainer.getNumeroPosicoesVazias() <= 0) {
                    Funcoes.mensagem(this, "A estante est\u00e1 cheia", 2);
                    return false;
                }
                if (this.tuboContainer.isTuboAdicionado(tubo) && avisaJaAdicionado && (resp = JOptionPane.showOptionDialog(this, "O tubo j\u00e1 foi adicionado.\nDeseja adicion\u00e1-lo novamente?", "Adicionando tubos", 0, 3, null, new Object[]{"Sim", "N\u00e3o"}, "N\u00e3o")) == 1) {
                    this.tuboContainer.selecionarTubo(tuboAux, true);
                    this.info.preencheInformacoes(tuboAux, false);
                    return false;
                }
                this.tuboContainer.addTubo(tubo, true);
                this.tuboContainer.selecionarTubo(tubo, true);
                this.tuboContainer.mostrarInformacoesTubo(tubo);
            }
        }
        return true;
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textIdentificacaoEstante);
        this.setStatus(2);
        String param = ParametrosUsuarios.getValor(PARAMETROS_SOROTECA);
        if (param != null && !Funcoes.textoVazio(param)) {
            this.checkAuto.setSelected(Boolean.parseBoolean(StringUtil.getValor(param, PARAMETRO_AUTOMATICO)));
            checkImprimirIdentificacao.setSelected(Boolean.parseBoolean(StringUtil.getValor(param, PARAMETRO_IMPRIMIR_IDENT_TUBOS)));
            checkIgnorarMensagemResultado.setSelected(Boolean.parseBoolean(StringUtil.getValor(param, PARAMETRO_IGNORAR_MENSAGEM)));
        }
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    protected String getCopiaFiliais() {
        return Variaveis.filialPadrao;
    }

    @Override
    public void salvar() {
        if (this.tuboContainer == null) {
            return;
        }
        try {
            int resp;
            List<Tubo> tubos = TuboContainer.listaTodosTubos;
            for (int i = 0; i < tubos.size(); ++i) {
                TuboDao.gravarTubo(tubos.get(i), estanteSelecionada);
            }
            String param = "<automatico>" + this.checkAuto.isSelected() + "</" + PARAMETRO_AUTOMATICO + ">";
            param = param + "<imprimir_ident_tubos>" + checkImprimirIdentificacao.isSelected() + "</" + PARAMETRO_IMPRIMIR_IDENT_TUBOS + ">";
            param = param + "<ignorarMensagens>" + checkIgnorarMensagemResultado.isSelected() + "</" + PARAMETRO_IGNORAR_MENSAGEM + ">";
            ParametrosUsuarios.setValor(PARAMETROS_SOROTECA, param);
            ParametrosUsuarios.salvarParametros(false);
            Conexao.arquivaSQL();
            if (this.isVazia && tubos.size() > 0 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja imprimir a identifica\u00e7\u00e3o da estante?", 4, true)) == 0) {
                ImprimirIdentificacaoEstante.imprimir(Variaveis.filialPadrao, estanteSelecionada.getCodigo().toString());
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos(false);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar tubos na soroteca.\n" + e.getMessage() + "\n\nComando:\n" + Conexao.getUltimoErro(), e.getStackTrace());
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

