/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.triagem.soroteca.RelatorioSolicitarTubo;
import jalis.laboratorio.triagem.soroteca.util.Exame;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.model.bean.triagem.SolicitarSorotecaBean;
import jalis.model.bean.triagem.SolicitarSorotecaTuboBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.cadastro.triagem.EstanteVO;
import jalis.model.vo.triagem.SolicitarSorotecaVO;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.triagem.SolicitarSorotecaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SolicitarTubo
extends FrmCadPadrao
implements ActionListener,
KeyListener,
FocusListener {
    private final JPanel panelCabecalho = new JPanel();
    private final JLabel labelData = new JLabel();
    private final JLabel labelVlrData = new JLabel();
    private final JLabel labelUsuario = new JLabel();
    private final JLabel labelVlrUsuario = new JLabel();
    private final JLabel labelSetor = new JLabel();
    private final JLabel labelDescSetor = new JLabel();
    private final JLabel labelPaciente = new JLabel();
    private final JLabel labelEtiqueta = new JLabel();
    private final TTextField textEtiqueta = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private final TTextField textSetor = new TTextField(12, 1);
    private final JButton buttonSetor = new JButton();
    private final JButton buttonImprimir = new JButton();
    private final JButton buttonEtiqueta = new JButton();
    private final JButton buttonOK = new JButton();
    private final JPanel panelDetalhes = new JPanel();
    private final JPanel panelDetalhesEtiqueta = new JPanel();
    private final JPanel panelDetalhesExames = new JPanel();
    private final JPanel panelBotoesEsq = new JPanel();
    private final JPanel panelBotoesDir = new JPanel();
    private final JPanel panelInsercao = new JPanel();
    private final JPanel panelEtiqueta = new JPanel();
    private final JPanel panelInformacoes = new JPanel();
    private final JPanel panelBotaoOK = new JPanel(new FlowLayout(2));
    private static final int COLUNA_ETIQUETA = 0;
    private static final int COLUNA_OBJETO = 2;
    private final ModeloGridTable modelEtiquetas = new ModeloGridTable(new String[]{"Etiqueta", "Paciente", "Objeto"}){

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            try {
                SolicitarTubo.this.tableEtiquetas.removeColumn(SolicitarTubo.this.tableEtiquetas.getColumn("Objeto"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            try {
                if (SolicitarTubo.this.tableEtiquetas != null) {
                    SolicitarTubo.this.tableEtiquetas.removeColumn(SolicitarTubo.this.tableEtiquetas.getColumn("Objeto"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    private final ModeloGridTable modelExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Sit."});
    private static final int COLUNA_RECIPIENTE = 0;
    private static final int COLUNA_CODIGO = 1;
    private static final int COLUNA_SELECAO = 5;
    private static final int COLUNA_TUBO = 6;
    private final ModeloGridTable modelInformacoes = new ModeloGridTable(new String[]{"Recip.", "C\u00f3digo", "Mat.", "Exame", "Sit.", "Sel.", "Tubo"}){

        public Class getColumnClass(int c) {
            if (c == 5) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.getColumnName(columnIndex).equalsIgnoreCase("Sel.");
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            try {
                SolicitarTubo.this.tableInformacoes.removeColumn(SolicitarTubo.this.tableInformacoes.getColumn("Tubo"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            try {
                if (SolicitarTubo.this.tableInformacoes != null) {
                    SolicitarTubo.this.tableInformacoes.removeColumn(SolicitarTubo.this.tableInformacoes.getColumn("Tubo"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    private final JTable tableEtiquetas = new JTable(this.modelEtiquetas);
    private final JTable tableExames = new JTable(this.modelExames);
    private final JTable tableInformacoes = new JTable(this.modelInformacoes);
    private final JScrollPane scrollEtiquetas = new JScrollPane(this.tableEtiquetas);
    private final JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private final JScrollPane scrollInformacoes = new JScrollPane(this.tableInformacoes);
    private String retornoParaPesquisa = "";
    private static long ACESSO_TELA = Long.parseLong("0300900500");
    private static long ACESSO_EXCLUIR = Long.parseLong("0300900501");
    private static final String PARAMETROS_SOLICITAR_TUBO = "SolicitarTubo.ultimoFiltro";
    private SetorVO setorAux = null;
    private Date dataAux = null;
    private boolean flagAlteracao = false;

    public SolicitarTubo() {
        this.setIcone(ImagemUtils.carregaImagemJalis("triagem/solicitacao_tubo.jpg"));
        this.setLabelFormulario("Solicita\u00e7\u00e3o de Tubo");
        this.setLabelDescricao("Solicita tubos adicionados na soroteca");
        ScreenUtil.setBorda(new JLabel[]{this.labelDescSetor, this.labelPaciente, this.labelVlrData, this.labelVlrUsuario}, new TitledBorder(""));
        Funcoes.imagemPesquisa(this.buttonEtiqueta);
        Funcoes.imagemPesquisa(this.buttonSetor);
        this.scrollEtiquetas.setToolTipText("Pressione DELETE para remover o tubo selecionado");
        this.buttonOK.setMnemonic('A');
        this.buttonImprimir.setMnemonic('I');
        this.tableEtiquetas.removeColumn(this.tableEtiquetas.getColumn("Objeto"));
        this.tableInformacoes.removeColumn(this.tableInformacoes.getColumn("Tubo"));
        this.tableInformacoes.setFocusable(true);
        this.buttonSetor.setFocusable(false);
        this.buttonEtiqueta.setFocusable(false);
        this.buttonImprimir.addActionListener(this);
        this.textSetor.addKeyListener(this);
        this.textSetor.addFocusListener(this);
        this.buttonSetor.addActionListener(this);
        this.textEtiqueta.addKeyListener(this);
        this.buttonEtiqueta.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.tableEtiquetas.addKeyListener(this);
        this.tableInformacoes.addKeyListener(this);
        this.tableEtiquetas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = SolicitarTubo.this.tableEtiquetas.getSelectedRow();
                if (row >= 0) {
                    SolicitarTubo.this.modelExames.clear();
                    ArrayList tubos = (ArrayList)SolicitarTubo.this.modelEtiquetas.getValueAt(row, 2);
                    if (tubos != null) {
                        for (int i = 0; i < tubos.size(); ++i) {
                            SolicitarSorotecaTuboBean tubo = (SolicitarSorotecaTuboBean)tubos.get(i);
                            SolicitarTubo.this.modelExames.addLine(new Object[]{tubo.getExame(), tubo.getAbreviaturaMaterial(), tubo.getDescricaoExame(), tubo.getSituacao(), tubo});
                        }
                    }
                }
            }
        });
        this.modelInformacoes.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row;
                if (SolicitarTubo.this.flagAlteracao) {
                    return;
                }
                if (e.getColumn() == 5 && (row = SolicitarTubo.this.tableInformacoes.getSelectedRow()) >= 0) {
                    Integer recipiente = (Integer)SolicitarTubo.this.modelInformacoes.getValueAt(row, 0);
                    Tubo tubo = (Tubo)SolicitarTubo.this.modelInformacoes.getValueAt(row, 6);
                    boolean selecionado = (Boolean)SolicitarTubo.this.modelInformacoes.getValueAt(row, 5);
                    for (int i = 0; i < SolicitarTubo.this.modelInformacoes.getRowCount(); ++i) {
                        int recipienteAux = (Integer)SolicitarTubo.this.modelInformacoes.getValueAt(i, 0);
                        Tubo tuboAux = (Tubo)SolicitarTubo.this.modelInformacoes.getValueAt(i, 6);
                        if (recipienteAux != recipiente || tuboAux.getCodigoSoroteca().intValue() != tubo.getCodigoSoroteca().intValue()) continue;
                        SolicitarTubo.this.flagAlteracao = true;
                        SolicitarTubo.this.modelInformacoes.setValueAt(selecionado, i, 5);
                        SolicitarTubo.this.flagAlteracao = false;
                    }
                }
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelCabecalho.setLayout(new GridBagLayout());
        this.modelInformacoes.setColumnSize(new int[]{50, 70, 50, 0, 50, 25, 0}, this.tableInformacoes);
        this.modelEtiquetas.setColumnSize(new int[]{100, 0, 0}, this.tableEtiquetas);
        this.modelExames.setColumnSize(new int[]{70, 50, 0, 50}, this.tableExames);
        this.labelData.setText("Data:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelData, gridBagConstraints);
        this.labelVlrData.setMinimumSize(new Dimension(90, 20));
        this.labelVlrData.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrData, gridBagConstraints);
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelVlrUsuario.setMinimumSize(new Dimension(20, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrUsuario, gridBagConstraints);
        this.labelSetor.setText("Setor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelSetor, gridBagConstraints);
        this.textSetor.setMinimumSize(new Dimension(70, 20));
        this.textSetor.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.textSetor, gridBagConstraints);
        this.buttonSetor.setMinimumSize(new Dimension(20, 20));
        this.buttonSetor.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.buttonSetor, gridBagConstraints);
        this.labelDescSetor.setMinimumSize(new Dimension(20, 20));
        this.labelDescSetor.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCabecalho.add((Component)this.labelDescSetor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelCabecalho, gridBagConstraints);
        this.panelDetalhes.setLayout(new GridBagLayout());
        this.panelDetalhesEtiqueta.setBorder(BorderFactory.createTitledBorder("Etiquetas"));
        this.panelDetalhesEtiqueta.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelDetalhesEtiqueta.add((Component)this.scrollEtiquetas, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 1.0;
        this.panelDetalhes.add((Component)this.panelDetalhesEtiqueta, gridBagConstraints);
        this.panelDetalhesExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelDetalhesExames.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelDetalhesExames.add((Component)this.scrollExames, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelDetalhes.add((Component)this.panelDetalhesExames, gridBagConstraints);
        this.panelDetalhes.setBorder(BorderFactory.createTitledBorder("Lista de tubos a serem solicitados"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelDetalhes, gridBagConstraints);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new GridBagLayout());
        this.panelBotoesEsq.setLayout(new FlowLayout(0));
        this.buttonImprimir.setText("Imprimir");
        this.panelBotoesEsq.add(this.buttonImprimir);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelBotoes.add((Component)this.panelBotoesEsq, gridBagConstraints);
        this.panelBotoesDir.setLayout(new FlowLayout(2));
        this.panelBotoesDir.add(this.botaoNovo);
        this.botaoSalvar.setText("Salvar");
        this.panelBotoesDir.add(this.botaoSalvar);
        this.botaoExcluir.setText("Excluir");
        this.panelBotoesDir.add(this.botaoExcluir);
        this.botaoCancelar.setText("Cancelar");
        this.panelBotoesDir.add(this.botaoCancelar);
        this.botaoFechar.setText("Fechar");
        this.panelBotoesDir.add(this.botaoFechar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.painelBotoes.add((Component)this.panelBotoesDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.painelBotoes, gridBagConstraints);
        this.panelInsercao.setBorder(BorderFactory.createTitledBorder("Buscar etiquetas/requisi\u00e7\u00f5es"));
        this.panelInsercao.setLayout(new GridBagLayout());
        this.panelEtiqueta.setLayout(new GridBagLayout());
        this.labelEtiqueta.setText("Etiq./Req.:");
        this.labelEtiqueta.setLabelFor(this.textEtiqueta);
        this.labelEtiqueta.setDisplayedMnemonic('t');
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelEtiqueta.add((Component)this.labelEtiqueta, gridBagConstraints);
        this.textEtiqueta.setMinimumSize(new Dimension(150, 20));
        this.textEtiqueta.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelEtiqueta.add((Component)this.textEtiqueta, gridBagConstraints);
        this.buttonEtiqueta.setMinimumSize(new Dimension(20, 20));
        this.buttonEtiqueta.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelEtiqueta.add((Component)this.buttonEtiqueta, gridBagConstraints);
        this.labelPaciente.setMinimumSize(new Dimension(20, 20));
        this.labelPaciente.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelEtiqueta.add((Component)this.labelPaciente, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelInsercao.add((Component)this.panelEtiqueta, gridBagConstraints);
        this.panelInformacoes.setLayout(new GridBagLayout());
        this.scrollInformacoes.setMinimumSize(new Dimension(20, 80));
        this.scrollInformacoes.setPreferredSize(new Dimension(20, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelInformacoes.add((Component)this.scrollInformacoes, gridBagConstraints);
        this.buttonOK.setText("Adicionar");
        this.buttonOK.setMinimumSize(new Dimension(100, 20));
        this.buttonOK.setPreferredSize(new Dimension(100, 22));
        this.panelBotaoOK.add(this.buttonOK);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panelInformacoes.add((Component)this.panelBotaoOK, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelInsercao.add((Component)this.panelInformacoes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.panelInsercao, gridBagConstraints);
        this.textEtiqueta.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.definirTeclaAtalho();
        this.controlaCampos();
    }

    private void definirTeclaAtalho() {
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao infReq = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                if (SolicitarTubo.this.tableEtiquetas.getRowCount() > 0 && SolicitarTubo.this.tableEtiquetas.getSelectedRow() > -1) {
                    String tubo = SolicitarTubo.this.modelEtiquetas.getValueAt(SolicitarTubo.this.tableEtiquetas.getSelectedRow(), 0).toString();
                    String filial = tubo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String codigo = tubo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                    infReq.setRequisicao(filial, Integer.parseInt(codigo));
                }
                infReq.setVisible(true);
                Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
    }

    public static long getModuloAcesso() {
        return ACESSO_TELA;
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.dataAux = new Date();
        this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy", this.dataAux));
        this.labelVlrUsuario.setText(Variaveis.login);
        String setor = ParametrosUsuarios.getValor(PARAMETROS_SOLICITAR_TUBO);
        this.textSetor.setText(StringUtil.getValor(setor, "setor"));
        this.textSetor.grabFocus();
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 3 || this.getStatus() == 2;
        this.textSetor.setEnabled(enabled);
        this.buttonSetor.setEnabled(enabled);
        this.textEtiqueta.setEnabled(enabled);
        this.tableInformacoes.setEnabled(enabled);
        this.tableEtiquetas.setEnabled(enabled);
        this.tableExames.setEnabled(enabled);
        this.buttonEtiqueta.setEnabled(enabled);
        this.buttonOK.setEnabled(enabled);
        this.buttonImprimir.setEnabled(enabled || this.getStatus() == 1 && !Funcoes.textoVazio(this.retornoParaPesquisa));
    }

    private void limparCampos() {
        this.labelVlrData.setText("");
        this.labelVlrUsuario.setText("");
        this.textSetor.clear();
        this.labelDescSetor.setText("");
        this.textEtiqueta.clear();
        this.labelPaciente.setText("");
        this.modelInformacoes.clear();
        this.modelEtiquetas.clear();
        this.modelExames.clear();
        this.retornoParaPesquisa = "";
        this.dataAux = null;
    }

    public void mostraInformacoesTubos(List<Tubo> tubos) {
        if (tubos == null || tubos.size() == 0) {
            return;
        }
        this.modelInformacoes.clear();
        this.labelPaciente.setText(tubos.get(0).getPaciente().getNome());
        for (int i = 0; i < tubos.size(); ++i) {
            Tubo tubo = tubos.get(i);
            List<Exame> exames = tubo.getExames();
            for (int j = 0; j < exames.size(); ++j) {
                Exame exame = exames.get(j);
                this.modelInformacoes.addLine(new Object[]{tubo.getRecipienteFilho().getCodigo(), exame.getCodigo(), exame.getMaterial(), exame.getDescricao(), exame.getSituacao(), true, tubo});
            }
        }
        if (this.modelInformacoes.getRowCount() > 0 && this.tableInformacoes.isEnabled() && this.tableInformacoes.isFocusable()) {
            ScreenUtil.requisitarFoco(this.tableInformacoes);
            this.tableInformacoes.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private SolicitarSorotecaBean getBeanPreenchido() {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        SolicitarSorotecaBean solicitacao = new SolicitarSorotecaBean();
        solicitacao.setFilial(filial);
        solicitacao.setDataHora(this.dataAux);
        solicitacao.setUsuario(usuario);
        solicitacao.setSetor(this.setorAux);
        ArrayList<SolicitarSorotecaTuboBean> tubos = new ArrayList<SolicitarSorotecaTuboBean>();
        for (int i = 0; i < this.modelEtiquetas.getRowCount(); ++i) {
            ArrayList tubosAux = (ArrayList)this.modelEtiquetas.getValueAt(i, 2);
            for (int j = 0; j < tubosAux.size(); ++j) {
                tubos.add((SolicitarSorotecaTuboBean)tubosAux.get(j));
            }
        }
        solicitacao.setTubos(tubos);
        return solicitacao;
    }

    @Override
    public void salvar() {
        if (!this.validaCampos()) {
            return;
        }
        SolicitarSorotecaService service = new SolicitarSorotecaService();
        SolicitarSorotecaBean bean = this.getBeanPreenchido();
        if (bean != null) {
            try {
                String param = "<setor>" + this.textSetor.getText() + "</setor>";
                ParametrosUsuarios.setValor(PARAMETROS_SOLICITAR_TUBO, param);
                ParametrosUsuarios.salvarParametros(false);
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, null);
                Conexao.arquivaSQL();
                this.retornoParaPesquisa = bean.getCodigo().toString();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "SolicitarTubo: 658");
            }
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void preencherCampos(SolicitarSorotecaBean bean) {
        if (bean != null) {
            this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy", bean.getDataHora()));
            this.labelVlrUsuario.setText(bean.getUsuario().getCodigo());
            this.textSetor.setText(bean.getSetor().getCodigo().toString());
            this.labelDescSetor.setText(bean.getSetor().getDescricao());
            int digFilial = ParametrosGerais.getDigitosTuboFilial();
            int digRequisicao = ParametrosGerais.getDigitosTuboRequisicao();
            int digRecipiente = ParametrosGerais.getDigitosTuboTubo();
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac_nome ");
            buf.append("   from paciente pac ");
            buf.append("   join requisicao req on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("  where req.fil_codigo = ? ");
            buf.append("    and req.req_codigo = ? ");
            PreparedStatement ps = Conexao.getPreparedStatement(buf.toString());
            ArrayList<SolicitarSorotecaTuboBean> tubos = bean.getTubos();
            for (int i = 0; i < tubos.size(); ++i) {
                SolicitarSorotecaTuboBean tubo = tubos.get(i);
                String filial = Funcoes.preencheZero(tubo.getFilialTubo().getCodigo().toString(), digFilial);
                String requisicao = Funcoes.preencheZero(tubo.getRequisicao().toString(), digRequisicao);
                String recipiente = Funcoes.preencheZero(tubo.getRecipienteFilho().toString(), digRecipiente);
                String paciente = null;
                try {
                    ps.setInt(1, tubo.getFilial().getCodigo());
                    ps.setInt(2, tubo.getRequisicao());
                    ResultSet rs = Conexao.executeQuery(ps);
                    if (rs.next()) {
                        paciente = rs.getString("pac_nome");
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.modelEtiquetas.addLine(new Object[]{filial + requisicao + recipiente, paciente == null ? "" : paciente});
            }
        }
    }

    @Override
    public void excluir() {
        SolicitarSorotecaVO vo = (SolicitarSorotecaVO)new SolicitarSorotecaService().pesquisaVO(Laboratorio.getInstancia(), new SolicitarSorotecaVO(), "Solicita\u00e7\u00e3o de Tubos", false);
        if (vo != null) {
            try {
                final SolicitarSorotecaBean bean = (SolicitarSorotecaBean)new SolicitarSorotecaService().get(Variaveis.filialPadrao, vo.getCodigo().toString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SolicitarTubo.this.preencherCampos(bean);
                        if (Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja cancelar a solicita\u00e7\u00e3o?", 4) == 0) {
                            try {
                                UsuarioVO usuario = new UsuarioVO();
                                usuario.setCodigo(Variaveis.login);
                                bean.setUsuarioCancelamento(usuario);
                                bean.setDataHoraCancelamento(new Date());
                                new SolicitarSorotecaService().gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, null);
                                Conexao.arquivaSQL();
                            }
                            catch (Exception e) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ReceberPagarBean:2329");
                            }
                        }
                        SolicitarTubo.this.limparCampos();
                    }
                });
            }
            catch (Exception e1) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel encontrar a Solicita\u00e7\u00e3o de Tubos.", 2);
            }
        }
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (this.setorAux == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Setor n\u00e3o configurado", 2);
            return false;
        }
        if (this.modelEtiquetas.getRowCount() <= 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhum tubo inserido", 2);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSetor) {
            SetorVO setor = new SetorVO();
            setor = (SetorVO)new SetorService().pesquisaVO(Laboratorio.getInstancia(), setor, "Pesquisando setores", true);
            if (setor != null) {
                this.setorAux = setor;
                this.textSetor.setText(setor.getCodigo().toString());
                this.labelDescSetor.setText(setor.getDescricao());
            } else {
                this.setorAux = null;
            }
        } else if (e.getSource() == this.buttonEtiqueta) {
            Hashtable req = Pesquisas.requisicaoSoroteca(Laboratorio.getInstancia());
            if (req != null) {
                this.textEtiqueta.setText(req.get("req_codigo").toString());
            } else {
                this.textEtiqueta.clear();
            }
        } else if (e.getSource() == this.buttonOK) {
            ArrayList<Tubo> tubos = new ArrayList<Tubo>();
            for (int i = 0; i < this.modelInformacoes.getRowCount(); ++i) {
                int j;
                if (!((Boolean)this.modelInformacoes.getValueAt(i, 5)).booleanValue()) continue;
                Tubo tubo = (Tubo)this.modelInformacoes.getValueAt(i, 6);
                boolean jaInserido = false;
                for (j = 0; j < this.modelEtiquetas.getRowCount(); ++j) {
                    ArrayList listaTuboAux = (ArrayList)this.modelEtiquetas.getValueAt(j, 2);
                    SolicitarSorotecaTuboBean tuboAux = (SolicitarSorotecaTuboBean)listaTuboAux.get(0);
                    String etiqueta = (String)this.modelEtiquetas.getValueAt(j, 0);
                    if (!etiqueta.equalsIgnoreCase(tubo.getEtiqueta()) || tuboAux.getSetor().getCodigo().intValue() != tubo.getSetor().getCodigo().intValue()) continue;
                    jaInserido = true;
                    break;
                }
                if (jaInserido) continue;
                for (j = 0; j < tubos.size(); ++j) {
                    if (!((Tubo)tubos.get(j)).getEtiqueta().equalsIgnoreCase(tubo.getEtiqueta()) || ((Tubo)tubos.get(j)).getSetor().getCodigo().intValue() != tubo.getSetor().getCodigo().intValue() || ((Tubo)tubos.get(j)).getCodigoSoroteca().intValue() != tubo.getCodigoSoroteca().intValue()) continue;
                    jaInserido = true;
                    break;
                }
                if (jaInserido) continue;
                tubos.add(tubo);
            }
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            for (int i = 0; i < tubos.size(); ++i) {
                Tubo tubo = (Tubo)tubos.get(i);
                ArrayList<SolicitarSorotecaTuboBean> auxTubos = new ArrayList<SolicitarSorotecaTuboBean>();
                for (int j = 0; tubo != null && j < tubo.getExames().size(); ++j) {
                    Exame exame = tubo.getExames().get(j);
                    SolicitarSorotecaTuboBean aux = new SolicitarSorotecaTuboBean();
                    aux.setFilial(filial);
                    aux.setFilialTubo(tubo.getFilial());
                    aux.setEstante((EstanteVO)tubo.getEstante().toVO());
                    aux.setExame(exame.getCodigo());
                    aux.setSituacao(exame.getSituacao());
                    aux.setDescricaoExame(exame.getDescricao());
                    aux.setMaterial(exame.getCodigoMaterial());
                    aux.setAbreviaturaMaterial(exame.getMaterial());
                    aux.setRequisicao(exame.getCodigoRequisicao());
                    aux.setRecipientePai(tubo.getRecipientePai(exame.getCodigo()).getCodigo());
                    aux.setRecipienteFilho(tubo.getRecipienteFilho().getCodigo());
                    aux.setCodigoSoroteca(tubo.getCodigoSoroteca());
                    aux.setSetor(tubo.getSetor());
                    auxTubos.add(aux);
                }
                int digFilial = ParametrosGerais.getDigitosTuboFilial();
                int digRequisicao = ParametrosGerais.getDigitosTuboRequisicao();
                int digRecipiente = ParametrosGerais.getDigitosTuboTubo();
                String etiqueta = StringUtil.preencheString(tubo.getFilial().getCodigo().toString(), digFilial, '0', 1);
                etiqueta = etiqueta + StringUtil.preencheString(tubo.getCodigoRequisicaoEtiqueta().toString(), digRequisicao, '0', 1);
                etiqueta = etiqueta + StringUtil.preencheString(tubo.getRecipienteFilho().getCodigo().toString(), digRecipiente, '0', 1);
                this.modelEtiquetas.addLine(new Object[]{etiqueta, this.labelPaciente.getText(), auxTubos});
            }
            this.textEtiqueta.clear();
            this.labelPaciente.setText("");
            this.modelInformacoes.clear();
            this.textEtiqueta.grabFocus();
        } else if (e.getSource() == this.buttonImprimir) {
            if (this.getStatus() == 2) {
                int resp = Funcoes.mensagem(Laboratorio.getInstancia(), "A solicita\u00e7\u00e3o deve ser salva, antes de ser impressa.\nDeseja salvar?", 4, true);
                if (resp == 0) {
                    this.salvar();
                } else {
                    return;
                }
            }
            if (this.getStatus() == 1) {
                RelatorioSolicitarTubo relatorioSolicitacao = new RelatorioSolicitarTubo();
                relatorioSolicitacao.imprimirPressionado(this.retornoParaPesquisa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.textEtiqueta) {
            if (e.isConsumed() || e.getKeyChar() != '\n') {
                return;
            }
            e.setKeyCode(0);
            if (!this.textEtiqueta.getText().isEmpty()) {
                List<Tubo> tubos = null;
                SplashMensagem splash = new SplashMensagem();
                try {
                    splash.mostrar("Buscando tubos na soroteca... aguarde.");
                    int digFilial = ParametrosGerais.getDigitosTuboFilial();
                    int digRequisicao = ParametrosGerais.getDigitosTuboRequisicao();
                    int digRecipiente = ParametrosGerais.getDigitosTuboTubo();
                    int digTotal = digFilial + digRequisicao + digRecipiente;
                    if (this.textEtiqueta.getText().length() == digTotal) {
                        tubos = TuboDao.carregaTubosConsulta(this.textEtiqueta.getText(), true, false);
                    }
                    if (tubos == null) {
                        tubos = TuboDao.carregaTubosConsulta(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(this.textEtiqueta.getText()));
                    }
                    ScreenUtil.requisitarFoco(this.scrollInformacoes);
                    this.tableInformacoes.getSelectionModel().setSelectionInterval(0, 0);
                    if (tubos == null || tubos.size() == 0) {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel localizar o tubo/requisi\u00e7\u00e3o.", 2);
                        this.textEtiqueta.selectAll();
                        this.textEtiqueta.grabFocus();
                    } else {
                        this.mostraInformacoesTubos(tubos);
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel localizar o tubo/requisi\u00e7\u00e3o.", 2);
                    this.textEtiqueta.selectAll();
                    this.textEtiqueta.grabFocus();
                }
                finally {
                    splash.apagar();
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        block7: {
            int row;
            block5: {
                block6: {
                    if (e.getKeyCode() != 113) break block5;
                    if (e.getSource() != this.textSetor) break block6;
                    this.buttonSetor.doClick();
                    break block7;
                }
                if (e.getSource() != this.textEtiqueta) break block7;
                this.buttonEtiqueta.doClick();
                break block7;
            }
            if (e.getKeyCode() == 127) {
                int resp;
                int row2;
                if (e.getSource() == this.tableEtiquetas && (row2 = this.tableEtiquetas.getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja remover o tubo?", 4, false)) == 0) {
                    this.modelEtiquetas.removeLine(row2);
                    this.modelExames.clear();
                }
            } else if (e.getKeyCode() == 32 && e.getSource() == this.tableInformacoes && this.tableInformacoes.getSelectedColumn() != 5 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                Integer recipiente = (Integer)this.modelInformacoes.getValueAt(row, 0);
                Tubo tubo = (Tubo)this.modelInformacoes.getValueAt(row, 6);
                boolean selecionado = (Boolean)this.modelInformacoes.getValueAt(row, 5) == false;
                for (int i = 0; i < this.modelInformacoes.getRowCount(); ++i) {
                    int recipienteAux = (Integer)this.modelInformacoes.getValueAt(i, 0);
                    Tubo tuboAux = (Tubo)this.modelInformacoes.getValueAt(i, 6);
                    if (recipienteAux != recipiente || tuboAux.getCodigoSoroteca().intValue() != tubo.getCodigoSoroteca().intValue()) continue;
                    this.flagAlteracao = true;
                    this.modelInformacoes.setValueAt(selecionado, i, 5);
                    this.flagAlteracao = false;
                }
            }
        }
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e) {
    }

    @Override
    @Deprecated
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textSetor) {
            if (!Funcoes.textoVazio(this.textSetor)) {
                try {
                    SetorVO setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, this.textSetor.getText());
                    if (setor == null) {
                        throw new Exception();
                    }
                    this.setorAux = setor;
                    this.labelDescSetor.setText(setor.getDescricao());
                }
                catch (Exception e1) {
                    Funcoes.mensagem(this, "Setor n\u00e3o localizado.", 2);
                    this.setorAux = null;
                    this.textSetor.selectAll();
                    this.textSetor.grabFocus();
                }
            } else {
                this.setorAux = null;
                this.labelDescSetor.setText("");
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "sso_codigo";
    }
}

