/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.soroteca.SorotecaBasica;
import jalis.laboratorio.triagem.soroteca.jtabuleiro.JTabuleiro;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.model.bean.triagem.SolicitarSorotecaBean;
import jalis.model.bean.triagem.SolicitarSorotecaTuboBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.triagem.SolicitarSorotecaVO;
import jalis.service.triagem.SolicitarSorotecaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RetiradaTubo
extends FrmCadPadrao {
    private JTable tableEtiquetas = null;
    private static final int COLUNA_OBJETO = 2;
    private ModeloGridTable modelEtiquetas = null;
    private JScrollPane scrollEtiquetas = null;
    private JTable tableEtiquetasRemovidas = null;
    private ModeloGridTable modelEtiquetasRemovidas = null;
    private JScrollPane scrollEtiquetasRemovidas = null;
    private final JLabel labelSolicitacao = new JLabel();
    private final JLabel labelData = new JLabel();
    private final JLabel labelVlrData = new JLabel();
    private final JLabel labelUsuario = new JLabel();
    private final JLabel labelVlrUsuario = new JLabel();
    private final JLabel labelSetor = new JLabel();
    private final JLabel labelVlrSetor = new JLabel();
    private final JLabel labelDescSetor = new JLabel();
    private final JLabel labelEtiqueta = new JLabel();
    private final TTextField textSolicitacao = new TTextField(10, 1);
    private final TTextField textEtiqueta = new TTextField(12, 1);
    private final JButton buttonSolicitacao = new JButton();
    private final JButton buttonOk = new JButton("OK");
    private final SorotecaBasica panelSoroteca = new SorotecaBasica();
    private JSplitPane splitSoroteca = null;
    private final JPanel panelLegenda = new JPanel();
    private final JPanel panelEtiquetaAvulsa = new JPanel(new GridBagLayout());
    private final JPanel panelEtiquetas = new JPanel(new GridBagLayout());
    private final JPanel panelEtiquetasOK = new JPanel(new BorderLayout());
    private final JPanel panelEtiquetasRemovidas = new JPanel(new BorderLayout());
    SolicitarSorotecaBean solicitacaoBean = null;
    boolean tuboAvulsoAdicionado = false;

    public static long getModuloAcesso() {
        return Long.parseLong("0300900600");
    }

    public RetiradaTubo() {
        this.setLabelFormulario("Retirada de Tubos");
        this.setLabelDescricao("Retirada de tubos solicitados e avulsos");
        this.setIcone(ImagemUtils.carregaImagemJalis("triagem/retirada_tubos.jpg"));
        ScreenUtil.setBorda(new JLabel[]{this.labelVlrData, this.labelVlrUsuario, this.labelVlrSetor, this.labelDescSetor}, new TitledBorder(""));
        Dimension d = new Dimension(130, 20);
        this.labelVlrData.setPreferredSize(d);
        this.labelVlrData.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.labelDescSetor.setPreferredSize(d);
        this.labelDescSetor.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.labelVlrUsuario.setPreferredSize(d);
        this.labelVlrUsuario.setMinimumSize(d);
        d = new Dimension(40, 20);
        this.labelVlrSetor.setPreferredSize(d);
        this.labelVlrSetor.setMinimumSize(d);
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setText("Retirar");
        this.botaoSalvar.setMnemonic('R');
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelSolicitacao.setText("Solicita\u00e7\u00e3o:");
        this.labelSolicitacao.setDisplayedMnemonic('R');
        this.labelSolicitacao.setLabelFor(this.textSolicitacao);
        this.labelEtiqueta.setText("Etiqueta:");
        this.labelEtiqueta.setDisplayedMnemonic('E');
        d = new Dimension(20, 20);
        this.buttonSolicitacao.setFocusable(false);
        this.buttonSolicitacao.setMinimumSize(d);
        this.buttonSolicitacao.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonSolicitacao);
        this.buttonSolicitacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolicitarSorotecaVO vo = (SolicitarSorotecaVO)new SolicitarSorotecaService().pesquisaVO(Laboratorio.getInstancia(), new SolicitarSorotecaVO(), "Solicita\u00e7\u00e3o de Tubos", false);
                if (vo != null) {
                    SolicitarSorotecaBean bean = null;
                    try {
                        bean = (SolicitarSorotecaBean)new SolicitarSorotecaService().get(Variaveis.filialPadrao, vo.getCodigo().toString());
                        if (bean == null) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel encontrar a Solicita\u00e7\u00e3o de Tubos.", 2);
                            RetiradaTubo.this.textSolicitacao.clear();
                            ScreenUtil.requisitarFoco(RetiradaTubo.this.textSolicitacao);
                            return;
                        }
                        RetiradaTubo.this.textSolicitacao.setText(bean.getCodigo().toString());
                        RetiradaTubo.this.carregarDados(bean);
                        RetiradaTubo.this.controlaCampos();
                        RetiradaTubo.this.tableEtiquetas.getSelectionModel().setSelectionInterval(0, 0);
                        ScreenUtil.requisitarFoco(RetiradaTubo.this.tableEtiquetas);
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel encontrar a Solicita\u00e7\u00e3o de Tubos.\n" + e1.getMessage(), e1.getStackTrace());
                        RetiradaTubo.this.textSolicitacao.clear();
                        ScreenUtil.requisitarFoco(RetiradaTubo.this.textSolicitacao);
                    }
                } else {
                    RetiradaTubo.this.textSolicitacao.selectAll();
                    ScreenUtil.requisitarFoco(RetiradaTubo.this.textSolicitacao);
                }
            }
        });
        d = new Dimension(80, 20);
        this.textSolicitacao.setMinimumSize(d);
        this.textSolicitacao.setPreferredSize(d);
        this.textSolicitacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    RetiradaTubo.this.buttonSolicitacao.doClick();
                }
            }
        });
        this.textSolicitacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(RetiradaTubo.this.textSolicitacao.getText())) {
                    RetiradaTubo.this.limparCampos();
                } else {
                    SolicitarSorotecaBean bean = null;
                    try {
                        bean = (SolicitarSorotecaBean)new SolicitarSorotecaService().get(Variaveis.filialPadrao, RetiradaTubo.this.textSolicitacao.getText());
                        if (bean == null) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel encontrar a Solicita\u00e7\u00e3o de Tubos.", 2);
                            RetiradaTubo.this.textSolicitacao.clear();
                            ScreenUtil.requisitarFoco(RetiradaTubo.this.textSolicitacao);
                            return;
                        }
                        if (bean.getDataHoraEntrega() != null) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Os tubos da solicita\u00e7\u00e3o j\u00e1 foram retirados.", 2);
                            RetiradaTubo.this.textSolicitacao.selectAll();
                            ScreenUtil.requisitarFoco(RetiradaTubo.this.textSolicitacao);
                            return;
                        }
                        if (bean.getDataHoraCancelamento() != null) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "A solicita\u00e7\u00e3o de tubos foi cancelada.", 2);
                            RetiradaTubo.this.textSolicitacao.clear();
                            ScreenUtil.requisitarFoco(RetiradaTubo.this.textSolicitacao);
                            return;
                        }
                        RetiradaTubo.this.carregarDados(bean);
                        RetiradaTubo.this.controlaCampos();
                        RetiradaTubo.this.tableEtiquetas.getSelectionModel().setSelectionInterval(0, 0);
                        ScreenUtil.requisitarFoco(RetiradaTubo.this.tableEtiquetas);
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel encontrar a Solicita\u00e7\u00e3o de Tubos.\n" + e1.getMessage(), e1.getStackTrace());
                        RetiradaTubo.this.textSolicitacao.selectAll();
                        ScreenUtil.requisitarFoco(RetiradaTubo.this.textSolicitacao);
                    }
                }
            }
        });
        this.modelEtiquetas = new ModeloGridTable(new String[]{"Etiqueta", "Paciente", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{String.class, String.class, Tubo.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (RetiradaTubo.this.tableEtiquetas != null) {
                        RetiradaTubo.this.tableEtiquetas.removeColumn(RetiradaTubo.this.tableEtiquetas.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    RetiradaTubo.this.tableEtiquetas.removeColumn(RetiradaTubo.this.tableEtiquetas.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.modelEtiquetasRemovidas = new ModeloGridTable(new String[]{"Etiqueta", "Paciente", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{String.class, String.class, Tubo.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (RetiradaTubo.this.tableEtiquetasRemovidas != null) {
                        RetiradaTubo.this.tableEtiquetasRemovidas.removeColumn(RetiradaTubo.this.tableEtiquetasRemovidas.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    RetiradaTubo.this.tableEtiquetasRemovidas.removeColumn(RetiradaTubo.this.tableEtiquetasRemovidas.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableEtiquetas = new JTable(this.modelEtiquetas);
        this.tableEtiquetas.setToolTipText("Pressione ESPA\u00c7O para marcar o tubo");
        this.tableEtiquetas.setFocusable(true);
        this.tableEtiquetas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (RetiradaTubo.this.tableEtiquetas.getSelectedRow() >= 0) {
                    ArrayList<Tubo> listaTubos = new ArrayList<Tubo>();
                    for (int i = 0; i < RetiradaTubo.this.modelEtiquetas.getRowCount(); ++i) {
                        listaTubos.add((Tubo)RetiradaTubo.this.modelEtiquetas.getValueAt(i, 2));
                    }
                    if (RetiradaTubo.this.modelEtiquetas.getRowCount() > 0) {
                        RetiradaTubo.this.panelSoroteca.setTubo((Tubo)RetiradaTubo.this.modelEtiquetas.getValueAt(RetiradaTubo.this.tableEtiquetas.getSelectedRow(), 2), listaTubos);
                    }
                }
            }
        });
        this.tableEtiquetas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && RetiradaTubo.this.tableEtiquetas.getSelectedRow() >= 0) {
                    ArrayList<Tubo> listaTubos = new ArrayList<Tubo>();
                    for (int i = 0; i < RetiradaTubo.this.modelEtiquetas.getRowCount(); ++i) {
                        Tubo tubo = (Tubo)RetiradaTubo.this.modelEtiquetas.getValueAt(i, 2);
                        if (i == RetiradaTubo.this.tableEtiquetas.getSelectedRow()) {
                            tubo.setMarcado(!tubo.isMarcado());
                        }
                        listaTubos.add(tubo);
                    }
                    RetiradaTubo.this.panelSoroteca.setTubo((Tubo)RetiradaTubo.this.modelEtiquetas.getValueAt(RetiradaTubo.this.tableEtiquetas.getSelectedRow(), 2), listaTubos);
                }
            }
        });
        this.tableEtiquetasRemovidas = new JTable(this.modelEtiquetasRemovidas);
        this.tableEtiquetasRemovidas.setFocusable(true);
        this.modelEtiquetas.setColumnSize(new int[]{120, 0, 0}, this.tableEtiquetas);
        this.tableEtiquetas.getTableHeader().addMouseListener(this.modelEtiquetas);
        this.tableEtiquetas.removeColumn(this.tableEtiquetas.getColumn("Objeto"));
        this.scrollEtiquetas = new JScrollPane(this.tableEtiquetas);
        this.scrollEtiquetas.setMinimumSize(new Dimension(230, 20));
        this.scrollEtiquetas.setPreferredSize(new Dimension(230, 20));
        this.panelEtiquetasOK.add((Component)this.scrollEtiquetas, "Center");
        this.panelEtiquetasOK.setBorder(BorderFactory.createTitledBorder("Etiquetas"));
        this.modelEtiquetasRemovidas.setColumnSize(new int[]{120, 0, 0}, this.tableEtiquetasRemovidas);
        this.tableEtiquetasRemovidas.getTableHeader().addMouseListener(this.modelEtiquetasRemovidas);
        this.tableEtiquetasRemovidas.removeColumn(this.tableEtiquetasRemovidas.getColumn("Objeto"));
        this.scrollEtiquetasRemovidas = new JScrollPane(this.tableEtiquetasRemovidas);
        this.scrollEtiquetasRemovidas.setMinimumSize(new Dimension(230, 20));
        this.scrollEtiquetasRemovidas.setPreferredSize(new Dimension(230, 20));
        this.panelEtiquetasRemovidas.add((Component)this.scrollEtiquetasRemovidas, "Center");
        this.panelEtiquetasRemovidas.setBorder(BorderFactory.createTitledBorder("Etiquetas removidas"));
        d = new Dimension(130, 20);
        this.textEtiqueta.setMinimumSize(d);
        this.textEtiqueta.setPreferredSize(d);
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        d = new Dimension(30, 20);
        this.buttonOk.setMinimumSize(d);
        d = new Dimension(30, 20);
        this.buttonOk.setPreferredSize(d);
        this.buttonOk.setMnemonic('i');
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashMensagem msg = new SplashMensagem();
                msg.mostrar("Aguarde, buscando tubos...");
                if (!Funcoes.textoVazio(RetiradaTubo.this.textEtiqueta)) {
                    RetiradaTubo.this.carregaTubos(RetiradaTubo.this.textEtiqueta.getText());
                }
                if (RetiradaTubo.this.modelEtiquetas.getRowCount() > 0 && RetiradaTubo.this.tableEtiquetas.isEnabled() && RetiradaTubo.this.tableEtiquetas.isFocusable()) {
                    RetiradaTubo.this.tableEtiquetas.getSelectionModel().setSelectionInterval(0, 0);
                }
                msg.apagar();
            }
        });
        this.panelEtiquetaAvulsa.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("ComboBox.selectionBackground")), BorderFactory.createEmptyBorder(0, 0, 2, 0)));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 0, 0, 1);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelEtiquetaAvulsa.add((Component)this.labelEtiqueta, c);
        ++c.gridx;
        this.panelEtiquetaAvulsa.add((Component)this.textEtiqueta, c);
        ++c.gridx;
        this.panelEtiquetaAvulsa.add((Component)this.buttonOk, c);
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 2;
        this.panelEtiquetaAvulsa.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 0, 0, 1);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelEtiquetas.add((Component)this.panelEtiquetasOK, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.7;
        this.panelEtiquetas.add((Component)this.panelEtiquetasRemovidas, c);
        this.splitSoroteca = new JSplitPane(1, this.panelEtiquetas, this.panelSoroteca);
        c = new GridBagConstraints();
        c.insets = new Insets(1, 0, 0, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 8;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelEtiquetaAvulsa, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelSolicitacao, c);
        c.insets = new Insets(5, 0, 0, 0);
        ++c.gridx;
        this.painelCentral.add((Component)this.textSolicitacao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonSolicitacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelUsuario.setText("Usu\u00e1rio:");
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.painelCentral.add((Component)this.labelVlrUsuario, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = new Insets(1, 20, 0, 1);
        this.labelData.setText("Data:");
        this.painelCentral.add((Component)this.labelData, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.labelVlrData, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 1);
        this.labelSetor.setText("Setor:");
        this.painelCentral.add((Component)this.labelSetor, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.labelVlrSetor, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.labelDescSetor, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 8;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.splitSoroteca.setBorder(BorderFactory.createTitledBorder(""));
        this.painelCentral.add((Component)this.splitSoroteca, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        RetiradaTubo.montaPanelLegenda(this.panelLegenda);
        this.painelCentral.add((Component)this.panelLegenda, c);
        this.modelEtiquetas.ordenarColunaSemTrocarSentido(this.modelEtiquetas.findColumn("Etiqueta"));
        this.definirTeclaAtalho();
        this.controlaCampos();
    }

    private void definirTeclaAtalho() {
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                InfoRequisicao infReq = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
                Tubo tuboSelecionado = null;
                if (RetiradaTubo.this.tableEtiquetas.hasFocus() && RetiradaTubo.this.tableEtiquetas.getRowCount() > 0 && RetiradaTubo.this.tableEtiquetas.getSelectedRow() > -1) {
                    tuboSelecionado = (Tubo)RetiradaTubo.this.modelEtiquetas.getValueAt(RetiradaTubo.this.tableEtiquetas.getSelectedRow(), 2);
                } else if (RetiradaTubo.this.tableEtiquetasRemovidas.hasFocus() && RetiradaTubo.this.tableEtiquetasRemovidas.getRowCount() > 0 && RetiradaTubo.this.tableEtiquetasRemovidas.getSelectedRow() > -1) {
                    tuboSelecionado = (Tubo)RetiradaTubo.this.modelEtiquetasRemovidas.getValueAt(RetiradaTubo.this.tableEtiquetasRemovidas.getSelectedRow(), 2);
                }
                if (null != tuboSelecionado) {
                    String filial = tuboSelecionado.getFilial().getCodigo().toString();
                    String codigo = tuboSelecionado.getCodigoRequisicaoEtiqueta().toString();
                    infReq.setRequisicao(filial, Integer.parseInt(codigo));
                }
                infReq.setVisible(true);
                Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
    }

    public void carregaTubos(String etiqueta) {
        ArrayList<Tubo> tubos = null;
        try {
            tubos = TuboDao.carregaTubosConsulta(etiqueta, true, false);
            if (tubos == null || tubos.size() == 0) {
                tubos = TuboDao.carregaTubosConsulta(etiqueta, true, true);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados dos tubos.\n" + e.getMessage(), e.getStackTrace());
        }
        if (tubos == null || tubos.size() == 0) {
            Funcoes.mensagem(this, "Nenhum tubo encontrado na soroteca.", 2);
            ScreenUtil.requisitarFoco(this.textEtiqueta);
        } else {
            this.preencheDadosTubos(tubos);
        }
    }

    private void preencheDadosTubos(List<Tubo> tubos) {
        if (tubos == null) {
            return;
        }
        int qtdeAdicionada = 0;
        for (int i = 0; i < tubos.size(); ++i) {
            Tubo tubo = tubos.get(i);
            if (tubo.getDataHoraDescarte() != null || tubo.getUsuarioDescarte() != null) continue;
            boolean jaAdicionado = false;
            if (i == 0) {
                for (int j = 0; j < this.modelEtiquetas.getRowCount(); ++j) {
                    if (!this.modelEtiquetas.getValueAt(j, 0).toString().equalsIgnoreCase(tubo.getEtiqueta())) continue;
                    jaAdicionado = true;
                    break;
                }
            }
            if (jaAdicionado) break;
            this.modelEtiquetas.addLine(new Object[]{tubo.getEtiqueta(), tubo.getPaciente().getNome(), tubo});
            ++qtdeAdicionada;
        }
        if (qtdeAdicionada == 0) {
            Tubo aux = null;
            for (int i = 0; i < tubos.size(); ++i) {
                if (tubos.get(i).getDataHoraDescarte() == null) continue;
                aux = tubos.get(i);
            }
            if (aux != null) {
                Funcoes.mensagem(null, "O tubo foi removido da soroteca em \"" + Funcoes.formataData("dd/MM/yyyy HH:mm", aux.getDataHoraDescarte()) + "\" pelo usu\u00e1rio \"" + aux.getUsuarioDescarte().getCodigo() + "\".", 5);
            } else {
                Funcoes.mensagem(null, "A etiqueta j\u00e1 foi adicionada.", 5);
            }
            this.textEtiqueta.selectAll();
        } else {
            this.tuboAvulsoAdicionado = true;
            this.controlaCampos();
            this.textEtiqueta.clear();
        }
        ScreenUtil.requisitarFoco(this.textEtiqueta);
    }

    private void carregarDados(SolicitarSorotecaBean solicitacao) {
        this.limpar();
        this.solicitacaoBean = solicitacao;
        if (this.solicitacaoBean != null) {
            this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm", this.solicitacaoBean.getDataHora()));
            this.labelVlrUsuario.setText(this.solicitacaoBean.getUsuario().getCodigo());
            this.labelVlrSetor.setText(this.solicitacaoBean.getSetor().getCodigo().toString());
            this.labelDescSetor.setText(this.solicitacaoBean.getSetor().getDescricao());
            ArrayList<SolicitarSorotecaTuboBean> tubos = this.solicitacaoBean.getTubos();
            if (tubos != null) {
                HashMap<String, SolicitarSorotecaTuboBean> mapaSolicitacoes = new HashMap<String, SolicitarSorotecaTuboBean>();
                for (int i = 0; i < tubos.size(); ++i) {
                    SolicitarSorotecaTuboBean aux = tubos.get(i);
                    String id = aux.getFilial().getCodigo().toString() + "" + aux.getRequisicao().toString() + "" + aux.getRecipienteFilho().toString() + "" + aux.getCodigoSoroteca().toString();
                    mapaSolicitacoes.put(id, aux);
                }
                ArrayList listaSolicitacoes = new ArrayList(mapaSolicitacoes.values());
                for (int i = 0; i < listaSolicitacoes.size(); ++i) {
                    SolicitarSorotecaTuboBean aux = (SolicitarSorotecaTuboBean)listaSolicitacoes.get(i);
                    try {
                        ArrayList<Tubo> listaTubos = TuboDao.carregaTubosConsulta(aux.getFilial().getCodigo(), aux.getFilialTubo().getCodigo(), aux.getRequisicao(), aux.getRecipienteFilho(), aux.getCodigoSoroteca(), aux.getEstante().getCodigo(), true, true, true);
                        if (listaTubos == null) continue;
                        for (int j = 0; j < listaTubos.size(); ++j) {
                            Tubo tubo = listaTubos.get(j);
                            if (tubo.getDataHoraDescarte() == null) {
                                this.modelEtiquetas.addLine(new Object[]{tubo.getEtiqueta(), tubo.getPaciente().getNome(), tubo});
                                continue;
                            }
                            this.modelEtiquetasRemovidas.addLine(new Object[]{tubo.getEtiqueta(), tubo.getPaciente().getNome()});
                        }
                        continue;
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados dos tubos. Requisi\u00e7\u00e3o: " + aux.getRequisicao() + ".", 2);
                    }
                }
            }
        }
    }

    public static void montaPanelLegenda(JPanel pnlLegenda) {
        if (pnlLegenda == null) {
            pnlLegenda = new JPanel(new GridBagLayout());
        } else if (!(pnlLegenda.getLayout() instanceof GridBagLayout)) {
            pnlLegenda.setLayout(new GridBagLayout());
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_PREENCHIDA);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Tubo n\u00e3o retirado");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_MARCADO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Tubo retirado");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        pnlLegenda.add((Component)new JLabel(""), c);
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.textEtiqueta.grabFocus();
    }

    private SolicitarSorotecaBean getBeanPreenchido() {
        if (this.solicitacaoBean != null) {
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            this.solicitacaoBean.setUsuarioEntrega(usuario);
            this.solicitacaoBean.setDataHoraEntrega(new Date());
            return this.solicitacaoBean;
        }
        return null;
    }

    @Override
    public void salvar() {
        if (!this.validaCampos()) {
            return;
        }
        SolicitarSorotecaService service = new SolicitarSorotecaService();
        SolicitarSorotecaBean bean = this.getBeanPreenchido();
        try {
            int qtdeRemovida = 0;
            for (int i = 0; i < this.modelEtiquetas.getRowCount(); ++i) {
                Tubo tubo = (Tubo)this.modelEtiquetas.getValueAt(i, 2);
                if (!tubo.isMarcado()) continue;
                tubo.removido = true;
                TuboDao.gravarTubo(tubo, tubo.getEstante());
                ++qtdeRemovida;
            }
            if (qtdeRemovida > 0) {
                if (bean != null) {
                    service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, null);
                }
                Conexao.arquivaSQL();
                Funcoes.mensagem(null, "Tubos removidos da soroteca com sucesso.", 5);
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            } else {
                Funcoes.mensagem(null, "Nenhum tubo removido.", 2);
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel retirar tudos da solicita\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 3 || this.getStatus() == 2;
        this.textEtiqueta.setEnabled(enabled && this.solicitacaoBean == null);
        this.buttonOk.setEnabled(enabled && this.solicitacaoBean == null);
        this.buttonSolicitacao.setEnabled(enabled && this.solicitacaoBean == null && !this.tuboAvulsoAdicionado);
        this.textSolicitacao.setEnabled(enabled && this.solicitacaoBean == null && !this.tuboAvulsoAdicionado);
        this.tableEtiquetas.setEnabled(enabled);
        this.panelSoroteca.setEnabled(enabled);
    }

    private void limparCampos() {
        this.textEtiqueta.clear();
        this.textSolicitacao.clear();
        this.labelVlrUsuario.setText("");
        this.labelVlrData.setText("");
        this.labelVlrSetor.setText("");
        this.labelDescSetor.setText("");
        this.modelEtiquetas.clear();
        this.panelSoroteca.limpar();
        this.solicitacaoBean = null;
        this.tuboAvulsoAdicionado = false;
    }

    private void limpar() {
        this.labelVlrUsuario.setText("");
        this.labelVlrData.setText("");
        this.labelVlrSetor.setText("");
        this.labelDescSetor.setText("");
        this.modelEtiquetas.clear();
        this.modelEtiquetasRemovidas.clear();
        this.panelSoroteca.limpar();
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

