/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.soroteca.util.Exame;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.laboratorio.util.impressao.ImprimirIdentificacaoEstante;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.vo.cadastro.triagem.EstanteVO;
import jalis.service.cadastro.triagem.EstanteService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DescarteEstante
extends FrmCadPadraoBean {
    private JButton buttonEstante = new JButton();
    private JLabel labelCodGeladeira = new JLabel();
    private JLabel labelDescGeladeira = new JLabel();
    private JLabel labelEstante = new JLabel();
    private JLabel labelDescEstante = new JLabel();
    private JLabel labelDescPrateleira = new JLabel();
    private JLabel labelGeladeira = new JLabel();
    private JLabel labelPrateleira = new JLabel();
    private JLabel labelNovoIdentificador = new JLabel("Novo identificador:");
    private JLabel labelIdentificacaoEstante = new JLabel("Identifica\u00e7\u00e3o Estante:");
    private TTextField textEstante = new TTextField(5, 1);
    private TTextField textIdentificador = new TTextField(10, 3);
    private TTextField textIdentificacaoEstante = new TTextField(ImprimirIdentificacaoEstante.getDigitosEstanteFilial() + ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira() + ImprimirIdentificacaoEstante.getDigitosEstanteCodigo(), 1);
    private JPanel panelNovaEstante = new JPanel(new GridBagLayout());
    private JPanel panelIdentificacaoEstante = new JPanel(new GridBagLayout());
    private EstanteBean estante = null;

    public DescarteEstante() {
        this.setLabelFormulario("Descarte de Estantes");
        this.setLabelDescricao("Descarte de estantes com tubos vencidos");
        this.setIcone(ImagemUtils.carregaImagemJalis("triagem/descarte_estantes.jpg"));
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.buttonEstante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstanteBean estanteAux = DescarteEstante.this.pesquisaEstantes(null);
                if (estanteAux != null) {
                    DescarteEstante.this.estante = estanteAux;
                    DescarteEstante.this.preencherCampos(DescarteEstante.this.estante);
                    DescarteEstante.this.controlaCampos();
                }
            }
        });
        this.textIdentificacaoEstante.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(DescarteEstante.this.textIdentificacaoEstante)) {
                    int digCodigo;
                    int digGeladeira;
                    int digFilial = ImprimirIdentificacaoEstante.getDigitosEstanteFilial();
                    int digTotal = digFilial + (digGeladeira = ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira()) + (digCodigo = ImprimirIdentificacaoEstante.getDigitosEstanteCodigo());
                    if (digTotal == DescarteEstante.this.textIdentificacaoEstante.getText().length()) {
                        int filial = Integer.valueOf(DescarteEstante.this.textIdentificacaoEstante.getText().substring(0, digFilial));
                        String codGeladeira = DescarteEstante.this.textIdentificacaoEstante.getText().substring(digFilial, digFilial + digGeladeira);
                        String codEstante = DescarteEstante.this.textIdentificacaoEstante.getText().substring(digFilial + digGeladeira);
                        if (filial != Integer.parseInt(Variaveis.filialPadrao)) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel carregar os dados de uma estante de outra filial.", 2);
                            return;
                        }
                        EstanteBean estanteAux = DescarteEstante.this.pesquisaEstantes(codEstante);
                        if (estanteAux != null && estanteAux.getGeladeira().getCodigo() != Integer.parseInt(codGeladeira)) {
                            Funcoes.mensagem(DescarteEstante.this, "A etiqueta informada est\u00e1 desatualizada.\nImprima a nova etiqueta da estante.", 2);
                            DescarteEstante.this.limparCampos();
                            DescarteEstante.this.controlaCampos();
                            ScreenUtil.requisitarFoco(DescarteEstante.this.textIdentificacaoEstante);
                            return;
                        }
                        if (estanteAux != null) {
                            DescarteEstante.this.estante = estanteAux;
                            DescarteEstante.this.preencherCampos(DescarteEstante.this.estante);
                            DescarteEstante.this.controlaCampos();
                        } else {
                            DescarteEstante.this.labelDescEstante.setText("N\u00e3o cadastrado");
                        }
                    } else {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "A identifica\u00e7\u00e3o da estante \u00e9 inv\u00e1lida.", 2);
                        return;
                    }
                }
            }
        });
        this.textEstante.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(DescarteEstante.this.textEstante.getText())) {
                    EstanteBean estanteAux = DescarteEstante.this.pesquisaEstantes(DescarteEstante.this.textEstante.getText());
                    if (estanteAux != null) {
                        DescarteEstante.this.estante = estanteAux;
                        DescarteEstante.this.preencherCampos(DescarteEstante.this.estante);
                        DescarteEstante.this.controlaCampos();
                    } else {
                        DescarteEstante.this.labelDescEstante.setText("N\u00e3o cadastrado");
                    }
                }
            }
        });
        this.textEstante.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    DescarteEstante.this.buttonEstante.doClick();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.labelIdentificacaoEstante.setText("Identifica\u00e7\u00e3o Estante:");
        this.panelIdentificacaoEstante.add((Component)this.labelIdentificacaoEstante, c);
        ++c.gridx;
        this.textIdentificacaoEstante.setPreferredSize(new Dimension(90, 20));
        this.textIdentificacaoEstante.setMinimumSize(new Dimension(90, 20));
        this.panelIdentificacaoEstante.add((Component)this.textIdentificacaoEstante, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelIdentificacaoEstante.add((Component)new JLabel(), c);
        this.painelCentral.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 6;
        c.anchor = 17;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelIdentificacaoEstante, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        this.panelNovaEstante.add((Component)this.labelNovoIdentificador, c);
        ++c.gridx;
        this.textIdentificador.setPreferredSize(new Dimension(120, 20));
        this.textIdentificador.setMinimumSize(new Dimension(120, 20));
        this.panelNovaEstante.add((Component)this.textIdentificador, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelNovaEstante.add((Component)new JLabel(), c);
        this.labelEstante.setText("Estante:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.labelEstante, c);
        this.textEstante.setMinimumSize(new Dimension(60, 20));
        this.textEstante.setPreferredSize(new Dimension(60, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.textEstante, c);
        this.buttonEstante.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstante);
        this.buttonEstante.setMinimumSize(new Dimension(20, 20));
        this.buttonEstante.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.buttonEstante, c);
        this.labelDescEstante.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescEstante.setMinimumSize(new Dimension(20, 20));
        this.labelDescEstante.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 4;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(1, 0, 0, 0);
        this.painelCentral.add((Component)this.labelDescEstante, c);
        this.labelGeladeira.setText("Geladeira:");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        this.painelCentral.add((Component)this.labelGeladeira, c);
        this.labelCodGeladeira.setBorder(BorderFactory.createTitledBorder(""));
        this.labelCodGeladeira.setMinimumSize(new Dimension(20, 20));
        this.labelCodGeladeira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 17;
        this.painelCentral.add((Component)this.labelCodGeladeira, c);
        this.labelDescGeladeira.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescGeladeira.setMinimumSize(new Dimension(20, 20));
        this.labelDescGeladeira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.labelDescGeladeira, c);
        JPanel aux = new JPanel();
        aux.setMinimumSize(new Dimension(20, 20));
        aux.setPreferredSize(new Dimension(20, 20));
        c.gridx += 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.painelCentral.add((Component)aux, c);
        this.labelPrateleira.setText("Prateleira:");
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 2;
        c.anchor = 17;
        this.painelCentral.add((Component)this.labelPrateleira, c);
        this.labelDescPrateleira.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescPrateleira.setMinimumSize(new Dimension(20, 20));
        this.labelDescPrateleira.setPreferredSize(new Dimension(20, 20));
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.labelDescPrateleira, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 7;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.panelNovaEstante.setBorder(BorderFactory.createTitledBorder("Nova estante"));
        this.painelCentral.add((Component)this.panelNovaEstante, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 7;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.painelCentral.add((Component)new JLabel(), c);
        this.panelNovaEstante.setVisible(false);
        this.controlaCampos();
    }

    private EstanteBean pesquisaEstantes(String codigoEstante) {
        EstanteVO estanteAux = new EstanteVO();
        try {
            if (codigoEstante == null) {
                ArrayList<String> filtros = new ArrayList<String>();
                filtros.add(" gel_codigo is not null ");
                filtros.add(" gpa_codigo is not null ");
                estanteAux = (EstanteVO)new EstanteService().pesquisaVO(Laboratorio.getInstancia(), estanteAux, "Pesquisando Estantes", false, filtros);
                if (estanteAux != null) {
                    return (EstanteBean)new EstanteService().get(Variaveis.filialPadrao, estanteAux.getCodigo().toString());
                }
                return null;
            }
            EstanteBean bean = (EstanteBean)new EstanteService().get(Variaveis.filialPadrao, codigoEstante);
            if (bean == null || bean.getGeladeira() == null || bean.getPrateleira() == null) {
                return null;
            }
            return (EstanteBean)new EstanteService().get(Variaveis.filialPadrao, codigoEstante);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da estante.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    @Override
    protected void controlaCampos() {
        boolean habilita = this.getStatus() == 2;
        this.textEstante.setEnabled(habilita && this.estante == null);
        this.buttonEstante.setEnabled(habilita && this.estante == null);
        this.textIdentificacaoEstante.setEnabled(habilita && this.estante == null);
    }

    @Override
    protected void limparCampos() {
        this.textEstante.clear();
        this.labelDescEstante.setText("");
        this.labelCodGeladeira.setText("");
        this.labelDescGeladeira.setText("");
        this.labelDescPrateleira.setText("");
        this.textIdentificacaoEstante.clear();
        this.panelNovaEstante.setVisible(false);
        this.estante = null;
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textIdentificacaoEstante);
        this.setStatus(2);
    }

    @Override
    public void salvar() {
        EstanteBean bean;
        EstanteService service = new EstanteService();
        if (this.validaCampos() && (bean = (EstanteBean)this.getBeanPreenchido()) != null) {
            try {
                service.descartarEstante(bean, Variaveis.filialPadrao, this.textIdentificador.getText());
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel descartar a estante.\n" + e.getMessage(), 2);
            }
        }
    }

    @Override
    public void cancelar() {
        super.cancelar();
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaCampos() {
        if (this.estante == null) {
            return false;
        }
        SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
        janelaEspera.mostrar("Verificando tubos - 0%");
        try {
            int resp;
            List<Tubo> tubos = TuboDao.carregaTubosEstante(Integer.parseInt(Variaveis.filialPadrao), this.estante.getCodigo(), janelaEspera, true);
            StringBuilder buf = new StringBuilder();
            if (tubos != null && tubos.size() > 0) {
                for (Tubo tubo : tubos) {
                    Iterator<Exame> it = tubo.getExames().iterator();
                    ArrayList<Exame> descricaoExamesSemResultado = new ArrayList<Exame>();
                    while (it.hasNext()) {
                        Exame exame = it.next();
                        if (!Funcoes.textoVazio(exame.getSituacao())) continue;
                        boolean podeAdicionarExame = true;
                        for (Exame ex : descricaoExamesSemResultado) {
                            if (!ex.getCodigo().equals(exame.getCodigo()) || ex.getCodigoMaterial() != exame.getCodigoMaterial()) continue;
                            podeAdicionarExame = false;
                            break;
                        }
                        if (!podeAdicionarExame) continue;
                        descricaoExamesSemResultado.add(exame);
                    }
                    if (descricaoExamesSemResultado.size() <= 0) continue;
                    if (buf.length() == 0) {
                        buf.append("H\u00e1 exames sem resultado:\n ");
                    }
                    for (int i = 0; i < descricaoExamesSemResultado.size(); ++i) {
                        buf.append("Etiqueta: <font color = red>\"").append(tubo.getEtiqueta());
                        buf.append(" - ");
                        buf.append(((Exame)descricaoExamesSemResultado.get(i)).getDescricao()).append("\"</font>\n");
                    }
                }
            }
            if ((resp = Funcoes.mensagem(Laboratorio.getInstancia(), buf.toString() + "Deseja descartar a estante?", 4)) == 1) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificando situa\u00e7\u00e3o dos tubos da estante.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            janelaEspera.apagar();
        }
        if (this.estante.getReutilizar().booleanValue() && Funcoes.textoVazio(this.textIdentificador)) {
            Funcoes.mensagem(this, "O identificador da nova estante deve ser inserido.", 2);
            return false;
        }
        if (janelaEspera != null) {
            janelaEspera.apagar();
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0300900400");
    }

    @Override
    @Deprecated
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        if (this.estante != null) {
            return this.estante;
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean == null || !(bean instanceof EstanteBean)) {
            return;
        }
        EstanteBean estBean = (EstanteBean)bean;
        this.textEstante.setText(estBean.getCodigo().toString());
        this.labelDescEstante.setText(estBean.getIdentificador());
        this.labelCodGeladeira.setText(estBean.getGeladeira().getCodigo().toString());
        this.labelDescGeladeira.setText(estBean.getGeladeira().getDescricao());
        this.labelDescPrateleira.setText(estBean.getPrateleira().getCodigo().toString());
        if (estBean.getReutilizar().booleanValue()) {
            this.panelNovaEstante.setVisible(true);
            this.textIdentificador.setText(estBean.getIdentificador());
            this.textIdentificador.selectAll();
            ScreenUtil.requisitarFoco(this.textIdentificador);
        }
        int digFilial = ImprimirIdentificacaoEstante.getDigitosEstanteFilial();
        int digGeladeira = ImprimirIdentificacaoEstante.getDigitosEstanteGeladeira();
        int digCodigo = ImprimirIdentificacaoEstante.getDigitosEstanteCodigo();
        String filial = Variaveis.filialPadrao;
        String geladeira = String.valueOf(estBean.getGeladeira().getCodigo());
        String estante = String.valueOf(estBean.getCodigo());
        filial = StringUtil.preencheString(filial, digFilial, '0', 1);
        geladeira = StringUtil.preencheString(geladeira, digGeladeira, '0', 1);
        estante = StringUtil.preencheString(estante, digCodigo, '0', 1);
        this.textIdentificacaoEstante.setText(filial + geladeira + estante);
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

