/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.soroteca;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.triagem.BanhoMariaBean;
import jalis.model.bean.triagem.BanhoMariaTemperaturaBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.triagem.BanhoMariaVO;
import jalis.service.cadastro.triagem.BanhoMariaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class BanhoMariaTemperatura
extends FrmCadPadraoBean {
    private JLabel labelBanhoMaria = new JLabel("Banho-Maria:");
    private TTextField textCodigoBanhoMaria = new TTextField(5, 1);
    private JLabel labelDescricaoBanhoMaria = new JLabel();
    private JButton buttonBuscaBanhoMaria = new JButton();
    private JPanel panelObservacao = new JPanel(new GridBagLayout());
    private JPanel panelTemperaturas = new JPanel(new GridBagLayout());
    private ModeloGridTable modelTemperaturas;
    private JTable tableTemperaturas;
    private JScrollPane scrollTemperaturas;
    private JLabel labelHora = new JLabel("Hora:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelTemperatura = new JLabel("Temperatura:");
    private JLabel labelTemperaturaMinima = new JLabel("M\u00ednima:");
    private JLabel labelTemperaturaMaxima = new JLabel("M\u00e1xima:");
    private TTextField textTemperatura = new TTextField(10, 2, 3);
    private TTextField textTemperaturaMinima = new TTextField(10, 2, 3);
    private TTextField textTemperaturaMaxima = new TTextField(10, 2, 3);
    private TTextField textDataTemperatura = new TTextField(10, 4);
    private TTextField textHoraTemperatura = new TTextField(5, 6);
    private JButton buttonDataTemperatura = new JButton();
    private JButton buttonAdicionarTemperatura = new JButton("OK");
    private JTextArea areaObservacao = new JTextArea(new TTextAreaDocument(1000));
    private JScrollPane scrollObservacao = new JScrollPane(this.areaObservacao);
    private BanhoMariaService banhoMariaService = new BanhoMariaService();
    private ArrayList<BanhoMariaTemperaturaBean> temperaturas;
    private BanhoMariaBean banhoMariaAux = null;
    private String retornoParaPesquisa = "";
    private final int COLUNA_OBJETO = 6;

    public BanhoMariaTemperatura() {
        this.setLabelFormulario("Banhos-Maria");
        this.setLabelDescricao("Registro de controle de temperaturas de banhos-maria");
        this.setIcone(ImagemUtils.carregaImagemJalis("triagem/temperatura_banho-maria.jpg"));
        Dimension d = new Dimension(80, 20);
        this.textCodigoBanhoMaria.setPreferredSize(d);
        this.textCodigoBanhoMaria.setMinimumSize(d);
        this.textCodigoBanhoMaria.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                BanhoMariaTemperatura.this.buscaBanhoMaria(BanhoMariaTemperatura.this.textCodigoBanhoMaria.getText());
                BanhoMariaTemperatura.this.controlaCampos();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BanhoMariaTemperatura.this.banhoMariaAux != null) {
                            ScreenUtil.requisitarFoco(BanhoMariaTemperatura.this.textDataTemperatura);
                        } else {
                            ScreenUtil.requisitarFoco(BanhoMariaTemperatura.this.textCodigoBanhoMaria);
                        }
                    }
                });
            }
        });
        this.buttonBuscaBanhoMaria.setFocusable(false);
        this.buttonBuscaBanhoMaria.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaBanhoMaria.setPreferredSize(d);
        this.buttonBuscaBanhoMaria.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaBanhoMaria);
        this.buttonBuscaBanhoMaria.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BanhoMariaTemperatura.this.buscaBanhoMaria();
                BanhoMariaTemperatura.this.controlaCampos();
            }
        });
        d = new Dimension(20, 20);
        this.labelDescricaoBanhoMaria.setPreferredSize(d);
        this.labelDescricaoBanhoMaria.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        d = new Dimension(70, 20);
        this.textDataTemperatura.setPreferredSize(d);
        this.textDataTemperatura.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.buttonDataTemperatura.setPreferredSize(d);
        this.buttonDataTemperatura.setMinimumSize(d);
        this.buttonDataTemperatura.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataTemperatura);
        this.buttonDataTemperatura.setFocusable(false);
        this.buttonDataTemperatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BanhoMariaTemperatura.this.buscaDataTemperatura();
            }
        });
        d = new Dimension(50, 20);
        this.textHoraTemperatura.setPreferredSize(d);
        this.textHoraTemperatura.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.textTemperatura.setPreferredSize(d);
        this.textTemperatura.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.textTemperaturaMinima.setPreferredSize(d);
        this.textTemperaturaMinima.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.textTemperaturaMaxima.setPreferredSize(d);
        this.textTemperaturaMaxima.setMinimumSize(d);
        this.buttonAdicionarTemperatura.setMnemonic('O');
        d = new Dimension(30, 20);
        this.buttonAdicionarTemperatura.setPreferredSize(d);
        this.buttonAdicionarTemperatura.setMinimumSize(d);
        this.buttonAdicionarTemperatura.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarTemperatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BanhoMariaTemperatura.this.adicionarTemperatura();
            }
        });
        this.panelTemperaturas.setBorder(new TitledBorder("Temperaturas do banho-maria"));
        this.modelTemperaturas = new ModeloGridTable(new String[]{"Data/Hora", "Temperatura", "M\u00ednima", "M\u00e1xima", "Usu\u00e1rio", "Observa\u00e7\u00e3o"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.tableTemperaturas = new JTable(this.modelTemperaturas);
        this.tableTemperaturas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    BanhoMariaTemperatura.this.removerTemperatura();
                } else if (e.getKeyCode() == 32) {
                    BanhoMariaTemperatura.this.alterarTemperatura();
                }
            }
        });
        this.tableTemperaturas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BanhoMariaTemperatura.this.alterarTemperatura();
                }
            }
        });
        this.modelTemperaturas.setColumnSize(new int[]{120, 100, 70, 70, 100, 0}, this.tableTemperaturas);
        this.tableTemperaturas.getTableHeader().addMouseListener(this.modelTemperaturas);
        this.scrollTemperaturas = new JScrollPane(this.tableTemperaturas);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        c.gridwidth = 1;
        this.labelBanhoMaria.setDisplayedMnemonic('G');
        this.labelBanhoMaria.setLabelFor(this.textCodigoBanhoMaria);
        this.painelCentral.add((Component)this.labelBanhoMaria, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoBanhoMaria, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaBanhoMaria, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        ScreenUtil.setBorda(new JComponent[]{this.labelDescricaoBanhoMaria}, new TitledBorder(""));
        this.painelCentral.add((Component)this.labelDescricaoBanhoMaria, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)this.panelTemperaturas, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        this.labelData.setDisplayedMnemonic('D');
        this.labelData.setLabelFor(this.textDataTemperatura);
        this.panelTemperaturas.add((Component)this.labelData, c);
        ++c.gridx;
        this.panelTemperaturas.add((Component)this.textDataTemperatura, c);
        ++c.gridx;
        this.panelTemperaturas.add((Component)this.buttonDataTemperatura, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.labelHora.setDisplayedMnemonic('H');
        this.labelHora.setLabelFor(this.textHoraTemperatura);
        this.panelTemperaturas.add((Component)this.labelHora, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.panelTemperaturas.add((Component)this.textHoraTemperatura, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.labelTemperatura.setDisplayedMnemonic('T');
        this.labelTemperatura.setLabelFor(this.textTemperatura);
        this.panelTemperaturas.add((Component)this.labelTemperatura, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.panelTemperaturas.add((Component)this.textTemperatura, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.labelTemperaturaMinima.setDisplayedMnemonic('M');
        this.labelTemperaturaMinima.setLabelFor(this.textTemperaturaMinima);
        this.panelTemperaturas.add((Component)this.labelTemperaturaMinima, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.panelTemperaturas.add((Component)this.textTemperaturaMinima, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.labelTemperaturaMaxima.setDisplayedMnemonic('x');
        this.labelTemperaturaMaxima.setLabelFor(this.textTemperaturaMaxima);
        this.panelTemperaturas.add((Component)this.labelTemperaturaMaxima, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.panelTemperaturas.add((Component)this.textTemperaturaMaxima, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 11;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.panelTemperaturas.add((Component)this.panelObservacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 11;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelTemperaturas.add((Component)this.scrollTemperaturas, c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 16;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 1.0;
        c.fill = 2;
        this.areaObservacao.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.areaObservacao);
        this.scrollObservacao.setMinimumSize(new Dimension(20, 50));
        this.scrollObservacao.setPreferredSize(new Dimension(20, 50));
        this.panelObservacao.add((Component)this.scrollObservacao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.panelObservacao.add((Component)this.buttonAdicionarTemperatura, c);
        this.service = this.banhoMariaService;
        this.controlaCampos();
        this.modelTemperaturas.ordenarColuna(0, 1);
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(BanhoMariaTemperatura.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0300901201"));
        this.setModuloApaga(Long.parseLong("0300901202"));
        this.setModuloEdita(Long.parseLong("0300901203"));
    }

    @Override
    protected void controlaCampos() {
        boolean statusOk = this.getStatus() == 3 || this.getStatus() == 2;
        boolean ativarBanhoMaria = statusOk && this.banhoMariaAux == null;
        this.textCodigoBanhoMaria.setEnabled(ativarBanhoMaria);
        this.buttonBuscaBanhoMaria.setEnabled(ativarBanhoMaria);
        boolean ativarCampos = statusOk && this.banhoMariaAux != null;
        this.buttonDataTemperatura.setEnabled(ativarCampos);
        this.buttonAdicionarTemperatura.setEnabled(ativarCampos);
        this.textHoraTemperatura.setEnabled(ativarCampos);
        this.textDataTemperatura.setEnabled(ativarCampos);
        this.textTemperatura.setEnabled(ativarCampos);
        this.textTemperaturaMinima.setEnabled(ativarCampos);
        this.textTemperaturaMaxima.setEnabled(ativarCampos);
        this.areaObservacao.setEnabled(ativarCampos);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        this.banhoMariaAux.setTemperaturas(new HashSet<BanhoMariaTemperaturaBean>(this.temperaturas));
        return this.banhoMariaAux;
    }

    @Override
    protected void limparCampos() {
        this.textCodigoBanhoMaria.setText("");
        this.labelDescricaoBanhoMaria.setText("");
        this.textHoraTemperatura.setText("");
        this.textDataTemperatura.setText("");
        this.textTemperatura.setText("");
        this.textTemperaturaMinima.setText("");
        this.textTemperaturaMaxima.setText("");
        this.areaObservacao.setText("");
        this.temperaturas = null;
        this.limparTemperaturas();
        this.banhoMariaAux = null;
    }

    @Override
    @Deprecated
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        BanhoMariaBean banhoMariaBean = (BanhoMariaBean)bean;
        this.textCodigoBanhoMaria.setText(Integer.toString(banhoMariaBean.getCodigo()));
        this.labelDescricaoBanhoMaria.setText(banhoMariaBean.getDescricao());
        this.temperaturas = new ArrayList(banhoMariaBean.getTemperaturas());
        this.limparTemperaturas();
        this.popularTemperaturas();
        this.textCodigoBanhoMaria.setEnabled(false);
        this.buttonBuscaBanhoMaria.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodigoBanhoMaria.getText())) {
            Funcoes.mensagem(this, "Campo banho-maria n\u00e3o est\u00e1 preenchido.", 2);
            return false;
        }
        if (!Funcoes.textoVazio(this.textCodigoBanhoMaria.getText()) && !this.labelDescricaoBanhoMaria.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            if (this.modelTemperaturas.getRowCount() > 0) {
                return true;
            }
            Funcoes.mensagem(this, "Pelo menos uma temperatura deve ser informada.", 2);
            return false;
        }
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0300901200");
    }

    private void buscaBanhoMaria(String codigo) {
        this.temperaturas = null;
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoBanhoMaria.setText("");
            this.labelDescricaoBanhoMaria.setText("");
            this.banhoMariaAux = null;
            return;
        }
        try {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("ban_codigo", codigo);
            this.banhoMariaAux = (BanhoMariaBean)new BanhoMariaService().getBean(chaves, true);
            if (this.banhoMariaAux != null) {
                if (this.banhoMariaAux.getInativo().booleanValue()) {
                    Funcoes.mensagem(this, "O banho-maria est\u00e1 inativa.", 2);
                    this.labelDescricaoBanhoMaria.setText("N\u00e3o cadastrado");
                    this.buttonAdicionarTemperatura.setEnabled(false);
                    this.textCodigoBanhoMaria.clear();
                    if (this.textCodigoBanhoMaria.isEnabled() && this.textCodigoBanhoMaria.isFocusable()) {
                        ScreenUtil.requisitarFoco(this.textCodigoBanhoMaria);
                    }
                    return;
                }
                this.labelDescricaoBanhoMaria.setText(this.banhoMariaAux.getDescricao());
                this.temperaturas = new ArrayList(this.banhoMariaAux.getTemperaturas());
                this.limparTemperaturas();
                this.popularTemperaturas();
                this.textCodigoBanhoMaria.setEnabled(false);
                this.buttonBuscaBanhoMaria.setEnabled(false);
                this.buttonAdicionarTemperatura.setEnabled(true);
                this.modelTemperaturas.ordenarColuna(0, -1);
            } else {
                this.labelDescricaoBanhoMaria.setText("N\u00e3o cadastrado");
                this.buttonAdicionarTemperatura.setEnabled(false);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void buscaBanhoMaria() {
        try {
            this.textCodigoBanhoMaria.setText("");
            this.labelDescricaoBanhoMaria.setText("");
            this.temperaturas = null;
            BanhoMariaVO vo = (BanhoMariaVO)this.banhoMariaService.pesquisaAtivosVO(Laboratorio.getInstancia(), new BanhoMariaVO(), "Pesquisando banhos-maria", true);
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("ban_codigo", vo.getCodigo());
                this.banhoMariaAux = (BanhoMariaBean)new BanhoMariaService().getBean(chaves, true);
                this.textCodigoBanhoMaria.setText(this.banhoMariaAux.getCodigo().toString());
                this.labelDescricaoBanhoMaria.setText(this.banhoMariaAux.getDescricao());
                this.temperaturas = new ArrayList(this.banhoMariaAux.getTemperaturas());
                this.limparTemperaturas();
                this.popularTemperaturas();
                this.textCodigoBanhoMaria.setEnabled(false);
                this.buttonBuscaBanhoMaria.setEnabled(false);
                this.buttonAdicionarTemperatura.setEnabled(true);
                ScreenUtil.requisitarFoco(this.textDataTemperatura);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void adicionarTemperatura() {
        if (this.temperaturas == null) {
            this.temperaturas = new ArrayList();
        }
        if (Funcoes.textoVazio(this.textCodigoBanhoMaria.getText()) || this.labelDescricaoBanhoMaria.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Banho-Maria n\u00e3o selecionado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoBanhoMaria);
            return;
        }
        if (Funcoes.textoVazio(this.textDataTemperatura)) {
            Funcoes.mensagem(this, "Data n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataTemperatura);
            return;
        }
        if (Funcoes.textoVazio(this.textHoraTemperatura)) {
            Funcoes.mensagem(this, "Hora n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textHoraTemperatura);
            return;
        }
        String t = this.textTemperatura.getText();
        String tMin = this.textTemperaturaMinima.getText();
        String tMax = this.textTemperaturaMaxima.getText();
        Double dT = null;
        Double dMin = null;
        Double dMax = null;
        if (!Funcoes.textoVazio(t)) {
            dT = new Double(Double.parseDouble(t));
        }
        if (!Funcoes.textoVazio(tMin)) {
            dMin = new Double(Double.parseDouble(tMin));
        }
        if (!Funcoes.textoVazio(tMin)) {
            dMax = new Double(Double.parseDouble(tMax));
        }
        if (dMin != null && dMax != null && dMin > dMax) {
            Funcoes.mensagem(this, "A temperatura m\u00ednima n\u00e3o pode ser maior que a m\u00e1xima.", 2);
            ScreenUtil.requisitarFoco(this.textTemperaturaMinima);
            return;
        }
        if (dT != null && dMin != null && dMin > dT || dMax != null && dMax < dT) {
            Funcoes.mensagem(this, "A temperatura deve estar no intervalo entre a m\u00ednima e a m\u00e1xima.", 2);
            ScreenUtil.requisitarFoco(this.textTemperatura);
            return;
        }
        boolean alteracao = false;
        BanhoMariaTemperaturaBean temperatura = new BanhoMariaTemperaturaBean();
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        temperatura.setUsuario(usuario);
        t = this.textDataTemperatura.getText() + " " + this.textHoraTemperatura.getText() + ":00";
        Date d = Funcoes.stringToDate("dd/MM/yyyy HH:mm:ss", t);
        if (this.temperaturas.size() > 0) {
            for (int i = 0; i < this.temperaturas.size(); ++i) {
                BanhoMariaTemperaturaBean gt = this.temperaturas.get(i);
                String data = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", gt.getDataHora());
                if (t.equalsIgnoreCase(data) && this.textDataTemperatura.isEnabled() && !gt.isRemover()) {
                    Funcoes.mensagem(this, "J\u00e1 existe uma temperatura para essa data/hora.", 2);
                    ScreenUtil.requisitarFoco(this.textDataTemperatura);
                    return;
                }
                if (!t.equalsIgnoreCase(data) || this.textDataTemperatura.isEnabled()) continue;
                alteracao = true;
                temperatura = gt;
                break;
            }
        }
        temperatura.setDataHora(d);
        temperatura.setTemperatura(dT);
        temperatura.setTemperaturaMinima(dMin);
        temperatura.setTemperaturaMaxima(dMax);
        temperatura.setObservacao(this.areaObservacao.getText().length() > 0 ? this.areaObservacao.getText() : null);
        if (alteracao) {
            temperatura.setAlterar(true);
        } else {
            temperatura.setInserir(true);
            this.temperaturas.add(temperatura);
        }
        this.limparTemperaturas();
        this.popularTemperaturas();
        this.textDataTemperatura.setText("");
        this.textHoraTemperatura.setText("");
        this.textTemperatura.setText("");
        this.textTemperaturaMinima.setText("");
        this.textTemperaturaMaxima.setText("");
        this.areaObservacao.setText("");
        this.textDataTemperatura.setEnabled(true);
        this.textHoraTemperatura.setEnabled(true);
        ScreenUtil.requisitarFoco(this.textDataTemperatura);
    }

    private void removerTemperatura() {
        if (this.tableTemperaturas.getSelectedRowCount() > 0 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            int row = this.tableTemperaturas.getSelectedRow();
            BanhoMariaTemperaturaBean gtb = (BanhoMariaTemperaturaBean)this.modelTemperaturas.getValueAt(row, 6);
            if (gtb.isInserir()) {
                this.temperaturas.remove(row);
                this.modelTemperaturas.removeLine(row);
            } else {
                gtb.setRemover(true);
                for (int i = 0; i < this.modelTemperaturas.getRowCount(); ++i) {
                    if (this.modelTemperaturas.getValueAt(i, 6) != gtb) continue;
                    this.modelTemperaturas.removeLine(i);
                    break;
                }
            }
            if (this.textDataTemperatura.isEnabled() && this.textDataTemperatura.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textDataTemperatura);
            }
        }
    }

    private void alterarTemperatura() {
        if (this.tableTemperaturas.getSelectedRowCount() > 0) {
            int row = this.tableTemperaturas.getSelectedRow();
            BanhoMariaTemperaturaBean gtb = (BanhoMariaTemperaturaBean)this.modelTemperaturas.getValueAt(row, 6);
            this.textDataTemperatura.setText(Funcoes.formataData("dd/MM/yyyy", gtb.getDataHora()));
            this.textHoraTemperatura.setText(Funcoes.formataData("HH:mm", gtb.getDataHora()));
            if (gtb.getTemperatura() != null) {
                this.textTemperatura.setText(Funcoes.formataDecimal(this.textTemperatura.getMaskDecimal(), gtb.getTemperatura()));
            }
            if (gtb.getTemperaturaMinima() != null) {
                this.textTemperaturaMinima.setText(Funcoes.formataDecimal(this.textTemperaturaMinima.getMaskDecimal(), gtb.getTemperaturaMinima()));
            }
            if (gtb.getTemperaturaMaxima() != null) {
                this.textTemperaturaMaxima.setText(Funcoes.formataDecimal(this.textTemperaturaMaxima.getMaskDecimal(), gtb.getTemperaturaMaxima()));
            }
            this.areaObservacao.setText(gtb.getObservacao() == null ? "" : gtb.getObservacao());
            this.textDataTemperatura.setEnabled(false);
            this.textHoraTemperatura.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textTemperatura);
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoBanhoMaria.hasFocus()) {
            this.buscaBanhoMaria();
        } else if (this.textDataTemperatura.hasFocus()) {
            this.buscaDataTemperatura();
        }
    }

    private void buscaDataTemperatura() {
        Funcoes.mostraData(this.textDataTemperatura, this.buttonDataTemperatura, this.panelTemperaturas, true);
    }

    private void limparTemperaturas() {
        this.modelTemperaturas.clear();
    }

    private void popularTemperaturas() {
        if (this.temperaturas == null) {
            return;
        }
        int tamanhoObservacao = 200;
        for (BanhoMariaTemperaturaBean gtb : this.temperaturas) {
            if (gtb.isRemover()) continue;
            this.modelTemperaturas.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", gtb.getDataHora()), gtb.getTemperatura() != null ? Funcoes.formataDecimal(this.textTemperatura.getMaskDecimal(), gtb.getTemperatura()) : "", gtb.getTemperaturaMinima() != null ? Funcoes.formataDecimal(this.textTemperaturaMinima.getMaskDecimal(), gtb.getTemperaturaMinima()) : "", gtb.getTemperaturaMaxima() != null ? Funcoes.formataDecimal(this.textTemperaturaMaxima.getMaskDecimal(), gtb.getTemperaturaMaxima()) : "", gtb.getUsuario().getCodigo(), gtb.getObservacao(), gtb});
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        super.novo();
        ScreenUtil.requisitarFoco(this.textCodigoBanhoMaria);
        this.setStatus(3);
        this.buttonBuscaBanhoMaria.doClick();
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public void salvar() {
        BanhoMariaBean bean;
        BanhoMariaService service = new BanhoMariaService();
        if (this.validaCampos() && (bean = (BanhoMariaBean)this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar as temperaturas do banho-maria.\n" + e.getMessage(), 2);
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ban_codigo";
    }
}

