/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.filial;

import jalis.laboratorio.triagem.filial.ReceberLoteFilial;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.Registro;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;

class RendererRequisicao
extends CorTableCellRenderer {
    RendererRequisicao() {
    }

    public static RendererRequisicao novaInstancia(int ... alinhamentos) {
        RendererRequisicao renderer = new RendererRequisicao();
        for (int i = 0; i < alinhamentos.length; ++i) {
            if (alinhamentos[i] <= -1) continue;
            renderer.setAlinhamentoColuna(i, alinhamentos[i]);
        }
        return renderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ModeloGridTable model = (ModeloGridTable)table.getModel();
        Registro reg = this.ObjToReg(row, model);
        List exames = (List)reg.getValor("listaexames");
        boolean urgente = reg.getBoolean("req_urgente");
        if (exames.size() == 0) {
            this.setToolTipText("Todos os exames foram recebidos");
            this.setBackground(ReceberLoteFilial.COR_REQ_COMPLETA);
        }
        if (urgente) {
            this.setForeground(isSelected ? ScreenUtil.escurecerCor(Color.RED, 40) : Color.RED);
        }
        return this;
    }

    private Registro ObjToReg(int line, ModeloGridTable modReq) {
        Registro reg = new Registro();
        for (int i = 0; i < ReceberLoteFilial.campos.length; ++i) {
            reg.setValor(ReceberLoteFilial.campos[i], modReq.getValueAt(line, i));
        }
        return reg;
    }
}

