/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.filial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.apoio.DescritorCodigoLote;
import jalis.laboratorio.triagem.filial.RendererExame;
import jalis.laboratorio.triagem.filial.RendererRequisicao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.Legenda;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ReceberLoteFilial
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener {
    private JButton buttonBuscaLote = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null, false);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private static final int COLUNA_REQ = 1;
    private static final int COLUNA_EXAMES_EXPORTAR = 4;
    private static final int COLUNA_EXAMES_BACKUP = 5;
    private static final int COLUNA_EXAMES_NAO_EXPORTAR = 6;
    private static final int COLUNA_REQ_CHAVE = 13;
    private static final int COLUNA_SELECAO = 3;
    private static final int COLUNA_CODIGO_REQUISICAO_PAI = 27;
    private static final Color COR_TRANSPORTE = Tipos.COR_TRANSPORTE[0];
    public static final Color COR_REQ_COMPLETA = Color.green;
    private static final String EXA_EXPORTADO = "exr_exportado";
    private static final String LISTA_EXAMES = "listaexames";
    private static final String CODIGO_REQUISICAO_PAI = "codigorequisicaopai";
    private static final String COLUNA_CHAVE = null;
    private String filial;
    private TTextField textRequisicao = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private TTextField textLote = new TTextField(12, 1);
    private JTable tableReq;
    private JTable tableExa;
    private JTable tableOutrosExa;
    private RequisicaoService requisicaoService;
    private ModeloGridTable modReq = new ModeloGridTable(new String[]{"Fil.", "C\u00f3digo", "Paciente"});
    private ModeloResultSet modExa = new ModeloResultSet(new String[]{"C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "#", "etiquetadigitada"}){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }

        public Class getColumnClass(int c) {
            if (c == 3) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }
    };
    private ArrayList<Registro> listaRegistros = new ArrayList();
    private boolean salvandoLote;
    private boolean temExameAReceber = false;
    static String SQL;
    private ModeloResultSet modOutrosExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "Sit.", "exr_situacao");
    private RendererRequisicao rendererReq = RendererRequisicao.novaInstancia(4, 4, -1, 4);
    private RendererExame rendererExa = RendererExame.novaInstancia(0, -1, 0, 0);
    private CorTableCellRenderer rendererOutrosExa = CorTableCellRenderer.novaInstancia(0, -1, 0, 0);
    protected static final String[] campos;

    public ReceberLoteFilial() {
        this.iniciar();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0301200200");
    }

    private void iniciar() {
        this.requisicaoService = new RequisicaoService();
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Receber Lote", "Receber Lote de Exames para Filial", "triagem/receber_lote_filial.jpg");
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(null, null, null, ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonSalvar, this.buttonCancelar, this.buttonFechar), null), "South");
        JPanel panelAux = new JPanel(new BorderLayout());
        this.add((Component)panelAux, "Center");
        this.tableReq = ComponenteFactory.novoJTable((TableModel)this.modReq, (ListSelectionListener)this, this.rendererReq, 40, 80, 0);
        this.tableReq.setDefaultRenderer(String.class, this.rendererReq);
        this.tableReq.setDefaultRenderer(Number.class, this.rendererReq);
        this.modReq.setColumnSize(new int[]{40, 80, 0}, this.tableReq);
        this.tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, 60, 0, 60, 40);
        this.tableExa.setDefaultRenderer(String.class, this.rendererExa);
        this.modExa.setTamanhoColunas(this.tableExa, 60, 0, 40, 28);
        this.tableOutrosExa = ComponenteFactory.novoJTable((TableModel)this.modOutrosExa, 60, 0, 40, 40);
        this.tableOutrosExa.setDefaultRenderer(String.class, this.rendererOutrosExa);
        JSplitPane splitExames = new JSplitPane(0, ComponenteFactory.novoJPanelBorderLayout("Exames para receber", (Component)new JScrollPane(this.tableExa), null, null, null, null), ComponenteFactory.novoJPanelBorderLayout("Outros exames", (Component)new JScrollPane(this.tableOutrosExa), null, null, null, null));
        splitExames.setResizeWeight(0.5);
        splitExames.setDividerSize(3);
        splitExames.setBorder(null);
        JSplitPane split = new JSplitPane(1, ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", (Component)new JScrollPane(this.tableReq), null, (Component)this.montaPanelLegendaExame(), null, null), splitExames);
        split.setDividerLocation(330);
        split.setDividerSize(3);
        split.setBorder(null);
        panelAux.add((Component)split, "Center");
        JPanel jPanel = panelAux;
        panelAux = new JPanel(new GridBagLayout());
        jPanel.add((Component)panelAux, "North");
        GridBagConstraints cons = new GridBagConstraints();
        panelAux.setBorder(BorderFactory.createEmptyBorder(3, 2, 1, 1));
        cons.gridx = 0;
        cons.gridy = 1;
        panelAux.add((Component)new JLabel("Lote:"), cons);
        cons.gridx = 1;
        cons.insets = new Insets(1, 1, 1, 0);
        this.textLote.setPreferredSize(new Dimension(150, 20));
        panelAux.add((Component)this.textLote, cons);
        cons.gridx = 2;
        cons.insets.left = 0;
        this.buttonBuscaLote.setFocusable(false);
        panelAux.add((Component)this.buttonBuscaLote, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        panelAux.add((Component)new JLabel("Tubo:"), cons);
        cons.gridx = 1;
        cons.insets = new Insets(1, 1, 1, 0);
        this.textRequisicao.setPreferredSize(new Dimension(150, 20));
        panelAux.add((Component)this.textRequisicao, cons);
        cons.gridx = 3;
        cons.gridwidth = 2;
        cons.weightx = 0.5;
        JPanel pen = new JPanel();
        panelAux.add((Component)pen, cons);
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Registro reg;
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)ReceberLoteFilial.this.getRootPane().getGlassPane();
                InfoRequisicao info = new InfoRequisicao((Frame)ReceberLoteFilial.this.getTopLevelAncestor(), glassPaneMensagem);
                if (ReceberLoteFilial.this.salvandoLote && (reg = ReceberLoteFilial.this.objectToReg(ReceberLoteFilial.this.tableReq.getSelectedRow())) != null) {
                    info.setRequisicao(reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                info.setVisible(true);
                ReceberLoteFilial.this.getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
        this.tableReq.addKeyListener(this);
        this.tableExa.addKeyListener(this);
        this.textRequisicao.addKeyListener(this);
        this.textLote.addKeyListener(this);
        this.buttonNovo.addKeyListener(this);
        this.buttonSalvar.addKeyListener(this);
        this.buttonCancelar.addKeyListener(this);
        this.buttonFechar.addKeyListener(this);
        this.habilitarDesabilitarBotoes();
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private JPanel montaPanelLegendaExame() {
        Legenda panelLegenda = new Legenda(10);
        panelLegenda.addItem(COR_REQ_COMPLETA, "Todos os exames recebidos");
        panelLegenda.addItem(Color.RED, "Urgente");
        return panelLegenda.getPanel();
    }

    private void limpar() {
        this.textRequisicao.setText("");
        this.textLote.setText("");
        this.modReq.clear();
        this.modExa.limpar();
        this.modOutrosExa.limpar();
        this.rendererExa.limpar();
        this.rendererReq.limpar();
        this.rendererOutrosExa.limpar();
        this.temExameAReceber = false;
    }

    private void habilitarDesabilitarBotoes() {
        this.textLote.setEnabled(!this.salvandoLote);
        this.buttonBuscaLote.setEnabled(!this.salvandoLote);
        this.textRequisicao.setEnabled(this.salvandoLote && !Funcoes.textoVazio(this.textLote));
        this.buttonNovo.setEnabled(!this.salvandoLote && !this.textLote.isEnabled());
        this.buttonSalvar.setEnabled(this.salvandoLote && this.temExameAReceber);
        this.buttonCancelar.setEnabled(this.salvandoLote);
        this.buttonFechar.setEnabled(!this.salvandoLote);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonBuscaLote) {
            this.pesquisarLote();
        } else if (o == this.buttonCancelar && Funcoes.mensagem(this, "Deseja cancelar a cria\u00e7\u00e3o de lote?", 4) == 0) {
            this.limpar();
            this.salvandoLote = false;
            ScreenUtil.requisitarFoco(this.textLote);
        } else if (o == this.buttonSalvar) {
            boolean gravado = this.gravarLote();
            if (gravado) {
                this.salvandoLote = false;
            }
        } else if (o == this.buttonNovo) {
            this.salvandoLote = false;
        }
        this.habilitarDesabilitarBotoes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean gravarLote() {
        if (this.qtdeExamesSelecionados() == 0) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado.", 2);
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return false;
        }
        SplashMensagem splash = new SplashMensagem();
        splash.mostrar("Salvando...");
        String codigoLote = this.pegaCodigoLote();
        String filial = this.pegaCodigoFilial();
        Statement st = Conexao.getStatement();
        try {
            int i;
            if (!this.atualizarLote(st, filial, codigoLote)) {
                splash.apagar();
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar o lote.", 2);
                boolean bl = false;
                return bl;
            }
            for (i = 0; i < this.modReq.getRowCount(); ++i) {
                Registro requisicao = this.objectToReg(i);
                List exames = (List)requisicao.getValor(LISTA_EXAMES);
                for (Registro regExame : exames) {
                    if (!regExame.getBoolean("etiquetadigitada")) continue;
                    this.atualizaExameRequisicao(st, requisicao, regExame);
                }
            }
            this.arquivaSQL();
            Funcoes.mensagem(this, "Exame(s) recebido(s) com sucesso.", 2);
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            splash.apagar();
            this.limpar();
        }
    }

    private boolean atualizarLote(Statement st, String filial, String codigoLote) throws Exception {
        if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(codigoLote) || st == null) {
            return false;
        }
        StringBuilder bui = new StringBuilder();
        try {
            bui.append("update lotefilial ");
            bui.append("   set lfi_datahorarecebeu = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm", new Date())).append("' ");
            bui.append("      ,usr_codrecebeu = '").append(Variaveis.login).append("' ");
            bui.append(" where fil_codigo = ").append(filial);
            bui.append("   and lfi_codigo = ").append(codigoLote);
            Conexao.execute(Variaveis.filialPadrao, st, bui);
            if (IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
                IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, bui.toString());
            }
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel atualizar o lote.\n" + e.getMessage());
        }
        return true;
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
        }
    }

    private void arquivaSQL() {
        try {
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
        }
    }

    private int qtdeExamesSelecionados() {
        int qtdeExamesSelecionados = 0;
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            Registro req = this.objectToReg(i);
            List exa = (List)req.getValor(LISTA_EXAMES);
            for (Registro registro : exa) {
                if (!registro.getBoolean("etiquetadigitada")) continue;
                ++qtdeExamesSelecionados;
            }
        }
        return qtdeExamesSelecionados;
    }

    private void atualizaExameRequisicao(Statement st, Registro reqRegistro, Registro exaRegistro) throws Exception {
        if (st != null) {
            StringBuilder bui = new StringBuilder();
            try {
                int[] requisicoes = (int[])exaRegistro.getValor("req_codigo");
                String codigosRequisicoes = "";
                for (int aux : requisicoes) {
                    if (!Funcoes.textoVazio(codigosRequisicoes)) {
                        codigosRequisicoes = codigosRequisicoes + ",";
                    }
                    codigosRequisicoes = codigosRequisicoes + String.valueOf(aux);
                }
                bui.setLength(0);
                bui.append(" update examerequisicao ");
                bui.append("    set exr_datatransportechegada = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
                bui.append("       ,usr_codtransportechegada = '").append(Variaveis.login).append("' ");
                bui.append("       ,exr_situacao = '' ");
                bui.append("  where fil_codigo = ").append(reqRegistro.getString("fil_codigo"));
                bui.append("    and req_codigo IN (").append(codigosRequisicoes).append(") ");
                bui.append("    and exa_codigo = '").append(exaRegistro.getString("exa_codigo")).append("' ");
                bui.append("    and mco_codigo = ").append(exaRegistro.getString("mco_codigo"));
                Conexao.execute(Variaveis.filialPadrao, st, bui.toString());
                if (IntegracaoUtil.isFilialParaIntegrar(st, reqRegistro.getString("fil_codigo"))) {
                    IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, reqRegistro.getString("fil_codigo"), bui.toString());
                }
            }
            catch (Exception e) {
                throw new Exception("N\u00e3o foi poss\u00edvel gravar os exames.\n" + e.getMessage());
            }
        }
    }

    private void pesquisarLote() {
        Hashtable resultado = null;
        resultado = Pesquisas.loteFilial(this.getTopLevelAncestor(), false);
        if (resultado != null) {
            StringBuilder bui = new StringBuilder();
            bui.append(StringUtil.preencheString(resultado.get("fil_codigo").toString(), 2, '0', 1));
            bui.append(StringUtil.preencheString(resultado.get("lfi_codigo").toString(), 8, '0', 1));
            this.textLote.setText(bui.toString());
            this.carregarLote();
        }
        ScreenUtil.requisitarFoco(this.textLote);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg;
        this.modExa.limpar();
        this.modOutrosExa.limpar();
        this.rendererExa.limpar();
        this.rendererReq.limpar();
        this.rendererOutrosExa.limpar();
        if (this.tableReq.getSelectedRowCount() == 1 && (reg = this.objectToReg(this.tableReq.getSelectedRow())) != null) {
            this.modExa.addRegistros((Collection)reg.getValor(LISTA_EXAMES));
            this.modOutrosExa.addRegistros((Collection)reg.getValor(campos[6]));
            this.modExa.fireTableDataChanged();
            this.modOutrosExa.fireTableDataChanged();
        }
    }

    private Registro objectToReg(int linha) {
        Registro reg = new Registro();
        for (int i = 0; i < campos.length; ++i) {
            reg.setValor(campos[i], this.modReq.getValueAt(linha, i));
        }
        return reg;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object o = e.getSource();
        if (o == this.textLote && e.getKeyCode() == 10) {
            this.carregarLote();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object o = e.getSource();
        if (o == this.textLote && e.getKeyCode() == 113) {
            this.pesquisarLote();
        } else if (o == this.textRequisicao && (e.getKeyCode() == 10 || e.getKeyChar() == '\t')) {
            this.buscarRequisicaoAoPerdeFoco();
        }
    }

    public void carregarLote() {
        boolean ok = this.carregarLote(this.textLote.getText());
        if (ok) {
            this.salvandoLote = true;
        }
        this.habilitarDesabilitarBotoes();
    }

    private boolean carregarLote(String lote) {
        return this.carregarLote(lote, null);
    }

    private boolean carregarLote(String lote, String codRecipiente) {
        if (Funcoes.textoVazio(lote)) {
            return false;
        }
        if (!Funcoes.textoVazio(lote) && lote.length() < 8) {
            Funcoes.mensagem(this, "Numero do lote \u00e9 composto por (Filial + Lote) Ex. 010000012, Min. 8 digitos", 2);
            this.limpar();
            return false;
        }
        String codigoFilial = this.pegaCodigoFilial();
        String codigoLote = this.pegaCodigoLote();
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        try {
            boolean agruparMultiguia;
            bui.append(" select lfi_codigo ");
            bui.append("   from lotefilial ");
            bui.append("  where lfi_codigo = ").append(codigoLote);
            bui.append("    and fil_codigo = ").append(codigoFilial);
            SQL = bui.toString();
            ResultSet resLote = Conexao.executeQuery(st, SQL);
            if (!resLote.next()) {
                Funcoes.mensagem(this, "O Lote '" + this.textLote.getText() + "' n\u00e3o foi encontrado.", 2);
                this.limpar();
                return false;
            }
            bui.setLength(0);
            bui.append(" select a.fil_codigo ");
            boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || !Funcoes.textoVazio(this.textRequisicao) && DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), codigoFilial, this.textRequisicao.getText());
            if (agruparMultiguia) {
                bui.append("     ,COALESCE(pegacodigomultiguiamae(a.fil_codigo, a.req_codigo), a.req_codigo) as ").append(CODIGO_REQUISICAO_PAI);
            } else {
                bui.append("     ,a.req_codigo as ").append(CODIGO_REQUISICAO_PAI);
            }
            bui.append("       ,a.req_codigo ");
            bui.append("       ,b.pac_codigo ");
            bui.append("       ,a.req_data ");
            bui.append("       ,a.req_hora ");
            bui.append("       ,a.req_dum ");
            bui.append("       ,a.req_obs ");
            bui.append("       ,a.req_peso ");
            bui.append("       ,a.req_altura ");
            bui.append("       ,a.req_anomes ");
            bui.append("       ,a.req_idade ");
            bui.append("       ,b.pac_codigo ");
            bui.append("       ,b.pac_nome ");
            bui.append("       ,b.pac_sexo ");
            bui.append("       ,b.pac_datanasc ");
            bui.append("       ,a.req_totpago ");
            bui.append("       ,a.req_total ");
            bui.append("       ,a.req_deveguia ");
            bui.append("       ,a.med_conselho ");
            bui.append("       ,a.med_crm ");
            bui.append("       ,a.med_uf ");
            bui.append("       ,c.med_nome ");
            bui.append("       ,a.req_dclinicos ");
            bui.append("       ,coalesce(a.req_urgente, false) as req_urgente ");
            bui.append("       ,lotefil.lfi_codigo ");
            bui.append("   from requisicao a ");
            bui.append("   join lotefilialrequisicao lotereq on a.fil_codigo = lotereq.fil_codigo and a.req_codigo = lotereq.req_codigo ");
            bui.append("   join lotefilial lotefil on a.fil_codigo = lotefil.fil_codigo and lotereq.lfi_codigo = lotefil.lfi_codigo ");
            bui.append("   join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            bui.append("   join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf ");
            bui.append("  where a.fil_codigo = ").append(codigoFilial);
            bui.append("    and lotefil.lfi_codigo = ").append(codigoLote);
            bui.append("    and a.req_excluida = false ");
            bui.append("  order by a.fil_codigo ");
            bui.append("          ,a.req_codigo ");
            SQL = bui.toString();
            ResultSet resReq = Conexao.executeQuery(st, SQL);
            ArrayList<String> requisicoesComMaisDeUmLote = new ArrayList<String>();
            while (resReq.next()) {
                Registro reg = new Registro(resReq);
                reg.setValor("req_data", Funcoes.formataData("dd/MM/yyyy", resReq.getDate("req_data")));
                this.adicionarRequisicao(reg, codRecipiente);
                String codigoRequisicao = resReq.getString("req_codigo");
                boolean requisicaoEstaPresenteEmMaisDeUmLote = this.requisicaoService.getNumeroDeLotesParaARequisicao(codigoFilial, codigoRequisicao) > 1;
                if (!requisicaoEstaPresenteEmMaisDeUmLote) continue;
                requisicoesComMaisDeUmLote.add(codigoRequisicao);
            }
            if (!requisicoesComMaisDeUmLote.isEmpty()) {
                StringBuilder mensagem = new StringBuilder();
                mensagem.append("As seguinte requisi\u00e7\u00f5es possuem mais de um lote: \n");
                for (String requisicao : requisicoesComMaisDeUmLote) {
                    mensagem.append(requisicao).append(", ");
                }
                mensagem.delete(mensagem.length() - 2, mensagem.length() - 1);
                Funcoes.mensagem(this.getParent(), mensagem.toString(), 2);
            }
            this.textLote.setEnabled(false);
            this.buttonBuscaLote.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            return false;
        }
        return true;
    }

    public String pegaCodigoLote() {
        DescritorCodigoLote codigoLote = new DescritorCodigoLote(Variaveis.filialPadrao, this.textLote.getText(), null);
        String codigo = StringUtil.removeZerosEsquerda(codigoLote.getCodigoLote().substring(3, codigoLote.getCodigoLote().length()));
        return codigo;
    }

    public String pegaCodigoFilial() {
        String filial = StringUtil.removeZerosEsquerda(this.textLote.getText().substring(0, 2));
        return filial;
    }

    private void adicionarRequisicao(Registro reg, String codRecipiente) {
        this.adicionarRequisicao(reg, null, codRecipiente);
    }

    private void adicionarRequisicao(String requisicao, String filial, String codRecipiente) {
        Integer[] guias = new Integer[]{Integer.parseInt(requisicao)};
        boolean agruparRequisicao = this.possuiAgrupamentoMultiguia(requisicao, filial);
        if (agruparRequisicao) {
            try {
                guias = RecepcaoUtil.verificaMultiGuias(filial, requisicao, true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            requisicao = String.valueOf(guias[0]);
        }
        int linha = this.pegaLinhaRequisicao(requisicao);
        Registro reg = this.objectToReg(linha);
        this.adicionarRequisicao(reg, filial, codRecipiente);
    }

    private boolean possuiAgrupamentoMultiguia(String requisicao, String filial) {
        boolean multiguia = false;
        try {
            multiguia = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, requisicao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return multiguia;
    }

    private void adicionarRequisicao(Registro reg, String filial, String codRecipiente) {
        Statement st;
        if (Funcoes.textoVazio(filial)) {
            filial = reg.getString("fil_codigo");
        }
        if ((st = Conexao.getStatement()) != null) {
            try {
                Integer[] requisicoes = null;
                String requisicao = reg.getString("req_codigo");
                boolean agruparMultiguias = this.possuiAgrupamentoMultiguia(requisicao, filial);
                requisicoes = agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(filial, requisicao, true) : new Integer[]{Integer.parseInt(requisicao)};
                ArrayList<Registro> exames = new ArrayList<Registro>();
                ArrayList<String> examesInserido = new ArrayList<String>();
                ArrayList<Registro> examesNaoExp = new ArrayList<Registro>();
                List<Registro> examesAnteriores = this.modExa.getRegistros();
                for (Integer req : requisicoes) {
                    StringBuilder bui = new StringBuilder("select h.lfi_codigo \n");
                    bui.append("  ,a.exr_descricaomaterial, a.exr_datamaterial, a.exr_volumediurese, cast(a.exr_tempodiurese as varchar) as ext_tempodiurese ");
                    bui.append(" ,a.exr_situacao, (a.exr_datatransportechegada is not null) as ").append(EXA_EXPORTADO);
                    bui.append(" ,b.exa_codigo, b.exa_descricao, a.exr_urgente, a.exr_situacao");
                    bui.append(" ,c.mco_codigo, c.mco_abreviatura, c.mco_solicitarmat, c.mco_descricao");
                    bui.append(" ,e.req_codigo ");
                    bui.append(" ,e.req_codigo as chaveexameagrupado ");
                    if (!Funcoes.textoVazio(codRecipiente)) {
                        bui.append(" ,array_agg(distinct f.rec_codigo)::varchar[] as rec_codigo ");
                        bui.append(" ,case when array_agg(distinct f.rec_codigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] = false then array_agg(distinct f.rec_kodigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("]");
                        bui.append(" \t\telse array_agg(distinct f.rec_codigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] end as etiquetaDigitada ");
                    }
                    bui.append(" from lotefilialexamerequisicao h ");
                    bui.append("left join examerequisicao a on h.fil_codigo =  a.fil_codigo and h.exa_codigo = a.exa_codigo and h.mco_codigo = a.mco_codigo and h.req_codigo = a.req_codigo ");
                    bui.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                    bui.append("left join materialcoleta c   on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
                    bui.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                    bui.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
                    if (!Funcoes.textoVazio(codRecipiente)) {
                        bui.append("left join examerequisicaorecipiente f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.req_codigo = f.req_codigo and a.mco_codigo = f.mco_codigo and f.ere_tipo = '").append("C").append("' ");
                    }
                    bui.append(" where ");
                    bui.append("  a.fil_codigo = ").append(Integer.parseInt(filial));
                    bui.append("  and a.req_codigo = ").append(req.toString());
                    bui.append("  and a.exr_excluido = false ");
                    bui.append(" group by a.exr_codigoapoiado ");
                    bui.append(" ,h.lfi_codigo");
                    bui.append(" ,exr_exportado");
                    bui.append(" ,a.exr_descricaomaterial ");
                    bui.append(" ,a.exr_datamaterial ");
                    bui.append(" ,a.exr_volumediurese ");
                    bui.append(" ,a.exr_situacao ");
                    bui.append(" ,b.exa_codigo ");
                    bui.append(" ,b.exa_descricao ");
                    bui.append(" ,a.exr_urgente ");
                    bui.append(" ,a.exr_situacao ");
                    bui.append(" ,c.mco_codigo ");
                    bui.append(" ,c.mco_abreviatura ");
                    bui.append(" ,c.mco_solicitarmat ");
                    bui.append(" ,c.mco_descricao ");
                    bui.append(" ,a.exr_datamaterial ");
                    bui.append(" ,a.exr_tempodiurese ");
                    bui.append(" ,a.exr_dataloteexterno ");
                    bui.append(" ,a.exr_datatransportesaida ");
                    bui.append(" ,e.req_codigo ");
                    bui.append(" ,a.exr_urgente ");
                    bui.append(" ,d.emc_materialcongelado ");
                    SQL = bui.toString();
                    ResultSet res = Conexao.executeQuery(st, SQL);
                    while (res.next()) {
                        Registro exa = new Registro(res);
                        exa.setValor("req_codigo", new int[]{exa.getInt("req_codigo")});
                        if (exa.getValor("exr_situacao") == null) {
                            exa.setValor("exr_situacao", "");
                        }
                        if (!Funcoes.textoVazio(codRecipiente)) {
                            exa.substituirValor("etiquetadigitada", exa.getBoolean("etiquetadigitada") ? Boolean.TRUE : Boolean.FALSE);
                        } else {
                            exa.setValor("etiquetadigitada", Boolean.FALSE);
                        }
                        String exameMatAtual = exa.getString("exa_codigo").concat(exa.getString("mco_codigo"));
                        for (Registro regAnterior : examesAnteriores) {
                            String exameMatAnterior = regAnterior.getString("exa_codigo").concat(regAnterior.getString("mco_codigo"));
                            int[] reqsExame = (int[])exa.getValor("req_codigo");
                            int[] reqsAnterior = (int[])regAnterior.getValor("req_codigo");
                            for (int reqAux : reqsExame) {
                                boolean isLocalizado = false;
                                for (int reqAuxAnt : reqsAnterior) {
                                    if (reqAux != reqAuxAnt) continue;
                                    isLocalizado = true;
                                    break;
                                }
                                if (!isLocalizado || !exameMatAtual.trim().equals(exameMatAnterior.trim()) || !regAnterior.getBoolean("etiquetadigitada")) continue;
                                exa.substituirValor("etiquetadigitada", Boolean.TRUE);
                            }
                        }
                        if (!examesInserido.contains(exa.getString("exa_codigo").concat(exa.getString("mco_codigo")))) {
                            if (exa.getString("exr_situacao").equals("N") && exa.getString("lfi_codigo").equals(reg.getString("lfi_codigo"))) {
                                exames.add(exa);
                                this.temExameAReceber = true;
                            } else {
                                examesNaoExp.add(exa);
                            }
                            examesInserido.add(exa.getString("exa_codigo").concat(exa.getString("mco_codigo")));
                            continue;
                        }
                        if (!agruparMultiguias) continue;
                        for (int i = 0; i < exames.size(); ++i) {
                            Registro registroExame = (Registro)exames.get(i);
                            String key = registroExame.getString("exa_codigo").concat(registroExame.getString("mco_codigo"));
                            if (!key.equalsIgnoreCase(exameMatAtual)) continue;
                            int[] req_codigo = (int[])registroExame.getValor("req_codigo");
                            registroExame.setValor("req_codigo", ArraysUtil.concatenar(req_codigo, (int[])exa.getValor("req_codigo")));
                            registroExame.setValor("chaveexameagrupado", registroExame.getString("chaveexameagrupado") + "-" + req);
                        }
                    }
                }
                reg.setValor(LISTA_EXAMES, exames);
                reg.setValor(campos[6], examesNaoExp);
                reg.setValor(COLUNA_CHAVE, this.getChave(reg));
                int linha = this.pegaLinhaRequisicao(reg);
                if (linha == -1) {
                    this.modReq.addLine(this.RegToObj(reg));
                    this.atualizarModeloRequisicoes();
                    this.tableReq.setRowSelectionInterval(this.tableReq.getRowCount() - 1, this.tableReq.getRowCount() - 1);
                    this.tableReq.scrollRectToVisible(this.tableReq.getCellRect(this.modReq.getRowCount() - 1, 0, false));
                } else if (!Funcoes.textoVazio(codRecipiente)) {
                    TableUtil.selecionarLinha(this.tableReq, linha);
                    for (int i = 0; i < exames.size(); ++i) {
                        Registro regAux = (Registro)exames.get(i);
                        this.modExa.setValueAt(regAux.getBoolean("etiquetadigitada") ? Boolean.TRUE : Boolean.FALSE, i, 3);
                    }
                }
            }
            catch (SQLException e) {
                Funcoes.mensagem(this, "", 1);
            }
        }
    }

    public int pegaLinhaRequisicao(String requisicao) {
        if (Funcoes.textoVazio(requisicao)) {
            return -1;
        }
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            Object req = this.modReq.getValueAt(i, 1);
            if (requisicao.length() > req.toString().length()) {
                req = Funcoes.preencheZero(req.toString(), ParametrosGerais.getDigitosTuboRequisicao());
            }
            if (!req.toString().trim().equals(requisicao.trim())) continue;
            return i;
        }
        return -1;
    }

    public int pegaLinhaRequisicao(Registro reg) {
        if (reg == null) {
            return -1;
        }
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            int req = (Integer)this.modReq.getValueAt(i, 27);
            if (req != reg.getInt(CODIGO_REQUISICAO_PAI)) continue;
            return i;
        }
        return -1;
    }

    private String getChave(Registro reg) {
        return Funcoes.preencheZero(reg.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()).concat(Funcoes.preencheZero(reg.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()));
    }

    private void buscarRequisicaoAoPerdeFoco() {
        this.filial = Variaveis.filialPadrao;
        String codigoRequisicao = this.textRequisicao.getText();
        String codRecipiente = "";
        if (codigoRequisicao.matches("\\d+")) {
            DescritorCodigoEtiqueta de = DescritorCodigoEtiqueta.getDescritor(codigoRequisicao);
            if (de != null) {
                this.filial = de.getFilial();
                codigoRequisicao = de.getRequisicao();
                codRecipiente = de.getTubo();
                if (this.modReq.getRowCount() > 0) {
                    this.carregarRegistrosModelo(codigoRequisicao);
                }
                this.adicionarRequisicao(codigoRequisicao, this.filial, codRecipiente);
            } else {
                Funcoes.mensagem(this, "Tubo n\u00e3o localizado no lote selecionado.", 2);
            }
            this.atualizarModeloRequisicoes();
            int linha = this.pegaLinhaRequisicao(codigoRequisicao);
            if (linha == -1) {
                linha = this.tableReq.getRowCount() - 1;
            }
            TableUtil.selecionarLinha(this.tableReq, linha);
            this.textRequisicao.setText("");
        }
    }

    private void atualizarModeloRequisicoes() {
        this.modReq.fireTableDataChanged();
        this.buttonSalvar.setEnabled(this.modReq.getRowCount() > 0);
    }

    public void carregarRegistrosModelo(String codigoRequisicao) {
        int linha = Funcoes.textoVazio(codigoRequisicao) ? this.tableReq.getSelectedRow() : this.pegaLinhaRequisicao(codigoRequisicao);
        if (linha != -1) {
            Registro reg = this.objectToReg(linha);
            this.modExa.addRegistros((Collection)reg.getValor(LISTA_EXAMES));
            this.modOutrosExa.addRegistros((Collection)reg.getValor(campos[6]));
            this.modExa.fireTableDataChanged();
            this.modOutrosExa.fireTableDataChanged();
        }
    }

    private Object[] RegToObj(Registro reg) {
        ArrayList<Object> req = new ArrayList<Object>();
        for (String key : campos) {
            req.add(reg.getValor(key));
        }
        return req.toArray();
    }

    static {
        campos = new String[]{"fil_codigo", "req_codigo", "pac_nome", "req_data", LISTA_EXAMES, "listaexamesnaoexportar", "med_nome", "pac_datanasc", "req_idade", "req_peso", "req_totpago", "req_obs", "chave", "pac_codigo", "req_anomes", "med_conselho", "pac_sexo", "req_total", "req_dum", "med_uf", "req_hora", "req_deveguia", "med_crm", "req_altura", "req_dclinicos", "lfi_codigo", "req_urgente", CODIGO_REQUISICAO_PAI};
    }
}

